/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applybill;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.business.rejectbill.RejectBillService;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.EntryTemplateConfig;
import kd.epm.eb.common.utils.StringUtils;

class EntryColumn
implements Serializable {
    private String tabKey = "";
    private String entityName = "";
    private String templateName = "";
    private EntryTemplateConfig entryTemplateConfig;
    private List<BaseColumn> beginFixCols = new ArrayList<BaseColumn>(16);
    private List<BaseColumn> rowDimCols = new ArrayList<BaseColumn>(16);
    private List<BaseColumn> measureCols = new ArrayList<BaseColumn>(16);
    private List<BaseColumn> otherCols = new ArrayList<BaseColumn>(16);
    private List<BaseColumn> endFixCols = new ArrayList<BaseColumn>(16);
    private List<BaseColumn> allCols = new ArrayList<BaseColumn>(128);

    public String getTabKey() {
        return this.tabKey;
    }

    public void setTabKey(String tabKey) {
        this.tabKey = tabKey;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public EntryTemplateConfig getEntryTemplateConfig() {
        return this.entryTemplateConfig;
    }

    public void setEntryTemplateConfig(EntryTemplateConfig entryTemplateConfig) {
        this.entryTemplateConfig = entryTemplateConfig;
    }

    public EntryColumn(List<BaseColumn> baseColumns, String templateName, String entityName) {
        baseColumns = baseColumns.stream().distinct().collect(Collectors.toList());
        this.entityName = entityName;
        String index = entityName.replace("entryentity", "");
        this.templateName = templateName;
        BaseColumn bhCol = new BaseColumn();
        bhCol.setKey("h_bhnumber" + index);
        bhCol.setTitle(ResManager.loadKDString((String)"\u9a73\u56de\u8c03\u6574\u5355\u53f7", (String)"BgRejectBillLogListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.beginFixCols.add(bhCol);
        this.rowDimCols.addAll(baseColumns.stream().filter(t -> StringUtils.isNotEmpty((String)t.getBaseEntityId())).collect(Collectors.toList()));
        this.measureCols.addAll(baseColumns.stream().filter(t -> RejectBillService.getInstance().isBigDecimalCol(t)).collect(Collectors.toList()));
        List measureColKeys = this.measureCols.stream().map(BaseColumn::getKey).collect(Collectors.toList());
        this.otherCols.addAll(baseColumns.stream().filter(t -> !measureColKeys.contains(t.getKey()) && StringUtils.isEmpty((String)t.getBaseEntityId()) && !t.getKey().startsWith("h_rejectstatus") && !t.getKey().startsWith("h_busplan") && !t.getKey().endsWith("_text")).collect(Collectors.toList()));
        for (BaseColumn measureCol : this.measureCols) {
            BaseColumn baseColumn = new BaseColumn();
            baseColumn.setKey(measureCol.getKey() + "_reject_adj" + index);
            baseColumn.setTitle(ResManager.loadResFormat((String)"%1(\u8c03\u6574)", (String)"BgRejectBillLogListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{measureCol.getTitle()}));
            measureCol.setTitle(ResManager.loadResFormat((String)"%1(\u9a73\u56de)", (String)"BgRejectBillLogListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{measureCol.getTitle()}));
            this.endFixCols.add(baseColumn);
        }
        BaseColumn statusCol = new BaseColumn();
        statusCol.setKey("h_status" + index);
        statusCol.setTitle(ResManager.loadKDString((String)"\u72b6\u6001", (String)"BgRejectBillLogListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.endFixCols.add(statusCol);
        this.allCols.addAll(this.beginFixCols);
        this.allCols.addAll(this.rowDimCols);
        this.allCols.addAll(this.measureCols);
        this.allCols.addAll(this.otherCols);
        this.allCols.addAll(this.endFixCols);
    }

    public List<BaseColumn> getAllCols() {
        return this.allCols;
    }

    public void setAllCols(List<BaseColumn> allCols) {
        this.allCols = allCols;
    }

    public List<BaseColumn> getBeginFixCols() {
        return this.beginFixCols;
    }

    public void setBeginFixCols(List<BaseColumn> beginFixCols) {
        this.beginFixCols = beginFixCols;
    }

    public List<BaseColumn> getRowDimCols() {
        return this.rowDimCols;
    }

    public void setRowDimCols(List<BaseColumn> rowDimCols) {
        this.rowDimCols = rowDimCols;
    }

    public List<BaseColumn> getMeasureCols() {
        return this.measureCols;
    }

    public void setMeasureCols(List<BaseColumn> measureCols) {
        this.measureCols = measureCols;
    }

    public List<BaseColumn> getOtherCols() {
        return this.otherCols;
    }

    public void setOtherCols(List<BaseColumn> otherCols) {
        this.otherCols = otherCols;
    }

    public List<BaseColumn> getEndFixCols() {
        return this.endFixCols;
    }

    public void setEndFixCols(List<BaseColumn> endFixCols) {
        this.endFixCols = endFixCols;
    }
}

