/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applybill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.logging.Log;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.applybill.util.ApplyBillPluginUitl;
import kd.epm.eb.business.applybill.util.ApplyTemplateUtils;
import kd.epm.eb.business.applybill.util.BgApplyBillUtils;
import kd.epm.eb.business.centralapproval.ApproveRecordUtil;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.applybill.ApplyBillConstant;
import kd.epm.eb.common.applybill.AuditRecordObj;
import kd.epm.eb.common.applybill.BillFieldStatus;
import kd.epm.eb.common.applybill.ColumnsContext;
import kd.epm.eb.common.applybill.ControlDimMembInfo;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.BgApplyENtryInfo;
import kd.epm.eb.common.applytemplatecolumn.ColumnEnum;
import kd.epm.eb.common.applytemplatecolumn.DataMapDimension;
import kd.epm.eb.common.applytemplatecolumn.EntryTemplateConfig;
import kd.epm.eb.common.applytemplatecolumn.FieldTypeEnum;
import kd.epm.eb.common.applytemplatecolumn.TextColumn;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.centralapproval.AppBillStatusEnum;
import kd.epm.eb.common.centralapproval.CentralAppBillApproveInfo;
import kd.epm.eb.common.centralapproval.CentralAppShowInfo;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.formplugin.applybill.IApplyBill;
import org.apache.commons.lang.StringUtils;

public interface IApAuditBill
extends IApplyBill {
    default public void setAuditTypeBillBtnStatus(BillFieldStatus fieldStatus) {
        fieldStatus.addDisableKeys(new String[]{"applydate", "proposer"});
        fieldStatus.addHideKeys(new String[]{"submit", "unsubmit", "btn_c_view", "btn_viewappbill", "btn_selappbill", "statistics"});
        fieldStatus.addHideKeys(ApplyBillConstant.btns_deleteentry);
        CentralAppShowInfo showInfo = this.getCentralAppShowInfo();
        if (showInfo.getStatus().equals("D") || showInfo.getStatus().equals("F") || "notApprove".equals(showInfo.getBillShowStatus())) {
            fieldStatus.addDisableKeys(ApplyBillConstant.btns_saveentity);
            fieldStatus.addHideKeys(new String[]{"save"});
            fieldStatus.addDisableKeys(ApplyBillConstant.btns_newentry);
            fieldStatus.addDisableKeys(ApplyBillConstant.entry_entryentity);
            fieldStatus.addDisableKeys(new String[]{"flexpanelap"});
        }
        if ("notApprove".equals(showInfo.getBillShowStatus())) {
            fieldStatus.addHideKeys(ApplyBillConstant.btns_rejectrow);
            fieldStatus.addHideKeys(new String[]{"btn_viewreject"});
            fieldStatus.addHideKeys(new String[]{"viewrejectlogpanel", "sourcebill"});
            fieldStatus.addHideKeys(ApplyBillConstant.btns_viewattachment);
            fieldStatus.addDisableKeys(new String[]{"attachmentpanelap"});
        } else {
            fieldStatus.addEnableKeys(new String[]{"attachmentpanelap"});
            fieldStatus.addShowKeys(new String[]{"btn_viewreject"});
            fieldStatus.addShowKeys(new String[]{"viewrejectlogpanel", "sourcebill"});
            fieldStatus.addShowKeys(ApplyBillConstant.btns_viewattachment);
        }
        CentralAppShowInfo centralAppShowInfo = this.getCentralAppShowInfo();
        if (centralAppShowInfo != null) {
            String status = centralAppShowInfo.getStatus();
            if (AppBillStatusEnum.AUDITFAIL.getNumber().equals(status)) {
                fieldStatus.addShowKeys(new String[]{"submit"});
            }
        }
    }

    @Override
    default public void afterModifColumnCellChange(String entityKey, Object newValue, Object oldValue, Long currentRowId, String columnKey, int rowIndex) {
        BgApplyBillUtils.getInstance().setOneAdjustedColumnColor(this.getView(), entityKey, rowIndex, columnKey);
    }

    default public void dealDisableDimMemb(BillFieldStatus fieldStatus, BgApplyENtryInfo entryInfo) {
        Map<String, ControlDimMembInfo> controlMembInfo = this.getOrCacheRowDimContrlMemb(null);
        BgApplyBillUtils applyBillUtils = BgApplyBillUtils.getInstance();
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        entryInfo.getEntryTemplateConfig().forEach((entryKey, tempConfig) -> {
            if (!applyBillUtils.isBizEntry(entryKey)) {
                Map hiddenDimMemMap = tempConfig.getHiddenDimMemMap();
                for (Map.Entry dimMembEntry : hiddenDimMemMap.entrySet()) {
                    ControlDimMembInfo controlDimMembInfo;
                    List controlMembIds;
                    String dimNum = (String)dimMembEntry.getKey();
                    Long membId = (Long)dimMembEntry.getValue();
                    if (!this.isLock(membId, controlMembIds = (controlDimMembInfo = (ControlDimMembInfo)controlMembInfo.get(dimNum)) == null ? null : controlDimMembInfo.getCtrlDimMembers())) continue;
                    fieldStatus.addDisableKeys(new String[]{entryKey});
                    return;
                }
                block1: for (BaseColumn column : tempConfig.getEntryColumns()) {
                    List colDimColumnMembInfo = ApplyTemplateUtils.getColDimColumnMembInfo((BaseColumn)column);
                    if (colDimColumnMembInfo == null) continue;
                    for (DataMapDimension dimMembInfo : colDimColumnMembInfo) {
                        List controlMembIds;
                        long dimId = dimMembInfo.getDimensionId();
                        long membId = dimMembInfo.getDimensionRememberId();
                        String dimNum = dimMembInfo.getDimNum();
                        Dimension dimension = modelCacheHelper.getDimension(Long.valueOf(dimId));
                        if (dimension == null) continue;
                        ControlDimMembInfo controlDimMembInfo = (ControlDimMembInfo)controlMembInfo.get(dimension.getNumber());
                        List list = controlMembIds = controlDimMembInfo == null ? null : controlDimMembInfo.getCtrlDimMembers();
                        if (!this.isLock(membId, controlMembIds)) continue;
                        fieldStatus.addColumnDisableKeys(new String[]{column.getKey()});
                        continue block1;
                    }
                }
                List<Integer> toLockRow = this.getLockRowIndex(null, (EntryTemplateConfig)tempConfig, (String)entryKey, controlMembInfo);
                if (toLockRow.size() > 0) {
                    Set rowIndex = fieldStatus.getDisableRowIndex().computeIfAbsent(entryKey, key -> new HashSet(16));
                    rowIndex.addAll(toLockRow);
                }
            }
        });
    }

    default public void initAdjustRecord(CentralAppShowInfo centralAppShowInfo, BgApplyENtryInfo bgApplyENtryInfo) {
        HashSet refBillNumbs = new HashSet(16);
        if (centralAppShowInfo.getRefedBillNos() != null) {
            refBillNumbs.addAll(centralAppShowInfo.getRefedBillNos());
        }
        if (centralAppShowInfo.getReportBillNos() != null) {
            refBillNumbs.addAll(centralAppShowInfo.getReportBillNos());
        }
        Set centralAppChainsBillSet = CentralAppBillService.getInstance().getCentralAppChainsBillSet(centralAppShowInfo.getCentralAppChain());
        refBillNumbs.addAll(centralAppChainsBillSet);
        refBillNumbs.remove("");
        QFilter qFilter = new QFilter("approvebillno", "in", refBillNumbs);
        if (refBillNumbs.size() > 0) {
            for (String refBillNumb : refBillNumbs) {
                qFilter.or("approvebillno", "like", (Object)(refBillNumb + "%"));
            }
        }
        List appAdjustRecords = ApproveRecordUtil.getInstance().getAppAdjustRecords(qFilter);
        HashMap allTempConfig = new HashMap(16);
        HashMap tempIdMapEntryKey = new HashMap(16);
        bgApplyENtryInfo.getEntryTemplateConfig().forEach((entityKey, tempConfig) -> {
            if (!BgApplyBillUtils.getInstance().isBizEntry(entityKey)) {
                allTempConfig.put(tempConfig.getTemplateID(), tempConfig);
                tempIdMapEntryKey.put(tempConfig.getTemplateID(), entityKey);
            }
        });
        Map adjustedColumn = ApplyBillPluginUitl.selectAdjustColumn((List)appAdjustRecords, allTempConfig, tempIdMapEntryKey);
        this.getOrCacheAdjustedColumn(adjustedColumn);
    }

    default public Map<String, Map<String, Set<String>>> getOrCacheAdjustedColumn(Map<String, Map<String, Set<String>>> adjustedColumn) {
        if (adjustedColumn == null) {
            String cacheStr = this.getCacheOfPage().get("AdjustedColumn");
            adjustedColumn = StringUtils.isNotEmpty((String)cacheStr) ? (HashMap)SerializationUtils.deSerializeFromBase64((String)cacheStr) : new HashMap(16);
        } else {
            this.getCacheOfPage().put("AdjustedColumn", SerializationUtils.serializeToBase64(adjustedColumn));
        }
        return adjustedColumn;
    }

    default public void setAdjustedColumnSign(BgApplyENtryInfo bgApplyENtryInfo) {
        bgApplyENtryInfo.getEntryTemplateConfig().forEach((entryKey, tempInfo) -> {
            if (!BgApplyBillUtils.getInstance().isBizEntry(entryKey)) {
                int rowCount = this.getDataModel().getEntryRowCount(entryKey);
                List rowsIndex = CommonServiceHelper.buildIntArrays((int)rowCount);
                this.setAdjustedColumnSign((String)entryKey, (EntryTemplateConfig)tempInfo, rowsIndex);
            }
        });
    }

    default public void setAdjustedColumnSign(String entityKey, EntryTemplateConfig tempConfig, List<Integer> rowIndex) {
        Map<String, Set<String>> adjustedColumn = this.getOrCacheAdjustedColumn(null).get(entityKey);
        Map<Long, Map<String, Object>> currentChangedColumns = this.getOrCacheColumnInitData(null).get(entityKey);
        if (adjustedColumn != null || currentChangedColumns != null) {
            DynamicObjectCollection entityDatas = this.getDataModel().getEntryEntity(entityKey);
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entityKey);
            this.setAdjustedColumnSign(entryGrid, entityDatas, adjustedColumn, currentChangedColumns, tempConfig, rowIndex);
        }
    }

    default public void setAdjustedColumnSign(EntryGrid entryGrid, DynamicObjectCollection allEntityDatas, Map<String, Set<String>> adjustedColumn, Map<Long, Map<String, Object>> currentChangedColumns, EntryTemplateConfig tempConfig, List<Integer> rowIndex) {
        if (allEntityDatas.size() > 0 && entryGrid != null) {
            StringBuilder sb = new StringBuilder(16);
            ArrayList<CellStyle> cellStyleList = new ArrayList<CellStyle>(16);
            HashSet<String> columnKeys = new HashSet<String>(16);
            BgApplyBillUtils bgApplyBillUtils = BgApplyBillUtils.getInstance();
            for (Integer index : rowIndex) {
                Long rowId;
                Map<String, Object> kvs;
                String membStr;
                Set<String> keys;
                columnKeys.clear();
                DynamicObject row = (DynamicObject)allEntityDatas.get(index.intValue());
                if (adjustedColumn != null && (keys = adjustedColumn.get(membStr = ApplyBillPluginUitl.selectDimMembIdStr((StringBuilder)sb, (DynamicObject)row, (List)tempConfig.getDimKeysList()))) != null) {
                    columnKeys.addAll(keys);
                }
                if (currentChangedColumns != null && (kvs = currentChangedColumns.get(rowId = Long.valueOf(row.getLong("id")))) != null) {
                    columnKeys.addAll(kvs.keySet());
                }
                if (columnKeys.size() <= 0) continue;
                for (String field : columnKeys) {
                    CellStyle cellStyle = bgApplyBillUtils.createCellStype(field, index.intValue());
                    cellStyleList.add(cellStyle);
                }
            }
            if (!cellStyleList.isEmpty()) {
                entryGrid.setCellStyle(cellStyleList);
            }
        }
    }

    default public List<Integer> getLockRowIndex(List<Integer> rowNums, EntryTemplateConfig tempConfig, String entryKey, Map<String, ControlDimMembInfo> rowDimContrlMembs) {
        DynamicObjectCollection entityDatas = this.getDataModel().getEntryEntity(entryKey);
        ArrayList<Integer> toLockRow = new ArrayList<Integer>(16);
        if (!entityDatas.isEmpty()) {
            Map columnMapDimNum = tempConfig.selectColumnMapDimNum();
            if (rowNums == null) {
                rowNums = CommonServiceHelper.buildIntArrays((int)entityDatas.size());
            }
            block0: for (int rowIndex : rowNums) {
                DynamicObject rowObj = (DynamicObject)entityDatas.get(rowIndex);
                for (String dimColumnKey : tempConfig.getDimKeysList()) {
                    String subtotalKey;
                    boolean subtotal;
                    String dimNum = (String)columnMapDimNum.get(dimColumnKey);
                    ControlDimMembInfo controlDimMembInfo = rowDimContrlMembs.get(dimNum);
                    List controlMembIds = controlDimMembInfo == null ? null : controlDimMembInfo.getCtrlDimMembers();
                    DynamicObject membObj = rowObj.getDynamicObject(dimColumnKey);
                    boolean isLock = false;
                    if (controlDimMembInfo == null || !controlDimMembInfo.isHasAuditDimSeting()) {
                        isLock = this.isLockNotDetail(tempConfig, entryKey, dimNum, dimColumnKey, rowObj);
                    }
                    if (!isLock) {
                        isLock = this.isLock(controlMembIds, membObj);
                    }
                    if (!BgApplyBillUtils.getInstance().isBizEntry(entryKey) && (subtotal = rowObj.getBoolean(subtotalKey = tempConfig.getSubtotalKey())) && isLock) {
                        isLock = false;
                    }
                    if (!isLock) continue;
                    toLockRow.add(rowIndex);
                    continue block0;
                }
            }
        }
        return toLockRow;
    }

    default public boolean isLockNotDetail(EntryTemplateConfig templateConfig, String entryKey, String dimNum, String dimKey, DynamicObject rowObj) {
        return false;
    }

    default public boolean isLock(List<Pair<Boolean, Set<Long>>> controlMembIds, DynamicObject membObj) {
        boolean result = false;
        if (membObj == null) {
            result = true;
        } else if (controlMembIds != null) {
            Long membId = membObj.getLong("id");
            result = this.isLock(membId, controlMembIds);
        }
        return result;
    }

    default public boolean isLock(Long membId, List<Pair<Boolean, Set<Long>>> controlMembIds) {
        boolean result = false;
        if (controlMembIds != null) {
            for (Pair<Boolean, Set<Long>> controlInfo : controlMembIds) {
                if ((!((Boolean)controlInfo.p1).booleanValue() || ((Set)controlInfo.p2).contains(membId)) && (((Boolean)controlInfo.p1).booleanValue() || !((Set)controlInfo.p2).contains(membId))) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    default public void saveAuditRecord(BgApplyENtryInfo eNtryInfo, Map<String, List<AuditRecordObj>> allAuditRecord, IModelCacheHelper modelCacheHelper, FormShowParameter parameter) {
        if (allAuditRecord.size() > 0) {
            HashMap hideDimMap = new HashMap(16);
            HashMap colDimMap = new HashMap(16);
            ApplyTemplateUtils.selectDimMembInfoOnTemp((BgApplyENtryInfo)eNtryInfo, hideDimMap, colDimMap, (IModelCacheHelper)modelCacheHelper);
            ArrayList recordObjs = new ArrayList(16);
            CentralAppShowInfo centralAppShowInfo = this.getCentralAppShowInfo();
            allAuditRecord.values().forEach(recordObjs::addAll);
            String curNodeNumber = "";
            String curNodeName = "";
            if (parameter != null) {
                curNodeNumber = (String)parameter.getCustomParam("approveNodeNumber");
                curNodeName = (String)parameter.getCustomParam("approveNodeName");
            }
            ApproveRecordUtil.getInstance().saveAdjustRecord(recordObjs, hideDimMap, colDimMap, centralAppShowInfo.getCurPlans(), centralAppShowInfo.getCurCentralScheme(), this.getModelId(), this.getBillNumber(), "1", null, curNodeNumber, curNodeName);
        }
    }

    @Override
    default public CentralAppShowInfo getCentralAppShowInfo() {
        String cacheStr = (String)this.getView().getFormShowParameter().getCustomParam("applyAuditParam");
        if (StringUtils.isEmpty((String)cacheStr)) {
            cacheStr = this.getCacheOfPage().get("applyAuditParam");
        }
        if (StringUtils.isNotEmpty((String)cacheStr)) {
            return (CentralAppShowInfo)SerializationUtils.fromJsonString((String)cacheStr, CentralAppShowInfo.class);
        }
        return new CentralAppShowInfo();
    }

    default public void cacheCentralAppShowInfo(CentralAppShowInfo appShowInfo) {
        this.getCacheOfPage().put(SerializationUtils.toJsonString((Object)appShowInfo), "applyAuditParam");
    }

    default public void addAuditCustomColumn(ColumnsContext columnsContext) {
        List mainColumns = columnsContext.getMainColumns();
        TextColumn rejectStatus = new TextColumn();
        String rejectKey = ApplyTemplateUtils.FIELD_REJECT_STATUS + columnsContext.getEntitySeq() + "_text";
        rejectStatus.setKey(rejectKey);
        rejectStatus.setCategory("h");
        rejectStatus.setEnable(false);
        rejectStatus.setTitle(ResManager.loadKDString((String)"\u9a73\u56de\u72b6\u6001", (String)"BgApplyBillPlugin_48", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        rejectStatus.setType(ColumnEnum.Text);
        rejectStatus.setFieldtype(FieldTypeEnum.TextField);
        rejectStatus.setIgnoreDB(true);
        mainColumns.add(rejectStatus);
    }

    default public void selectRowDimEnableMemb(CentralAppShowInfo showInfo) {
        Set mutexEntity;
        Set mutexAccount;
        List membControlInfo;
        ControlDimMembInfo controlDimMembInfo;
        Map appDimMemLevel = showInfo.getAppDimMemLevel();
        HashMap<String, ControlDimMembInfo> membInfo = new HashMap<String, ControlDimMembInfo>(16);
        appDimMemLevel.forEach((dimNum, membIds) -> {
            ControlDimMembInfo controlDimMembInfo = new ControlDimMembInfo();
            ArrayList<Pair> membControlInfo = new ArrayList<Pair>(2);
            membControlInfo.add(new Pair((Object)Boolean.TRUE, membIds));
            controlDimMembInfo.setCtrlDimMembers(membControlInfo);
            controlDimMembInfo.setHasAuditDimSeting(true);
            membInfo.put((String)dimNum, controlDimMembInfo);
        });
        Set<String> logSignsFromForm = this.getLogSignsFromForm();
        if (logSignsFromForm != null && logSignsFromForm.contains("logappDimMemLevel")) {
            CommonServiceHelper.handleLog((Log)this.getLog(), (String)"logappDimMemLevel", (String)SerializationUtils.toJsonString(membInfo));
        }
        Long modelId = this.getModelId();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Long bizModel = showInfo.getBizModel();
        Map viewsByBusModel = modelCacheHelper.getViewsByBusModel(bizModel);
        Member acountRootMemb = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), (Long)viewsByBusModel.get(SysDimensionEnum.Account.getNumber()), SysDimensionEnum.Account.getNumber());
        Member entityRootMemb = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), (Long)viewsByBusModel.get(SysDimensionEnum.Entity.getNumber()), SysDimensionEnum.Entity.getNumber());
        Pair accountContrlMembs = BgApplyBillUtils.getInstance().getControlMembIds(acountRootMemb, showInfo.getAccountSet());
        Pair entityContrlMembs = BgApplyBillUtils.getInstance().getControlMembIds(entityRootMemb, showInfo.getEntitySet());
        if (logSignsFromForm != null && logSignsFromForm.contains("logaccountContrlMembs")) {
            CommonServiceHelper.handleLog((Log)this.getLog(), (String)"logaccountContrlMembs", (String)SerializationUtils.toJsonString((Object)accountContrlMembs));
        }
        if (logSignsFromForm != null && logSignsFromForm.contains("logentityContrlMembs")) {
            CommonServiceHelper.handleLog((Log)this.getLog(), (String)"entityContrlMembs", (String)SerializationUtils.toJsonString((Object)entityContrlMembs));
        }
        if (accountContrlMembs != null) {
            controlDimMembInfo = membInfo.computeIfAbsent(SysDimensionEnum.Account.getNumber(), key -> new ControlDimMembInfo());
            membControlInfo = controlDimMembInfo.getCtrlDimMembers();
            membControlInfo.add(accountContrlMembs);
        }
        if (entityContrlMembs != null) {
            controlDimMembInfo = membInfo.computeIfAbsent(SysDimensionEnum.Entity.getNumber(), key -> new ControlDimMembInfo());
            membControlInfo = controlDimMembInfo.getCtrlDimMembers();
            membControlInfo.add(entityContrlMembs);
        }
        if ((mutexAccount = showInfo.getMutexAccount()).size() > 0) {
            Set membsAncestor = BgApplyBillUtils.getInstance().getMembsAncestor(mutexAccount, SysDimensionEnum.Account.getNumber(), modelCacheHelper, (Long)viewsByBusModel.get(SysDimensionEnum.Account.getNumber()));
            ControlDimMembInfo controlDimMembInfo2 = membInfo.computeIfAbsent(SysDimensionEnum.Account.getNumber(), key -> new ControlDimMembInfo());
            controlDimMembInfo2.getCtrlDimMembers().add(new Pair((Object)Boolean.FALSE, (Object)membsAncestor));
        }
        if ((mutexEntity = showInfo.getMutexEntity()).size() > 0) {
            Set membsAncestor = BgApplyBillUtils.getInstance().getMembsAncestor(mutexEntity, SysDimensionEnum.Entity.getNumber(), modelCacheHelper, (Long)viewsByBusModel.get(SysDimensionEnum.Entity.getNumber()));
            ControlDimMembInfo controlDimMembInfo3 = membInfo.computeIfAbsent(SysDimensionEnum.Entity.getNumber(), key -> new ControlDimMembInfo());
            controlDimMembInfo3.getCtrlDimMembers().add(new Pair((Object)Boolean.FALSE, (Object)membsAncestor));
        }
        this.getOrCacheRowDimContrlMemb(membInfo);
    }

    default public Map<String, ControlDimMembInfo> getOrCacheRowDimContrlMemb(Map<String, ControlDimMembInfo> membInfo) {
        if (membInfo == null) {
            String cache = this.getCacheOfPage().get("RowDimEnableMemb");
            if (StringUtils.isNotEmpty((String)cache)) {
                membInfo = (Map)SerializationUtils.deSerializeFromBase64((String)cache);
            }
        } else {
            this.getCacheOfPage().put("RowDimEnableMemb", SerializationUtils.serializeToBase64(membInfo));
        }
        return membInfo;
    }

    default public void setAuditTypeBillBaseInfo() {
        DynamicObject query;
        CentralAppShowInfo config = this.getCentralAppShowInfo();
        CentralAppBillApproveInfo approveInfo = config.getApproveInfo();
        IDataModel dataModel = this.getDataModel();
        dataModel.setValue("modifier", (Object)approveInfo.getModifier());
        dataModel.setValue("modifydate", (Object)approveInfo.getModifyDate());
        dataModel.setValue("auditor", (Object)approveInfo.getApprover());
        dataModel.setValue("auditdate", (Object)approveInfo.getApproveDate());
        dataModel.setValue("creater", (Object)approveInfo.getCreator());
        dataModel.setValue("createdate", (Object)approveInfo.getCreateDate());
        if (!config.getReportBillNos().isEmpty() && (query = QueryServiceHelper.queryOne((String)"eb_bgapplybill", (String)"id, org,year,applydate,proposer", (QFilter[])new QFilter[]{new QFilter("billnumber", "=", config.getReportBillNos().toArray()[0])})) != null) {
            dataModel.setValue("year", (Object)query.getLong("year"));
            dataModel.setValue("org", (Object)query.getLong("org"));
            dataModel.setValue("applydate", (Object)query.getDate("applydate"));
            dataModel.setValue("proposer", (Object)query.getLong("proposer"));
        }
    }

    default public Long getCenBillId() {
        Object billno = this.getView().getModel().getValue("billnumber");
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        filter.and("billno", "=", billno);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"eb_centralappbill", (String)"id", (QFilter[])filter.toArray());
        return obj == null ? 0L : obj.getLong("id");
    }

    @Override
    default public void deleteAttachment() {
        List<Map<String, Object>> removeAttachUidList = this.getRemoveAttachmentList();
        for (Map<String, Object> map : removeAttachUidList) {
            AttachmentServiceHelper.remove((String)map.get("entityNum").toString(), (Object)map.get("billPkId"), (Object)map.get("uid"));
        }
    }

    @Override
    default public void setBillId() {
        this.getView().getModel().setValue("id", (Object)this.getBillId());
    }
}

