/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applybill;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.epm.eb.common.applybill.DimensionColumnObj;
import kd.epm.eb.common.utils.StringUtils;

public class PreSplitDimSetingPlugin
extends AbstractFormPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("moveentryup".equals(operateKey)) {
            this.checkUp(args);
        } else if ("moveentrydown".equals(operateKey)) {
            this.checkDown(args);
        }
    }

    public void checkDown(BeforeDoOperationEventArgs args) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        String dimNum = (String)this.getModel().getValue("dimnumber", selectRows[0]);
        Set<String> lockNums = this.getLockNums();
        if (lockNums.contains(dimNum)) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u4e0b\u79fb\u3002", (String)"PreSplitDimSetingPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public void checkUp(BeforeDoOperationEventArgs args) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        int index = selectRows[0];
        if (index > 0) {
            String dimNum = (String)this.getModel().getValue("dimnumber", index - 1);
            Set<String> lockNums = this.getLockNums();
            if (lockNums.contains(dimNum)) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u4e0a\u79fb\u3002", (String)"PreSplitDimSetingPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_confirm"});
    }

    public void afterCreateNewData(EventObject e) {
        List<DimensionColumnObj> dimColInfoFromForm = this.getDimColInfoFromForm();
        HashSet<String> lockNums = new HashSet<String>(16);
        if (dimColInfoFromForm != null && dimColInfoFromForm.size() > 0) {
            this.getModel().deleteEntryData("entryentity");
            this.getModel().batchCreateNewEntryRow("entryentity", dimColInfoFromForm.size());
            for (int i = 0; i < dimColInfoFromForm.size(); ++i) {
                DimensionColumnObj dimensionColumnObj = dimColInfoFromForm.get(i);
                this.getModel().setValue("dimnumber", (Object)dimensionColumnObj.getDimNumber(), i);
                this.getModel().setValue("dimname", (Object)dimensionColumnObj.getDimName(), i);
                this.getModel().setValue("coltitle", (Object)dimensionColumnObj.getColName(), i);
                if (!dimensionColumnObj.isLock()) continue;
                lockNums.add(dimensionColumnObj.getDimNumber());
            }
        }
        this.getPageCache().put("lockNums", SerializationUtils.toJsonString(lockNums));
    }

    private Set<String> getLockNums() {
        String cacheStr = this.getPageCache().get("lockNums");
        if (StringUtils.isNotEmpty((String)cacheStr)) {
            return (Set)SerializationUtils.fromJsonString((String)cacheStr, Set.class);
        }
        return new HashSet<String>(16);
    }

    private List<DimensionColumnObj> getDimColInfoFromForm() {
        String paramStr = (String)this.getView().getFormShowParameter().getCustomParam("dimColumnInfo");
        if (StringUtils.isNotEmpty((String)paramStr)) {
            return SerializationUtils.fromJsonStringToList((String)paramStr, DimensionColumnObj.class);
        }
        return null;
    }

    public void click(EventObject evt) {
        super.click(evt);
        String itemKey = ((Control)evt.getSource()).getKey();
        if ("btn_confirm".equals(itemKey)) {
            List<DimensionColumnObj> dimColInfoFromForm = this.getDimColInfoFromForm();
            if (dimColInfoFromForm == null) {
                return;
            }
            Map<String, DimensionColumnObj> columnObjMap = dimColInfoFromForm.stream().collect(Collectors.toMap(DimensionColumnObj::getDimNumber, d -> d));
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            ArrayList<DimensionColumnObj> newColumnList = new ArrayList<DimensionColumnObj>(entryEntity.size());
            for (DynamicObject row : entryEntity) {
                String dimNum = row.getString("dimnumber");
                DimensionColumnObj dimensionColumnObj = columnObjMap.get(dimNum);
                newColumnList.add(dimensionColumnObj);
            }
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(newColumnList));
            this.getView().close();
        }
    }
}

