/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applybill;

import java.util.EventObject;
import java.util.List;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.applybill.ApplyBillType;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.model.permission.MemberPermHelper;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.commons.lang3.StringUtils;

public class RejectBillListPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final String MODEL_KEY = "model";
    private static final String BILLLIST_KEY = "billlistap";

    public void afterCreateNewData(EventObject e) {
        Long model = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)MODEL_KEY, (boolean)false);
        if (IDUtils.isNull((Long)model)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"RejectUserEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue(MODEL_KEY, (Object)model);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("btn_refresh".equals(itemKey)) {
            this.refreshBillList();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (MODEL_KEY.equals(key)) {
            DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL_KEY);
            if (model != null) {
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)model.getLong("id"));
            }
            this.refreshBillList();
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        int statusVal;
        BillShowParameter billShowParameter = e.getParameter();
        if (billShowParameter instanceof BaseShowParameter && (statusVal = billShowParameter.getBillStatusValue().intValue()) == BillOperationStatus.ADDNEW.getValue()) {
            billShowParameter.setCustomParam("modelId", (Object)this.getModelId());
        }
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getControl(BILLLIST_KEY);
        billList.clearSelection();
        billList.refresh();
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if (StringUtils.equals((CharSequence)"billnumber", (CharSequence)fieldName)) {
            args.setCancel(true);
            IFormView parentView = this.getView().getParentView();
            Object objId = this.getFocusRowPkId();
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)objId, (String)"eb_bgapplybill");
            BaseShowParameter baseShowParameter = new BaseShowParameter();
            baseShowParameter.setFormId("eb_bgapplybill");
            baseShowParameter.setCustomParam("pkId", objId);
            baseShowParameter.setCustomParam("schemeId", (Object)dynamicObject.getLong("applyscheme.id"));
            baseShowParameter.setCustomParam("orgId", (Object)dynamicObject.getLong("org.id"));
            baseShowParameter.setCustomParam("modelId", (Object)this.getModelId());
            baseShowParameter.setCustomParam("bill_type", (Object)dynamicObject.getString("billtype"));
            baseShowParameter.setCustomParam("billnumber", (Object)dynamicObject.getString("billnumber"));
            String billtype = dynamicObject.getString("billtype");
            if (StringUtils.equals((CharSequence)billtype, (CharSequence)ApplyBillType.APPLYREJECT.getNumber())) {
                baseShowParameter.setCaption(ApplyBillType.APPLYREJECT.getName());
                baseShowParameter.addCustPlugin(ApplyBillType.APPLYREJECT.getBillPlugin());
            } else if (StringUtils.equals((CharSequence)billtype, (CharSequence)ApplyBillType.COLLECTREJECT.getNumber())) {
                baseShowParameter.setCaption(ApplyBillType.COLLECTREJECT.getName());
                baseShowParameter.addCustPlugin(ApplyBillType.COLLECTREJECT.getBillPlugin());
            } else if (StringUtils.equals((CharSequence)billtype, (CharSequence)ApplyBillType.REJECT.getNumber())) {
                baseShowParameter.setCaption(ApplyBillType.REJECT.getName());
                baseShowParameter.addCustPlugin(ApplyBillType.REJECT.getBillPlugin());
            } else {
                throw new KDBizException(ResManager.loadResFormat((String)"\u6b64\u9a73\u56de\u5355\u7c7b\u578b\u4e3a\uff1a%1 \u4e0d\u662f\u7533\u62a5\u9a73\u56de\u5355\u4e5f\u4e0d\u662f\u6c47\u603b\u9a73\u56de\u5355\u3002", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[]{billtype}));
            }
            baseShowParameter.setPkId(objId);
            baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            String billStatus = dynamicObject.getString("billstatus");
            baseShowParameter.setStatus(OperationStatus.EDIT);
            Long proposer = dynamicObject.getLong("proposer.id");
            Long userId = this.getUserId();
            long modelId = this.getModelId();
            if ("C".equals(billStatus) || !proposer.equals(userId) && !MemberPermHelper.isModelManager((Long)modelId)) {
                baseShowParameter.setStatus(OperationStatus.VIEW);
            } else {
                baseShowParameter.setStatus(OperationStatus.EDIT);
            }
            baseShowParameter.setPageId(this.getView().getPageId() + objId.toString());
            if (parentView == null) {
                baseShowParameter.setParentPageId(this.getView().getPageId());
                baseShowParameter.setParentFormId(this.getView().getEntityId());
                this.getView().showForm((FormShowParameter)baseShowParameter);
            } else {
                baseShowParameter.setParentPageId(parentView.getPageId());
                baseShowParameter.setParentFormId(parentView.getEntityId());
                parentView.showForm((FormShowParameter)baseShowParameter);
                this.getView().sendFormAction(parentView);
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        long modelId = this.getModelId();
        qFilters.add(new QFilter(MODEL_KEY, "=", (Object)modelId));
        Long userId = this.getUserId();
        if (!MemberPermHelper.isModelManager((Long)modelId)) {
            qFilters.add(new QFilter("proposer.id", "=", (Object)userId).or("creater.id", "=", (Object)userId));
        }
    }

    @Override
    public Long getModelId() {
        DynamicObject modelObj = (DynamicObject)this.getModel().getValue(MODEL_KEY);
        if (modelObj != null) {
            return modelObj.getLong("id");
        }
        return 0L;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }
}

