/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applybill;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.epm.eb.business.rejectbill.entity.RejectMember;
import kd.epm.eb.business.utils.CustomF7utils;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.entity.memberF7.RangeF7Param;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import org.apache.commons.lang3.StringUtils;

public class RejectUserEditPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener {
    private static final String MODEL_KEY = "model";
    private static final String ENTITYTEXT_KEY = "entitiytext";
    private static final String ACCOUNTTEXT_KEY = "accounttext";
    private static final String MEMBERJSON_KEY = "memberjson";
    private static final String REJECTUSER_KEY = "rejectuser";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        super.addClickListeners(new String[]{ENTITYTEXT_KEY, ACCOUNTTEXT_KEY});
    }

    public void afterCreateNewData(EventObject e) {
        Long id = (Long)this.getModel().getValue("id");
        if (id != null && id > 0L) {
            String rejectMemberJson = (String)this.getModel().getValue(MEMBERJSON_KEY);
            List rejectMembers = JSON.parseArray((String)rejectMemberJson, RejectMember.class);
            Map<String, List<RejectMember>> dimMemberScope = rejectMembers.stream().collect(Collectors.groupingBy(RejectMember::getDimNumber));
            List<RejectMember> entityMembers = dimMemberScope.get(SysDimensionEnum.Entity.getNumber());
            this.getModel().setValue(ENTITYTEXT_KEY, (Object)this.getMemberTxt(entityMembers));
            List<RejectMember> accMembers = dimMemberScope.get(SysDimensionEnum.Account.getNumber());
            this.getModel().setValue(ACCOUNTTEXT_KEY, (Object)this.getMemberTxt(accMembers));
        } else {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Object modelId = formShowParameter.getCustomParam("modelId");
            if (IDUtils.isEmptyLong((Long)IDUtils.toLong((Object)modelId)).booleanValue()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"", (String)"", (Object[])new Object[0]));
            }
            this.getModel().setValue(MODEL_KEY, modelId);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "entitiytext": {
                this.openMemberF7(SysDimensionEnum.Entity.getNumber(), key);
                break;
            }
            case "accounttext": {
                this.openMemberF7(SysDimensionEnum.Account.getNumber(), key);
                break;
            }
        }
    }

    private void openMemberF7(String dimNumber, String key) {
        RangeF7Param f7Param = new RangeF7Param();
        f7Param.setShowView(false);
        String rejectMemberJson = (String)this.getModel().getValue(MEMBERJSON_KEY);
        ArrayList rejectMembers = StringUtils.isBlank((CharSequence)rejectMemberJson) ? new ArrayList(10) : JSON.parseArray((String)rejectMemberJson, RejectMember.class);
        ArrayList conList = new ArrayList();
        rejectMembers.stream().filter(e -> e.getDimNumber().equals(SysDimensionEnum.getEnumByNumber((String)dimNumber).getNumber())).forEach(e -> conList.add(new MemberCondition(e.getMemberNumber(), e.getMemberName(), "", e.getMemberRange() + "")));
        f7Param.setCon_list(conList);
        f7Param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        f7Param.setNeedPermCheck(false);
        CustomF7utils.openCustomF7Range((Long)this.getModelId(), (String)dimNumber, (Long)0L, (IFormView)this.getView(), (RangeF7Param)f7Param);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object rejectuser;
        String operation;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof FormOperate && "save".equals(operation = ((FormOperate)args.getSource()).getOperateKey()) && (rejectuser = this.getValue(REJECTUSER_KEY, null)) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u9a73\u56de\u8c03\u6574\u4eba\u3002", (String)"RejectUserEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String key;
        super.closedCallBack(closedCallBackEvent);
        switch (key = closedCallBackEvent.getActionId()) {
            case "entitiytext": {
                DynamicObjectCollection entityRows = (DynamicObjectCollection)closedCallBackEvent.getReturnData();
                this.setMemberJson(entityRows, ENTITYTEXT_KEY);
                break;
            }
            case "accounttext": {
                DynamicObjectCollection accRows = (DynamicObjectCollection)closedCallBackEvent.getReturnData();
                this.setMemberJson(accRows, ACCOUNTTEXT_KEY);
                break;
            }
        }
    }

    private void setMemberJson(DynamicObjectCollection memberRows, String key) {
        if (memberRows != null) {
            String dimNumber = StringUtils.equals((CharSequence)key, (CharSequence)ENTITYTEXT_KEY) ? SysDimensionEnum.Entity.getNumber() : SysDimensionEnum.Account.getNumber();
            String rejectMemberJson = (String)this.getModel().getValue(MEMBERJSON_KEY);
            List<Object> rejectMembers = StringUtils.isBlank((CharSequence)rejectMemberJson) ? new ArrayList(10) : JSON.parseArray((String)rejectMemberJson, RejectMember.class);
            rejectMembers = rejectMembers.stream().filter(e -> !dimNumber.equals(e.getDimNumber())).collect(Collectors.toList());
            ArrayList<RejectMember> members = new ArrayList<RejectMember>(memberRows.size());
            for (DynamicObject row : memberRows) {
                String number = row.getString("number");
                String name = row.getString("name");
                int range = row.getInt("scope");
                RejectMember rm = new RejectMember(dimNumber, number, name, Integer.valueOf(range));
                members.add(rm);
            }
            this.getModel().setValue(key, (Object)this.getMemberTxt(members));
            rejectMembers.addAll(members);
            this.getModel().setValue(MEMBERJSON_KEY, (Object)JSON.toJSONString(rejectMembers));
        }
    }

    @Override
    public Long getModelId() {
        DynamicObject modelObj = (DynamicObject)this.getModel().getValue(MODEL_KEY);
        if (modelObj != null) {
            return modelObj.getLong("id");
        }
        return 0L;
    }

    private String getMemberTxt(List<RejectMember> rejectMembers) {
        ArrayList<String> txtList = new ArrayList<String>(10);
        for (RejectMember rm : rejectMembers) {
            String memberText = rm.getMemberName() + "[" + RangeEnum.getRangeByVal((int)rm.getMemberRange()).getName() + "]";
            txtList.add(memberText);
        }
        return StringUtils.join(txtList, (String)",");
    }
}

