/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applybill;

import com.alibaba.fastjson.JSON;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.rejectbill.entity.RejectMember;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.fileImport.FileImportUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class RejectUserListPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final String MODEL_KEY = "model";
    private static final String BILLLIST_KEY = "billlistap";
    private final FileImportUtils fileImportUtils = FileImportUtils.getInstance();

    public void initialize() {
        super.initialize();
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        fc.setBillFormId("eb_billrejectconfig");
    }

    public void afterCreateNewData(EventObject e) {
        Long model = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)MODEL_KEY, (boolean)false);
        if (IDUtils.isNull((Long)model)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"RejectUserEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue(MODEL_KEY, (Object)model);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (MODEL_KEY.equals(key)) {
            DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL_KEY);
            if (model != null) {
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)model.getLong("id"));
            }
            this.refrushBillList();
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Long modelId;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"new") && IDUtils.isEmptyLong((Long)(modelId = this.getModelId())).booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"RejectUserEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        int statusVal;
        BillShowParameter billShowParameter = e.getParameter();
        if (billShowParameter instanceof BaseShowParameter && (statusVal = billShowParameter.getBillStatusValue().intValue()) == BillOperationStatus.ADDNEW.getValue()) {
            billShowParameter.setCustomParam("modelId", (Object)this.getModelId());
        }
    }

    private void refrushBillList() {
        BillList billList = (BillList)this.getControl(BILLLIST_KEY);
        billList.clearSelection();
        billList.refresh();
    }

    public void setFilter(SetFilterEvent e) {
        e.getQFilters().add(new QFilter(MODEL_KEY, "=", (Object)this.getModelId()));
    }

    @Override
    public Long getModelId() {
        DynamicObject modelObj = (DynamicObject)this.getModel().getValue(MODEL_KEY);
        if (modelObj != null) {
            return modelObj.getLong("id");
        }
        return 0L;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("import".equals(itemKey)) {
            this.openImportPage();
        } else if ("export".equals(itemKey)) {
            this.exportSelectData();
        }
    }

    private void exportSelectData() {
        BillList control = (BillList)this.getControl(BILLLIST_KEY);
        ListSelectedRowCollection selectedRows = control.getSelectedRows();
        if (selectedRows.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"RejectUserListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            this.doExportSelectData(selectedRows);
        }
    }

    private void doExportSelectData(ListSelectedRowCollection selectedRows) {
        DynamicObjectType dynamicObjectType = BusinessDataServiceHelper.newDynamicObject((String)"eb_billrejectconfig").getDynamicObjectType();
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).distinct().toArray(), (DynamicObjectType)dynamicObjectType);
        Workbook sheets = this.fillRejectUserData(load);
        if (sheets != null) {
            try {
                this.downloadExportFile(this.xssToInputSteam(sheets));
            }
            catch (IOException e) {
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
        }
    }

    private void openImportPage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epm_import");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam(MODEL_KEY, (Object)this.getModelId());
        showParameter.setCaption(ResManager.loadKDString((String)"\u9a73\u56de\u8c03\u6574\u914d\u7f6e", (String)"RejectUserListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)"epm_import");
        formConfig.getPlugins().clear();
        showParameter.setFormConfig(formConfig);
        showParameter.addCustPlugin("kd.epm.eb.formplugin.applybill.fileImport.RejectUserImportPlugin");
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "import");
        showParameter.setCloseCallBack(callBack);
        this.getView().showForm(showParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("import".equals(actionId)) {
            String returnData = (String)evt.getReturnData();
            String msg = ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"RejectUserListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            if (StringUtils.equals((CharSequence)msg, (CharSequence)String.valueOf(returnData))) {
                this.getView().showSuccessNotification(msg);
                this.refrushBillList();
            } else if (StringUtils.isNotEmpty((CharSequence)returnData)) {
                this.getView().showTipNotification(returnData);
                this.refrushBillList();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Workbook fillRejectUserData(DynamicObject[] dynamicObjects) {
        String path = "rejectuser/rejectuser_template.xlsx";
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(path);){
            if (inputStream == null) return null;
            XSSFWorkbook sheets = new XSSFWorkbook(inputStream);
            this.fileImportUtils.resetCellMaxTextLength();
            this.transSheetName(sheets);
            Workbook workbook = this.doFillRejectUserData((Workbook)sheets, dynamicObjects);
            return workbook;
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    private void transSheetName(XSSFWorkbook sheets) {
        XSSFSheet sheetAt = sheets.getSheetAt(0);
        XSSFRow row = sheetAt.getRow(0);
        XSSFCell cell = row.getCell(0);
        cell.setCellValue(ResManager.loadKDString((String)"1\u3001\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u7070\u8272\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\n2\u3001\u7ea2\u8272\u7684\u5b57\u6bb5\u4e3a\u5fc5\u5f55\u5b57\u6bb5", (String)"RejectUserListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        XSSFRow titleRow = sheetAt.getRow(1);
        XSSFCell entityNumberCell = titleRow.getCell(0);
        XSSFCell entityNameCell = titleRow.getCell(1);
        XSSFCell accountNumberCell = titleRow.getCell(2);
        XSSFCell accountNameCell = titleRow.getCell(3);
        XSSFCell rejectUserNumberCell = titleRow.getCell(4);
        XSSFCell rejectUserNameCell = titleRow.getCell(5);
        entityNameCell.setCellValue(ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0", (String)"RejectUserListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        accountNameCell.setCellValue(ResManager.loadKDString((String)"\u79d1\u76ee\u540d\u79f0", (String)"RejectUserListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        rejectUserNameCell.setCellValue(ResManager.loadKDString((String)"\u9a73\u56de\u8c03\u6574\u4eba\u540d\u79f0", (String)"RejectUserListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        entityNumberCell.setCellValue(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801", (String)"RejectUserListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.fileImportUtils.setCellTips((Cell)entityNumberCell, ResManager.loadKDString((String)"\u7ec4\u7ec7\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u540e\u7d27\u8ddf\u8303\u56f4\uff0c\u8303\u56f4\u7528[]\u5305\u88f9\uff0c\u53ef\u9009\u8303\u56f4\u6709\u4ec5\u81ea\u5df1\u3001\u76f4\u63a5\u4e0b\u7ea7_\u4e0d\u542b\u81ea\u5df1\u3001\u76f4\u63a5\u4e0b\u7ea7_\u542b\u81ea\u5df1\u3001\u6240\u6709\u4e0b\u7ea7_\u4e0d\u542b\u81ea\u5df1\u3001\u6240\u6709\u4e0b\u7ea7_\u542b\u81ea\u5df1\u3001\u6240\u6709\u5e73\u7ea7_\u4e0d\u542b\u81ea\u5df1\u3001\u6240\u6709\u5e73\u7ea7_\u542b\u81ea\u5df1\u3001\u6240\u6709\u4e0b\u7ea7_\u4ec5\u660e\u7ec6\u6210\u5458\u3001\u6240\u6709\u4e0b\u7ea7_\u4ec5\u975e\u660e\u7ec6\u6210\u5458\uff0c\u591a\u4e2a\u6210\u5458\u4e4b\u95f4\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00", (String)"RejectUserListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        accountNumberCell.setCellValue(ResManager.loadKDString((String)"\u79d1\u76ee\u7f16\u7801", (String)"RejectUserListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        rejectUserNumberCell.setCellValue(ResManager.loadKDString((String)"\u9a73\u56de\u8c03\u6574\u4eba\u7f16\u7801", (String)"RejectUserListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.fileImportUtils.setCellTips((Cell)accountNumberCell, ResManager.loadKDString((String)"\u79d1\u76ee\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u540e\u7d27\u8ddf\u8303\u56f4\uff0c\u8303\u56f4\u7528[]\u5305\u88f9\uff0c\u53ef\u9009\u8303\u56f4\u6709\u4ec5\u81ea\u5df1\u3001\u76f4\u63a5\u4e0b\u7ea7_\u4e0d\u542b\u81ea\u5df1\u3001\u76f4\u63a5\u4e0b\u7ea7_\u542b\u81ea\u5df1\u3001\u6240\u6709\u4e0b\u7ea7_\u4e0d\u542b\u81ea\u5df1\u3001\u6240\u6709\u4e0b\u7ea7_\u542b\u81ea\u5df1\u3001\u6240\u6709\u5e73\u7ea7_\u4e0d\u542b\u81ea\u5df1\u3001\u6240\u6709\u5e73\u7ea7_\u542b\u81ea\u5df1\u3001\u6240\u6709\u4e0b\u7ea7_\u4ec5\u660e\u7ec6\u6210\u5458\u3001\u6240\u6709\u4e0b\u7ea7_\u4ec5\u975e\u660e\u7ec6\u6210\u5458\uff0c\u591a\u4e2a\u6210\u5458\u4e4b\u95f4\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00", (String)"RejectUserListPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private Workbook doFillRejectUserData(Workbook sheets, DynamicObject[] dynamicObjects) {
        Sheet sheetAt = sheets.getSheetAt(0);
        for (int i = 0; i < dynamicObjects.length; ++i) {
            Row row = this.fileImportUtils.getRow(sheetAt, i + 2);
            Cell entityNumberCell = this.fileImportUtils.getCell(row, 0);
            Cell entityNameCell = this.fileImportUtils.getCell(row, 1);
            Cell accountNumberCell = this.fileImportUtils.getCell(row, 2);
            Cell accountNameCell = this.fileImportUtils.getCell(row, 3);
            Cell rejectUserNumberCell = this.fileImportUtils.getCell(row, 4);
            Cell rejectUserNameCell = this.fileImportUtils.getCell(row, 5);
            DynamicObject dynamicObject = dynamicObjects[i];
            String entitiytext = dynamicObject.getString("entitiytext");
            entityNameCell.setCellValue(entitiytext);
            String accounttext = dynamicObject.getString("accounttext");
            accountNameCell.setCellValue(accounttext);
            String userNumber = dynamicObject.getString("rejectuser.number");
            String userName = dynamicObject.getString("rejectuser.name");
            rejectUserNameCell.setCellValue(userName);
            rejectUserNumberCell.setCellValue(userNumber);
            String memberjson = dynamicObject.getString("memberjson");
            List members = JSON.parseArray((String)memberjson, RejectMember.class);
            ArrayList<RejectMember> entityList = new ArrayList<RejectMember>(10);
            ArrayList<RejectMember> accountList = new ArrayList<RejectMember>(10);
            for (RejectMember member : members) {
                String dimNumber = member.getDimNumber();
                if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
                    accountList.add(member);
                    continue;
                }
                if (!SysDimensionEnum.Entity.getNumber().endsWith(dimNumber)) continue;
                entityList.add(member);
            }
            entityNumberCell.setCellValue(this.getMemberNumberText(entityList));
            accountNumberCell.setCellValue(this.getMemberNumberText(accountList));
        }
        return sheets;
    }

    private String getMemberNumberText(List<RejectMember> rejectMembers) {
        ArrayList<String> txtList = new ArrayList<String>(10);
        for (RejectMember rm : rejectMembers) {
            String memberText = rm.getMemberNumber() + "[" + RangeEnum.getRangeByVal((int)rm.getMemberRange()).getName() + "]";
            txtList.add(memberText);
        }
        return StringUtils.join(txtList, (String)",");
    }

    private InputStream xssToInputSteam(Workbook sheets) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        sheets.write((OutputStream)bos);
        byte[] bytes = bos.toByteArray();
        return new ByteArrayInputStream(bytes);
    }

    private void downloadExportFile(InputStream inputStream) {
        String fileName = ResManager.loadKDString((String)"\u9a73\u56de\u8c03\u6574\u914d\u7f6e\u5bfc\u51fa\u4fe1\u606f.xlsx", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, inputStream, 10000);
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
        }
    }
}

