/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applybill;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.rejectbill.entity.RejectUserDto;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class RejectUserSelectListPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(RejectUserSelectListPlugin.class);

    public void afterCreateNewData(EventObject e) {
        this.initData();
    }

    private void initData() {
        List<RejectUserDto> rejectUsers = this.getRejectUser();
        if (CollectionUtils.isEmpty(rejectUsers)) {
            return;
        }
        log.info("RejectUserSelectListPlugin#initData.rejectUsers:" + SerializationUtils.toJsonString(rejectUsers));
        HashMap<String, Date> billnoMapDate = new HashMap<String, Date>(16);
        for (RejectUserDto rejectUser : rejectUsers) {
            Date date = (Date)billnoMapDate.get(rejectUser.getBillNo());
            Date approveDate = rejectUser.getApproveDate();
            if (date != null) {
                if (!approveDate.before(date)) continue;
                billnoMapDate.put(rejectUser.getBillNo(), approveDate);
                continue;
            }
            billnoMapDate.put(rejectUser.getBillNo(), approveDate);
        }
        Map<String, List<RejectUserDto>> group = rejectUsers.stream().collect(Collectors.groupingBy(s -> s.getBillNo()));
        List mapsort = billnoMapDate.entrySet().stream().sorted(new Comparator<Map.Entry<String, Date>>(){

            @Override
            public int compare(Map.Entry<String, Date> o1, Map.Entry<String, Date> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        }).collect(Collectors.toList());
        ArrayList<RejectUserDto> newRejectUsers = new ArrayList<RejectUserDto>(16);
        for (Map.Entry stringDateEntry : mapsort) {
            String key = (String)stringDateEntry.getKey();
            List<RejectUserDto> rejectUserDtos = group.get(key);
            rejectUserDtos.sort(new Comparator<RejectUserDto>(){

                @Override
                public int compare(RejectUserDto o1, RejectUserDto o2) {
                    return o1.getApproveDate().compareTo(o2.getApproveDate());
                }
            });
            newRejectUsers.addAll(rejectUserDtos);
        }
        int[] entryRows = this.getModel().batchCreateNewEntryRow("entryentity", newRejectUsers.size());
        for (int i = 0; i < newRejectUsers.size(); ++i) {
            RejectUserDto rejectUser = (RejectUserDto)SerializationUtils.getObjectMapper2().convertValue(newRejectUsers.get(i), RejectUserDto.class);
            this.getModel().setValue("bosuser", (Object)rejectUser.getUserId(), entryRows[i]);
            this.getModel().setValue("auditorg", (Object)rejectUser.getApproveOrg(), entryRows[i]);
            this.getModel().setValue("auditnode", (Object)rejectUser.getApproveNodeName(), entryRows[i]);
            this.getModel().setValue("approvebillno", (Object)rejectUser.getBillNo(), entryRows[i]);
        }
    }

    private List<RejectUserDto> getRejectUser() {
        ArrayList<RejectUserDto> result = new ArrayList<RejectUserDto>(16);
        Object rejectuser = this.getView().getFormShowParameter().getCustomParam("rejectUser");
        if (rejectuser == null) {
            return result;
        }
        return (List)SerializationUtils.deSerializeFromBase64((String)rejectuser.toString());
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((String)operateKey, (String)"btnok")) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows == null || selectRows.length < 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u9a73\u56de\u8c03\u6574\u4eba\u8bb0\u5f55\u3002", (String)"RejectUserSelectListPlugin_01", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            DynamicObject entryentity = this.getModel().getEntryRowEntity("entryentity", selectRows[0]);
            DynamicObject bosuser = entryentity.getDynamicObject("bosuser");
            String auditnode = entryentity.getString("auditnode");
            String approvebillno = entryentity.getString("approvebillno");
            long id = bosuser.getLong("id");
            List<RejectUserDto> rejectUsers = this.getRejectUser();
            if (CollectionUtils.isNotEmpty(rejectUsers)) {
                for (RejectUserDto rejectUser : rejectUsers) {
                    if (rejectUser.getApproveNodeName() == null) {
                        rejectUser.setApproveNodeName("");
                    }
                    if (id != rejectUser.getUserId() || !StringUtils.equals((String)auditnode, (String)rejectUser.getApproveNodeName()) || !StringUtils.equals((String)approvebillno, (String)rejectUser.getBillNo())) continue;
                    this.getView().returnDataToParent((Object)rejectUser);
                    this.getView().close();
                    break;
                }
            }
        }
    }
}

