/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applybill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.applybill.util.ApplyBillAggHelper;
import kd.epm.eb.business.applybill.util.ApplyBillPluginUitl;
import kd.epm.eb.business.applybill.util.BgApplyBillUtils;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateColCfgService;
import kd.epm.eb.business.centralapproval.ApproveBillUtil;
import kd.epm.eb.business.centralapproval.ApproveRecordUtil;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.common.applyTemplate.constants.FormTypeEnum;
import kd.epm.eb.common.applybill.AdjustShowTypeEnum;
import kd.epm.eb.common.applybill.ApplyBillType;
import kd.epm.eb.common.applybill.AuditRecordObj;
import kd.epm.eb.common.applybill.DetailMembBillData;
import kd.epm.eb.common.applybill.EntityRowDataType;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.EntryTemplateConfig;
import kd.epm.eb.common.applytemplatecolumn.FieldTypeEnum;
import kd.epm.eb.common.applytemplatecolumn.MeasureColumn;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.centralapproval.AdjustRecordColInfo;
import kd.epm.eb.common.centralapproval.ApproveBill;
import kd.epm.eb.common.centralapproval.CentralAppShowInfo;
import kd.epm.eb.common.model.Pair;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.ebSpread.common.util.StringUtil;
import kd.epm.eb.formplugin.applybill.SearchRepDataPlugin;

public class SearchNoDetailErrorPlugin
extends SearchRepDataPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"buttonap1", "buttonap4", "buttonap6"});
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("buttonap1".equals(key)) {
            this.searchAdjRecord();
        } else if ("buttonap4".equals(key)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u6279\u91cf\u53cd\u7b97\u540c\u4e00\u5355\u636e\u7684\u6570\u636e\u884c\uff0c\u8bf7\u68c0\u67e5\u5e76\u786e\u8ba4", (String)"", (String)"", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("addSubDataToOalp", (IFormPlugin)this));
        } else if ("buttonap6".equals(key)) {
            this.searchSubDataErrorRowData();
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if ("addSubDataToOalp".equals(callBackId) && event.getResult().getValue() == MessageBoxResult.Yes.getValue()) {
            this.addSubDataToOalp();
        }
    }

    private void addSubDataToOalp() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u53cd\u7b97\u7684\u884c", (String)"", (String)"", (Object[])new Object[0]));
            return;
        }
        EntryTemplateConfig templateConfig = this.getOrCacheTempConfig(null);
        List metricCol = templateConfig.getEntryColumns().stream().filter(col -> this.isNumMetricCol((BaseColumn)col)).collect(Collectors.toList());
        String billNumber = null;
        Map columnMapDimNum = templateConfig.selectColumnMapDimNum();
        ArrayList<AuditRecordObj> toSaveOlapData = new ArrayList<AuditRecordObj>(16);
        for (int index : selectRows) {
            DynamicObject rowObj = this.getModel().getEntryRowEntity("entryentity", index);
            String number = rowObj.getString("fbillnumber");
            if (billNumber == null) {
                billNumber = number;
            } else if (!billNumber.equals(number)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u6279\u91cf\u5904\u7406\u540c\u4e00\u5355\u636e\u7684\u884c\u8bb0\u5f55", (String)"", (String)"", (Object[])new Object[0]));
                return;
            }
            AuditRecordObj recordObj = new AuditRecordObj();
            recordObj.setNew(false);
            recordObj.setDetail(false);
            recordObj.setDataSetId(Long.valueOf(templateConfig.getDatasetId()));
            recordObj.setTemplateId(Long.valueOf(templateConfig.getTemplateID()));
            HashMap<String, Long> rowDimGroup = new HashMap<String, Long>(16);
            for (String dimKey : templateConfig.getDimKeysList()) {
                String dimIdStr = rowObj.getString(dimKey);
                dimIdStr = dimIdStr.substring(0, dimIdStr.indexOf(40));
                String dimNum = (String)columnMapDimNum.get(dimKey);
                rowDimGroup.put(dimNum, Long.valueOf(dimIdStr));
            }
            recordObj.setRowDimGroup(rowDimGroup);
            for (BaseColumn column : metricCol) {
                BigDecimal subData;
                String cKey = "f" + column.getKey();
                String adjKey = "f" + column.getKey() + "_adj";
                String adjDataStr = rowObj.getString(adjKey);
                String subDataStr = rowObj.getString(cKey);
                BigDecimal adjData = StringUtils.isEmpty((String)adjDataStr) ? BigDecimal.ZERO : new BigDecimal(adjDataStr);
                BigDecimal bigDecimal = subData = StringUtils.isEmpty((String)subDataStr) ? BigDecimal.ZERO : new BigDecimal(subDataStr);
                if (adjData.compareTo(subData) == 0) continue;
                AdjustRecordColInfo adjustInfo = new AdjustRecordColInfo();
                adjustInfo.setKey(column.getKey());
                adjustInfo.setAdjust((Object)subData.subtract(adjData));
                adjustInfo.setPreAdjust((Object)adjData);
                adjustInfo.setAfterAdjust((Object)subData);
                recordObj.getChangeDataInfos().add(adjustInfo);
            }
            if (recordObj.getChangeDataInfos().isEmpty()) continue;
            toSaveOlapData.add(recordObj);
        }
        this.saveOlapData(toSaveOlapData, billNumber, templateConfig);
    }

    private void saveOlapData(List<AuditRecordObj> toSaveOlapData, String billNumber, EntryTemplateConfig templateConfig) {
        if (!toSaveOlapData.isEmpty()) {
            IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
            FormTypeEnum billFormType = billNumber.contains("-HZ-") ? FormTypeEnum.COLLECT : FormTypeEnum.APPROVE;
            HashSet<Long> templateIds = new HashSet<Long>(16);
            templateIds.add(templateConfig.getTemplateID());
            Map auditTrailAllCfg = ApplyTemplateColCfgService.getInstance().queryColAuditTrailAllCfgByTemplateId(templateIds, billFormType);
            Map allTempConfig = ApplyBillPluginUitl.buildTempConfig(templateIds, (FormTypeEnum)billFormType, (IModelCacheHelper)modelCacheHelper, new HashMap());
            HashMap allTempConfigOnNumber = new HashMap(16);
            allTempConfigOnNumber.put(templateConfig.getNumber(), allTempConfig.get(templateConfig.getTemplateID()));
            CentralAppShowInfo showInfo = null;
            if (billFormType == FormTypeEnum.APPROVE) {
                ApproveBill approveBill = ApproveBillUtil.getInstance().getApproveBill(new QFilter("billno", "=", (Object)billNumber));
                showInfo = CentralAppBillService.getInstance().createShowInfo(approveBill);
            } else {
                DynamicObject billObj = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_bgapplybill", (QFilter[])new QFilter[]{new QFilter("billnumber", "=", (Object)billNumber)});
                Long collectOrgId = billObj.getLong("collectorg.id");
                String selappbills = billObj.getString("selappbills");
                Long bizCtrlRangeId = DatasetServiceHelper.getBusModelIdByDataset((Long)templateConfig.getDatasetId());
                Set selAppBills = StringUtil.isEmptyString((String)selappbills) ? new HashSet(16) : (Set)SerializationUtils.fromJsonString((String)selappbills, HashSet.class);
                showInfo = CentralAppBillService.getInstance().getCenAppInfosByEntity(billObj, collectOrgId, new ArrayList(templateIds), this.getModelId(), bizCtrlRangeId, Boolean.valueOf(true), selAppBills, Long.valueOf(billObj.getLong("applyscheme.id")), true);
            }
            showInfo.getTemplates().clear();
            showInfo.getTemplates().add(templateConfig.getTemplateID());
            Map allData = BgApplyBillUtils.getInstance().getAuditBillData(showInfo, billNumber, allTempConfigOnNumber, false);
            Map allSourceData = ApplyBillPluginUitl.buildSourceData((Map)allData, allTempConfigOnNumber, (IModelCacheHelper)modelCacheHelper);
            ApplyBillPluginUitl.saveAuditBillOlapData(toSaveOlapData, (EntryTemplateConfig)((EntryTemplateConfig)allTempConfig.get(templateConfig.getTemplateID())), (DetailMembBillData)((DetailMembBillData)allSourceData.get(templateConfig.getTemplateID())), (IModelCacheHelper)modelCacheHelper, (Map)((Map)auditTrailAllCfg.get(templateConfig.getTemplateID())));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u7b97\u6210\u529f", (String)"", (String)"", (Object[])new Object[0]));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"buttonap2", "buttonap5", "buttonap"});
    }

    @Override
    protected void addCustomCol(List<BaseColumn> main_collect, List<Pair<String, String>> colConfig) {
        for (BaseColumn column : main_collect) {
            if (!(column instanceof MeasureColumn)) continue;
            String key = "f" + column.getKey() + "_adj";
            String title = ResManager.loadResFormat((String)"%1_\u8c03\u6574\u5408\u8ba1", (String)"SearchNoDetailErrorPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[]{column.getTitle()});
            colConfig.add((Pair<String, String>)new Pair((Object)key, (Object)title));
        }
    }

    private void searchSubDataErrorRowData() {
        Number adjVal;
        EntryTemplateConfig tempConfig = this.getOrCacheTempConfig(null);
        String table = tempConfig.getEntryTable();
        List<Pair<String, String>> colConfig = this.getOrCacheColConfig(null);
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData("entryentity");
        String sql = this.getSql(table, colConfig);
        ArrayList<Object[]> rowDatas = new ArrayList<Object[]>(16);
        List dimColKeys = tempConfig.getDimKeysList();
        List rowDimNums = tempConfig.getRowDimNums();
        Map<String, Integer> colIndex = this.createColIndex(colConfig);
        ApplyBillAggHelper helper = ApplyBillAggHelper.getInstance();
        HashMap<String, Set<Long>> rowDimMembIds = new HashMap<String, Set<Long>>(16);
        try (DataSet dataSet = DB.queryDataSet((String)"fillEntryData", (DBRoute)new DBRoute("epm"), (String)sql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Object[] rowVal = new Object[colConfig.size()];
                for (int i = 0; i < colConfig.size(); ++i) {
                    String key2 = (String)colConfig.get(i).getKey();
                    if (key2.endsWith("_adj")) continue;
                    rowVal[i] = row.get(key2);
                }
                String dataType = helper.getRowDataType(rowVal);
                if (StringUtils.isEmpty((String)dataType) || EntityRowDataType.isDetailData((String)dataType)) continue;
                int seq = 0;
                for (String dimCol : dimColKeys) {
                    Long membId = row.getLong(dimCol);
                    String dimNum = (String)rowDimNums.get(seq);
                    Set membIds = rowDimMembIds.computeIfAbsent(dimNum, key -> new HashSet(16));
                    membIds.add(membId);
                    ++seq;
                }
                rowDatas.add(rowVal);
            }
        }
        if (rowDatas.isEmpty()) {
            return;
        }
        ApproveRecordUtil recordUtil = ApproveRecordUtil.getInstance();
        List adjustRecords = recordUtil.getAppAdjustRecords(rowDimMembIds, Long.valueOf(tempConfig.getTemplateID()), Long.valueOf(tempConfig.getDatasetId()), this.getModelId(), null);
        HashMap<Long, EntryTemplateConfig> templateConfigMap = new HashMap<Long, EntryTemplateConfig>(16);
        templateConfigMap.put(tempConfig.getTemplateID(), tempConfig);
        Map mergeAdjustRecord = ApplyBillPluginUitl.mergeAdjustRecord((List)adjustRecords, templateConfigMap);
        Map totalAdjRecord = mergeAdjustRecord.computeIfAbsent(tempConfig.getTemplateID(), key -> new HashMap(16));
        List metricCol = tempConfig.getEntryColumns().stream().filter(col -> this.isNumMetricCol((BaseColumn)col)).collect(Collectors.toList());
        HashMap allNoMatchVals = new HashMap(16);
        Iterator iterator = rowDatas.iterator();
        while (iterator.hasNext()) {
            Object[] rowVals = (Object[])iterator.next();
            String dimMembStr = BgApplyBillUtils.getInstance().seletRowDimMembIds(rowVals, dimColKeys, colIndex);
            Map adjVals = (Map)totalAdjRecord.get(dimMembStr);
            if (adjVals == null) continue;
            HashMap<String, Number> noMatchCol = new HashMap<String, Number>(16);
            for (BaseColumn column : metricCol) {
                Number rowVal;
                String fKey = "f" + column.getKey();
                String cKey = column.getKey();
                if (column.getFieldtype() == FieldTypeEnum.NumberField) {
                    rowVal = (BigDecimal)rowVals[colIndex.get(fKey)];
                    if (((BigDecimal)rowVal).compareTo((BigDecimal)(adjVal = (adjVal = (BigDecimal)adjVals.get(cKey)) == null ? BigDecimal.ZERO : BigDecimal.ZERO.subtract((BigDecimal)adjVal))) == 0) continue;
                    noMatchCol.put(fKey, adjVal);
                    continue;
                }
                rowVal = (Integer)rowVals[colIndex.get(fKey)];
                if (((Integer)rowVal).equals(adjVal = (adjVal = (Integer)adjVals.get(cKey)) == null ? Integer.valueOf(0) : Integer.valueOf(-((Integer)adjVal).intValue()))) continue;
                noMatchCol.put(fKey, adjVal);
            }
            if (!noMatchCol.isEmpty()) {
                allNoMatchVals.put(helper.getRowId(rowVals), noMatchCol);
                continue;
            }
            iterator.remove();
        }
        if (rowDatas.size() > 0) {
            Map<String, Map<Long, String>> idMapNames = this.selectDimMembNames(rowDimMembIds);
            dataModel.batchCreateNewEntryRow("entryentity", rowDatas.size());
            int rowCount = 0;
            Map colMapDimNum = tempConfig.selectColumnMapDimNum();
            for (Object[] rowVal : rowDatas) {
                Long rowId = helper.getRowId(rowVal);
                Map noMatchVal = (Map)allNoMatchVals.get(rowId);
                for (int i = 0; i < colConfig.size(); ++i) {
                    String key3 = (String)colConfig.get(i).getKey();
                    if (key3.endsWith("_adj")) {
                        if (noMatchVal == null || (adjVal = noMatchVal.get(key3.replace("_adj", ""))) == null) continue;
                        dataModel.setValue(key3, (Object)adjVal, rowCount);
                        continue;
                    }
                    String rowDimNum = (String)colMapDimNum.get(key3);
                    Map<Long, String> names = idMapNames.get(rowDimNum);
                    if (names != null) {
                        Long id = (Long)rowVal[i];
                        String name = names.get(id);
                        dataModel.setValue(key3, (Object)(id + "(" + name + ")"), rowCount);
                        continue;
                    }
                    dataModel.setValue(key3, rowVal[i], rowCount);
                }
                ++rowCount;
            }
        }
    }

    private boolean isNumMetricCol(BaseColumn column) {
        return column instanceof MeasureColumn && (column.getFieldtype() == FieldTypeEnum.NumberField || column.getFieldtype() == FieldTypeEnum.IntField);
    }

    @Override
    protected String getSql(String table, List<Pair<String, String>> colConfig) {
        StringBuilder sb = new StringBuilder();
        sb.append("select ");
        colConfig.forEach(p -> {
            if (!((String)p.getKey()).endsWith("_adj")) {
                sb.append((String)p.getKey()).append(',');
            }
        });
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" from ").append(table);
        return sb.toString();
    }

    public void searchAdjRecord() {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        if (currentRowIndex < 0) {
            return;
        }
        DynamicObject rowObj = this.getModel().getEntryRowEntity("entryentity", currentRowIndex);
        EntryTemplateConfig tempConfig = this.getOrCacheTempConfig(null);
        HashMap dims = new HashMap(16);
        Map columnMapDimNum = tempConfig.selectColumnMapDimNum();
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        for (String dimKey : tempConfig.getDimKeysList()) {
            String dimIdStr = rowObj.getString(dimKey);
            dimIdStr = dimIdStr.substring(0, dimIdStr.indexOf(40));
            String dimNum = (String)columnMapDimNum.get(dimKey);
            Member member = modelCacheHelper.getMember(dimNum, null, Long.valueOf(dimIdStr));
            dims.put(columnMapDimNum.get(dimKey), member.getNumber());
        }
        FormShowParameter adjustShowPage = CentralAppBillService.getInstance().getAdjustShowPage("", null, dims, Long.valueOf(tempConfig.getTemplateID()), AdjustShowTypeEnum.Adjust, ApplyBillType.APPLYAUDIT, Long.valueOf(tempConfig.getDatasetId()), this.getModelId());
        this.getView().showForm(adjustShowPage);
    }
}

