/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applybill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.applybill.util.ApplyBillAggHelper;
import kd.epm.eb.business.applybill.util.ApplyTemplateUtils;
import kd.epm.eb.business.applybill.util.BgApplyBillUtils;
import kd.epm.eb.common.applyTemplate.helper.CustomControlHelper;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.ColumnList;
import kd.epm.eb.common.applytemplatecolumn.EntryTemplateConfig;
import kd.epm.eb.common.applytemplatecolumn.FieldTypeEnum;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.model.Pair;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class SearchRepDataPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
EntryGridBindDataListener {
    private static final Log log = LogFactory.getLog(SearchRepDataPlugin.class);
    protected static final String entryKey = "entryentity";

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{entryKey});
        EntryGrid grid = (EntryGrid)this.getView().getControl(entryKey);
        grid.addDataBindListener((EntryGridBindDataListener)this);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"buttonap", "buttonap2", "buttonap5"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("model".equals(name)) {
            this.upateTemplateList();
        } else if ("template".equals(name)) {
            this.initEntry();
        }
    }

    private void upateTemplateList() {
        Long modelId = this.getModelId();
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"eb_applytemplate", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)});
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        for (DynamicObject obj : objects) {
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(obj.getString("id"));
            comboItem.setCaption(new LocaleString(obj.getString("name")));
            items.add(comboItem);
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("template");
        comboEdit.setComboItems(items);
    }

    @Override
    public Long getModelId() {
        Long modelId = (Long)this.getValue("model", "id");
        if (modelId == null) {
            modelId = 0L;
        }
        return modelId;
    }

    private void initEntry() {
        String templateId = (String)this.getValue("template", null);
        this.getModel().deleteEntryData(entryKey);
        if (StringUtils.isNotEmpty((String)templateId)) {
            DynamicObject template = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_applytemplate", (String)"id,name,number,amountunit,dataset_id,model_id,createtime,cachedata_tag,entrycfgjson_tag", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(templateId))});
            ColumnList columnList = ApplyTemplateUtils.getEntrycfgByApplyTemplate((DynamicObject)template);
            EntryTemplateConfig templateConfig = new EntryTemplateConfig();
            Long datasetId = template.getLong("dataset_id");
            templateConfig.setModelId(Long.valueOf(template.getLong("model_id")));
            templateConfig.setDatasetId(datasetId.longValue());
            templateConfig.setTemplateID(Long.parseLong(templateId));
            templateConfig.setNumber(template.getString("number"));
            List<BaseColumn> main_collect = columnList.getColumns().stream().filter(ee -> "h".equals(ee.getCategory())).collect(Collectors.toList());
            templateConfig.setEntryColumns(main_collect);
            ArrayList<Pair<String, String>> colCofig = new ArrayList<Pair<String, String>>(16);
            Pair p1 = new Pair((Object)"fentryid", (Object)"fentryid");
            colCofig.add(p1);
            Pair p2 = new Pair((Object)"fbilltype", (Object)"fbilltype");
            colCofig.add(p2);
            Pair p3 = new Pair((Object)"fbillnumber", (Object)"fbillnumber");
            colCofig.add(p3);
            Pair p4 = new Pair((Object)"fdatatype", (Object)"fdatatype");
            colCofig.add(p4);
            Pair p5 = new Pair((Object)"fcreator", (Object)"fcreator");
            colCofig.add(p5);
            Pair p6 = new Pair((Object)"fcreatedate", (Object)"fcreatedate");
            colCofig.add(p6);
            Pair p7 = new Pair((Object)"fmodifier", (Object)"fmodifier");
            colCofig.add(p7);
            Pair p8 = new Pair((Object)"fmodifydate", (Object)"fmodifydate");
            colCofig.add(p8);
            main_collect.forEach(col -> colCofig.add(new Pair((Object)("f" + col.getKey()), (Object)(col.getTitle() + "(" + col.getKey() + ")"))));
            this.addCustomCol(main_collect, colCofig);
            this.createEntry(colCofig);
            this.getOrCacheColConfig(colCofig);
            List dimKeyList = ApplyTemplateUtils.getDimKeyList(main_collect);
            for (int i = 0; i < dimKeyList.size(); ++i) {
                String key = (String)dimKeyList.get(i);
                dimKeyList.set(i, "f" + key);
            }
            List rowDimNumList = ApplyTemplateUtils.getRowDimNumList(main_collect, (IModelCacheHelper)this.getIModelCacheHelper());
            templateConfig.setDimKeysList(dimKeyList);
            templateConfig.setRowDimNums(rowDimNumList);
            templateConfig.setEntryTable((String)columnList.getEntityinfomap().get("mainentryentity"));
            this.getOrCacheTempConfig(templateConfig);
        }
    }

    protected EntryTemplateConfig getOrCacheTempConfig(EntryTemplateConfig templateConfig) {
        if (templateConfig == null) {
            String cacheStr = this.getPageCache().get("getOrCacheTableNum");
            templateConfig = (EntryTemplateConfig)SerializationUtils.fromJsonString((String)cacheStr, EntryTemplateConfig.class);
        } else {
            this.getPageCache().put("getOrCacheTableNum", SerializationUtils.toJsonString((Object)templateConfig));
        }
        return templateConfig;
    }

    protected Long getTemplateId() {
        String templateId = (String)this.getValue("template", null);
        if (StringUtils.isNotEmpty((String)templateId)) {
            return Long.valueOf(templateId);
        }
        return 0L;
    }

    protected void addCustomCol(List<BaseColumn> main_collect, List<Pair<String, String>> colConfig) {
    }

    private void createEntry(List<Pair<String, String>> colCofig) {
        EntryAp entryAp = this.getEntryAp(colCofig);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.preInvokeControlMethod(entryAp.getKey(), "createGridColumns", new Object[]{entryAp.createControl()});
    }

    protected EntryAp getEntryAp(List<Pair<String, String>> colCofig) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey(entryKey);
        for (Pair<String, String> pair : colCofig) {
            EntryFieldAp fieldAp = CustomControlHelper.createEntryFieldAp((String)((String)pair.getKey()), (String)((String)pair.getValue()), (FieldTypeEnum)FieldTypeEnum.TextField);
            ((TextField)fieldAp.getField()).setMaxLength(500);
            entryAp.getItems().add(fieldAp);
        }
        entryAp.setShowSeq(true);
        entryAp.setShowSelChexkbox(true);
        return entryAp;
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("buttonap".equals(key)) {
            this.searchRepRowData();
        } else if ("buttonap2".equals(key)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u5f53\u524d\u9009\u62e9\u7684\u884c\u6570\u636e", (String)"", (String)"", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delRowData", (IFormPlugin)this));
        } else if ("buttonap5".equals(key)) {
            this.searchNewRowOnAuditBill();
        }
    }

    public void searchNewRowOnAuditBill() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"buttonap2"});
        EntryTemplateConfig templateConfig = this.getOrCacheTempConfig(null);
        String table = templateConfig.getEntryTable();
        List<Pair<String, String>> colConfig = this.getOrCacheColConfig(null);
        this.getModel().deleteEntryData(entryKey);
        ArrayList<Object[]> rowDatas = new ArrayList<Object[]>(16);
        Map<String, Integer> colIndex = this.createColIndex(colConfig);
        ApplyBillAggHelper billAggHelper = ApplyBillAggHelper.getInstance();
        HashSet<Integer> rowIndexs = new HashSet<Integer>(16);
        int rowIndex = 0;
        try (DataSet dataSet = DB.queryDataSet((String)"fillEntryData", (DBRoute)new DBRoute("epm"), (String)this.getSql(table, colConfig));){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Object[] rowVal = new Object[colConfig.size()];
                for (int i = 0; i < colConfig.size(); ++i) {
                    rowVal[i] = row.get((String)colConfig.get(i).getKey());
                }
                String billNumber = billAggHelper.getBillNumberOnRow(rowVal);
                if (!billAggHelper.isDetailRow(rowVal) || !billNumber.contains("-SP-")) continue;
                rowDatas.add(rowVal);
                rowIndexs.add(rowIndex);
                ++rowIndex;
            }
        }
        this.insertRowToEntry(rowDatas, rowIndexs, templateConfig, colIndex, colConfig);
    }

    private void insertRowToEntry(List<Object[]> rowDatas, Set<Integer> rowIndexs, EntryTemplateConfig templateConfig, Map<String, Integer> colIndex, List<Pair<String, String>> colConfig) {
        if (rowIndexs.size() > 0) {
            IDataModel dataModel = this.getModel();
            dataModel.batchCreateNewEntryRow(entryKey, rowIndexs.size());
            Map columnMapDimNum = templateConfig.selectColumnMapDimNum();
            int rowCount = 0;
            Map<String, Map<Long, String>> dimMembNames = this.selectRowDimMembName(rowDatas, rowIndexs, templateConfig, colIndex);
            for (int index : rowIndexs) {
                Object[] rowVal = rowDatas.get(index);
                for (int i = 0; i < colConfig.size(); ++i) {
                    String key = (String)colConfig.get(i).getKey();
                    String rowDimNum = (String)columnMapDimNum.get(key);
                    Map<Long, String> names = dimMembNames.get(rowDimNum);
                    if (names != null) {
                        Long id = (Long)rowVal[i];
                        String name = names.get(id);
                        dataModel.setValue(key, (Object)(id + "(" + name + ")"), rowCount);
                        continue;
                    }
                    dataModel.setValue(key, rowVal[i], rowCount);
                }
                ++rowCount;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        if ("delRowData".equals(callBackId) && event.getResult().getValue() == MessageBoxResult.Yes.getValue()) {
            this.delRowData();
        }
    }

    private void delRowData() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryKey);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u5220\u9664\u7684\u884c", (String)"", (String)"", (Object[])new Object[0]));
            return;
        }
        IDataModel dataModel = this.getModel();
        HashSet<Long> toDelRowIds = new HashSet<Long>(16);
        for (int index : selectRows) {
            String fentryId = (String)dataModel.getValue("fentryid", index);
            toDelRowIds.add(Long.valueOf(fentryId));
        }
        EntryTemplateConfig tempConfig = this.getOrCacheTempConfig(null);
        String table = tempConfig.getEntryTable();
        StringBuilder sb = new StringBuilder();
        sb.append("delete from ").append(table).append(" where fentryid in(").append(SqlBatchUtils.getBatchParamsSql((int)toDelRowIds.size())).append(')');
        try (TXHandle tx = TX.required();){
            try {
                DB.execute((DBRoute)new DBRoute("epm"), (String)sb.toString(), (Object[])toDelRowIds.toArray());
            }
            catch (Throwable e) {
                log.error(e);
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
        this.getView().showSuccessNotification(ResManager.loadResFormat((String)"\u5220\u9664\u6210\u529f%1", (String)"SearchRepDataPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[]{((Object)toDelRowIds).toString()}), Integer.valueOf(10000));
    }

    private void searchRepRowData() {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"buttonap2"});
        EntryTemplateConfig templateConfig = this.getOrCacheTempConfig(null);
        String table = templateConfig.getEntryTable();
        List<Pair<String, String>> colConfig = this.getOrCacheColConfig(null);
        ArrayList<Object[]> rowDatas = new ArrayList<Object[]>(16);
        this.getModel().deleteEntryData(entryKey);
        List dimColKeys = templateConfig.getDimKeysList();
        HashMap<String, Integer> membStr = new HashMap<String, Integer>(16);
        HashSet<Integer> sameDimMembRowIndexs = new HashSet<Integer>(16);
        Map<String, Integer> colIndex = this.createColIndex(colConfig);
        int count = 0;
        try (DataSet dataSet = DB.queryDataSet((String)"fillEntryData", (DBRoute)new DBRoute("epm"), (String)this.getSql(table, colConfig));){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Object[] rowVal = new Object[colConfig.size()];
                for (int i = 0; i < colConfig.size(); ++i) {
                    rowVal[i] = row.get((String)colConfig.get(i).getKey());
                }
                String dimMembStr = BgApplyBillUtils.getInstance().seletRowDimMembIds(rowVal, dimColKeys, colIndex);
                Integer existRowIndex = (Integer)membStr.get(dimMembStr);
                if (existRowIndex != null) {
                    sameDimMembRowIndexs.add(existRowIndex);
                    sameDimMembRowIndexs.add(count);
                } else {
                    membStr.put(dimMembStr, count);
                }
                rowDatas.add(rowVal);
                ++count;
            }
        }
        this.insertRowToEntry(rowDatas, sameDimMembRowIndexs, templateConfig, colIndex, colConfig);
    }

    protected Map<String, Map<Long, String>> selectDimMembNames(Map<String, Set<Long>> dimMembIds) {
        IModelCacheHelper iModelCacheHelper = this.getIModelCacheHelper();
        HashMap<String, Map<Long, String>> result = new HashMap<String, Map<Long, String>>(16);
        dimMembIds.forEach((dimNum, membIds) -> {
            Dimension dimension = iModelCacheHelper.getDimension(dimNum);
            if (dimension != null) {
                List members = dimension.getMember(Long.valueOf(0L), (Collection)membIds);
                Map<Long, String> idMapNames = members.stream().collect(Collectors.toMap(m -> m.getId(), m -> m.getName()));
                result.put((String)dimNum, idMapNames);
            }
        });
        return result;
    }

    private Map<String, Map<Long, String>> selectRowDimMembName(List<Object[]> rowDatas, Set<Integer> sameDimMembRowIndexs, EntryTemplateConfig templateConfig, Map<String, Integer> colIndex) {
        List dimKeysList = templateConfig.getDimKeysList();
        Map columnMapDimNum = templateConfig.selectColumnMapDimNum();
        HashMap<String, Set<Long>> ids = new HashMap<String, Set<Long>>();
        for (int rowIndex : sameDimMembRowIndexs) {
            Object[] rowVal = rowDatas.get(rowIndex);
            for (String dimKey : dimKeysList) {
                Long membId = (Long)rowVal[colIndex.get(dimKey)];
                if (membId == null) continue;
                Set idSet = ids.computeIfAbsent((String)columnMapDimNum.get(dimKey), (Function<String, Set<Long>>)((Function<String, Set>)k -> new HashSet(16)));
                idSet.add(membId);
            }
        }
        return this.selectDimMembNames(ids);
    }

    protected String getSql(String table, List<Pair<String, String>> colConfig) {
        StringBuilder sb = new StringBuilder();
        sb.append("select ");
        colConfig.forEach(p -> sb.append((String)p.getKey()).append(','));
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" from ").append(table);
        return sb.toString();
    }

    protected Map<String, Integer> createColIndex(List<Pair<String, String>> colConfig) {
        HashMap<String, Integer> index = new HashMap<String, Integer>(16);
        for (int i = 0; i < colConfig.size(); ++i) {
            Pair<String, String> p = colConfig.get(i);
            index.put((String)p.getKey(), i);
        }
        return index;
    }

    protected List<Pair<String, String>> getOrCacheColConfig(List<Pair<String, String>> colConfig) {
        if (colConfig == null) {
            String cacheStr = this.getPageCache().get("getOrCacheColConfig");
            if (cacheStr != null) {
                colConfig = (List)SerializationUtils.deSerializeFromBase64((String)cacheStr);
            }
        } else {
            this.getPageCache().put("getOrCacheColConfig", SerializationUtils.serializeToBase64(colConfig));
        }
        return colConfig;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            log.error((Throwable)exp);
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        this.registDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    private void registDynamicProps(MainEntityType newMainType) {
        EntryType entryType = (EntryType)newMainType.getAllEntities().get(entryKey);
        entryType.createPropIndexs();
        List<Pair<String, String>> colConfig = this.getOrCacheColConfig(null);
        if (colConfig != null) {
            for (Pair<String, String> col : colConfig) {
                TextProp textProp = SearchRepDataPlugin.createTextProp((String)col.getKey(), (String)col.getValue());
                entryType.addProperty((DynamicProperty)textProp);
            }
        }
    }

    private static TextProp createTextProp(String key, String name) {
        TextProp textProp = new TextProp();
        textProp.setName(key);
        textProp.setDisplayName(new LocaleString(name));
        textProp.setDbIgnore(true);
        textProp.setAlias("");
        return textProp;
    }

    public void onGetControl(OnGetControlArgs e) {
        List<Pair<String, String>> colConfig;
        EntryGrid entryGrid;
        Control entryControl;
        super.onGetControl(e);
        String key = e.getKey();
        if (key != null && key.startsWith("f")) {
            TextEdit textEdit = new TextEdit();
            textEdit.setKey(key);
            textEdit.setView(this.getView());
            textEdit.setModel(this.getModel());
            textEdit.setEntryKey(entryKey);
            e.setControl((Control)textEdit);
        } else if (entryKey.equals(key) && (entryControl = e.getControl()) != null && (entryGrid = (EntryGrid)entryControl).getItems().isEmpty() && (colConfig = this.getOrCacheColConfig(null)) != null) {
            EntryAp entryAp = this.getEntryAp(colConfig);
            List fieldEdits = ((Container)entryAp.buildRuntimeControl()).getItems();
            this.addThisViewToEntryGrid(entryGrid, fieldEdits);
        }
    }

    private void addThisViewToEntryGrid(EntryGrid entryGrid, List<Control> fieldEdits) {
        for (Control fieldEdit : fieldEdits) {
            if (fieldEdit instanceof Container) {
                if (fieldEdit instanceof OperationColumn) {
                    fieldEdit.setView(this.getView());
                } else {
                    this.addThisViewToEntryEditField(((Container)fieldEdit).getItems());
                    fieldEdit.setView(this.getView());
                }
            } else if (fieldEdit != null) {
                fieldEdit.setView(this.getView());
            }
            entryGrid.getItems().add(fieldEdit);
        }
    }

    private void addThisViewToEntryEditField(List<Control> items) {
        for (Control fieldEdit : items) {
            if (fieldEdit instanceof Container) {
                if (!(fieldEdit instanceof OperationColumn)) {
                    this.addThisViewToEntryEditField(((Container)fieldEdit).getItems());
                }
                fieldEdit.setView(this.getView());
                continue;
            }
            if (fieldEdit == null) continue;
            fieldEdit.setView(this.getView());
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (name.equals("template")) {
            QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
            QFilter filter1 = new QFilter("status", "=", (Object)Character.valueOf('A'));
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
            qFilterList.add(filter);
            qFilterList.add(filter1);
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }
}

