/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applybill;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.BooleanProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.epm.eb.common.DynamicCreate.CreateItemApHelper;
import kd.epm.eb.common.DynamicCreate.CreateItemCtrlHelper;
import kd.epm.eb.common.DynamicCreate.FieldItemType;
import kd.epm.eb.common.applybill.DimColumnObj;
import kd.epm.eb.common.applybill.TemplateObj;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class StatDimSelectPlugin
extends AbstractFormPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"bnt_conform"});
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        this.createDimList(e);
    }

    private void createDimList(LoadCustomControlMetasArgs e) {
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        Map<TemplateObj, List<DimColumnObj>> allDimColumnInfo = this.getallDimColumnInfo(formShowParameter);
        if (allDimColumnInfo == null) {
            return;
        }
        FlexPanelAp panelAp = this.getAllDyItemAp(allDimColumnInfo);
        e.getItems().add(panelAp.createControl());
    }

    private FlexPanelAp getAllDyItemAp(Map<TemplateObj, List<DimColumnObj>> allDimColumnInfo) {
        FlexPanelAp panelAp = CreateItemApHelper.createFlexPanelAp((String)"dimcolumnpanel");
        panelAp.setDirection("column");
        panelAp.setAlignItems("stretch");
        panelAp.setJustifyContent("center");
        panelAp.setWrap(false);
        allDimColumnInfo.forEach((tempInfo, columnInfo) -> {
            FlexPanelAp tempDimColumnAp = CreateItemApHelper.createFlexPanelAp((String)("dimColumn-" + tempInfo.getTemplateNumber()));
            tempDimColumnAp.setDirection("row");
            tempDimColumnAp.setAlignItems("center");
            tempDimColumnAp.setWrap(false);
            tempDimColumnAp.setJustifyContent("center");
            if (columnInfo.size() > 3) {
                tempDimColumnAp.setJustifyContent("flex-start");
            }
            columnInfo.forEach(columnObj -> {
                FieldAp checkBox = CreateItemApHelper.getFieldAp((String)columnObj.getColumnKey(), (String)columnObj.getDimName(), (boolean)false, (FieldItemType)FieldItemType.CHECKBO);
                ((CheckBoxField)checkBox.getField()).setShowStyle(1);
                checkBox.setFireUpdEvt(true);
                tempDimColumnAp.getItems().add(checkBox);
            });
            panelAp.getItems().add(tempDimColumnAp);
        });
        return panelAp;
    }

    private void initDimColumnListVal() {
        Map<TemplateObj, List<DimColumnObj>> allDimColumnInfo = this.getallDimColumnInfo(this.getView().getFormShowParameter());
        if (allDimColumnInfo != null) {
            IFormView formView = this.getView();
            IDataModel dataModel = this.getModel();
            allDimColumnInfo.values().forEach(dimColumnObjs -> dimColumnObjs.forEach(dimColumnObj -> {
                if (dimColumnObj.isSelected()) {
                    dataModel.setValue(dimColumnObj.getColumnKey(), (Object)Boolean.TRUE);
                    formView.setEnable(Boolean.valueOf(false), new String[]{dimColumnObj.getColumnKey()});
                }
            }));
        }
    }

    private Map<TemplateObj, List<DimColumnObj>> getallDimColumnInfo(FormShowParameter formShowParameter) {
        String paramStr = (String)formShowParameter.getCustomParam("statDimColumnKeys");
        if (paramStr == null) {
            return null;
        }
        return (Map)SerializationUtils.deSerializeFromBase64((String)paramStr);
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Container control = (Container)this.getView().getControl("dimcolumnpanel");
        Map<TemplateObj, List<DimColumnObj>> allDimColumnInfo = this.getallDimColumnInfo(this.getView().getFormShowParameter());
        if (allDimColumnInfo == null) {
            return;
        }
        FlexPanelAp container = this.getAllDyItemAp(allDimColumnInfo);
        control.getItems().addAll(((Container)container.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(control.getItems());
    }

    public void afterCreateNewData(EventObject e) {
        this.initDimColumnListVal();
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (key != null && key.startsWith("h_")) {
            FieldEdit checkbox = CreateItemCtrlHelper.createCheckBoxItemCtrl((String)key, (IFormView)this.getView(), (IDataModel)this.getModel());
            e.setControl((Control)checkbox);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            MainEntityType newEntityType = (MainEntityType)e.getOriginalEntityType().clone();
            this.registCustomItemProp(newEntityType);
            e.setNewEntityType(newEntityType);
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void registCustomItemProp(MainEntityType newEntityType) {
        Map<TemplateObj, List<DimColumnObj>> allDimColumnInfo = this.getallDimColumnInfo(this.getView().getFormShowParameter());
        if (allDimColumnInfo != null) {
            allDimColumnInfo.values().forEach(dimColumnObjs -> dimColumnObjs.forEach(dimColumnObj -> {
                BooleanProp booleanProp = new BooleanProp();
                booleanProp.setName(dimColumnObj.getColumnKey());
                newEntityType.addProperty((DynamicProperty)booleanProp);
            }));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String itemKey = ((Control)evt.getSource()).getKey();
        if ("bnt_conform".equals(itemKey)) {
            this.backDataAndClose();
        }
    }

    private void backDataAndClose() {
        Map<TemplateObj, List<DimColumnObj>> allDimColumnInfo = this.getallDimColumnInfo(this.getView().getFormShowParameter());
        if (allDimColumnInfo == null) {
            return;
        }
        IDataModel dataModel = this.getModel();
        allDimColumnInfo.values().forEach(dimColumnObjs -> dimColumnObjs.forEach(dimColumnObj -> {
            if (!dimColumnObj.isSelected()) {
                Boolean selected = (Boolean)dataModel.getValue(dimColumnObj.getColumnKey());
                dimColumnObj.setSelected(selected.booleanValue());
            }
        }));
        this.getView().returnDataToParent((Object)SerializationUtils.serializeToBase64(allDimColumnInfo));
        this.getView().close();
    }
}

