/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applybill.fileImport;

import java.io.InputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.ComboItem;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.business.applybill.util.ApplyTemplateUtils;
import kd.epm.eb.business.applybill.util.BgApplyBillUtils;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateColCfgService;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateDimRangeService;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.applyTemplate.constants.ColCfgPropEnum;
import kd.epm.eb.common.applyTemplate.constants.ColCfgPropTypeEnum;
import kd.epm.eb.common.applyTemplate.constants.FormTypeEnum;
import kd.epm.eb.common.applyTemplate.entity.ApplyTemplateBizRange;
import kd.epm.eb.common.applybill.SchemeAssignDimGroup;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.ColumnEnum;
import kd.epm.eb.common.applytemplatecolumn.DimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.DimensionDataColumn;
import kd.epm.eb.common.applytemplatecolumn.EnumColumn;
import kd.epm.eb.common.applytemplatecolumn.FieldTypeEnum;
import kd.epm.eb.common.applytemplatecolumn.MeasureColumn;
import kd.epm.eb.common.applytemplatecolumn.RelationDimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.RowDimensionColumn;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.DateTimeUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.LanguageUtils;
import kd.epm.eb.formplugin.applybill.fileImport.BgApplyBillDataExportPlugin;
import kd.epm.eb.formplugin.applybill.fileImport.BgApplyBillImportBasePlugin;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class BgApplyBillDataImportPlugin
extends BgApplyBillImportBasePlugin {
    private static final Log log = LogFactory.getLog(BgApplyBillDataImportPlugin.class);
    private int rowIndex = -1;

    @Override
    public void downLoadTemplate() {
        BgApplyBillDataExportPlugin.getInstance().export(null, this.getEntryTemplateInfo(), this.getModelId(), this.getView(), this.getBillNumber(), this.getEnableCols(), null, null, true, this.getReportSchemeAssignGroup());
    }

    private Date getCurTime() {
        return TimeServiceHelper.now();
    }

    @Override
    public void importFileData(InputStream inputStream) {
        XSSFWorkbook workbook = this.getWorkBook(inputStream);
        this.errorBook = new XSSFWorkbook();
        log.info("BgApplyBillDataImportPlugin_importData: initStyle ---- start time :" + this.getCurTime());
        this.initErrorBookStyle();
        this.initCellStyle();
        log.info("BgApplyBillDataImportPlugin_importData: initTemplateAndModel ---- start time :" + this.getCurTime());
        Map<String, DynamicObject> templateInfos = this.getTemplateInfos();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        HashMap<Long, List<Map<String, Object>>> importInfos = new HashMap<Long, List<Map<String, Object>>>(16);
        HashMap<Long, List> colInfos = new HashMap<Long, List>(16);
        HashMap<Long, List<String>> limitInputInfos = new HashMap<Long, List<String>>(16);
        HashMap<String, HashMap<Long, List<Object>>> retData = new HashMap<String, HashMap<Long, List<Object>>>(16);
        Long modelId = this.getModelId();
        Map varInfo = ReportVarUtil.getVarInfo((SchemeAssignDimGroup)this.getReportSchemeAssignGroup());
        log.info("BgApplyBillDataImportPlugin_importData: importDataInLoop ---- start time :" + this.getCurTime());
        int sheetSum = workbook.getNumberOfSheets();
        for (int i = 0; i < sheetSum; ++i) {
            int endTitleIndex;
            log.info("BgApplyBillDataImportPlugin_importData: import " + (i + 1) + "st sheet ---- start time :" + this.getCurTime());
            this.rowIndex = -1;
            XSSFSheet sheet = workbook.getSheetAt(i);
            if (ResManager.loadKDString((String)"\u7ef4\u5ea6\u8303\u56f4", (String)"BgApplyBillDataImportPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]).equals(sheet.getSheetName()) || this.isSheetEmpty(sheet)) continue;
            log.info("BgApplyBillDataImportPlugin_importData: checkTopLogo ---- start time :" + this.getCurTime());
            if (!this.checkTopLogo(sheet)) continue;
            log.info("BgApplyBillDataImportPlugin_importData: checkTemplate ---- start time :" + this.getCurTime());
            DynamicObject template = this.getCurrentTemplate(this.getCurrentRow(sheet), templateInfos);
            if (template == null) continue;
            Long dataSetId = template.getLong("dataset_id");
            log.info("BgApplyBillDataImportPlugin_importData: checkHideDim ---- start time :" + this.getCurTime());
            Map dimViewMap = modelCacheHelper.getViewsByDataSet(dataSetId);
            Map hiddenDimMemMap = BgApplyBillUtils.getInstance().getHiddenDimMemNumMap(template.getString("cachedata_tag"), dimViewMap, modelCacheHelper, varInfo);
            this.checkHiddenDimInfos(sheet, hiddenDimMemMap);
            log.info("BgApplyBillDataImportPlugin_importData: getMeasureOrCalCols ---- start time :" + this.getCurTime());
            HashMap<String, Map<String, String>> colDimMemInSheet = new HashMap<String, Map<String, String>>(16);
            Pair<Integer, Integer> rowPair = this.getMeasureOrCalCols(sheet, colDimMemInSheet);
            log.info("BgApplyBillDataImportPlugin_importData: getHideCols ---- start time :" + this.getCurTime());
            Long tempId = template.getLong("id");
            Map colTypes = ApplyTemplateColCfgService.getInstance().queryColCfgMapByTemplateId(tempId, FormTypeEnum.APPLY);
            List<String> hideCols = this.getConfigCols(colTypes, ColCfgPropEnum.HIDE);
            log.info("BgApplyBillDataImportPlugin_importData: getMainEntityInfoByTemplate ---- start time :" + this.getCurTime());
            Map entityInfo = BgApplyBillUtils.getInstance().getMainEntityInfoByTemplate(tempId, modelCacheHelper, varInfo);
            List colList = (List)entityInfo.get("col");
            ApplyTemplateUtils.getRateColumnAndUpFormula((List)colList, (Long)modelId);
            List measureColumns = colList.stream().filter(e -> e.getType() == ColumnEnum.Measure || e.getType() == ColumnEnum.DimensionData || ColumnEnum.Cal == e.getType()).collect(Collectors.toList());
            log.info("BgApplyBillDataImportPlugin_importData: getAllColDimMembers ---- start time :" + this.getCurTime());
            Map cols = BgApplyBillUtils.getInstance().getAllColDimMembers(measureColumns, dataSetId, modelCacheHelper, Boolean.valueOf(true));
            hideCols.forEach(cols::remove);
            log.info("BgApplyBillDataImportPlugin_importData: checkColMembers ---- start time :" + this.getCurTime());
            this.checkColMembers(sheet, cols, colDimMemInSheet, rowPair);
            HashMap<Integer, String> rowInfos = new HashMap<Integer, String>(16);
            log.info("BgApplyBillDataImportPlugin_importData: removeHideColumns ---- start time :" + this.getCurTime());
            List hideColumns = colList.stream().filter(e -> hideCols.contains(e.getKey())).collect(Collectors.toList());
            colList.removeAll(hideColumns);
            log.info("BgApplyBillDataImportPlugin_importData: dealRowInfos ---- start time :" + this.getCurTime());
            Boolean hasGroupTitle = this.dealRowInfos(sheet, colList, modelCacheHelper, rowInfos, (Integer)rowPair.p2);
            int n = endTitleIndex = hasGroupTitle != false ? (Integer)rowPair.p2 + 2 : (Integer)rowPair.p2 + 1;
            if (rowInfos.size() == 0 || rowInfos.size() != colList.size()) {
                this.recordErrorInfo(sheet, (Integer)rowPair.p2, endTitleIndex, ResManager.loadKDString((String)"\u5355\u636e\u5217\u5339\u914d\u5931\u8d25\u3002", (String)"BgApplyBillDataImportPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]), false);
                continue;
            }
            log.info("BgApplyBillDataImportPlugin_importData: getReadOnlyCols ---- start time :" + this.getCurTime());
            List<String> limitInputCols = this.getConfigCols(colTypes, ColCfgPropEnum.READONLY);
            log.info("BgApplyBillDataImportPlugin_importData: getImportData ---- start time :" + this.getCurTime());
            List<Map<String, Object>> importData = this.getImportData(sheet, rowInfos, colList, limitInputCols, modelCacheHelper, dataSetId, (Integer)rowPair.p2, endTitleIndex, template);
            importInfos.put(tempId, importData);
            colInfos.put(tempId, colList);
            limitInputInfos.put(tempId, limitInputCols);
            log.info("BgApplyBillDataImportPlugin_importData: import " + (i + 1) + "st sheet ---- end time :" + this.getCurTime());
        }
        if (this.errorBook.getNumberOfSheets() != 0) {
            String errFileName = ResManager.loadKDString((String)"\u7533\u62a5\u5355\u636e-\u5bfc\u5165\u6570\u636e\u9519\u8bef\u8be6\u60c5", (String)"BgApplyBillDataImportPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.downLoadFailFile(errFileName, true);
        } else {
            retData.put("importData", importInfos);
            retData.put("colInfo", colInfos);
            retData.put("limitCol", limitInputInfos);
            this.getView().returnDataToParent(retData);
            this.getView().close();
        }
    }

    private List<String> getConfigCols(Map<ColCfgPropTypeEnum, Map<String, ColCfgPropEnum>> colTypes, ColCfgPropEnum type) {
        return CentralAppBillService.getInstance().getConfigCols(colTypes, type);
    }

    private List<Map<String, Object>> getImportData(XSSFSheet sheet, Map<Integer, String> rowInfos, List<BaseColumn> colList, List<String> limitInputCols, IModelCacheHelper modelCacheHelper, Long dataSetId, int startTitleIndex, int endTitleIndex, DynamicObject template) {
        ArrayList<Map<String, Object>> importData = new ArrayList<Map<String, Object>>(16);
        HashMap<String, Set<String>> dimMemberRange = new HashMap<String, Set<String>>(16);
        Map<String, BaseColumn> colInfos = this.dealColList(colList);
        log.info("BgApplyBillDataImportPlugin_importData: getImportData ---- getRelationDimInfo ---- start time :" + this.getCurTime());
        List applyTemplateBizRanges = ApplyTemplateDimRangeService.getInstance().getApplytemplateDimRange(Long.valueOf(template.getLong("id")), dataSetId, modelCacheHelper.getModelobj().getId());
        Set<RowDimensionColumn> rowDimensionColumns = colList.stream().filter(e -> e instanceof RowDimensionColumn).map(e -> (RowDimensionColumn)e).collect(Collectors.toSet());
        Map<String, Map<String, Object>> relationDimInfo = this.getRelationDimInfo(colList);
        String[] dimensionNums = modelCacheHelper.getDimensionNums(dataSetId);
        Map viewIds = modelCacheHelper.getViewsByDataSet(dataSetId);
        log.info("BgApplyBillDataImportPlugin_importData: getImportData ---- getRelationDimInfo ---- end time :" + this.getCurTime());
        log.info("BgApplyBillDataImportPlugin_importData: getImportData ---- relationDimNum : " + relationDimInfo.size());
        int lastRowNum = sheet.getLastRowNum();
        log.info("BgApplyBillDataImportPlugin_importData: getImportData ---- sheetRowNum : " + lastRowNum);
        for (int i = endTitleIndex + 1; i <= lastRowNum; ++i) {
            XSSFRow row = sheet.getRow(i);
            if (this.isRowEmpty(row)) continue;
            log.info("BgApplyBillDataImportPlugin_importData: getImportData ---- loop : " + (i - endTitleIndex) + " ---- start time :" + this.getCurTime());
            HashMap<String, Object> data = new HashMap<String, Object>(16);
            HashMap<String, Map<String, Object>> relateDimInfo = new HashMap<String, Map<String, Object>>(relationDimInfo);
            for (Map.Entry<Integer, String> rowInfo : rowInfos.entrySet()) {
                Member member;
                String dimNumber;
                Integer colIndex = rowInfo.getKey();
                String key = rowInfo.getValue();
                BaseColumn column = colInfos.get(key);
                XSSFCell cell = row.getCell(colIndex.intValue());
                String cellValue = this.getCellValue(cell, colIndex);
                if (limitInputCols.contains(key)) continue;
                if (StringUtils.isEmpty((String)cellValue)) {
                    if (!column.getIsmustinput().booleanValue() || column instanceof RelationDimensionColumn || column instanceof RowDimensionColumn && ((RowDimensionColumn)column).getEnableDimensionRelation().booleanValue()) continue;
                    this.recordDataErrorInfo(sheet, row, startTitleIndex, endTitleIndex, ResManager.loadResFormat((String)"\u7b2c%1\u5217\u4e3a\u5fc5\u586b\u5217\uff0c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BgApplyBillDataImportPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[]{colIndex + 1}));
                    continue;
                }
                if (column instanceof RelationDimensionColumn) continue;
                if (column instanceof DimensionColumn && this.checkMemberRange((DimensionColumn)column, row, dimMemberRange, modelCacheHelper, dataSetId, cellValue, startTitleIndex, endTitleIndex).booleanValue()) {
                    dimNumber = ((DimensionColumn)column).getDimNumber();
                    if (!this.isDetailMember(cellValue, modelCacheHelper, dimNumber, (Long)viewIds.get(dimNumber))) {
                        this.recordDataErrorInfo(sheet, row, startTitleIndex, endTitleIndex, ResManager.loadResFormat((String)"\u7ef4\u5ea6%1\u5b58\u5728\u975e\u660e\u7ec6\u6210\u5458%2\u3002", (String)"BgApplyBillDataImportPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[]{dimNumber, cellValue}));
                        continue;
                    }
                    if (this.checkRelationDimension(relateDimInfo, (DimensionColumn)column, cellValue)) {
                        Date curTime = this.getCurTime();
                        this.saveRelationDimMember(relateDimInfo, viewIds, data, row, modelCacheHelper, startTitleIndex, endTitleIndex);
                        log.info("BgApplyBillDataImportPlugin_importData: getImportData ---- saveRelationDimMember ---- cost time : " + (this.getCurTime().getTime() - curTime.getTime()) + "ms");
                    }
                    if ((member = modelCacheHelper.getMember(dimNumber, (Long)viewIds.get(dimNumber), cellValue)) == null) {
                        this.recordErrorInfo(sheet, row, ResManager.loadResFormat((String)"\u672a\u627e\u5230%1\u7ef4\u5ea6\u6210\u5458%2\u3002", (String)"BgApplyBillDataImportPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{dimNumber, cellValue}));
                        continue;
                    }
                    data.put(key, member.getId());
                    continue;
                }
                if (column instanceof RowDimensionColumn) {
                    dimNumber = ((RowDimensionColumn)column).getDimNumber();
                    if (!this.isDetailMember(cellValue, modelCacheHelper, dimNumber, (Long)viewIds.get(dimNumber))) {
                        this.recordDataErrorInfo(sheet, row, startTitleIndex, endTitleIndex, ResManager.loadResFormat((String)"\u7ef4\u5ea6%1\u5b58\u5728\u975e\u660e\u7ec6\u6210\u5458%2\u3002", (String)"BgApplyBillDataImportPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[]{dimNumber, cellValue}));
                        continue;
                    }
                    member = modelCacheHelper.getMember(dimNumber, (Long)viewIds.get(dimNumber), cellValue);
                    if (member == null) {
                        this.recordErrorInfo(sheet, row, ResManager.loadResFormat((String)"\u672a\u627e\u5230%1\u7ef4\u5ea6\u6210\u5458%2\u3002", (String)"BgApplyBillDataImportPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{dimNumber, cellValue}));
                        continue;
                    }
                    data.put(key, member.getId());
                    continue;
                }
                data.put(key, this.getValueByColumnType(sheet, row, column, cellValue));
            }
            log.info("BgApplyBillDataImportPlugin_importData: getImportData ---- loop : " + (i - endTitleIndex) + " ---- end time :" + this.getCurTime());
            this.checkCollectColumnInBizRange(data, applyTemplateBizRanges, rowDimensionColumns);
            if (!this.contains(importData, data)) {
                importData.add(data);
                continue;
            }
            this.recordErrorInfo(sheet, row, ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6570\u636e\u4e2d\u5b58\u5728\u91cd\u590d\u6570\u636e\u3002", (String)"BgApplyBillDataImportPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        log.info("BgApplyBillDataImportPlugin_importData: getImportData ---- end time :" + this.getCurTime());
        return importData;
    }

    private void checkCollectColumnInBizRange(Map<String, Object> curRowData, List<ApplyTemplateBizRange> applyTemplateBizRanges, Set<RowDimensionColumn> rowDimensionColumns) {
        if (CollectionUtils.isEmpty(rowDimensionColumns) || CollectionUtils.isEmpty(applyTemplateBizRanges)) {
            return;
        }
        List<Object> bizRanges = new ArrayList<ApplyTemplateBizRange>(applyTemplateBizRanges);
        for (RowDimensionColumn column : rowDimensionColumns) {
            Object data = curRowData.get(column.getKey());
            if (!(data instanceof Long)) continue;
            Long memberId = (Long)data;
            bizRanges = ApplyTemplateDimRangeService.getInstance().compareMemberId(bizRanges, column.getDimNumber(), memberId);
        }
        if (!bizRanges.isEmpty()) {
            Set<String> budgetSumFieldKeys = bizRanges.stream().map(ApplyTemplateBizRange::getBudgetSumFieldKey).collect(Collectors.toSet());
            budgetSumFieldKeys.forEach(curRowData::remove);
        }
    }

    private Object getValueByColumnType(XSSFSheet sheet, XSSFRow row, BaseColumn column, String cellValue) {
        String retValue = "";
        FieldTypeEnum fieldType = column.getFieldtype();
        switch (fieldType) {
            case EnumField: {
                if (column instanceof MeasureColumn || column instanceof DimensionDataColumn) {
                    List enumData = column.getEnumdata();
                    if (enumData == null) {
                        this.recordErrorInfo(sheet, row, ResManager.loadResFormat((String)"\u5ea6\u91cf\u5217%1\u4e2d\u4e0d\u5b58\u5728\u679a\u4e3e\u3002", (String)"BgApplyBillDataImportPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[]{column.getTitle()}));
                        break;
                    }
                    for (ComboItem enumDatum : enumData) {
                        String enumValue = enumDatum.getValue();
                        if (enumValue.equals(cellValue)) {
                            retValue = cellValue;
                            break;
                        }
                        String enumName = (String)enumDatum.getCaption().get((Object)LanguageUtils.getLang((Lang)Lang.zh_CN).toString());
                        if (!cellValue.equals(enumName)) continue;
                        retValue = enumValue;
                        break;
                    }
                    if (retValue != "") break;
                    this.recordErrorInfo(sheet, row, ResManager.loadResFormat((String)"\u5ea6\u91cf\u5217%1\u4e2d\u4e0d\u5b58\u5728%2\u7684\u679a\u4e3e\u3002", (String)"BgApplyBillDataImportPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[]{column.getTitle(), cellValue}));
                    break;
                }
                if (!(column instanceof EnumColumn)) break;
                retValue = cellValue;
                break;
            }
            case Date: {
                Date dateValue = this.getDateValue(sheet, row, cellValue);
                if (dateValue == null) break;
                retValue = new Timestamp(dateValue.getTime()).toString();
                break;
            }
            default: {
                retValue = cellValue;
            }
        }
        return retValue;
    }

    private Date getDateValue(XSSFSheet sheet, XSSFRow row, String cellValue) {
        Date date = DateTimeUtils.parseToDate((String)cellValue, (Boolean)true);
        if (date == null) {
            this.recordErrorInfo(sheet, row, ResManager.loadResFormat((String)"\u65f6\u95f4\u89e3\u6790\u5931\u8d25\uff1a%1\u3002", (String)"BgApplyBillDataImportPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[]{cellValue}));
        }
        return date;
    }

    private boolean contains(List<Map<String, Object>> importData, Map<String, Object> data) {
        boolean contains = false;
        for (Map<String, Object> importDatum : importData) {
            if (importDatum.size() != data.size() || !this.containsAll(importDatum, data)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    private boolean isDetailMember(String cellValue, IModelCacheHelper modelCacheHelper, String dimNumber, Long viewId) {
        Member member = modelCacheHelper.getMember(dimNumber, viewId, cellValue);
        return member.isLeaf();
    }

    private void saveRelationDimMember(Map<String, Map<String, Object>> relateDimInfos, Map<String, Long> viewIds, Map<String, Object> data, XSSFRow row, IModelCacheHelper modelCacheHelper, int startTitleIndex, int endTitleIndex) {
        for (Map.Entry<String, Map<String, Object>> relateDimInfo : relateDimInfos.entrySet()) {
            String key = relateDimInfo.getKey();
            Map<String, Object> value = relateDimInfo.getValue();
            List<String> relateDims = (List<String>)value.get("relateDims");
            ArrayList tmp = null;
            String memberTreeModel = value.get("memberTreeModel").toString();
            HashMap<String, Object> relateDimMember = new HashMap<String, Object>(16);
            if (!"epm_multidimmemrelation".equals(memberTreeModel)) {
                Object number = value.get("number");
                tmp = new ArrayList(relateDims);
                relateDims = Collections.singletonList(number.toString());
            }
            if (!this.checkHasAllRelateDims(value, relateDims, relateDimMember)) continue;
            String dimNumber = value.get("number").toString();
            if (!"epm_multidimmemrelation".equals(memberTreeModel) && tmp != null) {
                dimNumber = (String)tmp.get(0);
            }
            List relationMembers = (List)value.get("relateMembers");
            Date curTime = this.getCurTime();
            Long relateDimensionValue = this.getRelateDimensionValue(relationMembers, memberTreeModel, relateDimMember, dimNumber);
            log.info("BgApplyBillDataImportPlugin_importData: getImportData ---- getRelateDimensionValue ---- cost time : " + (this.getCurTime().getTime() - curTime.getTime()) + "ms");
            if (relateDimensionValue == null || relateDimensionValue == 0L) {
                this.recordDataErrorInfo(row.getSheet(), row, startTitleIndex, endTitleIndex, ResManager.loadResFormat((String)"\u672a\u627e\u5230\u6210\u5458\u201c%1\u201d\u6620\u5c04\u7684\u6210\u5458\u3002", (String)"BgApplyBillDataImportPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)",", relateDims)}));
                continue;
            }
            Long curDimensionId = ConvertUtils.toLong((Object)value.get("curDimensionId"));
            Dimension dimension = modelCacheHelper.getDimension(curDimensionId);
            if (dimension == null) {
                this.recordDataErrorInfo(row.getSheet(), row, startTitleIndex, endTitleIndex, ResManager.loadResFormat((String)"\u672a\u627e\u5230\u7ef4\u5ea6\uff0cID\u201c%1\u201d\u3002", (String)"BgApplyBillDataImportPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[]{curDimensionId}));
                continue;
            }
            Member member = dimension.getMember(viewIds.get(dimension.getNumber()), relateDimensionValue);
            if (member == null) {
                this.recordDataErrorInfo(row.getSheet(), row, startTitleIndex, endTitleIndex, ResManager.loadResFormat((String)"\u672a\u627e\u5230\u7ef4\u5ea6\u201c%1\u201d\u7684\u6210\u5458\u201c%2\u201d\u3002", (String)"BgApplyBillDataImportPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension.getName(), relateDimensionValue}));
                continue;
            }
            data.put(key, relateDimensionValue);
        }
    }

    private Long getRelateDimensionValue(List<DynamicObject> relationMembers, String memberTreeModel, Map<String, Object> relateDimMember, String dimNumber) {
        Long relateDimensionValue = null;
        relateDimensionValue = "epm_multidimmemrelation".equals(memberTreeModel) ? this.getMultiRelateDimValue(relationMembers, relateDimMember, dimNumber) : this.getRelateDimensionValue(relationMembers, relateDimMember, dimNumber);
        return relateDimensionValue;
    }

    private Long getMultiRelateDimValue(List<DynamicObject> relationMembers, Map<String, Object> relateDimMember, String dimNumber) {
        Long relateDimValue = null;
        Long singleRelateDimValue = null;
        if (relationMembers != null) {
            for (DynamicObject relateMember : relationMembers) {
                DynamicObjectCollection entryEntity = relateMember.getDynamicObjectCollection("entryentity");
                HashMap<String, Object> dimMembers = new HashMap<String, Object>(16);
                ArrayList mainDimMemId = new ArrayList(16);
                entryEntity.forEach(e -> {
                    String dimension = e.getString("dimension");
                    if (dimNumber.equals(dimension)) {
                        mainDimMemId.add(e.getLong("memberid"));
                    } else {
                        dimMembers.put(dimension, e.getString("membernum"));
                    }
                });
                if (dimMembers.size() > relateDimMember.size() || mainDimMemId.size() != 1) continue;
                if (this.containsAll(dimMembers, relateDimMember)) {
                    relateDimValue = (Long)mainDimMemId.get(0);
                    continue;
                }
                if (!this.containSingle(dimMembers, relateDimMember)) continue;
                singleRelateDimValue = (Long)mainDimMemId.get(0);
            }
        }
        log.info("BgApplyBillDataImportPlugin_importData: getMultiRelateDimValue ---- relateDimValue " + relateDimValue + " singleRelateDimValue " + singleRelateDimValue);
        return relateDimValue == null ? singleRelateDimValue : relateDimValue;
    }

    private boolean containSingle(Map<String, Object> dimMembers, Map<String, Object> relateDimMembers) {
        boolean containsOne = true;
        for (Map.Entry<String, Object> relateDimMember : relateDimMembers.entrySet()) {
            String dimMemberKey = relateDimMember.getKey();
            Object dimMemberValue = relateDimMember.getValue();
            Object value = dimMembers.get(dimMemberKey);
            if (value == null || !StringUtils.isNotEmpty((String)value.toString()) || dimMemberValue.equals(value)) continue;
            containsOne = false;
            break;
        }
        return containsOne;
    }

    private boolean containsAll(Map<String, Object> dimMembers, Map<String, Object> relateDimMembers) {
        boolean containsAll = true;
        for (Map.Entry<String, Object> relateDimMember : relateDimMembers.entrySet()) {
            String dimMemberKey = relateDimMember.getKey();
            Object dimMemberValue = relateDimMember.getValue();
            Object value = dimMembers.get(dimMemberKey);
            if (dimMemberValue != null && dimMemberValue.equals(value)) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    private Long getRelateDimensionValue(List<DynamicObject> relationMembers, Map<String, Object> relateDimMembers, String dimNumber) {
        Long relateDimValue = null;
        if (relateDimMembers.size() == 1 && relationMembers != null && relationMembers.size() != 0) {
            Map.Entry<String, Object> relateDimMember = relateDimMembers.entrySet().iterator().next();
            String dimMemberKey = relateDimMember.getKey();
            String selectFieldKey1 = this.getSelectKey(dimMemberKey);
            String selectFieldKey2 = this.getSelectKey(dimNumber);
            if (StringUtils.isEmpty((String)selectFieldKey1) || StringUtils.isEmpty((String)selectFieldKey2)) {
                return null;
            }
            for (DynamicObject relationMember : relationMembers) {
                String relate = relationMember.getString("number");
                if (relate == null || !relate.equals(relateDimMember.getValue())) continue;
                relateDimValue = relationMember.getLong(selectFieldKey2);
            }
        }
        return relateDimValue;
    }

    private String getSelectKey(String dimMemberKey) {
        String[] keys = dimMemberKey.split("_");
        if (keys.length != 2) {
            return null;
        }
        String selectKey = null;
        SysDimensionEnum enumByNumber = SysDimensionEnum.getEnumByNumber((String)keys[0]);
        selectKey = enumByNumber == null ? "customdim" + keys[1] : enumByNumber.getNumber().toLowerCase();
        return selectKey;
    }

    private boolean checkRelationDimension(Map<String, Map<String, Object>> relateDimInfos, DimensionColumn column, String cellValue) {
        boolean hasRelateDimension = false;
        String dimNumber = column.getDimNumber();
        for (Map.Entry<String, Map<String, Object>> relateDimInfo : relateDimInfos.entrySet()) {
            Map<String, Object> relateDimDetails = relateDimInfo.getValue();
            Object memberTreeModel = relateDimDetails.get("memberTreeModel");
            if (memberTreeModel == null) continue;
            if ("epm_multidimmemrelation".equals(memberTreeModel.toString())) {
                List relateDims = (List)relateDimDetails.get("relateDims");
                if (!relateDims.contains(dimNumber)) continue;
                relateDimDetails.put(dimNumber, cellValue);
                if (!this.checkHasAllRelateDims(relateDimDetails, relateDims, new HashMap<String, Object>(16))) continue;
                hasRelateDimension = true;
                break;
            }
            Object number = relateDimDetails.get("number");
            String relateNumber = dimNumber + "_1";
            hasRelateDimension = relateNumber.equals(number.toString());
            if (!hasRelateDimension) continue;
            relateDimDetails.put(relateNumber, cellValue);
        }
        return hasRelateDimension;
    }

    private boolean checkHasAllRelateDims(Map<String, Object> relateDimDetails, List<String> relateDims, Map<String, Object> relateDimMember) {
        boolean hasAllRelateDims = true;
        for (String relateDim : relateDims) {
            Object dim = relateDimDetails.get(relateDim);
            if (dim == null) {
                hasAllRelateDims = false;
                break;
            }
            relateDimMember.put(relateDim, dim.toString());
        }
        return hasAllRelateDims;
    }

    private Map<String, Map<String, Object>> getRelationDimInfo(List<BaseColumn> colList) {
        HashMap<String, Map<String, Object>> relationDimInfo = new HashMap<String, Map<String, Object>>(16);
        for (BaseColumn column : colList) {
            if (!(column instanceof RelationDimensionColumn)) continue;
            HashMap<String, Object> info = new HashMap<String, Object>(16);
            RelationDimensionColumn relateDimColumn = (RelationDimensionColumn)column;
            String relationTreeModel = relateDimColumn.getDimensionrelationidtype();
            long relateDimension = relateDimColumn.getRelationDimensionId();
            long relation = relateDimColumn.getDimensionBussSchemeId();
            Pair<String, List<String>> relateDims = this.getRelateDims(relationTreeModel, relation, relateDimension);
            if (relateDims != null) {
                info.put("relateMembers", this.getRelateMember(relationTreeModel, relateDims, relation));
                info.put("relateDims", relateDims.p2);
                info.put("number", relateDims.p1);
            }
            info.put("memberTreeModel", this.getMemberTreeModel(relationTreeModel));
            info.put("curDimensionId", relateDimColumn.getDimensionId());
            relationDimInfo.put(relateDimColumn.getKey(), info);
        }
        return relationDimInfo;
    }

    private List<DynamicObject> getRelateMember(String relationTreeModel, Pair<String, List<String>> relateDims, long relation) {
        DynamicObject[] relateMembers = null;
        relateMembers = "epm_multidimrelation".equals(relationTreeModel) ? this.getMultiRelateMembers(relation) : this.getRelateMembers(relateDims, relation);
        return relateMembers == null ? new ArrayList(16) : Arrays.asList(relateMembers);
    }

    private DynamicObject[] getMultiRelateMembers(long relation) {
        String sql = "entryentity.dimension, entryentity.membernum, entryentity.memberid";
        QFilter qFilter = new QFilter("relationid", "=", (Object)relation);
        DynamicObject[] relateMembers = BusinessDataServiceHelper.load((String)"epm_multidimmemrelation", (String)sql, (QFilter[])new QFilter[]{qFilter});
        if (relateMembers == null) {
            return new DynamicObject[0];
        }
        return relateMembers;
    }

    private DynamicObject[] getRelateMembers(Pair<String, List<String>> relateDims, long relation) {
        DynamicObjectCollection relationInfo;
        String dimNumber = (String)((List)relateDims.p2).get(0);
        String dimMemberKey = (String)relateDims.p1;
        String selectFieldKey1 = this.getSelectKey(dimMemberKey);
        String selectFieldKey2 = this.getSelectKey(dimNumber);
        if (StringUtils.isEmpty((String)selectFieldKey1) || StringUtils.isEmpty((String)selectFieldKey2)) {
            return null;
        }
        String tableModel = "t_eb_structofdefined";
        SysDimensionEnum sysDimensionEnum = SysDimensionEnum.getEnumByNumberIgnoreCase((String)selectFieldKey1);
        if (sysDimensionEnum != null) {
            tableModel = sysDimensionEnum.getMemberTreetable();
        }
        String sql = "select relate.fdimension1 as %s, relate.fdimension2 as %s, member.fnumber as number from t_eb_dimmemberrelation as relate left join %s as member on relate.fdimension1 = member.fid where relate.frelationid = %s";
        try (DataSet ds = DB.queryDataSet((String)"queryRelate", (DBRoute)DBRoute.of((String)"epm"), (String)String.format(sql, selectFieldKey1, selectFieldKey2, tableModel, relation));){
            relationInfo = ORMUtil.toDynamicObjectCollection((DataSet)ds, (String)"epm_dimmemberrelation");
        }
        return (DynamicObject[])relationInfo.toArray((Object[])new DynamicObject[0]);
    }

    private Pair<String, List<String>> getRelateDims(String relationTreeModel, long relation, long relateDimension) {
        Pair<String, List<String>> dimNums = "epm_multidimrelation".equals(relationTreeModel) ? this.getMultiRelateDims(relation) : this.getRelateDim(relation, relateDimension);
        return dimNums;
    }

    private Pair<String, List<String>> getMultiRelateDims(Long relation) {
        ArrayList<String> dims = new ArrayList<String>(16);
        String sql = "entryentity.dimension, entryentity.ismaindim";
        QFilter qFilter = new QFilter("id", "=", (Object)relation);
        DynamicObject relationInfo = BusinessDataServiceHelper.loadSingle((String)"epm_multidimrelation", (String)sql, (QFilter[])new QFilter[]{qFilter});
        if (relationInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6210\u5458\u6620\u5c04\u65b9\u6848\u83b7\u53d6\u5931\u8d25\u3002", (String)"BgApplyBillDataImportPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String mainDimNumber = null;
        DynamicObjectCollection entryEntity = relationInfo.getDynamicObjectCollection("entryentity");
        if (entryEntity == null || entryEntity.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6210\u5458\u6620\u5c04\u65b9\u6848\u83b7\u53d6\u5931\u8d25\u3002", (String)"BgApplyBillDataImportPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        for (DynamicObject entry : entryEntity) {
            String isMainDim = entry.getString("ismaindim");
            String dimNumber = entry.getString("dimension.number");
            if ("1".equals(isMainDim)) {
                mainDimNumber = dimNumber;
                continue;
            }
            dims.add(dimNumber);
        }
        return new Pair(mainDimNumber, dims);
    }

    private Pair<String, List<String>> getRelateDim(long relation, long relateDimension) {
        String select = "entryentity.dimension.number as dimnumber, entryentity.dimension.id as dimid, entryentity.seq";
        QFilter qFilter = new QFilter("id", "=", (Object)relation);
        DynamicObjectCollection relationInfo = QueryServiceHelper.query((String)"epm_dimensionrelation", (String)select, (QFilter[])new QFilter[]{qFilter});
        if (relationInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u6210\u5458\u5173\u7cfb\u65b9\u6848\u5931\u8d25\u3002", (String)"BgApplyBillDataImportPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String num1 = null;
        String num2 = null;
        long dimensionId = 0L;
        for (DynamicObject dynamicObject : relationInfo) {
            int seq = dynamicObject.getInt("entryentity.seq");
            if (seq == 1) {
                num1 = dynamicObject.getString("dimnumber");
                dimensionId = dynamicObject.getLong("dimid");
                continue;
            }
            num2 = dynamicObject.getString("dimnumber");
        }
        if (dimensionId == relateDimension) {
            return new Pair((Object)(num1 + "_1"), Collections.singletonList(num2 + "_2"));
        }
        return new Pair((Object)(num2 + "_2"), Collections.singletonList(num1 + "_1"));
    }

    private String getMemberTreeModel(String relationTreeModel) {
        if ("epm_multidimrelation".equals(relationTreeModel)) {
            return "epm_multidimmemrelation";
        }
        return "epm_dimmemberrelation";
    }

    private Boolean checkMemberRange(DimensionColumn column, XSSFRow row, Map<String, Set<String>> dimMemberRange, IModelCacheHelper modelCacheHelper, Long dataSetId, String cellValue, int startTitleIndex, int endTitleIndex) {
        Date curTime = this.getCurTime();
        String number = column.getDimNumber();
        Set<String> memNumbers = dimMemberRange.get(number);
        if (memNumbers == null || memNumbers.size() == 0) {
            memNumbers = new HashSet<String>(BgApplyBillUtils.getInstance().getMemberRanges(column.getDimensionMemberRanges(), modelCacheHelper, dataSetId, number));
            dimMemberRange.put(number, memNumbers);
        }
        if (!memNumbers.contains(cellValue)) {
            this.recordDataErrorInfo(row.getSheet(), row, startTitleIndex, endTitleIndex, ResManager.loadResFormat((String)"%1\u7ef4\u7684\u6210\u5458%2\u4e0d\u5728\u6a21\u677f\u8bbe\u7f6e\u7684\u7ef4\u5ea6\u8303\u56f4\u6216\u4e1a\u52a1\u6a21\u578b\u5185\u3002", (String)"BgApplyBillDataImportPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[]{number, cellValue}));
            return false;
        }
        log.info("BgApplyBillDataImportPlugin_importData: getImportData ---- checkMemberRange ---- cost time : " + (this.getCurTime().getTime() - curTime.getTime()) + "ms");
        return true;
    }

    private Map<String, BaseColumn> dealColList(List<BaseColumn> colList) {
        HashMap<String, BaseColumn> colInfos = new HashMap<String, BaseColumn>(16);
        colList.forEach(e -> colInfos.put(e.getKey(), (BaseColumn)e));
        return colInfos;
    }

    private Boolean dealRowInfos(XSSFSheet sheet, List<BaseColumn> colList, IModelCacheHelper modelCacheHelper, Map<Integer, String> rowInfos, Integer rowIndex) {
        boolean hasGroupTitle = false;
        XSSFRow row = sheet.getRow(rowIndex.intValue());
        int lastCellNum = row.getLastCellNum();
        log.info("BgApplyBillDataImportPlugin_importData: dealRowInfos ---- cellNum : " + lastCellNum + " ---- start time :" + this.getCurTime());
        for (int i = 0; i < lastCellNum; ++i) {
            String key;
            log.info("BgApplyBillDataImportPlugin_importData: dealRowInfos ---- loop : " + (i + 1) + " ---- start time :" + this.getCurTime());
            XSSFCell cell = row.getCell(i);
            log.info("BgApplyBillDataImportPlugin_importData: dealRowInfos ---- getCellValue ---- start time :" + this.getCurTime());
            String cellValue = this.getCellValue(cell, i);
            if (StringUtils.isEmpty((String)cellValue)) continue;
            String[] split = cellValue.split("\\.");
            cellValue = split[0];
            log.info("BgApplyBillDataImportPlugin_importData: dealRowInfos ---- getColumnByNumber ---- start time :" + this.getCurTime());
            BaseColumn column = this.getColumnByNumber(colList, modelCacheHelper, cellValue);
            if (column == null) continue;
            if (StringUtils.isNotEmpty((String)column.getGrouptitle())) {
                hasGroupTitle = true;
            }
            if (!rowInfos.containsValue(key = column.getKey())) {
                rowInfos.put(i, key);
            }
            log.info("BgApplyBillDataImportPlugin_importData: dealRowInfos ---- loop : " + (i + 1) + " ---- end time :" + this.getCurTime());
        }
        return hasGroupTitle;
    }

    private BaseColumn getColumnByNumber(List<BaseColumn> colList, IModelCacheHelper modelCacheHelper, String cellValue) {
        for (BaseColumn column : colList) {
            if (column.getKey().equals(cellValue)) {
                return column;
            }
            String number = null;
            if (column instanceof DimensionColumn) {
                number = ((DimensionColumn)column).getDimNumber();
            } else if (column instanceof RelationDimensionColumn) {
                number = BgApplyBillUtils.getInstance().getRelationDimensionNumber((RelationDimensionColumn)column, modelCacheHelper);
            } else if (column instanceof RowDimensionColumn) {
                number = ((RowDimensionColumn)column).getDimNumber();
            }
            if (!StringUtils.isNotEmpty((String)number) || !cellValue.equals(number)) continue;
            return column;
        }
        return null;
    }

    private void checkColMembers(XSSFSheet sheet, Map<String, Map<String, String>> cols, Map<String, Map<String, String>> colDimMemInSheet, Pair<Integer, Integer> rowPair) {
        int startRow = (Integer)rowPair.p1;
        int endRow = (Integer)rowPair.p2 - 1;
        if (cols.size() != colDimMemInSheet.size()) {
            this.recordErrorInfo(sheet, startRow, endRow, ResManager.loadKDString((String)"\u5ea6\u91cf\u5217\u4e0e\u8ba1\u7b97\u5217\u6570\u91cf\u4e0d\u4e00\u81f4\u3002", (String)"BgApplyBillDataImportPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]), true);
        }
        block0: for (Map.Entry<String, Map<String, String>> col : cols.entrySet()) {
            String rowKey = col.getKey();
            Map<String, String> colDimMembers = colDimMemInSheet.get(rowKey);
            if (colDimMembers == null) continue;
            for (Map.Entry<String, String> entry : col.getValue().entrySet()) {
                String key = entry.getKey();
                if (colDimMembers.get(key).equals(entry.getValue())) continue;
                this.recordErrorInfo(sheet, startRow, endRow, ResManager.loadResFormat((String)"%1\u5217\u4e2d%2\u7ef4\u6210\u5458\u672a\u5339\u914d\u3002", (String)"BgApplyBillDataImportPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[]{rowKey, key}), true);
                continue block0;
            }
        }
    }

    private Pair<Integer, Integer> getMeasureOrCalCols(XSSFSheet sheet, Map<String, Map<String, String>> colDimMemInSheet) {
        int endRow = 999;
        XSSFRow row = this.getCurrentRow(sheet);
        int startRow = this.getCurrentRowIndex();
        int startCol = row.getFirstCellNum();
        short endCol = row.getLastCellNum();
        HashMap<Integer, String> dimMap = new HashMap<Integer, String>(16);
        for (int i = startCol; i < endCol; ++i) {
            String key = null;
            HashMap<String, String> dimMembers = new HashMap<String, String>(16);
            for (int j = startRow + 1; j <= endRow; ++j) {
                XSSFCell cell;
                String value;
                XSSFRow colRow = sheet.getRow(j);
                if (this.isRowEmpty(row) || StringUtils.isEmpty((String)(value = this.getCellValue(cell = colRow.getCell(i), i)))) continue;
                String splitNumber = this.getSplitNumber(value);
                if (StringUtils.isEmpty((String)splitNumber)) {
                    key = value;
                    endRow = j;
                    break;
                }
                value = splitNumber;
                String dim = (String)dimMap.get(j);
                if (StringUtils.isEmpty((String)dim)) {
                    dimMap.put(j, value);
                    continue;
                }
                dimMembers.put(dim, value);
            }
            if (dimMembers.size() == 0 || !StringUtils.isNotEmpty(key)) continue;
            colDimMemInSheet.put(key, dimMembers);
        }
        return new Pair((Object)startRow, (Object)endRow);
    }

    private void checkHiddenDimInfos(XSSFSheet sheet, Map<String, String> hiddenDimMemMap) {
        XSSFRow dimRow = this.getCurrentRow(sheet);
        int startRow = this.getCurrentRowIndex();
        XSSFRow memRow = this.getCurrentRow(sheet);
        int endRow = this.getCurrentRowIndex();
        boolean isSame = true;
        int lastCellNum = dimRow.getLastCellNum();
        if (lastCellNum == hiddenDimMemMap.size() + 1) {
            for (int i = 1; i < lastCellNum; ++i) {
                XSSFCell dimCell = dimRow.getCell(i);
                XSSFCell memCell = memRow.getCell(i);
                String dimNum = this.getSplitNumber(this.getCellValue(dimCell, i));
                String memNum = this.getSplitNumber(this.getCellValue(memCell, i));
                String hiddenMem = hiddenDimMemMap.get(dimNum);
                if (!StringUtils.isEmpty((String)hiddenMem) && hiddenMem.equals(memNum)) continue;
                isSame = false;
                break;
            }
        } else {
            isSame = false;
        }
        if (!isSame) {
            String dimInfoString = hiddenDimMemMap.entrySet().stream().map(e -> (String)e.getKey() + ": " + (String)e.getValue()).collect(Collectors.joining(" | "));
            this.recordErrorInfo(sheet, startRow, endRow, ResManager.loadResFormat((String)"\u9690\u85cf\u7ef4\u53ca\u6210\u5458\u4fe1\u606f\u5339\u914d\u4e0d\u6210\u529f\uff08\u6b63\u786e\u7684\u9690\u85cf\u7ef4\u6210\u5458\u4fe1\u606f\uff1a%1\uff09\u3002", (String)"BgApplyBillDataImportPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[]{dimInfoString}), false);
        }
    }

    private String getSplitNumber(String number) {
        String[] split = number.split("#");
        if (split.length != 2) {
            return "";
        }
        return split[1];
    }

    private DynamicObject getCurrentTemplate(XSSFRow row, Map<String, DynamicObject> templateInfos) {
        XSSFCell cell;
        String tempNum;
        DynamicObject template = null;
        if (this.existValueInRow(row, 1) && StringUtils.isNotEmpty((String)(tempNum = this.getCellValue(cell = row.getCell(1), 1)))) {
            template = templateInfos.get(tempNum);
        }
        if (template == null) {
            this.recordErrorInfo(row.getSheet(), row, ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u6a21\u677f", (String)"BgApplyBillDataImportPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return template;
    }

    private Map<String, DynamicObject> getTemplateInfos() {
        HashMap<String, DynamicObject> templateInfos = new HashMap<String, DynamicObject>(16);
        List<Long> templateIds = this.getTemplates();
        DynamicObject[] templates = BusinessDataServiceHelper.load((Object[])templateIds.toArray(new Long[0]), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"eb_applytemplate").getDynamicObjectType());
        if (templates != null) {
            for (DynamicObject template : templates) {
                String number = template.getString("number");
                templateInfos.put("#" + number + "#", template);
            }
        }
        return templateInfos;
    }

    private boolean isSheetEmpty(XSSFSheet sheet) {
        boolean isEmpty = false;
        if (sheet == null || sheet.getLastRowNum() == 0 && sheet.getPhysicalNumberOfRows() == 0) {
            isEmpty = true;
        } else {
            int firstRowNum = sheet.getFirstRowNum();
            int lastRowNum = sheet.getLastRowNum();
            for (int i = firstRowNum; i <= lastRowNum; ++i) {
                if (!this.isRowEmpty(sheet.getRow(i))) {
                    isEmpty = false;
                    break;
                }
                isEmpty = true;
            }
        }
        return isEmpty;
    }

    private boolean checkTopLogo(XSSFSheet sheet) {
        XSSFRow row = this.getCurrentRow(sheet);
        String cellValue = null;
        if (this.existValueInRow(row, 0)) {
            XSSFCell cell = row.getCell(0);
            cellValue = this.getCellValue(cell, 0);
        }
        if (!"#kingdee#".equals(cellValue)) {
            this.recordErrorInfo(sheet, row, ResManager.loadKDString((String)"\u201ckingdee\u201d\u5bfc\u5165\u6807\u8bc6\u9519\u8bef\u6216\u7f3a\u5931", (String)"BgApplyBillDataImportPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private XSSFRow getCurrentRow(XSSFSheet sheet) {
        XSSFRow row = sheet.getRow(++this.rowIndex);
        while (this.isRowEmpty(row)) {
            row = sheet.getRow(++this.rowIndex);
        }
        return row;
    }

    private int getCurrentRowIndex() {
        return this.rowIndex;
    }

    private void recordDataErrorInfo(XSSFSheet sheet, XSSFRow row, int startTitleNum, int endTitleNum, String errMsg) {
        int lastRowNum;
        XSSFSheet errBookSheet = this.getErrBookSheet(sheet);
        XSSFRow lastRow = errBookSheet.getRow(lastRowNum = errBookSheet.getLastRowNum());
        XSSFCell cell = lastRow.getCell(1);
        String cellValue = this.getCellValue(cell, 1);
        if (StringUtils.isEmpty((String)cellValue) || ResManager.loadKDString((String)"\u9519\u8bef\u884c", (String)"BgApplyBillDataImportPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]).equals(cellValue) || Integer.parseInt(cellValue.substring(1, cellValue.length() - 1)) < endTitleNum) {
            this.addTitleRows(row.getSheet(), startTitleNum + 1, endTitleNum);
        }
        this.recordErrorInfo(sheet, row, errMsg);
    }

    private String getBillNumber() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String billNo = (String)formShowParameter.getCustomParam("billNo");
        if (StringUtils.isEmpty((String)billNo)) {
            billNo = null;
        }
        return billNo;
    }

    private List<Long> getTemplates() {
        Map<String, Long> entryTemplateInfo = this.getEntryTemplateInfo();
        return new ArrayList<Long>(entryTemplateInfo.values());
    }

    private Map<String, Long> getEntryTemplateInfo() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String template = (String)formShowParameter.getCustomParam("templates");
        if (StringUtils.isEmpty((String)template)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\u3002", (String)"BgApplyBillDataImportPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return (Map)ObjectSerialUtil.deSerializedBytes((String)template);
    }

    private Map<Long, List<String>> getEnableCols() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String colConfig = (String)formShowParameter.getCustomParam("colConfig");
        if (StringUtils.isEmpty((String)colConfig)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801\u83b7\u53d6\u5931\u8d25\u3002", (String)"BgApplyBillDataImportPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return (Map)ObjectSerialUtil.deSerializedBytes((String)colConfig);
    }
}

