/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applybill.fileImport;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.utils.ImportAndExportUtil;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.applybill.SchemeAssignDimGroup;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class BgApplyBillImportBasePlugin
extends AbstractFormPlugin {
    protected XSSFWorkbook errorBook = null;
    protected CellStyle cellStyle = null;
    private static final Log log = LogFactory.getLog(BgApplyBillImportBasePlugin.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btndownload", "btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(this.showAddBtn()), new String[]{"newandcover"});
    }

    protected boolean showAddBtn() {
        return false;
    }

    protected boolean isAddAndUpdate() {
        String importType = (String)this.getValue("radiogroupfield", null);
        return "3".equals(importType);
    }

    protected SchemeAssignDimGroup getReportSchemeAssignGroup() {
        Object schemeAssignDimGroup = this.getView().getFormShowParameter().getCustomParam("schemeAssignDimGroup");
        if (schemeAssignDimGroup != null) {
            return (SchemeAssignDimGroup)SerializationUtils.deSerializeFromBase64((String)String.valueOf(schemeAssignDimGroup));
        }
        return new SchemeAssignDimGroup();
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btndownload": {
                this.downLoadTemplate();
                break;
            }
            case "btnok": {
                this.importData();
                break;
            }
        }
    }

    protected void downLoadTemplate() {
    }

    private void importData() {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanelap");
        List attachments = attachmentPanel.getAttachmentData();
        if (attachments.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u4e00\u4e2a\u5bfc\u5165\u6587\u4ef6\u3002", (String)"BgApplyBillImportBasePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        InputStream inputStream = this.getUploadFileInputStream((Map)attachments.get(0));
        if (inputStream == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u6587\u4ef6\u6d41\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BgApplyBillImportBasePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.preImportFileData();
        try {
            this.importFileData(inputStream);
            inputStream.close();
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
    }

    protected void preImportFileData() {
        this.errorBook = new XSSFWorkbook();
        this.initErrorBookStyle();
        this.initCellStyle();
    }

    protected void initErrorBookStyle() {
        XSSFCellStyle style = this.errorBook.createCellStyle();
        style.setAlignment(HorizontalAlignment.LEFT);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
    }

    protected void initCellStyle() {
        this.cellStyle = this.errorBook.createCellStyle();
        XSSFFont font = this.errorBook.createFont();
        font.setColor(IndexedColors.RED.getIndex());
        this.cellStyle.setFont((Font)font);
        this.cellStyle.setAlignment(HorizontalAlignment.LEFT);
        this.cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
    }

    private InputStream getUploadFileInputStream(Map<String, Object> attachment) {
        this.checkFileType(attachment.get("name").toString());
        String url = attachment.get("url").toString();
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        return tempFileCache.getInputStream(url);
    }

    private void checkFileType(String name) {
        int index = name.lastIndexOf(".") + 1;
        if (index == 0 || index >= name.length()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u6587\u4ef6\u683c\u5f0f\u5931\u8d25\u3002", (String)"BgApplyBillImportBasePlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String type = name.substring(index);
        if (!"xlsx".equals(type) && !"xls".equals(type)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20Excel\u683c\u5f0f\u7684\u6587\u6863\u3002", (String)"BgApplyBillImportBasePlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    protected void importFileData(InputStream inputStream) {
    }

    protected void downLoadFailFile(String fileName, Boolean showErr) {
        String url = null;
        try {
            url = ImportAndExportUtil.writeFile((Workbook)this.errorBook, (String)fileName);
        }
        catch (IOException ex) {
            throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
        }
        if (StringUtils.isNotEmpty((String)url)) {
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
        }
        if (showErr.booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u9519\u8bef\u65e5\u5fd7\u3002", (String)"BgApplyBillImportBasePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    protected void addTitleRows(XSSFSheet sheet, int startTitleNum, int endTitleNum) {
        if (startTitleNum == endTitleNum) {
            this.addTitleRows(sheet, startTitleNum);
        } else {
            this.recordErrorInfo(sheet, startTitleNum, endTitleNum, "", false);
        }
    }

    private void addTitleRows(XSSFSheet sheet, int rowIndex) {
        XSSFRow row = sheet.getRow(rowIndex);
        this.recordErrorInfo(sheet, row, "");
    }

    protected void recordErrorInfo(XSSFSheet sheet, int startRow, int endRow, String errMsg, boolean isUpdate) {
        String sheetName = sheet.getSheetName();
        XSSFSheet errSheet = this.getErrBookSheet(sheet);
        int lastRowNum = errSheet.getLastRowNum();
        XSSFRow row = errSheet.getRow(lastRowNum);
        if (isUpdate && this.existValueInRow(row, 1) && this.getCellValue(row.getCell(1), 1).equals(String.valueOf((double)endRow))) {
            XSSFCell cell = row.getCell(0);
            cell.setCellValue(this.getCellValue(cell, 0) + ";" + errMsg);
            return;
        }
        for (int i = startRow; i <= endRow; ++i) {
            row = sheet.getRow(i);
            this.recordErrorInfo(sheet, row, errMsg);
        }
        errSheet = this.errorBook.getSheet(sheetName);
        int row2 = errSheet.getLastRowNum();
        CellRangeAddress titleRegion = new CellRangeAddress(lastRowNum + 1, row2, 0, 0);
        errSheet.addMergedRegion(titleRegion);
        List<CellRangeAddress> copyRowRegions = this.getSheetRegions(sheet, startRow, endRow, lastRowNum + 1);
        copyRowRegions.forEach(arg_0 -> ((XSSFSheet)errSheet).addMergedRegion(arg_0));
    }

    protected boolean existValueInRow(XSSFRow row, int colIndex) {
        if (this.isRowEmpty(row)) {
            return false;
        }
        short firstCellNum = row.getFirstCellNum();
        short lastCellNum = row.getLastCellNum();
        return colIndex >= firstCellNum && colIndex <= lastCellNum;
    }

    private List<CellRangeAddress> getSheetRegions(XSSFSheet sheet, int startRow, int endRow, int row) {
        ArrayList<CellRangeAddress> regions = new ArrayList<CellRangeAddress>(16);
        List mergedRegions = sheet.getMergedRegions();
        if (mergedRegions != null) {
            mergedRegions.forEach(e -> {
                if (e.getFirstRow() >= startRow && e.getLastRow() <= endRow) {
                    regions.add(new CellRangeAddress(e.getFirstRow() - startRow + row, e.getLastRow() - startRow + row, e.getFirstColumn() + 2, e.getLastColumn() + 2));
                }
            });
        }
        return regions;
    }

    protected void recordErrorInfo(XSSFSheet sheet, XSSFRow row, String errMsg) {
        XSSFSheet errSheet = this.getErrBookSheet(sheet);
        int lastRowNum = errSheet.getLastRowNum();
        int rowNum = row.getRowNum() + 1;
        String rowStr = ResManager.loadResFormat((String)"\u7b2c%1\u884c", (String)"BgApplyBillDataImportPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[]{rowNum});
        XSSFRow lastRow = errSheet.getRow(lastRowNum);
        XSSFCell cell1 = lastRow.getCell(1);
        CellType cellType = null;
        if (cell1 != null) {
            cellType = cell1.getCellType();
        }
        if (rowStr.equals(this.getCellValue(lastRow.getCell(1), 1))) {
            XSSFCell errInfoCell = lastRow.getCell(0);
            String errInfo = this.getCellValue(errInfoCell, 0);
            errInfo = errInfo + ";" + errMsg;
            errInfoCell.setCellValue(errInfo);
        } else {
            XSSFRow errRow = errSheet.createRow(lastRowNum + 1);
            XSSFCell cell = errRow.createCell(0, CellType.STRING);
            cell.setCellStyle(this.getCellStyle());
            cell.setCellValue(errMsg);
            cell = errRow.createCell(1, CellType.STRING);
            cell.setCellValue(rowStr);
            this.copyRowCells(errRow, row);
        }
        if (cell1 != null) {
            cell1.setCellType(cellType);
        }
    }

    private void copyRowCells(XSSFRow errRow, XSSFRow row) {
        short lastCellNum = row.getLastCellNum();
        if (this.isRowEmpty(row)) {
            return;
        }
        for (short i = 0; i < lastCellNum; i = (short)(i + 1)) {
            XSSFCell cell = row.getCell((int)i);
            XSSFCell errCell = errRow.createCell(i + 2, CellType.STRING);
            if (cell != null && cell.getCellStyle() != null) {
                XSSFCellStyle cellStyle = this.errorBook.createCellStyle();
                cellStyle.cloneStyleFrom((CellStyle)cell.getCellStyle());
                errCell.setCellStyle((CellStyle)cellStyle);
            }
            errCell.setCellValue(this.getCellValue(cell, i));
        }
    }

    protected boolean isRowEmpty(XSSFRow row) {
        boolean isEmpty = false;
        if (row == null || (row.getLastCellNum() == 0 || row.getLastCellNum() == -1) && row.getPhysicalNumberOfCells() == 0) {
            isEmpty = true;
        } else {
            int firstCellNum = row.getFirstCellNum();
            short lastCellNum = row.getLastCellNum();
            for (int i = firstCellNum; i < lastCellNum; ++i) {
                XSSFCell cell = row.getCell(i);
                if (!StringUtils.isEmpty((String)this.getCellValue(cell, i))) {
                    isEmpty = false;
                    break;
                }
                isEmpty = true;
            }
        }
        return isEmpty;
    }

    protected String getCellValue(XSSFCell cell, int colIndex) {
        String cellValue = "";
        if (cell == null) {
            return cellValue;
        }
        CellType cellType = cell.getCellType();
        if (CellType.STRING != cellType) {
            cell.setCellType(CellType.STRING);
        }
        cellValue = cell.getStringCellValue();
        return cellValue;
    }

    protected XSSFSheet getErrBookSheet(XSSFSheet sheet) {
        String sheetName;
        XSSFSheet errSheet;
        if (this.errorBook == null) {
            this.errorBook = new XSSFWorkbook();
            this.initErrorBookStyle();
            this.initCellStyle();
        }
        if ((errSheet = this.errorBook.getSheet(sheetName = sheet.getSheetName())) == null) {
            errSheet = this.errorBook.createSheet(sheetName);
            this.createHeaderInfo(errSheet);
            Pair<Integer, Integer> titleRow = this.getTitleRow();
            if (titleRow != null) {
                this.addTitleRows(sheet, (Integer)titleRow.p1, (Integer)titleRow.p2);
            }
        }
        return errSheet;
    }

    protected Pair<Integer, Integer> getTitleRow() {
        return null;
    }

    protected void createHeaderInfo(XSSFSheet sheet) {
        this.setSheetWidth(sheet);
        XSSFRow row = sheet.createRow(0);
        XSSFCell cell = row.createCell(0, CellType.STRING);
        cell.setCellStyle(this.getCellStyle());
        cell.setCellValue(ResManager.loadKDString((String)"\u9519\u8bef\u539f\u56e0", (String)"BgApplyBillImportBasePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        cell = row.createCell(1, CellType.STRING);
        cell.setCellValue(ResManager.loadKDString((String)"\u9519\u8bef\u884c", (String)"BgApplyBillImportBasePlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        cell = row.createCell(2, CellType.STRING);
        cell.setCellValue(ResManager.loadKDString((String)"\u6e90\u6570\u636e", (String)"BgApplyBillImportBasePlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private void setSheetWidth(XSSFSheet sheet) {
        sheet.setDefaultColumnWidth(30);
        sheet.setColumnWidth(0, 4000);
        sheet.setColumnWidth(1, 2000);
    }

    protected CellStyle getCellStyle() {
        if (this.cellStyle == null) {
            this.initCellStyle();
        }
        return this.cellStyle;
    }

    @Override
    public Long getModelId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object modelId = formShowParameter.getCustomParam("model");
        if (modelId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u4f53\u7cfb\u5931\u8d25\u3002", (String)"EbCustomShareF7Plugin_3", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
        return IDUtils.toLong((Object)modelId);
    }

    protected XSSFWorkbook getWorkBook(InputStream inputStream) {
        XSSFWorkbook workbook = null;
        try {
            workbook = new XSSFWorkbook(inputStream);
        }
        catch (Exception ex) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u5bfc\u5165\u6587\u4ef6\u3002", (String)"BgApplyBillImportBasePlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return workbook;
    }
}

