/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applybill.fileImport;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.applybill.util.BgApplyBillUtils;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateColCfgService;
import kd.epm.eb.business.centralapproval.ApproveRecordUtil;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.applyTemplate.constants.ColCfgPropEnum;
import kd.epm.eb.common.applyTemplate.entity.ApplyTemplateColCfgEntity;
import kd.epm.eb.common.applybill.exportcol.BaseExportCol;
import kd.epm.eb.common.applytemplatecolumn.ColumnEnum;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.centralapproval.AppAdjustRecord;
import kd.epm.eb.common.centralapproval.CentralAppChain;
import kd.epm.eb.common.centralapproval.CentralAppShowInfo;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.formula.ExpressionContext;
import kd.epm.eb.common.formula.ExpressionParseHelper;
import kd.epm.eb.common.formula.Iexpression;
import kd.epm.eb.common.formula.SheetExpressionContext;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.applybill.fileImport.BgApplyBillDataExportPlugin;
import kd.epm.eb.formplugin.applybill.fileImport.DataType;
import kd.epm.eb.formplugin.applybill.fileImport.RowType;
import kd.epm.eb.formplugin.applybill.fileImport.StatisticRow;
import kd.epm.eb.olap.service.OlapCommService;
import kd.epm.eb.olap.service.request.QueryRequest;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;

public class BgStatisticsDataExportPlugin
extends BgApplyBillDataExportPlugin {
    private static final BgStatisticsDataExportPlugin instance = new BgStatisticsDataExportPlugin();
    private static final Log log = LogFactory.getLog(BgStatisticsDataExportPlugin.class);

    public static BgStatisticsDataExportPlugin getInstance() {
        return instance;
    }

    @Override
    protected Set<String> getBillNumbers(String applyBillNumber, Long modelId) {
        CentralAppBillService instance = CentralAppBillService.getInstance();
        CentralAppChain centralAppChain = instance.getCentralAppChainByBills(applyBillNumber, modelId);
        Set billNumbers = instance.getCentralAppChainsBillSet(centralAppChain);
        billNumbers.add(applyBillNumber);
        Set billNos = instance.getAllApplyBillNumbers(billNumbers);
        billNumbers.addAll(billNos);
        Set referBillNums = CentralAppBillService.getInstance().getRefedBillNums(applyBillNumber, modelId);
        billNumbers.addAll(referBillNums);
        return billNumbers;
    }

    @Override
    protected void createDimRangeSheet(Map<String, List<String>> dimRanges, List<String> dimOrder, Map<String, Long> viewIdMap, IModelCacheHelper modelCacheHelper, Map<String, List<Map<String, String>>> enumskeyMap) {
    }

    @Override
    protected String getFileName(Boolean isTemplate) {
        return ResManager.loadKDString((String)"\u5206\u9879\u7edf\u8ba1-\u5bfc\u51fa\u6570\u636e", (String)"BgStatisticsDataExportPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    @Override
    protected void batchFillData(XSSFSheet sheet, CentralAppShowInfo showInfo, List<BaseExportCol> rowInfos, Map<String, Map<String, Map<String, String>>> colRowDimMembers, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds, Map<String, String> hiddenDimMemMap, Map<String, String> calCols, Long modelId, Long dataSetId, BigDecimal unitData, List<String> statisticsDims, String definedDimension, Long tempId, int currentRow, Map<String, Map<String, String>> varInfo, Set<String> colDimNums) {
        if (statisticsDims.size() == 0) {
            super.batchFillData(sheet, showInfo, rowInfos, colRowDimMembers, modelCacheHelper, viewIds, hiddenDimMemMap, calCols, modelId, dataSetId, unitData, statisticsDims, definedDimension, tempId, currentRow, varInfo, colDimNums);
        } else {
            Map<String, Map<String, String>> cols = colRowDimMembers.get("col");
            Map<String, Map<String, String>> rows = colRowDimMembers.get("row");
            if (rows.size() == 0) {
                return;
            }
            List<String> removeKeys = this.filterCols(cols, colDimNums, showInfo, modelCacheHelper, dataSetId);
            this.removeColInfo(rowInfos, removeKeys);
            HashMap<String, String> colMetric = new HashMap<String, String>(16);
            String metricNumber = SysDimensionEnum.Metric.getNumber();
            String metricMember = hiddenDimMemMap.get(metricNumber);
            if (StringUtils.isNotEmpty((String)metricMember)) {
                Member member = modelCacheHelper.getMember(metricNumber, null, metricMember);
                if (member != null) {
                    String datatype = member.getDatatype();
                    cols.keySet().forEach(e -> colMetric.put("f" + e, datatype));
                }
            } else {
                cols.forEach((key, value) -> {
                    Member member;
                    String metric = (String)value.get(metricNumber);
                    if (StringUtils.isNotEmpty((String)metric) && (member = modelCacheHelper.getMember(metricNumber, null, metric)) != null) {
                        String datatype = member.getDatatype();
                        colMetric.put("f" + key, datatype);
                    }
                });
            }
            HashMap<String, Map<String, String>> others = colRowDimMembers.get("other") == null ? new HashMap(16) : colRowDimMembers.get("other");
            Map<MembersKey, Set<String>> allRelateAdjustRecords = this.getAllRelateAdjustRecords(rows, tempId, dataSetId, modelCacheHelper, varInfo);
            Map<String, Map<String, String>> notDetail_rows = this.getNotDetailRows(rows, modelCacheHelper, viewIds);
            this.filterRows(rows, showInfo, modelCacheHelper, viewIds);
            this.replaceByOlapData(rows, rowInfos, cols, others, modelCacheHelper, hiddenDimMemMap, dataSetId, modelId);
            String statisticsDim = statisticsDims.get(0);
            HashSet<String> ignoreAggKey = new HashSet<String>(16);
            HashSet<String> notAggKey4DefDim = new HashSet<String>(16);
            cols.forEach((colKey, memberMap) -> {
                if (memberMap.containsKey(statisticsDim)) {
                    ignoreAggKey.add("f" + colKey);
                } else if (definedDimension != null && memberMap.containsKey(definedDimension)) {
                    notAggKey4DefDim.add("f" + colKey);
                }
            });
            HashMap<String, Map<String, String>> notDetailRowsCopy = new HashMap<String, Map<String, String>>(16);
            notDetailRowsCopy.putAll(notDetail_rows);
            List<StatisticRow> currentDetailRows = this.getCurrentLevelMembers(rows, others, colMetric, modelCacheHelper, viewIds, statisticsDim, ignoreAggKey);
            List<StatisticRow> rootRows = this.getRootRows(currentDetailRows, notDetail_rows, others, colMetric, modelCacheHelper, viewIds, statisticsDim, ignoreAggKey);
            Map<Map<String, String>, Map<String, BigDecimal>> noDetailOlapData = this.getNoDetailOlapData(rootRows, modelId, dataSetId, hiddenDimMemMap, cols, tempId);
            this.replaceNoDetailData(rootRows, notDetailRowsCopy, others, noDetailOlapData);
            Map<String, Map<String, Integer>> colIndexes = this.getAllColIndex(rowInfos, colMetric.keySet());
            this.fillData(sheet, rootRows, rowInfos, notDetail_rows, others, statisticsDims, modelCacheHelper, viewIds, colIndexes, colMetric, definedDimension, currentRow, notAggKey4DefDim);
            Set<String> currencyCols = this.getCurrencyCols(colMetric);
            List<String> notDetailColKeys = this.getNotDetailCols(cols, modelCacheHelper);
            List<String> unableEditCols = this.getUnEnableEditCols(tempId);
            notDetailColKeys.removeAll(unableEditCols);
            List dimensionList = modelCacheHelper.getDimensionList(dataSetId);
            if (rows.size() == 0) {
                log.info("export-rowIsEmpty:" + tempId);
                return;
            }
            Set<String> dimNumbers = rows.entrySet().iterator().next().getValue().keySet();
            List<Dimension> rowDimensionList = dimensionList.stream().filter(e -> dimNumbers.contains(e.getNumber())).collect(Collectors.toList());
            this.updateSheetData(sheet, colIndexes, calCols, currencyCols, unitData, allRelateAdjustRecords, notDetailColKeys, modelCacheHelper, viewIds, statisticsDim, definedDimension, rowDimensionList, currentRow);
        }
    }

    private Set<String> getCurrencyCols(Map<String, String> colMetric) {
        HashSet<String> currencyCols = new HashSet<String>(16);
        String currencyIndex = MetricDataTypeEnum.CURRENCY.getIndex();
        colMetric.forEach((key, value) -> {
            if (currencyIndex.equals(value)) {
                currencyCols.add((String)key);
            }
        });
        return currencyCols;
    }

    private List<String> getUnEnableEditCols(Long tempId) {
        HashMap<String, Set> colEditConfig = new HashMap<String, Set>(16);
        List colCfgList = ApplyTemplateColCfgService.getInstance().getColCfgListByTemplateId(tempId);
        for (ApplyTemplateColCfgEntity colCfgEntity : colCfgList) {
            String formType = colCfgEntity.getFormtype();
            String editType = colCfgEntity.getEdittype();
            String colKey = colCfgEntity.getColkey();
            if (!ColCfgPropEnum.HIDE.getValue().equals(editType) && !ColCfgPropEnum.READONLY.getValue().equals(editType)) continue;
            Set billTypes = colEditConfig.computeIfAbsent(colKey, k -> new HashSet(16));
            billTypes.add(formType);
        }
        return colEditConfig.entrySet().stream().filter(e -> ((Set)e.getValue()).size() == 4).map(e -> "f" + (String)e.getKey()).collect(Collectors.toList());
    }

    private List<String> getNotDetailCols(Map<String, Map<String, String>> cols, IModelCacheHelper modelCacheHelper) {
        ArrayList<String> colKeys = new ArrayList<String>(16);
        cols.forEach((key, value) -> {
            Member member;
            String number = SysDimensionEnum.AuditTrail.getNumber();
            String auditTrail = (String)value.get(number);
            if (StringUtils.isNotEmpty((String)auditTrail) && (member = modelCacheHelper.getMember(number, null, auditTrail)) != null && !member.isLeaf()) {
                colKeys.add("f" + key);
            }
        });
        return colKeys;
    }

    private Map<MembersKey, Set<String>> getAllRelateAdjustRecords(Map<String, Map<String, String>> rows, Long tempId, Long dataSetId, IModelCacheHelper modelCacheHelper, Map<String, Map<String, String>> varInfo) {
        HashMap memberMap = new HashMap(16);
        Long modelId = modelCacheHelper.getModelobj().getId();
        Map viewIds = modelCacheHelper.getViewsByDataSet(dataSetId);
        rows.values().forEach(e -> e.forEach((key, value) -> {
            Set members = memberMap.computeIfAbsent(key, k -> new HashSet(16));
            Member member = modelCacheHelper.getMember(key, (Long)viewIds.get(key), value);
            if (member != null) {
                members.add(member.getId());
            }
        }));
        List appAdjustRecords = ApproveRecordUtil.getInstance().getAppAdjustRecords(memberMap, tempId, dataSetId, modelId, varInfo);
        List dimensionList = modelCacheHelper.getDimensionList(dataSetId);
        return this.getRecordCols(appAdjustRecords, memberMap.keySet(), viewIds, dimensionList);
    }

    private Map<MembersKey, Set<String>> getRecordCols(List<AppAdjustRecord> appAdjustRecords, Set<String> dims, Map<String, Long> viewIds, List<Dimension> dimensionList) {
        HashMap<MembersKey, Set<String>> recordInfos = new HashMap<MembersKey, Set<String>>(16);
        if (appAdjustRecords == null || appAdjustRecords.isEmpty()) {
            return recordInfos;
        }
        HashMap rowDimensions = new HashMap(16);
        ArrayList rowDimensionList = new ArrayList(16);
        dimensionList.forEach(e -> {
            String number = e.getNumber();
            if (dims.contains(number)) {
                rowDimensions.put(number, e);
                rowDimensionList.add(e);
            }
        });
        for (AppAdjustRecord appAdjustRecord : appAdjustRecords) {
            HashMap tmp = new HashMap(16);
            Map dimMemberMap = appAdjustRecord.getDimMemberMap();
            dims.forEach(e -> {
                Dimension dimension = (Dimension)rowDimensions.get(e);
                Long memberId = (Long)dimMemberMap.get(e);
                Long viewId = (Long)viewIds.get(dimension.getNumber());
                Member member = dimension.getMember(viewId, memberId);
                if (member != null) {
                    tmp.put(e, member.getNumber());
                }
            });
            MembersKey membersKey = BgApplyBillUtils.getInstance().getMembersKey(tmp, rowDimensionList);
            Set colKeys = recordInfos.computeIfAbsent(membersKey, k -> new HashSet(16));
            List colDataInfos = appAdjustRecord.getColDataInfos();
            Set keys = colDataInfos.stream().map(e -> "f" + e.getKey()).collect(Collectors.toSet());
            colKeys.addAll(keys);
        }
        return recordInfos;
    }

    private void removeColInfo(List<BaseExportCol> rowInfos, List<String> removeKeys) {
        if (removeKeys.size() == 0) {
            return;
        }
        ArrayList<BaseExportCol> toRemove = new ArrayList<BaseExportCol>(16);
        for (BaseExportCol rowInfo : rowInfos) {
            String number;
            ColumnEnum rowType = rowInfo.getRowType();
            if (ColumnEnum.Measure != rowType && ColumnEnum.Cal != rowType || !removeKeys.contains(number = rowInfo.getNumber())) continue;
            toRemove.add(rowInfo);
        }
        rowInfos.removeAll(toRemove);
    }

    private void updateSheetData(XSSFSheet sheet, Map<String, Map<String, Integer>> colIndexes, Map<String, String> calCols, Set<String> currencyCols, BigDecimal unitData, Map<MembersKey, Set<String>> allRelateAdjustRecords, List<String> notDetailColKeys, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds, String statisticsDim, String definedDimension, List<Dimension> rowDimensionList, int startRowIndex) {
        int lastRowNum = sheet.getLastRowNum();
        Map<String, Integer> measureIndex = colIndexes.get("measure");
        Map<String, Integer> numberCIndex = colIndexes.get("numberC");
        Map<String, Integer> dimensionIndex = colIndexes.get("dimension");
        HashMap<String, Integer> indexes_tmp = new HashMap<String, Integer>(measureIndex);
        calCols.keySet().forEach(indexes_tmp::remove);
        HashMap<String, Integer> indexes = new HashMap<String, Integer>(measureIndex);
        indexes.putAll(numberCIndex);
        SheetExpressionContext sheetExpressionContext = new SheetExpressionContext();
        sheetExpressionContext.setMeasureIndex(indexes);
        Map<String, Iexpression> expression = this.parseToExpression(calCols, currencyCols);
        for (int index = startRowIndex + 1; index <= lastRowNum; ++index) {
            XSSFRow row = sheet.getRow(index);
            if (this.isRowEmpty(row)) continue;
            sheetExpressionContext.setRow(row);
            this.updateCalCols(sheetExpressionContext, expression, calCols);
            this.updateRowUnit(row, indexes, currencyCols, unitData);
            this.clearNotUseData(row, allRelateAdjustRecords, notDetailColKeys, modelCacheHelper, viewIds, rowDimensionList, statisticsDim, definedDimension, indexes_tmp, dimensionIndex);
        }
    }

    private void clearNotUseData(XSSFRow row, Map<MembersKey, Set<String>> allRelateAdjustRecords, List<String> notDetailColKeys, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds, List<Dimension> rowDimensionList, String statisticsDim, String definedDimension, Map<String, Integer> indexes, Map<String, Integer> dimensionIndex) {
        HashMap<String, String> dimMap = new HashMap<String, String>(16);
        this.getDimInfoInSheet(row, dimMap, dimensionIndex);
        DataType dataType = this.getDataType(dimMap, statisticsDim, definedDimension, modelCacheHelper, viewIds);
        MembersKey membersKey = BgApplyBillUtils.getInstance().getMembersKey(dimMap, rowDimensionList);
        Set<String> colKeys = allRelateAdjustRecords.get(membersKey);
        if (DataType.DETAIL == dataType) {
            ArrayList<String> colKey_tmp = new ArrayList<String>(notDetailColKeys);
            if (colKeys != null) {
                colKey_tmp.removeAll(colKeys);
            }
            this.clearCellValue(row, colKey_tmp, indexes);
        } else if (DataType.NOT_DETAIL == dataType) {
            ArrayList<String> colKey_tmp = new ArrayList<String>(indexes.keySet());
            if (colKeys != null) {
                colKey_tmp.removeAll(colKeys);
            }
            this.clearCellValue(row, colKey_tmp, indexes);
        }
    }

    private void clearCellValue(XSSFRow row, List<String> colKeys, Map<String, Integer> indexes) {
        if (colKeys == null || colKeys.size() == 0) {
            return;
        }
        colKeys.forEach(e -> {
            XSSFCell cell;
            Integer index = (Integer)indexes.get(e);
            if (index != null && (cell = row.getCell(index.intValue())) != null) {
                cell.setCellValue("");
            }
        });
    }

    private DataType getDataType(Map<String, String> dimMap, String statisticsDim, String definedDimension, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds) {
        boolean isCollectRow = false;
        DataType dataType = null;
        for (Map.Entry<String, String> entry : dimMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            Member member = modelCacheHelper.getMember(key, viewIds.get(key), value);
            if (member == null || member.isLeaf()) continue;
            if (statisticsDim.equals(key)) {
                isCollectRow = true;
                continue;
            }
            if (!key.equals(definedDimension)) {
                dataType = DataType.NOT_DETAIL;
                continue;
            }
            if (dataType == DataType.NOT_DETAIL) continue;
            if (member.getParentId() == 0L) {
                dataType = DataType.ROOT;
                continue;
            }
            dataType = DataType.NOT_DETAIL;
        }
        if (dataType == null) {
            dataType = isCollectRow ? DataType.COLLECT_DETAIL : DataType.DETAIL;
        }
        return dataType;
    }

    private void updateRowUnit(XSSFRow row, Map<String, Integer> indexes, Set<String> currencyCols, BigDecimal unitData) {
        for (Map.Entry<String, Integer> indexEntry : indexes.entrySet()) {
            XSSFCell cell;
            String cellValue;
            BigDecimal bigDecimal;
            boolean needUpdateUnit = true;
            Integer index = indexEntry.getValue();
            String key = indexEntry.getKey();
            if (!currencyCols.contains(key)) {
                needUpdateUnit = false;
            }
            if ((bigDecimal = ConvertUtils.toDecimal((Object)(cellValue = (cell = row.getCell(index.intValue())).getStringCellValue()))) == null) continue;
            if (needUpdateUnit) {
                bigDecimal = bigDecimal.setScale(10, RoundingMode.HALF_UP);
                bigDecimal = bigDecimal.divide(unitData, RoundingMode.HALF_UP);
            }
            bigDecimal = bigDecimal.setScale(2, RoundingMode.HALF_UP);
            cell.setCellValue(bigDecimal.toString());
        }
    }

    private Map<String, Iexpression> parseToExpression(Map<String, String> calCols, Set<String> currencyCols) {
        HashMap<String, Iexpression> expression = new HashMap<String, Iexpression>(16);
        for (Map.Entry<String, String> calCol : calCols.entrySet()) {
            String key = calCol.getKey();
            String formula = calCol.getValue();
            if (StringUtils.isEmpty((String)formula)) continue;
            try {
                expression.put(key, ExpressionParseHelper.parse((String)formula, calCols));
                this.addNumberCol(key, formula, currencyCols);
            }
            catch (Exception e) {
                throw new KDBizException((Throwable)e, new ErrorCode("parseToExpression", e.getMessage()), new Object[0]);
            }
        }
        return expression;
    }

    private void updateCalCols(SheetExpressionContext context, Map<String, Iexpression> expression, Map<String, String> calCols) {
        Map measureIndex = context.getMeasureIndex();
        XSSFRow row = context.getRow();
        for (String colKey : calCols.keySet()) {
            Iexpression iexpression;
            Integer index = (Integer)measureIndex.get(colKey);
            if (index == null || (iexpression = expression.get(colKey)) == null) continue;
            iexpression.setContext((ExpressionContext)context);
            BigDecimal calculate = iexpression.calculate();
            XSSFCell cell = row.getCell(index.intValue());
            cell.setCellValue(calculate.toString());
        }
    }

    private void addNumberCol(String key, String formula, Set<String> currencyCols) throws Exception {
        if (currencyCols.contains(key)) {
            return;
        }
        Stack<Character> operators = new Stack<Character>();
        operators.push(Character.valueOf('#'));
        Stack operand = new Stack();
        List colKeys = ExpressionParseHelper.toNBL((String)formula, null, operators, operand);
        if (colKeys.size() == 0) {
            return;
        }
        List col_keys = colKeys.stream().map(e -> "f" + e).collect(Collectors.toList());
        col_keys.retainAll(currencyCols);
        if (col_keys.size() != 0) {
            currencyCols.add(key);
        }
    }

    private List<String> filterCols(Map<String, Map<String, String>> cols, Set<String> colDimNums, CentralAppShowInfo showInfo, IModelCacheHelper modelCacheHelper, Long datasetId) {
        ArrayList<String> colKeys = new ArrayList<String>(16);
        if (showInfo == null) {
            return colKeys;
        }
        Long modelId = modelCacheHelper.getModelobj().getId();
        Long bizModelId = modelCacheHelper.getBusModelByDataSet(datasetId);
        Map viewIds = modelCacheHelper.getViewsByBusModel(bizModelId);
        Set permOrgIds = DimMembPermHelper.getPermMembIds((String)SysDimensionEnum.Entity.getNumber(), (Long)modelId, (Long)bizModelId, (Long)((Long)viewIds.get("Entity")), (DimMembPermType)DimMembPermType.READ, (boolean)true);
        Set permAccountIds = DimMembPermHelper.getPermMembIds((String)SysDimensionEnum.Account.getNumber(), (Long)modelId, (Long)bizModelId, (Long)((Long)viewIds.get("Account")), (DimMembPermType)DimMembPermType.READ, (boolean)true);
        Set entitySet = showInfo.getEntitySet();
        Set accountSet = showInfo.getAccountSet();
        String entity = SysDimensionEnum.Entity.getNumber();
        String account = SysDimensionEnum.Account.getNumber();
        boolean hasAccount = colDimNums.contains(SysDimensionEnum.Account.getNumber());
        boolean hasEntity = colDimNums.contains(SysDimensionEnum.Entity.getNumber());
        for (Map.Entry<String, Map<String, String>> col : cols.entrySet()) {
            String key = col.getKey();
            Map<String, String> dims = col.getValue();
            if (this.checkDim(dims, entitySet, permOrgIds, !hasEntity, entity, modelCacheHelper, viewIds) && this.checkDim(dims, accountSet, permAccountIds, !hasAccount, account, modelCacheHelper, viewIds)) continue;
            colKeys.add(key);
        }
        colKeys.forEach(cols::remove);
        return colKeys;
    }

    private List<String> filterRows(Map<String, Map<String, String>> cols, CentralAppShowInfo showInfo, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds) {
        ArrayList<String> colKeys = new ArrayList<String>(16);
        if (showInfo == null) {
            return colKeys;
        }
        Set entitySet = showInfo.getEntitySet();
        Set accountSet = showInfo.getAccountSet();
        String entity = SysDimensionEnum.Entity.getNumber();
        String account = SysDimensionEnum.Account.getNumber();
        for (Map.Entry<String, Map<String, String>> col : cols.entrySet()) {
            String key = col.getKey();
            Map<String, String> dims = col.getValue();
            if (this.checkDim(dims, entitySet, entity, modelCacheHelper, viewIds) && this.checkDim(dims, accountSet, account, modelCacheHelper, viewIds)) continue;
            colKeys.add(key);
        }
        colKeys.forEach(cols::remove);
        return colKeys;
    }

    private boolean checkDim(Map<String, String> dims, Set<Long> memberSet, Set<Long> permSet, boolean checkPerm, String dim, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds) {
        String entityNumber = dims.get(dim);
        if (StringUtils.isNotEmpty((String)entityNumber)) {
            Member member = modelCacheHelper.getMember(dim, viewIds.get(dim), entityNumber);
            Long entityId = member.getId();
            return checkPerm ? permSet == null || permSet.contains(entityId) : memberSet != null && memberSet.contains(entityId);
        }
        return true;
    }

    private boolean checkDim(Map<String, String> dims, Set<Long> memberSet, String dim, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds) {
        String entityNumber = dims.get(dim);
        if (StringUtils.isNotEmpty((String)entityNumber) && memberSet != null) {
            Member member = modelCacheHelper.getMember(dim, viewIds.get(dim), entityNumber);
            Long entityId = member.getId();
            return memberSet.contains(entityId);
        }
        return true;
    }

    private List<StatisticRow> getRootRows(List<StatisticRow> rows, Map<String, Map<String, String>> notDetailRows, Map<String, Map<String, String>> others, Map<String, String> colMetric, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds, String statisticsDim, Set<String> ignoreAggKeys) {
        this.updateNotDetailRows(rows, notDetailRows, others, colMetric);
        List<StatisticRow> parentRows = this.getParentRows(rows, modelCacheHelper, viewIds, statisticsDim, colMetric, ignoreAggKeys);
        return parentRows.size() == 0 ? rows : this.getRootRows(parentRows, notDetailRows, others, colMetric, modelCacheHelper, viewIds, statisticsDim, ignoreAggKeys);
    }

    private void updateNotDetailRows(List<StatisticRow> rows, Map<String, Map<String, String>> notDetailRows, Map<String, Map<String, String>> others, Map<String, String> colMetric) {
        HashMap<String, Map<String, String>> tmp = new HashMap<String, Map<String, String>>(notDetailRows);
        for (Map.Entry entry : tmp.entrySet()) {
            String index = (String)entry.getKey();
            Map value = (Map)entry.getValue();
            StatisticRow rowInList = this.getRowInList(rows, value);
            if (rowInList == null) continue;
            Map<String, String> remove = others.remove(index);
            this.updateOtherMapValue(rowInList.getOthers(), remove, colMetric, null);
            this.updateNotMetricValue(rowInList.getOthers(), remove, colMetric);
            notDetailRows.remove(index);
        }
    }

    private void updateNotMetricValue(Map<String, String> others_toAdd, Map<String, String> others, Map<String, String> colMetric) {
        others.forEach((key, value) -> {
            String metricTypeIndex = (String)colMetric.get(key);
            if (StringUtils.isEmpty((String)metricTypeIndex) && StringUtils.isNotEmpty((String)value)) {
                others_toAdd.put((String)key, (String)value);
            }
        });
    }

    private List<StatisticRow> getParentRows(List<StatisticRow> rows, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds, String statisticsDim, Map<String, String> colMetric, Set<String> ignoreAggKeys) {
        ArrayList<StatisticRow> parentRows = new ArrayList<StatisticRow>(16);
        ArrayList<Integer> hasUsedList = new ArrayList<Integer>(16);
        if (rows.size() != 0 && rows.get(0).getLevel() > 2) {
            for (int i = 0; i < rows.size(); ++i) {
                if (hasUsedList.contains(i)) continue;
                boolean hasCommonParent = false;
                StatisticRow row = rows.get(i);
                for (int j = i + 1; j < rows.size(); ++j) {
                    StatisticRow statisticRow = rows.get(j);
                    StatisticRow parentRow = this.getCommonParentRow(row, statisticRow, colMetric, modelCacheHelper, viewIds, statisticsDim, ignoreAggKeys);
                    if (parentRow == null) continue;
                    hasCommonParent = true;
                    hasUsedList.add(j);
                    StatisticRow rowInList = this.getRowInList(parentRows, parentRow.getRows());
                    if (rowInList == null) {
                        parentRows.add(parentRow);
                        break;
                    }
                    this.updateChildInfo(rowInList, parentRow, colMetric, ignoreAggKeys);
                    break;
                }
                if (hasCommonParent) continue;
                StatisticRow parentRow = this.getParentRow(row, statisticsDim, modelCacheHelper, viewIds, row.getLevel() - 1, colMetric);
                StatisticRow rowInList = this.getRowInList(parentRows, parentRow.getRows());
                if (rowInList == null) {
                    parentRows.add(parentRow);
                    continue;
                }
                this.updateChildInfo(rowInList, parentRow, colMetric, ignoreAggKeys);
            }
            return parentRows;
        }
        return new ArrayList<StatisticRow>(16);
    }

    private StatisticRow getCommonParentRow(StatisticRow row, StatisticRow statisticRow, Map<String, String> colMetric, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds, String statisticsDim, Set<String> ignoreAggKeys) {
        Member member_second;
        Member member_first;
        Member parentMember;
        Map<String, String> rows_second;
        StatisticRow parentRow = null;
        Map<String, String> rows_first = row.getRows();
        if (this.checkOtherDimSame(rows_first, rows_second = statisticRow.getRows(), statisticsDim) && (parentMember = this.getParentMember(member_first = row.getMember(), member_second = statisticRow.getMember(), modelCacheHelper, viewIds)) != null) {
            parentRow = new StatisticRow();
            HashMap<String, String> rows_parent = new HashMap<String, String>(rows_first);
            rows_parent.put(statisticsDim, parentMember.getNumber());
            parentRow.setMember(parentMember);
            parentRow.setRows(rows_parent);
            HashMap<String, String> otherMap_new = new HashMap<String, String>(16);
            row.getOthers().entrySet().stream().filter(e -> colMetric.containsKey(e.getKey())).forEach(e -> {
                String cfr_ignored_0 = (String)otherMap_new.put((String)e.getKey(), (String)e.getValue());
            });
            this.updateOtherMapValue(otherMap_new, statisticRow.getOthers(), colMetric, ignoreAggKeys);
            parentRow.setOthers(otherMap_new);
            List<StatisticRow> children = parentRow.getChildren();
            children.add(row);
            children.add(statisticRow);
        }
        return parentRow;
    }

    private Member getParentMember(Member first, Member second, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds) {
        String parentNumber = first.getParentNumber();
        if (!parentNumber.equals(second.getParentNumber())) {
            return null;
        }
        return modelCacheHelper.getMember(first.getDimension().getNumber(), viewIds.get(first.getDimension().getNumber()), parentNumber);
    }

    private boolean checkOtherDimSame(Map<String, String> rows_first, Map<String, String> rows_second, String statisticsDim) {
        boolean isSame = true;
        if (rows_first.size() != rows_second.size()) {
            isSame = false;
        } else {
            for (Map.Entry<String, String> row : rows_first.entrySet()) {
                String value_compare;
                String key = row.getKey();
                String value = row.getValue();
                if (statisticsDim.equals(key) || value.equals(value_compare = rows_second.get(key))) continue;
                isSame = false;
                break;
            }
        }
        return isSame;
    }

    private void fillData(XSSFSheet sheet, List<StatisticRow> rootRows, List<BaseExportCol> rowInfos, Map<String, Map<String, String>> notDetailRows, Map<String, Map<String, String>> others, List<String> statisticsDims, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds, Map<String, Map<String, Integer>> colIndexes, Map<String, String> colMetric, String definedDimension, int currentRow, Set<String> notAggKey4DefDim) {
        ArrayList<Integer> insertRowIndexes = new ArrayList<Integer>(16);
        HashMap<Integer, Map<String, String>> rowDimMapInSheet = new HashMap<Integer, Map<String, String>>(16);
        for (StatisticRow rootRow : rootRows) {
            currentRow = this.addDefinedRowToSheet(sheet, rootRow, rowInfos, modelCacheHelper, viewIds, statisticsDims, colIndexes, insertRowIndexes, rowDimMapInSheet, colMetric, currentRow, definedDimension, 0, notAggKey4DefDim);
            currentRow = this.fillNotDetailDataToSheet(sheet, rootRow, rowInfos, notDetailRows, others, modelCacheHelper, viewIds, statisticsDims, colIndexes, colMetric, insertRowIndexes, rowDimMapInSheet, definedDimension, currentRow, 0);
            this.fillRowDataToSheet(sheet, rootRow.getRows(), rowInfos, rootRow.getOthers(), statisticsDims, modelCacheHelper, viewIds, definedDimension, ++currentRow, 0);
            int rowIndex = this.fillChildRows(sheet, rootRow, rowInfos, modelCacheHelper, viewIds, notDetailRows, others, statisticsDims, colIndexes, colMetric, insertRowIndexes, rowDimMapInSheet, currentRow, definedDimension, rootRow.getLevel(), notAggKey4DefDim);
            if (currentRow == rowIndex) continue;
            currentRow = rowIndex;
        }
    }

    private int addDefinedRowToSheet(XSSFSheet sheet, StatisticRow rootRow, List<BaseExportCol> rowInfos, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds, List<String> statisticsDims, Map<String, Map<String, Integer>> colIndexes, List<Integer> insertRowIndexes, Map<Integer, Map<String, String>> rowDimMapInSheet, Map<String, String> colMetric, int rowIndex, String definedDimension, int level, Set<String> notAggKey4DefDim) {
        int existRowIndex = -2;
        Map<String, String> rowsBase = rootRow.getRows();
        Map<String, String> others = rootRow.getOthers();
        HashMap<String, String> otherMap_new = new HashMap<String, String>(16);
        others.entrySet().stream().filter(e -> colMetric.containsKey(e.getKey())).forEach(e -> {
            String cfr_ignored_0 = (String)otherMap_new.put((String)e.getKey(), (String)e.getValue());
        });
        Map<String, Integer> dimensionIndex = colIndexes.get("dimension");
        Map<String, Integer> measureIndex = colIndexes.get("measure");
        if (StringUtils.isNotEmpty((String)definedDimension)) {
            HashMap<String, String> rows = new HashMap<String, String>(rowsBase);
            rows.put(definedDimension, definedDimension);
            existRowIndex = this.getRowIndexInSheet(sheet, rows, dimensionIndex, rowDimMapInSheet, insertRowIndexes);
            if (existRowIndex == -1) {
                this.fillRowDataToSheet(sheet, rows, rowInfos, otherMap_new, statisticsDims, modelCacheHelper, viewIds, definedDimension, ++rowIndex, level);
                insertRowIndexes.add(rowIndex);
                rowDimMapInSheet.put(rowIndex, rows);
            } else {
                this.addValueToDefinedRow(sheet, otherMap_new, measureIndex, existRowIndex, notAggKey4DefDim);
            }
        }
        List<Integer> indexes = this.getAdjustRowsInSheet(sheet, rowsBase, dimensionIndex, rowDimMapInSheet, statisticsDims, insertRowIndexes, modelCacheHelper, viewIds);
        if (existRowIndex == -1) {
            indexes.remove((Object)rowIndex);
        } else if (existRowIndex != -2) {
            indexes.remove((Object)existRowIndex);
        }
        indexes.forEach(e -> this.addValueToDefinedRow(sheet, (Map<String, String>)otherMap_new, measureIndex, (int)e, notAggKey4DefDim));
        return rowIndex;
    }

    private List<Integer> getAdjustRowsInSheet(XSSFSheet sheet, Map<String, String> rowsBase, Map<String, Integer> dimensionIndex, Map<Integer, Map<String, String>> rowDimMapInSheet, List<String> statisticsDims, List<Integer> insertRowIndexes, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds) {
        ArrayList<Integer> rowIndexes = new ArrayList<Integer>(16);
        for (Integer insertRowIndex : insertRowIndexes) {
            Map<String, String> dimMap = rowDimMapInSheet.get(insertRowIndex);
            if (dimMap == null || dimMap.size() == 0) {
                dimMap = this.getRowDimMapInSheet(sheet, dimensionIndex, insertRowIndex);
            }
            if (!this.isNotDetailAdjustRow(dimMap, rowsBase, statisticsDims, modelCacheHelper, viewIds)) continue;
            rowIndexes.add(insertRowIndex);
        }
        return rowIndexes;
    }

    private boolean isNotDetailAdjustRow(Map<String, String> dimMap, Map<String, String> rowsBase, List<String> statisticsDims, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds) {
        boolean isAdjustRow = true;
        for (String statisticsDim : statisticsDims) {
            String member = dimMap.get(statisticsDim);
            String memberBase = rowsBase.get(statisticsDim);
            int index = statisticsDims.indexOf(statisticsDim);
            if ((index != 0 || member.equals(memberBase)) && this.isHighLevel(statisticsDim, member, memberBase, modelCacheHelper, viewIds)) continue;
            isAdjustRow = false;
            break;
        }
        return isAdjustRow;
    }

    private boolean isHighLevel(String dimNumber, String memberNumber, String memberBaseNumber, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds) {
        Member member = modelCacheHelper.getMember(dimNumber, viewIds.get(dimNumber), memberNumber);
        if (member == null) {
            return false;
        }
        List<String> memberLongNumbers = Arrays.asList(member.getLongNumber().split("!"));
        Member memberBase = modelCacheHelper.getMember(dimNumber, viewIds.get(dimNumber), memberBaseNumber);
        if (memberBase == null) {
            return false;
        }
        List<String> longNumbers = Arrays.asList(memberBase.getLongNumber().split("!"));
        return longNumbers.containsAll(memberLongNumbers);
    }

    private Map<String, String> getRowDimMapInSheet(XSSFSheet sheet, Map<String, Integer> dimensionIndex, Integer insertRowIndex) {
        HashMap<String, String> dimMap = new HashMap<String, String>(16);
        XSSFRow row = sheet.getRow(insertRowIndex.intValue());
        for (Map.Entry<String, Integer> dimColInfo : dimensionIndex.entrySet()) {
            String key = dimColInfo.getKey();
            Integer index = dimColInfo.getValue();
            XSSFCell cell = row.getCell(index.intValue());
            String value = cell.getStringCellValue();
            dimMap.put(key, value);
        }
        return dimMap;
    }

    private void addValueToDefinedRow(XSSFSheet sheet, Map<String, String> others, Map<String, Integer> colIndexes, int existRowIndex, Set<String> notAggKey4DefDim) {
        XSSFRow row = sheet.getRow(existRowIndex);
        for (Map.Entry<String, Integer> colInfo : colIndexes.entrySet()) {
            String key = colInfo.getKey();
            if (notAggKey4DefDim != null && notAggKey4DefDim.contains(key)) continue;
            Integer index = colInfo.getValue();
            XSSFCell cell = row.getCell(index.intValue());
            String value = cell.getStringCellValue();
            String value_add = others.get(key);
            BigDecimal bigDecimal = ConvertUtils.toDecimal((Object)value);
            BigDecimal bigDecimal_add = ConvertUtils.toDecimal((Object)value_add);
            if (bigDecimal == null || bigDecimal_add == null) continue;
            BigDecimal afterCal = bigDecimal_add.add(bigDecimal);
            cell.setCellValue(afterCal.toString());
        }
    }

    private int fillNotDetailDataToSheet(XSSFSheet sheet, StatisticRow row, List<BaseExportCol> rowInfos, Map<String, Map<String, String>> notDetail_rows, Map<String, Map<String, String>> others, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds, List<String> statisticsDims, Map<String, Map<String, Integer>> colIndexes, Map<String, String> colMetric, List<Integer> insertRowIndexes, Map<Integer, Map<String, String>> rowDimMapInSheet, String definedDimension, int rowIndex, int level) {
        List<StatisticRow> notDetailRows = this.getCurRowRelateNotDetailRows(row.getRows(), notDetail_rows, others, modelCacheHelper, viewIds, statisticsDims);
        Map<String, String> othersMap = row.getOthers();
        for (StatisticRow notDetailRow : notDetailRows) {
            boolean containSelf = this.addValuesToAncestorRow(sheet, notDetailRow.getRows(), notDetailRow.getOthers(), colIndexes, insertRowIndexes, rowDimMapInSheet, modelCacheHelper, viewIds);
            if (containSelf) continue;
            HashMap<String, String> other_tmp = new HashMap<String, String>(notDetailRow.getOthers());
            this.updateOtherMapValue(other_tmp, othersMap, colMetric, null);
            Map<String, String> rows = notDetailRow.getRows();
            this.fillRowDataToSheet(sheet, rows, rowInfos, other_tmp, statisticsDims, modelCacheHelper, viewIds, definedDimension, ++rowIndex, level);
            insertRowIndexes.add(rowIndex);
            rowDimMapInSheet.put(rowIndex, rows);
        }
        return rowIndex;
    }

    private boolean addValuesToAncestorRow(XSSFSheet sheet, Map<String, String> rows, Map<String, String> othersMap, Map<String, Map<String, Integer>> colIndexes, List<Integer> insertRowIndexes, Map<Integer, Map<String, String>> rowDimMapInSheet, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds) {
        boolean containSelf = false;
        Map<String, Integer> dimension = colIndexes.get("dimension");
        Map<String, Integer> measure = colIndexes.get("measure");
        Map<String, Integer> text = colIndexes.get("text");
        for (Integer insertRowIndex : insertRowIndexes) {
            RowType rowType;
            XSSFRow row = sheet.getRow(insertRowIndex.intValue());
            Map<String, String> dimMap = rowDimMapInSheet.get(insertRowIndex);
            if (dimMap == null || dimMap.size() == 0) {
                if (dimMap == null) {
                    dimMap = new HashMap<String, String>(16);
                }
                this.getDimInfoInSheet(row, dimMap, dimension);
            }
            if (RowType.NO_RELATE == (rowType = this.getRowType(dimMap, rows, modelCacheHelper, viewIds))) continue;
            if (RowType.SELF == rowType) {
                this.updateSheetRowValue(row, othersMap, text, false);
                containSelf = true;
            }
            this.updateSheetRowValue(row, othersMap, measure, true);
        }
        return containSelf;
    }

    private void getDimInfoInSheet(XSSFRow row, Map<String, String> dimMap, Map<String, Integer> dimension) {
        for (Map.Entry<String, Integer> dimensionEntry : dimension.entrySet()) {
            String key = dimensionEntry.getKey();
            Integer value = dimensionEntry.getValue();
            XSSFCell cell = row.getCell(value.intValue());
            if (cell == null) continue;
            String cellValue = cell.getStringCellValue();
            dimMap.put(key, cellValue);
        }
    }

    private RowType getRowType(Map<String, String> dimMap, Map<String, String> rows, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds) {
        RowType rowType = RowType.NO_RELATE;
        if (dimMap == null) {
            return rowType;
        }
        if (dimMap.equals(rows)) {
            rowType = RowType.SELF;
        } else if (rows != null && rows.size() != 0 && rows.size() == dimMap.size()) {
            rowType = RowType.ANCESTOR;
            for (Map.Entry<String, String> row : rows.entrySet()) {
                String longNumber;
                List<String> ancestors;
                Member member;
                String compareMember;
                String dimKey = row.getKey();
                String memberNumber = row.getValue();
                if (memberNumber.equals(compareMember = dimMap.get(dimKey)) || (member = modelCacheHelper.getMember(dimKey, viewIds.get(dimKey), memberNumber)) == null || (ancestors = Arrays.asList((longNumber = member.getLongNumber()).split("!"))).contains(compareMember)) continue;
                rowType = RowType.NO_RELATE;
                break;
            }
        }
        return rowType;
    }

    private int getRowIndexInSheet(XSSFSheet sheet, Map<String, String> rows, Map<String, Integer> dimColIndexes, Map<Integer, Map<String, String>> rowDimMapInSheet, List<Integer> insertRowIndexes) {
        int existRowIndex = -1;
        for (Integer insertIndex : insertRowIndexes) {
            Map<String, String> rowMap = rowDimMapInSheet.get(insertIndex);
            if (rowMap == null || rowMap.size() == 0) {
                rowMap = this.getRowDimMapInSheet(sheet, dimColIndexes, insertIndex);
            }
            if (!rows.equals(rowMap)) continue;
            existRowIndex = insertIndex;
            break;
        }
        return existRowIndex;
    }

    private void updateSheetRowValue(XSSFRow row, Map<String, String> others, Map<String, Integer> colIndexes, boolean isMetric) {
        for (Map.Entry<String, Integer> colInfo : colIndexes.entrySet()) {
            String key = colInfo.getKey();
            Integer index = colInfo.getValue();
            XSSFCell cell = row.getCell(index.intValue());
            String value_add = others.get(key);
            if (isMetric) {
                String value = cell.getStringCellValue();
                BigDecimal bigDecimal = ConvertUtils.toDecimal((Object)value);
                BigDecimal bigDecimal_add = ConvertUtils.toDecimal((Object)value_add);
                if (bigDecimal != null && bigDecimal_add != null) {
                    BigDecimal afterCal = bigDecimal_add.add(bigDecimal);
                    cell.setCellValue(afterCal.toString());
                    continue;
                }
                cell.setCellValue(value_add);
                continue;
            }
            cell.setCellValue(value_add);
        }
    }

    private Map<String, Map<String, Integer>> getAllColIndex(List<BaseExportCol> rowInfos, Set<String> colKeys) {
        HashMap<String, Map<String, Integer>> colIndexes = new HashMap<String, Map<String, Integer>>(16);
        HashMap<String, Integer> dimColIndex = new HashMap<String, Integer>(16);
        HashMap<String, Integer> measureColIndex = new HashMap<String, Integer>(16);
        HashMap<String, Integer> numberCColIndex = new HashMap<String, Integer>(16);
        HashMap<String, Integer> textColIndex = new HashMap<String, Integer>(16);
        int index = -1;
        for (BaseExportCol rowInfo : rowInfos) {
            ColumnEnum columnEnum = rowInfo.getRowType();
            String number = rowInfo.getNumber();
            if (this.isDimensionColumn(columnEnum)) {
                dimColIndex.put(number, ++index);
                ++index;
                continue;
            }
            if (colKeys.contains("f" + number)) {
                measureColIndex.put("f" + number, ++index);
                continue;
            }
            if (ColumnEnum.NumberC == columnEnum) {
                numberCColIndex.put("f" + number, ++index);
                continue;
            }
            if (ColumnEnum.Text == columnEnum) {
                textColIndex.put("f" + number, ++index);
                continue;
            }
            ++index;
        }
        colIndexes.put("dimension", dimColIndex);
        colIndexes.put("measure", measureColIndex);
        colIndexes.put("numberC", numberCColIndex);
        colIndexes.put("text", textColIndex);
        return colIndexes;
    }

    private List<StatisticRow> getCurRowRelateNotDetailRows(Map<String, String> rows, Map<String, Map<String, String>> notDetailRows, Map<String, Map<String, String>> others, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds, List<String> statisticsDims) {
        List<StatisticRow> statisticRows = new ArrayList<StatisticRow>(16);
        if (statisticsDims.size() <= 1) {
            return statisticRows;
        }
        List<Pair<String, List<String>>> parentNumberList = this.getParentNumberList(statisticsDims, rows, modelCacheHelper, viewIds);
        statisticRows.addAll(this.getAllParentRows(parentNumberList, rows, 0));
        statisticRows = this.replaceByNotDetailRows(statisticRows, notDetailRows, others);
        return statisticRows;
    }

    private List<StatisticRow> replaceByNotDetailRows(List<StatisticRow> statisticRows, Map<String, Map<String, String>> notDetailRows, Map<String, Map<String, String>> others) {
        ArrayList<StatisticRow> rows = new ArrayList<StatisticRow>(statisticRows);
        for (StatisticRow statisticRow : statisticRows) {
            String index = this.getRowIndexInMap(statisticRow, notDetailRows);
            if (StringUtils.isEmpty((String)index)) {
                rows.remove(statisticRow);
                continue;
            }
            notDetailRows.remove(index);
            if (!CollectionUtils.isNotEmpty(others)) continue;
            HashMap<String, String> otherValues = new HashMap<String, String>(others.get(index));
            statisticRow.setOthers(otherValues);
        }
        return rows;
    }

    private String getRowIndexInMap(StatisticRow statisticRow, Map<String, Map<String, String>> notDetailRows) {
        String index = null;
        Map<String, String> rows = statisticRow.getRows();
        for (Map.Entry<String, Map<String, String>> notDetailRow : notDetailRows.entrySet()) {
            Map<String, String> rowValue = notDetailRow.getValue();
            if (!rows.equals(rowValue)) continue;
            index = notDetailRow.getKey();
            break;
        }
        return index;
    }

    private List<StatisticRow> getAllParentRows(List<Pair<String, List<String>>> parentNumberList, Map<String, String> rows, int index) {
        ArrayList<StatisticRow> statisticRows = new ArrayList<StatisticRow>(16);
        Pair<String, List<String>> parentPair = parentNumberList.get(index);
        String dimNumber = (String)parentPair.p1;
        List parentNumbers = (List)parentPair.p2;
        for (String parentNumber : parentNumbers) {
            HashMap<String, String> rowMap = new HashMap<String, String>(rows);
            rowMap.put(dimNumber, parentNumber);
            if (index < parentNumberList.size() - 1) {
                statisticRows.addAll(this.getAllParentRows(parentNumberList, rowMap, index + 1));
                continue;
            }
            StatisticRow statisticRow = new StatisticRow();
            statisticRow.setRows(rowMap);
            statisticRows.add(statisticRow);
        }
        return statisticRows;
    }

    private List<Pair<String, List<String>>> getParentNumberList(List<String> statisticsDims, Map<String, String> rows, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds) {
        ArrayList<Pair<String, List<String>>> parentNumberList = new ArrayList<Pair<String, List<String>>>(16);
        for (int i = 1; i < statisticsDims.size(); ++i) {
            String statisticsDim = statisticsDims.get(i);
            String statisticsMember = rows.get(statisticsDim);
            Member member = modelCacheHelper.getMember(statisticsDim, viewIds.get(statisticsDim), statisticsMember);
            String longNumber = member.getLongNumber();
            String[] split = longNumber.split("!");
            parentNumberList.add((Pair<String, List<String>>)new Pair((Object)statisticsDim, Arrays.asList(split)));
        }
        return parentNumberList;
    }

    private int fillChildRows(XSSFSheet sheet, StatisticRow row, List<BaseExportCol> rowInfos, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds, Map<String, Map<String, String>> notDetail_rows, Map<String, Map<String, String>> others, List<String> statisticsDims, Map<String, Map<String, Integer>> colIndexes, Map<String, String> colMetric, List<Integer> insertRowIndexes, Map<Integer, Map<String, String>> rowDimMapInSheet, int rowIndex, String definedDimension, int baseLevel, Set<String> notAggKey4DefDim) {
        List<StatisticRow> children = row.getChildren();
        if (children.size() == 0) {
            return rowIndex;
        }
        for (StatisticRow child : children) {
            int level = child.getLevel() - baseLevel;
            rowIndex = this.addDefinedRowToSheet(sheet, child, rowInfos, modelCacheHelper, viewIds, statisticsDims, colIndexes, insertRowIndexes, rowDimMapInSheet, colMetric, rowIndex, definedDimension, level, notAggKey4DefDim);
            rowIndex = this.fillNotDetailDataToSheet(sheet, child, rowInfos, notDetail_rows, others, modelCacheHelper, viewIds, statisticsDims, colIndexes, colMetric, insertRowIndexes, rowDimMapInSheet, definedDimension, rowIndex, level);
            this.fillRowDataToSheet(sheet, child.getRows(), rowInfos, child.getOthers(), statisticsDims, modelCacheHelper, viewIds, definedDimension, ++rowIndex, level);
            int afterRowIndex = this.fillChildRows(sheet, child, rowInfos, modelCacheHelper, viewIds, notDetail_rows, others, statisticsDims, colIndexes, colMetric, insertRowIndexes, rowDimMapInSheet, rowIndex, definedDimension, baseLevel, notAggKey4DefDim);
            if (afterRowIndex == rowIndex) continue;
            sheet.groupRow(++rowIndex, afterRowIndex);
            sheet.setRowGroupCollapsed(rowIndex, true);
            rowIndex = afterRowIndex;
        }
        return rowIndex;
    }

    private Map<String, Map<String, String>> getNotDetailRows(Map<String, Map<String, String>> rows, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds) {
        HashMap<String, Map<String, String>> tmp = new HashMap<String, Map<String, String>>(rows);
        HashMap<String, Map<String, String>> notDetailRows = new HashMap<String, Map<String, String>>(16);
        for (Map.Entry entry : tmp.entrySet()) {
            if (this.isAllDetailMember((Map)entry.getValue(), modelCacheHelper, viewIds)) continue;
            notDetailRows.put((String)entry.getKey(), (Map<String, String>)entry.getValue());
            rows.remove(entry.getKey());
        }
        return notDetailRows;
    }

    private List<StatisticRow> getCurrentLevelMembers(Map<String, Map<String, String>> rows, Map<String, Map<String, String>> others, Map<String, String> colMetric, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds, String statisticsDim, Set<String> ignoreAggKeys) {
        int minIndex = 99;
        List<StatisticRow> statisticRows = new ArrayList<StatisticRow>(16);
        for (Map.Entry<String, Map<String, String>> row : rows.entrySet()) {
            String index = row.getKey();
            Map<String, String> rowDimMap = row.getValue();
            Map<String, String> otherMap = others.get(index);
            if (otherMap == null) {
                otherMap = new HashMap<String, String>(16);
            }
            String statisticMember = rowDimMap.get(statisticsDim);
            Member member = modelCacheHelper.getMember(statisticsDim, viewIds.get(statisticsDim), statisticMember);
            int level = member.getLevel();
            if (level < minIndex) {
                minIndex = level;
                statisticRows = this.updateStatisticRows(statisticRows, statisticsDim, colMetric, ignoreAggKeys, modelCacheHelper, viewIds, level);
            }
            if (this.containRow(statisticRows, rowDimMap)) continue;
            StatisticRow statisticRow = new StatisticRow();
            statisticRow.setMember(member);
            statisticRow.setRows(rowDimMap);
            statisticRow.setOthers(otherMap);
            if (level == minIndex) {
                statisticRows.add(statisticRow);
                continue;
            }
            StatisticRow parentRow = this.getParentRow(statisticRow, statisticsDim, modelCacheHelper, viewIds, minIndex, colMetric);
            Map<String, String> rows_parent = parentRow.getRows();
            StatisticRow rowInList = this.getRowInList(statisticRows, rows_parent);
            if (rowInList == null) {
                statisticRows.add(parentRow);
                continue;
            }
            this.updateChildInfo(rowInList, parentRow, colMetric, ignoreAggKeys);
        }
        return statisticRows;
    }

    private void updateChildInfo(StatisticRow rowInList, StatisticRow parentRow, Map<String, String> colMetric, Set<String> ignoreAggKey) {
        List<StatisticRow> children = rowInList.getChildren();
        children.addAll(parentRow.getChildren());
        this.updateOtherMapValue(rowInList.getOthers(), parentRow.getOthers(), colMetric, ignoreAggKey);
    }

    private boolean containRow(List<StatisticRow> statisticRows, Map<String, String> rowDimMap) {
        StatisticRow statisticRow = this.getRowInList(statisticRows, rowDimMap);
        return statisticRow != null;
    }

    private StatisticRow getRowInList(List<StatisticRow> statisticRows, Map<String, String> rowDimMap) {
        StatisticRow statisticRow_result = null;
        for (StatisticRow statisticRow : statisticRows) {
            Map<String, String> rows = statisticRow.getRows();
            if (!rows.equals(rowDimMap)) continue;
            statisticRow_result = statisticRow;
            break;
        }
        return statisticRow_result;
    }

    private List<StatisticRow> updateStatisticRows(List<StatisticRow> statisticRows, String statisticsDim, Map<String, String> colMetric, Set<String> ignoreAggKeys, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds, int level) {
        ArrayList<StatisticRow> statisticRows_new = new ArrayList<StatisticRow>(16);
        for (StatisticRow statisticRow : statisticRows) {
            StatisticRow parent = this.getParentRow(statisticRow, statisticsDim, modelCacheHelper, viewIds, level, colMetric);
            Map<String, String> rows = parent.getRows();
            StatisticRow rowInList = this.getRowInList(statisticRows_new, rows);
            if (rowInList == null) {
                statisticRows_new.add(parent);
                continue;
            }
            this.updateChildInfo(rowInList, parent, colMetric, ignoreAggKeys);
        }
        return statisticRows_new;
    }

    private void updateOtherMapValue(Map<String, String> others_toAdd, Map<String, String> others, Map<String, String> colMetric, Set<String> ignoreColKeys) {
        others.forEach((key, value) -> {
            String metricTypeIndex = (String)colMetric.get(key);
            if (StringUtils.isNotEmpty((String)metricTypeIndex) && this.isCanAddType(metricTypeIndex)) {
                BigDecimal bigDecimal_toAdd;
                BigDecimal bigDecimal;
                BigDecimal bigDecimal2 = bigDecimal = ignoreColKeys != null && ignoreColKeys.contains(key) ? null : ConvertUtils.toDecimal((Object)value);
                if (bigDecimal == null) {
                    bigDecimal = new BigDecimal(0);
                }
                if ((bigDecimal_toAdd = ConvertUtils.toDecimal(others_toAdd.get(key))) == null) {
                    bigDecimal_toAdd = new BigDecimal(0);
                }
                BigDecimal afterAdd = bigDecimal_toAdd.add(bigDecimal);
                others_toAdd.put((String)key, afterAdd.toString());
            }
        });
    }

    private boolean isCanAddType(String metricTypeIndex) {
        return MetricDataTypeEnum.CURRENCY.getIndex().equals(metricTypeIndex) || MetricDataTypeEnum.NONMONETARY.getIndex().equals(metricTypeIndex) || MetricDataTypeEnum.RATE.getIndex().equals(metricTypeIndex);
    }

    private StatisticRow getParentRow(StatisticRow statisticRow, String statisticsDim, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds, int level, Map<String, String> colMetric) {
        StatisticRow parentRow = null;
        Map<String, String> rowDimMap = statisticRow.getRows();
        Map<String, String> otherMap = statisticRow.getOthers();
        Member member = statisticRow.getMember();
        String parentNumber = member.getParentNumber();
        Member parent = modelCacheHelper.getMember(statisticsDim, viewIds.get(statisticsDim), parentNumber);
        HashMap<String, String> rowDimMap_new = new HashMap<String, String>(rowDimMap);
        rowDimMap_new.put(statisticsDim, parent.getNumber());
        StatisticRow statisticRow_parent = new StatisticRow();
        statisticRow_parent.setMember(parent);
        statisticRow_parent.setRows(rowDimMap_new);
        HashMap<String, String> otherMap_new = new HashMap<String, String>(16);
        if (otherMap != null) {
            otherMap.entrySet().stream().filter(e -> colMetric.containsKey(e.getKey())).forEach(e -> {
                String cfr_ignored_0 = (String)otherMap_new.put((String)e.getKey(), (String)e.getValue());
            });
        }
        statisticRow_parent.setOthers(otherMap_new);
        List<StatisticRow> children = statisticRow_parent.getChildren();
        children.add(statisticRow);
        int level_parent = parent.getLevel();
        parentRow = level_parent > level ? this.getParentRow(statisticRow_parent, statisticsDim, modelCacheHelper, viewIds, level, colMetric) : statisticRow_parent;
        return parentRow;
    }

    private boolean isRowEmpty(XSSFRow row) {
        boolean isEmpty = false;
        if (row == null || (row.getLastCellNum() == 0 || row.getLastCellNum() == -1) && row.getPhysicalNumberOfCells() == 0) {
            isEmpty = true;
        } else {
            int firstCellNum = row.getFirstCellNum();
            short lastCellNum = row.getLastCellNum();
            for (int i = firstCellNum; i < lastCellNum; ++i) {
                XSSFCell cell = row.getCell(i);
                if (cell != null && !StringUtils.isEmpty((String)cell.getStringCellValue())) {
                    isEmpty = false;
                    break;
                }
                isEmpty = true;
            }
        }
        return isEmpty;
    }

    private Map<Map<String, String>, Map<String, BigDecimal>> getNoDetailOlapData(List<StatisticRow> rootRows, Long modelId, Long datasetId, Map<String, String> hiddenDimMemMap, Map<String, Map<String, String>> cols, Long tempId) {
        HashSet<String> aggColumnKeys = new HashSet<String>(16);
        List colCfgList = ApplyTemplateColCfgService.getInstance().getColCfgListByTemplateId(tempId);
        for (ApplyTemplateColCfgEntity colCfgEntity : colCfgList) {
            String aggregate = colCfgEntity.getAggregate();
            String colKey = colCfgEntity.getColkey();
            if (!ColCfgPropEnum.AGGREGATE.getValue().equals(aggregate)) continue;
            aggColumnKeys.add(colKey);
        }
        ArrayList<Map<String, String>> noDetailDimMemRows = new ArrayList<Map<String, String>>(16);
        this.filterNoDetailRows(rootRows, noDetailDimMemRows);
        HashMap dimMembers = new HashMap(16);
        BgApplyBillUtils instance = BgApplyBillUtils.getInstance();
        instance.mergeMap(hiddenDimMemMap, dimMembers);
        cols.values().forEach(value -> instance.mergeMap(value, dimMembers));
        HashMap<Map<String, String>, Map<String, BigDecimal>> rowAggColumnDataMap = new HashMap<Map<String, String>, Map<String, BigDecimal>>(16);
        noDetailDimMemRows.forEach(rowDimMemMap -> {
            HashMap<String, BigDecimal> aggColumnDataMap = new HashMap<String, BigDecimal>(aggColumnKeys.size());
            for (String aggColumnKey : aggColumnKeys) {
                aggColumnDataMap.put(aggColumnKey, new BigDecimal(0));
            }
            rowAggColumnDataMap.put((Map<String, String>)rowDimMemMap, (Map<String, BigDecimal>)aggColumnDataMap);
            instance.mergeMap(rowDimMemMap, dimMembers);
        });
        List bgCells = OlapCommService.getInstance().queryList(new QueryRequest(modelId, datasetId, dimMembers));
        for (BGCell bgCell : bgCells) {
            Map olapMemberMap = bgCell.getMemberMap();
            BigDecimal olapValue = ConvertUtils.toDecimal((Object)bgCell.getValue());
            for (Map.Entry rowEntry : rowAggColumnDataMap.entrySet()) {
                Map rowDimMembers = (Map)rowEntry.getKey();
                Map rowDataMap = (Map)rowEntry.getValue();
                for (Map.Entry entry : rowDataMap.entrySet()) {
                    String aggColumnKey = (String)entry.getKey();
                    Map<String, String> colDimMembers = cols.get(aggColumnKey);
                    HashMap<String, String> dimMemberMap = new HashMap<String, String>(rowDimMembers);
                    if (CollectionUtils.isNotEmpty(colDimMembers)) {
                        dimMemberMap.putAll(colDimMembers);
                    }
                    if (olapValue == null || !BgApplyBillUtils.getInstance().isSameDimMap(olapMemberMap, dimMemberMap)) continue;
                    rowDataMap.put(aggColumnKey, olapValue);
                }
            }
        }
        return rowAggColumnDataMap;
    }

    private void replaceNoDetailData(List<StatisticRow> rootRows, Map<String, Map<String, String>> notDetailRowsCopy, Map<String, Map<String, String>> others, Map<Map<String, String>, Map<String, BigDecimal>> noDetailOlapData) {
        for (StatisticRow rootRow : rootRows) {
            List<StatisticRow> children = rootRow.getChildren();
            if (!CollectionUtils.isNotEmpty(children)) continue;
            this.sumSubNoDetailData(rootRow, notDetailRowsCopy, others);
            Map<String, String> row = rootRow.getRows();
            Map<String, BigDecimal> olapDataMap = noDetailOlapData.get(row);
            if (olapDataMap != null) {
                Map<String, String> rootOthers = rootRow.getOthers();
                for (Map.Entry<String, String> entry : rootOthers.entrySet()) {
                    String fKey = entry.getKey();
                    String key = fKey.substring(1);
                    BigDecimal data = olapDataMap.get(key);
                    if (data == null) continue;
                    String value = entry.getValue();
                    if (StringUtils.isEmpty((String)value)) {
                        value = "0";
                    }
                    BigDecimal newValue = data.add(new BigDecimal(value));
                    rootOthers.put(fKey, newValue.toString());
                }
            }
            this.replaceNoDetailData(children, notDetailRowsCopy, others, noDetailOlapData);
        }
    }

    private void sumSubNoDetailData(StatisticRow parentRow, Map<String, Map<String, String>> notDetailRowsCopy, Map<String, Map<String, String>> others) {
        ArrayList<Map<String, String>> subNoDetailRows = new ArrayList<Map<String, String>>(16);
        this.getSubNoDetailRows(parentRow, subNoDetailRows);
        HashMap<String, String> newOthers = new HashMap<String, String>(parentRow.getOthers().size());
        for (Map.Entry<String, String> entry : parentRow.getOthers().entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringUtils.isEmpty((String)value)) {
                newOthers.put(key, value);
                continue;
            }
            newOthers.put(key, "0");
        }
        for (Map.Entry<String, Object> entry : notDetailRowsCopy.entrySet()) {
            Map dimMemMap = (Map)entry.getValue();
            String index = entry.getKey();
            Map<String, String> subDataMap = others.get(index);
            if (!subNoDetailRows.contains(dimMemMap)) continue;
            for (Map.Entry<String, String> entry2 : subDataMap.entrySet()) {
                String key = entry2.getKey();
                String data = (String)newOthers.get(key);
                if (StringUtils.isEmpty((String)data)) {
                    newOthers.put(key, data);
                    continue;
                }
                String value = entry2.getValue();
                if (StringUtils.isEmpty((String)value)) {
                    value = "0";
                }
                BigDecimal newValue = new BigDecimal(data).add(new BigDecimal(value));
                newOthers.put(key, newValue.toString());
            }
        }
        parentRow.setOthers(newOthers);
    }

    private void getSubNoDetailRows(StatisticRow parentRow, List<Map<String, String>> subNoDetailRows) {
        List<StatisticRow> children = parentRow.getChildren();
        for (StatisticRow childRow : children) {
            List<StatisticRow> rows = childRow.getChildren();
            if (CollectionUtils.isNotEmpty(rows)) {
                subNoDetailRows.add(childRow.getRows());
            }
            this.getSubNoDetailRows(childRow, subNoDetailRows);
        }
    }

    private void filterNoDetailRows(List<StatisticRow> rootRows, List<Map<String, String>> noDetailDimMemRows) {
        for (StatisticRow rootRow : rootRows) {
            List<StatisticRow> children = rootRow.getChildren();
            if (!CollectionUtils.isNotEmpty(children)) continue;
            noDetailDimMemRows.add(rootRow.getRows());
            this.filterNoDetailRows(children, noDetailDimMemRows);
        }
    }
}

