/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applybill.fileImport;

import com.alibaba.fastjson.JSON;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.rejectbill.entity.RejectMember;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.excelImport.POIUtils;
import kd.epm.eb.common.utils.fileImport.FileImportUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class RejectUserImportPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final Log LOG = LogFactory.getLog(RejectUserImportPlugin.class);
    private final FileImportUtils fileImportUtils = FileImportUtils.getInstance();
    private boolean errorFlag = false;
    private boolean insertFlag = false;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btndownload", "btndwntemp"});
        AttachmentPanel attach = (AttachmentPanel)this.getControl("attachmentpanelap");
        attach.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Object model;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && (model = customParams.get("model")) != null) {
            this.getPageCache().put("model", String.valueOf(model));
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"newandcover"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Button)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            TempFileCacheDownloadable fileCache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
            try {
                String file_url = this.getPageCache().get("file_url");
                if (file_url == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5bfc\u5165\u6570\u636e\u3002", (String)"RejectUserImportPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                List urls = (List)SerializationUtils.fromJsonString((String)file_url, List.class);
                LinkedHashMap<Integer, Set<String>> errorMap = new LinkedHashMap<Integer, Set<String>>(16, 0.75f, false);
                if (urls.isEmpty()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5bfc\u5165\u6570\u636e\u3002", (String)"RejectUserImportPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                if (urls.size() > 1) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5bfc\u5165\u79d1\u76ee\u6839\u8282\u70b9", (String)"RejectUserImportPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                for (String url : urls) {
                    String[] reqParams = new URL(url).getQuery().split("&");
                    HashMap<String, String> map = new HashMap<String, String>(reqParams.length);
                    for (String param : reqParams) {
                        String[] p = param.split("=");
                        map.put(p[0], p[1]);
                    }
                    TempFileCacheDownloadable.Content content = fileCache.get((String)map.get("configKey"), (String)map.get("id"));
                    InputStream inputStream = content.getInputStream();
                    this.fileImportUtils.resetCellMaxTextLength();
                    Workbook sheets = WorkbookFactory.create((InputStream)inputStream);
                    this.handleInputStream(sheets, errorMap);
                    if (!this.errorFlag) {
                        if (this.insertFlag) {
                            this.getView().returnDataToParent((Object)ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"RejectUserImportPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        } else {
                            this.getView().returnDataToParent((Object)ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u5bfc\u5165\u7684\u6570\u636e\u3002", (String)"RejectUserImportPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        }
                        this.getView().close();
                        continue;
                    }
                    if (this.insertFlag) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u90e8\u5206\u63d2\u5165\u6210\u529f\u3002\u5df2\u4e0b\u8f7d\u5bf9\u5e94\u9519\u8bef\u6587\u4ef6\u3002", (String)"RejectUserImportPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        this.getPageCache().put("insertFlag", "true");
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u3002\u8bf7\u4e0b\u8f7d\u5bf9\u5e94\u9519\u8bef\u6587\u4ef6\u3002", (String)"RejectUserImportPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        this.getPageCache().put("insertFlag", "false");
                    }
                    Workbook errorSheets = this.fillErrorMsg(sheets, errorMap);
                    String fileName = ResManager.loadKDString((String)"\u9a73\u56de\u8c03\u6574\u914d\u7f6e\u5bfc\u5165\u9519\u8bef\u4fe1\u606f.xlsx", (String)"RejectUserImportPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    this.fileImportUtils.downloadErrorFile(this.xssToInputSteam(errorSheets), this.getView(), fileName);
                }
            }
            catch (Exception e) {
                LOG.error(e.getMessage());
                LOG.error((Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
        if ("btndownload".equals(key)) {
            String path = "rejectuser/rejectuser_template.xlsx";
            InputStream inputStream = null;
            InputStream xssToInputSteam = null;
            String fileName = ResManager.loadKDString((String)"\u9a73\u56de\u8c03\u6574\u914d\u7f6e\u5bfc\u5165\u6a21\u677f.xlsx", (String)"RejectUserImportPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            try {
                inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(path);
                if (inputStream != null) {
                    XSSFWorkbook sheets = new XSSFWorkbook(inputStream);
                    this.transSheetName(sheets);
                    xssToInputSteam = this.xssToInputSteam((Workbook)sheets);
                    String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, xssToInputSteam, 10000);
                    if (StringUtils.isNotEmpty((CharSequence)url)) {
                        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
                    }
                }
            }
            catch (IOException e) {
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (xssToInputSteam != null) {
                    try {
                        xssToInputSteam.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private Workbook fillErrorMsg(Workbook sheets, Map<Integer, Set<String>> errorMap) {
        return this.doFillErrorMsgInBook(sheets, errorMap);
    }

    private Workbook doFillErrorMsgInBook(Workbook sheets, Map<Integer, Set<String>> errorMap) {
        Sheet sheetAt = sheets.getSheetAt(0);
        int index = 6;
        Row errorRow = sheetAt.getRow(1);
        Cell errorCell = errorRow.createCell(index);
        errorCell.setCellValue(ResManager.loadKDString((String)"\u9519\u8bef\u8be6\u60c5", (String)"RejectUserImportPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        POIUtils.setCellStyleOfRed((Cell)errorCell);
        for (Map.Entry<Integer, Set<String>> entry : errorMap.entrySet()) {
            Row row = sheetAt.getRow(entry.getKey().intValue());
            Cell cell = row.createCell(index);
            cell.setCellValue(StringUtils.join((Iterable)entry.getValue(), (String)";"));
            POIUtils.setCellStyleOfRed((Cell)cell);
        }
        return sheets;
    }

    private void handleInputStream(Workbook sheets, Map<Integer, Set<String>> errorMap) {
        Sheet sheetAt = sheets.getSheetAt(0);
        this.validTemplate(sheetAt);
        List<Row> rows = this.resolveSheet(sheetAt, errorMap);
        if (CollectionUtils.isNotEmpty(rows)) {
            this.doReSolveRowInfo(rows, errorMap);
        }
        if (!errorMap.isEmpty()) {
            this.errorFlag = true;
        }
    }

    private void doReSolveRowInfo(List<Row> rows, Map<Integer, Set<String>> errorMap) {
        Map<String, Long> allUser = this.getAllUser();
        Set<String> set = allUser.keySet();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        Map<String, Integer> rangeMap = this.getRangeMap();
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(10);
        for (Row row : rows) {
            String[] accountSplit;
            Cell userCell = this.fileImportUtils.getCell(row, 4);
            String userNumber = this.fileImportUtils.getCellStringValue(userCell);
            if (!set.contains(userNumber)) {
                String errorMsg = ResManager.loadResFormat((String)"\u7528\u6237%1\u4e0d\u5b58\u5728\u3002", (String)"RejectUserImportPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[]{userNumber});
                this.putErrorMsg(errorMap, row, errorMsg);
                continue;
            }
            HashMap<Member, Integer> entityMap = new HashMap<Member, Integer>(16);
            Cell entityCell = this.fileImportUtils.getCell(row, 0);
            String entityNumber = this.fileImportUtils.getCellStringValue(entityCell);
            String[] entitySplit = entityNumber.split(",");
            boolean needSave = true;
            for (String numberAndRange : entitySplit) {
                Integer rangeByName;
                String errorMsg;
                boolean valid = true;
                String number = "";
                String range = "";
                int start = numberAndRange.indexOf("[");
                int end = numberAndRange.indexOf("]");
                int lastStart = numberAndRange.lastIndexOf("[");
                int lastEnd = numberAndRange.lastIndexOf("]");
                if (lastStart != start || lastEnd != end) {
                    errorMsg = ResManager.loadResFormat((String)"\u8bf7\u4f7f\u7528\u82f1\u6587\u9017\u53f7\u5206\u9694\u6570\u636e%1\u3002", (String)"RejectUserImportPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[]{numberAndRange});
                    this.putErrorMsg(errorMap, row, errorMsg);
                    needSave = false;
                    continue;
                }
                if (start != -1) {
                    number = numberAndRange.substring(0, start).trim();
                } else {
                    valid = false;
                    errorMsg = ResManager.loadKDString((String)"\u8303\u56f4\u8bbe\u7f6e\u6709\u8bef\uff0c\u8bf7\u6b63\u786e\u4f7f\u7528", (String)"RejectUserImportPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]) + "\u201d[]\u201c";
                    this.putErrorMsg(errorMap, row, errorMsg);
                    needSave = false;
                }
                if (end > start) {
                    range = numberAndRange.substring(start + 1, end).trim();
                } else {
                    valid = false;
                    needSave = false;
                    errorMsg = ResManager.loadKDString((String)"\u8303\u56f4\u8bbe\u7f6e\u6709\u8bef\uff0c\u8bf7\u6b63\u786e\u4f7f\u7528", (String)"RejectUserImportPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]) + "\u201d[]\u201c";
                    this.putErrorMsg(errorMap, row, errorMsg);
                }
                if (!valid) continue;
                if (SysDimensionEnum.Entity.getNumber().equals(number)) {
                    errorMsg = ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5bfc\u5165\u7ec4\u7ec7\u6839\u8282\u70b9", (String)"RejectUserImportPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    this.putErrorMsg(errorMap, row, errorMsg);
                    needSave = false;
                    continue;
                }
                Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), null, number);
                if (member == null) {
                    valid = false;
                    String errorMsg2 = ResManager.loadResFormat((String)"\u7ec4\u7ec7\u7684\u7ef4\u5ea6\u6210\u5458\u201c%1\u201d\u4e0d\u5b58\u5728\u3002", (String)"RejectUserImportPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[]{number});
                    this.putErrorMsg(errorMap, row, errorMsg2);
                    needSave = false;
                }
                if ((rangeByName = rangeMap.get(range)) == null) {
                    String errorMsg3 = ResManager.loadResFormat((String)"\u8bf7\u68c0\u67e5\u7ec4\u7ec7\u7ef4\u5ea6\u6210\u5458\u201c%1\u201d\u7684\u8303\u56f4\u8bbe\u7f6e\u3002", (String)"RejectUserImportPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[]{number});
                    this.putErrorMsg(errorMap, row, errorMsg3);
                    needSave = false;
                    valid = false;
                }
                if (!valid) continue;
                entityMap.put(member, rangeByName);
            }
            List<RejectMember> entityMembers = this.getRejectMembers(entityMap, SysDimensionEnum.Entity.getNumber());
            String entityMemberJson = this.getMemberJson(entityMembers, SysDimensionEnum.Entity.getNumber(), "");
            String entityText = this.getMemberText(entityMembers);
            HashMap<Member, Integer> accountMap = new HashMap<Member, Integer>(16);
            Cell accountCell = this.fileImportUtils.getCell(row, 2);
            String accountNumber = this.fileImportUtils.getCellStringValue(accountCell);
            for (String numberAndRange : accountSplit = accountNumber.split(",")) {
                Integer rangeByName;
                String errorMsg;
                boolean valid = true;
                String number = "";
                String range = "";
                int start = numberAndRange.indexOf("[");
                int end = numberAndRange.indexOf("]");
                int lastStart = numberAndRange.lastIndexOf("[");
                int lastEnd = numberAndRange.lastIndexOf("]");
                if (lastStart != start || lastEnd != end) {
                    errorMsg = ResManager.loadResFormat((String)"\u8bf7\u4f7f\u7528\u82f1\u6587\u9017\u53f7\u5206\u9694\u6570\u636e%1\u3002", (String)"RejectUserImportPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[]{numberAndRange});
                    this.putErrorMsg(errorMap, row, errorMsg);
                    needSave = false;
                    continue;
                }
                if (start != -1) {
                    number = numberAndRange.substring(0, start).trim();
                } else {
                    valid = false;
                    errorMsg = ResManager.loadKDString((String)"\u8303\u56f4\u8bbe\u7f6e\u6709\u8bef\uff0c\u8bf7\u6b63\u786e\u4f7f\u7528", (String)"RejectUserImportPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]) + "\u201d[]\u201c";
                    this.putErrorMsg(errorMap, row, errorMsg);
                    needSave = false;
                }
                if (end > start) {
                    range = numberAndRange.substring(start + 1, end).trim();
                } else {
                    valid = false;
                    errorMsg = ResManager.loadKDString((String)"\u8303\u56f4\u8bbe\u7f6e\u6709\u8bef\uff0c\u8bf7\u6b63\u786e\u4f7f\u7528", (String)"RejectUserImportPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]) + "\u201d[]\u201c";
                    this.putErrorMsg(errorMap, row, errorMsg);
                    needSave = false;
                }
                if (!valid) continue;
                if (SysDimensionEnum.Account.getNumber().equals(number)) {
                    errorMsg = ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5bfc\u5165\u79d1\u76ee\u6839\u8282\u70b9", (String)"RejectUserImportPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    this.putErrorMsg(errorMap, row, errorMsg);
                    needSave = false;
                    continue;
                }
                Member member = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, number);
                if (member == null) {
                    valid = false;
                    String errorMsg4 = ResManager.loadResFormat((String)"\u79d1\u76ee\u7684\u7ef4\u5ea6\u6210\u5458%1\u4e0d\u5b58\u5728\u3002", (String)"RejectUserImportPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[]{number});
                    this.putErrorMsg(errorMap, row, errorMsg4);
                    needSave = false;
                }
                if ((rangeByName = rangeMap.get(range)) == null) {
                    String errorMsg5 = ResManager.loadResFormat((String)"\u8bf7\u68c0\u67e5\u79d1\u76ee\u7ef4\u5ea6\u6210\u5458\u201c%1\u201d\u7684\u8303\u56f4\u8bbe\u7f6e\u3002", (String)"RejectUserImportPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[]{number});
                    this.putErrorMsg(errorMap, row, errorMsg5);
                    valid = false;
                    needSave = false;
                }
                if (!valid) continue;
                accountMap.put(member, rangeByName);
            }
            if (!needSave) continue;
            List<RejectMember> accountMembers = this.getRejectMembers(accountMap, SysDimensionEnum.Account.getNumber());
            String memberJson = this.getMemberJson(accountMembers, SysDimensionEnum.Account.getNumber(), entityMemberJson);
            String accountText = this.getMemberText(accountMembers);
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_billrejectconfig"));
            dynamicObject.set("rejectuser", (Object)allUser.get(userNumber));
            dynamicObject.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            dynamicObject.set("model", (Object)this.getModelId());
            dynamicObject.set("entitiytext", (Object)entityText);
            dynamicObject.set("accounttext", (Object)accountText);
            dynamicObject.set("memberjson", (Object)memberJson);
            dynamicObject.set("createrid", (Object)UserUtils.getUserId());
            dynamicObject.set("createdate", (Object)TimeServiceHelper.now());
            dynamicObjects.add(dynamicObject);
        }
        if (dynamicObjects.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
            this.insertFlag = true;
        }
    }

    private String getMemberText(List<RejectMember> rejectMembers) {
        ArrayList<String> txtList = new ArrayList<String>(10);
        for (RejectMember rm : rejectMembers) {
            String memberText = rm.getMemberName() + "[" + RangeEnum.getRangeByVal((int)rm.getMemberRange()).getName() + "]";
            txtList.add(memberText);
        }
        return StringUtils.join(txtList, (String)",");
    }

    private String getMemberJson(List<RejectMember> rejectMembers, String dimNumber, String memberJson) {
        List<Object> members = StringUtils.isEmpty((CharSequence)memberJson) ? new ArrayList(10) : JSON.parseArray((String)memberJson, RejectMember.class);
        members = members.stream().filter(e -> !dimNumber.equals(e.getDimNumber())).collect(Collectors.toList());
        members.addAll(rejectMembers);
        return JSON.toJSONString(members);
    }

    private List<RejectMember> getRejectMembers(Map<Member, Integer> memberMap, String dimNumber) {
        ArrayList<RejectMember> members = new ArrayList<RejectMember>(memberMap.size());
        for (Map.Entry<Member, Integer> entry : memberMap.entrySet()) {
            RejectMember rm = new RejectMember(dimNumber, entry.getKey().getNumber(), entry.getKey().getName(), entry.getValue());
            members.add(rm);
        }
        return members;
    }

    private List<Row> resolveSheet(Sheet sheet, Map<Integer, Set<String>> errorMap) {
        int realCount;
        ArrayList<Row> rows = new ArrayList<Row>(16);
        for (int i = realCount = this.fileImportUtils.getRealCount(sheet, 1, 5); i > 1; --i) {
            Row row = sheet.getRow(i);
            if (row == null || !this.validMustInput(row, errorMap)) continue;
            rows.add(row);
        }
        return rows;
    }

    private boolean validMustInput(Row row, Map<Integer, Set<String>> errorMap) {
        String errorMsg;
        Cell entityNumberCell = this.fileImportUtils.getCell(row, 0);
        Cell accountNumberCell = this.fileImportUtils.getCell(row, 2);
        Cell rejectUserNumberCell = this.fileImportUtils.getCell(row, 4);
        String entityNumber = this.fileImportUtils.getCellStringValue(entityNumberCell);
        String accountNumber = this.fileImportUtils.getCellStringValue(accountNumberCell);
        String rejectUserNumber = this.fileImportUtils.getCellStringValue(rejectUserNumberCell);
        boolean needResolve = true;
        if (StringUtils.isEmpty((CharSequence)entityNumber)) {
            needResolve = false;
            errorMsg = ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u4e3a\u7a7a", (String)"RejectUserImportPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.putErrorMsg(errorMap, row, errorMsg);
        }
        if (StringUtils.isEmpty((CharSequence)accountNumber)) {
            needResolve = false;
            errorMsg = ResManager.loadKDString((String)"\u79d1\u76ee\u7f16\u7801\u4e3a\u7a7a", (String)"RejectUserImportPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.putErrorMsg(errorMap, row, errorMsg);
        }
        if (StringUtils.isEmpty((CharSequence)rejectUserNumber)) {
            needResolve = false;
            errorMsg = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u9a73\u56de\u8c03\u6574\u4eba\u7f16\u7801\u3002", (String)"RejectUserImportPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.putErrorMsg(errorMap, row, errorMsg);
        }
        return needResolve;
    }

    private void transSheetName(XSSFWorkbook sheets) {
        XSSFSheet sheetAt = sheets.getSheetAt(0);
        XSSFRow row = sheetAt.getRow(0);
        XSSFCell cell = row.getCell(0);
        cell.setCellValue(ResManager.loadKDString((String)"1\u3001\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u7070\u8272\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\n2\u3001\u7ea2\u8272\u7684\u5b57\u6bb5\u4e3a\u5fc5\u5f55\u5b57\u6bb5", (String)"RejectUserImportPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        XSSFRow titleRow = sheetAt.getRow(1);
        XSSFCell entityNumberCell = titleRow.getCell(0);
        XSSFCell entityNameCell = titleRow.getCell(1);
        XSSFCell accountNumberCell = titleRow.getCell(2);
        XSSFCell accountNameCell = titleRow.getCell(3);
        XSSFCell rejectUserNumberCell = titleRow.getCell(4);
        XSSFCell rejectUserNameCell = titleRow.getCell(5);
        entityNameCell.setCellValue(ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0", (String)"RejectUserImportPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        accountNameCell.setCellValue(ResManager.loadKDString((String)"\u79d1\u76ee\u540d\u79f0", (String)"RejectUserImportPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        rejectUserNameCell.setCellValue(ResManager.loadKDString((String)"\u9a73\u56de\u8c03\u6574\u4eba\u540d\u79f0", (String)"RejectUserImportPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        entityNumberCell.setCellValue(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801", (String)"RejectUserImportPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.fileImportUtils.setCellTips((Cell)entityNumberCell, ResManager.loadKDString((String)"\u7ec4\u7ec7\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u540e\u7d27\u8ddf\u8303\u56f4\uff0c\u8303\u56f4\u7528[]\u5305\u88f9\uff0c\u53ef\u9009\u8303\u56f4\u6709\u4ec5\u81ea\u5df1\u3001\u76f4\u63a5\u4e0b\u7ea7_\u4e0d\u542b\u81ea\u5df1\u3001\u76f4\u63a5\u4e0b\u7ea7_\u542b\u81ea\u5df1\u3001\u6240\u6709\u4e0b\u7ea7_\u4e0d\u542b\u81ea\u5df1\u3001\u6240\u6709\u4e0b\u7ea7_\u542b\u81ea\u5df1\u3001\u6240\u6709\u5e73\u7ea7_\u4e0d\u542b\u81ea\u5df1\u3001\u6240\u6709\u5e73\u7ea7_\u542b\u81ea\u5df1\u3001\u6240\u6709\u4e0b\u7ea7_\u4ec5\u660e\u7ec6\u6210\u5458\u3001\u6240\u6709\u4e0b\u7ea7_\u4ec5\u975e\u660e\u7ec6\u6210\u5458\uff0c\u591a\u4e2a\u6210\u5458\u4e4b\u95f4\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00", (String)"RejectUserImportPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        accountNumberCell.setCellValue(ResManager.loadKDString((String)"\u79d1\u76ee\u7f16\u7801", (String)"RejectUserImportPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        rejectUserNumberCell.setCellValue(ResManager.loadKDString((String)"\u9a73\u56de\u8c03\u6574\u4eba\u7f16\u7801", (String)"RejectUserImportPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.fileImportUtils.setCellTips((Cell)accountNumberCell, ResManager.loadKDString((String)"\u79d1\u76ee\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u540e\u7d27\u8ddf\u8303\u56f4\uff0c\u8303\u56f4\u7528[]\u5305\u88f9\uff0c\u53ef\u9009\u8303\u56f4\u6709\u4ec5\u81ea\u5df1\u3001\u76f4\u63a5\u4e0b\u7ea7_\u4e0d\u542b\u81ea\u5df1\u3001\u76f4\u63a5\u4e0b\u7ea7_\u542b\u81ea\u5df1\u3001\u6240\u6709\u4e0b\u7ea7_\u4e0d\u542b\u81ea\u5df1\u3001\u6240\u6709\u4e0b\u7ea7_\u542b\u81ea\u5df1\u3001\u6240\u6709\u5e73\u7ea7_\u4e0d\u542b\u81ea\u5df1\u3001\u6240\u6709\u5e73\u7ea7_\u542b\u81ea\u5df1\u3001\u6240\u6709\u4e0b\u7ea7_\u4ec5\u660e\u7ec6\u6210\u5458\u3001\u6240\u6709\u4e0b\u7ea7_\u4ec5\u975e\u660e\u7ec6\u6210\u5458\uff0c\u591a\u4e2a\u6210\u5458\u4e4b\u95f4\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00", (String)"RejectUserImportPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private void putErrorMsg(Map<Integer, Set<String>> errorMap, Row row, String errorMsg) {
        Set<String> strings = errorMap.get(row.getRowNum());
        if (CollectionUtils.isEmpty(strings)) {
            strings = new HashSet<String>(10);
        }
        strings.add(errorMsg);
        errorMap.put(row.getRowNum(), strings);
    }

    private InputStream xssToInputSteam(Workbook sheets) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        sheets.write((OutputStream)bos);
        byte[] bytes = bos.toByteArray();
        return new ByteArrayInputStream(bytes);
    }

    private void validTemplate(Sheet sheetAt) {
        Row row = this.fileImportUtils.getRow(sheetAt, 1);
        Cell entityNumberCell = this.fileImportUtils.getCell(row, 0);
        Cell entityNameCell = this.fileImportUtils.getCell(row, 1);
        Cell accountNumberCell = this.fileImportUtils.getCell(row, 2);
        Cell accountNameCell = this.fileImportUtils.getCell(row, 3);
        Cell rejectUserNumberCell = this.fileImportUtils.getCell(row, 4);
        Cell rejectUserNameCell = this.fileImportUtils.getCell(row, 5);
        String entityNumber = this.fileImportUtils.getCellStringValue(entityNumberCell);
        String entityName = this.fileImportUtils.getCellStringValue(entityNameCell);
        String accountNumber = this.fileImportUtils.getCellStringValue(accountNumberCell);
        String accountName = this.fileImportUtils.getCellStringValue(accountNameCell);
        String rejectUserNumber = this.fileImportUtils.getCellStringValue(rejectUserNumberCell);
        String rejectUserName = this.fileImportUtils.getCellStringValue(rejectUserNameCell);
        if (!(StringUtils.equals((CharSequence)this.getLocalName("entityNumber"), (CharSequence)entityNumber) && StringUtils.equals((CharSequence)this.getLocalName("entityName"), (CharSequence)entityName) && StringUtils.equals((CharSequence)this.getLocalName("accountNumber"), (CharSequence)accountNumber) && StringUtils.equals((CharSequence)this.getLocalName("accountName"), (CharSequence)accountName) && StringUtils.equals((CharSequence)this.getLocalName("rejectUserNumber"), (CharSequence)rejectUserNumber) && StringUtils.equals((CharSequence)this.getLocalName("rejectUserName"), (CharSequence)rejectUserName))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u683c\u5f0f\u7684\u6a21\u677f\u3002", (String)"RejectUserImportPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String insertFlag = this.getPageCache().get("insertFlag");
        if ("true".equals(insertFlag)) {
            this.getView().returnDataToParent((Object)ResManager.loadKDString((String)"\u90e8\u5206\u5bfc\u5165\u6210\u529f", (String)"RejectUserImportPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private Map<String, Integer> getRangeMap() {
        HashMap<String, Integer> rangeMap = new HashMap<String, Integer>();
        String only = ResManager.loadKDString((String)"\u4ec5\u81ea\u5df1", (String)"RejectUserImportPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String directsub_exclude = ResManager.loadKDString((String)"\u76f4\u63a5\u4e0b\u7ea7_\u4e0d\u542b\u81ea\u5df1", (String)"RejectUserImportPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String directsub = ResManager.loadKDString((String)"\u76f4\u63a5\u4e0b\u7ea7_\u542b\u81ea\u5df1", (String)"RejectUserImportPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String all_exclude = ResManager.loadKDString((String)"\u6240\u6709\u4e0b\u7ea7_\u4e0d\u542b\u81ea\u5df1", (String)"RejectUserImportPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String all = ResManager.loadKDString((String)"\u6240\u6709\u4e0b\u7ea7_\u542b\u81ea\u5df1", (String)"RejectUserImportPlugin_38", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String peers_exclude = ResManager.loadKDString((String)"\u6240\u6709\u5e73\u7ea7_\u4e0d\u542b\u81ea\u5df1", (String)"RejectUserImportPlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String peers = ResManager.loadKDString((String)"\u6240\u6709\u5e73\u7ea7_\u542b\u81ea\u5df1", (String)"RejectUserImportPlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String all_detail = ResManager.loadKDString((String)"\u6240\u6709\u4e0b\u7ea7_\u4ec5\u660e\u7ec6\u6210\u5458", (String)"RejectUserImportPlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String all_notdetail = ResManager.loadKDString((String)"\u6240\u6709\u4e0b\u7ea7_\u4ec5\u975e\u660e\u7ec6\u6210\u5458", (String)"RejectUserImportPlugin_41", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        rangeMap.put(only, 10);
        rangeMap.put(directsub_exclude, 20);
        rangeMap.put(directsub, 30);
        rangeMap.put(all_exclude, 40);
        rangeMap.put(all, 50);
        rangeMap.put(peers_exclude, 60);
        rangeMap.put(peers, 70);
        rangeMap.put(all_detail, 90);
        rangeMap.put(all_notdetail, 110);
        return rangeMap;
    }

    private Map<String, Long> getAllUser() {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryUser", (String)"bos_user", (String)"number,id", (QFilter[])new QFilter[0], null);
        HashMap<String, Long> userMap = new HashMap<String, Long>(16);
        while (dataSet.hasNext()) {
            kd.bos.algo.Row next = dataSet.next();
            String number = next.getString("number");
            Long id = next.getLong("id");
            userMap.put(number, id);
        }
        return userMap;
    }

    private String getLocalName(String type) {
        String localName = "";
        switch (type) {
            case "entityNumber": {
                localName = ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801", (String)"RejectUserImportPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "entityName": {
                localName = ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0", (String)"RejectUserImportPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "accountNumber": {
                localName = ResManager.loadKDString((String)"\u79d1\u76ee\u7f16\u7801", (String)"RejectUserImportPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "accountName": {
                localName = ResManager.loadKDString((String)"\u79d1\u76ee\u540d\u79f0", (String)"RejectUserImportPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "rejectUserNumber": {
                localName = ResManager.loadKDString((String)"\u9a73\u56de\u8c03\u6574\u4eba\u7f16\u7801", (String)"RejectUserImportPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "rejectUserName": {
                localName = ResManager.loadKDString((String)"\u9a73\u56de\u8c03\u6574\u4eba\u540d\u79f0", (String)"RejectUserImportPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        return localName;
    }

    private Long getModelId() {
        String model = this.getPageCache().get("model");
        if (StringUtils.isNotEmpty((CharSequence)model)) {
            return IDUtils.toLong((Object)model);
        }
        return 0L;
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
        String file_url = this.getPageCache().get("file_url");
        List urls = file_url == null ? new ArrayList(10) : (List)SerializationUtils.fromJsonString((String)file_url, List.class);
        for (Object url : evt.getUrls()) {
            urls.add((String)((Map)url).get("url"));
        }
        if (urls.size() > 0) {
            this.getPageCache().put("file_url", SerializationUtils.toJsonString(urls));
        }
    }

    public void afterRemove(UploadEvent evt) {
        String file_url = this.getPageCache().get("file_url");
        if (file_url != null) {
            Object[] objects;
            List urls = (List)SerializationUtils.fromJsonString((String)file_url, List.class);
            for (Object object : objects = evt.getUrls()) {
                String url = (String)((Map)object).get("url");
                urls.remove(url);
            }
            this.getPageCache().put("file_url", SerializationUtils.toJsonString((Object)urls));
        }
    }
}

