/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applybill.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.applybill.util.ApplyBillPluginUitl;
import kd.epm.eb.business.applybill.util.ApplyTemplateUtils;
import kd.epm.eb.business.applybill.util.BgApplyBillUtils;
import kd.epm.eb.common.applybill.ApplyBillConstant;
import kd.epm.eb.common.applybill.ApplyBizplanHelper;
import kd.epm.eb.common.applybill.EntityRowDataType;
import kd.epm.eb.common.applybill.SchemeAssignDimGroup;
import kd.epm.eb.common.applybill.TemplateBizPlan;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.ColumnEnum;
import kd.epm.eb.common.applytemplatecolumn.ColumnList;
import kd.epm.eb.common.applytemplatecolumn.FieldTypeEnum;
import kd.epm.eb.common.applytemplatecolumn.TextColumn;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;

public class ApplyDataCompareToolPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String MODEL = "model";
    private static final String DATASET = "dataset";
    private static final String TEMPLATE = "template";
    private static final String MULDATA_QUERY = "muldataquery";
    private static final String MAINSUB_QUERY = "mainsubquery";
    private static final String TABLE_QUERY = "tablequery";
    private static final String MULDATA_ENTRYENTITY = "muldataentryentity";
    private static final String MAINSUB_ENTRYENTITY = "mainsubentryentity";
    private static final int MAX_USER_DEFINED_SIZE = 8;
    private static final Map<String, String> fieldIndexMap = new LinkedHashMap<String, String>();
    private static final Map<String, String> billTypeMapEntityKey = new HashMap<String, String>();
    private static final String applyType = "apply";
    private static final String auditType = "audit";
    private static final String PRE = "sub_";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(DATASET);
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        basedataEdit = (BasedataEdit)this.getControl(TEMPLATE);
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Button mulquery = (Button)this.getControl(MULDATA_QUERY);
        mulquery.addClickListener((ClickListener)this);
        Button mainsubquery = (Button)this.getControl(MAINSUB_QUERY);
        mainsubquery.addClickListener((ClickListener)this);
        Button tablequery = (Button)this.getControl(TABLE_QUERY);
        tablequery.addClickListener((ClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyKey;
        super.propertyChanged(e);
        switch (propertyKey = e.getProperty().getName()) {
            case "model": 
            case "dataset": {
                this.initMulDataEntry();
                this.initMainSubDataEntry();
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String propertyKey;
        switch (propertyKey = e.getProperty().getName()) {
            case "dataset": {
                this.beforeF7Select_dateset(e);
                break;
            }
            case "template": {
                this.beforeF7Select_template(e);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control Control2 = (Control)evt.getSource();
        String key = Control2.getKey();
        if (key.equals(MULDATA_QUERY)) {
            this.muldataQuery();
        } else if (key.equals(MAINSUB_QUERY)) {
            this.mainSubQuery();
        } else if (key.equals(TABLE_QUERY)) {
            this.tableQuery();
        }
    }

    private void beforeF7Select_dateset(BeforeF7SelectEvent event) {
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        ArrayList<QFilter> filters = ((BasedataEdit)event.getSource()).getQFilters();
        if (filters == null) {
            filters = new ArrayList<QFilter>();
        }
        filters.add(new QFilter(MODEL, "=", (Object)this.getModelId()));
        showParameter.setListFilterParameter(new ListFilterParameter(filters, null));
    }

    private void beforeF7Select_template(BeforeF7SelectEvent event) {
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        ArrayList<QFilter> filters = ((BasedataEdit)event.getSource()).getQFilters();
        if (filters == null) {
            filters = new ArrayList<QFilter>();
        }
        filters.add(new QFilter(MODEL, "=", (Object)this.getModelId()));
        filters.add(new QFilter(DATASET, "=", (Object)this.getDataSetId()));
        showParameter.setListFilterParameter(new ListFilterParameter(filters, null));
    }

    public Long getModelId() {
        DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
        return model != null ? model.getLong("id") : 0L;
    }

    public Long getDataSetId() {
        DynamicObject dataset = (DynamicObject)this.getModel().getValue(DATASET);
        return dataset != null ? dataset.getLong("id") : 0L;
    }

    private void tableQuery() {
        DynamicObject templateModel = (DynamicObject)this.getModel().getValue(TEMPLATE);
        if (templateModel == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u3002", (String)"BgTemplateListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        long templateId = templateModel.getLong("id");
        long modelId = this.getModelId();
        DynamicObject templateObj = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_applytemplate", (String)"id,name,number,amountunit,dataset_id,createtime,cachedata_tag,entrycfgjson_tag", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)templateId)});
        if (templateObj == null) {
            return;
        }
        ColumnList columnList = ApplyTemplateUtils.getEntrycfgByApplyTemplate((DynamicObject)templateObj);
        Map entityinfomap = columnList.getEntityinfomap();
        String mainTable = (String)entityinfomap.get("mainentryentity");
        String bizTable = (String)entityinfomap.get("bizentryentity");
        TemplateBizPlan templateBizPlan = ApplyBizplanHelper.getTemplateBizPlan((Long)templateId, (ColumnList)columnList);
        List bizPlans = templateBizPlan.getBizPlans();
        HashMap<String, String> tabkeyMapName = new HashMap<String, String>(16);
        for (TemplateBizPlan.BizPlan bizPlan : bizPlans) {
            tabkeyMapName.put(bizPlan.getTabkey(), bizPlan.getTabName());
        }
        ArrayList<String> messageInfo = new ArrayList<String>(16);
        messageInfo.add(mainTable);
        messageInfo.add(bizTable);
        for (Map.Entry stringStringEntry : tabkeyMapName.entrySet()) {
            messageInfo.add((String)stringStringEntry.getKey() + ":" + (String)stringStringEntry.getValue());
        }
        this.getView().showMessage(String.join((CharSequence)"\r\n", messageInfo));
    }

    private void muldataQuery() {
        DynamicObject templateModel = (DynamicObject)this.getModel().getValue(TEMPLATE);
        if (templateModel == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u3002", (String)"BgTemplateListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        long templateId = templateModel.getLong("id");
        long modelId = this.getModelId();
        DynamicObject templateObj = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_applytemplate", (String)"id,name,number,amountunit,dataset_id,createtime,cachedata_tag,entrycfgjson_tag", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)templateId)});
        if (templateObj == null) {
            return;
        }
        this.getModel().deleteEntryData(MULDATA_ENTRYENTITY);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        ColumnList columnList = ApplyTemplateUtils.getEntrycfgByApplyTemplate((DynamicObject)templateObj);
        Map entityinfomap = columnList.getEntityinfomap();
        String mainTable = (String)entityinfomap.get("mainentryentity");
        String bizTable = (String)entityinfomap.get("bizentryentity");
        Long datasetId = templateObj.getLong("dataset_id");
        List columns = (List)columnList.getColumns();
        List<BaseColumn> mainColumns = columns.stream().filter(s -> s.getCategory().equals("h")).collect(Collectors.toList());
        Map columnIndexMap = ApplyTemplateUtils.getColumnIndexMap(mainColumns);
        List<Object[]> mainDatas = this.getBatchBillDataWhere(mainTable, mainColumns, "");
        int billnumberIndex = 2;
        int billTypeIndex = 1;
        List dimensions = modelCacheHelper.getDimensionList(this.getDataSetId());
        HashMap<String, Set> map = new HashMap<String, Set>(16);
        for (Object[] objectArray : mainDatas) {
            Set billnumbers;
            Object type = objectArray[billTypeIndex];
            Object number = objectArray[billnumberIndex];
            if (type == null || number == null) continue;
            if (type.toString().contains(applyType)) {
                billnumbers = map.computeIfAbsent(applyType, s -> new HashSet(16));
                billnumbers.add(number.toString());
                continue;
            }
            if (!type.toString().contains(auditType)) continue;
            billnumbers = map.computeIfAbsent(auditType, s -> new HashSet(16));
            billnumbers.add(number.toString());
        }
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Set billnumbers = (Set)entry.getValue();
            SchemeAssignDimGroup reportSchemeAssignDimGroupByBill = key.equals(applyType) ? this.getReportSchemeAssignDimGroupByBill(billnumbers, "applyscheme", "billnumber", billTypeMapEntityKey.get(key)) : this.getReportSchemeAssignDimGroupByBill(billnumbers, "reportscheme", "billno", billTypeMapEntityKey.get(key));
            if (reportSchemeAssignDimGroupByBill == null) continue;
            Map varInfo = ReportVarUtil.getVarInfo((SchemeAssignDimGroup)reportSchemeAssignDimGroupByBill);
            ColumnList columnList2 = ApplyTemplateUtils.getEntrycfgByApplyTemplate((DynamicObject)templateObj);
            ApplyTemplateUtils.changeVarOnColumn((ColumnList)columnList2, (Long)datasetId, (IModelCacheHelper)modelCacheHelper, (Map)varInfo);
            Map HiddentDimMemMap = BgApplyBillUtils.getInstance().getHiddenDimMemMap(templateObj.getString("cachedata_tag"), datasetId, modelCacheHelper, varInfo);
            List<Object[]> entityData = mainDatas.stream().filter(s -> billnumbers.contains(s[billnumberIndex])).collect(Collectors.toList());
            List<BaseColumn> mainColumns2 = columnList2.getColumns().stream().filter(s -> s.getCategory().equals("h")).collect(Collectors.toList());
            this.queryDimenisonData(mainColumns2, columnIndexMap, entityData, this.getDataSetId(), HiddentDimMemMap, templateId, dimensions);
        }
    }

    private void mainSubQuery() {
        DynamicObject templateModel = (DynamicObject)this.getModel().getValue(TEMPLATE);
        if (templateModel == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u3002", (String)"BgTemplateListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        long templateId = templateModel.getLong("id");
        long modelId = this.getModelId();
        DynamicObject templateObj = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_applytemplate", (String)"id,name,number,amountunit,dataset_id,createtime,cachedata_tag,entrycfgjson_tag", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)templateId)});
        if (templateObj == null) {
            return;
        }
        this.getModel().deleteEntryData(MAINSUB_ENTRYENTITY);
        String unit = templateObj.getString("amountunit");
        unit = StringUtils.isEmpty((CharSequence)unit) ? "1" : unit;
        BigDecimal unitData = BgApplyBillUtils.getInstance().getUnitData(unit);
        this.getModel().deleteEntryData(MAINSUB_ENTRYENTITY);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        ColumnList columnList = ApplyTemplateUtils.getEntrycfgByApplyTemplate((DynamicObject)templateObj);
        TemplateBizPlan templateBizPlan = ApplyBizplanHelper.getTemplateBizPlan((Long)templateId, (ColumnList)columnList);
        List bizPlans = templateBizPlan.getBizPlans();
        HashMap<String, String> tabkeyMapName = new HashMap<String, String>(16);
        for (TemplateBizPlan.BizPlan bizPlan : bizPlans) {
            tabkeyMapName.put(bizPlan.getTabkey(), bizPlan.getTabName());
        }
        Map entityinfomap = columnList.getEntityinfomap();
        String mainTable = (String)entityinfomap.get("mainentryentity");
        String bizTable = (String)entityinfomap.get("bizentryentity");
        Long datasetId = templateObj.getLong("dataset_id");
        List columns = (List)columnList.getColumns();
        List<BaseColumn> mainColumns = columns.stream().filter(s -> s.getCategory().equals("h")).collect(Collectors.toList());
        List<BaseColumn> bizColumns = columns.stream().filter(s -> s.getCategory().equals("e")).collect(Collectors.toList());
        TextColumn combinedimension = new TextColumn();
        combinedimension.setKey(ApplyTemplateUtils.FIELD_COMBINEDIMENSION);
        combinedimension.setCategory("e");
        combinedimension.setTitle(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7ec4\u5408\u5b57\u6bb5(\u9690\u85cf)", (String)"BgApplyBillPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        combinedimension.setType(ColumnEnum.Others);
        combinedimension.setMaxLength(300);
        combinedimension.setBaseVisible(false);
        combinedimension.setFieldtype(FieldTypeEnum.TextField);
        bizColumns.add((BaseColumn)combinedimension);
        Map columnIndexMap = ApplyTemplateUtils.getColumnIndexMap(mainColumns);
        Map bizcolumnIndexMap = ApplyTemplateUtils.getColumnIndexMap(bizColumns);
        List<Object[]> mainDatas = this.getBatchBillDataWhere(mainTable, mainColumns, "fbusplandetail='1'");
        List<Object[]> subDatas = this.getBatchBillDataWhere(bizTable, bizColumns, "");
        int billnumberIndex = 2;
        int billTypeIndex = 1;
        List dimensions = modelCacheHelper.getDimensionList(this.getDataSetId());
        HashMap<String, Set> map = new HashMap<String, Set>(16);
        for (Object[] objectArray : mainDatas) {
            Set billnumbers;
            Object type = objectArray[billTypeIndex];
            Object number = objectArray[billnumberIndex];
            if (type == null || number == null) continue;
            if (type.toString().contains(applyType)) {
                billnumbers = map.computeIfAbsent(applyType, s -> new HashSet(16));
                billnumbers.add(number.toString());
                continue;
            }
            if (!type.toString().contains(auditType)) continue;
            billnumbers = map.computeIfAbsent(auditType, s -> new HashSet(16));
            billnumbers.add(number.toString());
        }
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Set billnumbers = (Set)entry.getValue();
            SchemeAssignDimGroup reportSchemeAssignDimGroupByBill = key.equals(applyType) ? this.getReportSchemeAssignDimGroupByBill(billnumbers, "applyscheme", "billnumber", billTypeMapEntityKey.get(key)) : this.getReportSchemeAssignDimGroupByBill(billnumbers, "reportscheme", "billno", billTypeMapEntityKey.get(key));
            if (reportSchemeAssignDimGroupByBill == null) continue;
            Map varInfo = ReportVarUtil.getVarInfo((SchemeAssignDimGroup)reportSchemeAssignDimGroupByBill);
            ColumnList columnList2 = ApplyTemplateUtils.getEntrycfgByApplyTemplate((DynamicObject)templateObj);
            ApplyTemplateUtils.changeVarOnColumn((ColumnList)columnList2, (Long)datasetId, (IModelCacheHelper)modelCacheHelper, (Map)varInfo);
            Map HiddentDimMemMap = BgApplyBillUtils.getInstance().getHiddenDimMemMap(templateObj.getString("cachedata_tag"), datasetId, modelCacheHelper, varInfo);
            List<Object[]> mainentityData = mainDatas.stream().filter(s -> billnumbers.contains(s[billnumberIndex])).collect(Collectors.toList());
            List<Object[]> subentityData = subDatas.stream().filter(s -> billnumbers.contains(s[billnumberIndex])).collect(Collectors.toList());
            List<BaseColumn> mainColumns2 = columnList2.getColumns().stream().filter(s -> s.getCategory().equals("h")).collect(Collectors.toList());
            List<BaseColumn> bizColumns2 = columnList2.getColumns().stream().filter(s -> s.getCategory().equals("e")).collect(Collectors.toList());
            this.queryMainSubData(mainColumns2, bizColumns2, columnIndexMap, bizcolumnIndexMap, mainentityData, subentityData, this.getDataSetId(), HiddentDimMemMap, templateId, dimensions, unitData, tabkeyMapName);
        }
    }

    private void initMulDataEntry() {
        DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
        DynamicObject dataset = (DynamicObject)this.getModel().getValue(DATASET);
        if (model == null || dataset == null) {
            return;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)model.getLong("id"));
        List dimensions = modelCacheHelper.getDimensionList(Long.valueOf(dataset.getLong("id")));
        if (dimensions != null) {
            String dimKey;
            int index = 1;
            HashSet<String> cusColumns = new HashSet<String>(8);
            HashSet<String> hideCusColumns = new HashSet<String>(8);
            Dimension icDim = null;
            EntryGrid entry = (EntryGrid)this.getControl(MULDATA_ENTRYENTITY);
            if (entry != null) {
                for (Dimension dimension : dimensions) {
                    if (BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension)) {
                        dimKey = "userdefined" + index++;
                        cusColumns.add(dimKey);
                        entry.setColumnProperty(dimKey, "header", (Object)dimension.getName());
                        continue;
                    }
                    if (!SysDimensionEnum.InternalCompany.getNumber().equals(dimension.getNumber())) continue;
                    icDim = dimension;
                }
            }
            for (int i = 1; i <= 8; ++i) {
                dimKey = "userdefined" + i;
                if (cusColumns.contains(dimKey)) continue;
                hideCusColumns.add(dimKey);
            }
            this.getView().setVisible(Boolean.valueOf(icDim != null), new String[]{fieldIndexMap.get(SysDimensionEnum.InternalCompany.getNumber())});
            if (!cusColumns.isEmpty()) {
                this.getView().setVisible(Boolean.TRUE, cusColumns.toArray(new String[0]));
            }
            if (!hideCusColumns.isEmpty()) {
                this.getView().setVisible(Boolean.FALSE, hideCusColumns.toArray(new String[0]));
            }
        }
    }

    private void initMainSubDataEntry() {
        DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
        DynamicObject dataset = (DynamicObject)this.getModel().getValue(DATASET);
        if (model == null || dataset == null) {
            return;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)model.getLong("id"));
        List dimensions = modelCacheHelper.getDimensionList(Long.valueOf(dataset.getLong("id")));
        if (dimensions != null) {
            String dimKey;
            int index = 1;
            HashSet<String> cusColumns = new HashSet<String>(8);
            HashSet<String> hideCusColumns = new HashSet<String>(8);
            Dimension icDim = null;
            EntryGrid entry = (EntryGrid)this.getControl(MAINSUB_ENTRYENTITY);
            if (entry != null) {
                for (Dimension dimension : dimensions) {
                    if (BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension)) {
                        dimKey = "sub_userdefined" + index++;
                        cusColumns.add(dimKey);
                        entry.setColumnProperty(dimKey, "header", (Object)dimension.getName());
                        continue;
                    }
                    if (!SysDimensionEnum.InternalCompany.getNumber().equals(dimension.getNumber())) continue;
                    icDim = dimension;
                }
            }
            for (int i = 1; i <= 8; ++i) {
                dimKey = "sub_userdefined" + i;
                if (cusColumns.contains(dimKey)) continue;
                hideCusColumns.add(dimKey);
            }
            this.getView().setVisible(Boolean.valueOf(icDim != null), new String[]{PRE + fieldIndexMap.get(SysDimensionEnum.InternalCompany.getNumber())});
            if (!cusColumns.isEmpty()) {
                this.getView().setVisible(Boolean.TRUE, cusColumns.toArray(new String[0]));
            }
            if (!hideCusColumns.isEmpty()) {
                this.getView().setVisible(Boolean.FALSE, hideCusColumns.toArray(new String[0]));
            }
        }
    }

    public List<Object[]> getBatchBillDataWhere(String tablename, List<BaseColumn> collect, String wheresql) {
        String fieldSql = this.buildSqlStr(collect);
        StringBuilder stringBuilder = new StringBuilder("select ");
        stringBuilder.append(fieldSql).append(" from ").append(tablename);
        if (StringUtils.isNotEmpty((CharSequence)wheresql)) {
            stringBuilder.append(" where ").append(wheresql);
        }
        return this.getQueryData(collect, stringBuilder.toString());
    }

    private String buildSqlStr(List<BaseColumn> collect) {
        StringBuilder selectfield = new StringBuilder();
        for (String key : ApplyBillConstant.fixEntityTableKey) {
            selectfield.append(key).append(',');
        }
        selectfield.deleteCharAt(selectfield.length() - 1);
        for (BaseColumn coll : collect) {
            if (coll.isIgnoreDB()) continue;
            String columnKey = ApplyTemplateUtils.dealSpColumnKey((BaseColumn)coll);
            selectfield.append(",f").append(columnKey);
        }
        return selectfield.toString();
    }

    private List<Object[]> getQueryData(List<BaseColumn> columns, String sql) {
        ArrayList<Object[]> allValues = new ArrayList<Object[]>();
        int valLength = ApplyBillConstant.fixEntityTableKey.length + columns.size();
        try (DataSet ds = DB.queryDataSet((String)"setEntryEntiryDefaultValue", (DBRoute)BgBaseConstant.epm, (String)sql);){
            while (ds != null && ds.hasNext()) {
                int index = 0;
                Object[] values = new Object[valLength];
                Row row = ds.next();
                for (String key : ApplyBillConstant.fixEntityTableKey) {
                    values[index++] = row.get(key);
                }
                for (BaseColumn coll : columns) {
                    if (coll.isIgnoreDB()) continue;
                    String fkey = ApplyTemplateUtils.dealSpColumnKey((BaseColumn)coll);
                    values[index++] = row.get("f" + fkey);
                }
                allValues.add(values);
            }
        }
        return allValues;
    }

    private SchemeAssignDimGroup getReportSchemeAssignDimGroupByBill(Set<String> billNumbers, String schemePropKey, String numbKey, String entryKey) {
        QFilter numberFilter = new QFilter(numbKey, "in", billNumbers);
        DynamicObject billObj = QueryServiceHelper.queryOne((String)entryKey, (String)(schemePropKey + ",year,version,datatype,model"), (QFilter[])new QFilter[]{numberFilter});
        if (billObj != null) {
            return new SchemeAssignDimGroup(Long.valueOf(billObj.getLong(MODEL)), Long.valueOf(billObj.getLong(schemePropKey)), Long.valueOf(billObj.getLong("year")), Long.valueOf(billObj.getLong("version")), Long.valueOf(billObj.getLong("datatype")));
        }
        return null;
    }

    private void queryDimenisonData(List<BaseColumn> entryColumns, Map<String, Integer> columnIndexes, List<Object[]> entityData, long datasetId, Map<String, Long> HiddentDimMemMap, long templateId, List<Dimension> dimensions) {
        ArrayList<BaseColumn> measureCols = new ArrayList<BaseColumn>(16);
        ArrayList<BaseColumn> dimensionCols = new ArrayList<BaseColumn>(16);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        Map viewIds = modelCacheHelper.getViewsByDataSet(Long.valueOf(datasetId));
        List columns = entryColumns.stream().filter(ee -> !ee.getKey().endsWith("_text")).collect(Collectors.toList());
        for (BaseColumn column : columns) {
            if (column.getType() == ColumnEnum.Dimension || column.getType() == ColumnEnum.RelationDimension || column.getType() == ColumnEnum.RowDimension) {
                dimensionCols.add(column);
                continue;
            }
            if (column.getType() != ColumnEnum.Measure && column.getType() != ColumnEnum.DimensionData || column.getIspullfrommodel()) continue;
            measureCols.add(column);
        }
        Map allColDimMembers = BgApplyBillUtils.getInstance().getAllColDimMembers(measureCols, Long.valueOf(datasetId), modelCacheHelper, Boolean.valueOf(true));
        HashMap<String, Integer> rowDimColumnIndex = new HashMap<String, Integer>(16);
        dimensionCols.forEach(e -> {
            Integer cfr_ignored_0 = (Integer)rowDimColumnIndex.put(BgApplyBillUtils.getInstance().getDimOrRelateDimNumber(e, modelCacheHelper), (Integer)columnIndexes.get(e.getKey()));
        });
        HashMap<Integer, Map> allRowDimMembers = new HashMap<Integer, Map>(16);
        for (int i = 0; i < entityData.size(); ++i) {
            Object[] data = entityData.get(i);
            String dataType = (String)data[3];
            if (!EntityRowDataType.isDetailData((String)dataType)) continue;
            HashMap rowMemMap = new HashMap(16);
            rowDimColumnIndex.forEach((key, value) -> {
                Object memberId = data[value];
                Member member = modelCacheHelper.getMember(key, (Long)viewIds.get(key), IDUtils.toLong((Object)memberId));
                if (member != null) {
                    rowMemMap.put(key, member.getNumber());
                }
            });
            allRowDimMembers.put(i, rowMemMap);
        }
        Map<String, String> hideDimMembers = this.getHideDimMembersFromTempConfig(modelCacheHelper, HiddentDimMemMap, viewIds);
        HashMap dimGroups = new HashMap(16);
        BgApplyBillUtils.getInstance().mergeMap(hideDimMembers, dimGroups);
        allRowDimMembers.values().forEach(e -> BgApplyBillUtils.getInstance().mergeMap(e, dimGroups));
        allColDimMembers.values().forEach(e -> BgApplyBillUtils.getInstance().mergeMap(e, dimGroups));
        List dimensionList = modelCacheHelper.getDimensionList(Long.valueOf(datasetId));
        if (allColDimMembers.size() == 0 || allRowDimMembers.size() == 0) {
            return;
        }
        Map defaultMembers = BgApplyBillUtils.getInstance().getDefaultAddDimMembers(dimensionList, hideDimMembers, (Map)allColDimMembers.values().iterator().next(), (Map)allRowDimMembers.values().iterator().next());
        BgApplyBillUtils.getInstance().mergeMap(defaultMembers, dimGroups);
        Map membersKeyObjectMap = new HashMap(16);
        Map finalMembersKeyObjectMap = membersKeyObjectMap = BgApplyBillUtils.getInstance().queryOlapDataNotAuth(modelCacheHelper, this.getModelId(), Long.valueOf(datasetId), dimGroups, true, templateId);
        Map<String, BaseColumn> columnMap = entryColumns.stream().collect(Collectors.toMap(c -> c.getKey(), c -> c));
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection(MULDATA_ENTRYENTITY);
        allRowDimMembers.forEach((rowIndex, rowDimMembNums) -> {
            Object[] data = (Object[])entityData.get((int)rowIndex);
            HashMap dimGroup = new HashMap(hideDimMembers);
            dimGroup.putAll(rowDimMembNums);
            allColDimMembers.forEach((key, value) -> {
                HashMap dimGroup_tmp = new HashMap(dimGroup);
                dimGroup_tmp.putAll(value);
                dimGroup_tmp.putAll(defaultMembers);
                MembersKey membersKey = BgApplyBillUtils.getInstance().getMembersKey(dimGroup_tmp, dimensionList);
                Object cellValue = finalMembersKeyObjectMap.get(membersKey);
                BaseColumn column = (BaseColumn)columnMap.get(key);
                if (cellValue == null) {
                    cellValue = this.setDefaultData(cellValue, column);
                }
                if (!this.compareEqual(data[(Integer)columnIndexes.get(key)], cellValue, column)) {
                    DynamicObject row = entrys.addNew();
                    int billnumberIndex = 2;
                    int billTypeIndex = 1;
                    row.set("billnumber", data[billnumberIndex]);
                    row.set("billtype", data[billTypeIndex]);
                    row.set("colname", (Object)column.getTitle());
                    row.set("muldata", cellValue);
                    row.set("data", data[(Integer)columnIndexes.get(key)]);
                    int userDefined = 1;
                    String showColumn = "";
                    int in = dimensions.size();
                    for (int i = 0; i < in; ++i) {
                        Dimension dimension = (Dimension)dimensions.get(i);
                        showColumn = BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension) ? "userdefined" + userDefined++ : fieldIndexMap.get(dimension.getNumber());
                        Member member = modelCacheHelper.getMember(dimension.getNumber(), (Long)viewIds.get(dimension.getNumber()), (String)dimGroup_tmp.get(dimension.getNumber()));
                        if (member == null) continue;
                        row.set(showColumn, (Object)(member.getName() + "\r\n" + member.getNumber()));
                    }
                }
            });
        });
        this.getView().updateView(MULDATA_ENTRYENTITY);
    }

    private void queryMainSubData(List<BaseColumn> entryColumns, List<BaseColumn> bizColumns2, Map<String, Integer> columnIndexes, Map<String, Integer> bizcolumnIndexMap, List<Object[]> mainentityData, List<Object[]> subentityData, long datasetId, Map<String, Long> HiddentDimMemMap, long templateId, List<Dimension> dimensions, BigDecimal unitData, Map<String, String> tabkeyMapName) {
        ArrayList<BaseColumn> measureCols = new ArrayList<BaseColumn>(16);
        ArrayList<BaseColumn> dimensionCols = new ArrayList<BaseColumn>(16);
        Set mainCurrencyColumnKeys = ApplyTemplateUtils.getCurrencyColumnKeys(entryColumns, (Long)this.getModelId());
        String combineDimensionKey = ApplyTemplateUtils.FIELD_COMBINEDIMENSION;
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        Map viewIds = modelCacheHelper.getViewsByDataSet(Long.valueOf(datasetId));
        List columns = entryColumns.stream().filter(ee -> !ee.getKey().endsWith("_text")).collect(Collectors.toList());
        for (BaseColumn column : columns) {
            if (column.getType() == ColumnEnum.Dimension || column.getType() == ColumnEnum.RelationDimension || column.getType() == ColumnEnum.RowDimension) {
                dimensionCols.add(column);
                continue;
            }
            if (column.getType() != ColumnEnum.Measure && column.getType() != ColumnEnum.DimensionData || column.getIspullfrommodel()) continue;
            measureCols.add(column);
        }
        Map allColDimMembers = BgApplyBillUtils.getInstance().getAllColDimMembers(measureCols, viewIds, modelCacheHelper, Boolean.valueOf(true));
        HashMap<String, Integer> rowDimColumnIndex = new HashMap<String, Integer>(16);
        dimensionCols.forEach(e -> {
            Integer cfr_ignored_0 = (Integer)rowDimColumnIndex.put(BgApplyBillUtils.getInstance().getDimOrRelateDimNumber(e, modelCacheHelper), (Integer)columnIndexes.get(e.getKey()));
        });
        HashMap<Integer, Map> allRowDimMembers = new HashMap<Integer, Map>(16);
        for (int i = 0; i < mainentityData.size(); ++i) {
            Object[] data = mainentityData.get(i);
            String dataType = (String)data[3];
            if (!EntityRowDataType.isDetailData((String)dataType)) continue;
            HashMap rowMemMap = new HashMap(16);
            rowDimColumnIndex.forEach((key, value) -> {
                Object memberId = data[value];
                Member member = modelCacheHelper.getMember(key, (Long)viewIds.get(key), IDUtils.toLong((Object)memberId));
                if (member != null) {
                    rowMemMap.put(key, member.getNumber());
                }
            });
            allRowDimMembers.put(i, rowMemMap);
        }
        Map<String, String> hideDimMembers = this.getHideDimMembersFromTempConfig(modelCacheHelper, HiddentDimMemMap, viewIds);
        HashMap dimGroups = new HashMap(16);
        BgApplyBillUtils.getInstance().mergeMap(hideDimMembers, dimGroups);
        allRowDimMembers.values().forEach(e -> BgApplyBillUtils.getInstance().mergeMap(e, dimGroups));
        allColDimMembers.values().forEach(e -> BgApplyBillUtils.getInstance().mergeMap(e, dimGroups));
        List dimensionList = modelCacheHelper.getDimensionList(Long.valueOf(datasetId));
        if (allColDimMembers.size() == 0 || allRowDimMembers.size() == 0) {
            return;
        }
        Map defaultMembers = BgApplyBillUtils.getInstance().getDefaultAddDimMembers(dimensionList, hideDimMembers, (Map)allColDimMembers.values().iterator().next(), (Map)allRowDimMembers.values().iterator().next());
        BgApplyBillUtils.getInstance().mergeMap(defaultMembers, dimGroups);
        Map<String, BaseColumn> columnMap = entryColumns.stream().collect(Collectors.toMap(c -> c.getKey(), c -> c));
        Map<String, BaseColumn> bizcolumnMap = bizColumns2.stream().collect(Collectors.toMap(c -> c.getKey(), c -> c));
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection(MAINSUB_ENTRYENTITY);
        Map biz_sumcollect = ApplyBillPluginUitl.selectBizEntryAggKeys(bizColumns2);
        HashMap<String, Set> hcolumnMapSumKeys = new HashMap<String, Set>(16);
        for (Map.Entry column : biz_sumcollect.entrySet()) {
            String sumfield = (String)column.getKey();
            String hcolumnkey = (String)column.getValue();
            Set sumkeys = hcolumnMapSumKeys.computeIfAbsent(hcolumnkey, s -> new HashSet(16));
            sumkeys.add(sumfield);
        }
        String finalCombineDimensionKey = combineDimensionKey;
        allRowDimMembers.forEach((rowIndex, rowDimMembNums) -> {
            Object[] mainData = (Object[])mainentityData.get((int)rowIndex);
            StringBuilder dimStr = new StringBuilder();
            for (BaseColumn col : dimensionCols) {
                int index = (Integer)columnIndexes.get(col.getKey());
                Object value2 = mainData[index];
                dimStr.append(value2 == null ? "0" : value2.toString()).append("_");
            }
            String dimStr2 = dimStr.toString();
            ArrayList<Object[]> subDatas = new ArrayList<Object[]>(16);
            for (Object[] bizData : subentityData) {
                int index;
                Object combineDimensions = bizData[index = ((Integer)bizcolumnIndexMap.get(finalCombineDimensionKey)).intValue()];
                if (combineDimensions == null || !this.isMatchEntry(combineDimensions.toString(), dimStr2).booleanValue()) continue;
                subDatas.add(bizData);
            }
            HashMap dimGroup = new HashMap(hideDimMembers);
            dimGroup.putAll(rowDimMembNums);
            allColDimMembers.forEach((key, value) -> {
                Set sumcolumns;
                if (hcolumnMapSumKeys.containsKey(key) && !(sumcolumns = (Set)hcolumnMapSumKeys.get(key)).isEmpty()) {
                    BigDecimal sumresult = BigDecimal.ZERO;
                    HashMap<String, BigDecimal> tabkeyMapValue = new HashMap<String, BigDecimal>(16);
                    for (int index = 0; index < subDatas.size(); ++index) {
                        Object[] entry = (Object[])subDatas.get(index);
                        for (String fieldname : sumcolumns) {
                            Object entryValue = entry[(Integer)bizcolumnIndexMap.get(fieldname)];
                            BigDecimal bvalue = BigDecimal.ZERO;
                            BaseColumn bizcolumn = (BaseColumn)bizcolumnMap.get(fieldname);
                            BigDecimal bizsumvalue = (BigDecimal)tabkeyMapValue.get(bizcolumn.getBizPlanTabKey());
                            if (entryValue instanceof BigDecimal) {
                                bvalue = (BigDecimal)entryValue;
                            } else if (entryValue instanceof Integer) {
                                bvalue = new BigDecimal((Integer)entryValue);
                            }
                            if (bizsumvalue == null) {
                                tabkeyMapValue.put(bizcolumn.getBizPlanTabKey(), bvalue);
                            } else {
                                bizsumvalue = bizsumvalue.add(bvalue);
                                tabkeyMapValue.put(bizcolumn.getBizPlanTabKey(), bizsumvalue);
                            }
                            sumresult = sumresult.add(bvalue);
                        }
                    }
                    if (mainCurrencyColumnKeys.contains(key)) {
                        sumresult = sumresult.divide(unitData);
                    }
                    ArrayList<String> bizSumlist = new ArrayList<String>(16);
                    for (Map.Entry entry : tabkeyMapValue.entrySet()) {
                        String tabname = (String)tabkeyMapName.get(entry.getKey());
                        bizSumlist.add(tabname + ":" + entry.getValue());
                    }
                    HashMap dimGroup_tmp = new HashMap(dimGroup);
                    dimGroup_tmp.putAll(value);
                    dimGroup_tmp.putAll(defaultMembers);
                    BaseColumn baseColumn = (BaseColumn)columnMap.get(key);
                    if (!this.compareEqual(mainData[(Integer)columnIndexes.get(key)], sumresult, baseColumn)) {
                        DynamicObject row = entrys.addNew();
                        int billnumberIndex = 2;
                        int billTypeIndex = 1;
                        row.set("sub_billnumber", mainData[billnumberIndex]);
                        row.set("sub_billtype", mainData[billTypeIndex]);
                        row.set("sub_colname", (Object)baseColumn.getTitle());
                        row.set("sub_maindata", mainData[(Integer)columnIndexes.get(key)]);
                        row.set("sub_subdata", (Object)String.join((CharSequence)",", bizSumlist));
                        row.set("sub_sumsubdata", (Object)sumresult);
                        int userDefined = 1;
                        String showColumn = "";
                        int in = dimensions.size();
                        for (int i = 0; i < in; ++i) {
                            Dimension dimension = (Dimension)dimensions.get(i);
                            showColumn = BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension) ? "sub_userdefined" + userDefined++ : PRE + fieldIndexMap.get(dimension.getNumber());
                            Member member = modelCacheHelper.getMember(dimension.getNumber(), (Long)viewIds.get(dimension.getNumber()), (String)dimGroup_tmp.get(dimension.getNumber()));
                            if (member == null) continue;
                            row.set(showColumn, (Object)(member.getName() + "\r\n" + member.getNumber()));
                        }
                    }
                }
            });
        });
        this.getView().updateView(MAINSUB_ENTRYENTITY);
    }

    private Boolean isMatchEntry(String combineDimensions, String dimStr) {
        if (combineDimensions.length() == dimStr.length()) {
            if (StringUtils.equals((CharSequence)combineDimensions, (CharSequence)dimStr)) {
                return true;
            }
        } else {
            String[] s = combineDimensions.split("_");
            String[] s1 = dimStr.split("_");
            HashSet<String> combineDimIds = new HashSet<String>(Arrays.asList(s));
            HashSet<String> dimStrIds = new HashSet<String>(Arrays.asList(s1));
            if (dimStrIds.containsAll(combineDimIds)) {
                return true;
            }
        }
        return false;
    }

    private Object setDefaultData(Object val, BaseColumn column) {
        FieldTypeEnum fieldtype;
        if (val == null && (fieldtype = column.getFieldtype()) != null) {
            switch (fieldtype) {
                case IntField: {
                    val = 0;
                    break;
                }
                case NumberField: {
                    val = BigDecimal.ZERO;
                    break;
                }
                case TextField: 
                case LongText: {
                    val = "";
                    break;
                }
                case BaseDataField: {
                    val = 0L;
                    break;
                }
                case Boolean: {
                    val = Boolean.FALSE;
                }
            }
        }
        return val;
    }

    private boolean compareEqual(Object val, Object mulVal, BaseColumn column) {
        FieldTypeEnum fieldtype;
        if (val != null && mulVal != null && (fieldtype = column.getFieldtype()) != null) {
            switch (fieldtype) {
                case IntField: 
                case NumberField: {
                    return new BigDecimal(mulVal.toString()).compareTo(new BigDecimal(val.toString())) == 0;
                }
                case TextField: 
                case LongText: {
                    return mulVal.toString().equals(val.toString());
                }
            }
            return false;
        }
        return false;
    }

    public Map<String, String> getHideDimMembersFromTempConfig(IModelCacheHelper modelCacheHelper, Map<String, Long> hideenM, Map<String, Long> dimViewMap) {
        HashMap<String, String> memberMap = new HashMap<String, String>(16);
        for (Map.Entry<String, Long> entry : hideenM.entrySet()) {
            Member member = modelCacheHelper.getMember(entry.getKey(), dimViewMap.get(entry.getKey()), entry.getValue());
            if (member == null) continue;
            memberMap.put(entry.getKey(), member.getNumber());
        }
        return memberMap;
    }

    static {
        fieldIndexMap.put(SysDimensionEnum.Entity.getNumber(), "orgunit");
        fieldIndexMap.put(SysDimensionEnum.Account.getNumber(), "account");
        fieldIndexMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), "period");
        fieldIndexMap.put(SysDimensionEnum.Version.getNumber(), "version");
        fieldIndexMap.put(SysDimensionEnum.Currency.getNumber(), "currency");
        fieldIndexMap.put(SysDimensionEnum.DataType.getNumber(), "datatype");
        fieldIndexMap.put(SysDimensionEnum.ChangeType.getNumber(), "changetype");
        fieldIndexMap.put(SysDimensionEnum.AuditTrail.getNumber(), "audittrail");
        fieldIndexMap.put(SysDimensionEnum.Metric.getNumber(), "metric");
        fieldIndexMap.put(SysDimensionEnum.InternalCompany.getNumber(), "internalcompany");
        billTypeMapEntityKey.put(applyType, "eb_bgapplybill");
        billTypeMapEntityKey.put(auditType, "eb_centralappbill");
    }
}

