/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applybill.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.applybill.util.BgApplyBillUtils;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.reportscheme.service.ReportSchemeAssignService;
import kd.epm.eb.business.reportscheme.service.ReportSchemeService;
import kd.epm.eb.business.templateperm.TemplatePermServiceHelper;
import kd.epm.eb.business.userselect.UserSelectUtils;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.templateperm.TemplateTypeEnum;
import kd.epm.eb.common.templateperm.TemplateUserQueryResult;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.commons.collections4.CollectionUtils;

public class BgApplyBillListBasePlugin
extends AbstractListPlugin
implements TreeNodeClickListener,
BeforeF7SelectListener,
TreeNodeQueryListener {
    private static final String TREESEARCHKEY = "schemetree_search";
    private static final String YERA_KEY = "year";
    private static final String DATATYPE_KEY = "datatype";
    private static final String VERSION_KEY = "version";
    private static final String MODEL_KEY = "model";
    private static final String CACHE_SCHEME_ORG = "cache_scheme_org";
    private static final String SEARCH_RESULT = "search_result";
    private static final String SEARCH_INDEX = "search_index";
    private static final int MAX_ORG_NODES_LIMIT = 2000;
    private static final Log log = LogFactory.getLog(BgApplyBillListBasePlugin.class);

    public void initialize() {
        super.initialize();
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.initModel();
        this.setModelFilter();
        this.initSchemeTree();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String itemKey;
        switch (itemKey = e.getProperty().getName()) {
            case "datatype": 
            case "year": 
            case "version": {
                if (!this.needDealChange()) break;
                this.clearFocusNodeIdCache();
                this.saveUserSelect();
                this.reflesh();
                break;
            }
            case "model": {
                this.clearFocusNodeIdCache();
                this.dealModelChanged();
            }
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7SelectListener(this, new String[]{YERA_KEY, DATATYPE_KEY, VERSION_KEY, MODEL_KEY});
        this.addTreeSearchListeners();
        this.addTreeNodeClickListener(this, "treeviewap");
        this.addClickListeners(new String[]{"searchbefore", "searchnext", "modelswitch"});
    }

    private void addTreeSearchListeners() {
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener(this::search);
    }

    protected void initSchemeTree() {
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        treeView.deleteAllNodes();
        TreeNode rootNode = this.getLeftTree();
        treeView.addNode(rootNode);
        this.getOrCacheLeftTree(rootNode);
        this.clearSearchCache();
        if (CollectionUtils.isNotEmpty((Collection)rootNode.getChildren())) {
            String cacheId = this.getOrCacheLeftTreeClickNodeId(null);
            this.focusNodeByNodeId(cacheId);
            this.refleshRightBillList();
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "searchbefore": {
                this.searchOther(false);
                break;
            }
            case "searchnext": {
                this.searchOther(true);
                break;
            }
            case "modelswitch": {
                BasedataEdit modelItem = (BasedataEdit)this.getControl(MODEL_KEY);
                modelItem.click();
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String treeKey = ((Control)evt.getSource()).getKey();
        if (treeKey.equals("treeviewap")) {
            this.getOrCacheLeftTreeClickNodeId((String)evt.getNodeId());
            this.refleshRightBillList();
        }
    }

    protected String getOrCacheLeftTreeClickNodeId(String nodeId) {
        if (nodeId == null) {
            nodeId = this.getPageCache().get("LeftTreeClickNodeId");
        } else {
            this.getPageCache().put("LeftTreeClickNodeId", nodeId);
        }
        return nodeId;
    }

    public void setFilter(SetFilterEvent e) {
        String clickNodeId = this.getOrCacheLeftTreeClickNodeId(null);
        TreeNode leftTreeNode = this.getOrCacheLeftTree(null);
        TreeNode clickNode = new TreeNode();
        if (leftTreeNode != null) {
            clickNode = leftTreeNode.getTreeNode(clickNodeId, 20);
        }
        QFBuilder qb = new QFBuilder(MODEL_KEY, "=", (Object)this.getModelId());
        if (clickNode != null) {
            String[] focus = clickNode.getId().split("_");
            qb.add(DATATYPE_KEY, "=", (Object)IDUtils.toLong((Object)focus[0]));
            qb.add(YERA_KEY, "=", (Object)IDUtils.toLong((Object)focus[1]));
            qb.add(VERSION_KEY, "=", (Object)IDUtils.toLong((Object)focus[2]));
            if (focus.length >= 4) {
                qb.add(this.getApplySchemeKey(), "=", (Object)IDUtils.toLong((Object)focus[3]));
            }
            HashSet<Long> orgSet = new HashSet<Long>(16);
            this.buildOrgSet(clickNode, orgSet);
            qb.add(this.getOrgKey(), "in", orgSet);
        } else {
            qb.add("1", "=", (Object)-1);
        }
        this.addCustomFilter(qb);
        e.getCustomQFilters().addAll(qb.toList());
        log.info("setFilters:" + e.getCustomQFilters().toString());
    }

    protected void addCustomFilter(QFBuilder qb) {
    }

    protected String getOrgKey() {
        return "org";
    }

    protected String getApplySchemeKey() {
        return "applyscheme";
    }

    protected void buildOrgSet(TreeNode clickNode, Set<Long> set) {
        String[] split = clickNode.getId().split("_");
        Map<Long, Set<Long>> schemeOrgMap = this.getCacheSchemeOrgMap();
        switch (split.length) {
            case 3: {
                List schemeNodes = clickNode.getChildren();
                if (!CollectionUtils.isNotEmpty((Collection)schemeNodes)) break;
                for (TreeNode schemeNode : schemeNodes) {
                    Long schemeId = this.getSchemeIdByNodeId(schemeNode.getId());
                    Set<Long> orgIds = schemeOrgMap.get(schemeId);
                    if (!CollectionUtils.isNotEmpty(orgIds)) continue;
                    set.addAll(orgIds);
                }
                break;
            }
            case 4: {
                Long schemeId = this.getSchemeIdByNodeId(clickNode.getId());
                Set<Long> orgIds = schemeOrgMap.get(schemeId);
                if (!CollectionUtils.isNotEmpty(orgIds)) break;
                set.addAll(orgIds);
                break;
            }
            case 5: {
                this.getCurOrgAllChild(clickNode, set);
                break;
            }
        }
    }

    private void getCurOrgAllChild(TreeNode clickNode, Set<Long> orgIds) {
        orgIds.add(IDUtils.toLong((Object)clickNode.getId().split("_")[4]));
        if (clickNode.getChildren() != null) {
            List children = clickNode.getChildren();
            for (TreeNode child : children) {
                this.getCurOrgAllChild(child, orgIds);
            }
        }
    }

    protected TreeNode getOrCacheLeftTree(TreeNode treeNode) {
        if (treeNode == null) {
            String cacheStr = this.getPageCache().get(TREESEARCHKEY);
            if (cacheStr != null) {
                treeNode = (TreeNode)SerializationUtils.fromJsonString((String)cacheStr, TreeNode.class);
            }
        } else {
            this.getPageCache().put(TREESEARCHKEY, SerializationUtils.toJsonString((Object)treeNode));
        }
        return treeNode;
    }

    private void expandTree(TreeNode rootNode, TreeView treeView) {
        treeView.expand(rootNode.getId());
        List dimGroupNodes = rootNode.getChildren();
        if (dimGroupNodes != null && dimGroupNodes.size() > 0) {
            for (TreeNode treeNode : dimGroupNodes) {
                treeView.expand(treeNode.getId());
                List schemeNodes = treeNode.getChildren();
                if (schemeNodes == null || schemeNodes.size() <= 0) continue;
                for (TreeNode schemeNode : schemeNodes) {
                    String firstSchemeNodeId = schemeNode.getId();
                    this.loadCurSchemeOrgTree(firstSchemeNodeId);
                    treeView.expand(firstSchemeNodeId);
                }
            }
        }
    }

    private TreeNode getLeftTree() {
        TreeNode rootNode = new TreeNode("", "000", ResManager.loadKDString((String)"\u6839", (String)"BgApplyBillListBasePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        Map<String, List<Long>> dimGroupToSchemeMap = this.creatLeftTreeData();
        if (dimGroupToSchemeMap == null || dimGroupToSchemeMap.size() == 0) {
            return rootNode;
        }
        IModelCacheHelper cacheHelper = this.getIModelCacheHelper();
        Map schemeIdNameMap = BgApplyBillUtils.getInstance().getSchemeIdNameMap(dimGroupToSchemeMap);
        for (Map.Entry<String, List<Long>> entry : dimGroupToSchemeMap.entrySet()) {
            String dimGroupKey = entry.getKey();
            List<Long> schemeIds = entry.getValue();
            if (CollectionUtils.isEmpty(schemeIds)) continue;
            TreeNode dimGroupNode = new TreeNode(rootNode.getId(), dimGroupKey, this.getDimGroupShowName(dimGroupKey, cacheHelper));
            rootNode.addChild(dimGroupNode);
            for (Long schemeId : schemeIds) {
                TreeNode schemeNode = new TreeNode(dimGroupKey, dimGroupKey + "_" + schemeId, (String)schemeIdNameMap.get(schemeId), true);
                dimGroupNode.addChild(schemeNode);
            }
        }
        return rootNode;
    }

    private Map<String, List<Long>> creatLeftTreeData() {
        Map<Long, Set<Long>> noAdminMap = this.getNoAdminMap();
        DynamicObjectCollection dynamicObjects = this.getRecords();
        if (dynamicObjects == null || dynamicObjects.size() == 0) {
            return null;
        }
        HashMap<Long, Long> schemeBizMap = new HashMap<Long, Long>(16);
        Map<String, List<Long>> dimGroupToSchemeMap = this.getHasAdminMap(dynamicObjects, noAdminMap, schemeBizMap);
        if (dimGroupToSchemeMap.size() == 0) {
            return null;
        }
        Map<Long, Set<Long>> schemeToOrgMap = this.getAndCacheSchemeOrgMemberIds(noAdminMap, schemeBizMap);
        for (Map.Entry<String, List<Long>> entry : dimGroupToSchemeMap.entrySet()) {
            List<Long> schemeIds = entry.getValue();
            schemeIds.removeIf(schemeId -> CollectionUtils.isEmpty((Collection)((Collection)schemeToOrgMap.get(schemeId))));
        }
        return dimGroupToSchemeMap;
    }

    private Map<Long, Set<Long>> getSchemeOrgMap(DynamicObjectCollection proOrgobjects, Map<Long, Set<Long>> noAdminMap, Map<Long, Long> schBizMap) {
        Long modelId = this.getModelId();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Map templateEntityPermMap = TemplatePermServiceHelper.getTemplateEntityPermMap((Long)modelId, (TemplateTypeEnum)TemplateTypeEnum.APPLY, schBizMap.keySet());
        log.info("templateEntityPermMap:" + SerializationUtils.toJsonString((Object)templateEntityPermMap));
        HashMap<Long, Set<Long>> schemeOrgMap = new HashMap<Long, Set<Long>>(16);
        for (DynamicObject dynamicObject : proOrgobjects) {
            Long scheme = dynamicObject.getLong("scheme");
            TemplateUserQueryResult templateUserQueryResult = (TemplateUserQueryResult)templateEntityPermMap.get(scheme);
            if (templateUserQueryResult == null) continue;
            Long templateId = dynamicObject.getLong("applytemplate");
            String orgnumber = dynamicObject.getString("org.number");
            int orgrange = dynamicObject.getInt("orgrange");
            Long viewId = modelCacheHelper.getViewByBusModelAndDimNumber(schBizMap.get(scheme), SysDimensionEnum.Entity.getNumber());
            List members = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), viewId, orgnumber, orgrange);
            long createtime = 0L;
            Date createDate = dynamicObject.getDate("scheme.createdate");
            if (createDate != null) {
                createtime = createDate.getTime();
            }
            HashSet<Long> disableMemberIds = new HashSet<Long>(members.size());
            for (Member member : members) {
                if (!member.isDisable()) continue;
                disableMemberIds.add(member.getId());
            }
            QFilter qFilter = new QFilter("id", "in", disableMemberIds);
            DynamicObjectCollection disableMembers = QueryServiceHelper.query((String)SysDimensionEnum.Entity.getMemberTreemodel(), (String)"id,number,disabledate", (QFilter[])qFilter.toArray());
            Map<Long, DynamicObject> disableMembersMap = disableMembers.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
            for (Member member : members) {
                Set permEntityIds;
                if (member.isDisable()) {
                    Date disabledate;
                    DynamicObject memberObj = disableMembersMap.get(member.getId());
                    long disabletime = Long.MAX_VALUE;
                    if (memberObj != null && (disabledate = memberObj.getDate("disabledate")) != null) {
                        disabletime = disabledate.getTime();
                    }
                    if (disabletime < createtime) continue;
                }
                if (noAdminMap != null && noAdminMap.get(schBizMap.get(scheme)) != null && noAdminMap.get(schBizMap.get(scheme)).contains(member.getId()) || !templateUserQueryResult.isHasAllPerm() && templateUserQueryResult.getTemplateEntityMap() != null && ((permEntityIds = (Set)templateUserQueryResult.getTemplateEntityMap().get(templateId)) == null || !permEntityIds.contains(member.getId()) && !permEntityIds.contains(0L))) continue;
                schemeOrgMap.computeIfAbsent(scheme, k -> new LinkedHashSet(16));
                Set set = (Set)schemeOrgMap.get(scheme);
                set.add(member.getId());
                schemeOrgMap.put(scheme, set);
            }
        }
        return schemeOrgMap;
    }

    private Map<Long, Set<Long>> getNoAdminMap() {
        Set bizSet = BgApplyBillUtils.getInstance().queryBizByModel(this.getModelId());
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        HashMap<Long, Set<Long>> noAdminMap = new HashMap<Long, Set<Long>>(16);
        for (Long bizrange : bizSet) {
            Set longs;
            Set versionNumbers = DimMembPermHelper.getReadPermMembIds((String)SysDimensionEnum.Version.getNumber(), (Long)this.getModelId(), (Long)bizrange, null, (boolean)false);
            Set datatypeNumbers = DimMembPermHelper.getReadPermMembIds((String)SysDimensionEnum.DataType.getNumber(), (Long)this.getModelId(), (Long)bizrange, null, (boolean)false);
            HashSet entityNumbers = new HashSet(16);
            Map dimViewMap = modelCacheHelper.getViewsByBusModel(bizrange);
            Long entityViewId = (Long)dimViewMap.get(SysDimensionEnum.Entity.getNumber());
            Set readPermMemIds = DimMembPermHelper.getReadPermMembIds((String)SysDimensionEnum.Entity.getNumber(), (Long)this.getModelId(), (Long)bizrange, (Long)entityViewId, (boolean)false);
            if (readPermMemIds != null) {
                entityNumbers.addAll(readPermMemIds);
            }
            if (versionNumbers != null) {
                for (Long perm : versionNumbers) {
                    noAdminMap.computeIfAbsent(bizrange, k -> new HashSet(16));
                    longs = (Set)noAdminMap.get(bizrange);
                    longs.add(perm);
                    noAdminMap.put(bizrange, longs);
                }
            }
            if (datatypeNumbers != null) {
                for (Long perm : datatypeNumbers) {
                    noAdminMap.computeIfAbsent(bizrange, k -> new HashSet(16));
                    longs = (Set)noAdminMap.get(bizrange);
                    longs.add(perm);
                    noAdminMap.put(bizrange, longs);
                }
            }
            for (Long perm : entityNumbers) {
                noAdminMap.computeIfAbsent(bizrange, k -> new HashSet(16));
                longs = (Set)noAdminMap.get(bizrange);
                longs.add(perm);
                noAdminMap.put(bizrange, longs);
            }
        }
        return noAdminMap;
    }

    private Map<String, List<Long>> getHasAdminMap(DynamicObjectCollection dynamicObjects, Map<Long, Set<Long>> noAdminMap, Map<Long, Long> schemeBizMap) {
        LinkedHashMap<String, List<Long>> record = new LinkedHashMap<String, List<Long>>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            Long year = dynamicObject.getLong(YERA_KEY);
            Long version = dynamicObject.getLong(VERSION_KEY);
            Long datatype = dynamicObject.getLong(DATATYPE_KEY);
            Long biz = dynamicObject.getLong("bizrange");
            if (noAdminMap != null && noAdminMap.get(biz) != null && (noAdminMap.get(biz).contains(version) || noAdminMap.get(biz).contains(datatype))) continue;
            String key = "" + datatype + "_" + year + "_" + version;
            List schemeIds = record.computeIfAbsent(key, k -> new ArrayList(10));
            schemeIds.add(dynamicObject.getLong("scheme"));
            schemeBizMap.put(dynamicObject.getLong("scheme"), biz);
        }
        return record;
    }

    private DynamicObjectCollection getRecords() {
        Long yearId = (Long)this.getValue(YERA_KEY, "id");
        Long versionId = (Long)this.getValue(VERSION_KEY, "id");
        Long datatypeId = (Long)this.getValue(DATATYPE_KEY, "id");
        return ReportSchemeAssignService.getInstance().querySchemesGroup(yearId, versionId, datatypeId, this.getModelId());
    }

    private void initModel() {
        Long modelIdStr;
        Object userSelect = UserSelectUtils.getWholeUserSelect((IFormView)this.getView(), HashMap.class);
        Map map = new HashMap(16);
        if (userSelect instanceof Map) {
            map = (Map)userSelect;
        }
        Object initVersion = this.getModel().getDataEntity().get(VERSION_KEY);
        if (map.get(YERA_KEY) != null && initVersion == null) {
            this.getModel().setValue(YERA_KEY, map.get(YERA_KEY));
        }
        if (map.get(DATATYPE_KEY) != null && initVersion == null) {
            this.getModel().setValue(DATATYPE_KEY, map.get(DATATYPE_KEY));
        }
        if (map.get(VERSION_KEY) != null && initVersion == null) {
            this.getModel().setValue(VERSION_KEY, map.get(VERSION_KEY));
        }
        if (IDUtils.isNull((Long)(modelIdStr = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)MODEL_KEY, (boolean)false)))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u65b0\u589e\u4f53\u7cfb\u3002", (String)"BgApplyBillListBasePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getModel().setValue(MODEL_KEY, (Object)modelIdStr);
        this.setModelLabel();
    }

    private void setModelFilter() {
        QFilter filter1 = new QFilter("id", "=", (Object)this.getModelId());
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(MODEL_KEY);
        this.getView().getFormShowParameter().setAppId("bgm");
        List modelFilters = ModelUtil.getModelFilter((IFormView)this.getView());
        ArrayList<QFilter> filters = new ArrayList<QFilter>(modelFilters.size());
        for (QFilter filter : modelFilters) {
            filter.or(filter1);
            filters.add(filter);
        }
        basedataEdit.setQFilters(filters);
    }

    private void setModelLabel() {
        DynamicObject modelOjb = (DynamicObject)this.getModel().getValue(MODEL_KEY);
        if (modelOjb != null) {
            ((Label)this.getControl("modellabel")).setText(modelOjb.getString("name"));
        }
    }

    private void setCache(String cacheKey, String modelId) {
        this.getPageCache().put(cacheKey, modelId);
    }

    private void saveUserSelectModel(Long modelId) {
        if (IDUtils.isNull((Long)modelId)) {
            return;
        }
        UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propKey = beforeF7SelectEvent.getProperty().getName();
        if (propKey.equals(MODEL_KEY)) {
            beforeF7SelectEvent.getCustomQFilters().addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.setListFilterParameter(new ListFilterParameter(ModelUtil.getModelFilter((IFormView)this.getView()), null));
            return;
        }
        Long modelId = this.getModelId();
        if (YERA_KEY.equals(propKey)) {
            propKey = SysDimensionEnum.BudgetPeriod.getNumber();
        }
        MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)NewF7Utils.getDimNumber((String)propKey)), (String)ListSelectedRow.class.getName());
        if (SysDimensionEnum.BudgetPeriod.getNumber().equals(propKey)) {
            QFilter qFilter = new QFilter("level", "=", (Object)2);
            Set periodsOfSchemeHasApTem = ReportSchemeAssignService.getInstance().getPeriodsOfSchemeHasApTem(this.getModelId());
            if (periodsOfSchemeHasApTem.size() > 0) {
                qFilter.or("id", "in", (Object)periodsOfSchemeHasApTem);
            }
            f7Param.addCustomFilter(qFilter);
        }
        f7Param.setVerifyPermission(false);
        NewF7Utils.openF7((BeforeF7SelectEvent)beforeF7SelectEvent, (MemberF7Parameter)f7Param);
    }

    protected boolean isModelManager(Long currentUser) {
        Long modelId = this.getModelId();
        return ModelServiceHelper.isUserHasRootPermByModel((long)currentUser, (Long)modelId);
    }

    protected void dealModelChanged() {
        Long newModelId = (Long)this.getValue(MODEL_KEY, "id");
        if (newModelId == null) {
            newModelId = 0L;
        }
        this.setNeedDealPropChange(false);
        this.getModel().setValue(DATATYPE_KEY, null);
        this.getModel().setValue(YERA_KEY, null);
        this.getModel().setValue(VERSION_KEY, null);
        this.setNeedDealPropChange(true);
        this.reflesh();
        this.setModelLabel();
        this.setCache("KEY_MODEL_ID", newModelId.toString());
        this.saveUserSelect();
        this.saveUserSelectModel(newModelId);
    }

    protected void setNeedDealPropChange(boolean deal) {
        if (deal) {
            this.getPageCache().put("NeedDealPropChange", "true");
        } else {
            this.getPageCache().put("NeedDealPropChange", "false");
        }
    }

    protected boolean needDealChange() {
        String cacheStr = this.getPageCache().get("NeedDealPropChange");
        return cacheStr == null || cacheStr.equals("true");
    }

    protected void reflesh() {
        this.initSchemeTree();
        this.refleshRightBillList();
    }

    protected void saveUserSelect() {
        Long yearId = (Long)this.getValue(YERA_KEY, "id");
        Long versionId = (Long)this.getValue(VERSION_KEY, "id");
        Long datatypeId = (Long)this.getValue(DATATYPE_KEY, "id");
        HashMap<String, Long> map = new HashMap<String, Long>(16);
        map.put(YERA_KEY, yearId);
        map.put(VERSION_KEY, versionId);
        map.put(DATATYPE_KEY, datatypeId);
        UserSelectUtils.saveWholeUserSelect((IFormView)this.getView(), (long)this.getModelId(), map);
    }

    protected void refleshRightBillList() {
        BillList billlistap = (BillList)this.getControl("billlistap");
        billlistap.clearSelection();
        billlistap.refresh();
    }

    public String getCurrentDimNumber(String controlKey) {
        String dimNum = null;
        if (controlKey.equals(YERA_KEY)) {
            dimNum = SysDimensionEnum.BudgetPeriod.getNumber();
        } else if (controlKey.equals(DATATYPE_KEY)) {
            dimNum = SysDimensionEnum.DataType.getNumber();
        } else if (controlKey.equals(VERSION_KEY)) {
            dimNum = SysDimensionEnum.Version.getNumber();
        }
        return dimNum;
    }

    @Override
    public Long getModelId() {
        Long modelId = (Long)this.getValue(MODEL_KEY, "id");
        if (modelId != null && modelId != 0L) {
            return modelId;
        }
        return 0L;
    }

    public Map<Long, Set<Long>> getAndCacheSchemeOrgMemberIds(Map<Long, Set<Long>> noAdminMap, Map<Long, Long> schemeBizMap) {
        Map<Long, Set<Long>> schemeOrgMap = new LinkedHashMap<Long, Set<Long>>(16);
        DynamicObjectCollection proOrgobjects = ReportSchemeService.getInstance().queryRecordBySchemeIds(schemeBizMap.keySet());
        if (proOrgobjects == null) {
            return schemeOrgMap;
        }
        schemeOrgMap = this.getSchemeOrgMap(proOrgobjects, noAdminMap, schemeBizMap);
        this.getPageCache().put(CACHE_SCHEME_ORG, SerializationUtils.serializeToBase64(schemeOrgMap));
        log.info("CacheSchemeOrgMemberIds:" + schemeOrgMap.size());
        return schemeOrgMap;
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        String schemeNodeId = (String)evt.getNodeId();
        this.loadCurSchemeOrgTree(schemeNodeId);
    }

    private void loadCurSchemeOrgTree(String schemeNodeId) {
        long l1 = System.currentTimeMillis();
        if (StringUtils.isEmpty((String)schemeNodeId) || schemeNodeId.split("_").length != 4) {
            return;
        }
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        TreeNode leftTreeNode = this.getOrCacheLeftTree(null);
        if (leftTreeNode == null) {
            return;
        }
        TreeNode schemeNode = leftTreeNode.getTreeNode(schemeNodeId);
        BgApplyBillUtils instance = BgApplyBillUtils.getInstance();
        Map<Long, Set<Long>> schemeOrgMap = this.getCacheSchemeOrgMap();
        Set<Long> orgIds = schemeOrgMap.get(this.getSchemeIdByNodeId(schemeNodeId));
        if (CollectionUtils.isEmpty(orgIds)) {
            return;
        }
        QFilter qfilter = new QFilter("status", "=", (Object)Character.valueOf('C')).and("id", "in", orgIds);
        TreeNode orgTree = instance.buildOrgTreeByFilters(this.getModelId(), qfilter, schemeNodeId);
        if (orgTree != null && orgTree.getChildren() != null) {
            List children = orgTree.getChildren();
            schemeNode.addChildren(children);
            children.forEach(e -> e.setParentid(schemeNode.getId()));
        }
        if (orgIds.size() > 2000 && schemeOrgMap.size() > 1 && this.getOrCacheLeftTreeClickNodeId(null) != null) {
            List dimGroupNodes = leftTreeNode.getChildren();
            if (CollectionUtils.isNotEmpty((Collection)dimGroupNodes) && dimGroupNodes.size() > 0) {
                for (TreeNode dimGroupNode : dimGroupNodes) {
                    dimGroupNode.setIsOpened(true);
                    List schemeNodes = dimGroupNode.getChildren();
                    if (CollectionUtils.isEmpty((Collection)schemeNodes)) continue;
                    for (TreeNode node : schemeNodes) {
                        if (StringUtils.equals((String)node.getId(), (String)schemeNode.getId())) continue;
                        node.setChildren(new ArrayList(0));
                        node.setIsOpened(false);
                    }
                }
                treeView.deleteAllNodes();
                treeView.addNode(leftTreeNode);
                this.getOrCacheLeftTree(leftTreeNode);
                treeView.expand(schemeNode.getId());
                this.focusNodeByNodeId(schemeNode.getId());
            }
        } else {
            schemeNode.setIsOpened(true);
            treeView.updateNode(schemeNode);
            this.getOrCacheLeftTree(leftTreeNode);
        }
        long l2 = System.currentTimeMillis();
        log.info("loadCurSchemeOrgTree-time:" + (l2 - l1));
        log.info("orgIds-size:" + orgIds.size());
    }

    private Long getSchemeIdByNodeId(String schemeNodeId) {
        return IDUtils.toLong((Object)schemeNodeId.split("_")[3]);
    }

    private String getDimGroupShowName(String dimGroupStr, IModelCacheHelper cacheHelper) {
        Member datatypeMember;
        Member versionMember;
        StringBuilder dimGroupShowName = new StringBuilder();
        String[] split = dimGroupStr.split("_");
        Long datatypeId = IDUtils.toLong((Object)split[0]);
        Long yearId = IDUtils.toLong((Object)split[1]);
        Long versionId = IDUtils.toLong((Object)split[2]);
        Member periodMember = cacheHelper.getMember("BudgetPeriod", null, yearId);
        if (periodMember != null) {
            dimGroupShowName.append(periodMember.getName()).append("_");
        }
        if ((versionMember = cacheHelper.getMember("Version", null, versionId)) != null) {
            dimGroupShowName.append(versionMember.getName()).append("_");
        }
        if ((datatypeMember = cacheHelper.getMember("DataType", null, datatypeId)) != null) {
            dimGroupShowName.append(datatypeMember.getName());
        }
        return dimGroupShowName.toString();
    }

    public void search(SearchEnterEvent event) {
        this.clearSearchCache();
        if (event.getText() != null && !"".equals(event.getText())) {
            this.searchMember(event.getText());
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u540d\u79f0\uff0c\u6309\u56de\u8f66\u952e\u786e\u8ba4\u3002", (String)"BgApplyBillListBasePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void clearSearchCache() {
        this.getPageCache().remove(SEARCH_INDEX);
        this.getPageCache().remove(SEARCH_RESULT);
    }

    private void searchOther(Boolean isNext) {
        String nodeId;
        long l1 = System.currentTimeMillis();
        List searchResult = new ArrayList(10);
        String searchResultCache = this.getPageCache().get(SEARCH_RESULT);
        if (searchResultCache != null) {
            searchResult = (List)SerializationUtils.deSerializeFromBase64((String)searchResultCache);
        }
        if (CollectionUtils.isEmpty(searchResult)) {
            return;
        }
        String searchIndexCache = this.getPageCache().get(SEARCH_INDEX);
        int searchIndex = -1;
        if (searchIndexCache != null) {
            searchIndex = Integer.parseInt(searchIndexCache);
        }
        if (searchIndex == -1) {
            return;
        }
        if (searchIndex == 0 && !isNext.booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u662f\u7b2c\u4e00\u6761\u3002", (String)"DimensionManagerList_50", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (searchIndex == searchResult.size() - 1 && isNext.booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u662f\u6700\u540e\u4e00\u884c\u6570\u636e\u3002", (String)"DimensionManagerList_51", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (isNext.booleanValue() && searchIndex + 1 < searchResult.size()) {
            nodeId = (String)searchResult.get(searchIndex + 1);
            this.getPageCache().put(SEARCH_INDEX, String.valueOf(searchIndex + 1));
            this.focusNodeByNodeId(nodeId);
        } else if (!isNext.booleanValue() && searchIndex - 1 >= -1) {
            nodeId = (String)searchResult.get(searchIndex - 1);
            this.getPageCache().put(SEARCH_INDEX, String.valueOf(searchIndex - 1));
            this.focusNodeByNodeId(nodeId);
        }
        long l2 = System.currentTimeMillis();
        log.info("searchOther-time:" + (l2 - l1));
        log.info("searchIndex:" + searchIndex);
        log.info("searchResult.size:" + searchResult.size());
    }

    private void searchMember(String searchText) {
        long l1 = System.currentTimeMillis();
        TreeNode leftTree = this.getOrCacheLeftTree(null);
        Map<String, String> nodeIdToTextMap = this.getAllNodeIdToTextMap(leftTree);
        List<String> searchResult = this.getSearchResult(nodeIdToTextMap, searchText);
        this.getPageCache().put(SEARCH_RESULT, SerializationUtils.serializeToBase64(searchResult));
        if (CollectionUtils.isEmpty(searchResult)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u9879\u3002", (String)"DimensionManagerList_52", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String firstMatchNodeId = searchResult.get(0);
        this.getPageCache().put(SEARCH_INDEX, "0");
        this.focusNodeByNodeId(firstMatchNodeId);
        long l2 = System.currentTimeMillis();
        log.info("searchMember-time:" + (l2 - l1));
        log.info("nodeIdToTextMap.size:" + nodeIdToTextMap.size());
        log.info("searchResult.size:" + searchResult.size());
    }

    private void focusNodeByNodeId(String nodeId) {
        TreeNode leftTree = this.getOrCacheLeftTree(null);
        if (leftTree == null) {
            return;
        }
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        if (nodeId == null || leftTree.getTreeNode(nodeId, 10) == null) {
            List dimGroupNodes = leftTree.getChildren();
            if (CollectionUtils.isNotEmpty((Collection)dimGroupNodes)) {
                this.expandTree(leftTree, treeView);
                treeView.focusNode((TreeNode)leftTree.getChildren().get(0));
                this.getOrCacheLeftTreeClickNodeId(((TreeNode)leftTree.getChildren().get(0)).getId());
                this.refleshRightBillList();
            }
            return;
        }
        TreeNode treeNode = leftTree.getTreeNode(nodeId, 10);
        if (treeNode != null) {
            List childPathNodes = leftTree.getChildPathNodes(nodeId);
            childPathNodes.forEach(e -> {
                if (!nodeId.equals(e.getId())) {
                    treeView.expand(e.getId());
                }
            });
            treeView.focusNode(treeNode);
            this.getOrCacheLeftTreeClickNodeId(treeNode.getId());
            this.refleshRightBillList();
            return;
        }
        String[] split = nodeId.split("_");
        if (split.length == 5) {
            int i = nodeId.lastIndexOf("_");
            String schemeNodeId = nodeId.substring(0, i);
            this.loadCurSchemeOrgTree(schemeNodeId);
            leftTree = this.getOrCacheLeftTree(null);
            if (leftTree == null) {
                return;
            }
            TreeNode orgNode = leftTree.getTreeNode(nodeId, 10);
            if (orgNode != null) {
                List childPathNodes = leftTree.getChildPathNodes(nodeId);
                childPathNodes.forEach(e -> {
                    if (!nodeId.equals(e.getId())) {
                        treeView.expand(e.getId());
                    }
                });
                treeView.focusNode(orgNode);
                this.getOrCacheLeftTreeClickNodeId(orgNode.getId());
                this.refleshRightBillList();
            }
        }
    }

    private List<String> getSearchResult(Map<String, String> nodeIdToTextMap, String searchText) {
        ArrayList<String> searchResult = new ArrayList<String>(10);
        for (Map.Entry<String, String> entry : nodeIdToTextMap.entrySet()) {
            String nodeId = entry.getKey();
            String text = entry.getValue();
            if (!text.contains(searchText)) continue;
            searchResult.add(nodeId);
        }
        return searchResult;
    }

    private Map<String, String> getAllNodeIdToTextMap(TreeNode leftTree) {
        LinkedHashMap<String, String> nodeIdToTextMap = new LinkedHashMap<String, String>(16);
        Map<String, String> dimGroupNodeIdText = this.getDimGroupNode(leftTree);
        Map<String, String> schemeNodeIdText = this.getSchemeNode(leftTree);
        this.addOrgNode(dimGroupNodeIdText, schemeNodeIdText, nodeIdToTextMap);
        return nodeIdToTextMap;
    }

    private void addOrgNode(Map<String, String> dimGroupNodeIdText, Map<String, String> schemeNodeIdText, Map<String, String> nodeIdToTextMap) {
        Map<Long, Set<Long>> cacheSchemeOrgMap = this.getCacheSchemeOrgMap();
        Map orgIdNameMap = BgApplyBillUtils.getInstance().getDeepSortOrgIdNameMap(this.getModelId());
        for (Map.Entry<String, String> entry : schemeNodeIdText.entrySet()) {
            String schemeNodeId = entry.getKey();
            String schemeText = entry.getValue();
            String dimGroupNodeId = schemeNodeId.substring(0, schemeNodeId.lastIndexOf("_"));
            if (!nodeIdToTextMap.containsKey(dimGroupNodeId)) {
                nodeIdToTextMap.put(dimGroupNodeId, dimGroupNodeIdText.get(dimGroupNodeId));
            }
            nodeIdToTextMap.put(schemeNodeId, schemeText);
            Long schemeId = IDUtils.toLong((Object)schemeNodeId.split("_")[3]);
            Set<Long> orgIds = cacheSchemeOrgMap.get(schemeId);
            if (CollectionUtils.isEmpty(orgIds)) continue;
            for (Map.Entry orgEntry : orgIdNameMap.entrySet()) {
                if (!orgIds.contains(orgEntry.getKey())) continue;
                nodeIdToTextMap.put(schemeNodeId + "_" + orgEntry.getKey(), (String)orgEntry.getValue());
            }
        }
    }

    private Map<String, String> getDimGroupNode(TreeNode leftTree) {
        LinkedHashMap<String, String> dimGroupNodeIdText = new LinkedHashMap<String, String>(16);
        List dimGroupNodes = leftTree.getChildren();
        if (CollectionUtils.isNotEmpty((Collection)dimGroupNodes)) {
            for (TreeNode dimGroupNode : dimGroupNodes) {
                dimGroupNodeIdText.put(dimGroupNode.getId(), dimGroupNode.getText());
            }
        }
        return dimGroupNodeIdText;
    }

    private Map<String, String> getSchemeNode(TreeNode leftTree) {
        LinkedHashMap<String, String> schemeNodeIdText = new LinkedHashMap<String, String>(16);
        List dimGroupNodes = leftTree.getChildren();
        if (CollectionUtils.isNotEmpty((Collection)dimGroupNodes)) {
            for (TreeNode dimGroupNode : dimGroupNodes) {
                List schemeNodes = dimGroupNode.getChildren();
                if (!CollectionUtils.isNotEmpty((Collection)schemeNodes)) continue;
                for (TreeNode schemeNode : schemeNodes) {
                    schemeNodeIdText.put(schemeNode.getId(), schemeNode.getText());
                }
            }
        }
        return schemeNodeIdText;
    }

    private Map<Long, Set<Long>> getCacheSchemeOrgMap() {
        HashMap<Long, Set<Long>> schemeOrgMap = new HashMap<Long, Set<Long>>(16);
        String schemeOrgMapCache = this.getPageCache().get(CACHE_SCHEME_ORG);
        if (schemeOrgMapCache == null) {
            log.info("buildOrgSet:schemeOrgMapCache is empty.");
            return schemeOrgMap;
        }
        return (Map)SerializationUtils.deSerializeFromBase64((String)schemeOrgMapCache);
    }

    private void clearFocusNodeIdCache() {
        this.getPageCache().remove("LeftTreeClickNodeId");
    }
}

