/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applybill.util;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.utils.base.LockUtils;
import kd.epm.eb.common.utils.cache.Cache;
import kd.epm.eb.formplugin.applybill.util.BgApplyMutexPojo;

public class BgApplyLockUtils {
    private static final Log log = LogFactory.getLog(LockUtils.class);
    public static final long MAX_TRY_LOCK_TIME_LONG = 30000L;
    public static final int MAX_MUTEX_TIME_INT = 2;

    public static List<BgApplyMutexPojo> setMutuallyExclusiveObject(List<BgApplyMutexPojo> bgApplyMutexPojoList) {
        if (bgApplyMutexPojoList.isEmpty()) {
            return null;
        }
        for (BgApplyMutexPojo bgApplyMutexPojo : bgApplyMutexPojoList) {
            Cache.get().set(bgApplyMutexPojo.getApprovalId(), bgApplyMutexPojo.getUserId() + "_" + bgApplyMutexPojo.getUserIP() + "_" + bgApplyMutexPojo.getUserName(), 2, TimeUnit.HOURS);
        }
        return bgApplyMutexPojoList;
    }

    public static List<BgApplyMutexPojo> getMutuallyExclusiveObject(List<String> keyStringList) {
        if (keyStringList == null || keyStringList.isEmpty()) {
            return Collections.emptyList();
        }
        return keyStringList.stream().filter(key -> Cache.get().get(key) != null).map(key -> {
            String value = Cache.get().get(key);
            String[] split = value.split("_");
            BgApplyMutexPojo bgApplyMutexPojo = new BgApplyMutexPojo();
            bgApplyMutexPojo.setApprovalId((String)key);
            bgApplyMutexPojo.setUserId(split[0]);
            bgApplyMutexPojo.setUserIP(split[1]);
            bgApplyMutexPojo.setUserName(split[2]);
            return bgApplyMutexPojo;
        }).collect(Collectors.toList());
    }

    public static void removeMutuallyExclusiveObject(List<String> keyStringList) {
        if (keyStringList != null && !keyStringList.isEmpty()) {
            for (String key : keyStringList) {
                if (Cache.get().get(key) == null) continue;
                Cache.get().remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T lock(String keyString, Long maxWaitTimeLong, Supplier<T> supplier) {
        DLock lock = DLock.create((String)keyString);
        try {
            if (maxWaitTimeLong == null || maxWaitTimeLong <= 0L) {
                maxWaitTimeLong = 30000L;
            }
            if (!lock.tryLock(maxWaitTimeLong.longValue())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"BgApplyLockUtils_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            T t = supplier.get();
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    public static <T> T lock(String keyString, Supplier<T> supplier) {
        return BgApplyLockUtils.lock(keyString, null, supplier);
    }

    public static void lock(String keyString, Runnable runnable) {
        BgApplyLockUtils.lock(keyString, null, () -> {
            runnable.run();
            return null;
        });
    }

    public static String returnVerificationInformation(List<String> keyStringList) {
        if (keyStringList != null && !keyStringList.isEmpty()) {
            for (String key : keyStringList) {
                String value = Cache.get().get(key);
                if (value == null) continue;
                String userName = value.split("_")[2];
                return ResManager.loadResFormat((String)"\u5f53\u524d\u5355\u636e\u6b63\u5728\u88ab\u7528\u6237%1\u7f16\u8f91", (String)"RuleManagePlugin3_61", (String)"epm-eb-formplugin", (Object[])new Object[]{userName});
            }
        }
        return null;
    }
}

