/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applybill.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.applytemplatecolumn.FormatColumn;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.UserUtils;

public class BgUserTemplateFormatService {
    private static final Log log = LogFactory.getLog(BgUserTemplateFormatService.class);
    private static BgUserTemplateFormatService instance = new BgUserTemplateFormatService();

    private BgUserTemplateFormatService() {
    }

    public static BgUserTemplateFormatService getInstance() {
        return instance;
    }

    public Map<Long, Map<String, FormatColumn>> getTemplateColumnsFormat(List<Long> templateIds, Long modelId) {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
        qfBuilder.add("applytemplate", "in", templateIds);
        qfBuilder.add("user", "=", (Object)UserUtils.getUserId());
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_apusertemplateformat", (String)"id,applytemplate,columnkey,column,ishide,isfreeze", (QFilter[])qfBuilder.toArrays());
        HashMap<Long, Map<String, FormatColumn>> map = new HashMap<Long, Map<String, FormatColumn>>();
        for (DynamicObject object : dynamicObjects) {
            FormatColumn column = new FormatColumn();
            Long applyTemplateId = object.getLong("applytemplate");
            column.setKey(object.getString("columnkey"));
            column.setTitle(object.getString("column"));
            column.setVisible((Boolean)object.get("ishide") == false);
            column.setFreeze(((Boolean)object.get("isfreeze")).booleanValue());
            Map keyColumn = map.computeIfAbsent(applyTemplateId, k -> new HashMap());
            keyColumn.put(column.getKey(), column);
            map.put(applyTemplateId, keyColumn);
        }
        return map;
    }

    public Map<String, FormatColumn> getSingleTemplateColumnsFormat(Long applyTemplateId, Long modelId) {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
        qfBuilder.add("applytemplate", "=", (Object)applyTemplateId);
        qfBuilder.add("user", "=", (Object)UserUtils.getUserId());
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_apusertemplateformat", (String)"id,applytemplate,columnkey,column,ishide,isfreeze", (QFilter[])qfBuilder.toArrays());
        HashMap<String, FormatColumn> map = new HashMap<String, FormatColumn>();
        for (DynamicObject object : dynamicObjects) {
            FormatColumn column = new FormatColumn();
            String columnkey = object.getString("columnkey");
            column.setKey(columnkey);
            column.setTitle(object.getString("column"));
            column.setVisible((Boolean)object.get("ishide") == false);
            column.setFreeze(((Boolean)object.get("isfreeze")).booleanValue());
            map.put(columnkey, column);
        }
        return map;
    }

    public void saveFormat(List<DynamicObject> dynamicObjects, Long modelId, Long templateId) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (!"true".equals(dynamicObject.getString("hide")) && !"true".equals(dynamicObject.getString("freeze"))) continue;
            DynamicObject obj = this.getNewDynamicObject("eb_apusertemplateformat");
            obj.set("model", (Object)modelId);
            obj.set("applytemplate", (Object)templateId);
            obj.set("user", (Object)UserUtils.getUserId());
            obj.set("column", dynamicObject.get("columnname"));
            obj.set("ishide", dynamicObject.get("hide"));
            obj.set("isfreeze", dynamicObject.get("freeze"));
            obj.set("columnkey", (Object)dynamicObject.getString("columnkey"));
            result.add(obj);
        }
        try (TXHandle tx = TX.required();){
            try {
                this.deleteFormat(modelId, UserUtils.getUserId(), templateId);
                SaveServiceHelper.save((DynamicObject[])result.toArray(new DynamicObject[result.size()]));
            }
            catch (Throwable e) {
                log.error(e);
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public void deleteFormat(Long modelId, Long userId, Long applyTemplateId) {
        if (modelId != null && userId != null) {
            QFilter qf1 = new QFilter("model", "=", (Object)modelId);
            QFilter qf2 = new QFilter("user", "=", (Object)userId);
            QFilter qf3 = new QFilter("applytemplate", "=", (Object)applyTemplateId);
            DeleteServiceHelper.delete((String)"eb_apusertemplateformat", (QFilter[])new QFilter[]{qf1, qf2, qf3});
        }
    }

    private DynamicObject getNewDynamicObject(String entity) {
        return BusinessDataServiceHelper.newDynamicObject((String)entity);
    }
}

