/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applyschedule;

import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class BgTaskUrgePlugin
extends AbstractFormPlugin {
    private static final String CANCEL = "btn_cancel";
    private static final String SURE = "btn_sure";
    private static final String ENTRYENTITY = "entryentity";

    public void afterCreateNewData(EventObject e) {
        this.initData();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CANCEL, SURE});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Button)evt.getSource()).getKey();
        if (SURE.equals(key)) {
            Set<String> set = this.getSelectUser();
            if (set.size() == 0) {
                return;
            }
            this.openMessage(SerializationUtils.serializeToBase64(set));
        }
    }

    private Set<String> getSelectUser() {
        HashSet<String> set = new HashSet<String>(16);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] rows_temp = entryGrid.getSelectRows();
        if (rows_temp.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"BgTaskUrgePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return set;
        }
        boolean isExistNoDealer = false;
        for (int row : rows_temp) {
            DynamicObjectCollection dealerids = (DynamicObjectCollection)this.getModel().getValue("dealerids", row);
            if (CollectionUtils.isNotEmpty((Collection)dealerids)) {
                for (DynamicObject object : dealerids) {
                    set.add(object.getString("fbasedataid.id"));
                }
                continue;
            }
            isExistNoDealer = true;
        }
        if (isExistNoDealer) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u884c\u6570\u636e\u65e0\u5904\u7406\u4eba\u3002", (String)"BgTaskUrgePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return set;
    }

    private void initData() {
        ArrayList<HashMap> rowEntity = this.getRowEntity();
        if (rowEntity != null) {
            int[] indexs = this.getModel().batchCreateNewEntryRow(ENTRYENTITY, rowEntity.size());
            for (int i = 0; i < rowEntity.size(); ++i) {
                int index = indexs[i];
                HashMap map = rowEntity.get(i);
                this.getModel().setValue("entity", map.get("applyinfo"), index);
                if (map.get("apply") != null && !"".equals(map.get("apply"))) {
                    HashMap applyMap = (HashMap)SerializationUtils.fromJsonString((String)map.get("apply").toString(), HashMap.class);
                    this.getModel().setValue("number", applyMap.get("id"), index);
                }
                if (map.get("collect") != null && !"".equals(map.get("apply"))) {
                    HashMap collectMap = (HashMap)SerializationUtils.fromJsonString((String)map.get("collect").toString(), HashMap.class);
                    this.getModel().setValue("number", collectMap.get("id"), index);
                }
                if (StringUtils.isNotEmpty((CharSequence)((String)map.get("audit")))) {
                    this.getModel().setValue("approvebill", map.get("audit"), index);
                    this.getModel().setValue("approvebillid", map.get("auditid"), index);
                }
                this.getModel().setValue("status", map.get("billstatus"), index);
                this.getModel().setValue("dealer", map.get("dealer"), index);
                String dealerIds = (String)map.get("dealerids");
                if (!StringUtils.isNotEmpty((CharSequence)dealerIds)) continue;
                String[] split = dealerIds.split(",");
                Object[] ids = new Object[split.length];
                for (int j = 0; j < split.length; ++j) {
                    ids[j] = IDUtils.toLong((Object)split[j]);
                }
                this.getModel().setValue("dealerids", (Object)ids, index);
            }
        }
    }

    private ArrayList<HashMap> getRowEntity() {
        String rowEntityData = (String)this.getView().getFormShowParameter().getCustomParam("rowEntity");
        if (StringUtils.isNotEmpty((CharSequence)rowEntityData)) {
            ArrayList rowEntity = (ArrayList)ObjectSerialUtil.parseObject((String)rowEntityData, (TypeReference)new TypeReference<ArrayList<HashMap>>(){}, (Feature[])new Feature[0]);
            return rowEntity;
        }
        return null;
    }

    private void openMessage(String executorid) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_taskmessageremin");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setShowTitle(true);
        formShowParameter.setCustomParam("executorid", (Object)executorid);
        this.getView().showForm(formShowParameter);
    }
}

