/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applytemplate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.utils.CustomF7utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.entity.memberF7.RangeF7Param;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class FixedValueSettingEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String TOOLBARAP = "toolbarap";
    private static final String BIZMODEL = "bizmodel";
    private static final String ADD_CLOSECALLBACK = "ADD_CLOSECALLBACK";
    private static final String ENTRYENTITY = "entryentity";
    private static final String SHOW_ENTRYENTITY = "entryentity1";
    private static final String DIM_ENTRYENTITY = "entryentity3";
    private static final String ADDROW = "btn_add";
    private static final String DELROW = "btn_del";
    private static final String ADAPTSCOPE_TXT = "adaptscopetxt";
    private static final String ACCOUNT_TXT = "accounttxt";
    private static final String ACCOUNT_JSON = "accountjson";
    private static final String ORG_TXT = "orgtxt";
    private static final String FIXED_TYPE = "fixedtype";
    private static final String FIXEDVALUE_TXT = "fixedvaluetxt";
    private static final String FIXEDVALUE = "fixedvalue";
    private static final String BTN_CONFIRM = "btn_confirm";
    private static final String DIM_COL_MAP = "dimcolmap";
    private static final String DIM_COL_JSON_MAP = "dimcoljsonmap";
    private static final String[] dimtxt = new String[]{"orgtxt", "dimtxt1", "dimtxt2", "dimtxt3", "dimtxt4", "dimtxt5", "dimtxt6", "dimtxt7", "dimtxt8", "dimtxt9"};

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ADDROW, DELROW, ADAPTSCOPE_TXT, ACCOUNT_TXT});
        this.addClickListeners(dimtxt);
        this.addItemClickListeners(new String[]{TOOLBARAP});
        BasedataEdit modelBaseDate = (BasedataEdit)this.getView().getControl(BIZMODEL);
        modelBaseDate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, dimtxt);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object modelobj = formShowParameter.getCustomParam("model");
        if (modelobj == null) {
            this.getView().showTipNotification("");
            return;
        }
        this.getPageCache().put("model", modelobj.toString());
        String id = (String)formShowParameter.getCustomParam("id");
        if (StringUtils.isNotEmpty((String)id)) {
            this.getPageCache().put("id", id);
            this.setData(id);
        }
    }

    private void setData(String id) {
        DynamicObjectCollection jsonEntry;
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)id, (String)"eb_fixedvaluesetting");
        if (data == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"FixedValueSettingEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        IDataModel dataModel = this.getModel();
        DynamicObject bizmodel = data.getDynamicObject(BIZMODEL);
        String accountjson = data.getString(ACCOUNT_JSON);
        String number = data.getString("number");
        String fixedtype = data.getString(FIXED_TYPE);
        dataModel.setValue(BIZMODEL, (Object)bizmodel.getLong("id"));
        dataModel.setValue("number", (Object)number);
        dataModel.setValue(FIXED_TYPE, (Object)fixedtype);
        dataModel.setValue(ACCOUNT_JSON, (Object)accountjson);
        String accountTxt = this.resolveJsonAndSetVal(accountjson, SysDimensionEnum.Account.getNumber(), modelCacheHelper, null);
        dataModel.setValue(ACCOUNT_TXT, (Object)accountTxt);
        DynamicObjectCollection adaptEntry = data.getDynamicObjectCollection(ENTRYENTITY);
        EntryGrid entryGrid = (EntryGrid)this.getControl(SHOW_ENTRYENTITY);
        if (adaptEntry != null && adaptEntry.size() > 0) {
            StringBuilder sb = new StringBuilder();
            HashMap<String, String> map = new HashMap<String, String>(16);
            HashMap<String, String> jsonMap = new HashMap<String, String>(16);
            int customIndex = 0;
            for (DynamicObject dynamicObject : adaptEntry) {
                int row = this.getModel().createNewEntryRow(DIM_ENTRYENTITY);
                DynamicObject adapt = dynamicObject.getDynamicObject("dimension");
                sb.append(adapt.getString("name")).append(",");
                if (SysDimensionEnum.Entity.getNumber().equals(adapt.getString("number"))) {
                    map.put(adapt.getString("number"), ORG_TXT);
                    jsonMap.put(adapt.getString("number"), "orgjson");
                } else {
                    String key = "dimtxt" + ++customIndex;
                    map.put(adapt.getString("number"), key);
                    jsonMap.put(adapt.getString("number"), "dimjson" + customIndex);
                    entryGrid.setColumnProperty(key, "header", (Object)new LocaleString(adapt.getString("name")));
                }
                dataModel.setValue("adaptscope", (Object)adapt.getLong("id"), row);
            }
            this.cacheDimColMap(map);
            this.cacheDimJsonColMap(jsonMap);
            this.setColVisiable(map);
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            this.getModel().setValue(ADAPTSCOPE_TXT, (Object)sb.toString());
        }
        if ((jsonEntry = data.getDynamicObjectCollection(SHOW_ENTRYENTITY)) != null && jsonEntry.size() > 0) {
            Map viewIds = modelCacheHelper.getViewsByBusModel(Long.valueOf(bizmodel.getLong("id")));
            this.setJsonEntryData(jsonEntry, modelCacheHelper, viewIds);
        }
    }

    private void setJsonEntryData(DynamicObjectCollection jsonEntry, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIds) {
        for (DynamicObject object : jsonEntry) {
            int row = this.getModel().createNewEntryRow(SHOW_ENTRYENTITY);
            this.getModel().createNewEntryRow(ENTRYENTITY);
            String orgJson = object.getString("orgjson");
            if (StringUtils.isNotEmpty((String)orgJson)) {
                String orgTxt = this.resolveJsonAndSetVal(orgJson, SysDimensionEnum.Entity.getNumber(), modelCacheHelper, viewIds.get(SysDimensionEnum.Entity.getNumber()));
                this.getModel().setValue("orgjson", (Object)orgJson, row);
                this.getModel().setValue(ORG_TXT, (Object)orgTxt, row);
            }
            for (int i = 1; i <= 9; ++i) {
                String key = "dimjson" + i;
                String txtKey = "dimtxt" + i;
                String dimjson = object.getString(key);
                String dimNumber = this.getDimNumberByCol(txtKey);
                if (!StringUtils.isNotEmpty((String)dimjson) || !StringUtils.isNotEmpty((String)dimNumber)) continue;
                String dimTxt = this.resolveJsonAndSetVal(dimjson, dimNumber, modelCacheHelper, viewIds.get(dimNumber));
                this.getModel().setValue(key, (Object)dimjson, row);
                this.getModel().setValue(txtKey, (Object)dimTxt, row);
            }
            BigDecimal fixedvalue = object.getBigDecimal(FIXEDVALUE);
            this.getModel().setValue(FIXEDVALUE_TXT, (Object)fixedvalue, row);
            this.getModel().setValue(FIXEDVALUE, (Object)fixedvalue, row);
        }
    }

    private String resolveJsonAndSetVal(String json, String dimNumber, IModelCacheHelper modelCacheHelper, Long viewId) {
        if (StringUtils.isEmpty((String)dimNumber)) {
            return null;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        JSONObject dimJsonObj = (JSONObject)jsonObject.get((Object)dimNumber);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : dimJsonObj.entrySet()) {
            Member member = modelCacheHelper.getMember(dimNumber, viewId, (String)entry.getKey());
            String scope = (String)entry.getValue();
            this.buildMultiSelectF7ReturnValue(sb, member.getName(), Integer.parseInt(scope));
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (BIZMODEL.equals(key)) {
            long modelId = this.getModelId();
            if (modelId == 0L) {
                e.setCancel(true);
            } else {
                ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
                ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(BIZMODEL)).getQFilters();
                if (qFilterList == null) {
                    qFilterList = new ArrayList<QFilter>();
                }
                qFilterList.add(new QFilter("model", "=", (Object)modelId));
                showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
            }
        }
    }

    private void openF7(String dimNumber, String key, Long modelId, Long datasetId) {
        Long busModelId = DatasetServiceHelper.getInstance().queryBizmodelByDatasetId(datasetId);
        Long viewId = BusinessModelServiceHelper.getInstance().getViewId(busModelId, dimNumber, modelId);
        RangeF7Param f7Param = new RangeF7Param();
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        f7Param.setCloseCallBack(closeCallBack);
        f7Param.setEnableView(false);
        int clickRow = this.getClickRow();
        String realKey = key.replace("txt", "json");
        String value = (String)this.getModel().getValue(realKey, clickRow);
        if (StringUtils.isNotEmpty((String)value)) {
            JSONObject jO = JSON.parseObject((String)value);
            Map scope = (Map)jO.get((Object)dimNumber);
            ArrayList members = new ArrayList(16);
            scope.forEach((memberNumber, memberScope) -> members.add(new MemberCondition(memberNumber, null, null, memberScope)));
            f7Param.setCon_list(members);
        }
        f7Param.setBizModelId(busModelId);
        f7Param.setDatasetId(datasetId);
        CustomF7utils.openCustomF7Range((Long)modelId, (String)dimNumber, (Long)viewId, (IFormView)this.getView(), (RangeF7Param)f7Param);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (ADAPTSCOPE_TXT.equals(name)) {
            this.getModel().deleteEntryData(SHOW_ENTRYENTITY);
            this.getModel().deleteEntryData(ENTRYENTITY);
            this.getView().setVisible(Boolean.FALSE, dimtxt);
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            Map<String, String> cacheDimColMap = this.getCacheDimColMap();
            if (StringUtils.isEmpty((String)newVal)) {
                Map<String, String> cacheJsonColMap = this.getCacheDimColJsonMap();
                cacheDimColMap.clear();
                cacheJsonColMap.clear();
                this.cacheDimColMap(cacheDimColMap);
                this.cacheDimJsonColMap(cacheJsonColMap);
                this.setColVisiable(cacheDimColMap);
                this.getModel().deleteEntryData(DIM_ENTRYENTITY);
            } else {
                this.setColVisiable(cacheDimColMap);
            }
        } else if (FIXEDVALUE_TXT.equals(name)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            this.getModel().setValue(FIXEDVALUE, newValue, rowIndex);
        } else if (BIZMODEL.equals(name)) {
            this.getModel().setValue(ACCOUNT_TXT, null);
            this.getModel().setValue(ACCOUNT_JSON, null);
            this.getModel().setValue(ADAPTSCOPE_TXT, null);
            this.getModel().deleteEntryData(SHOW_ENTRYENTITY);
        }
    }

    private void setColVisiable(Map<String, String> cacheDimColMap) {
        if (cacheDimColMap.size() > 0) {
            String[] keys = new String[cacheDimColMap.size()];
            int index = 0;
            for (Map.Entry<String, String> entry : cacheDimColMap.entrySet()) {
                keys[index] = entry.getValue();
                ++index;
            }
            this.getView().setVisible(Boolean.TRUE, keys);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        IDataModel dataModel = this.getModel();
        if (returnData != null) {
            if (ACCOUNT_TXT.equals(actionId)) {
                DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)returnData;
                this.setAccountJson(dynamicObjects);
            } else if (ADAPTSCOPE_TXT.equals(actionId)) {
                List dimIds = (List)returnData;
                this.setAdaptScope(dimIds);
            } else if (Arrays.asList(dimtxt).contains(actionId)) {
                int clickRow;
                DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)returnData;
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(16);
                StringBuilder sb = new StringBuilder();
                if (dynamicObjects.size() > 0) {
                    for (DynamicObject dynamicObject : dynamicObjects) {
                        String number = dynamicObject.getString("number");
                        String scope = dynamicObject.getString("scope");
                        this.buildMultiSelectF7ReturnValue(sb, dynamicObject.getString("name"), Integer.parseInt(scope));
                        map.put(number, scope);
                    }
                }
                if ((clickRow = this.getClickRow()) == -1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u884c\u4e3a\u7a7a\u3002", (String)"FixedValueSettingEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (ORG_TXT.equals(actionId)) {
                    JSONObject jsonObject = this.createJsonObject(SysDimensionEnum.Entity.getNumber(), map);
                    this.setJsonToDataEntry(jsonObject, actionId, clickRow);
                } else {
                    String number = this.getDimNumberByCol(actionId);
                    if (StringUtils.isEmpty((String)number)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"FixedValueSettingEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    JSONObject jsonObject = this.createJsonObject(number, map);
                    this.setJsonToDataEntry(jsonObject, actionId, clickRow);
                }
                if (sb.length() > 0) {
                    sb.deleteCharAt(sb.length() - 1);
                }
                dataModel.setValue(actionId, (Object)sb.toString(), clickRow);
            }
        }
    }

    private void setAdaptScope(List<Long> dimIds) {
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData(DIM_ENTRYENTITY);
        HashMap<String, String> map = new HashMap<String, String>(16);
        HashMap<String, String> jsonMap = new HashMap<String, String>(16);
        EntryGrid entry = (EntryGrid)this.getControl(SHOW_ENTRYENTITY);
        int customIndex = 0;
        if (dimIds.size() > 0) {
            int[] rows = dataModel.batchCreateNewEntryRow(DIM_ENTRYENTITY, dimIds.size());
            int i = 0;
            StringBuilder sb = new StringBuilder();
            for (Long id : dimIds) {
                dataModel.setValue("adaptscope", (Object)id, rows[i]);
                DynamicObject dim = (DynamicObject)dataModel.getValue("adaptscope", rows[i]);
                String number = dim.getString("number");
                sb.append(dim.getString("name")).append(",");
                if (SysDimensionEnum.Entity.getNumber().equals(number)) {
                    map.put(number, ORG_TXT);
                    jsonMap.put(number, "orgjson");
                } else if (!dim.getBoolean("issysdimension")) {
                    String key = "dimtxt" + ++customIndex;
                    map.put(number, key);
                    jsonMap.put(number, "dimjson" + customIndex);
                    entry.setColumnProperty(key, "header", (Object)new LocaleString(dim.getString("name")));
                }
                ++i;
            }
            this.cacheDimColMap(map);
            this.cacheDimJsonColMap(jsonMap);
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            dataModel.setValue(ADAPTSCOPE_TXT, (Object)sb.toString());
        }
    }

    private void setAccountJson(DynamicObjectCollection dynamicObjects) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(16);
        StringBuilder sb = new StringBuilder();
        if (dynamicObjects.size() > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                String number = dynamicObject.getString("number");
                String scope = dynamicObject.getString("scope");
                this.buildMultiSelectF7ReturnValue(sb, dynamicObject.getString("name"), Integer.parseInt(scope));
                map.put(number, scope);
            }
        }
        JSONObject jsonObject = this.createJsonObject(SysDimensionEnum.Account.getNumber(), map);
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        this.getModel().setValue(ACCOUNT_TXT, (Object)sb.toString());
        if (jsonObject == null) {
            this.getModel().setValue(ACCOUNT_JSON, null);
            return;
        }
        this.getModel().setValue(ACCOUNT_JSON, (Object)jsonObject.toJSONString());
    }

    private int getClickRow() {
        EntryGrid entry = (EntryGrid)this.getControl(SHOW_ENTRYENTITY);
        int focusRow = entry.getEntryState().getFocusRow();
        return focusRow;
    }

    private JSONObject createJsonObject(String dimNumber, Map<String, String> dimRange) {
        if (StringUtils.isEmpty((String)dimNumber) || dimRange == null || dimRange.size() == 0) {
            return null;
        }
        JSONObject dimJson = new JSONObject();
        JSONObject jsonObject = new JSONObject(new LinkedHashMap());
        for (Map.Entry<String, String> entry : dimRange.entrySet()) {
            jsonObject.put(entry.getKey(), (Object)entry.getValue());
        }
        dimJson.put(dimNumber, (Object)jsonObject);
        return dimJson;
    }

    private void setJsonToDataEntry(JSONObject json, String key, int row) {
        String realKey = key.replace("txt", "json");
        if (json == null) {
            this.getModel().setValue(realKey, null, row);
            return;
        }
        String jsonStr = json.toJSONString();
        this.getModel().setValue(realKey, (Object)jsonStr, row);
    }

    private void cacheDimColMap(Map<String, String> map) {
        this.getPageCache().put(DIM_COL_MAP, SerializationUtils.toJsonString(map));
    }

    private void cacheDimJsonColMap(Map<String, String> map) {
        this.getPageCache().put(DIM_COL_JSON_MAP, SerializationUtils.toJsonString(map));
    }

    private Map<String, String> getCacheDimColMap() {
        String s = this.getPageCache().get(DIM_COL_MAP);
        if (StringUtils.isEmpty((String)s)) {
            return new HashMap<String, String>(16);
        }
        Map map = (Map)SerializationUtils.fromJsonString((String)s, Map.class);
        return map;
    }

    private Map<String, String> getCacheDimColJsonMap() {
        String s = this.getPageCache().get(DIM_COL_JSON_MAP);
        if (StringUtils.isEmpty((String)s)) {
            return new HashMap<String, String>(16);
        }
        Map map = (Map)SerializationUtils.fromJsonString((String)s, Map.class);
        return map;
    }

    private void buildMultiSelectF7ReturnValue(StringBuilder sb, String name, int val) {
        if (RangeEnum.getRangeByVal((int)val) == RangeEnum.ONLY) {
            sb.append(name).append(',');
        } else {
            sb.append(name).append(ResManager.loadKDString((String)"\u7684", (String)"FixedValueSettingEditPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)val).getName()).append(',');
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        long bizModel = this.getDatasetId();
        long modelId = this.getModelId();
        if (modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e3a\u7a7a\u3002", (String)"FixedValueSettingEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (bizModel == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u4e3a\u7a7a\u3002", (String)"FixedValueSettingEditPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (ACCOUNT_TXT.equals(key)) {
            this.openF7(SysDimensionEnum.Account.getNumber(), key, modelId, bizModel);
        } else if (ADAPTSCOPE_TXT.equals(key)) {
            this.openDimSelect();
        } else if (ORG_TXT.equals(key)) {
            this.openF7(SysDimensionEnum.Entity.getNumber(), key, modelId, bizModel);
        } else if (Arrays.asList(dimtxt).contains(key)) {
            this.openF7(this.getDimNumberByCol(key), key, modelId, bizModel);
        } else if (ADDROW.equals(key)) {
            this.getModel().createNewEntryRow(SHOW_ENTRYENTITY);
            this.getModel().createNewEntryRow(ENTRYENTITY);
        } else if (DELROW.equals(key)) {
            this.delRow();
        }
    }

    private void delRow() {
        EntryGrid entry = (EntryGrid)this.getControl(SHOW_ENTRYENTITY);
        int[] selectRows = entry.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"FixedValueSettingEditPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().deleteEntryRows(SHOW_ENTRYENTITY, selectRows);
        this.getModel().deleteEntryRows(ENTRYENTITY, selectRows);
    }

    private String getDimNumberByCol(String colKey) {
        Map<String, String> cacheDimColMap = this.getCacheDimColMap();
        String dinNumber = null;
        for (Map.Entry<String, String> entry : cacheDimColMap.entrySet()) {
            if (!colKey.equals(entry.getValue())) continue;
            dinNumber = entry.getKey();
        }
        return dinNumber;
    }

    private void openDimSelect() {
        long modelId = this.getModelId();
        long bizRangId = this.getBizRangeId();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_seldimension");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ADAPTSCOPE_TXT);
        List<Long> ids = this.getOrgAndCustomDim(bizRangId, modelId);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter qf = new QFilter("id", "in", ids);
        qFilters.add(qf);
        showParameter.setCustomParam("Qflters", (Object)SerializationUtils.serializeToBase64(qFilters));
        showParameter.setCustomParam("model", (Object)String.valueOf(modelId));
        showParameter.setCustomParam("maxsize", (Object)"9");
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setShowTitle(true);
        showParameter.setCaption(ResManager.loadKDString((String)"\u7ef4\u5ea6\u9009\u62e9", (String)"FixedValueSettingEditPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    private List<Long> getOrgAndCustomDim(Long bizModelId, Long modelId) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensionList = modelCacheHelper.getDimensionListByBusModel(bizModelId);
        ArrayList<Long> ids = new ArrayList<Long>(16);
        for (Dimension dimension : dimensionList) {
            if (!SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber()) && dimension.isPreset()) continue;
            ids.add(dimension.getId());
        }
        return ids;
    }

    private long getDatasetId() {
        DynamicObject obj = (DynamicObject)this.getModel().getValue(BIZMODEL);
        if (obj == null) {
            return 0L;
        }
        return obj.getLong("id");
    }

    private long getBizRangeId() {
        DynamicObject obj = (DynamicObject)this.getModel().getValue(BIZMODEL);
        if (obj == null) {
            return 0L;
        }
        return obj.getLong("businessmodel.id");
    }

    @Override
    public Long getModelId() {
        Long modelstr = IDUtils.toLong((Object)this.getPageCache().get("model"));
        if (modelstr == null || modelstr == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e3a\u7a7a\u3002", (String)"FixedValueSettingEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return 0L;
        }
        return modelstr;
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (BTN_CONFIRM.equals(itemKey)) {
            if (!this.check()) {
                evt.setCancel(true);
                return;
            }
            if (this.checkCurSettring()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7ec4\u5408\u5b58\u5728\u4ea4\u96c6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FixedValueSettingEditPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            String id = this.getPageCache().get("id");
            if (!this.checkWithOther(StringUtils.isEmpty((String)id) ? 0L : Long.parseLong(id))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u79d1\u76ee-\u56fa\u5b9a\u503c\u7c7b\u578b\u7ec4\u5408\u4e0e\u5176\u4ed6\u56fa\u5b9a\u503c\u8bbe\u7f6e\u5b58\u5728\u4ea4\u96c6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FixedValueSettingEditPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    private boolean check() {
        block9: {
            DynamicObjectCollection entryEntity;
            block8: {
                Object value = this.getModel().getValue(BIZMODEL);
                if (value == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u96c6\u3002", (String)"FixedValueSettingEditPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return false;
                }
                String account = (String)this.getModel().getValue(ACCOUNT_TXT);
                if (StringUtils.isEmpty((String)account)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u79d1\u76ee\u3002", (String)"FixedValueSettingEditPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return false;
                }
                entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
                DynamicObjectCollection showEntity = this.getModel().getEntryEntity(SHOW_ENTRYENTITY);
                Map<String, String> cacheDimColJsonMap = this.getCacheDimColJsonMap();
                if (cacheDimColJsonMap.size() <= 0) break block8;
                Collection<String> values = cacheDimColJsonMap.values();
                if (entryEntity == null) break block9;
                int row = 1;
                for (DynamicObject dynamicObject : entryEntity) {
                    BigDecimal fixedval = dynamicObject.getBigDecimal(FIXEDVALUE);
                    if (BigDecimal.ZERO.compareTo(fixedval) == 0) {
                        this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5217\u8868\u7b2c%1\u884c\u56fa\u5b9a\u503c\u672a\u586b\u5199\u3002", (String)"FixedValueSettingEditPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[]{row}));
                        return false;
                    }
                    DynamicObject showDyo = (DynamicObject)showEntity.get(row - 1);
                    for (String key : values) {
                        String txtKey = key.replace("json", "txt");
                        if (!StringUtils.isEmpty((String)showDyo.getString(txtKey))) continue;
                        this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5217\u8868\u7b2c%1\u884c\u7ef4\u5ea6\u672a\u9009\u62e9\u6210\u5458\u3002", (String)"FixedValueSettingEditPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[]{row}));
                        return false;
                    }
                    ++row;
                }
                break block9;
            }
            if (entryEntity != null) {
                int row = 1;
                for (DynamicObject dynamicObject : entryEntity) {
                    BigDecimal fixedval = dynamicObject.getBigDecimal(FIXEDVALUE);
                    if (BigDecimal.ZERO.compareTo(fixedval) == 0) {
                        this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5217\u8868\u7b2c%1\u884c\u56fa\u5b9a\u503c\u672a\u586b\u5199\u3002", (String)"FixedValueSettingEditPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[]{row}));
                        return false;
                    }
                    ++row;
                }
            }
        }
        return true;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (BTN_CONFIRM.equals(itemKey)) {
            String id = this.getPageCache().get("id");
            if (StringUtils.isEmpty((String)id)) {
                this.save(null);
            } else {
                this.save(Long.parseLong(id));
            }
        }
    }

    private void save(Long id) {
        IDataModel dataModel = this.getModel();
        DynamicObject dynamicObject = null;
        String userId = RequestContext.get().getUserId();
        Date now = TimeServiceHelper.now();
        String number = (String)dataModel.getValue("number");
        int maxSeq = this.getMaxSeq();
        if (id != null) {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"eb_fixedvaluesetting");
        } else {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_fixedvaluesetting");
            dynamicObject.set("creater", (Object)userId);
            dynamicObject.set("createdate", (Object)now);
            if (StringUtils.isEmpty((String)number)) {
                number = "FIXVAL-" + System.currentTimeMillis();
                dynamicObject.set("number", (Object)number);
                this.getModel().setValue("number", (Object)number);
            } else {
                dynamicObject.set("number", (Object)number);
            }
            dynamicObject.set("dseq", (Object)(maxSeq + 1));
        }
        Long bizmodel = this.getDatasetId();
        Long modelId = this.getModelId();
        String accountJson = (String)dataModel.getValue(ACCOUNT_JSON);
        String fixedtype = (String)dataModel.getValue(FIXED_TYPE);
        dynamicObject.set("model", (Object)modelId);
        dynamicObject.set(BIZMODEL, (Object)bizmodel);
        dynamicObject.set(ACCOUNT_JSON, (Object)accountJson);
        dynamicObject.set("modifydate", (Object)now);
        dynamicObject.set("modifier", (Object)userId);
        dynamicObject.set(FIXED_TYPE, (Object)fixedtype);
        DynamicObjectCollection dynamicObjects = dynamicObject.getDynamicObjectCollection(ENTRYENTITY);
        this.fillAdaptEntry(dynamicObjects);
        DynamicObjectCollection dynamicObjects1 = dynamicObject.getDynamicObjectCollection(SHOW_ENTRYENTITY);
        this.fillDimMeberEntry(dynamicObjects1);
        Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        String aftersaveId = ((DynamicObject)save[0]).getString("id");
        this.getPageCache().put("id", aftersaveId);
        this.getView().returnDataToParent((Object)aftersaveId);
        this.getView().close();
    }

    private void fillDimMeberEntry(DynamicObjectCollection dynamicObjects1) {
        dynamicObjects1.clear();
        DynamicObjectCollection adaptScopeEntry = this.getModel().getEntryEntity(ENTRYENTITY);
        int seq = 1;
        for (DynamicObject adapt : adaptScopeEntry) {
            DynamicObject dynamicObject = dynamicObjects1.addNew();
            dynamicObject.set("orgjson", (Object)adapt.getString("orgjson"));
            for (int i = 1; i <= 9; ++i) {
                dynamicObject.set("dimjson" + i, (Object)adapt.getString("dimjson" + i));
            }
            dynamicObject.set(FIXEDVALUE, (Object)adapt.getBigDecimal(FIXEDVALUE));
            dynamicObject.set("seq", (Object)seq);
            ++seq;
        }
    }

    private void fillAdaptEntry(DynamicObjectCollection dynamicObjects) {
        dynamicObjects.clear();
        DynamicObjectCollection adaptScopeEntry = this.getModel().getEntryEntity(DIM_ENTRYENTITY);
        int seq = 1;
        for (DynamicObject adapt : adaptScopeEntry) {
            DynamicObject adaptscope = adapt.getDynamicObject("adaptscope");
            DynamicObject dynamicObject = dynamicObjects.addNew();
            dynamicObject.set("dimension", (Object)adaptscope.getLong("id"));
            dynamicObject.set("seq", (Object)seq);
            ++seq;
        }
    }

    private int getMaxSeq() {
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_fixedvaluesetting", (String)"dseq", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId())}, (String)"dseq desc", (int)1);
        if (dynamicObjects == null || dynamicObjects.size() == 0) {
            return 0;
        }
        return ((DynamicObject)dynamicObjects.get(0)).getInt("dseq");
    }

    private boolean checkCurSettring() {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        if (entryEntity.size() <= 1) {
            return false;
        }
        List<Map<String, Set<String>>> rowDimMap = this.getRowDimMap(entryEntity, modelCacheHelper);
        for (int i = 1; i < rowDimMap.size(); ++i) {
            Map<String, Set<String>> iMap = rowDimMap.get(i);
            for (int j = i - 1; j >= 0; --j) {
                Map<String, Set<String>> jMap = rowDimMap.get(j);
                boolean flag = true;
                for (Map.Entry<String, Set<String>> en : iMap.entrySet()) {
                    boolean rowFlag = false;
                    String key = en.getKey();
                    HashSet iset = new HashSet(en.getValue());
                    Set<String> jset = jMap.get(key);
                    if (iset.size() > jset.size()) {
                        for (String s : jset) {
                            if (!iset.contains(s)) continue;
                            rowFlag = true;
                            break;
                        }
                    } else {
                        for (String s : iset) {
                            if (!jset.contains(s)) continue;
                            rowFlag = true;
                            break;
                        }
                    }
                    boolean bl = flag = flag && rowFlag;
                    if (rowFlag) continue;
                    break;
                }
                if (!flag) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkWithOther(Long curId) {
        QFilter qf2;
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        String selects = "id,fixedtype,bizmodel,accountjson";
        QFilter qf1 = new QFilter(BIZMODEL, "=", (Object)this.getDatasetId());
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"eb_fixedvaluesetting", (String)selects, (QFilter[])new QFilter[]{qf1, qf2 = new QFilter("id", "!=", (Object)curId)});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return true;
        }
        String curFixedType = (String)this.getModel().getValue(FIXED_TYPE);
        String accountjson = (String)this.getModel().getValue(ACCOUNT_JSON);
        if (StringUtils.isEmpty((String)curFixedType) || StringUtils.isEmpty((String)accountjson)) {
            return false;
        }
        String dimNumber = SysDimensionEnum.Account.getNumber();
        JSONObject pageJsonobj = JSONObject.parseObject((String)accountjson);
        JSONObject pageObj = pageJsonobj.getJSONObject(dimNumber);
        HashSet<String> set = new HashSet<String>(16);
        for (Map.Entry objectEntry : pageObj.entrySet()) {
            String number = (String)objectEntry.getKey();
            String scope = (String)objectEntry.getValue();
            List members = modelCacheHelper.getMember(dimNumber, null, number, Integer.parseInt(scope));
            for (Member member : members) {
                set.add(member.getNumber());
            }
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            String json;
            JSONObject jsonObject;
            JSONObject value;
            String fixedtype = dynamicObject.getString(FIXED_TYPE);
            if (!curFixedType.equals(fixedtype) || !this.hasIntersection(modelCacheHelper, set, value = (jsonObject = JSONObject.parseObject((String)(json = dynamicObject.getString(ACCOUNT_JSON)))).getJSONObject(dimNumber))) continue;
            return false;
        }
        return true;
    }

    private boolean hasIntersection(IModelCacheHelper modelCacheHelper, Set<String> set, JSONObject v2) {
        for (Map.Entry objectEntry : v2.entrySet()) {
            String number = (String)objectEntry.getKey();
            String scope = (String)objectEntry.getValue();
            List members = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, number, Integer.parseInt(scope));
            for (Member member : members) {
                if (!set.contains(member.getNumber())) continue;
                return true;
            }
        }
        return false;
    }

    private List<Map<String, Set<String>>> getRowDimMap(DynamicObjectCollection entryEntity, IModelCacheHelper modelCacheHelper) {
        ArrayList<Map<String, Set<String>>> list = new ArrayList<Map<String, Set<String>>>(16);
        Map<String, String> jsonDimMap = this.getCacheDimColJsonMap();
        long datasetId = this.getDatasetId();
        Map dimViewMap = modelCacheHelper.getViewsByDataSet(Long.valueOf(datasetId));
        for (DynamicObject rowEntity : entryEntity) {
            HashMap map = new HashMap(16);
            for (Map.Entry<String, String> entry : jsonDimMap.entrySet()) {
                String json = rowEntity.getString(entry.getValue());
                if (StringUtils.isEmpty((String)json)) continue;
                JSONObject jsonObject = JSONObject.parseObject((String)json);
                String dimNumber = entry.getKey();
                JSONObject dimObj = jsonObject.getJSONObject(dimNumber);
                HashSet<String> set = new HashSet<String>(16);
                for (Map.Entry objectEntry : dimObj.entrySet()) {
                    String number = (String)objectEntry.getKey();
                    String scope = (String)objectEntry.getValue();
                    List members = modelCacheHelper.getMember(dimNumber, (Long)dimViewMap.get(dimNumber), number, Integer.parseInt(scope));
                    for (Member member : members) {
                        set.add(member.getNumber());
                    }
                }
                map.put(dimNumber, set);
            }
            if (map.isEmpty()) continue;
            list.add(map);
        }
        return list;
    }
}

