/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applytemplate;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.FunPermissionHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.model.permission.MemberPermHelper;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;

public class FixedValueSettingListPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String TOOLBARAP = "toolbarap";
    private static final String MODEL = "model";
    private static final String ADD_CLOSECALLBACK = "ADD_CLOSECALLBACK";
    private static final String ENTRYENTITY = "entryentity";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOLBARAP});
        BasedataEdit modelBaseDate = (BasedataEdit)this.getView().getControl(MODEL);
        modelBaseDate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Long modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)MODEL, (boolean)false);
        if (IDUtils.isNotNull((Long)modelId)) {
            this.getModel().setValue(MODEL, (Object)modelId);
            this.getPageCache().put(MODEL, modelId.toString());
            this.modelChanged(modelId);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"FixedValueSettingListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public void modelChanged(Long modelId) {
        this.getPageCache().put(MODEL, modelId.toString());
        this.refreshList();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (MODEL.equals(key)) {
            DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
            if (model != null) {
                Long modelId = model.getLong("id");
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
                this.modelChanged(modelId);
            } else {
                this.getPageCache().put(MODEL, null);
                this.refreshList();
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("add".equals(key)) {
            this.openAddPage(null);
        } else if ("delete".equals(key)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows == null || selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"FixedValueSettingListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u4f1a\u5220\u9664\u6240\u9009\u56fa\u5b9a\u503c\u8bbe\u7f6e\uff0c\u662f\u5426\u7ee7\u7eed\u5220\u9664\uff1f", (String)"FixedValueSettingListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete_comfirm", (IFormPlugin)this));
        } else if ("refresh".equals(key)) {
            this.refreshList();
        } else if ("modify".equals(key)) {
            this.modify();
        }
    }

    private void modify() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"FixedValueSettingListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Object realid = this.getModel().getValue("realid", selectRows[0]);
        if (realid == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\u3002", (String)"FixedValueSettingListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.openAddPage(realid.toString());
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String key = messageBoxClosedEvent.getCallBackId();
        if ("delete_comfirm".equals(key) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.delete();
        }
    }

    private void delete() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        ArrayList<Long> ids = new ArrayList<Long>(10);
        if (selectRows != null && selectRows.length > 0) {
            for (int selectRow : selectRows) {
                String id = (String)this.getModel().getValue("realid", selectRow);
                if (!StringUtils.isNotEmpty((CharSequence)id)) continue;
                ids.add(Long.parseLong(id));
            }
        }
        DeleteServiceHelper.delete((String)"eb_fixedvaluesetting", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"FixedValueSettingListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.refreshList();
    }

    private void refreshList() {
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData(ENTRYENTITY);
        long modelId = this.getModelId();
        if (modelId == 0L) {
            return;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        String selects = "id,fnumber,fixedtype,bizmodel,accountjson,modifier,modifydate,entryentity.dimension";
        QFilter qf = new QFilter(MODEL, "=", (Object)modelId);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"eb_fixedvaluesetting", (String)selects, (QFilter[])new QFilter[]{qf}, (String)"dseq asc");
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            dataModel.batchCreateNewEntryRow(ENTRYENTITY, dynamicObjects.length);
            for (int i = 0; i < dynamicObjects.length; ++i) {
                dataModel.setValue("fixedtype", dynamicObjects[i].get("fixedtype"), i);
                dataModel.setValue("modifier", dynamicObjects[i].get("modifier.id"), i);
                dataModel.setValue("modifydate", dynamicObjects[i].get("modifydate"), i);
                dataModel.setValue("realid", dynamicObjects[i].get("id"), i);
                dataModel.setValue("accounttxt", (Object)this.resolveAccountJson(dynamicObjects[i].getString("accountjson"), modelCacheHelper, null), i);
                dataModel.setValue("bizmodel", (Object)dynamicObjects[i].getDynamicObject("bizmodel").getLong("id"), i);
                DynamicObjectCollection adaptEntry = dynamicObjects[i].getDynamicObjectCollection(ENTRYENTITY);
                if (adaptEntry == null || adaptEntry.size() <= 0) continue;
                StringBuilder sb = new StringBuilder();
                for (DynamicObject dynamicObject : adaptEntry) {
                    DynamicObject adapt = dynamicObject.getDynamicObject("dimension");
                    sb.append(adapt.getString("name")).append(",");
                }
                if (sb.length() > 0) {
                    sb.deleteCharAt(sb.length() - 1);
                }
                this.getModel().setValue("adaptscope", (Object)sb.toString(), i);
            }
        }
    }

    private String resolveAccountJson(String json, IModelCacheHelper modelCacheHelper, Long viewId) {
        String dimNumber = SysDimensionEnum.Account.getNumber();
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        JSONObject dimJsonObj = (JSONObject)jsonObject.get((Object)dimNumber);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : dimJsonObj.entrySet()) {
            Member member = modelCacheHelper.getMember(dimNumber, viewId, (String)entry.getKey());
            sb.append(member.getName()).append(",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private void openAddPage(String id) {
        long modelId = this.getModelId();
        if (modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"FixedValueSettingListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_fixedvalueedit");
        showParameter.setCustomParam(MODEL, (Object)this.getPageCache().get(MODEL));
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            showParameter.setCustomParam("id", (Object)id);
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ADD_CLOSECALLBACK);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setShowTitle(true);
        showParameter.setCaption(ResManager.loadKDString((String)"\u56fa\u5b9a\u503c\u8bbe\u7f6e", (String)"FixedValueSettingListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if (ADD_CLOSECALLBACK.equals(key)) {
            String id = (String)closedCallBackEvent.getReturnData();
            if (StringUtils.isNotEmpty((CharSequence)id)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"FixedValueSettingListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.refreshList();
        }
    }

    @Override
    public Long getModelId() {
        Long modelId = IDUtils.toLong((Object)this.getPageCache().get(MODEL));
        if (IDUtils.isNotNull((Long)modelId)) {
            DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
            if (model == null) {
                return 0L;
            }
            modelId = model.getLong("id");
            this.getPageCache().put(MODEL, modelId.toString());
        }
        return modelId;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (MODEL.equals(key) && this.getControl(MODEL) != null) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(MODEL)).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>();
            }
            qFilterList.addAll(FixedValueSettingListPlugin.getModelFilter(this.getView()));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    public static List<QFilter> getModelFilter(IFormView view) {
        QFilter qf = ModelUtil.getModelQfilterByApp((IFormView)view);
        ArrayList<QFilter> modelQFilters = new ArrayList<QFilter>();
        modelQFilters.add(qf);
        if (view.getParentView() != null) {
            if ("epm_user_assignperm".equals(view.getParentView().getEntityId())) {
                Set ids = ModelServiceHelper.getLimitedModelListByUser(null);
                modelQFilters.add(new QFilter("id", "in", (Object)ids));
            } else {
                String source = view.getEntityId();
                if (view instanceof ListView && "bos_list".equals(source)) {
                    source = ((ListView)view).getBillFormId();
                } else if (view instanceof ListView && "bos_templatetreelist".equals(source)) {
                    source = ((ListView)view).getBillFormId();
                } else if (view instanceof ListView && "bos_treelist".equals(source)) {
                    source = ((ListView)view).getBillFormId();
                }
                QFilter superid = new QFilter("id", "in", (Object)MemberPermHelper.getLimitedModelListByUser());
                QFilter haspermid = new QFilter("id", "in", (Object)FunPermissionHelper.getEffectiveByPermModel((String)source, (ApplicationTypeEnum)ModelUtil.queryApp((IFormView)view)));
                QFilter perRoleids = new QFilter("id", "in", (Object)FunPermissionHelper.getRoleModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)"epm_model", (ApplicationTypeEnum)ModelUtil.queryApp((IFormView)view)));
                modelQFilters.add(superid.or(haspermid).or(perRoleids));
            }
        }
        return modelQFilters;
    }
}

