/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applytemplate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.epm.eb.common.applybill.SplitColmunConfig;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.ColumnList;
import kd.epm.eb.common.applytemplatecolumn.FieldTypeEnum;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class SplitConfigSetPlugin
extends AbstractFormPlugin {
    private static final String ENTRYENTITY = "entryentity";

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String splitConfigStr = (String)formShowParameter.getCustomParam("splitConfig");
        String columnSetStr = (String)formShowParameter.getCustomParam("columnSet");
        List splitConfig = SerializationUtils.fromJsonStringToList((String)splitConfigStr, SplitColmunConfig.class);
        ColumnList columnList = (ColumnList)SerializationUtils.fromJsonString((String)columnSetStr, ColumnList.class);
        this.buildColum(columnList);
        this.initEntityData(splitConfig);
    }

    private void buildColum(ColumnList columnList) {
        Collection columns = columnList.getColumns();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        for (BaseColumn column : columns) {
            if (!column.getKey().startsWith("h_") || column.getFieldtype() != FieldTypeEnum.NumberField) continue;
            ComboItem item = new ComboItem(new LocaleString(column.getTitle()), column.getKey());
            items.add(item);
        }
        ComboEdit rangeEdit = (ComboEdit)this.getControl("splitsource");
        rangeEdit.setComboItems(items);
        rangeEdit = (ComboEdit)this.getControl("splitscale");
        rangeEdit.setComboItems(items);
        rangeEdit = (ComboEdit)this.getControl("splitcolumn");
        rangeEdit.setComboItems(items);
    }

    private void initEntityData(List<SplitColmunConfig> splitConfig) {
        if (!splitConfig.isEmpty()) {
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, splitConfig.size());
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
            int count = 0;
            for (DynamicObject row : entryEntity) {
                SplitColmunConfig config = splitConfig.get(count);
                row.set("splitcolumn", (Object)config.getSplitColumn());
                row.set("splitsource", (Object)config.getSplitSource());
                row.set("splitscale", (Object)config.getSplitScale());
            }
            this.getView().updateView(ENTRYENTITY);
        }
    }

    public void afterBindData(EventObject e) {
    }

    private void lockCell() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        int rowCount = 0;
        for (DynamicObject row : entryEntity) {
            String splitsource = row.getString("splitsource");
            String splitscale = row.getString("splitscale");
            if (StringUtils.isNotEmpty((CharSequence)splitsource)) {
                this.getView().setEnable(Boolean.valueOf(false), rowCount, new String[]{"splitsource"});
            }
            if (StringUtils.isNotEmpty((CharSequence)splitscale)) {
                this.getView().setEnable(Boolean.valueOf(false), rowCount, new String[]{"splitscale"});
            }
            ++rowCount;
        }
    }

    @Override
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (key.equals("btn_ok")) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
            ArrayList<SplitColmunConfig> configs = new ArrayList<SplitColmunConfig>();
            int rowCount = 1;
            for (DynamicObject row : entryEntity) {
                SplitColmunConfig config = new SplitColmunConfig();
                String splitcolumn = row.getString("splitcolumn");
                String splitsource = row.getString("splitsource");
                if (StringUtils.isEmpty((CharSequence)splitsource)) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u8bbe\u7f6e\u7b2c%1\u884c\u7684\u5206\u89e3\u6765\u6e90\u5217\u3002", (String)"SplitConfigSetPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{rowCount}));
                }
                String splitscale = row.getString("splitscale");
                ++rowCount;
                config.setSplitColumn(splitcolumn);
                config.setSplitSource(splitsource);
                config.setSplitScale(splitscale);
                configs.add(config);
            }
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(configs));
            this.getView().close();
        }
    }
}

