/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applytemplate.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.MulComboField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.EntryFieldGroupAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.applybill.util.ApplyTemplateUtils;
import kd.epm.eb.common.applyTemplate.constants.BussPlanEntryPresetFieldsEnum;
import kd.epm.eb.common.applyTemplate.constants.ColCfgPresetFieldsEnum;
import kd.epm.eb.common.applyTemplate.constants.ColCfgPropEnum;
import kd.epm.eb.common.applyTemplate.constants.DimUseTypeEnum;
import kd.epm.eb.common.applyTemplate.constants.StatusEnum;
import kd.epm.eb.common.applyTemplate.entity.ApplyTemplateDimCfgEntity;
import kd.epm.eb.common.applyTemplate.entity.tableconfig.BizTableConfig;
import kd.epm.eb.common.applyTemplate.helper.CustomControlHelper;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.CalculateColumn;
import kd.epm.eb.common.applytemplatecolumn.ColumnEnum;
import kd.epm.eb.common.applytemplatecolumn.ColumnList;
import kd.epm.eb.common.applytemplatecolumn.DimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.DimensionDataColumn;
import kd.epm.eb.common.applytemplatecolumn.DimensionMemberRange;
import kd.epm.eb.common.applytemplatecolumn.FieldTypeEnum;
import kd.epm.eb.common.applytemplatecolumn.MeasureColumn;
import kd.epm.eb.common.applytemplatecolumn.NumberColumn;
import kd.epm.eb.common.applytemplatecolumn.RelationDimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.RelationValueColumn;
import kd.epm.eb.common.applytemplatecolumn.RowDimensionColumn;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.entity.memberF7.BaseF7Parameter;
import kd.epm.eb.common.entity.memberF7.LeftTreeF7Parameter;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class ApplyTemplateCfgBasePlugin
extends AbstractFormPlugin {
    private ColumnList columnList;

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{"entryentity_businessplan", "entryentity_apply"});
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addBaseDataListener();
    }

    private void addBaseDataListener() {
        ColumnList columnList = this.getColumnListFromParam();
        Collection columns = columnList.getColumns();
        if (CollectionUtils.isEmpty((Collection)columns)) {
            return;
        }
        List<ApplyTemplateDimCfgEntity> dimCfgList = this.getDimCfgList();
        List dimBusinessNumList = dimCfgList.stream().filter(t -> DimUseTypeEnum.BUSINESS_PLAN.getValue().equals(t.getUsetype())).map(ApplyTemplateDimCfgEntity::getDimnum).collect(Collectors.toList());
        for (BaseColumn column : columns) {
            BasedataEdit basedataEdit;
            String number;
            DynamicObject dynamicObject;
            List dimensionMemberRanges;
            long dimensionId;
            if (column.getType() != ColumnEnum.Dimension && column.getType() != ColumnEnum.RelationDimension && column.getType() != ColumnEnum.RowDimension) continue;
            if (column instanceof DimensionColumn) {
                BasedataEdit basedataEdit2;
                DimensionColumn dimensionColumn = (DimensionColumn)column;
                String dimNumber = dimensionColumn.getDimNumber();
                long businessModelId = dimensionColumn.getBussinessModelId();
                long dimensionId2 = dimensionColumn.getDimensionId();
                List dimensionMemberRanges2 = dimensionColumn.getDimensionMemberRanges();
                if (!dimBusinessNumList.contains(dimNumber) || (basedataEdit2 = (BasedataEdit)this.getControl(this.getBusinessPlanEntryColKey(dimNumber.toLowerCase() + "_name"))) == null) continue;
                basedataEdit2.addBeforeF7SelectListener(beforeF7SelectEvent -> this.beforeFilterDimensionF7(businessModelId, dimensionId2, dimensionMemberRanges2, beforeF7SelectEvent));
                continue;
            }
            if (column instanceof RelationDimensionColumn) {
                RelationDimensionColumn relationDimensionColumn = (RelationDimensionColumn)column;
                long businessModelId = relationDimensionColumn.getBussinessModelId();
                dimensionId = relationDimensionColumn.getDimensionId();
                dimensionMemberRanges = relationDimensionColumn.getDimensionMemberRanges();
                dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)relationDimensionColumn.getDimensionId(), (String)"epm_dimension");
                number = dynamicObject.getString("number");
                if (!dimBusinessNumList.contains(number) || (basedataEdit = (BasedataEdit)this.getControl(this.getBusinessPlanEntryColKey(number.toLowerCase() + "_name"))) == null) continue;
                basedataEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> this.beforeFilterDimensionF7(businessModelId, dimensionId, dimensionMemberRanges, beforeF7SelectEvent));
                continue;
            }
            if (!(column instanceof RowDimensionColumn)) continue;
            RowDimensionColumn rowDimensionColumn = (RowDimensionColumn)column;
            long businessModelId = rowDimensionColumn.getBussinessModelId();
            dimensionId = rowDimensionColumn.getDimensionId();
            dimensionMemberRanges = rowDimensionColumn.getDimensionMemberRanges();
            dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)rowDimensionColumn.getDimensionId(), (String)"epm_dimension");
            number = dynamicObject.getString("number");
            if (!dimBusinessNumList.contains(number) || (basedataEdit = (BasedataEdit)this.getControl(this.getBusinessPlanEntryColKey(number.toLowerCase() + "_name"))) == null) continue;
            basedataEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> this.beforeFilterDimensionF7(businessModelId, dimensionId, dimensionMemberRanges, beforeF7SelectEvent));
        }
    }

    protected List<ApplyTemplateDimCfgEntity> getDimCfgList() {
        ArrayList<ApplyTemplateDimCfgEntity> result = new ArrayList<ApplyTemplateDimCfgEntity>(16);
        Map<String, List<Long>> cacheSelectedPanelDimIds = this.getCacheSelectedPanelDimIds();
        Collection<List<Long>> values = cacheSelectedPanelDimIds.values();
        ArrayList<Long> allDimIds = new ArrayList<Long>(16);
        for (List<Long> value : values) {
            allDimIds.addAll(value);
        }
        Map dimMap = BusinessDataServiceHelper.loadFromCache((Object[])allDimIds.toArray(), (String)"epm_dimension");
        for (Map.Entry<String, List<Long>> entry : cacheSelectedPanelDimIds.entrySet()) {
            String userType = entry.getKey();
            List<Long> dimIds = entry.getValue();
            for (Long dimId : dimIds) {
                ApplyTemplateDimCfgEntity applyTemplateDimCfgEntity = new ApplyTemplateDimCfgEntity();
                applyTemplateDimCfgEntity.setDimid(dimId);
                applyTemplateDimCfgEntity.setUsetype(userType);
                applyTemplateDimCfgEntity.setApplytemplateid(this.getTemplateId());
                applyTemplateDimCfgEntity.setApplytemplatenumber(this.getTemplateNumber());
                DynamicObject dynamicObject = (DynamicObject)dimMap.get(dimId);
                if (dynamicObject != null) {
                    String number = dynamicObject.getString("number");
                    applyTemplateDimCfgEntity.setDimnum(number);
                }
                result.add(applyTemplateDimCfgEntity);
            }
        }
        return result;
    }

    private void beforeFilterDimensionF7(Long busModelId, Long dimensionId, List<DimensionMemberRange> dimensionMemberRanges, BeforeF7SelectEvent arg) {
        ArrayList<String> allMemberNumbers = new ArrayList<String>(16);
        DynamicObject dimensionModel = BusinessDataServiceHelper.loadSingle((Object)dimensionId, (String)"epm_dimension");
        if (dimensionModel == null) {
            return;
        }
        String dimensionNumber = dimensionModel.getString("number");
        this.getPageCache().put("currentDimNum", dimensionNumber);
        Long dataSetId = this.getDataSetId();
        long bussModelId = this.getBusModelId();
        Map<String, Long> viewIds = this.getViewIds();
        Long viewId = viewIds.get(dimensionNumber);
        if (dimensionMemberRanges != null && !dimensionMemberRanges.isEmpty()) {
            for (DimensionMemberRange dimensionMemberRange : dimensionMemberRanges) {
                String memberNumber = dimensionMemberRange.getNumber();
                int range = Integer.parseInt(dimensionMemberRange.getScope());
                List members = this.getIModelCacheHelper().getMember(dimensionNumber, viewId, memberNumber, range);
                if (members == null || members.isEmpty()) continue;
                for (Member member : members) {
                    allMemberNumbers.add(member.getNumber());
                }
            }
        } else {
            List members = ModelCacheContext.getOrCreate((Long)this.getModelId()).getMembers(viewId, dimensionNumber);
            if (members != null && !members.isEmpty()) {
                for (Member member : members) {
                    allMemberNumbers.add(member.getNumber());
                }
            }
        }
        LeftTreeF7Parameter leftTreeF7Parameter = new LeftTreeF7Parameter();
        leftTreeF7Parameter.setMultiple(true);
        if (SysDimensionEnum.Account.getNumber().equals(dimensionNumber)) {
            leftTreeF7Parameter.setDataSetIds(Collections.singletonList(dataSetId));
        }
        leftTreeF7Parameter.setKeepTree(true);
        leftTreeF7Parameter.setOptionalNumber(new ArrayList(allMemberNumbers));
        arg.getFormShowParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, arg.getProperty().getName()));
        this.switchF7(arg, bussModelId, (BaseF7Parameter)leftTreeF7Parameter);
    }

    protected Map<String, Long> getViewIds() {
        return this.getIModelCacheHelper().getViewsByBusModel(this.getBusModelId());
    }

    protected Long getBusModelId() {
        Long dataSetId = this.getDataSetId();
        return this.getIModelCacheHelper().getBusModelByDataSet(dataSetId);
    }

    protected Long getDataSetId() {
        Object datasetId = this.getView().getFormShowParameter().getCustomParam("datasetId");
        if (datasetId == null) {
            return 0L;
        }
        return IDUtils.toLong((Object)datasetId);
    }

    public String getCurrentDimNumber(String controlKey) {
        return this.getPageCache().get("currentDimNum");
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        this.renderEntryEntityApplyCol(e);
        this.renderDimPanel(e);
    }

    private void renderDimPanel(LoadCustomControlMetasArgs e) {
        List<Map<String, String>> rowDims = this.getRowDimsFromParam((FormShowParameter)e.getSource());
        FlexPanelAp statisticsPanelAp = this.createStatisticsPanelAp(rowDims);
        FlexPanelAp businessPlanPanelAp = this.createBusinessPlanPanelAp(rowDims);
        FlexPanelAp dataInitDimPanelAp = this.createDataInitDimPanelAp(rowDims);
        this.setPanelApProperties(e, statisticsPanelAp, "flexpanel_statistics");
        this.setPanelApProperties(e, businessPlanPanelAp, "flexpanel_businessplan");
        this.setPanelApProperties(e, dataInitDimPanelAp, "flexpanel_init_dim");
    }

    private FlexPanelAp createStatisticsPanelAp(List<Map<String, String>> rowDims) {
        List<ControlAp<?>> controlAps = this.buildPanelFieldAps(rowDims, "flexpanel_statistics");
        FlexPanelAp dynamicFlexPanelAp = CustomControlHelper.createDynamicFlexPanelAp((String)"flexpanel_statistics");
        dynamicFlexPanelAp.getItems().addAll(controlAps);
        return dynamicFlexPanelAp;
    }

    private FlexPanelAp createDataInitDimPanelAp(List<Map<String, String>> rowDims) {
        List<ControlAp<?>> controlAps = this.buildPanelFieldAps(rowDims, "flexpanel_init_dim");
        FlexPanelAp dynamicFlexPanelAp = CustomControlHelper.createDynamicFlexPanelAp((String)"flexpanel_init_dim");
        dynamicFlexPanelAp.getItems().addAll(controlAps);
        return dynamicFlexPanelAp;
    }

    private FlexPanelAp createBusinessPlanPanelAp(List<Map<String, String>> rowDims) {
        List<ControlAp<?>> controlAps = this.buildPanelFieldAps(rowDims, "flexpanel_businessplan");
        FlexPanelAp dynamicFlexPanelAp = CustomControlHelper.createDynamicFlexPanelAp((String)"flexpanel_businessplan");
        dynamicFlexPanelAp.getItems().addAll(controlAps);
        return dynamicFlexPanelAp;
    }

    private List<ControlAp<?>> buildPanelFieldAps(List<Map<String, String>> rowDims, String panelKey) {
        ArrayList fieldAps = new ArrayList(16);
        if (CollectionUtils.isEmpty(rowDims)) {
            return fieldAps;
        }
        for (Map<String, String> rowDim : rowDims) {
            String dimensionId = rowDim.get("dimensionId");
            String flag = rowDim.get("flag");
            FieldAp dynamicFieldAp = CustomControlHelper.createDynamicFieldAp((String)(this.getPanelDimIdPrefix(panelKey) + dimensionId), (String)flag, null);
            CheckBoxField dynamicCheckBoxField = CustomControlHelper.createDynamicCheckBoxField((String)dimensionId, (String)flag);
            dynamicCheckBoxField.setShowStyle(1);
            dynamicFieldAp.setField((Field)dynamicCheckBoxField);
            fieldAps.add((ControlAp<?>)dynamicFieldAp);
        }
        return fieldAps;
    }

    protected String getPanelDimIdPrefix(String panelKey) {
        if (StringUtils.equals((String)panelKey, (String)"flexpanel_statistics")) {
            return "flexpanel_statistics_";
        }
        if (StringUtils.equals((String)panelKey, (String)"flexpanel_businessplan")) {
            return "flexpanel_businessplan_";
        }
        if (StringUtils.equals((String)panelKey, (String)"flexpanel_init_dim")) {
            return "flexpanel_init_dim_";
        }
        return "";
    }

    private void renderEntryEntityApplyCol(LoadCustomControlMetasArgs e) {
        List<BaseColumn> renderColumns = this.getRenderColumns(e);
        EntryAp entryAp = this.createEntryAp(renderColumns);
        this.setEntryApProperties(e, entryAp);
    }

    private void setEntryApProperties(LoadCustomControlMetasArgs e, EntryAp entryAp) {
        HashMap<String, String> mapEntry = new HashMap<String, String>(16);
        mapEntry.put("id", "entryentity_apply");
        mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
        e.getItems().add(mapEntry);
    }

    private void setPanelApProperties(LoadCustomControlMetasArgs e, FlexPanelAp flexPanelAp, String panelKey) {
        HashMap<String, String> mapHead = new HashMap<String, String>();
        mapHead.put("id", panelKey);
        mapHead.put("items", (String)flexPanelAp.createControl().get("items"));
        e.getItems().add(mapHead);
    }

    private List<BaseColumn> getRenderColumns(LoadCustomControlMetasArgs e) {
        ColumnList columnList = this.getApplyTemplateColumnList(e);
        if (columnList == null) {
            return new ArrayList<BaseColumn>(0);
        }
        this.columnListSort(columnList);
        this.setColumnListToParam((FormShowParameter)e.getSource(), columnList);
        return this.getBaseColumns(columnList);
    }

    protected List<BaseColumn> getBaseColumns(ColumnList columnList) {
        if (columnList == null) {
            return new ArrayList<BaseColumn>(16);
        }
        Collection columns = columnList.getColumns();
        return columns.stream().filter(ee -> "h".equals(ee.getCategory())).collect(Collectors.toList());
    }

    private ColumnList getApplyTemplateColumnList(LoadCustomControlMetasArgs e) {
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        Object templateId = formShowParameter.getCustomParam("templateId");
        return ApplyTemplateUtils.getEntrycfgByApplyTemplateID((Long)IDUtils.toLong((Object)templateId));
    }

    private EntryAp createEntryAp(List<BaseColumn> columns) {
        List<ControlAp<?>> entryFieldAps = this.buildEntryFields(columns);
        EntryAp entryAp = CustomControlHelper.createDynamicEntryAp((String)"entryentity_apply");
        entryAp.getItems().addAll(entryFieldAps);
        return entryAp;
    }

    private List<ControlAp<?>> buildEntryFields(List<BaseColumn> columns) {
        EntryFieldAp entryFieldAp;
        ColCfgPresetFieldsEnum[] values;
        ArrayList entryFieldAps = new ArrayList(16);
        for (ColCfgPresetFieldsEnum value : values = ColCfgPresetFieldsEnum.values()) {
            entryFieldAp = CustomControlHelper.createEntryFieldAp((String)value.getKey(), (String)value.getName(), (FieldTypeEnum)FieldTypeEnum.TextField);
            entryFieldAps.add((ControlAp<?>)entryFieldAp);
        }
        HashMap<String, EntryFieldGroupAp> entryGroups = new HashMap<String, EntryFieldGroupAp>(16);
        for (BaseColumn column : columns) {
            String key = column.getKey();
            entryFieldAp = CustomControlHelper.createEntryFieldAp((String)key, (String)column.getTitle(), (FieldTypeEnum)FieldTypeEnum.Boolean);
            if (StringUtils.isNotEmpty((String)column.getGrouptitle())) {
                EntryFieldGroupAp entryFieldGroupAp = new EntryFieldGroupAp();
                entryFieldGroupAp.setName(new LocaleString(column.getGrouptitle()));
                entryFieldGroupAp.setKey(key + "groupap");
                if (entryGroups.containsKey(column.getGrouptitle())) {
                    entryFieldGroupAp = (EntryFieldGroupAp)entryGroups.get(column.getGrouptitle());
                    entryFieldGroupAp.getItems().add(entryFieldAp);
                    continue;
                }
                entryFieldGroupAp.getItems().add(entryFieldAp);
                entryGroups.put(column.getGrouptitle(), entryFieldGroupAp);
                entryFieldAps.add((ControlAp<?>)entryFieldGroupAp);
                continue;
            }
            entryFieldAps.add((ControlAp<?>)entryFieldAp);
        }
        return entryFieldAps;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        super.getEntityType(e);
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        this.registerDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    private void registerDynamicProps(MainEntityType newMainType) {
        this.registerEntryEntityApplyDynamicProps(newMainType);
        this.registerStatisticsPanelDynamicProps(newMainType);
        this.registerBussPlanPanelDynamicProps(newMainType);
        this.registerBussPlanEntryProps(newMainType);
        this.registerDataInitPanelDynamicProps(newMainType);
    }

    private void registerBussPlanEntryProps(MainEntityType newMainType) {
        EntryAp entryAp = this.createBusinessPlanEntryAp();
        List items = entryAp.getItems();
        EntryType entryType = (EntryType)newMainType.getAllEntities().get("entryentity_businessplan");
        for (ControlAp item : items) {
            ComboProp dynamicComboFieldProp;
            BasedataField basedataField;
            if (!(item instanceof FieldAp)) continue;
            FieldAp fieldAp = (FieldAp)item;
            Field field = fieldAp.getField();
            if (field instanceof CheckBoxField) {
                BooleanProp dynamicBooleanProp = (BooleanProp)CustomControlHelper.createDynamicFieldProp((String)fieldAp.getKey(), (String)fieldAp.getName().toString(), (FieldTypeEnum)FieldTypeEnum.Boolean);
                entryType.addProperty((DynamicProperty)dynamicBooleanProp);
                continue;
            }
            if (field instanceof BasedataField) {
                basedataField = (BasedataField)fieldAp.getField();
                BasedataProp basedataProp = CustomControlHelper.createDynamicBaseDataProp((String)fieldAp.getKey(), (String)basedataField.getBaseEntityId());
                entryType.addProperty((DynamicProperty)basedataProp);
                entryType.addProperty((DynamicProperty)((LongProp)basedataProp.getRefIdProp()));
                continue;
            }
            if (field instanceof MulBasedataField) {
                basedataField = (MulBasedataField)fieldAp.getField();
                CustomControlHelper.addMultiBaseDataF7ToMainEntity((Container)((Container)this.getControl("entryentity_businessplan")), (MainEntityType)newMainType, (String)fieldAp.getKey(), (String)basedataField.getBaseEntityId());
                continue;
            }
            if (field instanceof TextField) {
                FieldProp dynamicFieldProp = CustomControlHelper.createDynamicFieldProp((String)fieldAp.getKey(), (String)fieldAp.getName().toString(), (FieldTypeEnum)FieldTypeEnum.TextField);
                entryType.addProperty((DynamicProperty)dynamicFieldProp);
                continue;
            }
            if (field instanceof ComboField) {
                dynamicComboFieldProp = CustomControlHelper.createDynamicComboFieldProp((String)fieldAp.getKey(), (String)fieldAp.getName().toString());
                entryType.addProperty((DynamicProperty)dynamicComboFieldProp);
                continue;
            }
            if (!(field instanceof MulComboField)) continue;
            dynamicComboFieldProp = CustomControlHelper.createDynamicComboFieldProp((String)fieldAp.getKey(), (String)fieldAp.getName().toString());
            entryType.addProperty((DynamicProperty)dynamicComboFieldProp);
        }
    }

    private void registerEntryEntityApplyDynamicProps(MainEntityType newMainType) {
        List<ControlAp<?>> entryApItems = this.getEntryApItems();
        EntryType entryType = (EntryType)newMainType.getAllEntities().get("entryentity_apply");
        entryType.createPropIndexs();
        for (ControlAp<?> controlAp : entryApItems) {
            if (controlAp instanceof EntryFieldAp) {
                EntryFieldAp entryFieldAp = (EntryFieldAp)controlAp;
                this.registerEntryFieldAp(entryType, entryFieldAp);
                continue;
            }
            if (!(controlAp instanceof EntryFieldGroupAp)) continue;
            EntryFieldGroupAp entryFieldGroupAp = (EntryFieldGroupAp)controlAp;
            List items = entryFieldGroupAp.getItems();
            for (ControlAp item : items) {
                if (!(item instanceof EntryFieldAp)) continue;
                EntryFieldAp entryFieldAp = (EntryFieldAp)item;
                this.registerEntryFieldAp(entryType, entryFieldAp);
            }
        }
    }

    private void registerStatisticsPanelDynamicProps(MainEntityType newMainType) {
        FlexPanelAp statisticsPanelAp = this.getStatisticsFlexPanelAp();
        List items = statisticsPanelAp.getItems();
        for (ControlAp item : items) {
            FieldAp fieldAp;
            Field field;
            if (!(item instanceof FieldAp) || !((field = (fieldAp = (FieldAp)item).getField()) instanceof CheckBoxField)) continue;
            BooleanProp dynamicBooleanProp = (BooleanProp)CustomControlHelper.createDynamicFieldProp((String)fieldAp.getKey(), (String)fieldAp.getName().toString(), (FieldTypeEnum)FieldTypeEnum.Boolean);
            newMainType.addProperty((DynamicProperty)dynamicBooleanProp);
        }
    }

    private void registerDataInitPanelDynamicProps(MainEntityType newMainType) {
        FlexPanelAp statisticsPanelAp = this.getDataInitFlexPanelAp();
        List items = statisticsPanelAp.getItems();
        for (ControlAp item : items) {
            FieldAp fieldAp;
            Field field;
            if (!(item instanceof FieldAp) || !((field = (fieldAp = (FieldAp)item).getField()) instanceof CheckBoxField)) continue;
            BooleanProp dynamicBooleanProp = (BooleanProp)CustomControlHelper.createDynamicFieldProp((String)fieldAp.getKey(), (String)fieldAp.getName().toString(), (FieldTypeEnum)FieldTypeEnum.Boolean);
            newMainType.addProperty((DynamicProperty)dynamicBooleanProp);
        }
    }

    private void registerBussPlanPanelDynamicProps(MainEntityType newMainType) {
        FlexPanelAp businessPlanPanelAp = this.getBusPlanFlexPanelAp();
        List items = businessPlanPanelAp.getItems();
        for (ControlAp item : items) {
            FieldAp fieldAp;
            Field field;
            if (!(item instanceof FieldAp) || !((field = (fieldAp = (FieldAp)item).getField()) instanceof CheckBoxField)) continue;
            BooleanProp dynamicBooleanProp = (BooleanProp)CustomControlHelper.createDynamicFieldProp((String)fieldAp.getKey(), (String)fieldAp.getName().toString(), (FieldTypeEnum)FieldTypeEnum.Boolean);
            newMainType.addProperty((DynamicProperty)dynamicBooleanProp);
        }
    }

    private void registerEntryFieldAp(EntryType entryType, EntryFieldAp entryFieldAp) {
        Field field = entryFieldAp.getField();
        if (field instanceof TextField) {
            TextProp dynamicTextProp = (TextProp)CustomControlHelper.createDynamicFieldProp((String)entryFieldAp.getKey(), (String)entryFieldAp.getName().toString(), (FieldTypeEnum)FieldTypeEnum.TextField);
            entryType.addProperty((DynamicProperty)dynamicTextProp);
        } else if (field instanceof CheckBoxField) {
            BooleanProp dynamicBooleanProp = (BooleanProp)CustomControlHelper.createDynamicFieldProp((String)entryFieldAp.getKey(), (String)entryFieldAp.getName().toString(), (FieldTypeEnum)FieldTypeEnum.Boolean);
            entryType.addProperty((DynamicProperty)dynamicBooleanProp);
        }
    }

    private List<ControlAp<?>> getEntryApItems() {
        ColumnList columnListFromParam = this.getColumnListFromParam();
        List<BaseColumn> baseColumns = this.getBaseColumns(columnListFromParam);
        EntryAp entryAp = this.createEntryAp(baseColumns);
        return entryAp.getItems();
    }

    private EntryAp getEntryAp() {
        ColumnList columnListFromParam = this.getColumnListFromParam();
        List<BaseColumn> baseColumns = this.getBaseColumns(columnListFromParam);
        return this.createEntryAp(baseColumns);
    }

    private FlexPanelAp getBusPlanFlexPanelAp() {
        List<Map<String, String>> rowDimsFromParam = this.getRowDimsFromParam(null);
        return this.createBusinessPlanPanelAp(rowDimsFromParam);
    }

    private FlexPanelAp getStatisticsFlexPanelAp() {
        List<Map<String, String>> rowDimsFromParam = this.getRowDimsFromParam(null);
        return this.createStatisticsPanelAp(rowDimsFromParam);
    }

    private FlexPanelAp getDataInitFlexPanelAp() {
        List<Map<String, String>> rowDimsFromParam = this.getRowDimsFromParam(null);
        return this.createDataInitDimPanelAp(rowDimsFromParam);
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setEntryApplyView();
        this.setFlexPanelView("flexpanel_businessplan");
        this.setFlexPanelView("flexpanel_statistics");
    }

    private void setEntryApplyView() {
        EntryAp dynamicEntryAp = this.getEntryAp();
        List fieldEdits = ((Container)dynamicEntryAp.buildRuntimeControl()).getItems();
        this.setViewToCustomControl(fieldEdits, "entryentity_apply");
    }

    private void setFlexPanelView(String panelKey) {
        FlexPanelAp flexPanelAp = this.getStatisticsFlexPanelAp();
        if (StringUtils.equals((String)panelKey, (String)"flexpanel_businessplan")) {
            flexPanelAp = this.getBusPlanFlexPanelAp();
        } else if (StringUtils.equals((String)panelKey, (String)"flexpanel_init_dim")) {
            flexPanelAp = this.getDataInitFlexPanelAp();
        }
        List items = ((Container)flexPanelAp.buildRuntimeControl()).getItems();
        for (Control item : items) {
            item.setView(this.getView());
        }
        Container panel1 = (Container)this.getView().getControl(panelKey);
        panel1.getItems().addAll(items);
        this.getView().createControlIndex(items);
    }

    private void setViewToCustomControl(List<Control> items, String entityName) {
        for (Control fieldEdit : items) {
            if (fieldEdit instanceof Container) {
                Container entryFieldGroupAp = (Container)fieldEdit;
                List controls = entryFieldGroupAp.getItems();
                this.setViewToCustomControl(controls, entityName);
                continue;
            }
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entityName);
            fieldEdit.setView(this.getView());
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        EntryGrid entryGrid;
        Control entryControl;
        super.onGetControl(e);
        String controlKey = e.getKey();
        if (controlKey.startsWith("h_") || ColCfgPresetFieldsEnum.isPresetField((String)controlKey)) {
            EntryAp entryAp = this.getEntryAp();
            List items = entryAp.getItems();
            this.setEntryApplyControls(items, controlKey, e);
        } else if (controlKey.startsWith("flexpanel_businessplan_")) {
            FlexPanelAp busPlanFlexPanelAp = this.getBusPlanFlexPanelAp();
            List itemsBusPlan = busPlanFlexPanelAp.getItems();
            this.setPanelControls(itemsBusPlan, controlKey, e);
        } else if (controlKey.startsWith("flexpanel_statistics_")) {
            FlexPanelAp statisticsFlexPanelAp = this.getStatisticsFlexPanelAp();
            List itemsStatistics = statisticsFlexPanelAp.getItems();
            this.setPanelControls(itemsStatistics, controlKey, e);
        } else if (controlKey.startsWith("flexpanel_init_dim_")) {
            FlexPanelAp dataInitFlexPanelAp = this.getDataInitFlexPanelAp();
            List itemsStatistics = dataInitFlexPanelAp.getItems();
            this.setPanelControls(itemsStatistics, controlKey, e);
        } else if (controlKey.startsWith("entryentity_businessplan_")) {
            EntryAp entryAp = this.createBusinessPlanEntryAp();
            List items = entryAp.getItems();
            this.setBusinessEntryApControls(items, controlKey, e);
        } else if (controlKey.equals("entryentity_businessplan")) {
            EntryGrid entryGrid2;
            Control entryControl2 = e.getControl();
            if (entryControl2 != null && (entryGrid2 = (EntryGrid)entryControl2).getItems().isEmpty()) {
                EntryAp entryAp = this.createBusinessPlanEntryAp();
                List fieldEdits = ((Container)entryAp.buildRuntimeControl()).getItems();
                this.addThisViewToEntryGrid(entryGrid2, fieldEdits);
            }
        } else if ("entryentity_apply".equals(controlKey) && (entryControl = e.getControl()) != null && (entryGrid = (EntryGrid)entryControl).getItems().isEmpty()) {
            EntryAp entryAp = this.getEntryAp();
            List fieldEdits = ((Container)entryAp.buildRuntimeControl()).getItems();
            this.addThisViewToEntryGrid(entryGrid, fieldEdits);
        }
    }

    private void setBusinessEntryApControls(List<ControlAp<?>> items, String controlKey, OnGetControlArgs e) {
        for (ControlAp<?> item : items) {
            ComboEdit comboEdit;
            BasedataEdit bsEdit;
            if (!(item instanceof FieldAp)) continue;
            FieldAp fieldAp = (FieldAp)item;
            String key = fieldAp.getKey();
            Field field = fieldAp.getField();
            if (!StringUtils.equals((String)controlKey, (String)key)) continue;
            if (field instanceof BasedataField) {
                bsEdit = new BasedataEdit();
                bsEdit.setKey(controlKey);
                bsEdit.setModel(this.getModel());
                bsEdit.setView(this.getView());
                bsEdit.setFieldKey(controlKey);
                bsEdit.setEntryKey("entryentity_businessplan");
                e.setControl((Control)bsEdit);
                continue;
            }
            if (field instanceof MulBasedataField) {
                bsEdit = new MulBasedataEdit();
                bsEdit.setKey(controlKey);
                bsEdit.setModel(this.getModel());
                bsEdit.setView(this.getView());
                bsEdit.setFieldKey(controlKey);
                bsEdit.setEntryKey("entryentity_businessplan");
                e.setControl((Control)bsEdit);
                continue;
            }
            if (field instanceof TextField) {
                TextEdit textEdit = new TextEdit();
                textEdit.setKey(controlKey);
                textEdit.setView(this.getView());
                textEdit.setModel(this.getModel());
                textEdit.setFieldKey(controlKey);
                textEdit.setEntryKey("entryentity_businessplan");
                e.setControl((Control)textEdit);
                continue;
            }
            if (field instanceof CheckBoxField) {
                FieldEdit fieldEdit = new FieldEdit();
                fieldEdit.setKey(controlKey);
                fieldEdit.setModel(this.getModel());
                fieldEdit.setView(this.getView());
                fieldEdit.setFieldKey(controlKey);
                fieldEdit.setEntryKey("entryentity_businessplan");
                e.setControl((Control)fieldEdit);
                continue;
            }
            if (field instanceof ComboField) {
                comboEdit = new ComboEdit();
                comboEdit.setKey(controlKey);
                comboEdit.setModel(this.getModel());
                comboEdit.setView(this.getView());
                comboEdit.setFieldKey(controlKey);
                comboEdit.setEntryKey("entryentity_businessplan");
                comboEdit.setEntryControlKey("entryentity_businessplan");
                e.setControl((Control)comboEdit);
                continue;
            }
            if (!(field instanceof MulComboField)) continue;
            comboEdit = new MulComboEdit();
            comboEdit.setKey(controlKey);
            comboEdit.setModel(this.getModel());
            comboEdit.setView(this.getView());
            comboEdit.setFieldKey(controlKey);
            comboEdit.setEntryKey("entryentity_businessplan");
            comboEdit.setEntryControlKey("entryentity_businessplan");
            e.setControl((Control)comboEdit);
        }
    }

    private void setEntryApplyControls(List<ControlAp<?>> items, String controlKey, OnGetControlArgs e) {
        for (ControlAp<?> item : items) {
            if (item instanceof EntryFieldAp) {
                EntryFieldAp entryFieldAp = (EntryFieldAp)item;
                String key = entryFieldAp.getKey();
                if (!StringUtils.equals((String)controlKey, (String)key)) continue;
                Field field = entryFieldAp.getField();
                if (field instanceof CheckBoxField) {
                    FieldEdit fieldEdit = new FieldEdit();
                    fieldEdit.setKey(controlKey);
                    fieldEdit.setModel(this.getModel());
                    fieldEdit.setView(this.getView());
                    fieldEdit.setFieldKey(controlKey);
                    fieldEdit.setEntryKey("entryentity_apply");
                    e.setControl((Control)fieldEdit);
                    continue;
                }
                if (!(field instanceof TextField)) continue;
                TextEdit textEdit = new TextEdit();
                textEdit.setKey(controlKey);
                textEdit.setModel(this.getModel());
                textEdit.setView(this.getView());
                textEdit.setFieldKey(controlKey);
                textEdit.setEntryKey("entryentity_apply");
                e.setControl((Control)textEdit);
                continue;
            }
            if (!(item instanceof EntryFieldGroupAp)) continue;
            EntryFieldGroupAp entryFieldGroupAp = (EntryFieldGroupAp)item;
            List entryFieldGroupApItems = entryFieldGroupAp.getItems();
            this.setEntryApplyControls(entryFieldGroupApItems, controlKey, e);
        }
    }

    private void setPanelControls(List<ControlAp<?>> items, String controlKey, OnGetControlArgs e) {
        for (ControlAp<?> item : items) {
            if (!(item instanceof FieldAp)) continue;
            FieldAp fieldAp = (FieldAp)item;
            String key = fieldAp.getKey();
            Field field = fieldAp.getField();
            if (!StringUtils.equals((String)controlKey, (String)key) || !(field instanceof CheckBoxField)) continue;
            FieldEdit fieldEdit = new FieldEdit();
            fieldEdit.setKey(controlKey);
            fieldEdit.setModel(this.getModel());
            fieldEdit.setView(this.getView());
            fieldEdit.setFieldKey(controlKey);
            e.setControl((Control)fieldEdit);
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity_apply");
        entryEntity.clear();
        this.setColEntryPresetRecords();
    }

    private void setColEntryPresetRecords() {
        ColCfgPropEnum[] values = ColCfgPropEnum.values();
        int[] rows = this.getModel().batchCreateNewEntryRow("entryentity_apply", values.length);
        for (int i = 0; i < rows.length; ++i) {
            this.getModel().setValue(values[i].getKey(), (Object)values[i].getDesc(), i);
        }
    }

    protected void dynamicCreateEntryField() {
        this.getModel().deleteEntryData("entryentity_businessplan");
        this.registerBussPlanEntryProps(this.getModel().getDataEntityType());
        EntryAp entryAp = this.createBusinessPlanEntryAp();
        this.sendCreateGridColumns(entryAp);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity_businessplan");
        entryGrid.getItems().clear();
        List fieldEdits = ((Container)entryAp.buildRuntimeControl()).getItems();
        this.addThisViewToEntryGrid(entryGrid, fieldEdits);
        this.getView().updateView("entryentity_businessplan");
    }

    private void addThisViewToEntryGrid(EntryGrid entryGrid, List<Control> fieldEdits) {
        for (Control fieldEdit : fieldEdits) {
            if (fieldEdit instanceof Container) {
                if (fieldEdit instanceof OperationColumn) {
                    fieldEdit.setView(this.getView());
                } else {
                    this.addThisViewToEntryEditField(((Container)fieldEdit).getItems());
                    fieldEdit.setView(this.getView());
                }
            } else if (fieldEdit != null) {
                fieldEdit.setView(this.getView());
            }
            entryGrid.getItems().add(fieldEdit);
        }
    }

    private void addThisViewToEntryEditField(List<Control> items) {
        for (Control fieldEdit : items) {
            if (fieldEdit instanceof Container) {
                if (!(fieldEdit instanceof OperationColumn)) {
                    this.addThisViewToEntryEditField(((Container)fieldEdit).getItems());
                }
                fieldEdit.setView(this.getView());
                continue;
            }
            if (fieldEdit == null) continue;
            fieldEdit.setView(this.getView());
        }
    }

    protected EntryAp createBusinessPlanEntryAp() {
        EntryAp entryAp = CustomControlHelper.createDynamicEntryAp((String)"entryentity_businessplan");
        Map<String, List<Long>> dimIdsMap = this.getCacheSelectedPanelDimIds();
        List<Long> dimIds = dimIdsMap.get(DimUseTypeEnum.BUSINESS_PLAN.getValue());
        if (CollectionUtils.isEmpty(dimIds)) {
            BussPlanEntryPresetFieldsEnum[] values;
            entryAp.getItems().clear();
            BussPlanEntryPresetFieldsEnum mainBudgetInfoEnum = BussPlanEntryPresetFieldsEnum.MAINBUDGETINFO;
            List<ComboItem> mainBudgetInfoItems = this.getMainbudgetinfoList();
            EntryFieldAp mainBudgetInfoFieldAp = CustomControlHelper.createEntryMainBudgetInfoOrBusinessPlanSheetFieldAp((String)this.getBusinessPlanEntryColKey(mainBudgetInfoEnum.getKey()), (String)mainBudgetInfoEnum.getName(), (FieldTypeEnum)mainBudgetInfoEnum.getFieldTypeEnum(), mainBudgetInfoItems);
            BussPlanEntryPresetFieldsEnum businessPlanSheetEnum = BussPlanEntryPresetFieldsEnum.BUSINESSPLANSHEET;
            List<ComboItem> businessPlanSheetItems = this.getbusinessPlanSheetList();
            EntryFieldAp businessPlanSheetFieldAp = CustomControlHelper.createEntryMainBudgetInfoOrBusinessPlanSheetFieldAp((String)this.getBusinessPlanEntryColKey(businessPlanSheetEnum.getKey()), (String)businessPlanSheetEnum.getName(), (FieldTypeEnum)businessPlanSheetEnum.getFieldTypeEnum(), businessPlanSheetItems);
            entryAp.getItems().add(mainBudgetInfoFieldAp);
            entryAp.getItems().add(businessPlanSheetFieldAp);
            for (BussPlanEntryPresetFieldsEnum value : values = BussPlanEntryPresetFieldsEnum.values()) {
                if (value == BussPlanEntryPresetFieldsEnum.MAINBUDGETINFO || value == BussPlanEntryPresetFieldsEnum.BUSINESSPLANSHEET) continue;
                EntryFieldAp entryFieldAp = CustomControlHelper.createEntryFieldAp((String)this.getBusinessPlanEntryColKey(value.getKey()), (String)value.getName(), (FieldTypeEnum)value.getFieldTypeEnum());
                Field field = entryFieldAp.getField();
                if (field instanceof CheckBoxField) {
                    CheckBoxField checkBoxField = (CheckBoxField)field;
                    checkBoxField.setShowStyle(0);
                    checkBoxField.setDefValue(StatusEnum.ENABLE.getValue());
                } else if (field instanceof BasedataField) {
                    entryFieldAp.setLock("new,view");
                    BasedataField baseDataField = (BasedataField)entryFieldAp.getField();
                    baseDataField.setBaseEntityId("bos_user");
                }
                entryAp.getItems().add(entryFieldAp);
            }
            return entryAp;
        }
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((Object[])dimIds.toArray(), (String)"epm_dimension");
        BussPlanEntryPresetFieldsEnum mainBudgetInfoEnum = BussPlanEntryPresetFieldsEnum.MAINBUDGETINFO;
        List<ComboItem> mainBudgetInfoItems = this.getMainbudgetinfoList();
        EntryFieldAp mainBudgetInfoFieldAp = CustomControlHelper.createEntryMainBudgetInfoOrBusinessPlanSheetFieldAp((String)this.getBusinessPlanEntryColKey(mainBudgetInfoEnum.getKey()), (String)mainBudgetInfoEnum.getName(), (FieldTypeEnum)mainBudgetInfoEnum.getFieldTypeEnum(), mainBudgetInfoItems);
        BussPlanEntryPresetFieldsEnum businessPlanSheetEnum = BussPlanEntryPresetFieldsEnum.BUSINESSPLANSHEET;
        List<ComboItem> businessPlanSheetItems = this.getbusinessPlanSheetList();
        EntryFieldAp businessPlanSheetFieldAp = CustomControlHelper.createEntryMainBudgetInfoOrBusinessPlanSheetFieldAp((String)this.getBusinessPlanEntryColKey(businessPlanSheetEnum.getKey()), (String)businessPlanSheetEnum.getName(), (FieldTypeEnum)businessPlanSheetEnum.getFieldTypeEnum(), businessPlanSheetItems);
        entryAp.getItems().add(mainBudgetInfoFieldAp);
        entryAp.getItems().add(businessPlanSheetFieldAp);
        for (Long dimId : dimIds) {
            DynamicObject dimObj = (DynamicObject)dynamicObjectMap.get(dimId);
            String name = dimObj.getString("name");
            String number = dimObj.getString("number");
            BaseColumn dimensionColumn = this.getHasDimensionColumn(dimId);
            if (dimensionColumn == null) continue;
            String nameFieldName = ResManager.loadResFormat((String)"%1\u540d\u79f0", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[]{name});
            String numberFieldName = ResManager.loadResFormat((String)"%1\u7f16\u7801", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[]{name});
            String rangeFieldName = ResManager.loadResFormat((String)"%1\u8303\u56f4", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[]{name});
            EntryFieldAp entryFieldApCode = CustomControlHelper.createEntryFieldAp((String)this.getBusinessPlanEntryColKey(number + "_name"), (String)nameFieldName, (FieldTypeEnum)FieldTypeEnum.MulBaseDataField);
            MulBasedataField baseDataField = (MulBasedataField)entryFieldApCode.getField();
            baseDataField.setBaseEntityId(dimensionColumn.getBaseEntityId());
            entryAp.getItems().add(entryFieldApCode);
        }
        if (CollectionUtils.isNotEmpty(dimIds)) {
            BussPlanEntryPresetFieldsEnum[] values;
            for (BussPlanEntryPresetFieldsEnum value : values = BussPlanEntryPresetFieldsEnum.values()) {
                if (value == BussPlanEntryPresetFieldsEnum.MAINBUDGETINFO || value == BussPlanEntryPresetFieldsEnum.BUSINESSPLANSHEET) continue;
                EntryFieldAp entryFieldAp = CustomControlHelper.createEntryFieldAp((String)this.getBusinessPlanEntryColKey(value.getKey()), (String)value.getName(), (FieldTypeEnum)value.getFieldTypeEnum());
                Field field = entryFieldAp.getField();
                if (field instanceof CheckBoxField) {
                    CheckBoxField checkBoxField = (CheckBoxField)field;
                    checkBoxField.setShowStyle(0);
                    checkBoxField.setDefValue(StatusEnum.ENABLE.getValue());
                } else if (field instanceof BasedataField) {
                    entryFieldAp.setLock("new,view");
                    BasedataField baseDataField = (BasedataField)entryFieldAp.getField();
                    baseDataField.setBaseEntityId("bos_user");
                }
                entryAp.getItems().add(entryFieldAp);
            }
        }
        return entryAp;
    }

    protected List<BaseColumn> getReferencedColumnsInMain() {
        ColumnList columnList = this.getColumnListFromParam();
        Collection columns = columnList.getColumns();
        Set hcolumnkeySet = columns.stream().filter(column -> column instanceof MeasureColumn || column instanceof NumberColumn || column instanceof RelationValueColumn || column instanceof CalculateColumn || column instanceof DimensionDataColumn).map(column -> {
            if (column instanceof MeasureColumn) {
                return ((MeasureColumn)column).getHcolumnkey();
            }
            if (column instanceof RelationValueColumn) {
                return ((RelationValueColumn)column).getHcolumnkey();
            }
            if (column instanceof CalculateColumn) {
                return ((CalculateColumn)column).getHcolumnkey();
            }
            if (column instanceof DimensionDataColumn) {
                return ((DimensionDataColumn)column).getHcolumnkey();
            }
            return ((NumberColumn)column).getHcolumnkey();
        }).filter(hcolumnkey -> hcolumnkey != null).collect(Collectors.toSet());
        List<BaseColumn> collectList = columns.stream().filter(e -> hcolumnkeySet.contains(e.getKey())).collect(Collectors.toList());
        return collectList;
    }

    private List<ComboItem> getMainbudgetinfoList() {
        List<BaseColumn> collectList = this.getReferencedColumnsInMain();
        Map<String, String> hcolumnkeyMap = collectList.stream().collect(Collectors.toMap(BaseColumn::getKey, e -> e.isIsdoubletitle() ? e.getGrouptitle() + "-" + e.getTitle() : e.getTitle()));
        ArrayList<ComboItem> mainBudgetInfoItems = new ArrayList<ComboItem>(hcolumnkeyMap.size());
        for (Map.Entry<String, String> entry : hcolumnkeyMap.entrySet()) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(entry.getValue()));
            comboItem.setValue(entry.getKey());
            mainBudgetInfoItems.add(comboItem);
        }
        return mainBudgetInfoItems;
    }

    private List<ComboItem> getbusinessPlanSheetList() {
        ColumnList columnList = this.getColumnListFromParam();
        List bizTableConfigList = columnList.getBizTableConfigList();
        ArrayList<ComboItem> businessPlanSheetItems = new ArrayList<ComboItem>(10);
        for (BizTableConfig bizTableConfig : bizTableConfigList) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(bizTableConfig.getTabName()));
            comboItem.setValue(bizTableConfig.getTabKey());
            businessPlanSheetItems.add(comboItem);
        }
        return businessPlanSheetItems;
    }

    private void sendCreateGridColumns(EntryAp entryAp) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.preInvokeControlMethod("entryentity_businessplan", "createGridColumns", new Object[]{entryAp.createControl()});
    }

    private BaseColumn getHasDimensionColumn(Long dimId) {
        List<BaseColumn> baseColumns = this.getBaseColumns(this.getColumnListFromParam());
        for (BaseColumn baseColumn : baseColumns) {
            RowDimensionColumn rowDimensionColumn;
            RelationDimensionColumn relationDimensionColumn;
            if (baseColumn instanceof DimensionColumn) {
                DimensionColumn dimensionColumn = (DimensionColumn)baseColumn;
                if (dimensionColumn.getDimensionId() != dimId.longValue()) continue;
                return dimensionColumn;
            }
            if (!(baseColumn instanceof RelationDimensionColumn ? (relationDimensionColumn = (RelationDimensionColumn)baseColumn).getDimensionId() == dimId.longValue() : baseColumn instanceof RowDimensionColumn && (rowDimensionColumn = (RowDimensionColumn)baseColumn).getDimensionId() == dimId.longValue())) continue;
            return baseColumn;
        }
        return null;
    }

    private void columnListSort(ColumnList columnList) {
        List columns = (List)columnList.getColumns();
        columns.sort((o1, o2) -> Integer.compare(o1.getSort(), o2.getSort()));
    }

    protected Map<String, Object> getParams() {
        IFormView view = this.getView();
        if (view == null) {
            return new HashMap<String, Object>(16);
        }
        return this.getView().getFormShowParameter().getCustomParams();
    }

    protected Long getTemplateId() {
        Map<String, Object> params = this.getParams();
        Object templateId = params.get("templateId");
        return IDUtils.toLong((Object)templateId);
    }

    protected ColumnList getColumnListFromParam() {
        FormShowParameter formShowParameter;
        String columnListStr;
        IFormView view = this.getView();
        if (view == null) {
            return null;
        }
        if (this.columnList == null && StringUtils.isNotEmpty((String)(columnListStr = (String)(formShowParameter = view.getFormShowParameter()).getCustomParam("cache_column_list_key")))) {
            ColumnList columnList = (ColumnList)SerializationUtils.fromJsonString((String)columnListStr, ColumnList.class);
            this.columnListSort(columnList);
            this.columnList = columnList;
        }
        return this.columnList;
    }

    private void setColumnListToParam(FormShowParameter formShowParameter, ColumnList columnList) {
        if (columnList == null) {
            return;
        }
        formShowParameter.setCustomParam("cache_column_list_key", (Object)SerializationUtils.toJsonString((Object)columnList));
    }

    protected List<Map<String, String>> getRowDimsFromParam(FormShowParameter formShowParameter) {
        Object rowDimsObj;
        if (formShowParameter != null && (rowDimsObj = formShowParameter.getCustomParam("rowDims")) != null) {
            return (List)rowDimsObj;
        }
        IFormView view = this.getView();
        if (view == null) {
            return new ArrayList<Map<String, String>>(0);
        }
        FormShowParameter viewFormShowParameter = view.getFormShowParameter();
        Object rowDimsStr = viewFormShowParameter.getCustomParam("rowDims");
        if (rowDimsStr != null) {
            return (List)rowDimsStr;
        }
        return new ArrayList<Map<String, String>>(0);
    }

    protected DynamicObject getTemplateObj() {
        Long templateId = this.getTemplateId();
        return BusinessDataServiceHelper.loadSingleFromCache((Object)templateId, (String)"eb_applytemplate");
    }

    protected String getTemplateNumber() {
        DynamicObject templateObj = this.getTemplateObj();
        return templateObj.getString("number");
    }

    protected Map<String, List<Long>> getCacheSelectedPanelDimIds() {
        String cacheSelectedPanelDimIdsStr = this.getPageCache().get("cache_dim_cfg_key");
        if (StringUtils.isEmpty((String)cacheSelectedPanelDimIdsStr)) {
            return new HashMap<String, List<Long>>(0);
        }
        return (Map)SerializationUtils.fromJsonString((String)cacheSelectedPanelDimIdsStr, Map.class);
    }

    protected String getBusinessPlanEntryColKey(String key) {
        return "entryentity_businessplan_" + key;
    }
}

