/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applytemplate.config;

import java.io.IOException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.MulComboField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.business.applybill.util.ApplyTemplateUtils;
import kd.epm.eb.business.applybill.util.BgApplyBillUtils;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateColCfgService;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateDimCfgService;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateDimRangeService;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateTableCfgService;
import kd.epm.eb.common.applyTemplate.constants.AuditTrailUseEnum;
import kd.epm.eb.common.applyTemplate.constants.BussPlanEntryPresetFieldsEnum;
import kd.epm.eb.common.applyTemplate.constants.ColCfgPresetFieldsEnum;
import kd.epm.eb.common.applyTemplate.constants.ColCfgPropEnum;
import kd.epm.eb.common.applyTemplate.constants.ColCfgPropTypeEnum;
import kd.epm.eb.common.applyTemplate.constants.DimUseTypeEnum;
import kd.epm.eb.common.applyTemplate.constants.FormTypeEnum;
import kd.epm.eb.common.applyTemplate.constants.StatusEnum;
import kd.epm.eb.common.applyTemplate.entity.ApplyTemplateAtCfgEntity;
import kd.epm.eb.common.applyTemplate.entity.ApplyTemplateColCfgEntity;
import kd.epm.eb.common.applyTemplate.entity.ApplyTemplateDataInitCfgEntity;
import kd.epm.eb.common.applyTemplate.entity.ApplyTemplateDimCfgEntity;
import kd.epm.eb.common.applyTemplate.entity.ApplyTemplateTableCfgEntity;
import kd.epm.eb.common.applyTemplate.entity.dto.DimRangeImportTemplate;
import kd.epm.eb.common.applyTemplate.entity.dto.TableColumn;
import kd.epm.eb.common.applyTemplate.entity.tableconfig.BizTableConfig;
import kd.epm.eb.common.applyTemplate.helper.ExcelHelper;
import kd.epm.eb.common.applyTemplate.helper.TableHelper;
import kd.epm.eb.common.applybill.SchemeAssignDimGroup;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.CalculateColumn;
import kd.epm.eb.common.applytemplatecolumn.ColumnList;
import kd.epm.eb.common.applytemplatecolumn.DataMapDimension;
import kd.epm.eb.common.applytemplatecolumn.DateColumn;
import kd.epm.eb.common.applytemplatecolumn.DimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.DimensionDataColumn;
import kd.epm.eb.common.applytemplatecolumn.EnumColumn;
import kd.epm.eb.common.applytemplatecolumn.MeasureColumn;
import kd.epm.eb.common.applytemplatecolumn.NumberColumn;
import kd.epm.eb.common.applytemplatecolumn.RelationDimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.RelationValueColumn;
import kd.epm.eb.common.applytemplatecolumn.RowDimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.TextColumn;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.entity.memberF7.BaseF7Parameter;
import kd.epm.eb.common.entity.memberF7.LeftTreeF7Parameter;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.utils.DateTimeUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.applytemplate.config.ApplyTemplateCfgBasePlugin;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ApplyTemplateCfgPlugin
extends ApplyTemplateCfgBasePlugin
implements BeforeF7SelectListener,
TabSelectListener,
CellClickListener,
RowClickEventListener {
    private static final Log log = LogFactory.getLog(ApplyTemplateCfgPlugin.class);
    private static final String MULINITDATACOLUMN = "mulinitdatacolumn";
    private IModelCacheHelper modelCacheHelper;

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setVisible();
        this.initPageData();
        this.setEnable();
    }

    private void setEnable() {
        this.setColCfgDisEnable();
        this.setColAggDisable();
        this.setModelDataColDisable();
        this.setDimensionDataColumnDisable();
    }

    private void setDimensionDataColumnDisable() {
        List dimensionDataColKeys = this.getColumnListFromParam().getColumns().stream().filter(col -> col instanceof DimensionDataColumn && col.getIspullfrommodel() && col.getKey().startsWith("h")).map(BaseColumn::getKey).collect(Collectors.toList());
        List numberColKeys = this.getColumnListFromParam().getColumns().stream().filter(col -> col instanceof NumberColumn && ((NumberColumn)col).isIsFormula() || col instanceof DimensionDataColumn && StringUtils.isNotEmpty((String)((DimensionDataColumn)col).getFormula())).map(BaseColumn::getKey).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(numberColKeys)) {
            dimensionDataColKeys.addAll(numberColKeys);
        }
        if (dimensionDataColKeys.size() > 0) {
            for (String colKey : dimensionDataColKeys) {
                for (int i = 0; i < ColCfgPropEnum.values().length; ++i) {
                    if (i != ColCfgPropEnum.WRITE.getRowIndex() - 1) continue;
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{colKey});
                }
            }
        }
    }

    private void setModelDataColDisable() {
        List modelDataColKeys = this.getColumnListFromParam().getColumns().stream().filter(col -> col instanceof MeasureColumn && col.getIspullfrommodel() && col.getKey().startsWith("h")).map(BaseColumn::getKey).collect(Collectors.toList());
        if (modelDataColKeys.size() > 0) {
            for (String colKey : modelDataColKeys) {
                boolean hasVal = false;
                for (int i = 0; i < ColCfgPropEnum.values().length; ++i) {
                    if (i == ColCfgPropEnum.WRITE.getRowIndex() - 1) {
                        this.getView().setEnable(Boolean.valueOf(false), i, new String[]{colKey});
                        this.getModel().setValue(colKey, (Object)false, i);
                        continue;
                    }
                    if (i == ColCfgPropEnum.AGGREGATE.getRowIndex() - 1 || i == ColCfgPropEnum.SUMMARYDISPLAY.getRowIndex() - 1 || !((Boolean)this.getModel().getValue(colKey, i)).booleanValue()) continue;
                    hasVal = true;
                }
                if (hasVal) continue;
                this.getModel().setValue(colKey, (Object)true, ColCfgPropEnum.READONLY.getRowIndex() - 1);
            }
        }
    }

    private void setColAggDisable() {
        List<String> disableAggKeys = this.getDisableAggKeys();
        int index = ColCfgPropEnum.AGGREGATE.getRowIndex() - 1;
        this.getView().setEnable(Boolean.valueOf(false), index, disableAggKeys.toArray(new String[0]));
        this.getView().setEnable(Boolean.valueOf(false), ColCfgPropEnum.SUMMARYDISPLAY.getRowIndex() - 1, disableAggKeys.toArray(new String[0]));
        for (String disableAggKey : disableAggKeys) {
            this.getModel().setValue(disableAggKey, (Object)false, index);
        }
    }

    private void setVisible() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"audittrailpanel"});
    }

    private void setColCfgDisEnable() {
        List<String> disableColKeys = this.getDisableColKeys();
        for (int i = 0; i < ColCfgPropEnum.values().length; ++i) {
            for (String rowDimCol : disableColKeys) {
                FormTypeEnum currentTabType = this.getCurrentTabType();
                if (FormTypeEnum.APPLY == currentTabType) {
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{rowDimCol});
                    continue;
                }
                this.getView().setEnable(Boolean.valueOf(true), i, new String[]{rowDimCol});
            }
        }
        ArrayList<String> hideRowCols = new ArrayList<String>(16);
        ColumnList columnListFromParam = this.getColumnListFromParam();
        List<BaseColumn> baseColumns = this.getBaseColumns(columnListFromParam);
        for (BaseColumn baseColumn : baseColumns) {
            if (!(baseColumn instanceof RowDimensionColumn) || !((RowDimensionColumn)baseColumn).getHide().booleanValue()) continue;
            String key = baseColumn.getKey();
            hideRowCols.add(key);
        }
        for (int i = 0; i < ColCfgPropEnum.values().length; ++i) {
            for (String rowDimCol : hideRowCols) {
                FormTypeEnum currentTabType = this.getCurrentTabType();
                if (FormTypeEnum.APPLY == currentTabType) {
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{rowDimCol});
                    continue;
                }
                this.getView().setEnable(Boolean.valueOf(true), i, new String[]{rowDimCol});
            }
        }
    }

    private List<String> getDisableAggKeys() {
        ArrayList<String> rowCols = new ArrayList<String>(16);
        ColumnList columnListFromParam = this.getColumnListFromParam();
        List<BaseColumn> baseColumns = this.getBaseColumns(columnListFromParam);
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        for (BaseColumn baseColumn : baseColumns) {
            if (baseColumn instanceof DimensionColumn || baseColumn instanceof RelationDimensionColumn || baseColumn instanceof TextColumn || baseColumn instanceof DateColumn || baseColumn instanceof EnumColumn) {
                String key = baseColumn.getKey();
                rowCols.add(key);
            }
            if (!(baseColumn instanceof DimensionDataColumn) && !(baseColumn instanceof MeasureColumn)) continue;
            List dataMapDimensions = baseColumn instanceof DimensionDataColumn ? ((DimensionDataColumn)baseColumn).getDataMapDimensions() : ((MeasureColumn)baseColumn).getDataMapDimensions();
            for (DataMapDimension dataMapDimension : dataMapDimensions) {
                Long dimensionRememberId;
                Member metric;
                if (!"Metric".equals(dataMapDimension.getDimNum()) || (metric = modelCacheHelper.getMember("Metric", null, dimensionRememberId = Long.valueOf(dataMapDimension.getDimensionRememberId()))) == null) continue;
                String datatype = metric.getDatatype();
                boolean hasAgg = metric.hasAgg();
                if (hasAgg && (MetricDataTypeEnum.CURRENCY.getIndex().equals(datatype) || MetricDataTypeEnum.NONMONETARY.getIndex().equals(datatype) || MetricDataTypeEnum.RATE.getIndex().equals(datatype))) continue;
                String key = baseColumn.getKey();
                rowCols.add(key);
            }
        }
        return rowCols;
    }

    private List<String> getDisableColKeys() {
        ArrayList<String> rowCols = new ArrayList<String>(16);
        ColumnList columnListFromParam = this.getColumnListFromParam();
        List<BaseColumn> baseColumns = this.getBaseColumns(columnListFromParam);
        for (BaseColumn baseColumn : baseColumns) {
            String key;
            if (baseColumn instanceof DimensionColumn) {
                key = baseColumn.getKey();
                rowCols.add(key);
                continue;
            }
            if (!(baseColumn instanceof RowDimensionColumn) || ((RowDimensionColumn)baseColumn).getHide().booleanValue()) continue;
            key = baseColumn.getKey();
            rowCols.add(key);
        }
        return rowCols;
    }

    private Set<String> getHasAuditDimColKeys() {
        HashSet<String> result = new HashSet<String>(16);
        List<BaseColumn> baseColumns = this.getBaseColumns(this.getColumnListFromParam());
        for (BaseColumn baseColumn : baseColumns) {
            if (!(baseColumn instanceof CalculateColumn) && !(baseColumn instanceof MeasureColumn) && !(baseColumn instanceof DimensionDataColumn)) continue;
            result.add(baseColumn.getKey());
        }
        return result;
    }

    private List<String> getRowDimCols() {
        ArrayList<String> rowCols = new ArrayList<String>(16);
        ColumnList columnListFromParam = this.getColumnListFromParam();
        List<BaseColumn> baseColumns = this.getBaseColumns(columnListFromParam);
        for (BaseColumn baseColumn : baseColumns) {
            if (!(baseColumn instanceof DimensionColumn) && !(baseColumn instanceof RelationDimensionColumn) && !(baseColumn instanceof RowDimensionColumn)) continue;
            String key = baseColumn.getKey();
            rowCols.add(key);
        }
        return rowCols;
    }

    private void initPageData() {
        this.initCacheInfo();
        this.initTemplateInfo();
    }

    private Map<String, String> getHidePanelAuditTrail() {
        List<Map<String, String>> hideDimList = this.getHideDimList();
        for (Map<String, String> map : hideDimList) {
            String dimensionNumber = map.get("dimensionNumber");
            if (!StringUtils.equals((String)dimensionNumber, (String)SysDimensionEnum.AuditTrail.getNumber())) continue;
            return map;
        }
        return null;
    }

    private Map<String, String> getRowPanelAuditTrail() {
        List<Map<String, String>> rowDimList = this.getRowDimList();
        for (Map<String, String> map : rowDimList) {
            String dimensionNumber = map.get("dimensionNumber");
            if (!StringUtils.equals((String)dimensionNumber, (String)SysDimensionEnum.AuditTrail.getNumber())) continue;
            return map;
        }
        return null;
    }

    private boolean auditTrailIsInRowPanel() {
        Map<String, String> map = this.getRowPanelAuditTrail();
        return map != null && map.size() > 0;
    }

    private void setAuditTrailValue(Long leafMemberId, Long nonLeafMemberId, Long splitProportionMemberId) {
        this.getModel().setValue("leaf_audittrail", (Object)leafMemberId);
        this.getModel().setValue("non_leaf_audittrail", (Object)nonLeafMemberId);
        this.getModel().setValue("split_audittrail", (Object)splitProportionMemberId);
    }

    private void setCurrentColAuditTrailValue(Long auditTrailMemId, String memberName) {
        this.getModel().setValue("audittrailid", (Object)auditTrailMemId);
        Control control = this.getControl("label_audittrail_value");
        if (control != null) {
            ((Label)control).setText(memberName);
        }
    }

    private List<Map<String, String>> getHideDimList() {
        List<Map<String, String>> result = new ArrayList<Map<String, String>>(16);
        Object hideDims = this.getView().getFormShowParameter().getCustomParam("hideDims");
        if (hideDims == null) {
            return result;
        }
        if (hideDims instanceof List) {
            result = (List)hideDims;
        }
        return result;
    }

    private List<Map<String, String>> getRowDimList() {
        List<Map<String, String>> result = new ArrayList<Map<String, String>>(16);
        Object rowDims = this.getView().getFormShowParameter().getCustomParam("rowDims");
        if (rowDims == null) {
            return result;
        }
        if (rowDims instanceof List) {
            result = (List)rowDims;
        }
        return result;
    }

    private void initCacheInfo() {
        this.initCacheColCfgMap();
        this.initCacheDimCfgMap();
        this.initCacheTableCfgMap();
        this.initCacheDataInitCfg();
    }

    private void initCacheTableCfgMap() {
        ApplyTemplateTableCfgEntity tableCfgEntity = ApplyTemplateTableCfgService.getInstance().getTableCfgByTemplateId(this.getTemplateId());
        String tableName = tableCfgEntity.getTablename();
        boolean hasDimRangeRecords = ApplyTemplateDimRangeService.getInstance().isHasDimRangeRecords(tableName);
        if (hasDimRangeRecords) {
            this.cacheCurrentDimTableName(tableName);
        } else {
            this.cacheCurrentDimTableName("");
        }
    }

    private void initCacheDataInitCfg() {
        ApplyTemplateDataInitCfgEntity cfgEntity;
        List<BaseColumn> baseColumns = this.getBaseColumns(this.getColumnListFromParam());
        Map<String, String> maps = baseColumns.stream().filter(s -> s instanceof DimensionDataColumn).collect(Collectors.toMap(BaseColumn::getKey, x -> {
            String groupTitle = x.getGrouptitle();
            if (StringUtils.isNotEmpty((String)groupTitle)) {
                return groupTitle + "-" + x.getTitle();
            }
            return x.getTitle();
        }));
        MulComboEdit mulComboEdit = (MulComboEdit)this.getControl(MULINITDATACOLUMN);
        if (!maps.isEmpty()) {
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(maps.size());
            for (Map.Entry<String, String> entry : maps.entrySet()) {
                ComboItem item = new ComboItem(new LocaleString(entry.getValue()), entry.getKey());
                items.add(item);
            }
            mulComboEdit.setComboItems(items);
        }
        if ((cfgEntity = ApplyTemplateDimCfgService.getInstance().getApplyTemplateDataInitCfgEntity(this.getTemplateId().longValue())) != null) {
            Set dimIds = cfgEntity.getDimIds();
            for (Long dimid : dimIds) {
                this.cacheSelectedDataInitPanelDimId(dimid);
                this.getModel().setValue(this.getPanelDimIdPrefix("flexpanel_init_dim") + dimid, (Object)true);
                this.getView().updateView(this.getPanelDimIdPrefix("flexpanel_init_dim") + dimid);
            }
            Set set = cfgEntity.getColumnKeys();
            if (!set.isEmpty()) {
                this.getModel().setValue(MULINITDATACOLUMN, (Object)String.join((CharSequence)",", set));
            }
        }
    }

    private void initCacheColCfgMap() {
        HashMap<String, Object> colCfgMap = new HashMap<String, Object>(16);
        List<ApplyTemplateColCfgEntity> colCfgEntities = this.getColCfg(null);
        for (FormTypeEnum formTypeEnum : FormTypeEnum.values()) {
            for (ApplyTemplateColCfgEntity entity : colCfgEntities) {
                List atCfgEntities = entity.getAtCfgEntities();
                for (ApplyTemplateAtCfgEntity atCfgEntity : atCfgEntities) {
                    if (!StringUtils.equals((String)atCfgEntity.getAuditTrailUse(), (String)AuditTrailUseEnum.SPLIT_PROPORTION.getCode())) continue;
                    this.getPageCache().put("currentTab" + formTypeEnum.getCode(), atCfgEntity.getAuditTrailMemId() + "");
                }
            }
        }
        if (CollectionUtils.isNotEmpty(colCfgEntities)) {
            for (ApplyTemplateColCfgEntity colCfgEntity : colCfgEntities) {
                if (!this.isTemplateCol(colCfgEntity.getColkey())) continue;
                List temp = (List)colCfgMap.computeIfAbsent(colCfgEntity.getFormtype(), t -> new ArrayList(16));
                temp.add(colCfgEntity);
            }
            this.getPageCache().put("cache_col_cfg_key", SerializationUtils.toJsonString(colCfgMap));
            this.refreshColCfgEntry(FormTypeEnum.APPLY);
        } else {
            this.createInitColCfgCache(colCfgMap);
        }
    }

    private List<ApplyTemplateColCfgEntity> getColCfg(FormTypeEnum formTypeEnum) {
        List colCfgEntities = new ArrayList(16);
        Map<String, Object> cfgMap = this.queryTemplateCfg();
        Object colCfg = cfgMap.get("colCfg");
        if (colCfg != null) {
            colCfgEntities = (List)colCfg;
        }
        if (formTypeEnum == null) {
            return colCfgEntities;
        }
        HashMap<String, List> map = new HashMap<String, List>(16);
        for (ApplyTemplateColCfgEntity colCfgEntity : colCfgEntities) {
            String formtype = colCfgEntity.getFormtype();
            map.computeIfAbsent(formtype, t -> new ArrayList(16)).add(colCfgEntity);
        }
        colCfgEntities = (List)map.get(formTypeEnum.getCode());
        if (colCfgEntities == null) {
            return new ArrayList<ApplyTemplateColCfgEntity>(16);
        }
        return colCfgEntities;
    }

    private boolean isTemplateCol(String colKey) {
        List<BaseColumn> baseColumns = this.getBaseColumns(this.getColumnListFromParam());
        for (BaseColumn baseColumn : baseColumns) {
            if (!StringUtils.equals((String)baseColumn.getKey(), (String)colKey)) continue;
            return true;
        }
        return false;
    }

    private void createInitColCfgCache(Map<String, Object> colCfgMap) {
        List<String> rowDimCols = this.getRowDimCols();
        for (FormTypeEnum value : FormTypeEnum.values()) {
            ColumnList columnListFromParam = this.getColumnListFromParam();
            List<BaseColumn> baseColumns = this.getBaseColumns(columnListFromParam);
            ArrayList<ApplyTemplateColCfgEntity> applyTemplateColCfgEntities = new ArrayList<ApplyTemplateColCfgEntity>(16);
            for (BaseColumn baseColumn : baseColumns) {
                ApplyTemplateColCfgEntity applyTemplateColCfgEntity = new ApplyTemplateColCfgEntity();
                applyTemplateColCfgEntity.setApplytemplateid(this.getTemplateId());
                applyTemplateColCfgEntity.setApplytemplatenumber(this.getTemplateNumber());
                applyTemplateColCfgEntity.setColkey(baseColumn.getKey());
                applyTemplateColCfgEntity.setAudittrailmemid(Long.valueOf(0L));
                applyTemplateColCfgEntity.setAudittrailmemnum("");
                if (rowDimCols.contains(baseColumn.getKey())) {
                    applyTemplateColCfgEntity.setEdittype(ColCfgPropEnum.WRITE.getValue());
                } else {
                    applyTemplateColCfgEntity.setEdittype(ColCfgPropEnum.READONLY.getValue());
                }
                applyTemplateColCfgEntity.setFormtype(value.getCode());
                applyTemplateColCfgEntity.setCreator(this.getUserId());
                applyTemplateColCfgEntity.setCreatedate(new Date(TimeServiceHelper.now().getTime()));
                applyTemplateColCfgEntity.setModifier(this.getUserId());
                applyTemplateColCfgEntity.setModifydate(new Date(TimeServiceHelper.now().getTime()));
                applyTemplateColCfgEntities.add(applyTemplateColCfgEntity);
            }
            colCfgMap.put(value.getCode(), applyTemplateColCfgEntities);
        }
        this.getPageCache().put("cache_col_cfg_key", SerializationUtils.toJsonString(colCfgMap));
    }

    private void cacheColCfgMap(FormTypeEnum formTypeEnum, List<ApplyTemplateColCfgEntity> colCfgEntities) {
        if (CollectionUtils.isEmpty(colCfgEntities) || formTypeEnum == null) {
            return;
        }
        Map<String, List<ApplyTemplateColCfgEntity>> cacheColCfg = this.getCacheColCfg();
        cacheColCfg.put(formTypeEnum.getCode(), colCfgEntities);
        this.getPageCache().put("cache_col_cfg_key", SerializationUtils.toJsonString(cacheColCfg));
    }

    private List<ApplyTemplateColCfgEntity> getCacheColCfgByFormType(FormTypeEnum formTypeEnum) {
        if (formTypeEnum == null) {
            return new ArrayList<ApplyTemplateColCfgEntity>(0);
        }
        String colCfgMapStr = this.getPageCache().get("cache_col_cfg_key");
        if (StringUtils.isEmpty((String)colCfgMapStr)) {
            return new ArrayList<ApplyTemplateColCfgEntity>(0);
        }
        Map result = (Map)SerializationUtils.fromJsonString((String)colCfgMapStr, HashMap.class);
        List applyTemplateColCfgEntities = (List)result.get(formTypeEnum.getCode());
        if (CollectionUtils.isEmpty((Collection)applyTemplateColCfgEntities)) {
            return new ArrayList<ApplyTemplateColCfgEntity>(0);
        }
        return applyTemplateColCfgEntities.stream().map(entity -> (ApplyTemplateColCfgEntity)SerializationUtils.getObjectMapper2().convertValue(entity, ApplyTemplateColCfgEntity.class)).collect(Collectors.toList());
    }

    private Map<String, List<ApplyTemplateColCfgEntity>> getCacheColCfg() {
        HashMap<String, List<ApplyTemplateColCfgEntity>> result = new HashMap<String, List<ApplyTemplateColCfgEntity>>(16);
        String colCfgMapStr = this.getPageCache().get("cache_col_cfg_key");
        if (StringUtils.isEmpty((String)colCfgMapStr)) {
            return result;
        }
        Map cache = (Map)SerializationUtils.fromJsonString((String)colCfgMapStr, HashMap.class);
        for (Map.Entry entry : cache.entrySet()) {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            List collect = value.stream().map(entity -> (ApplyTemplateColCfgEntity)SerializationUtils.getObjectMapper2().convertValue(entity, ApplyTemplateColCfgEntity.class)).collect(Collectors.toList());
            result.put(key, collect);
        }
        return result;
    }

    private void initCacheDimCfgMap() {
        List dimCfgEntities;
        Map<String, Object> allCfgMap = this.queryTemplateCfg();
        Object dimCfg = allCfgMap.get("dimCfg");
        if (dimCfg != null && CollectionUtils.isNotEmpty((Collection)(dimCfgEntities = (List)dimCfg))) {
            for (ApplyTemplateDimCfgEntity dimCfgEntity : dimCfgEntities) {
                Long dimid = dimCfgEntity.getDimid();
                String usetype = dimCfgEntity.getUsetype();
                DimUseTypeEnum dimUseTypeEnum = DimUseTypeEnum.getUseTypByValue((String)usetype);
                if (dimUseTypeEnum == null) continue;
                this.cacheSelectedPanelDimId(dimid, dimUseTypeEnum);
                this.getModel().setValue(this.getPanelDimIdPrefix(dimUseTypeEnum.getPanelKey()) + dimid, (Object)true);
                this.getView().updateView(this.getPanelDimIdPrefix(dimUseTypeEnum.getPanelKey()) + dimid);
            }
            this.dynamicCreateEntryField();
        }
    }

    private void initBusinessPlanEntry() {
        int entryRowCount = this.getModel().getEntryRowCount("entryentity_businessplan");
        if (entryRowCount != 0) {
            return;
        }
        List dimRangeRecords = ApplyTemplateDimRangeService.getInstance().getDimRangeRecords(this.getTemplateId().longValue(), null);
        if (dimRangeRecords.size() == 0) {
            this.getView().updateView("entryentity_businessplan");
            return;
        }
        ColumnList columnList = this.getColumnListFromParam();
        List bizTableConfigList = columnList.getBizTableConfigList();
        Map<String, Integer> bizTableConfigSortMap = bizTableConfigList.stream().collect(Collectors.toMap(BizTableConfig::getTabKey, BizTableConfig::getSort));
        Comparator<Map> comparator = Comparator.comparing(map -> {
            String orDefault = map.getOrDefault(BussPlanEntryPresetFieldsEnum.BUSINESSPLANSHEET.getColKey(), "");
            String[] businessPlanSheetStrArray = StringUtils.split((String)orDefault, (String)",");
            ArrayList<Integer> sorts = new ArrayList<Integer>(16);
            for (String businessPlanSheet : businessPlanSheetStrArray) {
                Integer sort = (Integer)bizTableConfigSortMap.get(businessPlanSheet);
                sorts.add(sort);
            }
            int sum = sorts.stream().reduce(0, Integer::sum);
            sum = sum == 0 ? sum + 10000 : sum;
            return sorts.size() > 1 ? sum + 100 : sum;
        }, Comparator.nullsLast(Comparator.naturalOrder()));
        Collections.sort(dimRangeRecords, comparator);
        for (Map dimRangeRecord : dimRangeRecords) {
            this.getModel().beginInit();
            int newEntryRow = this.getModel().createNewEntryRow("entryentity_businessplan");
            this.getModel().endInit();
            dimRangeRecord.forEach((key, value) -> {
                if (key.startsWith("entryentity_businessplan")) {
                    if (key.endsWith("modifydate")) {
                        this.getModel().setValue(key, (Object)DateTimeUtils.formatFromStr((String)value.toString()), newEntryRow);
                    } else if (key.endsWith("_name")) {
                        String[] baseDataStringArray = StringUtils.split((String)value.toString(), (String)",");
                        Long[] idArray = new Long[baseDataStringArray.length];
                        for (int i = 0; i < baseDataStringArray.length; ++i) {
                            idArray[i] = Long.parseLong(baseDataStringArray[i]);
                        }
                        this.getModel().setValue(key, (Object)idArray, newEntryRow);
                    } else {
                        this.getModel().setValue(key, value, newEntryRow);
                    }
                }
            });
        }
        this.getView().updateView("entryentity_businessplan");
    }

    private void initTemplateInfo() {
        DynamicObject templateObj = this.getTemplateObj();
        if (templateObj != null) {
            String name = templateObj.getString("name");
            String number = templateObj.getString("number");
            DynamicObject model = templateObj.getDynamicObject("model");
            String modelName = model.getString("name");
            this.getModel().setValue("templatenumber", (Object)number);
            this.getModel().setValue("templatename", (Object)name);
            this.getModel().setValue("modelname", (Object)modelName);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        super.registerListener(e);
        Tab tabPage = (Tab)this.getControl("tab_billtype");
        tabPage.addTabSelectListener((TabSelectListener)this);
        Tab tabap = (Tab)this.getControl("tabap");
        tabap.addTabSelectListener((TabSelectListener)this);
        this.addF7SelectListener(this, new String[]{"leaf_audittrail", "non_leaf_audittrail", "split_audittrail"});
        EntryGrid colGrid = (EntryGrid)this.getControl("entryentity_apply");
        colGrid.addCellClickListener((CellClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity_businessplan");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        boolean b = this.templateIsExit();
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((String)itemKey, (String)"btn_exit")) {
            return;
        }
        if (!b) {
            evt.setCancel(true);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((FormOperate)args.getSource()).getOperateKey()) {
            case "btn_addrow": {
                this.handleAddRowClick(args);
                break;
            }
            case "btn_delrow": {
                this.handleDelRowClick(args);
                break;
            }
            case "btn_save": {
                this.handleSaveClick(args);
                break;
            }
            case "btn_enable": {
                this.handleEnableClick(args);
                break;
            }
            case "btn_disable": {
                this.handleDisableClick(args);
                break;
            }
            case "btn_import": {
                this.handleImportClick();
                break;
            }
            case "btn_export": {
                this.handleExportClick();
                break;
            }
        }
    }

    private void handleSaveClick(BeforeDoOperationEventArgs args) {
        try (TXHandle tx = TX.required();){
            try {
                this.saveColCfg();
                this.saveDimCfg();
                this.saveDataInitConfig();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ApplyTemplateCfgPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.getView().updateView("entryentity_businessplan");
            }
            catch (KDBizException exception) {
                log.error((Throwable)exception);
                tx.markRollback();
                this.getView().showTipNotification(exception.getMessage());
            }
            catch (Exception exception) {
                tx.markRollback();
                log.error((Throwable)exception);
                throw new KDBizException(ResManager.loadResFormat((String)"\u7533\u62a5\u6a21\u677f\u57fa\u7840\u914d\u7f6e\u4fdd\u5b58\u5f02\u5e38\uff1a%1\u3002", (String)"ApplyTemplateCfgPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{ThrowableHelper.toString((Exception)exception)}));
            }
        }
    }

    private void checkDimRangeMustIn(List<TableColumn> columnList) {
        int rowCount = this.getModel().getEntryRowCount("entryentity_businessplan");
        for (TableColumn column : columnList) {
            String key = column.getKey();
            String name = column.getName();
            if (!key.endsWith("_name") && !key.endsWith(BussPlanEntryPresetFieldsEnum.MAINBUDGETINFO.getKey())) continue;
            for (int i = 0; i < rowCount; ++i) {
                String valueStr;
                Object value = this.getModel().getValue(column.getColKey(), i);
                String string = valueStr = value == null ? "" : value.toString();
                if (!StringUtils.isEmpty((String)valueStr)) continue;
                String desc = ResManager.loadResFormat((String)"%1\u5217\u7b2c%2\u884c\u662f\u5fc5\u586b\u9879\u3002", (String)"ApplyTemplateCfgPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[]{name, i + 1});
                throw new KDBizException(desc);
            }
        }
    }

    private void cacheCurrentDimTableName(String tableName) {
        this.getPageCache().put("dimRangeTableName", tableName);
    }

    private void saveColCfg() {
        this.checkColCfg();
        Map<String, List<ApplyTemplateColCfgEntity>> cacheColCfg = this.getCacheColCfg();
        if (cacheColCfg.size() > 0) {
            ArrayList<ApplyTemplateColCfgEntity> saveData = new ArrayList<ApplyTemplateColCfgEntity>(16);
            for (List<ApplyTemplateColCfgEntity> value : cacheColCfg.values()) {
                saveData.addAll(value);
            }
            ApplyTemplateColCfgService.getInstance().saveColCfg(saveData, this.getTemplateId().longValue());
        }
    }

    private void checkColCfg() {
        this.handleCheckCols();
        this.checkColCfgMustIn();
    }

    private ApplyTemplateTableCfgEntity saveTableCfg() {
        ApplyTemplateTableCfgEntity dimTableCfgEntity = this.createDimTableCfgEntity();
        List<TableColumn> dimRangeTableCols = this.createDimRangeTableCols();
        dimTableCfgEntity.setColumnList(dimRangeTableCols);
        dimTableCfgEntity.setColumnjson(SerializationUtils.toJsonString(dimRangeTableCols));
        String dimRangeTableName = this.getPageCache().get("dimRangeTableName");
        TableHelper.dropTable((String)dimRangeTableName);
        String table = TableHelper.createTable(dimRangeTableCols);
        dimTableCfgEntity.setTablename(table);
        Long tableCfgId = ApplyTemplateTableCfgService.getInstance().saveTableCfg(dimTableCfgEntity, this.getTemplateId().longValue());
        dimTableCfgEntity.setId(tableCfgId);
        return dimTableCfgEntity;
    }

    private void saveDimCfg() {
        List<ApplyTemplateDimCfgEntity> dimCfgList = this.getDimCfgList();
        List statisticsDims = dimCfgList.stream().filter(t -> StringUtils.equals((String)t.getUsetype(), (String)DimUseTypeEnum.STATISTICS.getValue())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(statisticsDims)) {
            Map<String, List<ApplyTemplateColCfgEntity>> cacheColCfg = this.getCacheColCfg();
            boolean flag = true;
            for (Map.Entry<String, List<ApplyTemplateColCfgEntity>> entry : cacheColCfg.entrySet()) {
                List<ApplyTemplateColCfgEntity> value = entry.getValue();
                List collect = value.stream().filter(t -> StringUtils.isNotEmpty((String)t.getAggregate())).collect(Collectors.toList());
                if (!CollectionUtils.isNotEmpty(collect)) continue;
                flag = false;
                break;
            }
            if (flag) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u5206\u9879\u7edf\u8ba1\u7ef4\u5ea6\u65f6\u5fc5\u987b\u5b58\u5728\u805a\u5408\u5c5e\u6027\u5217\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ApplyTemplateCfgPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        ApplyTemplateDimCfgService.getInstance().createDimCfgEntityList(statisticsDims, Long.valueOf(0L));
        ApplyTemplateDimCfgService.getInstance().delete(this.getTemplateId().longValue(), DimUseTypeEnum.STATISTICS);
        ApplyTemplateDimCfgService.getInstance().save(statisticsDims);
        String tabBusinessPlan = this.getPageCache().get("tabBusinessPlan");
        List businessPlanDims = dimCfgList.stream().filter(t -> StringUtils.equals((String)t.getUsetype(), (String)DimUseTypeEnum.BUSINESS_PLAN.getValue())).collect(Collectors.toList());
        if (StringUtils.equals((String)"yes", (String)tabBusinessPlan)) {
            ApplyTemplateTableCfgEntity tableCfgEntity = this.saveTableCfg();
            ApplyTemplateDimCfgService.getInstance().createDimCfgEntityList(businessPlanDims, tableCfgEntity.getId());
            ApplyTemplateDimCfgService.getInstance().delete(this.getTemplateId().longValue(), DimUseTypeEnum.BUSINESS_PLAN);
            ApplyTemplateDimCfgService.getInstance().save(businessPlanDims);
            List columnList = tableCfgEntity.getColumnList();
            this.checkDimRangeMustIn(columnList);
            this.checkDuplicateRows(true);
            DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity_businessplan");
            ApplyTemplateDimRangeService.getInstance().saveDimRange(entity, tableCfgEntity);
            this.cacheCurrentDimTableName(tableCfgEntity.getTablename());
        }
    }

    private void saveDataInitConfig() {
        Set<Long> cacheSelectedDataInitPanelDimIds = this.getCacheSelectedDataInitPanelDimIds();
        ApplyTemplateDataInitCfgEntity cfgEntity = new ApplyTemplateDataInitCfgEntity();
        cfgEntity.setDimIds(cacheSelectedDataInitPanelDimIds);
        String value = (String)this.getModel().getValue(MULINITDATACOLUMN);
        if (StringUtils.isNotEmpty((String)value)) {
            String[] split = value.split(",");
            cfgEntity.setColumnKeys(Arrays.stream(split).filter(StringUtils::isNotEmpty).collect(Collectors.toSet()));
        } else {
            cfgEntity.setColumnKeys(new HashSet(0));
        }
        ApplyTemplateDimCfgService.getInstance().saveDataInitCfg(this.getTemplateId().longValue(), cfgEntity);
    }

    private void checkColCfgMustIn() {
        Map<String, List<ApplyTemplateColCfgEntity>> cacheColCfg = this.getCacheColCfg();
        for (Map.Entry<String, List<ApplyTemplateColCfgEntity>> mapEntry : cacheColCfg.entrySet()) {
            String key = mapEntry.getKey();
            String formTypeDesc = "";
            FormTypeEnum formType = null;
            for (FormTypeEnum formTypeEnum : FormTypeEnum.values()) {
                if (!StringUtils.equals((String)key, (String)formTypeEnum.getCode())) continue;
                formTypeDesc = formTypeEnum.getDesc();
                formType = formTypeEnum;
            }
            List<ApplyTemplateColCfgEntity> value = mapEntry.getValue();
            for (ApplyTemplateColCfgEntity entity : value) {
                String edittype = entity.getEdittype();
                String colkey = entity.getColkey();
                String colNameByKey = this.getColNameByKey(colkey);
                if (StringUtils.isEmpty((String)edittype)) {
                    String desc = ResManager.loadResFormat((String)"%1 %2\u5217 \u3010\u9690\u85cf\u3011\u3010\u53ea\u8bfb\u3011\u3010\u8bfb\u5199\u3011\u5fc5\u987b\u52fe\u9009\u4e00\u884c\u3002", (String)"ApplyTemplateCfgPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[]{formTypeDesc, colNameByKey});
                    throw new KDBizException(desc);
                }
                if (!StringUtils.equals((String)edittype, (String)ColCfgPropEnum.WRITE.getValue())) continue;
                if (this.auditTrailIsInRowPanel()) {
                    return;
                }
                Set<String> hasAuditDimColKeys = this.getHasAuditDimColKeys();
                if (!hasAuditDimColKeys.contains(colkey)) continue;
                List atCfgEntities = entity.getAtCfgEntities();
                if (formType == FormTypeEnum.APPLY) continue;
                int i = 0;
                for (ApplyTemplateAtCfgEntity atCfgEntity : atCfgEntities) {
                    String auditTrailUse = atCfgEntity.getAuditTrailUse();
                    if (AuditTrailUseEnum.SPLIT_PROPORTION.getCode().equals(auditTrailUse)) continue;
                    ++i;
                }
                if (i == 2) continue;
                throw new KDBizException(ResManager.loadResFormat((String)"%1 %2 \u8c03\u6574\u53d8\u52a8\u7ebf\u7d22\u6210\u5458\u4e3a\u5fc5\u586b\u9879\u3002", (String)"ApplyTemplateCfgPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{formTypeDesc, colNameByKey}));
            }
        }
    }

    private String getColNameByKey(String colKey) {
        List<BaseColumn> baseColumns = this.getBaseColumns(this.getColumnListFromParam());
        for (BaseColumn baseColumn : baseColumns) {
            if (!StringUtils.equals((String)baseColumn.getKey(), (String)colKey)) continue;
            return baseColumn.getTitle();
        }
        return "";
    }

    private List<TableColumn> createDimRangeTableCols() {
        ArrayList<TableColumn> result = new ArrayList<TableColumn>(16);
        EntryAp businessPlanEntryAp = this.createBusinessPlanEntryAp();
        List items = businessPlanEntryAp.getItems();
        for (ControlAp item : items) {
            EntryFieldAp entryFieldAp = (EntryFieldAp)item;
            String key = entryFieldAp.getKey();
            LocaleString name = entryFieldAp.getName();
            String fKey = this.getTableColumnKey(key);
            Field field = entryFieldAp.getField();
            if (key.endsWith("_code") || key.endsWith("_range")) continue;
            TableColumn tableColumn = new TableColumn();
            tableColumn.setColKey(key);
            tableColumn.setName(name.toString());
            tableColumn.setKey(fKey);
            if (field instanceof BasedataField) {
                tableColumn.setType("bigint default 0 ");
            } else if (field instanceof MulBasedataField) {
                tableColumn.setType("clob default ' '");
            } else if (field instanceof CheckBoxField) {
                tableColumn.setType("nvarchar(10) default '" + StatusEnum.DISABLE.getCode() + "'");
            } else if (field instanceof TextField) {
                tableColumn.setType("nvarchar(100) default ' '");
            } else if (field instanceof ComboField) {
                tableColumn.setType("nvarchar(100) default ' '");
            } else if (field instanceof MulComboField) {
                tableColumn.setType("nvarchar(2000) default ' '");
            }
            result.add(tableColumn);
        }
        return result;
    }

    private String getTableColumnKey(String key) {
        return key.replace("entryentity_businessplan_", "f");
    }

    private ApplyTemplateTableCfgEntity createDimTableCfgEntity() {
        ApplyTemplateTableCfgEntity result = new ApplyTemplateTableCfgEntity();
        result.setApplytemplateid(this.getTemplateId());
        result.setApplytemplatenumber(this.getTemplateNumber());
        return result;
    }

    private void handleExportClick() {
        List<ApplyTemplateDimCfgEntity> dimCfgList = this.getDimCfgList();
        List collect = dimCfgList.stream().filter(t -> StringUtils.equals((String)t.getUsetype(), (String)DimUseTypeEnum.BUSINESS_PLAN.getValue())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5173\u8054\u7684\u4e1a\u52a1\u8ba1\u5212\u7ef4\u5ea6\u3002", (String)"ApplyTemplateCfgPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity_businessplan");
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity_businessplan");
        int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
        if (selectedRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"ApplyTemplateCfgPlugin_other_01", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, List<BizTableConfig>> relationship = this.getRelationship();
        HashMap<String, String> hcolumnkeyMap = this.gethcolumnkeyMap();
        HashMap<String, String> businessPlanSheetMap = this.getBusinessPlanSheetMap();
        DimRangeImportTemplate importTemplate = ExcelHelper.createImportTemplateNew(dimCfgList, relationship, hcolumnkeyMap);
        XSSFWorkbook xssfWorkBook = ExcelHelper.createExportXssfWorkNew((DimRangeImportTemplate)importTemplate, hcolumnkeyMap);
        XSSFSheet sheetAt = xssfWorkBook.getSheetAt(0);
        List headerMapList = importTemplate.getHeaderMapList();
        int index = 0;
        int[] nArray = selectedRows;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer selectRow = nArray[i];
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(selectRow.intValue());
            SerializationUtils.toJsonString((Object)dynamicObject);
            XSSFRow xssfRow = ExcelHelper.createXssfRow((XSSFSheet)sheetAt, (int)(3 + index));
            String mainBudgetInfoKey = dynamicObject.getString(BussPlanEntryPresetFieldsEnum.MAINBUDGETINFO.getColKey());
            if (!StringUtils.isNotEmpty((String)mainBudgetInfoKey)) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u6570\u636e\u5b58\u5728\u5fc5\u586b\u9879\u672a\u586b\u5199\uff0c\u4e0d\u5141\u8bb8\u5bfc\u51fa\u3002", (String)"ApplyTemplateCfgPlugin_other_02", (String)"epm-eb-formplugin", (Object[])new Object[]{selectRow + 1}));
                return;
            }
            ExcelHelper.setCellValue((XSSFSheet)sheetAt, null, (Integer)xssfRow.getRowNum(), (Integer)0, (String)(hcolumnkeyMap.get(mainBudgetInfoKey) + "[" + mainBudgetInfoKey + "]"));
            String businessPlanSheet = dynamicObject.getString(BussPlanEntryPresetFieldsEnum.BUSINESSPLANSHEET.getColKey());
            if (StringUtils.isNotEmpty((String)businessPlanSheet)) {
                String[] businessPlanArray = businessPlanSheet.split(",");
                ArrayList<String> businessPlanNumberList = new ArrayList<String>(16);
                for (String tableKey : businessPlanArray) {
                    String businessPlanNumber = businessPlanSheetMap.get(tableKey);
                    businessPlanNumberList.add(businessPlanNumber);
                }
                ExcelHelper.setCellValue((XSSFSheet)sheetAt, null, (Integer)xssfRow.getRowNum(), (Integer)1, (String)String.join((CharSequence)",", businessPlanNumberList));
            }
            for (Map map : headerMapList) {
                String dimNumber = (String)map.get("number");
                String colIndexStr = (String)map.get("colIndex");
                int colIndex = Integer.parseInt(colIndexStr);
                if (StringUtils.isNotEmpty((String)dimNumber)) {
                    String numberColKey = "entryentity_businessplan_" + dimNumber.toLowerCase() + "_code";
                    String nameColKey = "entryentity_businessplan_" + dimNumber.toLowerCase() + "_name";
                    DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(nameColKey);
                    if (dynamicObjectCollection == null) {
                        this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u6570\u636e\u5b58\u5728\u5fc5\u586b\u9879\u672a\u586b\u5199\uff0c\u4e0d\u5141\u8bb8\u5bfc\u51fa\u3002", (String)"ApplyTemplateCfgPlugin_other_02", (String)"epm-eb-formplugin", (Object[])new Object[]{selectRow + 1}));
                        return;
                    }
                    ArrayList baseNumbers = new ArrayList(16);
                    ArrayList baseNames = new ArrayList(16);
                    dynamicObjectCollection.forEach(e -> {
                        baseNumbers.add(e.getString("fbasedataid.number"));
                        baseNames.add(e.getString("fbasedataid.name"));
                    });
                    ExcelHelper.setCellValue((XSSFSheet)sheetAt, null, (Integer)xssfRow.getRowNum(), (Integer)colIndex, (String)StringUtils.join(baseNumbers, (String)","));
                    ExcelHelper.setCellValue((XSSFSheet)sheetAt, null, (Integer)xssfRow.getRowNum(), (Integer)(colIndex + 1), (String)StringUtils.join(baseNames, (String)","));
                }
                if (colIndex != importTemplate.getMaxCol()) continue;
                String statusValue = dynamicObject.getString(BussPlanEntryPresetFieldsEnum.STATUS.getColKey());
                if (Boolean.parseBoolean(statusValue)) {
                    ExcelHelper.setCellValue((XSSFSheet)sheetAt, null, (Integer)xssfRow.getRowNum(), (Integer)colIndex, (String)StatusEnum.ENABLE.getDesc());
                    continue;
                }
                ExcelHelper.setCellValue((XSSFSheet)sheetAt, null, (Integer)xssfRow.getRowNum(), (Integer)colIndex, (String)StatusEnum.DISABLE.getDesc());
            }
            ++index;
        }
        try {
            ExcelHelper.downloadExcel((XSSFWorkbook)xssfWorkBook, (String)importTemplate.getFileName(), (IFormView)this.getView());
        }
        catch (IOException e2) {
            log.error((Throwable)e2);
            throw new KDBizException(ResManager.loadResFormat((String)"\u53d1\u751f\u5f02\u5e38\uff1a%1\u3002", (String)"ApplyTemplateCfgPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[]{ThrowableHelper.toString((Exception)e2)}));
        }
    }

    private HashMap<String, String> gethcolumnkeyMap() {
        ColumnList columnList = this.getColumnListFromParam();
        Collection columns = columnList.getColumns();
        List<BaseColumn> collectList = this.getReferencedColumnsInMain();
        HashMap hcolumnkeyMap = (HashMap)collectList.stream().collect(Collectors.toMap(BaseColumn::getKey, BaseColumn::getTitle));
        return hcolumnkeyMap;
    }

    private HashMap<String, String> getBusinessPlanSheetMap() {
        ColumnList columnList = this.getColumnListFromParam();
        List bizTableConfigList = columnList.getBizTableConfigList();
        HashMap businessPlanSheetMap = (HashMap)bizTableConfigList.stream().collect(Collectors.toMap(BizTableConfig::getTabKey, BizTableConfig::getTabNumber));
        return businessPlanSheetMap;
    }

    private void handleImportClick() {
        List<ApplyTemplateDimCfgEntity> dimCfgList = this.getDimCfgList();
        List collect = dimCfgList.stream().filter(t -> StringUtils.equals((String)t.getUsetype(), (String)DimUseTypeEnum.BUSINESS_PLAN.getValue())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5173\u8054\u7684\u4e1a\u52a1\u8ba1\u5212\u7ef4\u5ea6\u3002", (String)"ApplyTemplateCfgPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, List<BizTableConfig>> relationship = this.getRelationship();
        HashMap<String, String> hcolumnkeyMap = this.gethcolumnkeyMap();
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("dimCfgList", SerializationUtils.serializeToBase64(dimCfgList));
        customParams.put("model", this.getModelId());
        customParams.put("viewIds", SerializationUtils.serializeToBase64(this.getViewIds()));
        customParams.put("busModelId", this.getBusModelId());
        customParams.put("hcolumnkeyMap", SerializationUtils.serializeToBase64(hcolumnkeyMap));
        customParams.put("relationship", SerializationUtils.serializeToBase64(relationship));
        String plugin = "kd.epm.eb.formplugin.applytemplate.config.ApplyTemplateDimRangeImportPlugin";
        String caption = ResManager.loadKDString((String)"\u7533\u62a5\u6a21\u677f\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\u5bfc\u5165", (String)"ApplyTemplateCfgPlugin_other_03", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        BgApplyBillUtils.getInstance().showImportBasePage(this.getView(), (IFormPlugin)this, caption, plugin, "eb_apptemplate_cfgimport", customParams, new SchemeAssignDimGroup());
    }

    private HashMap<String, List<BizTableConfig>> getRelationship() {
        ColumnList columnList = this.getColumnListFromParam();
        Collection columns = columnList.getColumns();
        List bizTableConfigList = columnList.getBizTableConfigList();
        Map<String, List<BaseColumn>> groupedByHcolumnkey = columns.stream().filter(column -> {
            if (column instanceof MeasureColumn) {
                return ((MeasureColumn)column).getHcolumnkey() != null;
            }
            if (column instanceof RelationValueColumn) {
                return ((RelationValueColumn)column).getHcolumnkey() != null;
            }
            if (column instanceof CalculateColumn) {
                return ((CalculateColumn)column).getHcolumnkey() != null;
            }
            if (column instanceof DimensionDataColumn) {
                return ((DimensionDataColumn)column).getHcolumnkey() != null;
            }
            if (column instanceof NumberColumn) {
                return ((NumberColumn)column).getHcolumnkey() != null;
            }
            return false;
        }).collect(Collectors.groupingBy(column -> {
            if (column instanceof MeasureColumn) {
                return ((MeasureColumn)column).getHcolumnkey();
            }
            if (column instanceof RelationValueColumn) {
                return ((RelationValueColumn)column).getHcolumnkey();
            }
            if (column instanceof CalculateColumn) {
                return ((CalculateColumn)column).getHcolumnkey();
            }
            if (column instanceof DimensionDataColumn) {
                return ((DimensionDataColumn)column).getHcolumnkey();
            }
            return ((NumberColumn)column).getHcolumnkey();
        }));
        HashMap<String, List<BizTableConfig>> mainBudgetInfoMapList = new HashMap<String, List<BizTableConfig>>(16);
        for (Map.Entry<String, List<BaseColumn>> listEntry : groupedByHcolumnkey.entrySet()) {
            List<BaseColumn> listEntryValue = listEntry.getValue();
            ArrayList<String> bizTableKeyList = new ArrayList<String>(16);
            for (BaseColumn baseColumn : listEntryValue) {
                String bizPlanTabKey = baseColumn.getBizPlanTabKey();
                if (!StringUtils.isNotEmpty((String)bizPlanTabKey)) continue;
                bizTableKeyList.add(bizPlanTabKey);
            }
            List tableConfigList = bizTableConfigList.stream().filter(bizTableConfig -> bizTableKeyList.contains(bizTableConfig.getTabKey())).collect(Collectors.toList());
            mainBudgetInfoMapList.put(listEntry.getKey(), tableConfigList);
        }
        return mainBudgetInfoMapList;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (returnData == null) {
            return;
        }
        if (StringUtils.equals((String)actionId, (String)"eb_apptemplate_cfgimport")) {
            Map retData = (Map)returnData;
            Boolean importStatus = (Boolean)retData.get("status");
            List entityList = (List)retData.get("retData");
            if (entityList.size() == 0) {
                return;
            }
            List dimRows = ((List)entityList.get(0)).stream().filter(e -> StringUtils.isNotEmpty((String)((String)e.get("dimNumber")))).map(e -> (String)e.get("dimNumber")).collect(Collectors.toList());
            if (dimRows.size() == 0) {
                return;
            }
            DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity_businessplan");
            HashMap<String, Integer> dimRangeMap = new HashMap<String, Integer>(16);
            if (entity.size() != 0) {
                for (int i = 0; i < entity.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entity.get(i);
                    String dimRange = dimRows.stream().map(k -> {
                        DynamicObjectCollection dynamicObject = entry.getDynamicObjectCollection("entryentity_businessplan_" + k + "_name");
                        ArrayList<String> nameStrList = new ArrayList<String>(16);
                        for (DynamicObject object : dynamicObject) {
                            nameStrList.add(object.getString("fbasedataid.number"));
                        }
                        return StringUtils.join(nameStrList, (String)",");
                    }).collect(Collectors.joining(";"));
                    dimRangeMap.put(dimRange, i);
                }
            }
            for (List list : entityList) {
                ColumnList columnList = this.getColumnListFromParam();
                List bizTableConfigList = columnList.getBizTableConfigList();
                Map<String, String> bizTableNumberMap = bizTableConfigList.stream().collect(Collectors.toMap(BizTableConfig::getTabNumber, BizTableConfig::getTabKey));
                String dimRange = list.stream().filter(e -> StringUtils.isNotEmpty((String)((String)e.get("memberNum")))).map(e -> (String)e.get("memberNum")).collect(Collectors.joining(";"));
                Integer index = (Integer)dimRangeMap.get(dimRange);
                if (index != null) {
                    StringBuilder status = new StringBuilder();
                    list.forEach(e -> {
                        String statusTmp = (String)e.get("status");
                        if (StringUtils.isNotEmpty((String)statusTmp)) {
                            status.append(statusTmp);
                        }
                    });
                    if (status.length() == 0) continue;
                    this.setStatus(status.toString(), index);
                    continue;
                }
                int newEntryRow = this.getModel().createNewEntryRow("entryentity_businessplan");
                for (Map map : list) {
                    String mainBudgetInfo = (String)map.get("mainbudgetinfo");
                    String businessPlanNumStr = (String)map.get("businessplansheet");
                    String dimId = (String)map.get("dimId");
                    String dimNumber = (String)map.get("dimNumber");
                    String memberNum = (String)map.get("memberNum");
                    String[] memberNumArray = StringUtils.split((String)memberNum, (String)",");
                    String status = (String)map.get("status");
                    if (StringUtils.isNotEmpty((String)mainBudgetInfo)) {
                        this.getModel().setValue(BussPlanEntryPresetFieldsEnum.MAINBUDGETINFO.getColKey(), (Object)mainBudgetInfo, newEntryRow);
                    }
                    if (StringUtils.isNotEmpty((String)businessPlanNumStr)) {
                        String businessPlanKeyString;
                        String[] businessPlanArray = businessPlanNumStr.split(",");
                        HashSet<String> businessPlanKeys = new HashSet<String>(10);
                        for (String businessPlan : businessPlanArray) {
                            String businessPlanKey = bizTableNumberMap.get(businessPlan);
                            businessPlanKeys.add(businessPlanKey);
                        }
                        if (businessPlanKeys.size() > 0 && (businessPlanKeyString = StringUtils.join(businessPlanKeys, (String)",")) != null) {
                            this.getModel().setValue(BussPlanEntryPresetFieldsEnum.BUSINESSPLANSHEET.getColKey(), (Object)businessPlanKeyString, newEntryRow);
                        }
                    }
                    if (StringUtils.isNotEmpty((String)dimId)) {
                        Map dynamicObjectMap;
                        String baseEntityId = this.getBaseEntityId(Long.parseLong(dimId));
                        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
                        filter.and("number", "in", (Object)memberNumArray);
                        if (StringUtils.isNotEmpty((String)baseEntityId) && (dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)baseEntityId, (String)"id", (QFilter[])filter.toArray())) != null) {
                            Set keys = dynamicObjectMap.keySet();
                            Long[] idArray = keys.toArray(new Long[0]);
                            String colKey = "entryentity_businessplan_" + dimNumber + "_name";
                            this.getModel().setValue(colKey, (Object)idArray, newEntryRow);
                        }
                    }
                    this.setStatus(status, newEntryRow);
                }
            }
            if (importStatus.booleanValue()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"ApplyTemplateCfgPlugin_other_04", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u90e8\u5206\u5bfc\u5165\u6210\u529f\uff0c\u8bf7\u67e5\u770b\u9519\u8bef\u4fe1\u606f\u3002", (String)"ApplyTemplateCfgPlugin_other_05", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else {
            DynamicProperty property = this.getModel().getEntryEntity("entryentity_businessplan").getDynamicObjectType().getProperty(actionId);
            if (property == null) {
                return;
            }
            int focusRowIndex = this.getFocusRowIndex();
            if (!(returnData instanceof ListSelectedRowCollection)) {
                return;
            }
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
            if (selectedRows.size() == 0) {
                this.getModel().setValue(actionId, null, focusRowIndex);
                return;
            }
            int totalRow = this.getModel().getEntryRowCount("entryentity_businessplan");
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity_businessplan");
            List items = entryGrid.getItems();
            Set entryKeys = items.stream().filter(item -> !item.getKey().endsWith("_status") && !item.getKey().endsWith("_modifier") && !item.getKey().contains("_modifydate") && !item.getKey().equals(actionId)).map(Control::getKey).collect(Collectors.toSet());
            ArrayList<Long> newIds = new ArrayList<Long>();
            int oldRowIndex = focusRowIndex;
            for (ListSelectedRow selectedRow : selectedRows) {
                if (focusRowIndex >= totalRow) {
                    this.getModel().beginInit();
                    this.getModel().createNewEntryRow("entryentity_businessplan");
                    this.getModel().setValue("entryentity_businessplan_status", (Object)true, focusRowIndex);
                    for (String entryKey : entryKeys) {
                        this.getModel().setValue(entryKey, this.getModel().getValue(entryKey, oldRowIndex), focusRowIndex);
                    }
                    this.getModel().endInit();
                }
                Object primaryKeyValue = selectedRow.getPrimaryKeyValue();
                newIds.add(Long.parseLong(primaryKeyValue.toString()));
            }
            Object value = this.getModel().getValue(actionId, focusRowIndex);
            HashSet oldIds = new HashSet(16);
            if (value instanceof DynamicObjectCollection) {
                DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)value;
                dynamicObjects.forEach(e -> oldIds.add(e.getLong("fbasedataid.id")));
            }
            if (newIds.containsAll(oldIds)) {
                this.getModel().setValue(actionId, (Object)newIds.toArray(), focusRowIndex);
                this.getView().updateView("entryentity_businessplan");
            } else {
                HashSet intersection = new HashSet(oldIds);
                intersection.removeAll(newIds);
                List<Map<String, Long>> quotedCombinations = this.getQuotedDimensionCombinations(focusRowIndex);
                HashSet<Long> values = new HashSet<Long>(16);
                for (Map<String, Long> map : quotedCombinations) {
                    for (Long ids : map.values()) {
                        values.add(ids);
                    }
                }
                ArrayList commonElements = new ArrayList(values);
                commonElements.retainAll(intersection);
                if (commonElements.size() > 0) {
                    IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
                    HashSet<Member> members = new HashSet<Member>(16);
                    Map dimViewMap = modelCacheHelper.getViewsByDataSet(this.getDataSetId());
                    for (Map<String, Long> map : quotedCombinations) {
                        for (Map.Entry<String, Long> entry : map.entrySet()) {
                            if (!commonElements.contains(entry.getValue())) continue;
                            Member member = modelCacheHelper.getMember(entry.getKey(), (Long)dimViewMap.get(entry.getKey()), entry.getValue());
                            members.add(member);
                        }
                    }
                    List memberNames = members.stream().map(Member::getName).collect(Collectors.toList());
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\u201c%1\u201d\u88ab\u5355\u636e\u5f15\u7528\uff0c\u4e0d\u53ef\u88ab\u4fee\u6539\u3002", (String)"ApplyTemplateCfgPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[]{StringUtils.join(memberNames, (String)",")}));
                } else {
                    this.getModel().setValue(actionId, (Object)newIds.toArray(), focusRowIndex);
                    this.getView().updateView("entryentity_businessplan");
                }
            }
        }
    }

    private void setStatus(String status, int rowIndex) {
        if (StringUtils.equals((String)status, (String)StatusEnum.ENABLE.getDesc())) {
            String colKey = "entryentity_businessplan_status";
            this.getModel().setValue(colKey, (Object)StatusEnum.ENABLE.getValue(), rowIndex);
        } else if (StringUtils.equals((String)status, (String)StatusEnum.DISABLE.getDesc())) {
            String colKey = "entryentity_businessplan_status";
            this.getModel().setValue(colKey, (Object)StatusEnum.DISABLE.getValue(), rowIndex);
        }
    }

    private int getFocusRowIndex() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity_businessplan");
        return entryGrid.getEntryState().getFocusRow();
    }

    private String getBaseEntityId(Long dimId) {
        List<BaseColumn> baseColumns = this.getBaseColumns(this.getColumnListFromParam());
        for (BaseColumn baseColumn : baseColumns) {
            long dimensionId;
            String baseEntityId;
            if (baseColumn instanceof DimensionColumn) {
                DimensionColumn dimensionColumn = (DimensionColumn)baseColumn;
                baseEntityId = dimensionColumn.getBaseEntityId();
                dimensionId = dimensionColumn.getDimensionId();
                if (dimId == null || !dimId.equals(dimensionId)) continue;
                return baseEntityId;
            }
            if (baseColumn instanceof RelationDimensionColumn) {
                RelationDimensionColumn relationDimensionColumn = (RelationDimensionColumn)baseColumn;
                baseEntityId = relationDimensionColumn.getBaseEntityId();
                dimensionId = relationDimensionColumn.getDimensionId();
                if (dimId == null || !dimId.equals(dimensionId)) continue;
                return baseEntityId;
            }
            if (!(baseColumn instanceof RowDimensionColumn)) continue;
            RowDimensionColumn rowDimensionColumn = (RowDimensionColumn)baseColumn;
            baseEntityId = rowDimensionColumn.getBaseEntityId();
            dimensionId = rowDimensionColumn.getDimensionId();
            if (dimId == null || !dimId.equals(dimensionId)) continue;
            return baseEntityId;
        }
        return "";
    }

    private void handleDisableClick(BeforeDoOperationEventArgs args) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity_businessplan");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u7981\u7528\u7684\u884c\u3002", (String)"ApplyTemplateCfgPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String statusKey = BussPlanEntryPresetFieldsEnum.STATUS.getKey();
        String businessPlanEntryColKey = this.getBusinessPlanEntryColKey(statusKey);
        for (int selectRow : selectRows) {
            this.getModel().setValue(businessPlanEntryColKey, (Object)false, selectRow);
        }
    }

    private void handleEnableClick(BeforeDoOperationEventArgs args) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity_businessplan");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u542f\u7528\u7684\u884c\u3002", (String)"ApplyTemplateCfgPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String statusKey = BussPlanEntryPresetFieldsEnum.STATUS.getKey();
        String businessPlanEntryColKey = this.getBusinessPlanEntryColKey(statusKey);
        for (int selectRow : selectRows) {
            this.getModel().setValue(businessPlanEntryColKey, (Object)true, selectRow);
        }
    }

    private void handleDelRowClick(BeforeDoOperationEventArgs args) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity_businessplan");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u884c\u3002", (String)"ApplyTemplateCfgPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        ArrayList<String> isQuoteRow = new ArrayList<String>(16);
        for (int selectRow : selectRows) {
            boolean isQuote = this.dimensionCombinationIsQuote(selectRow);
            if (!isQuote) continue;
            isQuoteRow.add(selectRow + 1 + "");
        }
        if (CollectionUtils.isNotEmpty(isQuoteRow)) {
            String tips = String.join((CharSequence)",", isQuoteRow);
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\u5df2\u88ab\u5355\u636e\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ApplyTemplateCfgPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[]{tips}));
        } else {
            this.getModel().deleteEntryRows("entryentity_businessplan", selectRows);
        }
    }

    private boolean dimensionCombinationIsQuote(int rowIndex) {
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity_businessplan", rowIndex);
        DynamicProperty property = entryRowEntity.getDynamicObjectType().getProperty("entryentity_businessplan_modifier");
        if (property == null) {
            return false;
        }
        DynamicObject modifier = entryRowEntity.getDynamicObject("entryentity_businessplan_modifier");
        if (modifier == null) {
            return false;
        }
        List<Map<String, String>> billDimCombinationList = this.getBillDimCombination();
        List<ApplyTemplateDimCfgEntity> dimCfgList = this.getDimCfgList();
        ArrayList<String> dimCfgKeyList = new ArrayList<String>(16);
        for (ApplyTemplateDimCfgEntity applyTemplateDimCfgEntity : dimCfgList) {
            if (!StringUtils.equals((String)applyTemplateDimCfgEntity.getUsetype(), (String)DimUseTypeEnum.BUSINESS_PLAN.getValue())) continue;
            dimCfgKeyList.add(applyTemplateDimCfgEntity.getDimnum());
        }
        ArrayList returnList = new ArrayList(16);
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        Map dimViewMap = modelCacheHelper.getViewsByDataSet(this.getDataSetId());
        for (Map<String, String> map : billDimCombinationList) {
            boolean flag = true;
            block2: for (Map.Entry<String, String> entry : map.entrySet()) {
                String dimNumber = entry.getKey();
                String billValue = entry.getValue();
                if (!dimCfgKeyList.contains(dimNumber)) continue;
                DynamicObjectCollection dynamicObjectCollection = entryRowEntity.getDynamicObjectCollection("entryentity_businessplan_" + dimNumber + "_name");
                for (DynamicObject dynamicObject : dynamicObjectCollection) {
                    boolean foundMatch = true;
                    HashMap<String, Long> dimNumberValueMap = new HashMap<String, Long>(16);
                    if (dynamicObject != null) {
                        String value = dynamicObject.getLong("fbasedataid.id") + "";
                        Member member = modelCacheHelper.getMember(dimNumber, (Long)dimViewMap.get(dimNumber), Long.valueOf(dynamicObject.getLong("fbasedataid.id")));
                        if (!StringUtils.equals((String)billValue, (String)value)) {
                            if (!member.isLeaf()) {
                                ArrayList<Long> memberIds = new ArrayList<Long>(16);
                                this.getMemberAllChildren(member, memberIds);
                                if (!memberIds.contains(Long.parseLong(billValue))) {
                                    foundMatch = false;
                                }
                            } else {
                                foundMatch = false;
                            }
                        }
                    } else {
                        foundMatch = false;
                    }
                    if (!foundMatch) continue block2;
                    dimNumberValueMap.put(dimNumber, dynamicObject.getLong("fbasedataid.id"));
                    returnList.add(dimNumberValueMap);
                }
            }
        }
        return returnList != null && returnList.size() > 0;
    }

    private List<Map<String, Long>> getQuotedDimensionCombinations(int rowIndex) {
        ArrayList<Map<String, Long>> returnList = new ArrayList<Map<String, Long>>(16);
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity_businessplan", rowIndex);
        DynamicProperty property = entryRowEntity.getDynamicObjectType().getProperty("entryentity_businessplan_modifier");
        if (property == null) {
            return returnList;
        }
        DynamicObject modifier = entryRowEntity.getDynamicObject("entryentity_businessplan_modifier");
        if (modifier == null) {
            return returnList;
        }
        List<Map<String, String>> billDimCombinationList = this.getBillDimCombination();
        List<ApplyTemplateDimCfgEntity> dimCfgList = this.getDimCfgList();
        ArrayList<String> dimCfgKeyList = new ArrayList<String>(16);
        for (ApplyTemplateDimCfgEntity applyTemplateDimCfgEntity : dimCfgList) {
            if (!StringUtils.equals((String)applyTemplateDimCfgEntity.getUsetype(), (String)DimUseTypeEnum.BUSINESS_PLAN.getValue())) continue;
            dimCfgKeyList.add(applyTemplateDimCfgEntity.getDimnum());
        }
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        Map currentDimViewMap = modelCacheHelper.getViewsByDataSet(this.getDataSetId());
        for (Map<String, String> map : billDimCombinationList) {
            boolean flag = true;
            block2: for (Map.Entry<String, String> entry : map.entrySet()) {
                String dimNumber = entry.getKey();
                String billValue = entry.getValue();
                if (!dimCfgKeyList.contains(dimNumber)) continue;
                DynamicObjectCollection dynamicObjectCollection = entryRowEntity.getDynamicObjectCollection("entryentity_businessplan_" + dimNumber + "_name");
                for (DynamicObject dynamicObject : dynamicObjectCollection) {
                    boolean foundMatch = true;
                    HashMap<String, Long> dimNumberValueMap = new HashMap<String, Long>(16);
                    if (dynamicObject != null) {
                        String value = dynamicObject.getLong("fbasedataid.id") + "";
                        Member member = modelCacheHelper.getMember(dimNumber, (Long)currentDimViewMap.get(dimNumber), Long.valueOf(dynamicObject.getLong("fbasedataid.id")));
                        if (!StringUtils.equals((String)billValue, (String)value)) {
                            if (!member.isLeaf()) {
                                ArrayList<Long> memberIds = new ArrayList<Long>(16);
                                this.getMemberAllChildren(member, memberIds);
                                if (!memberIds.contains(Long.parseLong(billValue))) {
                                    foundMatch = false;
                                }
                            } else {
                                foundMatch = false;
                            }
                        }
                    } else {
                        foundMatch = false;
                    }
                    if (!foundMatch) continue block2;
                    dimNumberValueMap.put(dimNumber, dynamicObject.getLong("fbasedataid.id"));
                    returnList.add(dimNumberValueMap);
                }
            }
        }
        return returnList;
    }

    private List<Map<String, String>> getBillDimCombination() {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(16);
        Map<String, String> dimKeyMap = this.getDimKeyList();
        ArrayList<String> dimKeyList = new ArrayList<String>(16);
        dimKeyList.addAll(dimKeyMap.keySet());
        String fieldStr = String.join((CharSequence)",", dimKeyList);
        String sql = "select " + fieldStr + " from " + this.getTemplateTableName();
        try (DataSet ds = DB.queryDataSet((String)"epm", (DBRoute)DBRoute.of((String)"epm"), (String)sql);){
            while (ds != null && ds.hasNext()) {
                Row next = ds.next();
                HashMap<String, String> map = new HashMap<String, String>(16);
                for (String colKey : dimKeyList) {
                    String value = next.getString(colKey);
                    String dimNumber = dimKeyMap.get(colKey);
                    if (StringUtils.isEmpty((String)value) || StringUtils.equals((String)"0", (String)value)) continue;
                    map.put(dimNumber, value);
                }
                if (map.size() <= 0) continue;
                result.add(map);
            }
        }
        return result;
    }

    private Map<String, String> getDimKeyList() {
        List<BaseColumn> baseColumns = this.getBaseColumns(this.getColumnListFromParam());
        HashMap<String, String> dimColMap = new HashMap<String, String>(16);
        for (BaseColumn baseColumn : baseColumns) {
            if (baseColumn instanceof DimensionColumn) {
                DimensionColumn dimensionColumn = (DimensionColumn)baseColumn;
                String dimNumber = dimensionColumn.getDimNumber();
                dimColMap.put("f" + baseColumn.getKey(), dimNumber);
                continue;
            }
            if (baseColumn instanceof RelationDimensionColumn) {
                RelationDimensionColumn relationDimensionColumn = (RelationDimensionColumn)baseColumn;
                long dimensionId = relationDimensionColumn.getDimensionId();
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)dimensionId, (String)"epm_dimension");
                if (dynamicObject == null) continue;
                String dimNumber = dynamicObject.getString("number");
                dimColMap.put("f" + baseColumn.getKey(), dimNumber);
                continue;
            }
            if (!(baseColumn instanceof RowDimensionColumn)) continue;
            RowDimensionColumn rowDimensionColumn = (RowDimensionColumn)baseColumn;
            String dimNumber = rowDimensionColumn.getDimNumber();
            dimColMap.put("f" + baseColumn.getKey(), dimNumber);
        }
        return dimColMap;
    }

    private String getTemplateTableName() {
        Map mainEntityInfo = BgApplyBillUtils.getInstance().getMainEntityInfoByTemplate(this.getTemplateId(), null, null);
        Object table = mainEntityInfo.get("table");
        if (table != null) {
            return table.toString();
        }
        return "";
    }

    private void handleAddRowClick(BeforeDoOperationEventArgs args) {
        Map<String, List<Long>> cacheSelectedPanelDimIds = this.getCacheSelectedPanelDimIds();
        if (cacheSelectedPanelDimIds == null || cacheSelectedPanelDimIds.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5173\u8054\u7684\u4e1a\u52a1\u8ba1\u5212\u7ef4\u5ea6\u3002", (String)"ApplyTemplateCfgPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        List<Long> dims = cacheSelectedPanelDimIds.get(DimUseTypeEnum.BUSINESS_PLAN.getValue());
        if (CollectionUtils.isNotEmpty(dims)) {
            int newEntryRow = this.getModel().createNewEntryRow("entryentity_businessplan");
            this.getModel().setValue(BussPlanEntryPresetFieldsEnum.STATUS.getColKey(), (Object)StatusEnum.ENABLE.getValue(), newEntryRow);
            List<BaseColumn> summaryColumns = this.getReferencedColumnsInMain();
            if (summaryColumns.size() == 1) {
                this.getModel().setValue(BussPlanEntryPresetFieldsEnum.MAINBUDGETINFO.getColKey(), (Object)summaryColumns.get(0).getKey(), newEntryRow);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5173\u8054\u7684\u4e1a\u52a1\u8ba1\u5212\u7ef4\u5ea6\u3002", (String)"ApplyTemplateCfgPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        FormTypeEnum currentTabType = this.getCurrentTabType();
        if ("leaf_audittrail".equals(name)) {
            this.getPageCache().put("currentDimNum", SysDimensionEnum.AuditTrail.getNumber());
            Long currentAuditTrailMemId = IDUtils.toLong((Object)this.getModel().getValue("audittrailid"));
            ArrayList<Long> ids = new ArrayList<Long>(16);
            Member leafAuditTrailMem = this.getLeafAuditTrailMem(currentAuditTrailMemId);
            if (leafAuditTrailMem != null) {
                ids.add(leafAuditTrailMem.getId());
            }
            QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
            if (currentTabType != FormTypeEnum.SPLIT) {
                qFilter.and("id", "in", ids);
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
            LeftTreeF7Parameter leftTreeF7Parameter = new LeftTreeF7Parameter();
            leftTreeF7Parameter.setQueryDecompose(true);
            this.switchF7(beforeF7SelectEvent, this.getBusModelId(), (BaseF7Parameter)leftTreeF7Parameter);
        } else if (StringUtils.equals((String)name, (String)"non_leaf_audittrail")) {
            this.getPageCache().put("currentDimNum", SysDimensionEnum.AuditTrail.getNumber());
            Long currentAuditTrailMemId = IDUtils.toLong((Object)this.getModel().getValue("audittrailid"));
            ArrayList<Long> ids = new ArrayList<Long>(16);
            Member nonLeafAuditTrailMem = this.getNonLeafAuditTrailMem(currentAuditTrailMemId);
            if (nonLeafAuditTrailMem != null) {
                ids.add(nonLeafAuditTrailMem.getId());
            }
            QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
            if (currentTabType != FormTypeEnum.SPLIT) {
                qFilter.and("id", "in", ids);
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
            LeftTreeF7Parameter leftTreeF7Parameter = new LeftTreeF7Parameter();
            leftTreeF7Parameter.setQueryDecompose(true);
            this.switchF7(beforeF7SelectEvent, this.getBusModelId(), (BaseF7Parameter)leftTreeF7Parameter);
        } else if (StringUtils.equals((String)name, (String)"split_audittrail")) {
            this.getPageCache().put("currentDimNum", SysDimensionEnum.AuditTrail.getNumber());
            QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
            LeftTreeF7Parameter leftTreeF7Parameter = new LeftTreeF7Parameter();
            leftTreeF7Parameter.setQueryDecompose(true);
            this.switchF7(beforeF7SelectEvent, this.getBusModelId(), (BaseF7Parameter)leftTreeF7Parameter);
        }
    }

    private Member getLeafAuditTrailMem(Long currentColMemId) {
        Member member = this.getIModelCacheHelper().getMember(SysDimensionEnum.AuditTrail.getNumber(), null, currentColMemId);
        if (member != null && member.isLeaf()) {
            return member;
        }
        if (member != null && !member.isLeaf()) {
            DynamicObject[] load;
            ArrayList<Long> ids = new ArrayList<Long>(16);
            for (Member child : member.getChildren()) {
                ids.add(child.getId());
            }
            for (DynamicObject value : load = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"epm_audittrialmembertree").getDynamicObjectType())) {
                String useStr = value.getString("use");
                long id = value.getLong("id");
                if (!StringUtils.equals((String)useStr, (String)"40")) continue;
                return this.getIModelCacheHelper().getMember(SysDimensionEnum.AuditTrail.getNumber(), null, Long.valueOf(id));
            }
        }
        return null;
    }

    private Member getNonLeafAuditTrailMem(Long currentColMemId) {
        Member member = this.getIModelCacheHelper().getMember(SysDimensionEnum.AuditTrail.getNumber(), null, currentColMemId);
        ArrayList<Long> ids = new ArrayList<Long>(16);
        if (member != null && member.isLeaf()) {
            return member;
        }
        if (member != null && !member.isLeaf()) {
            DynamicObject[] load;
            Long parentId = member.getParentId();
            Member parentMember = this.getIModelCacheHelper().getMember(SysDimensionEnum.AuditTrail.getNumber(), null, parentId);
            if (parentMember == null) {
                return member;
            }
            List memberChildren = parentMember.getChildren();
            for (Member memberChild : memberChildren) {
                if (member.getId().equals(memberChild.getId())) continue;
                ids.add(memberChild.getId());
            }
            for (DynamicObject value : load = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"epm_audittrialmembertree").getDynamicObjectType())) {
                String useStr = value.getString("use");
                long id = value.getLong("id");
                if (!StringUtils.equals((String)useStr, (String)"40")) continue;
                return this.getIModelCacheHelper().getMember(SysDimensionEnum.AuditTrail.getNumber(), null, Long.valueOf(id));
            }
        }
        return null;
    }

    private Member getSplitProportionAuditTrailMem(Long currentColMemId) {
        Member result = null;
        Member member = this.getIModelCacheHelper().getMember(SysDimensionEnum.AuditTrail.getNumber(), null, currentColMemId);
        if (member != null && member.isLeaf()) {
            result = member;
        } else if (member != null && !member.isLeaf()) {
            ArrayList<Long> ids = new ArrayList<Long>(16);
            this.getMemberAllChildren(member, ids);
            DynamicObject[] load = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"epm_audittrialmembertree").getDynamicObjectType());
            int count = 0;
            for (DynamicObject value : load) {
                String useStr = value.getString("use");
                long id = value.getLong("id");
                if (!StringUtils.equals((String)useStr, (String)"10")) continue;
                ++count;
                result = this.getIModelCacheHelper().getMember(SysDimensionEnum.AuditTrail.getNumber(), null, Long.valueOf(id));
            }
            if (count > 1) {
                result = null;
            }
        }
        if (result == null) {
            this.cacheSplitAuditTrailId(this.getCurrentTabType(), 0L);
        } else {
            this.cacheSplitAuditTrailId(this.getCurrentTabType(), result.getId());
        }
        return result;
    }

    private void getMemberAllChildren(Member member, List<Long> memberIds) {
        if (member == null) {
            return;
        }
        List memberChildren = member.getChildren();
        if (CollectionUtils.isEmpty((Collection)memberChildren)) {
            return;
        }
        for (Member memberChild : memberChildren) {
            this.getMemberAllChildren(memberChild, memberIds);
            memberIds.add(memberChild.getId());
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        this.setTabSelectedFlag();
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"audittrailpanel"});
        if (StringUtils.equals((String)tabKey, (String)FormTypeEnum.APPLY.getTabCode())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"audittrailpanel"});
            this.handleApplyTabSelected(tabSelectEvent);
        } else if (StringUtils.equals((String)tabKey, (String)FormTypeEnum.COLLECT.getTabCode())) {
            this.handleCollectTabSelected(tabSelectEvent);
        } else if (StringUtils.equals((String)tabKey, (String)FormTypeEnum.APPROVE.getTabCode())) {
            this.handleApproveTabSelected(tabSelectEvent);
        } else if (StringUtils.equals((String)tabKey, (String)FormTypeEnum.SPLIT.getTabCode())) {
            this.handleSplitTabSelected(tabSelectEvent);
        } else if (StringUtils.equals((String)tabKey, (String)"tab_businessplan")) {
            this.getPageCache().put("tabBusinessPlan", "yes");
            int rowCount = this.getModel().getEntryRowCount("entryentity_businessplan");
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity_businessplan");
            if (rowCount == 1 && ((DynamicObject)entryEntity.get(0)).get("entryentity_businessplan_modifier") == null) {
                this.dynamicCreateEntryField();
            }
            this.initBusinessPlanEntry();
        }
        this.setEnable();
        this.removeTabSelectedFlag();
        this.setComboList();
    }

    private void setTabSelectedFlag() {
        this.getPageCache().put("isTabSelected", "yes");
    }

    private void removeTabSelectedFlag() {
        this.getPageCache().remove("isTabSelected");
    }

    private boolean isTabSelected() {
        return StringUtils.equals((String)"yes", (String)this.getPageCache().get("isTabSelected"));
    }

    private void handleSplitTabSelected(TabSelectEvent tabSelectEvent) {
        this.refreshColCfgEntry(FormTypeEnum.SPLIT);
    }

    private void cacheSplitAuditTrailId(FormTypeEnum currentTabType, Long auditMemId) {
        if (currentTabType != null) {
            this.getPageCache().put("currentTab" + currentTabType.getCode(), auditMemId == null ? "0" : auditMemId + "");
        }
    }

    private void refreshColCfgEntry(FormTypeEnum formTypeEnum) {
        DynamicObjectCollection entryEntity;
        Integer lockRow = null;
        if (!formTypeEnum.getTabCode().equals(FormTypeEnum.APPLY.getTabCode())) {
            entryEntity = this.getModel().getEntryEntity("entryentity_apply");
            for (DynamicObject dynamicObject : entryEntity) {
                Object editValue = dynamicObject.get(ColCfgPresetFieldsEnum.EDIT_TYPE.getKey());
                if (!editValue.equals(ColCfgPropTypeEnum.SUMMARYDISPLAY.getName())) continue;
                lockRow = dynamicObject.getInt("seq") - 1;
            }
            if (lockRow != null) {
                this.getModel().deleteEntryRow("entryentity_apply", lockRow.intValue());
            }
        } else {
            entryEntity = this.getModel().getEntryEntity("entryentity_apply");
            HashSet<String> strings = new HashSet<String>(5);
            for (DynamicObject dynamicObject : entryEntity) {
                String editValue = dynamicObject.getString(ColCfgPresetFieldsEnum.EDIT_TYPE.getKey());
                strings.add(editValue);
                if (!editValue.equals(ColCfgPropTypeEnum.SUMMARYDISPLAY.getName())) continue;
                lockRow = dynamicObject.getInt("seq") - 1;
            }
            int rowCount = entryEntity.getRowCount();
            if (!strings.contains(ColCfgPropTypeEnum.SUMMARYDISPLAY.getName()) && rowCount < ColCfgPropEnum.SUMMARYDISPLAY.getRowIndex()) {
                int newEntryRow = this.getModel().createNewEntryRow("entryentity_apply");
                this.getModel().setValue(ColCfgPropEnum.SUMMARYDISPLAY.getKey(), (Object)ColCfgPropEnum.SUMMARYDISPLAY.getDesc(), newEntryRow);
                Map<String, List<ApplyTemplateColCfgEntity>> cacheColCfg = this.getCacheColCfg();
                List<ApplyTemplateColCfgEntity> applyTemplateColCfgEntities = cacheColCfg.get(FormTypeEnum.APPLY.getCode());
                applyTemplateColCfgEntities.forEach(e -> {
                    if (ColCfgPropEnum.SUMMARYDISPLAY.getValue().equals(e.getSummarydisplay())) {
                        this.getModel().setValue(e.getColkey(), (Object)true, newEntryRow);
                    }
                });
            }
        }
        DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)this.getModel().getDataEntity(true).get("entryentity_apply");
        int rowCount = dynamicObjects.size();
        List<ApplyTemplateColCfgEntity> cacheColCfgByFormType = this.getCacheColCfgByFormType(formTypeEnum);
        for (ApplyTemplateColCfgEntity applyTemplateColCfgEntity : cacheColCfgByFormType) {
            String editType = applyTemplateColCfgEntity.getEdittype();
            String aggregate = applyTemplateColCfgEntity.getAggregate();
            String summaryDisplay = applyTemplateColCfgEntity.getSummarydisplay();
            for (int i = 0; i < rowCount; ++i) {
                Object value = this.getModel().getValue(ColCfgPresetFieldsEnum.EDIT_TYPE.getKey(), i);
                if (value == null) continue;
                String propDesc = value.toString();
                String valueByDesc = ColCfgPropEnum.getValueByDesc((String)propDesc);
                if (i < ColCfgPropEnum.AGGREGATE.getRowIndex() - 1) {
                    if (StringUtils.isEmpty((String)editType)) {
                        this.getModel().setValue(applyTemplateColCfgEntity.getColkey(), (Object)false, i);
                        continue;
                    }
                    if (!StringUtils.equals((String)editType, (String)valueByDesc)) continue;
                    this.getModel().setValue(applyTemplateColCfgEntity.getColkey(), (Object)true, i);
                    continue;
                }
                if (i == ColCfgPropEnum.SUMMARYDISPLAY.getRowIndex() - 1) {
                    if (StringUtils.isEmpty((String)summaryDisplay)) {
                        this.getModel().setValue(applyTemplateColCfgEntity.getColkey(), (Object)false, i);
                        continue;
                    }
                    if (!StringUtils.equals((String)summaryDisplay, (String)valueByDesc)) continue;
                    this.getModel().setValue(applyTemplateColCfgEntity.getColkey(), (Object)true, i);
                    continue;
                }
                if (StringUtils.isEmpty((String)aggregate)) {
                    this.getModel().setValue(applyTemplateColCfgEntity.getColkey(), (Object)false, i);
                    continue;
                }
                if (!StringUtils.equals((String)propDesc, (String)ColCfgPropEnum.AGGREGATE.getDesc())) continue;
                if (StringUtils.equals((String)aggregate, (String)valueByDesc)) {
                    this.getModel().setValue(applyTemplateColCfgEntity.getColkey(), (Object)true, i);
                    continue;
                }
                this.getModel().setValue(applyTemplateColCfgEntity.getColkey(), (Object)false, i);
            }
        }
    }

    private void handleApproveTabSelected(TabSelectEvent tabSelectEvent) {
        this.refreshColCfgEntry(FormTypeEnum.APPROVE);
    }

    private void handleCollectTabSelected(TabSelectEvent tabSelectEvent) {
        this.refreshColCfgEntry(FormTypeEnum.COLLECT);
    }

    private void handleApplyTabSelected(TabSelectEvent tabSelectEvent) {
        this.refreshColCfgEntry(FormTypeEnum.APPLY);
    }

    private boolean templateIsExit() {
        boolean exists = QueryServiceHelper.exists((String)"eb_applytemplate", (Object)this.getTemplateId());
        if (!exists) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u677f\u4e0d\u5b58\u5728\u3002", (String)"ApplyTemplateCfgPlugin_other_06", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void handleBusinessPlanPanelDimBeforePropChange(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        if (name.startsWith("flexpanel_businessplan")) {
            int rowCount = this.getModel().getEntryRowCount("entryentity_businessplan");
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity_businessplan");
            DynamicProperty entryentity_businessplan_modifier = entryEntity.getDynamicObjectType().getProperty("entryentity_businessplan_modifier");
            if (entryentity_businessplan_modifier == null) {
                return;
            }
            if (rowCount > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\u5df2\u5b58\u5728\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5173\u8054\u4e1a\u52a1\u8ba1\u5212\u7ef4\u5ea6\u3002", (String)"ApplyTemplateCfgPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        boolean exists = this.templateIsExit();
        if (!exists) {
            return;
        }
        super.propertyChanged(e);
        this.handleBusinessPlanPanelDimBeforePropChange(e);
        this.handleCheckCols();
        this.handleColCheckPropChange(e);
        this.handleSummaryColPropChange(e);
        this.handleTemplateColPropChange(e);
        this.handlePanelDimPropChange(e);
        this.handleAuditTrailProportionChange(e);
        this.updateDimRangeModifyDate(e);
        this.handleMainBudgetInfoPropChange(e);
        this.handleBusinessPlanSheet(e);
        this.handSetQueryViewXsPlan(e);
        this.handleXsQueryClick(e);
    }

    private void handSetQueryViewXsPlan(PropertyChangedArgs args) {
        IDataEntityProperty property = args.getProperty();
        FormTypeEnum formTypeEnum = this.getCurrentTabType();
        if (property.getName().startsWith("h_") && formTypeEnum != null && !formTypeEnum.getCode().equals(FormTypeEnum.APPLY.getCode())) {
            this.setComboList();
        }
    }

    private void setComboList() {
        this.getModel().setValue("combofield", null);
        String colCfgMapStr = this.getPageCache().get("cache_col_cfg_key");
        Map result = (Map)SerializationUtils.fromJsonString((String)colCfgMapStr, HashMap.class);
        FormTypeEnum formTypeEnum = this.getCurrentTabType();
        List tabResult = new ArrayList(16);
        if (formTypeEnum != null) {
            tabResult = (List)result.get(formTypeEnum.getCode());
        }
        HashSet entityCloums = new HashSet(16);
        List collect = this.getColumnListFromParam().getColumns().stream().filter(e -> e instanceof DimensionDataColumn).map(BaseColumn::getKey).collect(Collectors.toList());
        for (HashMap hashMap : tabResult) {
            if (!"write".equals(hashMap.get("edittype")) || !collect.contains(String.valueOf(hashMap.get("colkey")))) continue;
            entityCloums.add(hashMap.get("colkey"));
        }
        ArrayList comboList = new ArrayList(16);
        List<BaseColumn> baseColumns = this.getBaseColumns(this.getColumnListFromParam());
        baseColumns.stream().forEach(e -> {
            boolean contains = entityCloums.contains(e.getKey());
            if (contains) {
                comboList.add(new ComboItem(new LocaleString(StringUtils.isNotEmpty((String)e.getGrouptitle()) ? e.getGrouptitle() + "-" + e.getTitle() : e.getTitle()), e.getKey()));
            }
        });
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("combofield");
        comboEdit.setComboItems(comboList);
        String currentColKey = this.getPageCache().get("currentColKey");
        String currentColSelectedValue = this.getPageCache().get("currentColSelectedValue");
        String finalCurrentColKey = currentColKey;
        boolean finalC = comboList.stream().anyMatch(e -> e.getValue().equals(finalCurrentColKey));
        if (StringUtils.isNotEmpty((String)currentColKey) && comboList.size() > 0 && "true".equals(currentColSelectedValue)) {
            if (!finalC) {
                currentColKey = ((ComboItem)comboList.get(0)).getValue();
            }
            this.getPageCache().put("currentColKey", currentColKey);
            this.getPageCache().put("currentColSelectedValue", String.valueOf(true));
            this.getModel().setValue("combofield", (Object)currentColKey);
        }
    }

    private void handleXsQueryClick(PropertyChangedArgs args) {
        BaseColumn baseColumn;
        IDataEntityProperty property = args.getProperty();
        ChangeData[] changeSet = args.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        FormTypeEnum formTypeEnum = this.getCurrentTabType();
        if (formTypeEnum != null && formTypeEnum.getCode().equals(FormTypeEnum.APPLY.getCode())) {
            return;
        }
        if (!"combofield".equals(property.getName()) || newValue == null || "".equals(String.valueOf(newValue))) {
            return;
        }
        Long leafMemberId = null;
        Long nonLeafMemberId = null;
        Long splitProportionMemberId = null;
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"audittrailpanel"});
        List<ApplyTemplateColCfgEntity> cacheColCfgByFormType = this.getCacheColCfgByFormType(this.getCurrentTabType());
        Optional<ApplyTemplateColCfgEntity> first = cacheColCfgByFormType.stream().filter(e -> e.getColkey().equals(String.valueOf(newValue))).findFirst();
        if (first.isPresent()) {
            ApplyTemplateColCfgEntity applyTemplateColCfgEntity = first.get();
            List atCfgEntities = applyTemplateColCfgEntity.getAtCfgEntities();
            for (ApplyTemplateAtCfgEntity atCfgEntity : atCfgEntities) {
                if (atCfgEntity.getAuditTrailUse().equals(AuditTrailUseEnum.ADJUST_LEAF.getCode())) {
                    leafMemberId = atCfgEntity.getAuditTrailMemId();
                }
                if (atCfgEntity.getAuditTrailUse().equals(AuditTrailUseEnum.ADJUST_NON_LEAF.getCode())) {
                    nonLeafMemberId = atCfgEntity.getAuditTrailMemId();
                }
                if (!atCfgEntity.getAuditTrailUse().equals(AuditTrailUseEnum.SPLIT_PROPORTION.getCode())) continue;
                splitProportionMemberId = atCfgEntity.getAuditTrailMemId();
                this.setAuditTrailEnable(atCfgEntity.getAuditTrailMemId());
            }
        }
        ColumnList columnListFromParam = this.getColumnListFromParam();
        Collection columns = columnListFromParam.getColumns();
        Optional<BaseColumn> firstkey = columns.stream().filter(e -> e.getKey().equals(newValue)).findFirst();
        this.getModel().setValue("audittrailid", null);
        if (firstkey.isPresent() && (baseColumn = firstkey.get()) instanceof DimensionDataColumn) {
            List<DataMapDimension> auditTrailMaps = this.getAuditTrailMaps(String.valueOf(newValue));
            QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
            filter.and("number", "=", (Object)SysDimensionEnum.AuditTrail.getNumber());
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_dimension", (QFilter[])filter.toArray());
            long currentAuditTrailId = dynamicObject.getLong("id");
            Member currentColAuditTrailMember = this.getAuditTrailFromCol(auditTrailMaps, currentAuditTrailId);
            Long currentAuditMemId = 0L;
            String name = "";
            if (currentColAuditTrailMember != null) {
                currentAuditMemId = currentColAuditTrailMember.getId();
                name = currentColAuditTrailMember.getName();
            }
            this.setCurrentColAuditTrailValue(currentAuditMemId, name);
            this.getModel().setValue("audittrailid", (Object)currentAuditMemId);
        }
        this.getPageCache().put("currentColKey", String.valueOf(newValue));
        this.getPageCache().put("currentColSelectedValue", String.valueOf(true));
        this.setAuditTrailValue(leafMemberId, nonLeafMemberId, splitProportionMemberId);
    }

    private void handleBusinessPlanSheet(PropertyChangedArgs e) {
        Object businessPlanSheet;
        IDataEntityProperty property = e.getProperty();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        String name = property.getName();
        int rowIndex = changeSet[0].getRowIndex();
        if (name.startsWith("entryentity_businessplan") && name.equals(BussPlanEntryPresetFieldsEnum.BUSINESSPLANSHEET.getColKey()) && newValue instanceof String) {
            this.checkReference(rowIndex, newValue.toString());
        }
        if (name.startsWith("entryentity_businessplan") && name.equals(BussPlanEntryPresetFieldsEnum.MAINBUDGETINFO.getColKey()) && (businessPlanSheet = this.getModel().getValue(BussPlanEntryPresetFieldsEnum.BUSINESSPLANSHEET.getColKey(), rowIndex)) instanceof String) {
            this.checkReference(rowIndex, businessPlanSheet.toString());
        }
        if (name.startsWith("entryentity_businessplan") && !name.endsWith("_code") && !name.endsWith("_range") && !name.endsWith("_modifier") && name.endsWith("_modifydate")) {
            this.checkDuplicateRows(false);
        }
    }

    private void checkReference(Integer rowIndex, String businessPlanSheetStr) {
        String mainBudgetInfo = (String)this.getModel().getValue(BussPlanEntryPresetFieldsEnum.MAINBUDGETINFO.getColKey(), rowIndex.intValue());
        HashMap<String, List<BizTableConfig>> relationship = this.getRelationship();
        List<BizTableConfig> bizTableConfigByMainBudgetInfo = relationship.get(mainBudgetInfo);
        HashMap<String, String> hcolumnkeyMap = this.gethcolumnkeyMap();
        ColumnList columnList = this.getColumnListFromParam();
        List bizTableConfigList = columnList.getBizTableConfigList();
        Map<String, String> bizTableMap = bizTableConfigList.stream().collect(Collectors.toMap(BizTableConfig::getTabKey, BizTableConfig::getTabName));
        String[] businessPlanSheetArray = StringUtils.split((String)businessPlanSheetStr, (String)",");
        if (businessPlanSheetArray != null && bizTableConfigByMainBudgetInfo != null) {
            HashSet tableKeySet = new HashSet(16);
            bizTableConfigByMainBudgetInfo.forEach(cfg -> tableKeySet.add(cfg.getTabKey()));
            for (int i = 0; i < businessPlanSheetArray.length; ++i) {
                if (tableKeySet.contains(businessPlanSheetArray[i])) continue;
                this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u4e3b\u8868\u9884\u7b97\u4fe1\u606f\u201c%2\u201d\u672a\u88ab\u4e1a\u52a1\u8ba1\u5212\u8868\u201c%3\u201d\u5f15\u7528\u6c47\u603b\uff0c\u4e0d\u53ef\u9009\u62e9\u3002", (String)"ApplyTemplateCfgPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[]{rowIndex + 1, hcolumnkeyMap.get(mainBudgetInfo), bizTableMap.get(businessPlanSheetArray[i])}));
                this.getModel().setValue(BussPlanEntryPresetFieldsEnum.BUSINESSPLANSHEET.getColKey(), null, rowIndex.intValue());
            }
        }
    }

    private void handleMainBudgetInfoPropChange(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        int rowIndex = changeSet[0].getRowIndex();
        String name = property.getName();
        if (BussPlanEntryPresetFieldsEnum.MAINBUDGETINFO.getColKey().equals(name)) {
            String bizPlanTabKey;
            this.setBusinessPlanComboItems(newValue.toString());
            ColumnList columnList = this.getColumnListFromParam();
            Collection columns = columnList.getColumns();
            Map<String, List<BaseColumn>> groupedByHcolumnkey = columns.stream().filter(column -> {
                if (column instanceof MeasureColumn) {
                    return ((MeasureColumn)column).getHcolumnkey() != null;
                }
                if (column instanceof RelationValueColumn) {
                    return ((RelationValueColumn)column).getHcolumnkey() != null;
                }
                if (column instanceof CalculateColumn) {
                    return ((CalculateColumn)column).getHcolumnkey() != null;
                }
                if (column instanceof DimensionDataColumn) {
                    return ((DimensionDataColumn)column).getHcolumnkey() != null;
                }
                if (column instanceof NumberColumn) {
                    return ((NumberColumn)column).getHcolumnkey() != null;
                }
                return false;
            }).collect(Collectors.groupingBy(column -> {
                if (column instanceof MeasureColumn) {
                    return ((MeasureColumn)column).getHcolumnkey();
                }
                if (column instanceof RelationValueColumn) {
                    return ((RelationValueColumn)column).getHcolumnkey();
                }
                if (column instanceof CalculateColumn) {
                    return ((CalculateColumn)column).getHcolumnkey();
                }
                if (column instanceof DimensionDataColumn) {
                    return ((DimensionDataColumn)column).getHcolumnkey();
                }
                return ((NumberColumn)column).getHcolumnkey();
            }));
            List<BaseColumn> baseColumns = groupedByHcolumnkey.get(newValue.toString());
            if (baseColumns != null && baseColumns.size() == 1 && (bizPlanTabKey = baseColumns.get(0).getBizPlanTabKey()) != null) {
                this.getModel().setValue(BussPlanEntryPresetFieldsEnum.BUSINESSPLANSHEET.getColKey(), (Object)bizPlanTabKey, rowIndex);
            }
        }
    }

    private void handleSummaryColPropChange(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        int rowIndex = changeSet[0].getRowIndex();
        String name = property.getName();
        FormTypeEnum currentTabType = this.getCurrentTabType();
        Map<String, List<ApplyTemplateColCfgEntity>> cacheColCfg = this.getCacheColCfg();
        List<ApplyTemplateColCfgEntity> applyTemplateColCfgEntities = cacheColCfg.get(FormTypeEnum.APPLY.getCode());
        if (rowIndex == ColCfgPropEnum.SUMMARYDISPLAY.getRowIndex() - 1 && newValue instanceof Boolean && ((Boolean)newValue).booleanValue() && FormTypeEnum.APPLY == currentTabType && !BussPlanEntryPresetFieldsEnum.STATUS.getColKey().equals(name)) {
            String aggregate = null;
            if (applyTemplateColCfgEntities != null) {
                Optional<ApplyTemplateColCfgEntity> colCfgOptional = applyTemplateColCfgEntities.stream().filter(colCfg -> name.equals(colCfg.getColkey())).findFirst();
                aggregate = colCfgOptional.map(ApplyTemplateColCfgEntity::getAggregate).orElse(null);
            }
            if (aggregate == null || !ColCfgPropEnum.AGGREGATE.getValue().equals(aggregate)) {
                this.getModel().setValue(name, (Object)false, ColCfgPropEnum.SUMMARYDISPLAY.getRowIndex() - 1);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5fc5\u987b\u5148\u9009\u62e9\u3010\u662f\u5426\u805a\u5408\u3011\u624d\u80fd\u9009\u62e9\u3010\u5408\u8ba1\u884c\u663e\u793a\u3011\u3002", (String)"ApplyTemplateCfgPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void updateDimRangeModifyDate(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        String name = e.getProperty().getName();
        if (name.startsWith("entryentity_businessplan_") && !this.isTabSelected()) {
            this.getModel().setValue(BussPlanEntryPresetFieldsEnum.MODIFY_DATE.getColKey(), (Object)this.getCurrentDate(), rowIndex);
            this.getModel().setValue(BussPlanEntryPresetFieldsEnum.MODIFIER.getColKey(), (Object)this.getUserId(), rowIndex);
        }
    }

    private String getCurrentDate() {
        return DateTimeUtils.formatFromStr((String)(TimeServiceHelper.now() + ""));
    }

    private void handleAuditTrailProportionChange(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        String name = e.getProperty().getName();
        if (!(StringUtils.equals((String)name, (String)"split_audittrail") || StringUtils.equals((String)name, (String)"non_leaf_audittrail") || StringUtils.equals((String)name, (String)"leaf_audittrail"))) {
            return;
        }
        if (!(newValue instanceof DynamicObject)) {
            return;
        }
        String currentColKey = this.getPageCache().get("currentColKey");
        String currentColSelectedValue = this.getPageCache().get("currentColSelectedValue");
        if (!StringUtils.equals((String)"true", (String)currentColSelectedValue)) {
            return;
        }
        DynamicObject auditObj = (DynamicObject)newValue;
        long id = auditObj.getLong("id");
        String number = auditObj.getString("number");
        List<ApplyTemplateColCfgEntity> cacheColCfgByFormType = this.getCacheColCfgByFormType(this.getCurrentTabType());
        block0: for (ApplyTemplateColCfgEntity entity : cacheColCfgByFormType) {
            List atCfgEntities = entity.getAtCfgEntities();
            if (CollectionUtils.isEmpty((Collection)atCfgEntities) || !StringUtils.equals((String)currentColKey, (String)entity.getColkey())) continue;
            for (ApplyTemplateAtCfgEntity atCfgEntity : atCfgEntities) {
                if (StringUtils.equals((String)name, (String)"split_audittrail")) {
                    if (!StringUtils.equals((String)AuditTrailUseEnum.SPLIT_PROPORTION.getCode(), (String)atCfgEntity.getAuditTrailUse())) continue;
                    atCfgEntity.setAuditTrailMemId(Long.valueOf(id));
                    atCfgEntity.setAuditTrailMemNum(number);
                    continue block0;
                }
                if (StringUtils.equals((String)name, (String)"leaf_audittrail")) {
                    if (!StringUtils.equals((String)AuditTrailUseEnum.ADJUST_LEAF.getCode(), (String)atCfgEntity.getAuditTrailUse())) continue;
                    atCfgEntity.setAuditTrailMemId(Long.valueOf(id));
                    atCfgEntity.setAuditTrailMemNum(number);
                    continue block0;
                }
                if (!StringUtils.equals((String)name, (String)"non_leaf_audittrail") || !StringUtils.equals((String)AuditTrailUseEnum.ADJUST_NON_LEAF.getCode(), (String)atCfgEntity.getAuditTrailUse())) continue;
                atCfgEntity.setAuditTrailMemId(Long.valueOf(id));
                atCfgEntity.setAuditTrailMemNum(number);
                continue block0;
            }
        }
        this.cacheColCfgMap(this.getCurrentTabType(), cacheColCfgByFormType);
    }

    private void handleCheckCols() {
        Map<String, List<ApplyTemplateColCfgEntity>> cacheColCfg = this.getCacheColCfg();
        ColumnList columnList = ApplyTemplateUtils.getEntrycfgByApplyTemplateID((Long)this.getTemplateId());
        List<BaseColumn> baseColumns = this.getBaseColumns(columnList);
        for (Map.Entry<String, List<ApplyTemplateColCfgEntity>> mapEntry : cacheColCfg.entrySet()) {
            List<ApplyTemplateColCfgEntity> value = mapEntry.getValue();
            if (value.size() != baseColumns.size()) {
                log.info("handleCheckCols() ---- templateColum size:" + baseColumns.size() + ";setting size:" + value.size());
                throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u5217\u4e0e\u5f53\u524d\u914d\u7f6e\u5217\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u57fa\u7840\u8bbe\u7f6e\u9875\u9762\u8fdb\u884c\u914d\u7f6e\u3002", (String)"ApplyTemplateCfgPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            for (BaseColumn baseColumn : baseColumns) {
                boolean flag = false;
                for (ApplyTemplateColCfgEntity entity : value) {
                    String colkey = entity.getColkey();
                    if (!StringUtils.equals((String)colkey, (String)baseColumn.getKey())) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u5217\u5df2\u53d1\u751f\u53d8\u5316\u3002\u8bf7\u91cd\u65b0\u6253\u5f00\u57fa\u7840\u8bbe\u7f6e\u9875\u9762\u8fdb\u884c\u914d\u7f6e\u3002", (String)"ApplyTemplateCfgPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void checkDuplicateRows(boolean saveCheck) {
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_businessplan");
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity_businessplan");
        List items = entryGrid.getItems();
        Set<String> entryKeys = items.stream().filter(item -> !item.getKey().endsWith("_code") && !item.getKey().endsWith("_range") && !item.getKey().endsWith("_status") && !item.getKey().endsWith("_modifier") && !item.getKey().contains("_modifydate")).map(Control::getKey).collect(Collectors.toSet());
        ArrayList<DynamicObject> objectsWithSameProperties = new ArrayList<DynamicObject>(2);
        block0: for (int i = 0; i < entryEntity.size() - 1; ++i) {
            DynamicObject currentItem = (DynamicObject)entryEntity.get(i);
            for (int j = i + 1; j < entryEntity.size(); ++j) {
                DynamicObject otherItem = (DynamicObject)entryEntity.get(j);
                if (!ApplyTemplateCfgPlugin.hasSameProperties(currentItem, otherItem, entryKeys)) continue;
                objectsWithSameProperties.add(currentItem);
                objectsWithSameProperties.add(otherItem);
                continue block0;
            }
        }
        if (objectsWithSameProperties.size() > 0) {
            if (saveCheck) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u4e0e\u7b2c%2\u884c\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ApplyTemplateCfgPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[]{String.valueOf(((DynamicObject)objectsWithSameProperties.get(0)).getInt("seq")), String.valueOf(((DynamicObject)objectsWithSameProperties.get(1)).getInt("seq"))}));
            }
            this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u4e0e\u7b2c%2\u884c\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ApplyTemplateCfgPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[]{String.valueOf(((DynamicObject)objectsWithSameProperties.get(0)).getInt("seq")), String.valueOf(((DynamicObject)objectsWithSameProperties.get(1)).getInt("seq"))}));
        }
    }

    private static boolean hasSameProperties(DynamicObject item1, DynamicObject item2, Set<String> propertiesToCompare) {
        ArrayList<Boolean> booleanList = new ArrayList<Boolean>(16);
        for (String property : propertiesToCompare) {
            if (item1.get(property) != null && item2.get(property) != null) {
                Object value2;
                boolean isEqual;
                String value22;
                Object value1;
                if (BussPlanEntryPresetFieldsEnum.BUSINESSPLANSHEET.getColKey().equals(property)) {
                    value1 = (String)item1.get(property);
                    HashSet<String> businessPlanSet1 = new HashSet<String>(Arrays.asList(((String)value1).split(",")));
                    value22 = (String)item2.get(property);
                    HashSet<String> businessPlanSet2 = new HashSet<String>(Arrays.asList(value22.split(",")));
                    isEqual = businessPlanSet1.size() == businessPlanSet2.size() && businessPlanSet1.containsAll(businessPlanSet2);
                    booleanList.add(isEqual);
                    continue;
                }
                if (property.endsWith("_name")) {
                    value1 = (DynamicObjectCollection)item1.get(property);
                    HashSet basedataIds1 = new HashSet(16);
                    value1.forEach(s1 -> basedataIds1.add(s1.getLong("fbasedataid.id")));
                    value22 = (DynamicObjectCollection)item2.get(property);
                    HashSet basedataIds2 = new HashSet(16);
                    value22.forEach(s2 -> basedataIds2.add(s2.getLong("fbasedataid.id")));
                    isEqual = basedataIds1.size() == basedataIds2.size() && basedataIds1.containsAll(basedataIds2);
                    booleanList.add(isEqual);
                    continue;
                }
                value1 = item1.get(property);
                if (Objects.equals(value1, value2 = item2.get(property))) continue;
                booleanList.add(false);
                continue;
            }
            if (item1.get(property) == null && item2.get(property) == null) {
                booleanList.add(true);
                continue;
            }
            booleanList.add(false);
        }
        return !booleanList.contains(false);
    }

    public IModelCacheHelper getIModelCacheHelper() {
        if (this.modelCacheHelper == null) {
            this.modelCacheHelper = super.getIModelCacheHelper();
        }
        return this.modelCacheHelper;
    }

    private void handleColCheckPropChange(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        int rowIndex = changeSet[0].getRowIndex();
        String name = property.getName();
        if (name.startsWith("h_") && newValue instanceof Boolean && ((Boolean)newValue).booleanValue()) {
            this.singleCheck(name, rowIndex);
        }
    }

    private void singleCheck(String colName, int currentRowIndex) {
        ColCfgPropEnum[] values = ColCfgPropEnum.values();
        for (int i = 0; i < values.length - 2; ++i) {
            if (i == currentRowIndex || currentRowIndex == ColCfgPropEnum.AGGREGATE.getRowIndex() - 1 || currentRowIndex == ColCfgPropEnum.SUMMARYDISPLAY.getRowIndex() - 1) continue;
            this.getModel().setValue(colName, (Object)false, i);
        }
    }

    private void handlePanelDimPropChange(PropertyChangedArgs e) {
        this.handleBusinessPlanPanelDimPropChange(e);
        this.handleStatisticsPanelDimPropChange(e);
        this.handleDataInitDimPanelDimPropChange(e);
    }

    private void handleBusinessPlanPanelDimPropChange(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        String name = property.getName();
        if (name.startsWith("flexpanel_businessplan")) {
            if (!(newValue instanceof Boolean)) {
                return;
            }
            String dimId = name.replace(this.getPanelDimIdPrefix("flexpanel_businessplan"), "");
            if (((Boolean)newValue).booleanValue()) {
                this.cacheSelectedPanelDimId(IDUtils.toLong((Object)dimId), DimUseTypeEnum.BUSINESS_PLAN);
            } else {
                this.removeSelectedPanelDimId(IDUtils.toLong((Object)dimId), DimUseTypeEnum.BUSINESS_PLAN);
            }
            this.dynamicCreateEntryField();
        }
    }

    private void handleStatisticsPanelDimPropChange(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        String name = property.getName();
        if (name.startsWith("flexpanel_statistics")) {
            if (!(newValue instanceof Boolean)) {
                return;
            }
            String dimId = name.replace(this.getPanelDimIdPrefix("flexpanel_statistics"), "");
            if (((Boolean)newValue).booleanValue()) {
                this.cacheSelectedPanelDimId(IDUtils.toLong((Object)dimId), DimUseTypeEnum.STATISTICS);
            } else {
                this.removeSelectedPanelDimId(IDUtils.toLong((Object)dimId), DimUseTypeEnum.STATISTICS);
            }
        }
    }

    private void handleDataInitDimPanelDimPropChange(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        String name = property.getName();
        if (name.startsWith("flexpanel_init_dim")) {
            if (!(newValue instanceof Boolean)) {
                return;
            }
            String dimId = name.replace(this.getPanelDimIdPrefix("flexpanel_init_dim"), "");
            if (((Boolean)newValue).booleanValue()) {
                this.cacheSelectedDataInitPanelDimId(IDUtils.toLong((Object)dimId));
            } else {
                this.removeSelectedDataInitPanelDimId(IDUtils.toLong((Object)dimId));
            }
        }
    }

    private void handleTemplateColPropChange(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        int rowIndex = changeSet[0].getRowIndex();
        String name = property.getName();
        if (name.startsWith("h_") && newValue instanceof Boolean) {
            this.handleAuditValuePropChange(e);
            this.cacheCurrentColCfg(name, rowIndex, (Boolean)newValue);
            if (rowIndex == ColCfgPropEnum.AGGREGATE.getRowIndex() - 1 && FormTypeEnum.APPLY == this.getCurrentTabType()) {
                this.getModel().setValue(name, newValue, ColCfgPropEnum.SUMMARYDISPLAY.getRowIndex() - 1);
            }
            this.getPageCache().put("currentColKey", name);
            this.getPageCache().put("currentColSelectedValue", newValue.toString());
            this.getPageCache().put("notAuditTrailMember", String.valueOf(false));
        }
    }

    private void handleAuditValuePropChange(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        int rowIndex = changeSet[0].getRowIndex();
        String name = property.getName();
        if (ColCfgPropEnum.AGGREGATE.getRowIndex() == rowIndex + 1 || ColCfgPropEnum.SUMMARYDISPLAY.getRowIndex() == rowIndex + 1) {
            return;
        }
        if (((Boolean)newValue).booleanValue()) {
            this.setAuditTrailPropChange(rowIndex, name);
        } else {
            this.setAuditTrailValue(null, null, null);
            this.setCurrentColAuditTrailValue(null, "");
        }
    }

    private void setAuditTrailPropChange(int rowIndex, String name) {
        Object value = this.getModel().getValue(ColCfgPresetFieldsEnum.EDIT_TYPE.getKey(), rowIndex);
        if (!this.colIfNeedHandleAuditTrail(name)) {
            return;
        }
        if (value == null || !StringUtils.equals((String)value.toString(), (String)ColCfgPropEnum.WRITE.getDesc())) {
            return;
        }
        Map<String, String> hidePanelAuditTrail = this.getHidePanelAuditTrail();
        if (hidePanelAuditTrail != null && hidePanelAuditTrail.size() > 0) {
            String memberIdStr = hidePanelAuditTrail.get("memberId");
            String memberName = hidePanelAuditTrail.get("name");
            Long memberId = IDUtils.toLong((Object)memberIdStr);
            this.setCurrentColAuditTrailValue(memberId, memberName);
            this.setAuditTrailValue(memberId, memberId, memberId);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"audittrailpanel"});
            return;
        }
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        filter.and("number", "=", (Object)SysDimensionEnum.AuditTrail.getNumber());
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_dimension", (QFilter[])filter.toArray());
        long currentAuditTrailId = dynamicObject.getLong("id");
        List<DataMapDimension> auditTrailMaps = this.getAuditTrailMaps(name);
        if (CollectionUtils.isEmpty(auditTrailMaps)) {
            this.setAuditTrailValue(null, null, null);
            this.setCurrentColAuditTrailValue(null, "");
        } else {
            Member currentColAuditTrailMember = this.getAuditTrailFromCol(auditTrailMaps, currentAuditTrailId);
            if (currentColAuditTrailMember != null) {
                Long currentAuditMemId = currentColAuditTrailMember.getId();
                FormTypeEnum currentTabType = this.getCurrentTabType();
                if (FormTypeEnum.APPLY == currentTabType) {
                    if (!currentColAuditTrailMember.isLeaf()) {
                        this.getModel().setValue(name, (Object)false, rowIndex);
                        this.getPageCache().put("notAuditTrailMember", String.valueOf(true));
                        this.setAuditTrailValue(null, null, null);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u7533\u62a5\u73af\u8282\u8bfb\u5199\u5c5e\u6027\u7684\u5217\u7ebf\u7d22\u5fc5\u987b\u4e3a\u660e\u7ec6\u6210\u5458\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ApplyTemplateCfgPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    } else {
                        this.setCurrentColAuditTrailValue(currentAuditMemId, currentColAuditTrailMember.getName());
                    }
                } else {
                    Member currentMember = this.getIModelCacheHelper().getMember(SysDimensionEnum.AuditTrail.getNumber(), null, currentAuditMemId);
                    Member nonLeafAuditTrailMem = this.getNonLeafAuditTrailMem(currentAuditMemId);
                    Member leafAuditTrailMem = this.getLeafAuditTrailMem(currentAuditMemId);
                    Member splitProportionAuditTrailMem = this.getSplitProportionAuditTrailMem(currentAuditMemId);
                    this.setAuditTrailEnable(currentAuditMemId);
                    Long leafId = leafAuditTrailMem == null ? null : leafAuditTrailMem.getId();
                    Long nonLeafId = nonLeafAuditTrailMem == null ? null : nonLeafAuditTrailMem.getId();
                    Long splitId = splitProportionAuditTrailMem == null ? null : splitProportionAuditTrailMem.getId();
                    List<ApplyTemplateColCfgEntity> colCfg = this.getCacheColCfgByFormType(this.getCurrentTabType());
                    for (ApplyTemplateColCfgEntity entity : colCfg) {
                        List atCfgEntities;
                        if (!StringUtils.equals((String)entity.getColkey(), (String)name) || (atCfgEntities = entity.getAtCfgEntities()) == null) continue;
                        for (ApplyTemplateAtCfgEntity atCfgEntity : atCfgEntities) {
                            String auditTrailUse = atCfgEntity.getAuditTrailUse();
                            if (AuditTrailUseEnum.SPLIT_PROPORTION.getCode().equals(auditTrailUse)) {
                                if (currentMember != null && currentMember.isLeaf()) continue;
                                splitId = atCfgEntity.getAuditTrailMemId();
                                continue;
                            }
                            if (AuditTrailUseEnum.ADJUST_NON_LEAF.getCode().equals(auditTrailUse)) {
                                nonLeafId = atCfgEntity.getAuditTrailMemId();
                                continue;
                            }
                            if (!AuditTrailUseEnum.ADJUST_LEAF.getCode().equals(auditTrailUse)) continue;
                            leafId = atCfgEntity.getAuditTrailMemId();
                        }
                    }
                    this.setAuditTrailValue(leafId, nonLeafId, splitId);
                    this.setCurrentColAuditTrailValue(currentAuditMemId, currentColAuditTrailMember.getName());
                }
            }
        }
    }

    private void setAuditTrailEnable(Long currentAuditMemId) {
        Member member = this.getIModelCacheHelper().getMember(SysDimensionEnum.AuditTrail.getNumber(), null, currentAuditMemId);
        if (member != null && member.isLeaf()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"split_audittrail"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"leaf_audittrail", "non_leaf_audittrail", "split_audittrail"});
        }
    }

    private boolean colIfNeedHandleAuditTrail(String colKey) {
        List<BaseColumn> baseColumns = this.getBaseColumns(this.getColumnListFromParam());
        for (BaseColumn baseColumn : baseColumns) {
            if (!(baseColumn instanceof CalculateColumn) && !(baseColumn instanceof MeasureColumn) && !(baseColumn instanceof DimensionDataColumn) || !StringUtils.equals((String)colKey, (String)baseColumn.getKey())) continue;
            return true;
        }
        return false;
    }

    private void cacheCurrentColCfg(String colName, int rowIndex, boolean isCheck) {
        ArrayList<ApplyTemplateAtCfgEntity> atCfgEntities = new ArrayList<ApplyTemplateAtCfgEntity>(16);
        Object leafAuditTrial = this.getModel().getValue("leaf_audittrail");
        Object nonLeafAuditTrail = this.getModel().getValue("non_leaf_audittrail");
        ApplyTemplateAtCfgEntity applyTemplateAtCfgEntity1 = new ApplyTemplateAtCfgEntity();
        if (leafAuditTrial instanceof DynamicObject) {
            DynamicObject auditObj = (DynamicObject)leafAuditTrial;
            long auditTrailId = auditObj.getLong("id");
            String number = auditObj.getString("number");
            applyTemplateAtCfgEntity1.setAuditTrailMemId(Long.valueOf(auditTrailId));
            applyTemplateAtCfgEntity1.setAuditTrailMemNum(number);
        }
        applyTemplateAtCfgEntity1.setAuditTrailUse(AuditTrailUseEnum.ADJUST_LEAF.getCode());
        atCfgEntities.add(applyTemplateAtCfgEntity1);
        ApplyTemplateAtCfgEntity applyTemplateAtCfgEntity2 = new ApplyTemplateAtCfgEntity();
        if (nonLeafAuditTrail instanceof DynamicObject) {
            DynamicObject auditObj = (DynamicObject)nonLeafAuditTrail;
            long auditTrailId = auditObj.getLong("id");
            String number = auditObj.getString("number");
            applyTemplateAtCfgEntity2.setAuditTrailMemId(Long.valueOf(auditTrailId));
            applyTemplateAtCfgEntity2.setAuditTrailMemNum(number);
        }
        applyTemplateAtCfgEntity2.setAuditTrailUse(AuditTrailUseEnum.ADJUST_NON_LEAF.getCode());
        atCfgEntities.add(applyTemplateAtCfgEntity2);
        FormTypeEnum currentTabType = this.getCurrentTabType();
        if (currentTabType == null) {
            return;
        }
        Object splitAuditTrail = this.getModel().getValue("split_audittrail");
        ApplyTemplateAtCfgEntity applyTemplateAtCfgEntity = new ApplyTemplateAtCfgEntity();
        applyTemplateAtCfgEntity.setAuditTrailUse(AuditTrailUseEnum.SPLIT_PROPORTION.getCode());
        if (splitAuditTrail instanceof DynamicObject) {
            DynamicObject auditObj = (DynamicObject)splitAuditTrail;
            long auditTrailId = auditObj.getLong("id");
            String number = auditObj.getString("number");
            applyTemplateAtCfgEntity.setAuditTrailMemId(Long.valueOf(auditTrailId));
            applyTemplateAtCfgEntity.setAuditTrailMemNum(number);
        }
        atCfgEntities.add(applyTemplateAtCfgEntity);
        boolean b = this.colIfNeedHandleAuditTrail(colName);
        List<ApplyTemplateColCfgEntity> cacheColCfgByFormType = this.getCacheColCfgByFormType(currentTabType);
        for (ApplyTemplateColCfgEntity applyTemplateColCfgEntity : cacheColCfgByFormType) {
            if (!StringUtils.equals((String)colName, (String)applyTemplateColCfgEntity.getColkey())) continue;
            Object editTypeObj = this.getModel().getValue(ColCfgPresetFieldsEnum.EDIT_TYPE.getKey(), rowIndex);
            if (isCheck) {
                if (editTypeObj != null) {
                    String notAuditTrailMember;
                    String editTypeStr = editTypeObj.toString();
                    String valueByDesc = ColCfgPropEnum.getValueByDesc((String)editTypeStr);
                    if (FormTypeEnum.APPLY == currentTabType && "true".equals(notAuditTrailMember = this.getPageCache().get("notAuditTrailMember"))) {
                        valueByDesc = null;
                    }
                    if (rowIndex == ColCfgPropEnum.AGGREGATE.getRowIndex() - 1) {
                        applyTemplateColCfgEntity.setAggregate(valueByDesc);
                        break;
                    }
                    if (rowIndex == ColCfgPropEnum.SUMMARYDISPLAY.getRowIndex() - 1) {
                        if (FormTypeEnum.APPLY != currentTabType) break;
                        String aggregate = applyTemplateColCfgEntity.getAggregate();
                        if (!ColCfgPropEnum.AGGREGATE.getValue().equals(aggregate)) break;
                        applyTemplateColCfgEntity.setSummarydisplay(valueByDesc);
                        break;
                    }
                    applyTemplateColCfgEntity.setEdittype(valueByDesc);
                    if (ColCfgPropEnum.WRITE.getValue().equals(valueByDesc)) {
                        if (!b) break;
                        applyTemplateColCfgEntity.setAtCfgEntities(atCfgEntities);
                        break;
                    }
                    applyTemplateColCfgEntity.clearAtCfgEntities();
                    break;
                }
                applyTemplateColCfgEntity.clearAtCfgEntities();
                break;
            }
            if (rowIndex == ColCfgPropEnum.AGGREGATE.getRowIndex() - 1) {
                applyTemplateColCfgEntity.setAggregate(null);
            }
            if (rowIndex != ColCfgPropEnum.SUMMARYDISPLAY.getRowIndex() - 1) break;
            applyTemplateColCfgEntity.setSummarydisplay(null);
            break;
        }
        this.cacheColCfgMap(currentTabType, cacheColCfgByFormType);
    }

    private FormTypeEnum getCurrentTabType() {
        Tab control = (Tab)this.getControl("tab_billtype");
        String currentTab = control.getCurrentTab();
        for (FormTypeEnum value : FormTypeEnum.values()) {
            if (!StringUtils.equals((String)value.getTabCode(), (String)currentTab)) continue;
            return value;
        }
        return null;
    }

    private List<DataMapDimension> getAuditTrailMaps(String dimColKey) {
        ColumnList columnListFromParam = this.getColumnListFromParam();
        List<BaseColumn> baseColumns = this.getBaseColumns(columnListFromParam);
        for (BaseColumn baseColumn : baseColumns) {
            if (!StringUtils.equals((String)dimColKey, (String)baseColumn.getKey())) continue;
            if (baseColumn instanceof MeasureColumn) {
                MeasureColumn measureColumn = (MeasureColumn)baseColumn;
                return measureColumn.getDataMapDimensions();
            }
            if (baseColumn instanceof CalculateColumn) {
                CalculateColumn calculateColumn = (CalculateColumn)baseColumn;
                return calculateColumn.getDataMapDimensions();
            }
            if (!(baseColumn instanceof DimensionDataColumn)) break;
            DimensionDataColumn dimensionDataColumn = (DimensionDataColumn)baseColumn;
            return dimensionDataColumn.getDataMapDimensions();
        }
        return new ArrayList<DataMapDimension>(0);
    }

    private Member getAuditTrailFromCol(List<DataMapDimension> dataMapDimensions, long auditTrailId) {
        for (DataMapDimension dataMapDimension : dataMapDimensions) {
            long dimensionId = dataMapDimension.getDimensionId();
            long dimensionRememberId = dataMapDimension.getDimensionRememberId();
            if (auditTrailId != dimensionId) continue;
            return this.getIModelCacheHelper().getMember(SysDimensionEnum.AuditTrail.getNumber(), null, Long.valueOf(dimensionRememberId));
        }
        return null;
    }

    private void cacheSelectedPanelDimId(Long dimId, DimUseTypeEnum useTypeEnum) {
        HashMap<String, Set> cacheDimsMap = new HashMap<String, Set>(16);
        String cacheSelectedPanelDimIds = this.getPageCache().get("cache_dim_cfg_key");
        if (StringUtils.isNotEmpty((String)cacheSelectedPanelDimIds)) {
            Map cacheDimsMapTemp = (Map)SerializationUtils.fromJsonString((String)cacheSelectedPanelDimIds, Map.class);
            for (Map.Entry mapEntry : cacheDimsMapTemp.entrySet()) {
                String key = (String)mapEntry.getKey();
                List value = (List)mapEntry.getValue();
                cacheDimsMap.put(key, new HashSet(value));
            }
            Set dimIds = cacheDimsMap.computeIfAbsent(useTypeEnum.getValue(), t -> new HashSet(16));
            dimIds.add(dimId);
        } else {
            Set dimIds = cacheDimsMap.computeIfAbsent(useTypeEnum.getValue(), t -> new HashSet(16));
            dimIds.add(dimId);
        }
        this.getPageCache().put("cache_dim_cfg_key", SerializationUtils.toJsonString(cacheDimsMap));
    }

    private void removeSelectedPanelDimId(Long dimId, DimUseTypeEnum useTypeEnum) {
        Map cacheDimsMap;
        List dimIds;
        String cacheSelectedPanelDimIds = this.getPageCache().get("cache_dim_cfg_key");
        if (StringUtils.isNotEmpty((String)cacheSelectedPanelDimIds) && CollectionUtils.isNotEmpty((Collection)(dimIds = (List)(cacheDimsMap = (Map)SerializationUtils.fromJsonString((String)cacheSelectedPanelDimIds, Map.class)).get(useTypeEnum.getValue())))) {
            dimIds.remove(dimId);
            cacheDimsMap.put(useTypeEnum.getValue(), dimIds);
            this.getPageCache().put("cache_dim_cfg_key", SerializationUtils.toJsonString((Object)cacheDimsMap));
        }
    }

    private void cacheSelectedDataInitPanelDimId(Long dimId) {
        HashSet<Long> cacheDims = new HashSet<Long>(16);
        cacheDims.add(dimId);
        String cacheSelectedPanelDimIds = this.getPageCache().get("cache_data_init_dim_cfg_key");
        if (StringUtils.isNotEmpty((String)cacheSelectedPanelDimIds)) {
            Set cacheDimsMapTemp = (Set)SerializationUtils.fromJsonString((String)cacheSelectedPanelDimIds, Set.class);
            cacheDims.addAll(cacheDimsMapTemp);
        }
        this.getPageCache().put("cache_data_init_dim_cfg_key", SerializationUtils.toJsonString(cacheDims));
    }

    private void removeSelectedDataInitPanelDimId(Long dimId) {
        Set cacheDimsMap;
        String cacheSelectedPanelDimIds = this.getPageCache().get("cache_data_init_dim_cfg_key");
        if (StringUtils.isNotEmpty((String)cacheSelectedPanelDimIds) && CollectionUtils.isNotEmpty((Collection)(cacheDimsMap = (Set)SerializationUtils.fromJsonString((String)cacheSelectedPanelDimIds, Set.class)))) {
            cacheDimsMap.remove(dimId);
            this.getPageCache().put("cache_data_init_dim_cfg_key", SerializationUtils.toJsonString((Object)cacheDimsMap));
        }
    }

    private Map<String, Object> queryTemplateCfg() {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        List dimCfgListByTemplateId = ApplyTemplateDimCfgService.getInstance().getDimCfgListByTemplateId(this.getTemplateId().longValue());
        List colCfgListByTemplateId = ApplyTemplateColCfgService.getInstance().getColCfgListByTemplateIdFromDB(this.getTemplateId());
        ApplyTemplateTableCfgEntity tableCfgByTemplateId = ApplyTemplateTableCfgService.getInstance().getTableCfgByTemplateId(this.getTemplateId());
        result.put("dimCfg", dimCfgListByTemplateId);
        result.put("colCfg", colCfgListByTemplateId);
        result.put("tableCfg", tableCfgByTemplateId);
        return result;
    }

    @Override
    public Long getModelId() {
        Object modelIdObj = this.getView().getFormShowParameter().getCustomParam("modelId");
        if (modelIdObj != null && StringUtils.isNotEmpty((String)modelIdObj.toString())) {
            Long modelId = IDUtils.toLong((Object)modelIdObj.toString());
            this.getModel().setValue("model", (Object)modelId);
            return IDUtils.toLong((Object)modelId.toString());
        }
        return 0L;
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        String fieldKey = cellClickEvent.getFieldKey();
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        int clickEventRow = evt.getRow();
        Object mainBudgetInfoObject = this.getModel().getValue(BussPlanEntryPresetFieldsEnum.MAINBUDGETINFO.getColKey(), clickEventRow);
        if (mainBudgetInfoObject != null) {
            String mainBudgetInfo = (String)mainBudgetInfoObject;
            this.setBusinessPlanComboItems(mainBudgetInfo);
        }
    }

    private void setBusinessPlanComboItems(String mainBudgetInfo) {
        if (StringUtils.isNotEmpty((String)mainBudgetInfo)) {
            HashMap<String, List<BizTableConfig>> relationship = this.getRelationship();
            List<BizTableConfig> businessPlanList = relationship.get(mainBudgetInfo);
            ColumnList columnList = this.getColumnListFromParam();
            List bizTableConfigList = columnList.getBizTableConfigList();
            HashSet tableKeySet = new HashSet(16);
            if (businessPlanList != null) {
                businessPlanList.forEach(e -> tableKeySet.add(e.getTabKey()));
            }
            ArrayList<ComboItem> businessPlanSheetItems = new ArrayList<ComboItem>(10);
            for (BizTableConfig bizTableConfig : bizTableConfigList) {
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(bizTableConfig.getTabName()));
                comboItem.setValue(bizTableConfig.getTabKey());
                if (tableKeySet != null && !tableKeySet.contains(bizTableConfig.getTabKey())) {
                    comboItem.setItemVisible(false);
                }
                businessPlanSheetItems.add(comboItem);
            }
            ComboEdit comboEdit = (ComboEdit)this.getControl(BussPlanEntryPresetFieldsEnum.BUSINESSPLANSHEET.getColKey());
            comboEdit.setComboItems(businessPlanSheetItems);
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    private Set<Long> getCacheSelectedDataInitPanelDimIds() {
        String cacheSelectedPanelDimIdsStr = this.getPageCache().get("cache_data_init_dim_cfg_key");
        if (StringUtils.isEmpty((String)cacheSelectedPanelDimIdsStr)) {
            return new HashSet<Long>(0);
        }
        return (Set)SerializationUtils.fromJsonString((String)cacheSelectedPanelDimIdsStr, Set.class);
    }
}

