/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applytemplate.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.applyTemplate.entity.ApplyTemplateDimCfgEntity;
import kd.epm.eb.common.applyTemplate.entity.dto.DimRangeImportTemplate;
import kd.epm.eb.common.applyTemplate.entity.tableconfig.BizTableConfig;
import kd.epm.eb.common.applyTemplate.helper.ExcelHelper;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.applybill.fileImport.BgApplyBillImportBasePlugin;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ApplyTemplateDimRangeImportPlugin
extends BgApplyBillImportBasePlugin {
    private static final Log log = LogFactory.getLog(ApplyTemplateDimRangeImportPlugin.class);

    private Map<String, Long> getDimensionViewIdMap() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object viewIdsObj = customParams.get("viewIds");
        if (viewIdsObj != null) {
            return (Map)SerializationUtils.deSerializeFromBase64((String)viewIdsObj.toString());
        }
        return new HashMap<String, Long>(16);
    }

    private Long getBusModelId() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object busModelIdObj = customParams.get("busModelId");
        if (busModelIdObj != null) {
            return IDUtils.toLong((Object)busModelIdObj.toString());
        }
        return 0L;
    }

    private List<ApplyTemplateDimCfgEntity> getDimCfgList() {
        List<Object> result = new ArrayList<ApplyTemplateDimCfgEntity>(16);
        Object dimCfgListObj = this.getView().getFormShowParameter().getCustomParam("dimCfgList");
        if (dimCfgListObj != null) {
            result = (List)SerializationUtils.deSerializeFromBase64((String)dimCfgListObj.toString());
        }
        return result;
    }

    @Override
    public void downLoadTemplate() {
        List<ApplyTemplateDimCfgEntity> dimCfgList = this.getDimCfgList();
        HashMap<String, List<BizTableConfig>> relationshipCorrespondence = this.getRelationship();
        HashMap<String, String> hcolumnkeyMap = this.gethcolumnkeyMap();
        DimRangeImportTemplate importTemplate = ExcelHelper.createImportTemplateNew(dimCfgList, relationshipCorrespondence, hcolumnkeyMap);
        XSSFWorkbook xssfWorkBook = ExcelHelper.createExportXssfWorkNew((DimRangeImportTemplate)importTemplate, hcolumnkeyMap);
        try {
            ExcelHelper.downloadExcel((XSSFWorkbook)xssfWorkBook, (String)importTemplate.getFileName(), (IFormView)this.getView());
        }
        catch (IOException e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadResFormat((String)"\u4e0b\u8f7d\u6a21\u677f\u53d1\u751f\u5f02\u5e38\uff1a%1\u3002", (String)"ApplyTemplateDimRangeImportPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[]{ThrowableHelper.toString((Exception)e)}));
        }
    }

    private HashMap<String, String> gethcolumnkeyMap() {
        HashMap hcolumnkeyMap = new HashMap(16);
        Object hcolumnkeyMapObj = this.getView().getFormShowParameter().getCustomParam("hcolumnkeyMap");
        if (hcolumnkeyMapObj != null) {
            hcolumnkeyMap = (HashMap)SerializationUtils.deSerializeFromBase64((String)hcolumnkeyMapObj.toString());
        }
        return hcolumnkeyMap;
    }

    private HashMap<String, List<BizTableConfig>> getRelationship() {
        HashMap relationship = new HashMap(16);
        Object dimCfgListObj = this.getView().getFormShowParameter().getCustomParam("relationship");
        if (dimCfgListObj != null) {
            relationship = (HashMap)SerializationUtils.deSerializeFromBase64((String)dimCfgListObj.toString());
        }
        return relationship;
    }

    @Override
    public void importFileData(InputStream inputStream) {
        XSSFWorkbook workbook = this.getWorkBook(inputStream);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        ArrayList returnDataToParent = new ArrayList(16);
        List<ApplyTemplateDimCfgEntity> dimCfgList = this.getDimCfgList();
        DimRangeImportTemplate importTemplate = ExcelHelper.createImportTemplate(dimCfgList);
        List headerMapList = importTemplate.getHeaderMapList();
        long count = headerMapList.stream().filter(e -> StringUtils.isNotEmpty((String)((String)e.get("number"))) || ResManager.loadKDString((String)"*\u72b6\u6001", (String)"ApplyTemplateDimRangeImportPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]).equals(e.get("value"))).count() + 2L;
        HashSet<String> importSet = new HashSet<String>(16);
        XSSFSheet sheetAt = workbook.getSheetAt(0);
        int lastRowNum = sheetAt.getLastRowNum();
        Map<String, Long> dimensionViewIdMap = this.getDimensionViewIdMap();
        HashMap<String, List<BizTableConfig>> relationshipMap = this.getRelationship();
        HashSet<String> bizNumSet = new HashSet<String>(16);
        for (List<BizTableConfig> innerList : relationshipMap.values()) {
            for (BizTableConfig inner : innerList) {
                bizNumSet.add(inner.getTabNumber());
            }
        }
        Long busModelId = this.getBusModelId();
        for (int i = 3; i <= lastRowNum; ++i) {
            XSSFRow xssfRow = ExcelHelper.createXssfRow((XSSFSheet)sheetAt, (int)i);
            ArrayList rowData = new ArrayList(16);
            block3: for (Map map : headerMapList) {
                HashMap<String, String> entity = new HashMap<String, String>(16);
                String number = (String)map.get("number");
                String colIndexStr = (String)map.get("colIndex");
                String rowIndexStr = (String)map.get("rowIndex");
                String id = (String)map.get("id");
                int colIndex = Integer.parseInt(colIndexStr);
                int rowIndex = Integer.parseInt(rowIndexStr);
                XSSFCell xssfCell = ExcelHelper.createXssfCell((XSSFRow)xssfRow, (int)colIndex);
                String value = ExcelHelper.convertCellValueToString((Cell)xssfCell);
                if (colIndex == 0 && rowIndex != 1) {
                    if (value != null && !"".equals(value.toString())) {
                        int startIndex = value.toString().indexOf("[");
                        int endIndex = value.toString().indexOf("]");
                        if (startIndex != -1 && endIndex != -1 && endIndex > startIndex) {
                            String extractedValue = value.toString().substring(startIndex + 1, endIndex);
                            HashMap<String, String> hcolumnkeyMap = this.gethcolumnkeyMap();
                            if (hcolumnkeyMap.get(extractedValue) == null) {
                                this.recordErrorInfo(sheetAt, xssfRow, ResManager.loadResFormat((String)"\u4e3b\u8868\u9884\u7b97\u4fe1\u606f\u5217%1\u4e0d\u5b58\u5728\uff0c\u8bf7\u4e0b\u8f7d\u6a21\u677f\u67e5\u770b\u3002", (String)"ApplyTemplateDimRangeImportPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[]{value}));
                            } else {
                                entity.put("mainbudgetinfo", extractedValue);
                                rowData.add(entity);
                            }
                        }
                    } else {
                        this.recordErrorInfo(sheetAt, xssfRow, ResManager.loadKDString((String)"\u4e3b\u8868\u9884\u7b97\u4fe1\u606f\u5217\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApplyTemplateDimRangeImportPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                }
                if (colIndex == 1) {
                    if (value != null && !"".equals(value.toString())) {
                        String[] businessPlanArray = value.toString().split(",");
                        if (!bizNumSet.containsAll(Arrays.asList(businessPlanArray))) {
                            this.recordErrorInfo(sheetAt, xssfRow, ResManager.loadKDString((String)"\u4e1a\u52a1\u8ba1\u5212\u8868\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"ApplyTemplateDimRangeImportPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        } else {
                            entity.put("businessplansheet", value.toString());
                            rowData.add(entity);
                        }
                    } else {
                        this.recordErrorInfo(sheetAt, xssfRow, ResManager.loadKDString((String)"\u4e1a\u52a1\u8ba1\u5212\u8868\u5217\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApplyTemplateDimRangeImportPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                }
                if (colIndex == importTemplate.getMaxCol()) {
                    if (value != null && !"".equals(value.toString())) {
                        entity.put("status", value.toString());
                        rowData.add(entity);
                    } else {
                        this.recordErrorInfo(sheetAt, xssfRow, ResManager.loadKDString((String)"\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (String)"ApplyTemplateDimRangeImportPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                }
                if (!StringUtils.isNotEmpty((String)number)) continue;
                if (value != null && !"".equals(value.toString())) {
                    String[] memberNumberArray;
                    String memberNumberStr = value.toString();
                    for (String memberNumber : memberNumberArray = memberNumberStr.split(",")) {
                        Member member;
                        Long viewId = dimensionViewIdMap.get(number);
                        if (IDUtils.isEmptyLong((Long)viewId).booleanValue()) {
                            viewId = 0L;
                        }
                        if ((member = modelCacheHelper.getMember(number, viewId, memberNumber)) != null) {
                            Set permMembIds = DimMembPermHelper.getPermMembIds((String)number, (Long)this.getModelId(), (Long)busModelId, null, (DimMembPermType)DimMembPermType.READ, (boolean)true);
                            if (permMembIds == null || permMembIds.contains(member.getId())) continue;
                            this.recordErrorInfo(sheetAt, xssfRow, ResManager.loadResFormat((String)"\u7ef4\u5ea6\u7f16\u7801[%1]\u7684\u6210\u5458[%2]\u6ca1\u6709\u8bfb\u53d6\u6743\u9650\u3002", (String)"ApplyTemplateDimRangeImportPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[]{number, memberNumber}));
                            continue block3;
                        }
                        this.recordErrorInfo(sheetAt, xssfRow, ResManager.loadResFormat((String)"\u7ef4\u5ea6\u7f16\u7801\u201c%1\u201d\u7684\u6210\u5458\u201c%2\u201d\u4e0d\u5b58\u5728\u3002", (String)"ApplyTemplateDimRangeImportPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{number, memberNumber}));
                        continue block3;
                    }
                    entity.put("dimNumber", number);
                    entity.put("dimId", id);
                    entity.put("memberNum", memberNumberStr);
                    rowData.add(entity);
                    continue;
                }
                this.recordErrorInfo(sheetAt, xssfRow, ResManager.loadResFormat((String)"\u7ef4\u5ea6\u7f16\u7801\u201c%1\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApplyTemplateDimRangeImportPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{number}));
            }
            if ((long)rowData.size() != count) continue;
            String dimString = rowData.stream().filter(e -> StringUtils.isNotEmpty((String)((String)e.get("memberNum"))) || StringUtils.isNotEmpty((String)((String)e.get("mainbudgetinfo"))) || StringUtils.isNotEmpty((String)((String)e.get("businessplansheet")))).map(e -> (String)e.get("memberNum") + "|" + (String)e.get("mainbudgetinfo") + "|" + (String)e.get("businessplansheet")).collect(Collectors.joining(";"));
            if (importSet.contains(dimString)) {
                this.recordErrorInfo(sheetAt, xssfRow, ResManager.loadKDString((String)"\u8be5\u884c\u6570\u636e\u4e0e\u5176\u4ed6\u5f85\u5bfc\u5165\u7684\u6570\u636e\u51b2\u7a81\u3002", (String)"ApplyTemplateDimRangeImportPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            returnDataToParent.add(rowData);
            importSet.add(dimString);
        }
        boolean isAllErr = this.isAllError(importSet);
        String errFileName = ResManager.loadKDString((String)"\u5173\u8054\u4e1a\u52a1\u8ba1\u5212-\u5bfc\u5165\u6570\u636e\u9519\u8bef\u8be6\u60c5", (String)"ApplyTemplateDimRangeImportPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        if (isAllErr) {
            this.downLoadFailFile(errFileName, true);
        } else {
            HashMap<String, Serializable> retData = new HashMap<String, Serializable>(16);
            retData.put("status", Boolean.valueOf(importSet.size() == lastRowNum - 2));
            retData.put("retData", returnDataToParent);
            if (this.errorBook.getNumberOfSheets() != 0) {
                this.downLoadFailFile(errFileName, false);
            }
            this.getView().returnDataToParent(retData);
            this.getView().close();
        }
    }

    private boolean isAllError(Set<String> importSet) {
        return this.errorBook.getNumberOfSheets() != 0 && importSet.size() == 0;
    }

    @Override
    protected Pair<Integer, Integer> getTitleRow() {
        return new Pair((Object)2, (Object)2);
    }
}

