/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applytemplate.config;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.events.AfterMoveEntryEventArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.MoveEntryDown;
import kd.bos.form.operate.MoveEntryUp;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.ColumnList;
import kd.epm.eb.common.enums.ApplyDimAreaPanelEnum;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.collections4.CollectionUtils;

public class ApplyTemplateSortCfgPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String KEY_BUTTON_CANCEL = "btncancel";
    private static final String KEY_BUTTON_CONFIRM = "btnconfirm";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_BUTTON_CANCEL, KEY_BUTTON_CONFIRM});
        EntryGrid entryGrid = (EntryGrid)this.getControl("treeentryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        List<BaseColumn> baseColumns = this.getBaseColumns();
        this.sortColumnList(baseColumns);
        if (CollectionUtils.isEmpty(baseColumns)) {
            return;
        }
        this.setEntityTreeData(baseColumns);
        this.updateColumnListSort();
    }

    private void setEntityTreeData(List<BaseColumn> baseColumns) {
        this.getModel().deleteEntryData("treeentryentity");
        HashMap<String, BaseColumn> baseColumnMapBase = new HashMap<String, BaseColumn>(16);
        for (BaseColumn baseColumn : baseColumns) {
            baseColumnMapBase.put(baseColumn.getKey(), baseColumn);
        }
        Map<String, Set<String>> groupTitleMap = this.getGroupTitleMap();
        HashMap<String, Object> baseColumnMap = new HashMap<String, Object>(16);
        ArrayList<Object> newBaseColumns = new ArrayList<Object>(16);
        for (BaseColumn baseColumn : baseColumns) {
            if (baseColumnMap.get(baseColumn.getKey()) != null) continue;
            baseColumnMap.put(baseColumn.getKey(), baseColumn);
            newBaseColumns.add(baseColumn);
            Set<String> colKeys = groupTitleMap.get(baseColumn.getGrouptitle());
            if (CollectionUtils.isEmpty(colKeys)) continue;
            for (String colKey : colKeys) {
                if (baseColumnMap.get(colKey) != null) continue;
                baseColumnMap.put(colKey, baseColumnMapBase.get(colKey));
                newBaseColumns.add(baseColumnMapBase.get(colKey));
            }
        }
        HashMap<String, Long> Sites = new HashMap<String, Long>(16);
        for (int i = 0; i < newBaseColumns.size(); ++i) {
            BaseColumn baseColumn = (BaseColumn)newBaseColumns.get(i);
            int sortNum = i + 1;
            baseColumn.setSort(sortNum);
            String grouptitle = baseColumn.getGrouptitle();
            this.setentitydata(Sites, grouptitle, baseColumn, sortNum);
        }
    }

    private void setentitydata(Map<String, Long> sites, String grouptitle, BaseColumn baseColumn, int sortNum) {
        if (grouptitle != null && !grouptitle.equals("")) {
            this.setrootdata(sites, grouptitle);
        }
        int treeentryentity = this.getModel().createNewEntryRow("treeentryentity");
        Long id = 0L;
        this.getModel().setValue("newfieldname", (Object)baseColumn.getTitle(), treeentryentity);
        this.getModel().setValue("newfieldkey", (Object)baseColumn.getKey(), treeentryentity);
        this.getModel().setValue("newsortnumber", (Object)sortNum, treeentryentity);
        this.getModel().setValue("newgrouptitle", (Object)baseColumn.getGrouptitle(), treeentryentity);
        if (sites.get(baseColumn.getGrouptitle()) != null) {
            id = sites.get(baseColumn.getGrouptitle());
            this.getModel().setValue("newfieldname", (Object)baseColumn.getTitle(), treeentryentity);
        }
        this.getModel().setValue("pid", (Object)id, treeentryentity);
        Long random = DB.genGlobalLongId();
        this.getModel().setValue("id", (Object)random, treeentryentity);
    }

    private void setrootdata(Map<String, Long> sites, String grouptitle) {
        Set<String> keySet = sites.keySet();
        if (!keySet.contains(grouptitle)) {
            Long random = DB.genGlobalLongId();
            int treeentryentity = this.getModel().createNewEntryRow("treeentryentity");
            this.getModel().setValue("newfieldname", (Object)grouptitle, treeentryentity);
            this.getModel().setValue("id", (Object)random, treeentryentity);
            this.getModel().setValue("pid", (Object)0);
            sites.put(grouptitle, random);
        }
    }

    private Map<String, Set<String>> getGroupTitleMap() {
        List<BaseColumn> baseColumns = this.getBaseColumns();
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(16);
        for (BaseColumn baseColumn : baseColumns) {
            if (StringUtils.isEmpty((CharSequence)baseColumn.getGrouptitle())) continue;
            Set colKeys = result.computeIfAbsent(baseColumn.getGrouptitle(), t -> new LinkedHashSet(16));
            colKeys.add(baseColumn.getKey());
        }
        return result;
    }

    private void sortColumnList(List<BaseColumn> columns) {
        columns.sort(Comparator.comparingInt(BaseColumn::getSort));
    }

    private List<BaseColumn> getBaseColumns() {
        String type = this.getTypeFromParam();
        ColumnList columnList = this.getColumnListFromParam();
        ArrayList baseColumns = new ArrayList(Objects.requireNonNull(columnList).getColumns());
        if (StringUtils.equals((CharSequence)type, (CharSequence)ApplyDimAreaPanelEnum.MAIN.getNumber())) {
            String category = ApplyDimAreaPanelEnum.MAIN.getColumnCategory();
            return baseColumns.stream().filter(t -> category.equals(t.getCategory())).collect(Collectors.toList());
        }
        String curBizTabKey = this.getCurBizTabKey();
        String category = ApplyDimAreaPanelEnum.BIZ.getColumnCategory();
        return baseColumns.stream().filter(t -> category.equals(t.getCategory()) && StringUtils.equals((CharSequence)curBizTabKey, (CharSequence)t.getBizPlanTabKey())).collect(Collectors.toList());
    }

    private String getCurBizTabKey() {
        return (String)this.getView().getFormShowParameter().getCustomParam("curBizTabKey");
    }

    private String getTypeFromParam() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object type = customParams.get("type");
        return type == null ? "" : type.toString();
    }

    private ColumnList getColumnListFromParam() {
        String columnListStr = this.getPageCache().get("columnList");
        if (StringUtils.isNotEmpty((CharSequence)columnListStr)) {
            return (ColumnList)SerializationUtils.fromJsonString((String)columnListStr, ColumnList.class);
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object columnListObj = customParams.get("columnList");
        if (columnListObj != null) {
            ColumnList columnList = (ColumnList)SerializationUtils.fromJsonString((String)columnListObj.toString(), ColumnList.class);
            this.getPageCache().put("columnList", SerializationUtils.toJsonString((Object)columnList));
            return columnList;
        }
        return null;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate abstractOperate = (AbstractOperate)args.getSource();
        String operateKey = abstractOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"settop")) {
            this.setRootTop();
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"setbottom")) {
            this.setRootBottom();
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"moveentryup") && this.checkIsMove()) {
            args.setCancel(true);
        }
    }

    private boolean checkIsMove() {
        int parentIndex;
        int[] selectRow;
        EntryGrid entryGrid = (EntryGrid)this.getControl("treeentryentity");
        DynamicObject[] dataentity = entryGrid.getEntryData().getDataEntitys();
        DynamicObject object = dataentity[(selectRow = entryGrid.getSelectRows())[0]];
        Object pid = object.get("pid");
        return Long.parseLong(pid.toString()) != 0L && (parentIndex = this.getparentindex(dataentity, Long.parseLong(pid.toString()))) + 1 == selectRow[0];
    }

    private void setRootBottom() {
        int[] selectRows;
        EntryGrid entryGrid = (EntryGrid)this.getControl("treeentryentity");
        DynamicObject[] dataentity = entryGrid.getEntryData().getDataEntitys();
        for (int selectRow : selectRows = entryGrid.getSelectRows()) {
            int[] selectRows1;
            DynamicObject object = dataentity[selectRow];
            Object pid = object.get("pid");
            Object id = object.get("id");
            int size = 0;
            int dataentitysize = dataentity.length;
            if (Long.parseLong(pid.toString()) == 0L) {
                int groupSize = this.getsize(dataentity, Long.parseLong(id.toString()));
                size = dataentity.length - groupSize - selectRow - 1;
            } else {
                int parentIndex = this.getparentindex(dataentity, Long.parseLong(pid.toString()));
                int groupSize = this.getsize(dataentity, Long.parseLong(pid.toString()));
                size = groupSize + parentIndex - selectRow;
            }
            for (int x = 0; x < size && (selectRows1 = entryGrid.getSelectRows())[0] != dataentitysize - 1; ++x) {
                this.moveEntryDown();
            }
        }
    }

    private void setRootTop() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("treeentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObject[] dataentity = entryGrid.getEntryData().getDataEntitys();
        for (int selectRow : selectRows) {
            int[] selectRows1;
            Object pid = dataentity[selectRow].get("pid");
            int size = 0;
            if (Long.parseLong(pid.toString()) == 0L) {
                size = selectRow;
            } else {
                int parentIndex = this.getparentindex(dataentity, Long.parseLong(pid.toString()));
                size = selectRow - parentIndex - 1;
            }
            for (int x = 0; x < size && (selectRows1 = entryGrid.getSelectRows())[0] != 0; ++x) {
                this.moveEntryUp();
            }
        }
    }

    private int getparentindex(DynamicObject[] dataentity, Long pid) {
        int i = 0;
        for (DynamicObject dynamicObject : dataentity) {
            Object parent = dynamicObject.get("id");
            if (Long.parseLong(parent.toString()) == pid) {
                return i;
            }
            ++i;
        }
        return i;
    }

    private int getsize(DynamicObject[] dataentity, Long pid) {
        int i = 0;
        for (DynamicObject dynamicObject : dataentity) {
            Object parent = dynamicObject.get("pid");
            long rowPid = Long.parseLong(parent.toString());
            if (!IDUtils.isNotEmptyLong((Long)rowPid).booleanValue() || !IDUtils.equals((Object)rowPid, (Object)pid)) continue;
            ++i;
        }
        return i;
    }

    public void entryRowClick(RowClickEvent evt) {
    }

    public void afterMoveEntryUp(AfterMoveEntryEventArgs e) {
        super.afterMoveEntryUp(e);
        this.updateColumnListSort();
    }

    private void moveEntryUp() {
        MoveEntryUp moveEntryUp = new MoveEntryUp();
        HashMap<String, String> parameter = new HashMap<String, String>(16);
        parameter.put("entryId", "treeentryentity");
        moveEntryUp.setParameter(parameter);
        moveEntryUp.setView(this.getView());
        moveEntryUp.invokeOperation();
    }

    private void moveEntryDown() {
        MoveEntryDown moveEntryDown = new MoveEntryDown();
        HashMap<String, String> parameter = new HashMap<String, String>(16);
        parameter.put("entryId", "treeentryentity");
        moveEntryDown.setParameter(parameter);
        moveEntryDown.setView(this.getView());
        moveEntryDown.invokeOperation();
    }

    public void afterSetEntryBottom(AfterMoveEntryEventArgs e) {
        super.afterMoveEntryUp(e);
        this.updateColumnListSort();
    }

    public void afterSetEntryTop(AfterMoveEntryEventArgs e) {
        super.afterMoveEntryUp(e);
        this.updateColumnListSort();
    }

    public void afterMoveEntryDown(AfterMoveEntryEventArgs e) {
        super.afterMoveEntryDown(e);
        this.updateColumnListSort();
    }

    private void updateColumnListSort() {
        ColumnList columnList = this.getColumnListFromParam();
        ArrayList baseColumns = new ArrayList(Objects.requireNonNull(columnList).getColumns());
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("treeentryentity");
        for (int i = 0; i < entryentity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryentity.get(i);
            Object seq = dynamicObject.get("seq");
            int sortNum = Integer.parseInt(seq.toString());
            this.getModel().setValue("newsortnumber", (Object)sortNum, i);
            Object fieldKey = dynamicObject.get("newfieldkey");
            for (BaseColumn baseColumn : baseColumns) {
                String key = baseColumn.getKey();
                if (!StringUtils.equals((CharSequence)key, (CharSequence)fieldKey.toString())) continue;
                baseColumn.setSort(sortNum);
            }
        }
        if (CollectionUtils.isNotEmpty(baseColumns)) {
            columnList.setColumns(baseColumns);
            this.getPageCache().put("columnList", SerializationUtils.toJsonString((Object)columnList));
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)KEY_BUTTON_CONFIRM)) {
            this.getView().returnDataToParent((Object)this.getColumnListFromParam());
            this.getView().close();
        }
    }
}

