/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applytemplate.config;

import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.AfterMoveEntryEventArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEventListener;
import kd.epm.eb.common.applyTemplate.entity.tableconfig.BizTableConfig;
import kd.epm.eb.common.applytemplatecolumn.ColumnList;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class ApplyTemplateTabSortPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String KEY_BUTTON_CANCEL = "btncancel";
    private static final String KEY_BUTTON_CONFIRM = "btnok";
    private static final String KEY_ENTRYENTITY = "entryentity";

    @Override
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_BUTTON_CANCEL, KEY_BUTTON_CONFIRM});
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        List bizTableConfigList = this.getColumnList().getBizTableConfigList();
        this.sortBizTableList(bizTableConfigList);
        this.setDataEntity(bizTableConfigList);
    }

    private void setDataEntity(List<BizTableConfig> bizTableConfigList) {
        for (BizTableConfig bizTableConfig : bizTableConfigList) {
            int addNew = this.getModel().createNewEntryRow(KEY_ENTRYENTITY);
            this.getModel().setValue("name", (Object)bizTableConfig.getTabName(), addNew);
            this.getModel().setValue("number", (Object)bizTableConfig.getTabNumber(), addNew);
            this.getModel().setValue("sort", (Object)(addNew + 1), addNew);
        }
    }

    public void afterMoveEntryDown(AfterMoveEntryEventArgs e) {
        super.afterMoveEntryDown(e);
        this.updateEntitySort();
    }

    public void afterMoveEntryUp(AfterMoveEntryEventArgs e) {
        super.afterMoveEntryUp(e);
        this.updateEntitySort();
    }

    private void updateEntitySort() {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        for (int i = 0; i < entryentity.size(); ++i) {
            this.getModel().setValue("sort", (Object)(i + 1), i);
        }
    }

    private ColumnList getColumnList() {
        return (ColumnList)SerializationUtils.fromJsonString((String)((String)this.getFormCustomParam("columnList")), ColumnList.class);
    }

    private void setColumnList(ColumnList columnList) {
        this.getPageCache().put("columnList", SerializationUtils.toJsonString((Object)columnList));
    }

    private ColumnList getColumnInfo() {
        return (ColumnList)SerializationUtils.fromJsonString((String)this.getPageCache().get("columnList"), ColumnList.class);
    }

    private void sortBizTableList(List<BizTableConfig> bizTableConfigList) {
        bizTableConfigList.sort(Comparator.comparingInt(bizTableConfig -> bizTableConfig.getSort()));
    }

    private void setBizTabSort() {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        ColumnList columnList = this.getColumnList();
        List bizTableConfigList = columnList.getBizTableConfigList();
        for (DynamicObject dynamicObject : entryentity) {
            Optional<BizTableConfig> bizTable = bizTableConfigList.stream().filter(e -> e.getTabNumber().equals(dynamicObject.getString("number"))).findFirst();
            if (!bizTable.isPresent()) continue;
            BizTableConfig bizTableConfig = bizTable.get();
            bizTableConfig.setSort(dynamicObject.getInt("sort"));
        }
        this.sortBizTableList(bizTableConfigList);
        columnList.setBizTableConfigList(bizTableConfigList);
        this.setColumnList(columnList);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)KEY_BUTTON_CONFIRM)) {
            this.setBizTabSort();
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)this.getColumnInfo()));
            this.getView().close();
        }
    }
}

