/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.approveBill;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.OperateOptionPrivate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Image;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.task.TaskUtils;
import kd.bos.workflow.taskcenter.plugin.ApprovalPageAddSignPlugin;
import kd.bos.workflow.taskcenter.plugin.ApprovalPagePluginNew;
import kd.epm.eb.business.approveBill.helper.ApproveBillSubmitHelper;
import kd.epm.eb.business.approvetype.ApproveUtils;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.approveBill.Entity.CentralBillType;
import kd.epm.eb.common.enums.ApproveDecisionEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.params.ParamEnum;
import kd.epm.eb.common.params.ParamQueryServiceHelper;
import kd.epm.eb.common.reportprocess.helper.ApproveBillHelper;
import kd.epm.eb.common.utils.ApproveBill.ApproveTempPojo;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.adminmode.utils.AdminModelUtil;
import kd.epm.eb.formplugin.approveBill.ApproveBillShowRptBGM;
import kd.epm.eb.formplugin.approveBill.ApproveCommon;
import kd.epm.eb.formplugin.approveBill.ApproveOptimization;
import kd.epm.eb.formplugin.centralaudit.CentralOptimization;
import kd.epm.eb.formplugin.task.command.IBgTaskExecutePlugin;
import kd.epm.eb.formplugin.versionconstrast.VersionConstrastExportHelper;
import org.apache.commons.collections4.CollectionUtils;

public class ApproveBillEditPlugin
extends AbstractBasePlugin
implements ClickListener,
BeforeF7SelectListener {
    protected static final String CON_CTL_DIMORG = "dim_entity";
    private static final String CON_CTL_DIMDATATYPE = "dim_datatype";
    private static final String CON_CTL_EBORG = "eborgid";
    protected static final String CON_CTL_DIMENSTIONJSON = "dimensionjson";
    private static final String CON_CTL_CREATERID = "createrid";
    private static final String CON_CTL_BTNSAVE = "bnt_save";
    private static final String CON_CTL_BTNSUBMIT = "btn_submit";
    private static final String CON_CTL_BTNAUDIT = "btn_audit";
    private static final String CON_CTL_BTNCANCEL = "btn_cancel";
    private static final String SPLITCONTAINERAP = "splitcontainerap";
    private static final String SPLITPANELAP = "splitpanelap";
    private static final String CON_NUMBER = "number";
    private static final String CON_CACHE_DATATYPE = "cachedatatype";
    private static final String CON_CACHE_RETURNDATA = "returnDataMessage";
    protected static final String CON_LANGEUAGE = "epm-eb-formplugin";
    protected static final String ENTRYENTITY = "entryentity";
    protected static final String CON_MODEL = "modelId";

    @Override
    public boolean isCheckModel() {
        return true;
    }

    @Override
    public Long getModelId() {
        String modelId = this.getPageCache().get("modelid");
        if (modelId == null) {
            DynamicObject model = (DynamicObject)this.getModel().getValue(CON_MODEL);
            return model.getLong("id");
        }
        return Long.valueOf(modelId);
    }

    @Override
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        String appId = formShowParameter.getAppId();
        if (wfApps.contains(appId)) {
            Object from = e.getFormShowParameter().getCustomParam("from");
            if ("dimrangeselect".equals(from)) {
                return;
            }
            if (ApproveUtils.getInstance().isExtClassExist()) {
                e.getFormShowParameter().setCloseCallBack(new CloseCallBack("kd.bos.ext.fi.eb.ApprovalPagePlugin", "closeApproveBill"));
            }
            e.getFormShowParameter().addCustPlugin("kd.epm.eb.formplugin.workflow.ApproveBillExtraPlugin");
        }
    }

    private void submitBillByInvoke() {
        try {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"floatmenuap"});
            this.getModel().setDataChanged(false);
            log.info("begin invokeOperation.");
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("descInfo", (String)this.getView().getFormShowParameter().getCustomParam("descInfo"));
            this.getView().invokeOperation("submit", operateOption);
        }
        catch (Exception ex) {
            this.getView().getParentView().setEnable(Boolean.valueOf(true), new String[]{"btnok", "btncancel"});
            log.error("submit approvebill exception.");
            log.error((Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u63d0\u4ea4\u5355\u636e\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AuditOp_01", (String)"epm-eb-opplugin", (Object[])new Object[0]));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.checkBillStatusAndClose()) {
            return;
        }
        Object from = this.getView().getFormShowParameter().getCustomParam("from");
        if ("dimrangeselect".equals(from)) {
            this.submitBillByInvoke();
            return;
        }
        Object pkId = this.getPkId();
        ArrayList<Long> auditors = new ArrayList<Long>();
        String nodeName = "";
        if (pkId != null) {
            auditors.addAll(this.getAuditorId(String.valueOf(pkId)));
            nodeName = ApproveCommon.getCurrentNodeName(String.valueOf(pkId));
        }
        ApproveBillShowRptBGM rptBGM = new ApproveBillShowRptBGM();
        String billstatus = String.valueOf(this.getModel().getValue("billstatus"));
        boolean fromAuditPage = this.isFromAuditPage();
        rptBGM.showTplReport(this.getView(), auditors, nodeName, billstatus, this.getPluginName(), fromAuditPage, true);
        SplitContainer splitcontainerap = (SplitContainer)this.getControl(SPLITCONTAINERAP);
        splitcontainerap.setCollapse(SPLITPANELAP, true);
        this.changeBtnStatus();
        if (fromAuditPage) {
            this.hideApprovePageLeftPanel();
            this.getView().getPageCache().put("isNewApprovePage", "true");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"approveinfo"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"floatmenuap", "btn_approve", "btn_rejectonreport", "btn_reject"});
            this.getView().setVisible(Boolean.valueOf(false), ApproveOptimization.getInstance().getWFRefBtnKeys());
        }
        this.loadApproveParam(pkId);
        Long approveTypeId_old = (Long)this.getValue("approvaltype", "id");
        if (approveTypeId_old == null || approveTypeId_old == 0L) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"approvaltypepanel"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"approvetypepanel", "bailorginfo"});
        }
        this.setBailOrgShowValue();
        String centralBillType = (String)this.getModel().getValue("centralbilltype");
        if (!CentralBillType.Child.getNumber().equals(centralBillType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap23"});
        }
        IBgTaskExecutePlugin.hideNoBgmdItem(this.getView(), this.getModelId(), Sets.newHashSet((Object[])new String[]{"btn_exportvc", "btn_versionconstrast"}));
    }

    private boolean checkBillStatusAndClose() {
        IFormView parentView;
        Long _pkId = IDUtils.toLong((Object)this.getModel().getValue("id"));
        if (!this.isEmpty(_pkId) && !ApproveBillHelper.isNormalBill((Long)_pkId) && (parentView = this.getView().getParentView()) != null) {
            IFormView pParentView = parentView.getParentView();
            if (pParentView != null) {
                pParentView.showTipNotification(ResManager.loadKDString((String)"\u5ba1\u6838\u5355\u636e\u5185\u5bb9\u5df2\u5220\u9664\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ApproveBillEditPlugin_10", (String)CON_LANGEUAGE, (Object[])new Object[0]));
                this.getView().sendFormAction(pParentView);
            }
            parentView.close();
            this.getView().sendFormAction(parentView);
            return true;
        }
        return false;
    }

    private Object getPkId() {
        return ((BillShowParameter)this.getView().getFormShowParameter()).getPkId();
    }

    private void loadApproveParam(Object pkId) {
        IPageCache pageCache;
        boolean isNeedShrink;
        if (pkId == null) {
            return;
        }
        DynamicObject approveBill = QueryServiceHelper.queryOne((String)"eb_approvebill", (String)"modelid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)ConvertUtils.toLong((Object)pkId))});
        Long modelId = approveBill.getLong("modelid");
        IFormView parentView = this.getView().getParentView();
        if (this.isFromAuditPage() && (isNeedShrink = ParamQueryServiceHelper.getBoolean((long)modelId, (ParamEnum)ParamEnum.BG008)) && parentView != null) {
            parentView.setVisible(Boolean.TRUE, new String[]{"float_flexpanelap"});
            parentView.setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
            this.getView().sendFormAction(parentView);
            this.getPageCache().put("isNeedShrink", "true");
        }
        boolean fromCentralList = CentralOptimization.getInstance().isFromCentralList(this.getView());
        boolean isShowList = ParamQueryServiceHelper.getBoolean((long)modelId, (ParamEnum)ParamEnum.BG009);
        if (isShowList && !fromCentralList) {
            this.getPageCache().put("isShowList", "true");
        }
        if (fromCentralList) {
            SplitContainer splitContainerAp = (SplitContainer)this.getControl(SPLITCONTAINERAP);
            splitContainerAp.hidePanel(SplitDirection.up, true);
        }
        if (parentView != null && (pageCache = parentView.getPageCache()) != null) {
            pageCache.put("EPM_APPROVEBILL_KEY", pkId.toString());
            pageCache.put("EPM_MODEL_KEY", modelId.toString());
        }
    }

    private void hideApprovePageLeftPanel() {
        IFormView parentView = this.getView().getParentView().getParentView();
        if (this.isFromWFPage(parentView)) {
            parentView.setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
            this.getView().sendFormAction(parentView);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"floatmenuap"});
        }
    }

    private boolean isFromWFPage(IFormView parentView) {
        if (parentView == null) {
            return false;
        }
        if (parentView instanceof ListView) {
            ListView view = (ListView)parentView;
            String billFormId = view.getBillFormId();
            return !"eb_approvebill".equals(billFormId);
        }
        return true;
    }

    private boolean isFromAuditPage() {
        return ApproveUtils.getInstance().isFromAuditPage(this.getView());
    }

    private void setBailOrgShowValue() {
        String showValue = "-";
        DynamicObjectCollection bailOrg_entity = this.getModel().getEntryEntity("entryentity_bailorg");
        List bailOrgNames = bailOrg_entity.stream().map(e -> e.getString("bail_org.name")).collect(Collectors.toList());
        String _showValue = String.join((CharSequence)";", bailOrgNames);
        if (StringUtils.isNotEmpty((String)_showValue)) {
            showValue = _showValue;
        }
        this.getModel().setValue("bailorginfo", (Object)showValue);
        this.getModel().setDataChanged(false);
    }

    private void changeBtnStatus() {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_approvebill", (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", this.getModel().getValue("id"))});
        if (dynamicObject == null) {
            log.info("changeBtnStatus approvebill is null.");
            return;
        }
        String billStatus = dynamicObject.getString("billstatus");
        this.getPageCache().put("billstatus", String.valueOf(this.getModel().getValue("billStatus")));
        if (StringUtils.equals((String)"A", (String)billStatus) || StringUtils.equals((String)"C", (String)billStatus)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{CON_CTL_BTNSUBMIT});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{CON_CTL_BTNCANCEL});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"approve"});
        } else if (StringUtils.equals((String)"B", (String)billStatus)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{CON_CTL_BTNCANCEL});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{CON_CTL_BTNSUBMIT});
            Long userId = UserUtils.getUserId();
            String businessKey = String.valueOf(this.getPkId());
            List auditors = WorkflowServiceHelper.getApproverByBusinessKey((String)businessKey);
            this.getView().setVisible(Boolean.valueOf(auditors.contains(userId)), new String[]{"approve"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"unapprove"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{CON_CTL_BTNCANCEL, CON_CTL_BTNSUBMIT});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"approve"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"approve"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"unapprove"});
        }
        if (wfApps.contains(this.getBizAppId())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"approve", CON_CTL_BTNCANCEL});
        }
    }

    private void updataUserInfoShow() {
        IDataModel dataModel = this.getModel();
        DynamicObject user = (DynamicObject)dataModel.getValue(CON_CTL_CREATERID);
        Image pic = (Image)this.getControl("userpic");
        if (user != null) {
            Long userId = user.getLong("id");
            ArrayList<Long> userIds = new ArrayList<Long>();
            userIds.add(userId);
            Map userPics = UserServiceHelper.getUserAvatarPath(userIds, (boolean)true);
            pic.setUrl((String)userPics.get(userId));
            dataModel.setValue("handler", (Object)user.getLong("id"));
            this.getView().updateView("userpic");
            this.getView().updateView("handler");
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap", "advcontoolbarap", "floatmenuap", "toolbarap1"});
        this.addItemClickListeners(new String[]{"btn_exportvc"});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "expandmenu": {
                if (!this.isFromAuditPage()) break;
                IFormView parentView = this.getView().getParentView().getParentView();
                if (parentView != null) {
                    parentView.setVisible(Boolean.TRUE, new String[]{"flexpanelap1"});
                    this.getView().sendFormAction(parentView);
                }
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"floatmenuap"});
                break;
            }
            case "btn_open": {
                this.invokeChildPageView("open");
                break;
            }
            case "btn_export": {
                this.invokeChildPageView("export");
                break;
            }
            case "btn_refresh": {
                this.invokeChildPageView("refresh");
                this.changeItemStatusByFormType();
                break;
            }
            case "exportdownloadlist": {
                ApproveOptimization.getInstance().openDownloadPage(this.getView(), this.getModelId());
                break;
            }
            case "btn_reject": {
                this.invokeChildPageView("reject");
                break;
            }
            case "btn_rejectonreport": {
                this.invokeChildPageView("rejectonreport");
                break;
            }
            case "approve": {
                ApproveOptimization.getInstance().batchApprove(this.getView(), "", this.getPluginName(), this.getModelId(), true);
                break;
            }
            case "unapprove": {
                this.getView().invokeOperation("unaudit");
                break;
            }
            case "btn_circulation": {
                this.showCirculationPage();
                break;
            }
            case "btn_circulationrecord": {
                this.showCirculationRecordPage();
                break;
            }
            case "btn_approve": {
                this.openApprovePanel();
                break;
            }
            case "btn_transfer": {
                this.showTransferPage();
                break;
            }
            case "btn_coordinate": 
            case "btn_coortransfer": {
                this.showCoordinatePage();
                break;
            }
            case "btn_allowaddsign": {
                this.showAllowAddSignPage();
                break;
            }
            case "btn_approveopinion": {
                String reportField;
                String entityKey;
                IFormView tplReportView = this.getTplReportView();
                if (tplReportView == null) {
                    return;
                }
                String formId = tplReportView.getEntityId();
                if ("bgm_rptpreparation".equals(formId)) {
                    entityKey = "billlist_entity";
                    reportField = "process.id";
                } else {
                    entityKey = ENTRYENTITY;
                    reportField = "reportprocess.id";
                }
                EntryGrid control = (EntryGrid)tplReportView.getControl(entityKey);
                int[] selectRows = control.getSelectRows();
                if (selectRows == null || selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e", (String)"ApproveOptimization_0", (String)CON_LANGEUAGE, (Object[])new Object[0]));
                    return;
                }
                if (selectRows.length != 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u540c\u65f6\u67e5\u770b\u591a\u4e2a\u62a5\u8868\u5ba1\u6838\u610f\u89c1", (String)"ApproveOptimization_1", (String)CON_LANGEUAGE, (Object[])new Object[0]));
                    return;
                }
                DynamicObject entryRowEntity = tplReportView.getModel().getEntryRowEntity(entityKey, selectRows[0]);
                Long reportId = entryRowEntity.getLong(reportField);
                if (IDUtils.isEmptyLong((Long)reportId).booleanValue()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u62a5\u8868\u5b9e\u4f8b\u5931\u8d25", (String)"ApproveOptimization_2", (String)CON_LANGEUAGE, (Object[])new Object[0]));
                    return;
                }
                ApproveOptimization.getInstance().viewApproveOpinion(this.getView(), reportId, this.getModelId(), this.getPluginName());
                break;
            }
            case "btn_exportvc": {
                new VersionConstrastExportHelper("0", true, false, this.getDimViewIdFromCache("filterf7_entitymember")).exportBatch((AbstractFormPlugin)this, this.getModel());
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            String eventId;
            switch (eventId = messageBoxClosedEvent.getCallBackId()) {
                case "submit": {
                    this.submitAndClosePage(true);
                    break;
                }
                case "submitDelete": {
                    this.deleteHasSubmitReport();
                    break;
                }
            }
        }
    }

    private void deleteHasSubmitReport() {
        String hasSubmitReportProcessIds = this.getPageCache().get("hasSubmitReportProcessIds");
        Set reportProcessIds = (Set)SerializationUtils.deSerializeFromBase64((String)hasSubmitReportProcessIds);
        ApproveUtils.getInstance().deleteHasSubmitReport(reportProcessIds, (Set)Sets.newHashSet((Object[])new Object[]{this.getModel().getValue("id")}));
        Object pkId = this.getPkId();
        ArrayList<Long> auditors = new ArrayList<Long>();
        String nodeName = "";
        if (pkId != null) {
            auditors.addAll(this.getAuditorId(String.valueOf(pkId)));
            nodeName = ApproveCommon.getCurrentNodeName(String.valueOf(pkId));
        }
        ApproveBillShowRptBGM rptBGM = new ApproveBillShowRptBGM();
        String billstatus = String.valueOf(this.getModel().getValue("billstatus"));
        boolean fromAuditPage = this.isFromAuditPage();
        rptBGM.showTplReport(this.getView(), auditors, nodeName, billstatus, this.getPluginName(), fromAuditPage, false);
    }

    private void submitAndClosePage(boolean needClose) {
        this.getPageCache().put("submitShowConfirm", "false");
        OperateOption operateOption = OperateOption.create();
        this.getView().invokeOperation("submit", operateOption);
    }

    private void invokeTplReportRefresh() {
        try {
            IFormView tplReportView = this.getTplReportView();
            if (tplReportView != null) {
                FormViewPluginProxy pluginProxy;
                IFormPlugin plugin;
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_approvebill", (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", this.getModel().getValue("id"))});
                tplReportView.getFormShowParameter().setCustomParam("billstatus", (Object)dynamicObject.getString("billstatus"));
                tplReportView.cacheFormShowParameter();
                String pluginName = null;
                String formId = tplReportView.getFormShowParameter().getFormId();
                if ("bgm_rptpreparation".equals(formId)) {
                    pluginName = "kd.epm.eb.formplugin.reportscheme.ReportPreparationListPlugin";
                } else if ("eb_executetask".equals(formId)) {
                    pluginName = "kd.epm.eb.formplugin.task.BgTaskExecutePlugin";
                }
                if (StringUtils.isNotEmpty((String)pluginName) && (plugin = (pluginProxy = (FormViewPluginProxy)tplReportView.getService(FormViewPluginProxy.class)).getPlugin(pluginName)) != null) {
                    plugin.itemClick(new ItemClickEvent((Object)plugin, "refresh", ""));
                    this.getView().sendFormAction(tplReportView);
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u63d0\u4ea4\u5355\u636e\u540e\u5237\u65b0\u62a5\u8868\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AuditOp_02", (String)"epm-eb-opplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("submit".equals(operateKey)) {
            Pair pair;
            Long approveId = ConvertUtils.toLong((Object)this.getModel().getValue("id"));
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)approveId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_approvebill"));
            if (!CentralBillType.Child.getNumber().equals(dynamicObject.getString("centralbilltype")) && (pair = ApproveUtils.getInstance().validateApproveBillCanSubmit((Collection)Sets.newHashSet((Object[])new Long[]{approveId}))) != null) {
                this.getView().showConfirm(ResManager.loadResFormat((String)"\u5f53\u524d\u9009\u62e9\u5ba1\u6279\u5355\u5305\u542b\u7684%1\uff0c\u672c\u6b21\u63d0\u4ea4\u5c06\u4e0d\u518d\u91cd\u590d\u63d0\u4ea4\uff0c\u8bf7\u77e5\u6089", (String)"ApproveBillListPlugin_42", (String)CON_LANGEUAGE, (Object[])new Object[]{pair.p1}), MessageBoxOptions.YesNo, new ConfirmCallBackListener("submitDelete", (IFormPlugin)this));
                args.setCancel(true);
                this.getPageCache().put("hasSubmitReportProcessIds", SerializationUtils.serializeToBase64((Object)pair.p2));
                return;
            }
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection(ENTRYENTITY);
            if (CollectionUtils.isEmpty((Collection)entryentity)) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5ba1\u6279\u5355%1\u4e2d\u4e0d\u5b58\u5728\u672a\u63d0\u4ea4\u7684\u62a5\u8868\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4", (String)"ApproveBillListPlugin_40", (String)CON_LANGEUAGE, (Object[])new Object[]{dynamicObject.getString("billno")}));
                return;
            }
            Object from = this.getView().getFormShowParameter().getCustomParam("from");
            if ("dimrangeselect".equals(from)) {
                this.getView().getParentView().setEnable(Boolean.valueOf(true), new String[]{"btnok", "btncancel"});
                this.getView().sendFormAction(this.getView().getParentView());
                Object op = this.getView().getFormShowParameter().getCustomParam("op");
                if (op != null) {
                    OperateOption operateOption = (OperateOption)SerializationUtils.deSerializeFromBase64((String)op.toString());
                    operate.getOption().merge(operateOption);
                }
            } else if (StringUtils.equals((String)"C", (String)String.valueOf(this.getModel().getValue("billstatus")))) {
                String submitShowConfirm = this.getPageCache().get("submitShowConfirm");
                if (!"false".equals(submitShowConfirm)) {
                    this.getPageCache().remove("submitShowConfirm");
                    args.setCancel(true);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u6240\u6709\u6570\u636e\u5df2\u4fdd\u5b58\u3002", (String)"ApplyBgApplybillListPlugin_9", (String)CON_LANGEUAGE, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("submit", (IFormPlugin)this));
                } else {
                    Set notAllDealProcesses;
                    ApproveUtils instance = ApproveUtils.getInstance();
                    HashSet processIds = new HashSet(16);
                    HashSet approveBillIds = Sets.newHashSet((Object[])new Long[]{approveId});
                    List inRejectApproveBills = instance.getInRejectApproveBills((Collection)approveBillIds, processIds);
                    if (inRejectApproveBills.size() != 0) {
                        processIds.addAll(instance.getApproveRefReportProcessIds((Collection)inRejectApproveBills));
                    }
                    if ((notAllDealProcesses = instance.getNotAllDealProcesses(processIds, (Collection)approveBillIds)).size() != 0) {
                        args.setCancel(true);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u5f53\u524d\u5355\u636e\u5b58\u5728\u5982\u4e0b\u672a\u5904\u7406\u5b8c\u6210\u7684\u9a73\u56de\u62a5\u8868\uff1a\r\n%s", (String)"", (String)"", (Object[])new Object[]{String.join((CharSequence)"\r\n", notAllDealProcesses)}));
                    }
                }
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opType = ((FormOperate)afterDoOperationEventArgs.getSource()).getType();
        if ("save".equalsIgnoreCase(opType) || "submit".equalsIgnoreCase(opType) || "unsubmit".equalsIgnoreCase(opType) || "close".equalsIgnoreCase(opType)) {
            this.getModel().setDataChanged(false);
            Object from = this.getView().getFormShowParameter().getCustomParam("from");
            if ("submit".equals(opType)) {
                if (!"dimrangeselect".equals(from)) {
                    this.invokeTplReportRefresh();
                    OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
                    if (operationResult != null && CollectionUtils.isNotEmpty((Collection)operationResult.getSuccessPkIds())) {
                        Set approveIds = afterDoOperationEventArgs.getOperationResult().getSuccessPkIds().stream().map(IDUtils::toLong).collect(Collectors.toSet());
                        ApproveBillSubmitHelper.getInstance().autoAddBailOrg(approveIds, this.getModelId());
                    }
                } else {
                    HashMap<String, String> returnData = new HashMap<String, String>(16);
                    returnData.put("submitResult", SerializationUtils.serializeToBase64((Object)afterDoOperationEventArgs.getOperationResult()));
                    this.getView().returnDataToParent(returnData);
                    this.getView().close();
                }
                Set pkIds = Objects.requireNonNull(afterDoOperationEventArgs.getOperationResult()).getSuccessPkIds().stream().map(ConvertUtils::toLong).collect(Collectors.toSet());
                ApproveUtils.getInstance().saveSubmitInfos(pkIds);
                ApproveUtils.getInstance().saveApproveBillAuditType(pkIds);
                Set approveReportProcessIds = ApproveUtils.getInstance().getApproveReportProcessIds(pkIds);
                ApproveUtils.getInstance().updateRejectBillStatus(pkIds, (Collection)approveReportProcessIds);
            }
        } else if ("donothing".equalsIgnoreCase(opType)) {
            String opKey;
            String operateKey = afterDoOperationEventArgs.getOperateKey();
            if (!"app_optimize".equals(operateKey)) {
                return;
            }
            Donothing operate = (Donothing)afterDoOperationEventArgs.getSource();
            OperateOption option = operate.getOption();
            switch (opKey = option.getVariableValue("epm_op")) {
                case "circulation": {
                    this.showCirculationPage();
                    break;
                }
                case "circulationrecord": {
                    this.showCirculationRecordPage();
                    break;
                }
                case "openapprovepanel": {
                    this.openApprovePanel();
                    break;
                }
                case "transfer": {
                    this.showTransferPage();
                    break;
                }
                case "coordinate": 
                case "coortransfer": {
                    this.showCoordinatePage();
                    break;
                }
                case "allowaddsign": {
                    this.showAllowAddSignPage();
                    break;
                }
                case "showCentralList": {
                    this.invokeParentOperation(opKey);
                    break;
                }
                case "open": {
                    this.invokeChildPageView(opKey, option.getVariableValue(CentralOptimization.EPM_OP_PARAM, ""));
                    break;
                }
            }
        }
        this.changeItemStatusByFormType();
    }

    private void showAllowAddSignPage() {
        this.validateRejectReportsForBill();
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_addsignpage");
        parameter.setCustomParam("taskid", (Object)this.getApproveTaskId());
        parameter.setCustomParam("processInstanceId", (Object)parentView.getPageCache().get("processInstanceId"));
        parameter.setCloseCallBack(new CloseCallBack(new ApprovalPageAddSignPlugin().getPluginName(), "showAddSignPageCallBack"));
        parameter.setHasRight(true);
        parameter.setCustomParam("isIgnoreLicense", (Object)Boolean.TRUE);
        parentView.showForm(parameter);
        this.getView().sendFormAction(parentView);
    }

    private void showCoordinatePage() {
        this.validateRejectReportsForBill();
        String taskId = this.getApproveTaskId();
        boolean exists = WfUtils.exist((String)"wf_task", (Object)taskId);
        if (!exists) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5904\u7406\u3002", (String)"ApprovalPagePluginNew_18", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        } else if (TaskUtils.isTaskSuspended((Long)ConvertUtils.toLong((Object)taskId))) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u4e3a\u6302\u8d77\u72b6\u6001\uff0c\u4e0d\u80fd%1$s\u6216%2$s%3$s\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u89e3\u51b3\u3002", (String)"ApprovalPagePluginNew_26", (String)"bos-wf-formplugin", (Object[])new Object[0]), WfConfigurationUtil.getCoordinateName(), WfConfigurationUtil.getCoordinateName(), WfConfigurationUtil.getTransferName()));
        } else {
            IFormView parentView = this.getView().getParentView();
            if (parentView == null) {
                return;
            }
            HashMap<String, Object> customParams = new HashMap<String, Object>(16);
            customParams.put("taskid", ConvertUtils.toLong((Object)taskId));
            String taskCoordinate = parentView.getPageCache().get("is_taskcoordinate");
            customParams.put("is_taskcoordinate", taskCoordinate);
            FormShowParameter para = new FormShowParameter();
            para.getOpenStyle().setShowType(ShowType.Modal);
            para.setFormId("wf_taskcoordinate");
            if (Boolean.parseBoolean(taskCoordinate)) {
                para.setCaption(String.format(ResManager.loadKDString((String)"%1$s\u4efb\u52a1%2$s", (String)"ApprovalPagePluginNew_23", (String)"bos-wf-formplugin", (Object[])new Object[0]), WfConfigurationUtil.getCoordinateName(), WfConfigurationUtil.getTransferName()));
            } else {
                para.setCaption(String.format(ResManager.loadKDString((String)"\u4efb\u52a1%s", (String)"ApprovalPagePluginNew_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), WfConfigurationUtil.getCoordinateName()));
            }
            para.setCustomParams(customParams);
            para.setCloseCallBack(new CloseCallBack(new ApprovalPagePluginNew().getPluginName(), "showCoordinate"));
            para.setHasRight(true);
            customParams.put("isIgnoreLicense", Boolean.TRUE);
            parentView.showForm(para);
            this.getView().sendFormAction(parentView);
        }
    }

    private void showTransferPage() {
        this.validateRejectReportsForBill();
        ArrayList<Long> taskIds = new ArrayList<Long>(16);
        taskIds.add(ConvertUtils.toLong((Object)this.getApproveTaskId()));
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_transfertohandletask");
        parameter.setCaption(ResManager.loadKDString((String)"\u4efb\u52a1%s", (String)"ApprovalPagePluginNew_3", (String)"bos-wf-formplugin", (Object[])new Object[]{WfConfigurationUtil.getTransferName()}));
        parameter.setCustomParam("taskIds", taskIds);
        parameter.setCloseCallBack(new CloseCallBack(new ApprovalPagePluginNew().getPluginName(), "tasktransfercallback"));
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.showForm(parameter);
            this.getView().sendFormAction(parentView);
        }
    }

    private void openApprovePanel() {
        if (this.isFromAuditPage()) {
            IFormView parentView = this.getView().getParentView();
            if (parentView == null) {
                return;
            }
            parentView.setVisible(Boolean.FALSE, new String[]{"float_flexpanelap"});
            parentView.setVisible(Boolean.TRUE, new String[]{"flexpanelap"});
            this.getView().sendFormAction(parentView);
        }
    }

    private void showCirculationRecordPage() {
        FormShowParameter para = new FormShowParameter();
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setFormId("wf_taskcirculationlog");
        para.setCustomParam("taskid", (Object)ConvertUtils.toLong((Object)this.getApproveTaskId()));
        para.setCaption(ResManager.loadKDString((String)"\u4f20\u9605\u8bb0\u5f55", (String)"WorkflowTCDataPluginUtil_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        this.getView().showForm(para);
    }

    private void showCirculationPage() {
        HashMap<String, Long> customParams = new HashMap<String, Long>(16);
        customParams.put("taskid", ConvertUtils.toLong((Object)this.getApproveTaskId()));
        FormShowParameter para = new FormShowParameter();
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setFormId("wf_taskcirculation");
        para.setCaption(ResManager.loadKDString((String)"\u4efb\u52a1%s", (String)"ApprovalPagePluginNew_3", (String)"bos-wf-formplugin", (Object[])new Object[]{WfConfigurationUtil.getCirculationName()}));
        para.setCustomParams(customParams);
        para.setCloseCallBack(new CloseCallBack(new ApprovalPagePluginNew().getPluginName(), "showCirculationPage"));
        para.setHasRight(true);
        para.getCustomParams().put("isIgnoreLicense", Boolean.TRUE);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.showForm(para);
            this.getView().sendFormAction(parentView);
        }
    }

    private void changeItemStatusByFormType() {
        this.changeBtnStatus();
    }

    public void afterLoadData(EventObject e) {
        this.setModelTempToPageChache("modelid");
        this.fillDataToPage(e);
        this.updataUserInfoShow();
        this.getModel().setDataChanged(false);
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
    }

    private void setModelTempToPageChache(String strCtlKey) {
        if (this.getModel().getValue(strCtlKey) != null) {
            this.getPageCache().put(strCtlKey, ((DynamicObject)this.getModel().getValue(strCtlKey)).getString("id"));
        } else {
            this.getModel().setValue(strCtlKey, (Object)this.getPageCache().get(strCtlKey));
        }
    }

    private void setJsonCache(String strValue) {
        this.getPageCache().put(CON_CACHE_RETURNDATA, strValue);
        this.getModel().setValue(CON_CTL_DIMENSTIONJSON, (Object)strValue);
    }

    private void fillDataToPage(EventObject e) {
        Object pkid = ((BillShowParameter)((BillView)e.getSource()).getFormShowParameter()).getPkId();
        this.getBillAndFilldimension(IDUtils.toLong((Object)pkid));
    }

    private void getBillAndFilldimension(Long billId) {
        DynamicObject doc = BusinessDataServiceHelper.loadSingle((String)"eb_approvebill", (String)CON_CTL_DIMENSTIONJSON, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId)});
        if (doc != null) {
            this.fillDimensionRangAndValue(doc, CON_CTL_DIMENSTIONJSON);
        }
    }

    private void setDataTypeControlFilter(List<ApproveTempPojo> lstScope) {
        if (lstScope == null || lstScope.size() == 0) {
            return;
        }
        String model = this.getPageCache().get("modelid");
        if (StringUtils.isEmpty((String)model)) {
            return;
        }
        List<Long> idfilter = ApproveCommon.getListMemberFromScope(lstScope, 0L, Long.valueOf(model));
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(CON_CTL_DIMDATATYPE);
        basedataEdit.setQFilter(new QFilter("id", "in", idfilter));
        this.getPageCache().put(CON_CACHE_DATATYPE, SerializationUtils.toJsonString(lstScope));
    }

    private void fillDimensionRangAndValue(DynamicObject doc, String jsonField) {
        String saveDimension = doc.getString(jsonField);
        if (saveDimension == null || saveDimension.trim().length() == 0) {
            return;
        }
        String str = SerializationUtils.deSerializeFromBase64((String)saveDimension).toString();
        if (str.contains("bcm")) {
            return;
        }
        Map dimMap = (Map)SerializationUtils.deSerializeFromBase64((String)saveDimension);
        String[] defaultDimesion = new String[dimMap.size()];
        int i = 0;
        for (Map.Entry dimKey : dimMap.entrySet()) {
            String dim = ((String)dimKey.getKey()).toLowerCase(Locale.getDefault());
            if (!ApproveCommon.Alldimsion.contains(dim)) continue;
            if (dim.equalsIgnoreCase(CON_CTL_DIMDATATYPE)) {
                this.setDataTypeControlFilter((List)dimKey.getValue());
                continue;
            }
            String text = null;
            List map = (List)dimKey.getValue();
            if (dim.startsWith("dim_userdefind")) {
                TextEdit textEdit = (TextEdit)this.getControl(dim);
                textEdit.setCaption(new LocaleString(((ApproveTempPojo)map.get(0)).getDimensionName()));
            }
            for (ApproveTempPojo EBApproveTempPojo : map) {
                if (text == null) {
                    text = ResManager.loadResFormat((String)"%1\u7684%2", (String)"ApproveBillEditPlugin_9", (String)CON_LANGEUAGE, (Object[])new Object[]{EBApproveTempPojo.getDimName(), RangeEnum.getRangeByVal((int)EBApproveTempPojo.getScope()).getName()});
                    continue;
                }
                text = String.format("%1$s,%2$s", text, ResManager.loadResFormat((String)"%1\u7684%2", (String)"ApproveBillEditPlugin_9", (String)CON_LANGEUAGE, (Object[])new Object[]{EBApproveTempPojo.getDimName(), RangeEnum.getRangeByVal((int)EBApproveTempPojo.getScope()).getName()}));
            }
            this.getModel().setValue(dim, text);
            defaultDimesion[i] = ((ApproveTempPojo)map.get(0)).getDimensionId();
            ++i;
        }
        this.setJsonCache(SerializationUtils.serializeToBase64((Object)dimMap));
    }

    private List<Long> getAuditorId(String pkId) {
        List auditorsId = WorkflowServiceHelper.getApproverByBusinessKey((String)pkId);
        if (auditorsId == null || auditorsId.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        return auditorsId;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.isFromAuditPage()) {
            IFormView parentView = this.getView().getParentView().getParentView();
            if (this.isFromWFPage(parentView)) {
                parentView.setVisible(Boolean.TRUE, new String[]{"flexpanelap1"});
                this.getView().sendFormAction(parentView);
            }
            this.getView().returnDataToParent((Object)"close");
        }
    }

    private String getApproveTaskId() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return String.valueOf(0L);
        }
        return parentView.getPageCache().get("taskid");
    }

    public IFormView getTplReportView() {
        String tplReportPageId = this.getPageCache().get("tplReportPageId");
        if (StringUtils.isEmpty((String)tplReportPageId)) {
            return null;
        }
        return this.getView().getView(tplReportPageId);
    }

    private void invokeChildPageView(String opKey) {
        this.invokeChildPageView(opKey, "");
    }

    private void invokeChildPageView(String opKey, String param) {
        IFormView tplReportView = this.getTplReportView();
        if (tplReportView != null) {
            if (StringUtils.isEmpty((String)param)) {
                tplReportView.invokeOperation(opKey);
            } else {
                OperateOptionPrivate optionPrivate = new OperateOptionPrivate();
                optionPrivate.setVariableValue(CentralOptimization.EPM_OP_PARAM, param);
                tplReportView.invokeOperation(opKey, (OperateOption)optionPrivate);
            }
            this.getView().sendFormAction(tplReportView);
        }
    }

    public void invokeParentOperation(String operateKey) {
        CentralOptimization.getInstance().invokeParentOperation(operateKey, this.getView(), false);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("closePage".equals(actionId)) {
            if (!ApproveUtils.getInstance().isExtClassExist() && this.isFromAuditPage()) {
                IFormView parentView = this.getView().getParentView();
                parentView.close();
                this.getView().sendFormAction(parentView);
            } else {
                this.getView().close();
            }
        } else if ("btn_reject".equals(actionId)) {
            if (ApproveOptimization.getInstance().needRejectClose(event.getReturnData())) {
                if (wfApps.contains(this.getBizAppId()) && !ApproveUtils.getInstance().isExtClassExist()) {
                    IFormView parentView = this.getView().getParentView();
                    parentView.close();
                    this.getView().sendFormAction(parentView);
                }
                this.getView().close();
            }
        } else if ("btn_batchapprove".equals(actionId) && ApproveOptimization.getInstance().isApproveConfirm(event.getReturnData())) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5ba1\u6279\u6210\u529f", (String)"", (String)"", (Object[])new Object[0]));
            this.invokeChildPageView("refresh");
            Object billNo = this.getModel().getValue("billno");
            Map returnData = (Map)event.getReturnData();
            String approveDecision = (String)returnData.get("approveDecision");
            MultiLangEnumBridge desc = new MultiLangEnumBridge("\u5355\u636e\uff1a%1$s\u5ba1\u6838\u6210\u529f\u3002", "ApproveBillListPlugin_29", CON_LANGEUAGE);
            String[] descArgs = new String[]{String.valueOf(billNo)};
            if (ApproveDecisionEnum.REJECT_TASK.getIndex().equals(approveDecision)) {
                desc = new MultiLangEnumBridge("\u5355\u636e\uff1a%1$s\u9a73\u56de\u6210\u529f\u3002", "ApproveBillListPlugin_44", CON_LANGEUAGE);
            } else if (ApproveDecisionEnum.REJECT_REPORT.getIndex().equals(approveDecision)) {
                desc = new MultiLangEnumBridge("\u5355\u636e\uff1a%1$s\u6309\u8868\u9a73\u56de\u6210\u529f\u3002", "ApproveBillListPlugin_45", CON_LANGEUAGE);
            }
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5ba1\u6838", "ApproveBillListPlugin_28", CON_LANGEUAGE);
            this.writeLog(null, "audit", opName, desc, descArgs);
        }
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        AdminModelUtil.checkAdminModeBeforeItemClick(evt, this.getModelId(), this.getView(), Sets.newHashSet((Object[])new String[]{"btn_close"}));
    }

    private void writeOpLog(AfterDoOperationEventArgs args, String opName) {
    }

    private void validateRejectReportsForBill() {
        Long approveBillId = ConvertUtils.toLong((Object)this.getModel().getValue("id"));
        Set reportProcessIds = ApproveUtils.getInstance().getApproveRefReportProcessIds(Collections.singletonList(approveBillId));
        Set notAllDealProcesses = ApproveUtils.getInstance().getNotAllDealProcesses((Collection)reportProcessIds, Collections.singletonList(approveBillId));
        if (notAllDealProcesses.size() != 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5f53\u524d\u5355\u636e\u5b58\u5728\u5982\u4e0b\u672a\u5904\u7406\u5b8c\u6210\u7684\u9a73\u56de\u62a5\u8868\uff1a\r\n%s", (String)"", (String)"", (Object[])new Object[]{String.join((CharSequence)"\r\n", notAllDealProcesses)}));
        }
    }
}

