/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.approveBill;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.approveBill.ApproveUpdata;
import kd.epm.eb.business.approveBill.filter.ApproveBillFilterFactory;
import kd.epm.eb.business.approveBill.filter.ApproveBillFilterService;
import kd.epm.eb.business.approveBill.helper.ApproveBillSubmitHelper;
import kd.epm.eb.business.approvetype.ApproveUtils;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.approveBill.Entity.ApproveBillStatus;
import kd.epm.eb.common.approveBill.Entity.CentralBillType;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.ApproveDecisionEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.examine.enums.ExamineExecTypeEnum;
import kd.epm.eb.common.utils.CommonMethod;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.adminmode.utils.AdminModelUtil;
import kd.epm.eb.formplugin.approveBill.ApproveOptimization;
import kd.epm.eb.formplugin.approveBill.CommitExaminCheck;
import kd.epm.eb.formplugin.filterContainerModelListPlugin;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.commons.collections4.CollectionUtils;

public class ApproveBillListPlugin
extends filterContainerModelListPlugin
implements ClickListener,
BeforeF7SelectListener,
CommonMethod {
    private static Log log = LogFactory.getLog(ApproveBillListPlugin.class);
    private Dimension entityCache;

    public void initialize() {
        super.initialize();
    }

    @Override
    public boolean isCheckModel() {
        return true;
    }

    @Override
    public Long getModelId() {
        String modelCache = this.getPageCache().get("modelId");
        if (StringUtils.isEmpty((CharSequence)modelCache)) {
            BillList billlist = (BillList)this.getControl("billlistap");
            ListSelectedRow row = billlist.getCurrentSelectedRowInfo();
            if (row != null) {
                DynamicObject load = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (DynamicObjectType)((DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"eb_approvebill").getDataEntityType()));
                return load.getLong("modelid.id");
            }
            return 0L;
        }
        return ConvertUtils.toLong((Object)modelCache);
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String pageId = "eb_approvebill";
        if (e.getSource() instanceof BillList) {
            BillList billList = (BillList)e.getSource();
            pageId = billList.getEntityType().getName();
        }
        if ("eb_approvebill".equals(pageId)) {
            e.setDataPermQFilters(new ArrayList(1));
        }
        if (this.isLookUp()) {
            return;
        }
        if (e.getMainOrgQFilter() == null) {
            QFilter qFilter = new QFilter("id", "=", (Object)0L);
            e.getQFilters().add(qFilter);
            if (StringUtils.isEmpty((CharSequence)this.getPageCache().get("setFilterCount"))) {
                this.getPageCache().put("setFilterCount", "1");
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"DecomposeSchemeListPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getPageCache().remove("setFilterCount");
        }
        if ("eb_approvebill".equals(pageId)) {
            String qryType = "0";
            for (QFilter qFilter : e.getQFilters()) {
                if (!"qrytype".equals(qFilter.getProperty())) continue;
                qryType = (String)qFilter.getValue();
                e.getQFilters().remove(qFilter);
                break;
            }
            String tabType = "all";
            Tab tab = (Tab)this.getControl("tabap");
            if (tab != null) {
                String currentTab = tab.getCurrentTab();
                if ("tabpageap_wait".equals(currentTab)) {
                    tabType = "pending";
                } else if ("tabpageap_done".equals(currentTab)) {
                    tabType = "processed";
                }
            }
            Long modelId = this.getModelId();
            List<String> billIds = this.getBillsByModel(modelId);
            ApproveBillFilterService filterService = ApproveBillFilterFactory.getInstance((String)qryType, (String)tabType);
            QFilter qFilter = filterService.getQFilter(modelId, billIds);
            e.getQFilters().add(qFilter);
        }
        List qFilters = e.getQFilters();
        qFilters.add(new QFilter("billstatus", "!=", (Object)ApproveBillStatus.DISCARD.getNumber()));
        Iterator iterator = qFilters.iterator();
        ArrayList<QFilter> fastQFilter = new ArrayList<QFilter>(qFilters.size());
        while (iterator.hasNext()) {
            QFilter next = (QFilter)iterator.next();
            String cp = next.getCP();
            String property = next.getProperty();
            if (!"1".equals(property) || !"ftlike".equals(cp)) continue;
            fastQFilter.add(next);
            iterator.remove();
        }
        e.setQFilters(qFilters);
        this.getPageCache().put("fastQFilter", SerializationUtils.serializeToBase64(fastQFilter));
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (Arrays.asList("btn_delete", "btn_submit", "btn_cancel", "btn_viewflow", "btn_unaudit").contains(evt.getItemKey())) {
            BillList billlist = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection listSelectedRows = billlist.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)listSelectedRows)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ApproveBillListPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            this.checkApproveBillStatus(listSelectedRows);
        }
        super.beforeItemClick(evt);
        AdminModelUtil.checkAdminModeBeforeItemClick(evt, this.getModelId(), this.getView(), Sets.newHashSet((Object[])new String[]{"btn_close"}));
    }

    private void checkApproveBillStatus(ListSelectedRowCollection selectedRows) {
        if (selectedRows == null || selectedRows.size() == 0) {
            return;
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                long t1 = System.currentTimeMillis();
                DynamicObjectCollection collection = super.getData(0, this.getMaxCount());
                ArrayList pkId = new ArrayList(16);
                collection.forEach(v -> pkId.add(String.valueOf(v.getPkValue())));
                if (pkId.size() > 0) {
                    try {
                        ApproveBillListPlugin.this.setOtherInfoAndFilterDataByFastQFilter(collection, pkId);
                    }
                    catch (Exception e) {
                        log.error("ErWorkFlowFlexListForOtherPlugin >>>>> \u8bbe\u7f6e\u5ba1\u6279\u4eba\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                    }
                }
                long t2 = System.currentTimeMillis();
                log.info("\u5ba1\u6838\u4eba\u6570\u636e\u52a0\u8f7dB \u7528\u65f6\uff1a " + (t2 - t1) + "ms");
                DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
                int start = collection.size() > arg0 ? arg0 : collection.size() / arg1 * arg1;
                dynamicObjects.addAll((Collection)collection.subList(start, Math.min(arg1 + arg0, collection.size())));
                return dynamicObjects;
            }
        });
    }

    private void setOtherInfoAndFilterDataByFastQFilter(DynamicObjectCollection collection, List<String> pkIds) {
        Map auditorsNameMap = ApproveUtils.getInstance().getNextAuditor(pkIds);
        Set sourceIds = collection.stream().map(row -> row.getLong("source_id")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "in", sourceIds);
        Map scheme = BusinessDataServiceHelper.loadFromCache((String)"eb_rptscheme", (String)"name", (QFilter[])qFilter.toArray());
        Map taskList = BusinessDataServiceHelper.loadFromCache((String)"eb_tasklist", (String)"name", (QFilter[])qFilter.toArray());
        Iterator iterator = collection.iterator();
        DataEntityPropertyCollection properties = ((DynamicObject)collection.get(0)).getDynamicObjectType().getProperties();
        while (iterator.hasNext()) {
            DynamicObject next = (DynamicObject)iterator.next();
            this.setNextAuditor(next, auditorsNameMap);
            this.setSourceName(next, scheme, taskList);
            if (!this.filterDataByFastQFilter(next, properties)) continue;
            iterator.remove();
        }
    }

    private String getRptName(DynamicObject row) {
        Long centralOrgId = row.getLong("centralorg.id");
        DynamicObject tempObj = row.getDynamicObject("entryentity.tempid");
        String tempName = tempObj != null ? tempObj.getString("name") : "";
        if (this.notEmpty(centralOrgId)) {
            Member member;
            Long orgViewId = row.getLong("orgviewid.id");
            String orgName = null;
            Dimension entityCache = this.getEntityCache();
            if (entityCache != null && (member = entityCache.getMember(orgViewId, centralOrgId)) != null) {
                orgName = member.getName();
            }
            if (orgName == null) {
                orgName = "";
            }
            tempName = ApproveUtils.getInstance().buildCentralBillRptName(tempName, orgName);
        }
        return tempName;
    }

    private boolean filterDataByFastQFilter(DynamicObject next, DataEntityPropertyCollection properties) {
        List qFilters;
        String fastQFilter = this.getPageCache().get("fastQFilter");
        boolean needRemove = false;
        if (StringUtils.isNotEmpty((CharSequence)fastQFilter) && CollectionUtils.isNotEmpty((Collection)(qFilters = (List)SerializationUtils.deSerializeFromBase64((String)fastQFilter)))) {
            for (QFilter qFilter : qFilters) {
                String[] values;
                boolean filterValid = false;
                String value = (String)qFilter.getValue();
                String[] split = value.split("#");
                if (split.length != 2) break;
                String keyStr = split[0];
                String queryValues = split[1];
                for (String queryValue : values = queryValues.split("\b")) {
                    String tem;
                    if (keyStr.contains("billno") && properties.containsKey((Object)"billno") && (tem = next.getString("billno")).contains(queryValue)) {
                        filterValid = true;
                        break;
                    }
                    if (keyStr.contains("entryentity.tempid.name") && properties.containsKey((Object)"entryentity.tempid") && (tem = this.getRptName(next)).contains(queryValue)) {
                        filterValid = true;
                        break;
                    }
                    if (keyStr.contains("source.name") && properties.containsKey((Object)"sourcename") && (tem = next.getString("sourcename")).contains(queryValue)) {
                        filterValid = true;
                        break;
                    }
                    if (!keyStr.contains("handler.name") || !properties.containsKey((Object)"handlertext") || !(tem = next.getString("handlertext")).contains(queryValue)) continue;
                    filterValid = true;
                    break;
                }
                if (filterValid) continue;
                needRemove = true;
                break;
            }
        }
        return needRemove;
    }

    private void setNextAuditor(DynamicObject next, Map<String, String> auditorsNameMap) {
        String pkIdTemp = String.valueOf(next.getPkValue());
        String handlerText = auditorsNameMap.get(pkIdTemp);
        if (handlerText != null && !"A".equals(next.getString("billstatus"))) {
            next.set("handlertext", (Object)handlerText);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent var1) {
    }

    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        if (this.isLookUp()) {
            return;
        }
        List selectMainOrgIds = args.getSearchClickEvent().getSelectMainOrgIds();
        this.getPageCache().put("modelId", selectMainOrgIds.size() > 0 ? ((Long)selectMainOrgIds.get(0)).toString() : null);
        if (selectMainOrgIds.size() == 1) {
            UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)((Long)selectMainOrgIds.get(0)));
        }
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        List filterCol = commonFilterColumns.stream().filter(e -> e.getFieldName().equals("modelid.name")).collect(Collectors.toList());
        if (filterCol == null) {
            return;
        }
        CommonFilterColumn cfc = (CommonFilterColumn)filterCol.get(0);
        cfc.getComboItems().clear();
        ArrayList modelQFilters = new ArrayList(16);
        modelQFilters.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
        Map modelMap = BusinessDataServiceHelper.loadFromCache((String)"epm_model", (String)"id,name", (QFilter[])modelQFilters.toArray(new QFilter[0]));
        ArrayList modelList = new ArrayList(modelMap.size());
        HashSet modelIds = new HashSet(modelMap.size());
        modelMap.values().forEach(e -> {
            modelIds.add(e.getLong("id"));
            modelList.add(new ComboItem(new LocaleString(e.getString("name")), e.getString("id")));
        });
        if (CollectionUtils.isNotEmpty(modelList)) {
            cfc.setComboItems(modelList);
            Long model = ConvertUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"));
            if (model == 0L) {
                model = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)"model", (boolean)false);
                if (IDUtils.isNotNull((Long)model) && modelIds.contains(model)) {
                    cfc.setDefaultValue(String.valueOf(model));
                    this.getPageCache().put("modelId", String.valueOf(model));
                } else {
                    cfc.setDefaultValue(((ComboItem)modelList.get(0)).getValue());
                    this.getPageCache().put("modelId", ((ComboItem)modelList.get(0)).getValue());
                }
            } else {
                cfc.setDefaultValue(String.valueOf(model));
                this.getPageCache().put("modelId", String.valueOf(model));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u4efb\u4f55\u4f53\u7cfb\u3002", (String)"AdjustRuleListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private List<String> getBillsByModel(Long modelId) {
        DynamicObjectCollection bills;
        ArrayList<String> list = new ArrayList<String>(16);
        if (modelId == null) {
            return list;
        }
        if (modelId == 0L) {
            bills = QueryServiceHelper.query((String)"eb_approvebill", (String)"id", null);
        } else {
            QFilter qFilter = new QFilter("modelid", "=", (Object)modelId);
            qFilter.and("billstatus", "!=", (Object)ApproveBillStatus.DISCARD.getNumber());
            bills = QueryServiceHelper.query((String)"eb_approvebill", (String)"id", (QFilter[])qFilter.toArray());
        }
        if (bills != null && bills.size() > 0) {
            for (DynamicObject bill : bills) {
                list.add(bill.getString("id"));
            }
        }
        return list;
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ((args.getFieldName().equals("modelid.id") || args.getFieldName().equals("modelid.name")) && (this.modelIdSet == null || this.modelIdSet.size() == 0)) {
            DynamicObject[] modelList = this.queryHasPremModel();
            this.modelIdSet = this.getPermModelIdSet(modelList);
            args.getQfilters().add(new QFilter("id", "in", (Object)this.modelIdSet));
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operation = ((FormOperate)args.getSource()).getType();
        if ("submit".equals(operation)) {
            Pair pair;
            DynamicObject[] approveBills;
            Set filterApproveIds;
            HashSet processIds;
            ListSelectedRowCollection selectedData = args.getListSelectedData();
            List approveIds = selectedData.stream().map(e -> ConvertUtils.toLong((Object)e.getPrimaryKeyValue())).collect(Collectors.toList());
            if (approveIds.size() == 0) {
                return;
            }
            ApproveUtils instance = ApproveUtils.getInstance();
            List inRejectApproveBills = instance.getInRejectApproveBills(approveIds, processIds = new HashSet(16));
            if (inRejectApproveBills.size() != 0) {
                processIds.addAll(instance.getApproveRefReportProcessIds((Collection)inRejectApproveBills));
            }
            if (CollectionUtils.isNotEmpty(filterApproveIds = Arrays.stream(approveBills = BusinessDataServiceHelper.load((Object[])approveIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_approvebill"))).filter(dynamicObject -> !CentralBillType.Child.getNumber().equals(dynamicObject.getString("centralbilltype"))).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet())) && (pair = ApproveUtils.getInstance().validateApproveBillCanSubmit(filterApproveIds)) != null) {
                this.getView().showConfirm(ResManager.loadResFormat((String)"\u5f53\u524d\u9009\u62e9\u5ba1\u6279\u5355\u5305\u542b\u7684%1\uff0c\u672c\u6b21\u63d0\u4ea4\u5c06\u4e0d\u518d\u91cd\u590d\u63d0\u4ea4\uff0c\u8bf7\u77e5\u6089", (String)"ApproveBillListPlugin_42", (String)"epm-eb-formplugin", (Object[])new Object[]{pair.p1}), MessageBoxOptions.YesNo, new ConfirmCallBackListener("submitDelete", (IFormPlugin)this));
                args.setCancel(true);
                this.getPageCache().put("hasSubmitReportProcessIds", SerializationUtils.serializeToBase64((Object)pair.p2));
                return;
            }
            StringBuilder notNeedSubmit = new StringBuilder();
            for (DynamicObject approveBill : approveBills) {
                DynamicObjectCollection entryentity = approveBill.getDynamicObjectCollection("entryentity");
                if (!CollectionUtils.isEmpty((Collection)entryentity)) continue;
                notNeedSubmit.append(approveBill.getString("billno")).append("\u3001");
            }
            if (StringUtils.isNotEmpty((CharSequence)notNeedSubmit)) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5ba1\u6279\u5355%1\u4e2d\u4e0d\u5b58\u5728\u672a\u63d0\u4ea4\u7684\u62a5\u8868\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4", (String)"ApproveBillListPlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[]{notNeedSubmit.substring(0, notNeedSubmit.length() - 1)}));
                return;
            }
            DynamicObject[] dynamicObjects = (DynamicObject[])Arrays.stream(approveBills).filter(dynamicObject -> filterApproveIds.contains(dynamicObject.getLong("id"))).toArray(DynamicObject[]::new);
            boolean containRepeat = ApproveUtils.getInstance().validateApproveBillReportRepeat(dynamicObjects);
            if (containRepeat) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u5ba1\u6279\u5355\u62a5\u8868\u5b58\u5728\u4ea4\u96c6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ApproveBillListPlugin_41", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            Set notAllDealProcesses = instance.getNotAllDealProcesses(processIds, approveIds);
            if (notAllDealProcesses.size() != 0) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u5f53\u524d\u5355\u636e\u5b58\u5728\u5982\u4e0b\u672a\u5904\u7406\u5b8c\u6210\u7684\u9a73\u56de\u62a5\u8868\uff1a%s\u3002", (String)"ApproveBillListPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)"\r\n", notAllDealProcesses)}));
            }
            FormOperate source = (FormOperate)args.getSource();
            OperateOption option = source.getOption();
            option.setVariableValue("fromApprove", "true");
            source.setOption(option);
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if ("submitDelete".equals(callBackId)) {
            MessageBoxResult result = event.getResult();
            if (result == MessageBoxResult.Yes) {
                String hasSubmitReportProcessIds = this.getPageCache().get("hasSubmitReportProcessIds");
                Set reportProcessIds = (Set)SerializationUtils.deSerializeFromBase64((String)hasSubmitReportProcessIds);
                BillList billlistap = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection selectedRows = billlistap.getSelectedRows();
                ApproveUtils.getInstance().deleteHasSubmitReport(reportProcessIds, selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet()));
                this.getView().invokeOperation("refresh");
            }
            this.getPageCache().remove("hasSubmitReportProcessIds");
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operation = ((FormOperate)args.getSource()).getType();
        String operateKey = args.getOperateKey();
        if ("submit".equals(operation)) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
            if ("submit".equals(operateKey)) {
                String remindMesStr;
                OperationResult operationResult = args.getOperationResult();
                if (operationResult != null && CollectionUtils.isNotEmpty((Collection)operationResult.getSuccessPkIds())) {
                    Set approveIds = operationResult.getSuccessPkIds().stream().map(IDUtils::toLong).collect(Collectors.toSet());
                    ApproveBillSubmitHelper.getInstance().autoAddBailOrg(approveIds, this.getModelId());
                    ApproveUtils.getInstance().saveSubmitInfos(approveIds);
                    ApproveUtils.getInstance().saveApproveBillAuditType(approveIds);
                    Set reportProcessIds = ApproveUtils.getInstance().getApproveRefReportProcessIds(approveIds);
                    ApproveUtils.getInstance().updateRejectBillStatus(approveIds, (Collection)reportProcessIds);
                }
                if (operationResult != null && this.notEmpty(remindMesStr = (String)((FormOperate)args.getSource()).getOption().getVariables().get("remindMes"))) {
                    List mesList = (List)SerializationUtils.fromJsonString((String)remindMesStr, List.class);
                    mesList.forEach(mes -> {
                        OperateErrorInfo operateInfo = new OperateErrorInfo();
                        operateInfo.setErrorLevel(ErrorLevel.Info.name());
                        operateInfo.setMessage(mes);
                        operateInfo.setPkValue((Object)0L);
                        operationResult.getAllErrorInfo().add(operateInfo);
                    });
                }
            }
        }
    }

    private void writeOpLog(AfterDoOperationEventArgs args, String opName) {
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        e.getParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, "submit"));
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "submit": {
                if (!StringUtils.equals((CharSequence)"success", (CharSequence)String.valueOf(closedCallBackEvent.getReturnData()))) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"BgApplySplitBillPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.getBillListControl().refresh();
                break;
            }
            case "btn_batchapprove": {
                if (!ApproveOptimization.getInstance().isApproveConfirm(closedCallBackEvent.getReturnData())) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5ba1\u6838\u6210\u529f", (String)"ApproveBillListPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                Map returnData = (Map)closedCallBackEvent.getReturnData();
                String approveDecision = (String)returnData.get("approveDecision");
                MultiLangEnumBridge desc = new MultiLangEnumBridge("\u5355\u636e\uff1a%1$s\u5ba1\u6838\u6210\u529f\u3002", "ApproveBillListPlugin_29", "epm-eb-formplugin");
                if (ApproveDecisionEnum.REJECT_TASK.getIndex().equals(approveDecision)) {
                    desc = new MultiLangEnumBridge("\u5355\u636e\uff1a%1$s\u9a73\u56de\u6210\u529f\u3002", "ApproveBillListPlugin_44", "epm-eb-formplugin");
                } else if (ApproveDecisionEnum.REJECT_REPORT.getIndex().equals(approveDecision)) {
                    desc = new MultiLangEnumBridge("\u5355\u636e\uff1a%1$s\u6309\u8868\u9a73\u56de\u6210\u529f\u3002", "ApproveBillListPlugin_45", "epm-eb-formplugin");
                }
                this.writeLog("audit", new MultiLangEnumBridge("\u5ba1\u6838", "ApproveBillListPlugin_28", "epm-eb-formplugin"), desc, new String[]{String.join((CharSequence)"\u3001", this.getSelectBillNos())});
                this.getBillListControl().clearSelection();
                this.getBillListControl().refresh();
                break;
            }
            case "reportExportAddActionId": {
                ApproveOptimization.getInstance().handleCloseCallback(this.getView(), this.getModelId(), closedCallBackEvent.getReturnData());
                this.writeLog("export", new MultiLangEnumBridge("\u5bfc\u51fa\u6570\u636e", "AdjustBillListPlugin_23", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5ba1\u6838\u7ba1\u7406-\u5bfc\u51fa\u6570\u636e", "ApproveBillListPlugin_46", "epm-eb-formplugin"));
                break;
            }
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"_toolbar_"});
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "updata": {
                boolean updata = ApproveUpdata.getInstance().updata();
                if (updata) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f", (String)"BizRuleGroupListPlugin2_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u5931\u8d25,\u65e0\u65e7\u6570\u636e\u6216\u67e5\u770b\u65e5\u5fd7", (String)"ApproveBillListPlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                break;
            }
            case "btn_audit": {
                List selectedMainOrgIds = this.getSelectedMainOrgIds();
                if (selectedMainOrgIds.size() != 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u4f53\u7cfb\u3002", (String)"ApproveBillListPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                ApproveOptimization.getInstance().batchApprove(this.getView(), "", this.getPluginName(), (Long)selectedMainOrgIds.get(0), true, true);
                break;
            }
            case "btn_exportdata": {
                this.beforeExportData();
                break;
            }
            case "exportdownloadlist": {
                ApproveOptimization.getInstance().openDownloadPage(this.getView(), this.getModelId());
                break;
            }
            case "examinecheck": {
                this.doExamineCheck();
                break;
            }
        }
    }

    private void doExamineCheck() {
        DynamicObject[] billObjs;
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        HashSet approveBillIds = new HashSet(16);
        HashMap billIdNumberMap = new HashMap(16);
        selectedRows.forEach(e -> {
            Long id = IDUtils.toLong((Object)e.getPrimaryKeyValue());
            approveBillIds.add(id);
            billIdNumberMap.put(id, e.getNumber());
        });
        if (approveBillIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ApproveBillListPlugin_audit_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        for (DynamicObject obj : billObjs = BusinessDataServiceHelper.load((String)"eb_approvebill", (String)"id,source,rptprocesstype,modelid,eborgid,dim_period,dim_datatype,dim_version,billstatus,entryentity.tempid", (QFilter[])new QFilter("id", "in", approveBillIds).toArray())) {
            billIdNumberMap.remove(obj.getLong("id"));
        }
        if (billIdNumberMap.size() > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e%s\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"ApproveOptimization_38", (String)"epm-eb-formplugin", (Object[])new Object[]{billIdNumberMap.values().toString()}));
            return;
        }
        if (billObjs.length == 0) {
            return;
        }
        List examineCheckReports = ApproveBillSubmitHelper.getInstance().batCheckExamine(Arrays.asList(billObjs), null);
        new CommitExaminCheck().handleCheckReport(examineCheckReports, this.getView(), null, (IFormPlugin)this, ExamineExecTypeEnum.CheckInList);
    }

    private void beforeExportData() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        HashSet approveBillIds = new HashSet(16);
        selectedRows.forEach(e -> approveBillIds.add(IDUtils.toLong((Object)e.getPrimaryKeyValue())));
        if (approveBillIds.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"ApproveBillListPlugin_audit_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ApproveOptimization.getInstance().openExportPageFromList(this.getView(), new CloseCallBack((IFormPlugin)this, "reportExportAddActionId"), (Long)approveBillIds.iterator().next(), this.getModelId());
    }

    private Set<String> getSelectBillNos() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        HashSet<String> approveBillNos = new HashSet<String>(16);
        selectedRows.forEach(e -> approveBillNos.add(e.getNumber()));
        return approveBillNos;
    }

    private void setSourceName(DynamicObject next, Map<Object, DynamicObject> scheme, Map<Object, DynamicObject> taskList) {
        DynamicObject sourceObj = null;
        sourceObj = scheme.get(next.getLong("source_id"));
        if (sourceObj == null) {
            sourceObj = taskList.get(next.getLong("source_id"));
        }
        if (sourceObj != null) {
            next.set("sourcename", (Object)sourceObj.getString("name"));
        }
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        if (AdminModelUtil.checkAdminModeNeedResult(this.getModelId(), this.getView())) {
            return;
        }
        super.hyperLinkClick(hyperLinkClickEvent);
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs evt) {
        if (AdminModelUtil.checkAdminModeNeedResult(this.getModelId(), this.getView())) {
            evt.setCancel(true);
            return;
        }
        if (this.isLookUp()) {
            return;
        }
        super.billListHyperLinkClick(evt);
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        String columnKey = ((AbstractColumnDesc)e.getSource()).getKey();
        if ("tempid.name".equals(columnKey)) {
            e.setFormatValue((Object)this.getRptName(e.getRowData()));
        }
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
    }

    private Dimension getEntityCache() {
        if (this.entityCache == null) {
            this.entityCache = this.getIModelCacheHelper().getDimension(SysDimensionEnum.Entity.getNumber());
        }
        return this.entityCache;
    }

    private boolean isLookUp() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)formShowParameter;
            return listShowParameter.isLookUp();
        }
        return false;
    }

    @Override
    protected Boolean checkDataRulePerm() {
        return true;
    }
}

