/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.approveBill;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.approvetype.ApproveUtils;
import kd.epm.eb.common.approveBill.Entity.ApproveBillInfo;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.ebcommon.common.enums.RangeEnum;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.EBPermission;
import kd.epm.eb.common.reportprocess.helper.ApproveBillHelper;
import kd.epm.eb.common.reportprocess.helper.MemberHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.formplugin.centralaudit.CentralOptimization;

public class ApproveBillShowRptBGM {
    protected static final String CON_CTL_DIMORG = "dim_entity";
    protected static final String CON_CTL_DIMENSTIONJSON = "dimensionjson";
    private long model_id;
    private long dimPeriod_id;
    private long dimVersion_id;
    private long dimDatatype_id;
    private long org_id;
    private long orgview_id;
    private long source_id;
    private Set<Long> temp_id = new HashSet<Long>(16);

    public void showTplReport(IFormView view, List<Long> auditors, String curNodeName, String billstatus, String pluginName, boolean isFromAuditPage, boolean showReport) {
        IDataModel model = view.getModel();
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)model.getDataEntity().getLong("id"), (String)"eb_approvebill");
        if (!this.setDimId(bill)) {
            view.setVisible(Boolean.valueOf(false), new String[]{"reportlist"});
            return;
        }
        boolean isFromTask = ProcessTypeEnum.REPORT.getIndex() != bill.getInt("rptProcessType");
        Map<String, Object> paramsMap = this.buildCustomParamsMap(view, bill, isFromTask);
        if (auditors != null && auditors.size() != 0) {
            paramsMap.put("auditors", SerializationUtils.toJsonString(auditors));
        }
        paramsMap.put("CurrentAuditNode", curNodeName);
        paramsMap.put("billstatus", billstatus);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setTargetKey("reportlist");
        formShowParameter.setCustomParams(paramsMap);
        if (isFromTask) {
            formShowParameter.setFormId("eb_executetask");
            if (isFromAuditPage && this.source_id != 0L) {
                paramsMap.put("taskListId", String.valueOf(this.source_id));
            }
        } else {
            DynamicObjectCollection entryentity = bill.getDynamicObjectCollection("entryentity");
            if (entryentity != null) {
                formShowParameter.setFormId("bgm_rptpreparation");
                HashSet processIds = new HashSet(16);
                ArrayList<String> process = new ArrayList<String>(16);
                this.getReportProcess(view, process);
                process.forEach(e -> processIds.add(Long.parseLong(e)));
                paramsMap.put("BILL_ORGID", this.org_id);
                paramsMap.put("BILL_PROCESSID", SerializationUtils.toJsonString(processIds));
                if (this.source_id != 0L) {
                    paramsMap.put("source", this.source_id);
                }
            }
        }
        CentralOptimization.getInstance().addCentralParams(view, formShowParameter);
        formShowParameter.setCloseCallBack(new CloseCallBack(pluginName, "closePage"));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u5ba1\u6838\u4efb\u52a1", (String)"ApproveBillEditPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        formShowParameter.setCustomParam("showReport", (Object)showReport);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        view.showForm(formShowParameter);
        view.getPageCache().put("tplReportPageId", formShowParameter.getPageId());
    }

    public boolean setDimId(DynamicObject bill) {
        DynamicObject modelid = bill.getDynamicObject("modelid");
        DynamicObject dimPeriod = bill.getDynamicObject("dim_period");
        DynamicObject dimVersion = bill.getDynamicObject("dim_version");
        DynamicObject dimDatatype = bill.getDynamicObject("dim_datatype");
        DynamicObject eborgid = bill.getDynamicObject("eborgid");
        DynamicObject orgviewid = bill.getDynamicObject("orgviewid");
        Long source = bill.getLong("source_id");
        DynamicObjectCollection entryentity = (DynamicObjectCollection)bill.get("entryentity");
        if (entryentity == null || entryentity.size() == 0) {
            return false;
        }
        for (DynamicObject object : entryentity) {
            DynamicObject tempid = (DynamicObject)object.get("tempid");
            if (tempid == null) {
                return false;
            }
            this.temp_id.add(tempid.getLong("id"));
        }
        if (eborgid == null || modelid == null || dimPeriod == null || dimVersion == null || dimDatatype == null || source == 0L) {
            return false;
        }
        this.model_id = modelid.getLong("id");
        this.dimPeriod_id = dimPeriod.getLong("id");
        this.dimVersion_id = dimVersion.getLong("id");
        this.dimDatatype_id = dimDatatype.getLong("id");
        this.org_id = eborgid.getLong("id");
        this.orgview_id = orgviewid != null ? orgviewid.getLong("id") : 0L;
        this.source_id = source;
        return true;
    }

    public Map<String, Object> buildCustomParamsMap(IFormView view, DynamicObject bill, boolean isFromTask) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(16);
        List<Object> taskProcessIds = new ArrayList(16);
        DynamicObject billDy = view.getModel().getDataEntity();
        paramsMap.put("modelid", bill.getString("modelid.id"));
        paramsMap.put("tabkey", "tab_myreport");
        long approveBillId = bill.getLong("id");
        if (isFromTask) {
            taskProcessIds = this.getTaskProcessIds(view, approveBillId);
            paramsMap.put("taskProcessIds", SerializationUtils.toJsonString(taskProcessIds));
            paramsMap.put("orgid", String.valueOf(this.org_id));
        }
        paramsMap.put("taskApproveBill", String.valueOf(approveBillId));
        ApproveBillInfo approveBillInfo = ApproveBillHelper.queryBill((Long)approveBillId);
        if (approveBillInfo != null && approveBillInfo.isCentralBill()) {
            HashMap<String, String> definedCustoms = new HashMap<String, String>(16);
            Set reportProcessIds = ApproveUtils.getInstance().getApproveRefReportProcessIds((Collection)Sets.newHashSet((Object[])new Long[]{approveBillId}));
            Map<Long, List> processBillMap = reportProcessIds.stream().collect(Collectors.toMap(e -> e, e -> Collections.singletonList(approveBillId)));
            definedCustoms.put(CentralOptimization.PROCESS_BILL_MAP, SerializationUtils.toJsonString(processBillMap));
            paramsMap.put(CentralOptimization.DEFINED_CUSTOMS, SerializationUtils.toJsonString(definedCustoms));
        }
        paramsMap.put("approveBill", "2");
        if (ApproveUtils.getInstance().isFromHasDealPage(view, bill.getString("billstatus"))) {
            paramsMap.put("wfTaskOnlyView", "true");
        }
        paramsMap.put("isWfApp", String.valueOf(EBPermission.wfApps.contains(view.getFormShowParameter().getAppId())));
        long modelId = ApproveBillShowRptBGM.getModelId(view);
        return this.getParamsMap(paramsMap, billDy, modelId);
    }

    private List<String> getTaskProcessIds(IFormView view, Long approveBillId) {
        QFilter qFilter;
        DynamicObject dynamicObject;
        ArrayList<String> result = new ArrayList<String>(16);
        if (IDUtils.isNotNull((Long)approveBillId) && (dynamicObject = BusinessDataServiceHelper.loadSingle((String)"eb_approvebill", (String)"eborgid,dim_datatype,dim_period,dim_version,entryentity.tempid,orgviewid", (QFilter[])(qFilter = new QFilter("id", "=", (Object)approveBillId)).toArray())) != null) {
            Long period = dynamicObject.getLong("dim_period.id");
            Long version = dynamicObject.getLong("dim_version.id");
            Long datatype = dynamicObject.getLong("dim_datatype.id");
            HashSet tempIds = new HashSet(16);
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            entryentity.forEach(e -> tempIds.add(e.getLong("tempid.id")));
            HashSet entityIds = new HashSet(16);
            Long entity = dynamicObject.getLong("eborgid.id");
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)ApproveBillShowRptBGM.getModelId(view));
            Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), Long.valueOf(dynamicObject.getLong("orgviewid.id")), entity);
            List entitys = modelCacheHelper.getChildren(member, true);
            entitys.forEach(e -> entityIds.add(e.getId()));
            qFilter = new QFilter("org", "in", entityIds);
            qFilter.and("template", "in", tempIds);
            qFilter.and("task.tasklist.year", "in", (Object)period);
            qFilter.and("task.tasklist.version", "in", (Object)version);
            qFilter.and("task.tasklist.datatype", "in", (Object)datatype);
            qFilter.and("task.tasklist", "=", (Object)this.source_id);
            DynamicObjectCollection ids = QueryServiceHelper.query((String)"eb_taskprocess", (String)"id", (QFilter[])qFilter.toArray());
            ids.forEach(e -> result.add(e.getString("id")));
        }
        return result;
    }

    public Map<String, Object> getParamsMap(Map<String, Object> paramsMap, DynamicObject billDy, long modelId) {
        if (modelId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u7cfb\u4e3a\u7a7a", (String)"ApproveBillEditPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        paramsMap.put("model", String.valueOf(modelId));
        return paramsMap;
    }

    public static Long getModelId(IFormView view) {
        String modelId = view.getPageCache().get("modelid");
        if (modelId == null) {
            DynamicObject model = (DynamicObject)view.getModel().getValue("modelId");
            return model.getLong("id");
        }
        return Long.valueOf(modelId);
    }

    public void getReportProcess(IFormView view, List<String> taskProcessIds) {
        DynamicObject[] fromCache;
        Long modelId = ApproveBillShowRptBGM.getModelId(view);
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)modelId);
        Set entityIdSetByView = MemberHelper.getEntityIdSetByView((IModelCacheHelper)orCreate, (Long)this.orgview_id, (Long)this.org_id, (Integer)RangeEnum.VALUE_50.getValue());
        QFBuilder qfBuilder = new QFBuilder("period", "=", (Object)this.dimPeriod_id);
        qfBuilder.add(new QFilter("datatype", "=", (Object)this.dimDatatype_id));
        qfBuilder.add(new QFilter("version", "=", (Object)this.dimVersion_id));
        qfBuilder.add(new QFilter("model", "=", (Object)this.model_id));
        qfBuilder.add(new QFilter("entity", "in", (Object)entityIdSetByView));
        qfBuilder.add(new QFilter("template", "in", this.temp_id));
        for (DynamicObject dynamicObject : fromCache = BusinessDataServiceHelper.load((String)"eb_reportprocess", (String)"id,template", (QFilter[])qfBuilder.toArrays(), (String)"template.number asc")) {
            taskProcessIds.add(String.valueOf(dynamicObject.getLong("id")));
        }
    }
}

