/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.approveBill;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.approveBill.ApproveBillQuery;
import kd.epm.eb.common.approveBill.Entity.ApproveBillRptTemp;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.reportprocess.entity.request.UpdateRptProcessStatusRequest;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessAggService;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.controlParamsSetting.ControlParamsSettingUtil;
import kd.epm.eb.formplugin.approveBill.CommitCommandUtil;
import kd.epm.eb.formplugin.task.command.IBgTaskExecutePlugin;
import org.apache.commons.collections4.CollectionUtils;

public class ApproveBillUtil {
    public static void updateReportStatus(Long modelId, Long processId, Long entityViewId) {
        QFilter qFilter = new QFilter("id", "=", (Object)processId);
        DynamicObject process = QueryServiceHelper.queryOne((String)"eb_reportprocess", (String)"template,entity,period,dataType,version", (QFilter[])qFilter.toArray());
        if (process != null) {
            HashSet<Long> templateIdSet = new HashSet<Long>();
            templateIdSet.add(process.getLong("template"));
            UpdateRptProcessStatusRequest updateRptProcessStatusRequest = new UpdateRptProcessStatusRequest(modelId, entityViewId, templateIdSet, Long.valueOf(process.getLong("entity")), Long.valueOf(process.getLong("period")), Long.valueOf(process.getLong("dataType")), Long.valueOf(process.getLong("version")), Long.valueOf(0L), BgTaskStateEnum.TEMPSAVE);
            ReportProcessAggService.getInstance().updateReportProcessStatus(updateRptProcessStatusRequest);
        }
    }

    public static void doEntityCommitClick(Collection<ApproveBillRptTemp> rptTemps, IBgTaskExecutePlugin formPlugin, IFormView formView, IPageCache pageCache, Long modelId, Long userId, String tip, String key, Long orgViewId) {
        if (formPlugin == null || formView == null || pageCache == null || IDUtils.isEmptyLong((Long)modelId).booleanValue() || IDUtils.isEmptyLong((Long)userId).booleanValue()) {
            return;
        }
        if (CollectionUtils.isNotEmpty(rptTemps)) {
            boolean hasUnPrepared = rptTemps.stream().anyMatch(e -> BgTaskStateEnum.UNPREPARED.getNumber().equals(e.getStatus()));
            boolean noAgainPrompt = ApproveBillUtil.isNoAgainPrompt(modelId, userId);
            boolean isUnWeaveReportConfirm = ControlParamsSettingUtil.getUnWeaveReportConfirm((Long)modelId);
            if (hasUnPrepared && !noAgainPrompt && isUnWeaveReportConfirm) {
                List<ApproveBillRptTemp> unPreparedList = rptTemps.stream().filter(e -> BgTaskStateEnum.UNPREPARED.getNumber().equals(e.getStatus())).collect(Collectors.toList());
                CommitCommandUtil.showNotPromptConfirmWithCloseCallBack(unPreparedList, formView, "eb_notprompt_confirm", formPlugin, tip, "orgcommit_notpromptconfirm", modelId, orgViewId);
            } else {
                formView.showConfirm(tip, MessageBoxOptions.YesNo, new ConfirmCallBackListener(key));
            }
        }
    }

    public static boolean isNoAgainPrompt(Long modelId, Long userId) {
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue() || IDUtils.isEmptyLong((Long)userId).booleanValue()) {
            return false;
        }
        QFilter modelQf = new QFilter("model", "=", (Object)modelId);
        QFilter userQf = new QFilter("user", "=", (Object)userId);
        QFilter noAgainPromptQf = new QFilter("noagainprompt", "=", (Object)true);
        return QueryServiceHelper.exists((String)"eb_userselnotprompt", (QFilter[])new QFilter[]{modelQf, userQf, noAgainPromptQf});
    }

    public static void saveUserSelNotPrompt(Map<String, Object> returnDataMap, Long modelId, Long userId) {
        if (returnDataMap == null || IDUtils.isEmptyLong((Long)modelId).booleanValue() || IDUtils.isEmptyLong((Long)userId).booleanValue()) {
            return;
        }
        Boolean noAgainPrompt = (Boolean)returnDataMap.get("noagainprompt");
        String result = (String)returnDataMap.get("result");
        if (noAgainPrompt.booleanValue() && "true".equals(result)) {
            QFilter modelQf = new QFilter("model", "=", (Object)modelId);
            QFilter userQf = new QFilter("user", "=", (Object)userId);
            DeleteServiceHelper.delete((String)"eb_userselnotprompt", (QFilter[])new QFilter[]{modelQf, userQf});
            DynamicObject newObj = BusinessDataServiceHelper.newDynamicObject((String)"eb_userselnotprompt");
            newObj.set("model", (Object)modelId);
            newObj.set("user", (Object)userId);
            newObj.set("noagainprompt", (Object)true);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newObj});
        }
    }

    public static void updateRptInfos(Collection<ApproveBillRptTemp> rptTemps) {
        if (rptTemps == null || rptTemps.size() == 0) {
            return;
        }
        HashSet rptIds = new HashSet(rptTemps.size());
        rptTemps.forEach(e -> rptIds.add(e.getRptId()));
        Map processOtherInfos = ApproveBillQuery.getInstance().getProcessOtherInfos(rptIds);
        if (processOtherInfos == null || processOtherInfos.size() == 0) {
            return;
        }
        for (ApproveBillRptTemp rptTemp : rptTemps) {
            String processOtherInfo = (String)processOtherInfos.get(rptTemp.getRptId());
            String bill = "0";
            String status = BgTaskStateEnum.UNSTARTED.getNumber();
            if (StringUtils.isNotEmpty((CharSequence)processOtherInfo)) {
                String[] split = processOtherInfo.split("!");
                status = split[0];
                if (split.length > 1 && StringUtils.isNotEmpty((CharSequence)split[1])) {
                    bill = split[1];
                }
            }
            rptTemp.setStatus(status);
            rptTemp.setApproveBillId(IDUtils.toLong((Object)bill));
        }
    }
}

