/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.approveBill;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.engine.dynprocess.freeflow.WFBaseElement;
import kd.bos.workflow.engine.dynprocess.freeflow.WFFlowElement;
import kd.bos.workflow.engine.dynprocess.freeflow.WFRejectNodesModel;
import kd.bos.workflow.engine.dynprocess.freeflow.WFUserTask;
import kd.epm.eb.business.approveBill.ApproveBillServiceHelper;
import kd.epm.eb.business.approveBill.CommitCheck;
import kd.epm.eb.business.approveBill.RejectOnReportService;
import kd.epm.eb.business.approvetype.ApproveUtils;
import kd.epm.eb.business.ebupgrades.utils.UpgradesTaskUtil;
import kd.epm.eb.business.utils.WorkFlowUtil;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.approveBill.Entity.CentralBillType;
import kd.epm.eb.common.enums.ApproveDecisionEnum;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.enums.LocalRecordTypeEnum;
import kd.epm.eb.common.message.MessageUtils;
import kd.epm.eb.common.params.ParamEnum;
import kd.epm.eb.common.params.ParamQueryServiceHelper;
import kd.epm.eb.common.pojo.BasedataPojo;
import kd.epm.eb.common.reportprocess.helper.ApproveBillHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.base.LanguageUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.approveBill.ApproveOptimization;

public class ApproveOperationConfirmPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(ApproveOperationConfirmPlugin.class);
    private Boolean isLocalApprove;
    private Boolean isRejectOpinion;
    private Boolean isRejectOnReport;
    private List<Long> relateApproveBills;
    private List<String> invisibleObjects;
    private Long modelId;
    private Boolean isFromAuditPage;
    private Map<String, List<String>> alterRelateInvisibleMap;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_confirm", "btn_reject", "btn_batchset"});
    }

    public void afterCreateNewData(EventObject e) {
        String defaultAlternative = this.getDefaultAlternative();
        this.setItemsVisible();
        this.setDefaultOpinion(ApproveDecisionEnum.APPROVE.getIndex().equals(defaultAlternative));
        this.alternativeChange(defaultAlternative);
        this.setSavedData();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setDefaultSelected();
    }

    public void setDefaultSelected() {
        String selectProcessIdsJson = (String)this.getCustomFormParam("selectProcessIds");
        if (StringUtils.isEmpty((String)selectProcessIdsJson)) {
            return;
        }
        List selectProcessIds = (List)SerializationUtils.fromJsonString((String)selectProcessIdsJson, ArrayList.class);
        if (selectProcessIds.size() == 0) {
            return;
        }
        DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
        ArrayList<Integer> toSelectRows = new ArrayList<Integer>(16);
        for (int i = 0; i < entity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entity.get(i);
            long reportProcess = dynamicObject.getLong("reportprocess");
            if (!selectProcessIds.contains(reportProcess)) continue;
            toSelectRows.add(i);
        }
        if (toSelectRows.size() != 0) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = new int[toSelectRows.size()];
            for (int i = 0; i < toSelectRows.size(); ++i) {
                selectRows[i] = (Integer)toSelectRows.get(i);
            }
            entryGrid.selectRows(selectRows, ((Integer)toSelectRows.get(0)).intValue());
        }
    }

    private void setItemsVisible() {
        if (!this.isRejectOpinion()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"rejectopinion"});
        }
        if (!this.isRejectOnReport()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"rejectonreport"});
        }
    }

    public String getDefaultAlternative() {
        Object defaultAlternative = this.getView().getFormShowParameter().getCustomParam("defaultAlternative");
        String defaultAlternativeValue = Convert.toStr((Object)defaultAlternative, (String)ApproveDecisionEnum.APPROVE.getIndex());
        if (ApproveDecisionEnum.REJECT_REPORT.getIndex().equals(defaultAlternativeValue) && !this.isRejectOnReport()) {
            defaultAlternativeValue = ApproveDecisionEnum.REJECT_TASK.getIndex();
        }
        this.getModel().setValue("alternative", (Object)defaultAlternativeValue);
        return defaultAlternativeValue;
    }

    public List<String> getInvisibleObjects() {
        if (this.invisibleObjects == null) {
            Object invisibleObjectsJson = this.getView().getFormShowParameter().getCustomParam("invisible_object");
            this.invisibleObjects = invisibleObjectsJson == null ? new ArrayList<String>(16) : (List)SerializationUtils.fromJsonString((String)invisibleObjectsJson.toString(), ArrayList.class);
        }
        return this.invisibleObjects;
    }

    public Map<String, List<String>> getAlterRelateInvisibleMap() {
        if (this.alterRelateInvisibleMap == null) {
            Object alterRelateInvisibleMapJson = this.getView().getFormShowParameter().getCustomParam("alterRelateInvisible");
            this.alterRelateInvisibleMap = alterRelateInvisibleMapJson == null ? new HashMap<String, List<String>>(16) : (Map)SerializationUtils.fromJsonString((String)alterRelateInvisibleMapJson.toString(), HashMap.class);
        }
        return this.alterRelateInvisibleMap;
    }

    public List<String> getRefVisibleObjects(String select) {
        Map<String, List<String>> alterRelateInvisibleMap = this.getAlterRelateInvisibleMap();
        if (alterRelateInvisibleMap.size() == 0) {
            return new ArrayList<String>(16);
        }
        List<String> invisible = alterRelateInvisibleMap.get(select);
        if (invisible == null) {
            invisible = new ArrayList<String>(16);
        }
        HashSet<String> visible = new HashSet<String>(16);
        for (Map.Entry<String, List<String>> entry : alterRelateInvisibleMap.entrySet()) {
            String selectKey = entry.getKey();
            if (select.equals(selectKey)) continue;
            List<String> visibleKeys = entry.getValue();
            visibleKeys.removeAll(invisible);
            visible.addAll(visibleKeys);
        }
        return new ArrayList<String>(visible);
    }

    public List<String> getRefInvisibleObjects(String select) {
        Map<String, List<String>> alterRelateInvisibleMap = this.getAlterRelateInvisibleMap();
        if (alterRelateInvisibleMap.size() == 0) {
            return new ArrayList<String>(16);
        }
        List<String> invisible = alterRelateInvisibleMap.get(select);
        if (invisible == null) {
            invisible = new ArrayList<String>(16);
        }
        return invisible;
    }

    private void setSavedData() {
        if (!this.isFromAuditPage()) {
            return;
        }
        String saveRejectInfo = this.getView().getParentView().getParentView().getPageCache().getBigObject("saveRejectInfo");
        if (StringUtils.isEmpty((String)saveRejectInfo)) {
            return;
        }
        Map savedInfos = (Map)SerializationUtils.fromJsonString((String)saveRejectInfo, HashMap.class);
        for (Map.Entry entry : savedInfos.entrySet()) {
            String fieldKey = (String)entry.getKey();
            if ("relateBills".equals(fieldKey)) continue;
            this.setEntryFieldValues(fieldKey, (String)entry.getValue());
        }
    }

    private void setEntryFieldValues(String fieldKey, String fieldValue) {
        if (StringUtils.isEmpty((String)fieldValue)) {
            return;
        }
        boolean isMustRejectField = "mustreject".equals(fieldKey);
        Map fieldValueMap = (Map)SerializationUtils.fromJsonString((String)fieldValue, HashMap.class);
        DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entity.get(i);
            long reportProcess = dynamicObject.getLong("reportprocess");
            String curFieldValue = (String)fieldValueMap.get(String.valueOf(reportProcess));
            if (!StringUtils.isNotEmpty((String)curFieldValue)) continue;
            this.getModel().setValue(fieldKey, isMustRejectField ? Convert.toBool((Object)curFieldValue, (Boolean)false) : curFieldValue, i);
        }
    }

    private boolean isFromAuditPage() {
        if (this.isFromAuditPage == null) {
            Object isFromAuditPageStr = this.getView().getFormShowParameter().getCustomParam("isFromAuditPage");
            this.isFromAuditPage = Convert.toBool((Object)isFromAuditPageStr, (Boolean)false);
        }
        return this.isFromAuditPage;
    }

    private void showApproveInnerPage() {
        if (this.isNotFirstLoad("auditpasspanel")) {
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_batchcancelconfirm");
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        openStyle.setShowType(ShowType.InContainer);
        openStyle.setTargetKey("auditpasspanel");
        StyleCss styleCss = new StyleCss();
        styleCss.setHeight("450");
        styleCss.setWidth("600px");
        openStyle.setInlineStyleCss(styleCss);
        formShowParameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
        formShowParameter.setCustomParam("hideButtons", (Object)"true");
        formShowParameter.setCustomParam("definedLabelText", (Object)ResManager.loadKDString((String)"\u672c\u6b21\u64cd\u4f5c\u4f1a\u5ba1\u6838\u901a\u8fc7\u7684\u62a5\u8868\u5982\u4e0b\uff1a", (String)"ApproveOperationConfirmPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        formShowParameter.setCloseCallBack(new CloseCallBack(this.getPluginName(), "showInnerPage"));
        this.getView().showForm(formShowParameter);
    }

    private boolean isRejectOpinion() {
        if (this.isRejectOpinion == null) {
            this.isRejectOpinion = ParamQueryServiceHelper.getBoolean((long)this.getModelId(), (ParamEnum)ParamEnum.BG007);
        }
        return this.isRejectOpinion;
    }

    private boolean isRejectOnReport() {
        if (this.isRejectOnReport == null) {
            this.isRejectOnReport = ParamQueryServiceHelper.getBoolean((long)this.getModelId(), (ParamEnum)ParamEnum.BG034) && !ApproveBillHelper.hasCentralBill(this.getRelateApproveBills());
        }
        return this.isRejectOnReport;
    }

    private boolean isLocalApprove() {
        if (this.isLocalApprove == null) {
            Object containLocalApprove = this.getView().getFormShowParameter().getCustomParam("containLocalApprove");
            this.isLocalApprove = Convert.toBool((Object)containLocalApprove, (Boolean)false);
        }
        return this.isLocalApprove;
    }

    private void setDefaultOpinion(boolean isApprove) {
        String opinion = ResManager.loadKDString((String)"\u9a73\u56de", (String)"ApproveOperationConfirmPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        if (isApprove) {
            opinion = ResManager.loadKDString((String)"\u540c\u610f", (String)"ApproveOperationConfirmPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        this.getModel().setValue("opinion", (Object)opinion);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        if (((Boolean)this.getCache("ignorePropertyChange", Boolean.class, () -> false)).booleanValue()) {
            return;
        }
        if ("alternative".equals(name)) {
            ChangeData changeSet = e.getChangeSet()[0];
            Object newValue = changeSet.getNewValue();
            String errMessage = this.validateSwitchItem(newValue);
            if (StringUtils.isNotEmpty((String)errMessage)) {
                this.getModel().setValue("alternative", changeSet.getOldValue());
                this.getView().showTipNotification(errMessage);
            } else {
                this.alternativeChange(newValue);
            }
        } else if ("mustreject".equals(name)) {
            String rejectOpinion;
            ChangeData changeSet = e.getChangeSet()[0];
            Object newValue = changeSet.getNewValue();
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int focusRow = entryGrid.getEntryState().getFocusRow();
            if (Convert.toBool((Object)newValue, (Boolean)false).booleanValue() && StringUtils.isEmpty((String)(rejectOpinion = (String)this.getModel().getValue("rejectopinion", focusRow)))) {
                this.getModel().setValue("rejectopinion", (Object)ResManager.loadKDString((String)"\u9a73\u56de", (String)"ApproveOperationConfirmPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), focusRow);
            }
        }
    }

    private String validateSwitchItem(Object selected) {
        DynamicObjectCollection approveBills;
        ApproveDecisionEnum decision = ApproveDecisionEnum.getDecisionByIndex((String)((String)selected));
        if (selected == null || decision == null) {
            return ResManager.loadKDString((String)"\u9009\u62e9\u4e86\u9519\u8bef\u7684\u51b3\u7b56\u9879\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ApproveOperationConfirmPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        if (ApproveDecisionEnum.APPROVE == decision) {
            return null;
        }
        if (!this.isLocalApprove() && (approveBills = QueryServiceHelper.query((String)"eb_approvebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", this.getRelateApproveBills())})).size() != 1) {
            return ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u5f20\u5355\u636e\u9a73\u56de", (String)"ApproveOperationConfirmPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    private List<Long> getRelateApproveBills() {
        Map customParams;
        Object relateApproveBillsJson;
        if (this.relateApproveBills == null && (relateApproveBillsJson = (customParams = this.getView().getFormShowParameter().getCustomParams()).get("relateApproveBills")) != null) {
            this.relateApproveBills = (List)SerializationUtils.fromJsonString((String)relateApproveBillsJson.toString(), ArrayList.class);
        }
        return this.relateApproveBills;
    }

    private void alternativeChange(Object selected) {
        List<String> refInvisibleObjects;
        List<String> refVisibleObjects;
        String select = selected.toString();
        ApproveDecisionEnum decision = ApproveDecisionEnum.getDecisionByIndex((String)select);
        if (ApproveDecisionEnum.APPROVE == decision) {
            this.showApproveInnerPage();
        } else {
            Boolean isBatchSetVisible = this.isRejectOpinion();
            this.loadRejectEntity(isBatchSetVisible);
            if (this.isFromAuditPage()) {
                String rejectNode = (String)this.getView().getFormShowParameter().getCustomParam("rejectNode");
                String rejectOpinion = (String)this.getView().getFormShowParameter().getCustomParam("rejectOpinion");
                this.getModel().setValue("rejectnode", (Object)rejectNode);
                this.getModel().setValue("opinion", (Object)rejectOpinion);
            } else {
                this.loadRejectNodes();
            }
            this.setLabelView(select);
            this.setEntryView(isBatchSetVisible, decision);
        }
        List<String> invisibleObjects = this.getInvisibleObjects();
        if (invisibleObjects.size() != 0) {
            this.getView().setVisible(Boolean.valueOf(false), invisibleObjects.toArray(new String[0]));
        }
        if ((refVisibleObjects = this.getRefVisibleObjects(select)).size() != 0) {
            this.getView().setVisible(Boolean.valueOf(true), refVisibleObjects.toArray(new String[0]));
        }
        if ((refInvisibleObjects = this.getRefInvisibleObjects(select)).size() != 0) {
            this.getView().setVisible(Boolean.valueOf(false), refInvisibleObjects.toArray(new String[0]));
        }
        if (!this.isRejectOpinion()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"mustreject"});
        }
        this.setDefaultOpinion(ApproveDecisionEnum.APPROVE == decision);
        if (ApproveDecisionEnum.REJECT_TASK == decision) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"handler"});
        } else if (ApproveDecisionEnum.REJECT_REPORT == decision) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"handler"});
        }
    }

    private void setEntryView(Boolean isBatchSetVisible, ApproveDecisionEnum decision) {
        if (ApproveDecisionEnum.REJECT_REPORT == decision) {
            this.getView().setVisible(isBatchSetVisible, new String[]{"btn_batchset"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"entryentity"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"entryentity_withoutselect"});
        } else {
            this.getView().setVisible(isBatchSetVisible, new String[]{"btn_batchset", "entryentity"});
            this.getView().setVisible(Boolean.valueOf(isBatchSetVisible == false), new String[]{"entryentity_withoutselect"});
        }
    }

    private void setLabelView(String select) {
        Label label = (Label)this.getControl("labelap");
        String labelValue = ResManager.loadKDString((String)"\u672c\u6b21\u64cd\u4f5c\u4f1a\u9a73\u56de\u7684\u62a5\u8868\u5982\u4e0b\uff1a", (String)"ApproveOperationConfirmPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        if (ApproveDecisionEnum.REJECT_REPORT.getIndex().equals(select)) {
            labelValue = ResManager.loadKDString((String)"\u8bf7\u6807\u8bb0\u9700\u8981\u9a73\u56de\u7684\u62a5\u8868\uff1a", (String)"ApproveOperationConfirmPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        label.setText(labelValue);
    }

    public void loadRejectEntity(Boolean isBatchSetVisible) {
        HashMap processInfo;
        if (this.isNotFirstLoad("entryentity")) {
            this.clearRejectEntity();
            return;
        }
        List<Long> relateApproveBills = this.getRelateApproveBills();
        Map rejectStatusMap = new HashMap(16);
        if (this.isLocalApprove()) {
            processInfo = ApproveUtils.getInstance().getProcessRefTemplateInfo(relateApproveBills);
        } else {
            Map _processInfo = ApproveUtils.getInstance().getApproveRefReportProcessInfo(relateApproveBills);
            processInfo = new HashMap(16);
            _processInfo.forEach((key, value) -> processInfo.put(key, value.getTemplateId()));
            rejectStatusMap = ApproveUtils.getInstance().getProcessRejectStatusByApprove(relateApproveBills);
        }
        Map nextAuditorMap = new HashMap(16);
        HashSet rejectRptIds = new HashSet(16);
        for (Map.Entry entry : processInfo.entrySet()) {
            String rejectInfo = (String)rejectStatusMap.get(entry.getKey());
            if (!StringUtils.isNotEmpty((String)rejectInfo)) continue;
            rejectRptIds.add(entry.getKey());
        }
        HashMap<Long, String> rejectBillMap = new HashMap<Long, String>(16);
        if (!rejectRptIds.isEmpty()) {
            QFilter qFilter = new QFilter("id", "in", rejectRptIds);
            DynamicObjectCollection reportList = QueryServiceHelper.query((String)"eb_reportprocess", (String)"id,approvebill", (QFilter[])qFilter.toArray());
            for (DynamicObject report : reportList) {
                Long reportId = report.getLong("id");
                Long approveBillId = report.getLong("approvebill");
                if (!IDUtils.isNotNull((Long)approveBillId)) continue;
                rejectBillMap.put(reportId, approveBillId.toString());
            }
        }
        if (!rejectBillMap.isEmpty()) {
            ArrayList rejectBillIds = new ArrayList(rejectBillMap.size());
            rejectBillMap.values().forEach(ids -> rejectBillIds.addAll(Collections.singleton(ids)));
            nextAuditorMap = ApproveUtils.getInstance().getNextAuditor(rejectBillIds);
        }
        for (Map.Entry entry : processInfo.entrySet()) {
            String rejectBillId;
            String[] rejectInfoArr;
            int newEntryRow = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("reportprocess", entry.getKey(), newEntryRow);
            this.getModel().setValue("reportnumber", entry.getValue(), newEntryRow);
            String status = "";
            String handler = "";
            String rejectInfo = (String)rejectStatusMap.get(entry.getKey());
            if (StringUtils.isNotEmpty((String)rejectInfo) && "2".equals(status = (rejectInfoArr = rejectInfo.split("#"))[0]) && StringUtils.isNotEmpty((String)(rejectBillId = (String)rejectBillMap.get(entry.getKey())))) {
                handler = (String)nextAuditorMap.get(rejectBillId);
            }
            this.getModel().setValue("status", (Object)status, newEntryRow);
            this.getModel().setValue("handler", (Object)handler, newEntryRow);
            int newRow = this.getModel().createNewEntryRow("entryentity_withoutselect");
            this.getModel().setValue("reportprocess1", entry.getKey(), newRow);
            this.getModel().setValue("reportnumber1", entry.getValue(), newRow);
        }
    }

    public void clearRejectEntity() {
        DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entity.size(); ++i) {
            String rejectOpinion;
            DynamicObject dynamicObject = (DynamicObject)entity.get(i);
            boolean mustReject = dynamicObject.getBoolean("mustreject");
            if (mustReject) {
                this.getModel().setValue("mustreject", (Object)false, i);
            }
            if (!StringUtils.isNotEmpty((String)(rejectOpinion = dynamicObject.getString("rejectopinion")))) continue;
            this.getModel().setValue("rejectopinion", (Object)"", i);
        }
    }

    public void loadRejectNodes() {
        if (this.isNotFirstLoad("rejectnode")) {
            return;
        }
        Long relateApproveBill = this.getRelateApproveBills().get(0);
        String businessKey = String.valueOf(relateApproveBill);
        Long taskId = WorkflowServiceHelper.getTaskIdByBusinessKeyAndUserId((String)businessKey, (Long)UserUtils.getUserId());
        if (taskId == null || taskId == 0L) {
            return;
        }
        String rejectOptionNumber = WorkFlowUtil.getRejectOptionNumber((Long)taskId);
        if (StringUtils.isEmpty((String)rejectOptionNumber)) {
            return;
        }
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        ArrayList<String> nodeIds = new ArrayList<String>(16);
        String firstNodeId = this.getRejectNodes(taskId, rejectOptionNumber, nodeIds, businessKey, comboItems);
        ComboEdit nodeCombo = (ComboEdit)this.getControl("rejectnode");
        nodeCombo.setComboItems(comboItems);
        if (!nodeIds.isEmpty()) {
            String nodeId = (String)nodeIds.get(0);
            this.getModel().setValue("rejectnode", (Object)(nodeId + "#" + firstNodeId));
        }
    }

    private String getRejectNodes(Long taskId, String rejectOptionNumber, List<String> nodeIds, String businessKey, List<ComboItem> comboItems) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)this.getRelateApproveBills().get(0), (String)"eb_approvebill");
        List elements = WorkflowServiceHelper.getProcessElements((DynamicObject)dynamicObject, (String)"submit");
        Map<Object, Object> elementMap = elements == null ? new HashMap(16) : elements.stream().collect(Collectors.toMap(WFBaseElement::getId, e -> e, (n1, n2) -> n2));
        List rejectNodes = WorkFlowUtil.getRejectNodes((Long)taskId, (String)rejectOptionNumber);
        if (rejectNodes.size() == 0) {
            return null;
        }
        nodeIds.addAll(rejectNodes.stream().map(WFRejectNodesModel::getItemId).collect(Collectors.toList()));
        List allApprovalRecord = WorkFlowUtil.getAllApprovalRecord((String)businessKey);
        HashMap<String, List> nodeDetailInfo = new HashMap<String, List>(16);
        for (IApprovalRecordGroup approvalRecordGroup : allApprovalRecord) {
            String groupDecisionType = approvalRecordGroup.getGroupDecisionType();
            if ("wait".equals(groupDecisionType)) continue;
            List children = approvalRecordGroup.getChildren();
            for (IApprovalRecordItem child : children) {
                String activityId = child.getActivityId();
                if (!nodeIds.contains(activityId)) continue;
                String activityName = child.getActivityName();
                List baseDataPojos = nodeDetailInfo.computeIfAbsent(activityId, k -> new ArrayList(16));
                if (!this.isNotContain(baseDataPojos, child.getUserId())) continue;
                baseDataPojos.add(new BasedataPojo(child.getUserId(), activityName.substring(0, activityName.length() - 1), child.getAssignee()));
            }
        }
        if (nodeDetailInfo.size() == 0) {
            return null;
        }
        String firstNodeId = "";
        for (String nodeId : nodeIds) {
            ComboItem item = new ComboItem();
            List baseDataPojos = (List)nodeDetailInfo.get(nodeId);
            if (baseDataPojos == null || baseDataPojos.size() == 0) continue;
            String nodeName = "";
            ArrayList<String> showNames = new ArrayList<String>(16);
            ArrayList<String> userIds = new ArrayList<String>(16);
            WFFlowElement wfFlowElement = (WFFlowElement)elementMap.get(nodeId);
            boolean isSubmitTask = this.isSubmitTask(wfFlowElement);
            for (BasedataPojo baseDataPojo : baseDataPojos) {
                if (isSubmitTask) {
                    showNames.add(baseDataPojo.getNumber());
                }
                userIds.add(String.valueOf(baseDataPojo.getId()));
                nodeName = baseDataPojo.getName();
            }
            String showNameStr = String.join((CharSequence)"\u3001", showNames);
            if (StringUtils.isNotEmpty((String)showNameStr)) {
                nodeName = nodeName + "-" + showNameStr;
            }
            item.setCaption(new LocaleString(nodeName));
            String nodeUserId = String.join((CharSequence)"_", userIds);
            item.setValue(nodeId + "#" + nodeUserId);
            comboItems.add(item);
            if (!StringUtils.isEmpty((String)firstNodeId)) continue;
            firstNodeId = nodeUserId;
        }
        return firstNodeId;
    }

    private boolean isSubmitTask(WFFlowElement wfFlowElement) {
        WFUserTask wfUserTask;
        String type;
        boolean isSubmitTask = false;
        if (wfFlowElement instanceof WFUserTask && "UserTask".equalsIgnoreCase(type = (wfUserTask = (WFUserTask)wfFlowElement).getType())) {
            isSubmitTask = true;
        }
        return isSubmitTask;
    }

    private boolean isNotContain(List<BasedataPojo> baseDataPojos, Long userId) {
        if (userId == null) {
            return false;
        }
        for (BasedataPojo baseDataPojo : baseDataPojos) {
            if (!userId.equals(baseDataPojo.getId())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Long getModelId() {
        if (this.modelId == null) {
            Object modelIdStr = this.getView().getFormShowParameter().getCustomParam("modelId");
            this.modelId = ConvertUtils.toLong((Object)modelIdStr);
        }
        return this.modelId;
    }

    private boolean isNotFirstLoad(String fieldKey) {
        String loadKey = this.getPageCache().get("firstLoad_" + fieldKey);
        if (StringUtils.isEmpty((String)loadKey)) {
            this.cacheFirstLoad(fieldKey);
            return false;
        }
        return true;
    }

    private void cacheFirstLoad(String fieldKey) {
        this.getPageCache().put("firstLoad_" + fieldKey, "true");
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btn_batchset".equals(key)) {
            this.openBatchSetPage();
            return;
        }
        ArrayList<Long> inRejectApproveBills = new ArrayList<Long>(16);
        ArrayList<Long> processIds = new ArrayList<Long>(16);
        if (this.approveInfoNotValidate() || this.rejectInfoNotValidate(key) || this.approveNotValidate(key, inRejectApproveBills, processIds) || this.checkCentralAuditPass(key)) {
            return;
        }
        boolean needClose = false;
        if ("btn_confirm".equals(key)) {
            String alternative = (String)this.getValue("alternative", null);
            ApproveDecisionEnum decision = ApproveDecisionEnum.getDecisionByIndex((String)alternative);
            if (this.isFromAuditPage() && ApproveDecisionEnum.REJECT_TASK == decision) {
                HashMap<String, String> retData = new HashMap<String, String>(16);
                this.collectRejectEntityData(retData);
                this.getView().getParentView().getParentView().getPageCache().putBigObject("saveRejectInfo", SerializationUtils.toJsonString(retData));
                HashMap<String, String> returnData = new HashMap<String, String>(2);
                returnData.put("result", "success");
                returnData.put("approveDecision", decision.getIndex());
                this.getView().returnDataToParent(returnData);
                needClose = true;
            } else {
                boolean success;
                block26: {
                    if (this.isLocalApprove()) {
                        try (TXHandle tx = TX.requiresNew((String)"localApprove");){
                            try {
                                success = this.dealLocalApprove();
                                break block26;
                            }
                            catch (Exception ex) {
                                tx.markRollback();
                                log.error((Throwable)ex);
                                throw new KDBizException(ResManager.loadKDString((String)"\u672c\u5730\u5ba1\u6838\u5b58\u5728\u95ee\u9898\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ApproveOperationConfirmPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            }
                        }
                    }
                    if (ApproveDecisionEnum.APPROVE == decision) {
                        this.dealAuditPass();
                        this.batchUpdateStatus();
                        success = true;
                    } else {
                        success = this.dealReject(inRejectApproveBills, processIds);
                    }
                }
                if (success) {
                    HashMap<String, String> returnData = new HashMap<String, String>(2);
                    returnData.put("result", "success");
                    returnData.put("approveDecision", decision.getIndex());
                    this.getView().returnDataToParent(returnData);
                    needClose = true;
                }
            }
        } else if ("btn_reject".equals(key) && this.dealReject(inRejectApproveBills, processIds)) {
            this.getView().returnDataToParent((Object)"rejectAndClosePage");
            needClose = true;
        }
        if (needClose) {
            this.getView().close();
        }
    }

    private void batchUpdateStatus() {
        List<Long> relateApproveBills = this.getRelateApproveBills();
        ArrayList<Long> toUpdateBills = new ArrayList<Long>(16);
        for (Long relateApproveBill : relateApproveBills) {
            boolean joinAuditNode = ApproveUtils.getInstance().isJoinAuditNode(relateApproveBill);
            if (joinAuditNode) continue;
            toUpdateBills.add(relateApproveBill);
        }
        ArrayList processIds = new ArrayList(16);
        List inRejectApproveBills = ApproveUtils.getInstance().getInRejectApproveBills(toUpdateBills, processIds);
        if (inRejectApproveBills.size() != 0) {
            processIds.addAll(ApproveUtils.getInstance().getApproveRefReportProcessIds((Collection)inRejectApproveBills));
        }
        ApproveUtils.getInstance().updateRejectBillStatus((Collection)inRejectApproveBills, processIds);
        if (toUpdateBills.size() != 0) {
            ApproveUtils.getInstance().deleteApproveBillReadRecord(toUpdateBills);
        }
    }

    private boolean approveInfoNotValidate() {
        String alternative = (String)this.getValue("alternative", null);
        List<String> refInvisibleObjects = this.getRefInvisibleObjects(alternative);
        if (refInvisibleObjects.contains("opinionpanel")) {
            return false;
        }
        Object opinion = this.getValue("opinion", null);
        if (opinion == null || StringUtils.isEmpty((String)opinion.toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5ba1\u6279\u5931\u8d25\uff0c\u5ba1\u6279\u610f\u89c1\u4e0d\u80fd\u4e3a\u7a7a", (String)"ApproveOperationConfirmPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void openBatchSetPage() {
        ApproveOptimization.getInstance().openBatchSetPage(this.getView(), this.getPluginName(), this.getInvisibleKeys(), this.getModelId(), "entryentity");
    }

    private String getInvisibleKeys() {
        ArrayList<String> invisibleKeys = new ArrayList<String>(16);
        String alternative = (String)this.getValue("alternative", null);
        ApproveDecisionEnum decision = ApproveDecisionEnum.getDecisionByIndex((String)alternative);
        if (ApproveDecisionEnum.REJECT_LOCAL == decision) {
            invisibleKeys.add("mustreject");
        } else if (ApproveDecisionEnum.REJECT_REPORT == decision) {
            invisibleKeys.add("mustreject");
        }
        invisibleKeys.add("submitdesc");
        return SerializationUtils.toJsonString(invisibleKeys);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (!"batchSet".equals(actionId)) {
            return;
        }
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        Map retData = (Map)SerializationUtils.fromJsonString((String)returnData.toString(), HashMap.class);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] rows = entryGrid.getSelectRows();
        if (rows.length == 0) {
            return;
        }
        this.putCache("ignorePropertyChange", true);
        for (int row : rows) {
            retData.forEach((key, value) -> {
                if ("opinion".equals(key)) {
                    this.getModel().setValue("rejectopinion", value, row);
                } else {
                    this.getModel().setValue(key, (Object)Convert.toBool((Object)value, (Boolean)false), row);
                }
            });
        }
        this.removeCache("ignorePropertyChange");
    }

    private boolean rejectInfoNotValidate(String key) {
        String alternative = (String)this.getValue("alternative", null);
        if ("btn_confirm".equals(key) && ApproveDecisionEnum.APPROVE.getIndex().equals(alternative)) {
            return false;
        }
        ArrayList<String> errRows = new ArrayList<String>(16);
        DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entity.size(); ++i) {
            String rejectOpinion;
            DynamicObject dynamicObject = (DynamicObject)entity.get(i);
            boolean mustReject = dynamicObject.getBoolean("mustreject");
            if (!mustReject || !StringUtils.isEmpty((String)(rejectOpinion = dynamicObject.getString("rejectopinion")))) continue;
            errRows.add(String.valueOf(i + 1));
        }
        if (errRows.size() != 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9a73\u56de\u5931\u8d25\uff0c\u7b2c%s\u884c\u9700\u8981\u586b\u5165\u9a73\u56de\u610f\u89c1", (String)"ApproveOperationConfirmPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)"\u3001", errRows)}));
            return true;
        }
        return false;
    }

    private boolean approveNotValidate(String clickKey, List<Long> inRejectApproveBills, List<Long> processIds) {
        String alternative = (String)this.getValue("alternative", null);
        ApproveDecisionEnum decision = ApproveDecisionEnum.getDecisionByIndex((String)alternative);
        if ("btn_confirm".equals(clickKey) && this.isFromAuditPage() && ApproveDecisionEnum.REJECT_TASK == decision) {
            return false;
        }
        ApproveUtils instance = ApproveUtils.getInstance();
        inRejectApproveBills.addAll(instance.getInRejectApproveBills(this.getRelateApproveBills(), processIds));
        List<Long> _processIds = new ArrayList<Long>(processIds);
        if (inRejectApproveBills.size() != 0) {
            processIds.addAll(instance.getApproveRefReportProcessIds(inRejectApproveBills));
        }
        if (ApproveDecisionEnum.REJECT_TASK == decision || ApproveDecisionEnum.APPROVE == decision) {
            Set notAllDealProcesses;
            if (ApproveDecisionEnum.REJECT_TASK == decision) {
                _processIds = processIds;
            }
            if ((notAllDealProcesses = instance.getNotAllDealProcesses(_processIds, this.getRelateApproveBills())).size() != 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5ba1\u6838\u5931\u8d25\uff0c\u5f53\u524d\u5355\u636e\u5b58\u5728\u5982\u4e0b\u672a\u5904\u7406\u5b8c\u6210\u7684\u9a73\u56de\u62a5\u8868\uff1a\r\n%s", (String)"ApproveOperationConfirmPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)"\r\n", notAllDealProcesses)}));
                return true;
            }
        }
        return false;
    }

    private void collectRejectEntityData(Map<String, String> retData) {
        DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
        HashMap<Long, String> mustRejectMap = new HashMap<Long, String>(16);
        HashMap<Long, String> opinion = new HashMap<Long, String>(16);
        ArrayList<Long> relateProcessIds = new ArrayList<Long>(16);
        for (DynamicObject dynamicObject : entity) {
            String rejectOpinion;
            long reportProcess = dynamicObject.getLong("reportprocess");
            boolean mustReject = dynamicObject.getBoolean("mustreject");
            if (mustReject) {
                mustRejectMap.put(reportProcess, "true");
            }
            if (StringUtils.isNotEmpty((String)(rejectOpinion = dynamicObject.getString("rejectopinion")))) {
                opinion.put(reportProcess, rejectOpinion);
            }
            relateProcessIds.add(reportProcess);
        }
        if (mustRejectMap.size() != 0) {
            retData.put("mustreject", SerializationUtils.toJsonString(mustRejectMap));
        }
        if (opinion.size() != 0) {
            retData.put("rejectopinion", SerializationUtils.toJsonString(opinion));
        }
        retData.put("relateBills", SerializationUtils.toJsonString(relateProcessIds));
    }

    public boolean dealLocalApprove() {
        String fields = "id, template.id as tempId, approvebill, approvebill.billno as billno, entity, submitentity, approvebill.orgviewid as orgviewid";
        DynamicObjectCollection processes = QueryServiceHelper.query((String)"eb_reportprocess", (String)fields, (QFilter[])new QFilter[]{new QFilter("id", "in", this.relateApproveBills)});
        ArrayList processIds = new ArrayList(16);
        ArrayList<Long> tempIds = new ArrayList<Long>(16);
        ArrayList<Long> approveBillIds = new ArrayList<Long>(16);
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        long[] pkIds = DB.genGlobalLongIds((int)processes.size());
        String opinion = (String)this.getValue("opinion", null);
        String alternative = (String)this.getValue("alternative", null);
        boolean isReject = ApproveDecisionEnum.REJECT_LOCAL.getIndex().equals(alternative);
        String type = isReject ? LocalRecordTypeEnum.REJECT.getIndex() : LocalRecordTypeEnum.APPROVE.getIndex();
        Timestamp timeStamp = new Timestamp(TimeServiceHelper.getTimeStamp());
        Long userId = UserUtils.getUserId();
        String userMainJob = UserServiceHelper.getUserMainJob((long)userId);
        HashMap approveProcessMap = new HashMap(16);
        HashMap processDetailMap = new HashMap(16);
        processes.forEach(e -> {
            long id = e.getLong("id");
            processIds.add(id);
            tempIds.add(e.getLong("tempId"));
            long approvebill = e.getLong("approvebill");
            approveBillIds.add(approvebill);
            params.add(new Object[]{pkIds[params.size()], id, type, opinion, timeStamp, userId, userMainJob, e.getString("billno"), e.getLong("entity"), e.getLong("submitentity"), e.getLong("orgviewid")});
            approveProcessMap.put(id, approvebill);
            processDetailMap.put(id, e.getString("billno") + "!" + e.getLong("entity") + "!" + e.getLong("submitentity") + "!" + e.getLong("orgviewid"));
        });
        Map approveDescMap = ApproveUtils.getInstance().getApproveDescMap(approveProcessMap.keySet());
        String _fields = "id, approveinfo, createrid.id as creater, createdate";
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"eb_approvebill", (String)_fields, (QFilter[])new QFilter[]{new QFilter("id", "in", approveProcessMap.values())});
        HashMap approveInfoMap = new HashMap(16);
        HashMap approveUserMap = new HashMap(16);
        ArrayList userIds = new ArrayList(16);
        bills.forEach(e -> {
            long id = e.getLong("id");
            approveInfoMap.put(id, e.getString("approveinfo"));
            approveUserMap.put(id, new Pair((Object)e.getLong("creater"), (Object)e.getDate("createdate")));
            userIds.add(e.getLong("creater"));
        });
        Map userMainJobs = UserServiceHelper.getUserMainJob(userIds);
        long[] pkids = DB.genGlobalLongIds((int)(approveProcessMap.size() * 2));
        int index = -1;
        for (Map.Entry entry : approveProcessMap.entrySet()) {
            boolean canOperation;
            Long processId = (Long)entry.getKey();
            Long approveBillId = (Long)entry.getValue();
            if (isReject && !(canOperation = new CommitCheck().checkCurrentSchemeOrTaskEntityReportCanOperation(approveBillId, null, false))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u5df2\u63d0\u4ea4\uff0c\u4e0d\u80fd\u9a73\u56de\u3002", (String)"ApproveOperationConfirmPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
            Iterator pair = approveUserMap.getOrDefault(approveBillId, new Pair((Object)0L, (Object)new Date()));
            String detailInfos = processDetailMap.getOrDefault(processId, "");
            String[] split = detailInfos.split("!");
            String billNo = split[0];
            Long entityId = ConvertUtils.toLong(split.length >= 2 ? split[1] : null);
            Long submitEntityId = ConvertUtils.toLong(split.length >= 3 ? split[2] : null);
            Long viewId = ConvertUtils.toLong(split.length >= 4 ? split[3] : null);
            String mainJob = userMainJobs.getOrDefault(((Pair)pair).p1, "");
            String approveDesc = approveDescMap.getOrDefault(processId, "");
            params.add(new Object[]{pkids[++index], processId, LocalRecordTypeEnum.APPROVE_DESC.getIndex(), approveDesc, new Timestamp(((Date)((Pair)pair).p2).getTime()), ((Pair)pair).p1, mainJob, billNo, entityId, submitEntityId, viewId});
            String submitDesc = approveInfoMap.getOrDefault(approveBillId, "");
            params.add(new Object[]{pkids[++index], processId, LocalRecordTypeEnum.SUBMIT_DESC.getIndex(), submitDesc, new Timestamp(((Date)((Pair)pair).p2).getTime()), ((Pair)pair).p1, mainJob, billNo, entityId, submitEntityId, viewId});
        }
        String reportStatus = BgTaskStateEnum.COMPLETED.getNumber();
        if (isReject) {
            reportStatus = BgTaskStateEnum.INCOMPLETE.getNumber();
            ArrayList opinion_params = new ArrayList(16);
            DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
            long[] _pkIds = DB.genGlobalLongIds((int)entity.size());
            for (DynamicObject dynamicObject : entity) {
                String rejectOpinion = dynamicObject.getString("rejectopinion");
                if (StringUtils.isEmpty((String)rejectOpinion)) {
                    rejectOpinion = "";
                }
                opinion_params.add(new Object[]{_pkIds[opinion_params.size()], dynamicObject.getLong("reportprocess"), "0", rejectOpinion, "", "", "0", userId, timeStamp, "0", "1", 0L});
            }
            if (opinion_params.size() != 0) {
                ApproveUtils.getInstance().saveRejectOpinion((List)opinion_params);
            }
            ApproveUtils.getInstance().addHistoryApproveRecord(new HashSet(approveBillIds), "local_unsubmit", (ILocaleString)ResManager.getLocaleString((String)"\u64a4\u9500", (String)"ApproveOperationConfirmPlugin_26", (String)"epm-eb-formplugin"));
        }
        for (DynamicObject process : processes) {
            if (process.getLong("entity") == process.getLong("submitentity")) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u4e0a\u7ea7\u7ec4\u7ec7\u63d0\u4ea4\u7684\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u5ba1\u6838", (String)"ApproveOperationConfirmPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        Set relProcessIds = ApproveUtils.getInstance().getProcessRefReportProcessInfoWithAllEntity(processIds);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("update t_eb_reportprocess set fstatus = ? ", new Object[]{reportStatus});
        sqlBuilder.append(" where ", new Object[0]);
        sqlBuilder.appendIn("fid", relProcessIds.toArray());
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
        ApproveUtils.getInstance().saveLocalApproveOpinion(params);
        HashSet<Long> rejectBillIds = new HashSet<Long>(16);
        QFilter qFilter = new QFilter("id", "in", approveBillIds);
        DynamicObjectCollection approveBills = QueryServiceHelper.query((String)"eb_approvebill", (String)"id,splitbilltype", (QFilter[])qFilter.toArray());
        for (DynamicObject approveBill : approveBills) {
            Long billId = approveBill.getLong("id");
            String billType = approveBill.getString("splitbilltype");
            if (!CentralBillType.Reject.getNumber().equals(billType)) continue;
            rejectBillIds.add(billId);
        }
        RejectOnReportService.getInstance().auditSelfRejectBill(rejectBillIds);
        if (isReject) {
            ApproveBillServiceHelper.unLockDimMemForLocalApprove(new HashSet(approveBillIds));
        } else {
            ApproveBillServiceHelper.saveLocalApproveBill(new HashSet(approveBillIds));
        }
        ApproveOptimization.getInstance().deleteTemplateInApproveBill(approveBillIds, tempIds);
        UpgradesTaskUtil.getInstance().clearDataEntityCache("eb_reportprocess");
        return true;
    }

    public boolean dealReject(Collection<Long> inRejectApproveBills, Collection<Long> processIds) {
        String opinion;
        String nodeId;
        List<Long> relateApproveBills = this.getRelateApproveBills();
        Long relateApproveBill = relateApproveBills.get(0);
        String billNo = ApproveUtils.getInstance().isParentEntityInApprove(relateApproveBill);
        for (Long inRejectApproveBill : inRejectApproveBills) {
            boolean canOperation = new CommitCheck().checkCurrentSchemeOrTaskEntityReportCanOperation(inRejectApproveBill, null, false);
            if (canOperation) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u5df2\u63d0\u4ea4\uff0c\u4e0d\u80fd\u9a73\u56de\u3002", (String)"ApproveOperationConfirmPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (billNo != null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u5b58\u5728\u4e0a\u7ea7\u7ec4\u7ec7\u63d0\u4ea4\u7684\u5355\u636e\u201c%1\u201d\uff0c\u4e0d\u80fd\u9a73\u56de\u3002", (String)"ApproveOperationConfirmPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[]{billNo}));
        }
        Long userId = this.getUserId();
        Timestamp timeStamp = new Timestamp(TimeServiceHelper.getTimeStamp());
        String businessKey = String.valueOf(relateApproveBill);
        Long taskId = WorkflowServiceHelper.getTaskIdByBusinessKeyAndUserId((String)businessKey, (Long)userId);
        String alternative = (String)this.getValue("alternative", null);
        if (ApproveDecisionEnum.REJECT_REPORT.getIndex().equals(alternative)) {
            return this.dealSingleReject(taskId, relateApproveBill);
        }
        if (this.isFromAuditPage()) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Object decision = customParams.get("decision");
            if (decision == null || StringUtils.isEmpty((String)decision.toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u5ba1\u6279\u51b3\u7b56\u5931\u8d25\uff0c\u8bf7\u8fd4\u56de\u5ba1\u6279\u9875\u9762\u9a73\u56de\u3002", (String)"ApproveOperationConfirmPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
            String[] split = decision.toString().split("_and_");
            String auditType = split[split.length - 1];
            if ("approve".equals(auditType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5ba1\u6279\u51b3\u7b56\u975e\u9a73\u56de\uff0c\u8bf7\u8c03\u6574\u540e\u91cd\u8bd5\u3002", (String)"ApproveOperationConfirmPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
            Object rejectNode = customParams.get("rejectNode");
            if (rejectNode == null || StringUtils.isEmpty((String)rejectNode.toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u9a73\u56de\u8282\u70b9\u5931\u8d25\uff0c\u8bf7\u8fd4\u56de\u5ba1\u6279\u9875\u9762\u9a73\u56de\u3002", (String)"ApproveOperationConfirmPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
            nodeId = rejectNode.toString();
            Object approveMessage = customParams.get("approveMessage");
            opinion = "";
            if (approveMessage != null) {
                Map messageValue = (Map)SerializationUtils.fromJsonString((String)approveMessage.toString(), HashMap.class);
                opinion = (String)messageValue.get(LanguageUtils.getLang((Lang)Lang.zh_CN).name());
            }
        } else {
            opinion = (String)this.getValue("opinion", null);
            nodeId = (String)this.getValue("rejectnode", null);
            if (StringUtils.isEmpty((String)nodeId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9a73\u56de\u8282\u70b9\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"ApproveOperationConfirmPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        String rejectToNode = nodeId.split("#")[0];
        String curNodeId = WorkFlowUtil.getCurNodeId((Long)taskId);
        HashMap<String, String> variables = new HashMap<String, String>(16);
        variables.put("nextNodeId", rejectToNode);
        variables.put("dynType", "dynReject");
        String rejectOptionNumber = WorkFlowUtil.getRejectOptionNumber((Long)taskId);
        WorkFlowUtil.completeTask((String)String.valueOf(relateApproveBill), (String)curNodeId, (Long)userId, (String)rejectOptionNumber, (String)opinion, (boolean)false, variables);
        boolean joinAuditNode = ApproveUtils.getInstance().isJoinAuditNode(relateApproveBill, curNodeId);
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        DynamicObjectCollection rejectEntity = this.getModel().getEntryEntity("entryentity");
        long[] pkIds = DB.genGlobalLongIds((int)rejectEntity.size());
        int index = 0;
        for (DynamicObject dynamicObject : rejectEntity) {
            boolean mustReject = dynamicObject.getBoolean("mustreject");
            String rejectOpinion = dynamicObject.getString("rejectopinion");
            if (StringUtils.isEmpty((String)rejectOpinion)) {
                rejectOpinion = "";
            }
            if (joinAuditNode) {
                params.add(new Object[]{pkIds[index++], dynamicObject.getLong("reportprocess"), mustReject ? "1" : "0", rejectOpinion, curNodeId, nodeId, userId, timeStamp, relateApproveBill});
                continue;
            }
            params.add(new Object[]{pkIds[index++], dynamicObject.getLong("reportprocess"), mustReject ? "1" : "0", rejectOpinion, curNodeId, nodeId, "0", userId, timeStamp, "0", "1", relateApproveBill});
        }
        if (joinAuditNode) {
            if (params.size() != 0) {
                ApproveUtils.getInstance().saveTmpRejectOpinion(params);
            }
        } else {
            ApproveUtils.getInstance().updateRejectBillStatus(inRejectApproveBills, processIds);
            if (params.size() != 0) {
                ApproveUtils.getInstance().saveRejectOpinion(params);
            }
            ApproveUtils.getInstance().deleteApproveBillReadRecord(this.getRelateApproveBills());
            ApproveUtils.getInstance().saveApproveBillRejectStatus(Collections.singletonList(new Object[]{DB.genGlobalLongId(), relateApproveBill, "1", 0L, userId, timeStamp}));
        }
        return true;
    }

    public boolean dealSingleReject(Long taskId, Long relateApproveBill) {
        Long userId = this.getUserId();
        Timestamp timeStamp = new Timestamp(TimeServiceHelper.getTimeStamp());
        String businessKey = String.valueOf(relateApproveBill);
        String nodeId = (String)this.getValue("rejectnode", null);
        if (StringUtils.isEmpty((String)nodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9a73\u56de\u8282\u70b9\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"ApproveOperationConfirmPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        ArrayList<Object[]> params_opinion = new ArrayList<Object[]>(16);
        ArrayList<Object[]> params_status = new ArrayList<Object[]>(16);
        HashMap<String, String> templateOpinions = new HashMap<String, String>(16);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
        if (selectedRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u9a73\u56de\u7684\u62a5\u8868", (String)"ApproveOperationConfirmPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        String curNodeId = WorkFlowUtil.getCurNodeId((Long)taskId);
        long[] pkIds = DB.genGlobalLongIds((int)(selectedRows.length * 2));
        int index = -1;
        HashSet<Long> reportProcessIds = new HashSet<Long>(16);
        for (int selectedRow : selectedRows) {
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity("entryentity", selectedRow);
            String rejectOpinion = dynamicObject.getString("rejectopinion");
            long reportProcess = dynamicObject.getLong("reportprocess");
            reportProcessIds.add(reportProcess);
            params_opinion.add(new Object[]{pkIds[++index], reportProcess, "0", rejectOpinion, curNodeId, nodeId, "0", userId, timeStamp, "0", "1", relateApproveBill});
            params_status.add(new Object[]{pkIds[++index], relateApproveBill, "1", reportProcess, userId, timeStamp});
            templateOpinions.put(dynamicObject.getString("reportnumber.name"), rejectOpinion);
        }
        Set notAllDealProcesses = ApproveUtils.getInstance().getNotAllDealProcesses(reportProcessIds, this.getRelateApproveBills());
        if (notAllDealProcesses.size() != 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9a73\u56de\u5931\u8d25\uff0c\u4ee5\u4e0b\u62a5\u8868\u5df2\u88ab\u9a73\u56de\u4e14\u672a\u5904\u7406\u5b8c\u6210\uff1a\r\n%s", (String)"ApproveOperationConfirmPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)"\r\n", notAllDealProcesses)}));
            return false;
        }
        List allApprovalRecord = WorkFlowUtil.getAllApprovalRecord((String)businessKey);
        String submitNodeId = ApproveUtils.getInstance().getSubmitNodeId(allApprovalRecord);
        if (StringUtils.isEmpty((String)submitNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u63d0\u4ea4\u8282\u70b9\u4fe1\u606f\u5931\u8d25", (String)"ApproveOperationConfirmPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)relateApproveBill);
        String field = "eborgid.name as entity, dim_period.name as period, dim_version.name as version, dim_datatype.name as datatype";
        DynamicObject approveBill = QueryServiceHelper.queryOne((String)"eb_approvebill", (String)field, (QFilter[])new QFilter[]{qFilter});
        if (approveBill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u5355\u636e\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5", (String)"ApproveOperationConfirmPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        String[] split = nodeId.split("#");
        if (split.length < 2) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u9a73\u56de\u4eba\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5", (String)"ApproveOperationConfirmPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        ApproveUtils.getInstance().saveRejectOpinion(params_opinion);
        ApproveUtils.getInstance().saveApproveBillRejectStatus(params_status);
        String rejectToNode = split[0];
        if (submitNodeId.equals(rejectToNode)) {
            Map billRptMap = RejectOnReportService.getInstance().getSrcBillRptIds(Collections.singleton(relateApproveBill), reportProcessIds);
            if (CollectionUtils.isNotEmpty((Map)billRptMap)) {
                Set passiveRptIds = (Set)billRptMap.get(relateApproveBill);
                reportProcessIds.addAll(passiveRptIds);
            }
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("update t_eb_reportprocess set fstatus = ? ", new Object[]{BgTaskStateEnum.INCOMPLETE.getNumber()});
            sqlBuilder.append(" where ", new Object[0]);
            sqlBuilder.appendIn("fid", reportProcessIds.toArray());
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
            UpgradesTaskUtil.getInstance().clearDataEntityCache("eb_reportprocess");
        } else {
            boolean isMatchNewWorkFlow = RejectOnReportService.getInstance().isMatchNewWorkFlow(this.getModelId());
            if (isMatchNewWorkFlow) {
                HashSet<Long> approveBillIds = new HashSet<Long>(1);
                approveBillIds.add(relateApproveBill);
                RejectOnReportService.getInstance().createRejectBill(approveBillIds, reportProcessIds, "audit");
            }
        }
        StringBuilder message = new StringBuilder();
        message.append(ResManager.loadResFormat((String)"\u9884\u7b97\u5ba1\u6838\u4efb\u52a1\u88ab%1\u9a73\u56de\uff0c\u8bf7\u5904\u7406\uff01", (String)"ApproveOperationConfirmPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[]{UserUtils.getUserName()})).append("\r\n");
        message.append(ResManager.loadResFormat((String)"\u9884\u7b97\u5ba1\u6838\u4efb\u52a1\u8303\u56f4\uff1a%1-%2-%3-%4;", (String)"ApproveOperationConfirmPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[]{approveBill.getString("entity"), approveBill.getString("period"), approveBill.getString("version"), approveBill.getString("datatype")}));
        message.append("\n\r");
        List templateNotifies = templateOpinions.entrySet().stream().map(e -> (String)e.getKey() + ": " + (String)e.getValue()).collect(Collectors.toList());
        message.append(String.join((CharSequence)"\n\r", templateNotifies));
        String userStr = split[1];
        String[] userSplit = userStr.split("_");
        ArrayList<Long> senders = new ArrayList<Long>(16);
        for (String user : userSplit) {
            senders.add(ConvertUtils.toLong((Object)user));
        }
        senders.remove(0L);
        if (senders.size() != 0) {
            MessageUtils.get().sendMessageWithSender("eb_approvebill", ResManager.loadKDString((String)"\u9884\u7b97\u5ba1\u6279\u9a73\u56de", (String)"ApproveOperationConfirmPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]), message.toString(), senders, MessageUtils.MessageType.YUNZHIJIA, userId, ResManager.loadKDString((String)"\u9884\u7b97\u5ba1\u6838", (String)"ApproveOperationConfirmPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return true;
    }

    private void dealAuditPass() {
        List<Long> relateApproveBills = this.getRelateApproveBills();
        String opinion = (String)this.getValue("opinion", null);
        ArrayList<String> taskIds = new ArrayList<String>(16);
        for (Long relateApproveBill : relateApproveBills) {
            Long taskId = WorkflowServiceHelper.getTaskIdByBusinessKeyAndUserId((String)String.valueOf(relateApproveBill), (Long)this.getUserId());
            if (taskId == null) {
                log.info("ApproveOperationConfirmPlugin_cannot_find_task: " + relateApproveBill);
                continue;
            }
            taskIds.add(String.valueOf(taskId));
        }
        String operateMessage = WorkFlowUtil.batchAgreeTaskWithUserId((String)String.join((CharSequence)",", taskIds), (ILocaleString)new LocaleString(opinion), (Long)this.getUserId());
        log.info("ApproveOperationConfirmPlugin_audit_pass_message: " + operateMessage);
    }

    private boolean checkCentralAuditPass(String clickKey) {
        String alternative = (String)this.getValue("alternative", null);
        if ("btn_confirm".equals(clickKey)) {
            DynamicObject[] approveBills;
            List<Long> billIds = this.getRelateApproveBills();
            for (DynamicObject approveBill : approveBills = BusinessDataServiceHelper.load((Object[])billIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_approvebill"))) {
                String billNo = approveBill.getString("billno");
                String centralBillType = approveBill.getString("centralbilltype");
                if (!CentralBillType.Main.getNumber().equals(centralBillType)) continue;
                if (ApproveDecisionEnum.APPROVE.getIndex().equals(alternative)) {
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5ba1\u6279\u5931\u8d25\uff0c\u5f53\u524d\u5355\u636e\u201c%1\u201d\u5b58\u5728\u672a\u5ba1\u6838\u901a\u8fc7\u7684\u5b50\u5ba1\u6279\u5355", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[]{billNo}));
                } else if (ApproveDecisionEnum.REJECT_TASK.getIndex().equals(alternative) || ApproveDecisionEnum.REJECT_REPORT.getIndex().equals(alternative)) {
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u9a73\u56de\u5931\u8d25\uff0c\u5f53\u524d\u5355\u636e\u201c%1\u201d\u5b58\u5728\u672a\u5ba1\u6838\u901a\u8fc7\u7684\u5b50\u5ba1\u6279\u5355", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[]{billNo}));
                }
                return true;
            }
        }
        return false;
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        Boolean notClose = (Boolean)this.getCache("notClose", Boolean.class, () -> false);
        if (notClose.booleanValue()) {
            evt.setCancel(true);
        }
    }
}

