/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.approveBill;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.engine.impl.persistence.entity.task.component.ApprovalRecordGroup;
import kd.bos.workflow.engine.impl.persistence.entity.task.component.ApprovalRecordItem;
import kd.epm.eb.business.approvetype.ApproveUtils;
import kd.epm.eb.business.utils.WorkFlowUtil;
import kd.epm.eb.common.approveBill.Entity.ApproveBillInfo;
import kd.epm.eb.common.approveBill.Entity.ApproveOpinion;
import kd.epm.eb.common.approveBill.Entity.LocalApproveRecord;
import kd.epm.eb.common.approveBill.Entity.RejectOpinionRecord;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.ApproveOpTypeEnum;
import kd.epm.eb.common.enums.LocalRecordTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.reportprocess.helper.ApproveBillHelper;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.DateTimeUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.centralaudit.CentralOptimization;

public class ApproveOpinionListPlugin
extends AbstractFormPlugin
implements TreeNodeQueryListener {
    private static final String GROUP_NODE_PRE = "c_";
    private static final String JOIN_AUDIT_PRE = "h_";
    private Long processId;
    private Long approveBillId;
    private static final String ENTITY = "treeentryentity";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"vector_list"});
        this.addItemClickListeners(new String[]{"toolbarap"});
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(ENTITY);
        entryGrid.addCellClickListener((TreeNodeQueryListener)this);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.loadListRecords();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (!"vector_list".equals(this.getCurrentView())) {
            return;
        }
        switch (itemKey) {
            case "btn_refresh": {
                this.loadListRecords();
                break;
            }
        }
    }

    private void loadListRecords() {
        ArrayList<ApproveOpinion> opinions = new ArrayList<ApproveOpinion>(16);
        boolean notInWorkFlow = ApproveUtils.getInstance().notInWorkFlowWithoutType(this.getApproveBillId().longValue());
        List<ApproveOpinion> approveOpinions = this.getApproveOpinions(notInWorkFlow);
        if (!notInWorkFlow || approveOpinions.size() == 0 || ((Boolean)CommonUtils.getMetaDataFieldDefaultValue((String)"eb_approveopinion_list", (String)"showlocaloperation", () -> false)).booleanValue()) {
            opinions.addAll(this.getHistoryOpinions(notInWorkFlow));
        }
        opinions.addAll(approveOpinions);
        this.getModel().deleteEntryData(ENTITY);
        if (this.isEmpty(opinions)) {
            return;
        }
        int[] rows = this.getModel().batchCreateNewEntryRow(ENTITY, opinions.size());
        boolean existNode = this.batchLoadRecords(opinions, rows);
        if (!existNode) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"auditnode"});
        }
    }

    private List<ApproveOpinion> getHistoryOpinions(boolean notInWorkFlow) {
        DynamicObject dynamicObject;
        Long approveBillId = this.getApproveBillId();
        String billNo = "";
        if (!notInWorkFlow && (dynamicObject = QueryServiceHelper.queryOne((String)"eb_approvebill", (String)"billno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)approveBillId)})) != null) {
            billNo = dynamicObject.getString("billno");
        }
        List<ApproveOpinion> opinions = this.getProcessRefOpinions();
        String finalBillNo = billNo;
        return opinions.stream().filter(e -> !e.getApproveBillNo().equals(finalBillNo)).collect(Collectors.toList());
    }

    private List<ApproveOpinion> getProcessRefOpinions() {
        Long processId = this.getProcessId();
        QFilter qFilter = new QFilter("id", "=", (Object)processId);
        DynamicObject process = QueryServiceHelper.queryOne((String)"eb_reportprocess", (String)"template.name as tempName, entity.name as entName", (QFilter[])new QFilter[]{qFilter});
        String tempName = "";
        String entity = "";
        if (process != null) {
            tempName = process.getString("tempName");
            entity = process.getString("entName");
        }
        qFilter = new QFilter("process", "=", (Object)processId);
        String fields = "billno, operationname, user, user.name as userName, entity.name as entName, view.name as viewName, audittime";
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_historyapproverecord", (String)fields, (QFilter[])new QFilter[]{qFilter});
        ArrayList<ApproveOpinion> opinions = new ArrayList<ApproveOpinion>(16);
        for (DynamicObject dynamicObject : query) {
            ApproveOpinion opinion = new ApproveOpinion();
            opinion.setTempName(tempName);
            opinion.setEntity(entity);
            opinion.setApproveBillNo(dynamicObject.getString("billno"));
            opinion.setOpName(dynamicObject.getString("operationname"));
            opinion.setUserId(Long.valueOf(dynamicObject.getLong("user")));
            opinion.setUserName(dynamicObject.getString("userName"));
            opinion.setSubmitEntity(dynamicObject.getString("entName"));
            opinion.setView(dynamicObject.getString("viewName"));
            opinion.setRecordTime(dynamicObject.getDate("audittime"));
            opinions.add(opinion);
        }
        return opinions;
    }

    private List<ApproveOpinion> getApproveOpinions(boolean notInWorkFlow) {
        Long processId = this.getProcessId();
        if (processId == 0L) {
            return new ArrayList<ApproveOpinion>(16);
        }
        Long approveBill = this.getApproveBillId();
        List<ApproveOpinion> opinions = notInWorkFlow ? this.getLocalApproveOpinions(approveBill, processId) : this.getWfApproveOpinions(approveBill, processId);
        return opinions.stream().filter(e -> e.getRecordTime() != null).sorted(Comparator.comparing(ApproveOpinion::getRecordTime)).collect(Collectors.toList());
    }

    private boolean batchLoadRecords(List<ApproveOpinion> opinions, int[] rows) {
        boolean existNode = false;
        if (opinions == null || rows == null || opinions.size() == 0 || rows.length == 0) {
            return false;
        }
        for (int i = 0; i < opinions.size(); ++i) {
            ApproveOpinion opinion = opinions.get(i);
            DynamicObject row = this.getModel().getEntryRowEntity(ENTITY, rows[i]);
            String userName = opinion.getUserName();
            String _nodeName = opinion.getNodeName();
            if (StringUtils.isNotEmpty((String)_nodeName)) {
                row.set("auditnode", (Object)_nodeName);
                existNode = true;
            }
            row.set("auditor", (Object)userName);
            ApproveOpTypeEnum opType = opinion.getOpType();
            String result = "";
            if (opType != null) {
                result = opType.getName();
            } else {
                String opName = opinion.getOpName();
                if (opName != null) {
                    result = opName;
                }
            }
            row.set("auditresult", (Object)result);
            row.set("auditopinion", (Object)(ApproveOpTypeEnum.SUBMIT == opType ? opinion.getSubmitDesc() : opinion.getApproveOpinion()));
            if (ApproveOpTypeEnum.WAIT != opType) {
                row.set("audittime", (Object)opinion.getRecordTime());
            }
            row.set("submitdesc", (Object)opinion.getApproveDesc());
            row.set("rejectopinion", (Object)opinion.getRejectOpinion());
            if (opinion.isShowAdjust()) {
                row.set("isadjust", (Object)"\u2714");
            }
            row.set("detailinfo", (Object)SerializationUtils.toJsonString((Object)opinion));
            row.set("reportname", (Object)opinion.getTempName());
            if (opinion.isCanExpand()) {
                row.set("isgroupnode", (Object)true);
            }
            row.set("entity", (Object)opinion.getEntity());
            row.set("approvebill", (Object)opinion.getApproveBillNo());
            row.set("submitentity", (Object)opinion.getSubmitEntity());
            row.set("view", (Object)opinion.getView());
        }
        this.getView().updateView(ENTITY);
        return existNode;
    }

    private List<ApproveOpinion> getLocalApproveOpinions(Long approveBill, Long processId) {
        ArrayList<ApproveOpinion> opinions = new ArrayList<ApproveOpinion>(16);
        HashSet processIds = Sets.newHashSet((Object[])new Long[]{processId});
        String fields = "id, approveinfo, createrid.id as creater, createrid.name as creatername, createdate, billstatus, orgviewid.name as view, billno";
        DynamicObject bill = QueryServiceHelper.queryOne((String)"eb_approvebill", (String)fields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)approveBill)});
        String submitDesc = "";
        String submitUserName = "";
        String submitOrg = "";
        Date createTime = null;
        String billNo = null;
        String orgView = null;
        long submitUser = 0L;
        if (bill != null) {
            submitDesc = bill.getString("approveinfo");
            submitUserName = bill.getString("creatername");
            submitUser = bill.getLong("creater");
            submitOrg = UserServiceHelper.getUserMainJob((long)submitUser);
            createTime = bill.getDate("createdate");
            billNo = bill.getString("billno");
            orgView = bill.getString("view");
        }
        String tempName = null;
        String entity = null;
        String submitEntity = null;
        fields = "template.name as tempName, entity.name as entName, submitentity.name as subName";
        DynamicObject query = QueryServiceHelper.queryOne((String)"eb_reportprocess", (String)fields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)processId)});
        if (query != null) {
            tempName = query.getString("tempName");
            entity = query.getString("entName");
            submitEntity = query.getString("subName");
        }
        Map approveDescMap = ApproveUtils.getInstance().getApproveDescMap((Collection)processIds);
        String approveDesc = approveDescMap.getOrDefault(processId, "");
        Map approveRejectOpinions = ApproveUtils.getInstance().getApproveRejectOpinions((Set)processIds, (Set)Sets.newHashSet((Object[])new Long[]{approveBill}), false);
        List rejectOpinions = approveRejectOpinions.getOrDefault(processId, new ArrayList(16));
        List localApproveRecords = ApproveUtils.getInstance().getLocalApproveRecords((Set)processIds);
        for (LocalApproveRecord localApproveRecord : localApproveRecords) {
            ApproveOpinion opinion = new ApproveOpinion();
            opinion.setRecordTime(localApproveRecord.getApproveTime());
            opinion.setUserId(localApproveRecord.getApproveUser());
            opinion.setUserName(localApproveRecord.getUserName() + "|" + localApproveRecord.getMainJob());
            opinion.setApproveOpinion(localApproveRecord.getOpinion());
            opinion.setTempName(tempName);
            opinion.setEntity(localApproveRecord.getEntityName());
            opinion.setApproveBillNo(localApproveRecord.getBillNo());
            opinion.setSubmitEntity(localApproveRecord.getSubmitEntityName());
            opinion.setView(localApproveRecord.getViewName());
            LocalRecordTypeEnum type = localApproveRecord.getType();
            if (LocalRecordTypeEnum.SUBMIT_DESC == type || LocalRecordTypeEnum.APPROVE_DESC == type) {
                opinion.setOpType(ApproveOpTypeEnum.SUBMIT);
                ApproveOpinion _opinion = this.getFilterOpinion(opinion, opinions);
                if (_opinion != null) {
                    if (LocalRecordTypeEnum.SUBMIT_DESC == type) {
                        _opinion.setSubmitDesc(localApproveRecord.getOpinion());
                        continue;
                    }
                    _opinion.setApproveDesc(localApproveRecord.getOpinion());
                    continue;
                }
                if (LocalRecordTypeEnum.SUBMIT_DESC == type) {
                    opinion.setSubmitDesc(localApproveRecord.getOpinion());
                } else {
                    opinion.setApproveDesc(localApproveRecord.getOpinion());
                }
                opinions.add(opinion);
                continue;
            }
            opinion.setOpType(ApproveOpTypeEnum.APPROVE);
            if (LocalRecordTypeEnum.REJECT == type) {
                opinion.setOpType(ApproveOpTypeEnum.REJECT);
                opinion.setRejectOpinion(this.getSuitRejectOpinion(opinion, rejectOpinions));
            }
            opinions.add(opinion);
        }
        if (bill != null && "B".equals(bill.getString("billstatus"))) {
            ApproveOpinion approveOpinion = new ApproveOpinion();
            approveOpinion.setRecordTime(createTime);
            approveOpinion.setUserId(Long.valueOf(submitUser));
            approveOpinion.setUserName(submitUserName + "|" + submitOrg);
            approveOpinion.setOpType(ApproveOpTypeEnum.SUBMIT);
            approveOpinion.setSubmitDesc(submitDesc);
            approveOpinion.setApproveDesc(approveDesc);
            approveOpinion.setTempName(tempName);
            approveOpinion.setEntity(entity);
            approveOpinion.setApproveBillNo(billNo);
            approveOpinion.setSubmitEntity(submitEntity);
            approveOpinion.setView(orgView);
            opinions.add(approveOpinion);
        }
        return opinions;
    }

    private List<ApproveOpinion> getWfApproveOpinions(Long approveBill, Long processId) {
        ArrayList<ApproveOpinion> opinions = new ArrayList<ApproveOpinion>(16);
        HashSet processIds = Sets.newHashSet((Object[])new Long[]{processId});
        Map approveRejectOpinions = ApproveUtils.getInstance().getApproveRejectOpinions((Set)processIds, (Set)Sets.newHashSet((Object[])new Long[]{approveBill}), true);
        List rejectOpinions = approveRejectOpinions.getOrDefault(processId, new ArrayList(16));
        HashMap<Date, String> approveInfos = new HashMap<Date, String>(16);
        QFilter qFilter = new QFilter("relateid", "=", (Object)processId);
        qFilter.and("otherrelateid", "=", (Object)approveBill);
        qFilter.and("type", "=", (Object)"1");
        Map approveInfoRecords = BusinessDataServiceHelper.loadFromCache((String)"eb_approveinforecord", (String)"submittime,approveinfo", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject approveInfoRecord : approveInfoRecords.values()) {
            approveInfos.put(approveInfoRecord.getDate("submittime"), approveInfoRecord.getString("approveinfo"));
        }
        List subApproveBillList = ApproveBillHelper.getSubApproveBillList((Long)approveBill, (boolean)false);
        HashMap<String, List<ApproveBillInfo>> billInfos = new HashMap<String, List<ApproveBillInfo>>(16);
        for (ApproveBillInfo approveBillInfo : subApproveBillList) {
            List approveBillInfos = billInfos.computeIfAbsent(approveBillInfo.getNodeId(), k -> new ArrayList(16));
            approveBillInfos.add(approveBillInfo);
        }
        String submitEntity = null;
        String fields = "orgviewid.name as view, billno, eborgid.name as submitentity";
        DynamicObject bill = QueryServiceHelper.queryOne((String)"eb_approvebill", (String)fields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)approveBill)});
        String billNo = null;
        String orgView = null;
        if (bill != null) {
            billNo = bill.getString("billno");
            orgView = bill.getString("view");
            submitEntity = bill.getString("submitentity");
        }
        String tempName = null;
        String entity = null;
        fields = "template.name as tempName, entity.name as entName";
        DynamicObject query = QueryServiceHelper.queryOne((String)"eb_reportprocess", (String)fields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)processId)});
        if (query != null) {
            tempName = query.getString("tempName");
            entity = query.getString("entName");
        }
        long curTime = System.currentTimeMillis();
        List allApprovalRecord = WorkFlowUtil.getAllApprovalRecord((String)String.valueOf(approveBill));
        for (IApprovalRecordGroup approvalRecordGroup : allApprovalRecord) {
            Long formatTime;
            ApproveOpinion approveOpinion;
            IApprovalRecordItem child;
            String groupDecisionType = approvalRecordGroup.getGroupDecisionType();
            List children = approvalRecordGroup.getChildren();
            if (this.isCentralNode(billInfos, approvalRecordGroup)) {
                if (children == null || children.size() == 0 || (child = this.getLatestChildNode(children)) == null) continue;
                approveOpinion = new ApproveOpinion();
                approveOpinion.setNodeId(child.getActivityId());
                approveOpinion.setNodeName(child.getActivityName());
                approveOpinion.setTempName(tempName);
                formatTime = child.getFormatTime();
                if (formatTime == null) {
                    formatTime = curTime;
                }
                approveOpinion.setRecordTime(new Date(formatTime));
                approveOpinion.setEnterTime(DateTimeUtils.parseToDate((String)child.getTime()));
                approveOpinion.setCanExpand(true);
                approveOpinion.setExpandType("centralNode");
                approveOpinion.setOpType(this.getOpType(groupDecisionType, GROUP_NODE_PRE));
                approveOpinion.setEntity(entity);
                approveOpinion.setApproveBillNo(billNo);
                approveOpinion.setSubmitEntity(submitEntity);
                approveOpinion.setView(orgView);
                opinions.add(approveOpinion);
                continue;
            }
            if ("huiqian".equals(((ApprovalRecordGroup)approvalRecordGroup).getGroupType())) {
                if (children == null || children.size() == 0 || (child = this.getLatestChildNode(children)) == null) continue;
                approveOpinion = new ApproveOpinion();
                approveOpinion.setNodeId(child.getActivityId());
                approveOpinion.setNodeName(child.getActivityName());
                approveOpinion.setTempName(tempName);
                formatTime = child.getFormatTime();
                if (formatTime == null) {
                    formatTime = curTime;
                }
                approveOpinion.setRecordTime(new Date(formatTime));
                approveOpinion.setEnterTime(DateTimeUtils.parseToDate((String)child.getTime()));
                approveOpinion.setCanExpand(true);
                approveOpinion.setExpandType("huiqian");
                approveOpinion.setOpType(this.getOpType(groupDecisionType, GROUP_NODE_PRE));
                approveOpinion.setGroup(approvalRecordGroup.getGroup());
                approveOpinion.setEntity(entity);
                approveOpinion.setApproveBillNo(billNo);
                approveOpinion.setSubmitEntity(submitEntity);
                approveOpinion.setView(orgView);
                opinions.add(approveOpinion);
                continue;
            }
            if ("wait".equals(groupDecisionType)) continue;
            for (IApprovalRecordItem child2 : children) {
                ApproveOpinion approveOpinion2 = new ApproveOpinion();
                approveOpinion2.setNodeId(child2.getActivityId());
                approveOpinion2.setNodeName(child2.getActivityName());
                approveOpinion2.setRecordTime(new Date(child2.getFormatTime()));
                approveOpinion2.setEnterTime(DateTimeUtils.parseToDate((String)child2.getTime()));
                approveOpinion2.setUserId(child2.getUserId());
                approveOpinion2.setUserName(((ApprovalRecordItem)child2).getUserNameFormat());
                approveOpinion2.setOpType(ApproveOpTypeEnum.APPROVE);
                approveOpinion2.setTempName(tempName);
                if ("submit".equals(groupDecisionType)) {
                    approveOpinion2.setOpType(ApproveOpTypeEnum.SUBMIT);
                    String _approveDesc = this.getSuitApproveDesc(approveOpinion2, approveInfos);
                    approveOpinion2.setApproveDesc(_approveDesc);
                    approveOpinion2.setSubmitDesc(child2.getMessage());
                } else {
                    String rejectOpinion;
                    approveOpinion2.setApproveOpinion(child2.getMessage());
                    if ("reject".equals(groupDecisionType)) {
                        approveOpinion2.setOpType(ApproveOpTypeEnum.REJECT);
                        approveOpinion2.setRejectOpinion(this.getSuitRejectOpinion(approveOpinion2, rejectOpinions));
                    } else if ("approve".equals(groupDecisionType) && StringUtils.isNotEmpty((String)(rejectOpinion = this.getSuitRejectOpinionOnReport(approveOpinion2, rejectOpinions)))) {
                        approveOpinion2.setRejectOpinion(rejectOpinion);
                    }
                }
                approveOpinion2.setEntity(entity);
                approveOpinion2.setApproveBillNo(billNo);
                approveOpinion2.setSubmitEntity(submitEntity);
                approveOpinion2.setView(orgView);
                opinions.add(approveOpinion2);
            }
        }
        return opinions;
    }

    private IApprovalRecordItem getLatestChildNode(List<IApprovalRecordItem> children) {
        IApprovalRecordItem item = null;
        long time = 0L;
        long curTime = System.currentTimeMillis();
        for (IApprovalRecordItem child : children) {
            Long formatTime = child.getFormatTime();
            if (formatTime == null) {
                formatTime = curTime;
            }
            if (time != 0L && time >= formatTime) continue;
            time = formatTime;
            item = child;
        }
        return item;
    }

    private ApproveOpTypeEnum getOpType(String groupDecisionType, String preKey) {
        List approveTypesByOpType = ApproveOpTypeEnum.getApproveTypesByOpType((String)(preKey + groupDecisionType));
        if (approveTypesByOpType.size() != 1) {
            approveTypesByOpType = ApproveOpTypeEnum.getApproveTypesByOpType((String)groupDecisionType);
        }
        return approveTypesByOpType.size() == 1 ? (ApproveOpTypeEnum)approveTypesByOpType.get(0) : null;
    }

    private ApproveOpTypeEnum getOpTypeByBillStatus(String billStatus) {
        ApproveOpTypeEnum type = null;
        switch (billStatus) {
            case "A": {
                type = ApproveOpTypeEnum.SAVE;
                break;
            }
            case "C": {
                type = ApproveOpTypeEnum.INCOMPLETE;
                break;
            }
            case "B": {
                type = ApproveOpTypeEnum.SUBMIT;
                break;
            }
            case "E": {
                type = ApproveOpTypeEnum.COMPLETE;
                break;
            }
        }
        return type;
    }

    private boolean isCentralNode(Map<String, List<ApproveBillInfo>> billInfos, IApprovalRecordGroup approvalRecordGroup) {
        List children = approvalRecordGroup.getChildren();
        if (children == null || children.size() == 0) {
            return false;
        }
        HashSet<String> activities = new HashSet<String>(16);
        children.forEach(e -> {
            String activityId = e.getActivityId();
            if (StringUtils.isNotEmpty((String)activityId)) {
                String[] split = activityId.split("_");
                activities.add(split[split.length - 1]);
            }
        });
        List<ApproveBillInfo> refBills = this.getNodeRefBills(billInfos, activities);
        return refBills.size() != 0;
    }

    private List<ApproveBillInfo> getNodeRefBills(Map<String, List<ApproveBillInfo>> billInfos, Set<String> activities) {
        ArrayList<ApproveBillInfo> refBills = new ArrayList<ApproveBillInfo>(16);
        if (billInfos == null || billInfos.size() == 0 || activities == null || activities.size() == 0) {
            return refBills;
        }
        for (String activity : activities) {
            List<ApproveBillInfo> approveBillInfos = billInfos.get(activity);
            if (approveBillInfos == null) continue;
            refBills.addAll(approveBillInfos);
        }
        return refBills;
    }

    private void relateAdjustStatus(List<ApproveOpinion> opinions, Long approveBill) {
    }

    private String getSuitApproveDesc(ApproveOpinion approveOpinion, Map<Date, String> approveInfos) {
        Date recordTime = approveOpinion.getRecordTime();
        if (recordTime == null) {
            return "";
        }
        for (Map.Entry<Date, String> approveInfo : approveInfos.entrySet()) {
            Date subTime = approveInfo.getKey();
            long abs = Math.abs(recordTime.getTime() - subTime.getTime());
            if (abs > 5000L) continue;
            return approveInfo.getValue();
        }
        return "";
    }

    private ApproveOpinion getFilterOpinion(ApproveOpinion opinion, List<ApproveOpinion> opinions) {
        if (opinions.size() == 0) {
            return null;
        }
        for (ApproveOpinion approveOpinion : opinions) {
            if (!approveOpinion.getUserId().equals(opinion.getUserId()) || !approveOpinion.getRecordTime().equals(opinion.getRecordTime())) continue;
            return approveOpinion;
        }
        return null;
    }

    private String getSuitRejectOpinionOnReport(ApproveOpinion approveOpinion, List<RejectOpinionRecord> rejectOpinions) {
        Date recordTime = approveOpinion.getRecordTime();
        if (recordTime == null) {
            return "";
        }
        Date lastApproveTime = approveOpinion.getEnterTime();
        RejectOpinionRecord filterRejectOpinion = null;
        for (RejectOpinionRecord rejectOpinion : rejectOpinions) {
            Date _time;
            Date time;
            if (!rejectOpinion.isRejectOnReport() || (time = rejectOpinion.getTime()) == null) continue;
            Long userId = rejectOpinion.getUserId();
            if (!approveOpinion.getUserId().equals(userId)) continue;
            String nodeId = rejectOpinion.getNodeId();
            String _nodeId = approveOpinion.getNodeId();
            if (StringUtils.isEmpty((String)nodeId) && StringUtils.isNotEmpty((String)_nodeId) || StringUtils.isNotEmpty((String)nodeId) && StringUtils.isEmpty((String)_nodeId) || recordTime.before(time)) continue;
            if (lastApproveTime == null) {
                if (filterRejectOpinion == null) {
                    filterRejectOpinion = rejectOpinion;
                    continue;
                }
                _time = filterRejectOpinion.getTime();
                if (!_time.before(time)) continue;
                filterRejectOpinion = rejectOpinion;
                continue;
            }
            if (lastApproveTime.after(time)) continue;
            if (filterRejectOpinion == null) {
                filterRejectOpinion = rejectOpinion;
                continue;
            }
            _time = filterRejectOpinion.getTime();
            if (!_time.before(time)) continue;
            filterRejectOpinion = rejectOpinion;
        }
        if (filterRejectOpinion != null) {
            return filterRejectOpinion.getOpinion();
        }
        return "";
    }

    private String getSuitRejectOpinion(ApproveOpinion record, List<RejectOpinionRecord> rejectOpinions) {
        if (rejectOpinions.size() == 0) {
            return "";
        }
        Long minAbs = null;
        RejectOpinionRecord minRejectOpinion = null;
        for (RejectOpinionRecord rejectOpinion : rejectOpinions) {
            Date time;
            if (rejectOpinion.isRejectOnReport() || (time = rejectOpinion.getTime()) == null) continue;
            Long userId = rejectOpinion.getUserId();
            if (!record.getUserId().equals(userId)) continue;
            String nodeId = rejectOpinion.getNodeId();
            String _nodeId = record.getNodeId();
            if (StringUtils.isEmpty((String)nodeId) && StringUtils.isNotEmpty((String)_nodeId) || StringUtils.isNotEmpty((String)nodeId) && StringUtils.isEmpty((String)_nodeId)) continue;
            Date recordTime = record.getRecordTime();
            long abs = Math.abs(time.getTime() - recordTime.getTime());
            if ((minAbs = minAbs == null ? Long.valueOf(abs) : Long.valueOf(Math.min(minAbs, abs))) != abs) continue;
            minRejectOpinion = rejectOpinion;
        }
        if (minAbs != null && minAbs <= 1000L && minRejectOpinion != null) {
            return minRejectOpinion.getOpinion();
        }
        return "";
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
        int row = treeNodeEvent.getRowKey();
        DynamicObject selectRow = this.getModel().getEntryRowEntity(ENTITY, row);
        String detailInfo = selectRow.getString("detailinfo");
        ApproveOpinion opinion = null;
        if (StringUtils.isNotEmpty((String)detailInfo)) {
            opinion = (ApproveOpinion)SerializationUtils.fromJsonString((String)detailInfo, ApproveOpinion.class);
        }
        if (opinion == null) {
            return;
        }
        String expandType = opinion.getExpandType();
        if (expandType == null) {
            return;
        }
        List<ApproveOpinion> children = null;
        switch (expandType) {
            case "centralNode": {
                children = this.getChildApproveBillStatus(opinion);
                break;
            }
            case "huiqian": {
                children = this.getJoinAuditDetailOpinions(opinion);
                break;
            }
        }
        if (children == null) {
            return;
        }
        this.getModel().beginInit();
        int[] rows = this.getModel().batchInsertEntryRow(ENTITY, row, children.size());
        this.batchLoadRecords(children, rows);
        this.getModel().endInit();
    }

    private List<ApproveOpinion> getChildApproveBillStatus(ApproveOpinion opinion) {
        ArrayList<ApproveOpinion> opinions = new ArrayList<ApproveOpinion>(16);
        Long approveBillId = this.getApproveBillId();
        String nodeId = opinion.getNodeId();
        List subApproveBillList = ApproveBillHelper.getSubApproveBillList((Long)approveBillId, (boolean)false);
        HashMap<String, List<ApproveBillInfo>> billInfos = new HashMap<String, List<ApproveBillInfo>>(16);
        for (ApproveBillInfo approveBillInfo : subApproveBillList) {
            List approveBillInfos = billInfos.computeIfAbsent(approveBillInfo.getNodeId(), k -> new ArrayList(16));
            approveBillInfos.add(approveBillInfo);
        }
        String fields = "createrid.id as creater, createrid.name as creatername, modelid, orgviewid.name as view, billno, eborgid.name as submitentity";
        DynamicObject bill = QueryServiceHelper.queryOne((String)"eb_approvebill", (String)fields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)approveBillId)});
        String submitUserName = "";
        String submitOrg = "";
        long submitUser = 0L;
        long modelId = 0L;
        String submitEntity = null;
        String orgView = null;
        if (bill != null) {
            submitUserName = bill.getString("creatername");
            submitUser = bill.getLong("creater");
            submitOrg = UserServiceHelper.getUserMainJob((long)submitUser);
            modelId = bill.getLong("modelid");
            orgView = bill.getString("view");
            submitEntity = bill.getString("submitentity");
        }
        String tempName = null;
        String entity = null;
        fields = "template.name as tempName, entity.name as entName";
        DynamicObject query = QueryServiceHelper.queryOne((String)"eb_reportprocess", (String)fields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.getProcessId())});
        if (query != null) {
            tempName = query.getString("tempName");
            entity = query.getString("entName");
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Dimension dimension = modelCacheHelper.getDimension(SysDimensionEnum.Entity.getNumber());
        if (StringUtils.isEmpty((String)nodeId)) {
            return opinions;
        }
        String[] split = nodeId.split("_");
        List<ApproveBillInfo> nodeRefBills = this.getNodeRefBills(billInfos, Sets.newHashSet((Object[])new String[]{split[split.length - 1]}));
        Map processRefTemplateInfo = ApproveUtils.getInstance().getProcessRefTemplateInfo((Collection)Sets.newHashSet((Object[])new Long[]{this.getProcessId()}));
        Long tempId = processRefTemplateInfo.getOrDefault(this.getProcessId(), 0L);
        List filterBills = ApproveUtils.getInstance().getFilterBills(nodeRefBills, tempId);
        Map<Long, String> childNodes = this.getRefNodeInfo(filterBills);
        for (ApproveBillInfo nodeRefBill : filterBills) {
            boolean isAudit = true;
            ApproveOpinion _opinion = this.getLastAuditNodeOpinion(nodeRefBill);
            if (_opinion == null) {
                _opinion = new ApproveOpinion();
                isAudit = false;
            }
            String memberName = "";
            Long centralOrgId = nodeRefBill.getCentralOrgId();
            Member member = dimension.getMember(nodeRefBill.getOrgViewId(), centralOrgId);
            if (member != null) {
                memberName = member.getName();
            }
            if (isAudit && _opinion.getUserId() != null) {
                opinion.setUserName(memberName + "-" + opinion.getUserName());
            }
            if (_opinion.getUserId() == null) {
                _opinion.setRecordTime(nodeRefBill.getCreateTime());
                _opinion.setUserId(nodeRefBill.getCreatorId());
                _opinion.setUserName(submitUserName + "|" + submitOrg);
            }
            _opinion.setNodeName(childNodes.getOrDefault(nodeRefBill.getBillId(), ""));
            _opinion.setTempName(String.format("%s\u3010%s\u3011", tempName, memberName));
            _opinion.setOpType(this.getOpTypeByBillStatus(nodeRefBill.getBillStatus()));
            _opinion.setCentralOrgId(centralOrgId);
            _opinion.setMainNodeId(nodeRefBill.getNodeId());
            _opinion.setEntity(entity);
            _opinion.setApproveBillNo(nodeRefBill.getBillNo());
            _opinion.setSubmitEntity(submitEntity);
            _opinion.setView(orgView);
            opinions.add(_opinion);
        }
        return opinions;
    }

    private Map<Long, String> getRefNodeInfo(List<ApproveBillInfo> nodeRefBills) {
        HashMap<Long, String> nodeInfos = new HashMap<Long, String>(16);
        if (nodeRefBills == null) {
            return nodeInfos;
        }
        for (ApproveBillInfo nodeRefBill : nodeRefBills) {
            IApprovalRecordGroup approvalRecordGroup;
            List children;
            Long billId = nodeRefBill.getBillId();
            List allApprovalRecord = WorkFlowUtil.getAllApprovalRecord((String)String.valueOf(billId));
            if (allApprovalRecord == null || allApprovalRecord.size() == 0 || (children = (approvalRecordGroup = (IApprovalRecordGroup)allApprovalRecord.get(allApprovalRecord.size() - 1)).getChildren()) == null || allApprovalRecord.size() == 0) continue;
            IApprovalRecordItem iApprovalRecordItem = (IApprovalRecordItem)children.get(children.size() - 1);
            String activityName = iApprovalRecordItem.getActivityName();
            nodeInfos.put(billId, activityName);
        }
        return nodeInfos;
    }

    private ApproveOpinion getLastAuditNodeOpinion(ApproveBillInfo nodeRefBill) {
        IApprovalRecordGroup approvalRecordGroup;
        String groupDecisionType;
        Long billId = nodeRefBill.getBillId();
        boolean notInWorkFlow = ApproveUtils.getInstance().notInWorkFlowWithoutType(billId.longValue());
        if (notInWorkFlow) {
            return null;
        }
        Long processId = this.getProcessId();
        Map approveRejectOpinions = ApproveUtils.getInstance().getApproveRejectOpinions((Set)Sets.newHashSet((Object[])new Long[]{processId}), (Set)Sets.newHashSet((Object[])new Long[]{billId}), true);
        List rejectOpinions = approveRejectOpinions.getOrDefault(processId, new ArrayList(16));
        ApproveOpinion opinion = new ApproveOpinion();
        List allApprovalRecord = WorkFlowUtil.getAllApprovalRecord((String)String.valueOf(billId));
        for (int i = allApprovalRecord.size() - 1; i >= 0 && !"submit".equals(groupDecisionType = (approvalRecordGroup = (IApprovalRecordGroup)allApprovalRecord.get(i)).getGroupDecisionType()); --i) {
            List children;
            if (opinion.getUserId() != null || opinion.getRecordTime() != null || (children = approvalRecordGroup.getChildren()) == null) continue;
            ArrayList<String> userNames = new ArrayList<String>(16);
            for (IApprovalRecordItem child : children) {
                Date recordTime = opinion.getRecordTime();
                Long formatTime = child.getFormatTime();
                if (recordTime == null && formatTime != null || recordTime != null && formatTime != null && formatTime > recordTime.getTime()) {
                    opinion.setRecordTime(new Date(formatTime));
                    opinion.setUserId(child.getUserId());
                    if ("approve".equals(groupDecisionType) || "reject".equals(groupDecisionType)) {
                        opinion.setApproveOpinion(child.getMessage());
                        if ("reject".equals(groupDecisionType)) {
                            opinion.setRejectOpinion(this.getSuitRejectOpinion(opinion, rejectOpinions));
                        } else {
                            String rejectOpinion = this.getSuitRejectOpinionOnReport(opinion, rejectOpinions);
                            if (StringUtils.isNotEmpty((String)rejectOpinion)) {
                                opinion.setRejectOpinion(rejectOpinion);
                            }
                        }
                    }
                }
                userNames.add(((ApprovalRecordItem)child).getUserNameFormat());
            }
            opinion.setUserName(String.join((CharSequence)"\u3001", userNames));
        }
        return opinion;
    }

    private List<ApproveOpinion> getJoinAuditDetailOpinions(ApproveOpinion opinion) {
        ArrayList<ApproveOpinion> opinions = new ArrayList<ApproveOpinion>(16);
        Long processId = this.getProcessId();
        Long approveBillId = this.getApproveBillId();
        Map approveRejectOpinions = ApproveUtils.getInstance().getApproveRejectOpinions((Set)Sets.newHashSet((Object[])new Long[]{processId}), (Set)Sets.newHashSet((Object[])new Long[]{approveBillId}), true);
        approveRejectOpinions.putAll(ApproveUtils.getInstance().getApproveRejectOpinions((Set)Sets.newHashSet((Object[])new Long[]{processId}), (Set)Sets.newHashSet((Object[])new Long[]{approveBillId}), true, true));
        List rejectOpinions = approveRejectOpinions.getOrDefault(processId, new ArrayList(16));
        String submitEntity = null;
        String fields = "orgviewid.name as view, billno, eborgid.name as submitentity";
        DynamicObject bill = QueryServiceHelper.queryOne((String)"eb_approvebill", (String)fields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)approveBillId)});
        String billNo = null;
        String orgView = null;
        if (bill != null) {
            billNo = bill.getString("billno");
            orgView = bill.getString("view");
            submitEntity = bill.getString("submitentity");
        }
        String tempName = null;
        String entity = null;
        fields = "template.name as tempName, entity.name as entName, submitentity.name as subName";
        DynamicObject query = QueryServiceHelper.queryOne((String)"eb_reportprocess", (String)fields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)processId)});
        if (query != null) {
            tempName = query.getString("tempName");
            entity = query.getString("entName");
        }
        List allApprovalRecord = WorkFlowUtil.getAllApprovalRecord((String)String.valueOf(approveBillId));
        for (IApprovalRecordGroup approvalRecordGroup : allApprovalRecord) {
            List children;
            String group = approvalRecordGroup.getGroup();
            if (!group.equals(opinion.getGroup()) || (children = approvalRecordGroup.getChildren()) == null) continue;
            for (IApprovalRecordItem child : children) {
                String decisionType = child.getDecisionType();
                if (decisionType == null) {
                    decisionType = ((ApprovalRecordItem)child).getGroupDecisionType();
                }
                ApproveOpinion approveOpinion = new ApproveOpinion();
                approveOpinion.setNodeId(child.getActivityId());
                approveOpinion.setNodeName(child.getActivityName());
                Long formatTime = child.getFormatTime();
                if (formatTime != null) {
                    approveOpinion.setRecordTime(new Date(formatTime));
                }
                approveOpinion.setUserId(child.getUserId());
                approveOpinion.setUserName(((ApprovalRecordItem)child).getUserNameFormat());
                approveOpinion.setTempName(tempName);
                approveOpinion.setOpType(this.getOpType(decisionType, JOIN_AUDIT_PRE));
                approveOpinion.setApproveOpinion(child.getMessage());
                approveOpinion.setEntity(entity);
                approveOpinion.setApproveBillNo(billNo);
                approveOpinion.setSubmitEntity(submitEntity);
                approveOpinion.setView(orgView);
                if ("approve".equals(decisionType)) {
                    String rejectOpinion = this.getSuitRejectOpinionOnReport(approveOpinion, rejectOpinions);
                    if (StringUtils.isNotEmpty((String)rejectOpinion)) {
                        approveOpinion.setRejectOpinion(rejectOpinion);
                    }
                } else if ("reject".equals(decisionType)) {
                    approveOpinion.setRejectOpinion(this.getSuitRejectOpinion(approveOpinion, rejectOpinions));
                } else if (!"wait".equals(decisionType)) continue;
                opinions.add(approveOpinion);
            }
        }
        return opinions;
    }

    private Long getProcessId() {
        if (this.processId == null) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Object processIdObj = customParams.get("processId");
            this.processId = ConvertUtils.toLong(processIdObj);
        }
        return this.processId;
    }

    private Long getApproveBillId() {
        if (this.approveBillId == null) {
            Long processId;
            QFilter qFilter;
            DynamicObject reportProcess;
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            this.approveBillId = ConvertUtils.toLong(customParams.get("approveBillId"));
            if (this.approveBillId == 0L && (reportProcess = QueryServiceHelper.queryOne((String)"eb_reportprocess", (String)"id,approvebill", (QFilter[])(qFilter = new QFilter("id", "=", (Object)(processId = this.getProcessId()))).toArray())) != null) {
                this.approveBillId = reportProcess.getLong("approvebill");
            }
        }
        return this.approveBillId;
    }

    private String getCurrentView() {
        return (String)this.getCache("curView", String.class, () -> "vector_list");
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String controlKey = control.getKey();
        if ("vector_list".equals(controlKey)) {
            this.loadListRecords();
        }
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        int rowIndex;
        String detailInfo;
        super.hyperLinkClick(hyperLinkClickEvent);
        String checkFormId = this.getCheckFormId();
        if (StringUtils.isNotEmpty((String)checkFormId)) {
            String appid = this.getAppId();
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"EPMPermissionService", (String)"checkPermission", (Object[])new Object[]{this.getModelId(), UserUtils.getUserId(), AppMetadataCache.getAppInfo((String)appid).getId(), checkFormId, "btn_viewcentralreport_l"});
        }
        if (StringUtils.isEmpty((String)(detailInfo = (String)this.getEntryValue("detailinfo", null, rowIndex = hyperLinkClickEvent.getRowIndex())))) {
            return;
        }
        ApproveOpinion opinion = (ApproveOpinion)SerializationUtils.fromJsonString((String)detailInfo, ApproveOpinion.class);
        if (opinion == null) {
            return;
        }
        HashMap<Long, List<Long>> billMap = new HashMap<Long, List<Long>>(16);
        Long approveBill = this.getApproveBillId();
        Long centralOrgId = opinion.getCentralOrgId();
        String mainNodeId = opinion.getMainNodeId();
        if (centralOrgId != null && centralOrgId != 0L) {
            List subApproveBillList = ApproveBillHelper.getSubApproveBillList((Long)approveBill, (boolean)false);
            Optional<ApproveBillInfo> optional = subApproveBillList.stream().filter(e -> e.getNodeId() != null && e.getNodeId().equals(mainNodeId) && e.getCentralOrgId().equals(centralOrgId)).findFirst();
            if (optional.isPresent()) {
                ApproveBillInfo approveBillInfo = optional.get();
                approveBill = approveBillInfo.getBillId();
            }
            if (IDUtils.isNotNull((Long)approveBill)) {
                billMap.put(this.getProcessId(), Lists.newArrayList((Object[])new Long[]{approveBill}));
            }
        } else if (opinion.isCanExpand() && "centralNode".equals(opinion.getExpandType())) {
            String[] split = opinion.getNodeId().split("_");
            String nodeId = split[split.length - 1];
            List subApproveBillList = ApproveBillHelper.getSubApproveBillList((Long)approveBill, (boolean)false);
            List bills = subApproveBillList.stream().filter(e -> e.getNodeId() != null && e.getNodeId().equals(nodeId)).map(ApproveBillInfo::getBillId).collect(Collectors.toList());
            billMap.put(this.getProcessId(), bills);
        } else if (IDUtils.isNotNull((Long)approveBill)) {
            billMap.put(this.getProcessId(), Lists.newArrayList((Object[])new Long[]{approveBill}));
        }
        IFormView parentView = this.getView().getParentView();
        CentralOptimization.getInstance().openCentralApproveList(parentView, billMap, this.getModelId(), (String)this.getCustomFormParam("pluginName"), true);
        this.getView().sendFormAction(parentView);
        this.getView().close();
    }

    @Override
    public Long getModelId() {
        return ConvertUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("modelId"));
    }

    public String getCheckFormId() {
        return (String)this.getView().getFormShowParameter().getCustomParam("checkFormId");
    }

    public String getAppId() {
        if (NewEbAppUtil.isNewEbModel((Long)this.getModelId())) {
            return ApplicationTypeEnum.EB.getAppnum();
        }
        return ApplicationTypeEnum.BGM.getAppnum();
    }
}

