/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.approveBill;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.epm.eb.business.approveBill.ApproveBillServiceHelper;
import kd.epm.eb.business.approveBill.CommitCheck;
import kd.epm.eb.business.approveBill.RejectOnReportService;
import kd.epm.eb.business.approvetype.ApproveUtils;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.business.ebupgrades.utils.UpgradesTaskUtil;
import kd.epm.eb.common.approveBill.Entity.ApproveBillStatus;
import kd.epm.eb.common.approveBill.Entity.RejectStatus;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.constant.BgTaskExecuteConstant;
import kd.epm.eb.common.enums.ApproveDecisionEnum;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.reportprocess.entity.domain.ReportProcess;
import kd.epm.eb.common.reportprocess.entity.dto.TemplateEntityDto;
import kd.epm.eb.common.reportprocess.entity.request.BaseRptProcessRequest;
import kd.epm.eb.common.reportprocess.helper.ApproveBillHelper;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessAggService;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.adjustrecord.AdjustRecordHelper;
import kd.epm.eb.spread.report.excel.constant.ReportExportTypeEnum;
import org.apache.commons.collections4.CollectionUtils;

public class ApproveOptimization
implements BgTaskExecuteConstant {
    private static final ApproveOptimization instance = new ApproveOptimization();
    public static final String CANCEL_CLOSE_KEY = "btn_batchcancel";
    public static final String APPROVE_CLOSE_KEY = "btn_batchapprove";
    public static final String APPROVE_CLOSE_KEY_TIP = "btn_batchapprove_tip";
    public static final String UN_AUDIT_CLOSE_KEY = "btn_batchunapprove";
    public static final String REJECT_CLOSE_KEY = "btn_reject";

    public static ApproveOptimization getInstance() {
        return instance;
    }

    public boolean isParentEntityInApprove(IFormView view, Long templateId, Long modelId) {
        String billNo;
        Map<String, Long> dimMembers;
        if (view == null) {
            return false;
        }
        IPageCache pageCache = view.getPageCache();
        if (pageCache == null) {
            return false;
        }
        if (ApproveBillHelper.hasCentralBill((IFormView)view)) {
            return false;
        }
        String org = pageCache.get("current_org");
        String period = pageCache.get("CURRENT_PERIOD");
        String version = pageCache.get("CURRENT_VERSION");
        String dataType = pageCache.get("CURRENT_DATATYPE");
        String viewId = pageCache.get("current_entity_view_id");
        Long view_id = ConvertUtils.toLong((Object)viewId);
        if (StringUtils.isEmpty((String)period) || StringUtils.isEmpty((String)org) || StringUtils.isEmpty((String)version) || StringUtils.isEmpty((String)dataType)) {
            dimMembers = this.getUserSelectF7FromCache(pageCache);
            if (!dimMembers.containsKey(SysDimensionEnum.Entity.getNumber())) {
                dimMembers.put(SysDimensionEnum.Entity.getNumber(), IDUtils.toLong((Object)org));
            }
            if (!(dimMembers.containsKey(SysDimensionEnum.DataType.getNumber()) && dimMembers.containsKey(SysDimensionEnum.Version.getNumber()) && dimMembers.containsKey(SysDimensionEnum.BudgetPeriod.getNumber()))) {
                Long taskPk = ConvertUtils.toLong((Object)pageCache.get("current_taskp"));
                DynamicObject taskP = QueryServiceHelper.queryOne((String)"eb_tasklist", (String)"year, version, datatype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taskPk)});
                if (taskP == null) {
                    return false;
                }
                if (!dimMembers.containsKey(SysDimensionEnum.DataType.getNumber())) {
                    dimMembers.put(SysDimensionEnum.DataType.getNumber(), taskP.getLong("datatype"));
                }
                if (!dimMembers.containsKey(SysDimensionEnum.Version.getNumber())) {
                    dimMembers.put(SysDimensionEnum.Version.getNumber(), taskP.getLong("version"));
                }
                if (!dimMembers.containsKey(SysDimensionEnum.BudgetPeriod.getNumber())) {
                    dimMembers.put(SysDimensionEnum.BudgetPeriod.getNumber(), taskP.getLong("year"));
                }
            }
        } else {
            dimMembers = new HashMap<String, Long>(16);
            dimMembers.put(SysDimensionEnum.Entity.getNumber(), Long.parseLong(org));
            dimMembers.put(SysDimensionEnum.BudgetPeriod.getNumber(), Long.parseLong(period));
            dimMembers.put(SysDimensionEnum.Version.getNumber(), Long.parseLong(version));
            dimMembers.put(SysDimensionEnum.DataType.getNumber(), Long.parseLong(dataType));
        }
        return (billNo = ApproveUtils.getInstance().isParentEntityInApprove(dimMembers, Collections.singletonList(templateId), modelId, view_id)) != null;
    }

    private Map<String, Long> getUserSelectF7FromCache(IPageCache pageCache) {
        HashMap<String, Long> f7KeyValues = new HashMap<String, Long>(16);
        for (Map.Entry e : pageCache.getAll().entrySet()) {
            if (!((String)e.getKey()).startsWith("lastselect_") || e.getValue() == null) continue;
            String dimNumber = ((String)e.getKey()).substring("lastselect_".length());
            f7KeyValues.put(dimNumber, Long.valueOf((String)e.getValue()));
        }
        return f7KeyValues;
    }

    public void viewApproveOpinion(IFormView view, Long modelId, String entryKey, String pluginName) {
        Long selectReport = this.getSelectReportId(view, entryKey);
        if (selectReport == null) {
            return;
        }
        this.viewApproveOpinion(view, selectReport, modelId, pluginName);
    }

    public void viewApproveOpinion(IFormView view, Long reportProcessId, Long modelId, String pluginName) {
        this.viewApproveOpinion(view, reportProcessId, 0L, modelId, pluginName);
    }

    public void viewApproveOpinion(IFormView view, Long reportProcessId, Long approveBillId, Long modelId, String pluginName) {
        this.viewApproveOpinion(view, reportProcessId, approveBillId, modelId, pluginName, view.getFormShowParameter().getFormId());
    }

    public void viewApproveOpinion(IFormView view, Long reportProcessId, Long approveBillId, Long modelId, String pluginName, String formId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_approveopinion_list");
        formShowParameter.setCustomParam("processId", (Object)reportProcessId);
        formShowParameter.setCustomParam("approveBillId", (Object)approveBillId);
        formShowParameter.setCustomParam("modelId", (Object)modelId);
        formShowParameter.setCustomParam("pluginName", (Object)pluginName);
        if (StringUtils.isNotEmpty((String)formId)) {
            formShowParameter.setCustomParam("checkFormId", (Object)formId);
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(formShowParameter);
    }

    public Long getSelectReportId(IFormView view, String entryKey) {
        EntryGrid control = (EntryGrid)view.getControl(entryKey);
        int[] selectRows = control.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e", (String)"ApproveOptimization_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        if (selectRows.length != 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u540c\u65f6\u67e5\u770b\u591a\u4e2a\u62a5\u8868\u5ba1\u6838\u610f\u89c1", (String)"ApproveOptimization_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        DynamicObject entryRowEntity = view.getModel().getEntryRowEntity(entryKey, selectRows[0]);
        long reportProcessId = entryRowEntity.getLong("process.id");
        if (IDUtils.isEmptyLong((Long)reportProcessId).booleanValue()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u62a5\u8868\u5b9e\u4f8b\u5931\u8d25", (String)"ApproveOptimization_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        return reportProcessId;
    }

    public void viewRptFlowChart(IFormView view, String entryKey, String processFiledKey) {
        EntryGrid control = (EntryGrid)view.getControl(entryKey);
        int[] selectRows = control.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"ApproveOptimization_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<Long> reportProcessIds = new HashSet<Long>(16);
        for (int selectRow : selectRows) {
            DynamicObject entryRowEntity = view.getModel().getEntryRowEntity(entryKey, selectRow);
            long reportProcessId = entryRowEntity.getLong(processFiledKey);
            reportProcessIds.add(reportProcessId);
        }
        ApproveOptimization.getInstance().viewRptFlowChart(view, reportProcessIds);
    }

    public void viewRptFlowChart(IFormView view, Set<Long> reportProcessIds) {
        if (CollectionUtils.isEmpty(reportProcessIds)) {
            return;
        }
        HashSet approveBillIds = new HashSet(16);
        Map reportBillMap = ApproveBillServiceHelper.getReportBillMap(new HashSet<Long>(reportProcessIds));
        if (!reportBillMap.isEmpty()) {
            reportBillMap.values().forEach(approveBillIds::addAll);
        }
        if (approveBillIds.isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u62a5\u8868\u4e0d\u5728\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u67e5\u770b\u5ba1\u6838\u6d41\u7a0b\u3002", (String)"BgTaskExecutePlugin_viewflow_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (approveBillIds.size() > 1 && reportBillMap.size() > 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u540c\u65f6\u67e5\u8be2\u591a\u5f20\u5355\u636e\u7684\u6d41\u7a0b\u3002", (String)"ReportPreparationListPlugin_48", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            WorkflowServiceHelper.viewFlowchart((String)view.getPageId(), approveBillIds.iterator().next());
        }
    }

    public Long getSelectedApproveBill(IFormView view, String tip) {
        EntryGrid control = (EntryGrid)view.getControl("billlist_entity");
        int[] selectRows = control.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"ApproveOptimization_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        long approveBillId = 0L;
        for (int selectRow : selectRows) {
            long reportProcessId;
            Set approveIds;
            DynamicObject entryRowEntity = view.getModel().getEntryRowEntity("billlist_entity", selectRow);
            long billId = entryRowEntity.getLong("approvebill.id");
            if (billId == 0L && CollectionUtils.isNotEmpty((Collection)(approveIds = ApproveBillServiceHelper.getReportBillMap((Long)(reportProcessId = entryRowEntity.getLong("process.id")))))) {
                billId = (Long)approveIds.iterator().next();
            }
            if (approveBillId == 0L) {
                approveBillId = billId;
                continue;
            }
            if (billId == 0L || billId == approveBillId) continue;
            view.showTipNotification(tip);
            return null;
        }
        return approveBillId;
    }

    public void batchCancel(IFormView view, String pluginName) {
        String errMessage;
        String submitUserErrMessage;
        EntryGrid control = (EntryGrid)view.getControl("billlist_entity");
        int[] selectRows = control.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u64a4\u9500\u6570\u636e", (String)"ApproveOptimization_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<String> statusNotMatch = new ArrayList<String>(16);
        HashMap<Long, List> checkSubmitUserMap = new HashMap<Long, List>(16);
        ArrayList<String> submitUserNotMatch = new ArrayList<String>(16);
        ArrayList<Long> relateApproveBills = new ArrayList<Long>(16);
        ArrayList<Long> checkApproveBills = new ArrayList<Long>(16);
        boolean containLocalApprove = false;
        HashSet<Long> processIds = new HashSet<Long>(16);
        ArrayList<DynamicObject> rows = new ArrayList<DynamicObject>(16);
        HashSet<Long> approveBillIds = new HashSet<Long>(16);
        for (int selectRow : selectRows) {
            DynamicObject entryRowEntity = view.getModel().getEntryRowEntity("billlist_entity", selectRow);
            long approveBill = entryRowEntity.getLong("approvebill.id");
            approveBillIds.add(approveBill);
            rows.add(entryRowEntity);
        }
        HashMap auditTypeMap = new HashMap(16);
        ApproveUtils.getInstance().queryRelBillInfo(approveBillIds, auditTypeMap);
        HashMap records = new HashMap(16);
        HashMap<Long, String> reportNameMaps = new HashMap<Long, String>(rows.size());
        for (DynamicObject entryRowEntity : rows) {
            String reportName = entryRowEntity.getString("reportname");
            reportNameMaps.put(entryRowEntity.getLong("approvebill.id"), reportName);
            String status = entryRowEntity.getString("status");
            if (!BgTaskStateEnum.UNDERWAY.getName().equals(status)) {
                if (statusNotMatch.contains(reportName)) continue;
                statusNotMatch.add(reportName);
                continue;
            }
            long processId = entryRowEntity.getLong("process.id");
            processIds.add(processId);
            List reportNames = checkSubmitUserMap.computeIfAbsent(processId, k -> new ArrayList(16));
            reportNames.add(reportName);
            long approveBill = entryRowEntity.getLong("approvebill.id");
            if (ApproveUtils.getInstance().notInWorkFlow(approveBill, (String)auditTypeMap.get(approveBill), records)) {
                containLocalApprove = true;
                relateApproveBills.add(processId);
            } else {
                relateApproveBills.add(approveBill);
            }
            checkApproveBills.add(approveBill);
        }
        HashMap<Long, Long> processEntityMap = new HashMap<Long, Long>(16);
        HashMap<Long, Long> processBillMap = new HashMap<Long, Long>(16);
        long userId = UserUtils.getUserId();
        DynamicObjectCollection processes = QueryServiceHelper.query((String)"eb_reportprocess", (String)"id, submituser, entity, approvebill", (QFilter[])new QFilter[]{new QFilter("id", "in", processIds)});
        for (DynamicObject process : processes) {
            long processId = process.getLong("id");
            List reportNames = (List)checkSubmitUserMap.get(processId);
            if (userId != process.getLong("submituser") && reportNames != null && reportNames.size() != 0) {
                for (String reportName : reportNames) {
                    if (submitUserNotMatch.contains(reportName)) continue;
                    submitUserNotMatch.add(reportName);
                }
            }
            processEntityMap.put(processId, process.getLong("entity"));
            processBillMap.put(process.getLong("approvebill"), processId);
        }
        ArrayList<String> errMessages = new ArrayList<String>(16);
        String statusErrMessage = String.join((CharSequence)"\u3001", statusNotMatch);
        if (StringUtils.isNotEmpty((String)statusErrMessage)) {
            errMessages.add(ResManager.loadKDString((String)"\u62a5\u8868%s\u4e0d\u662f\u5df2\u63d0\u4ea4\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500", (String)"ApproveOptimization_5", (String)"epm-eb-formplugin", (Object[])new Object[]{statusErrMessage}));
        }
        if (StringUtils.isNotEmpty((String)(submitUserErrMessage = String.join((CharSequence)"\u3001", submitUserNotMatch)))) {
            errMessages.add(ResManager.loadKDString((String)"\u4e0d\u80fd\u64a4\u9500\u975e\u672c\u4eba\u63d0\u4ea4\u7684\u62a5\u8868: %s", (String)"ApproveOptimization_6", (String)"epm-eb-formplugin", (Object[])new Object[]{submitUserErrMessage}));
        }
        if (StringUtils.isNotEmpty((String)(errMessage = String.join((CharSequence)";", errMessages)))) {
            view.showTipNotification(errMessage);
            return;
        }
        boolean existApproveBill = false;
        ArrayList<String> unValidates = new ArrayList<String>(16);
        QFilter qFilter = new QFilter("id", "in", checkApproveBills);
        qFilter.and("billstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{ApproveBillStatus.SUBMIT.getNumber(), ApproveBillStatus.AUDIT.getNumber()}));
        DynamicObjectCollection approveBills = QueryServiceHelper.query((String)"eb_approvebill", (String)"id, billno, eborgid", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject approveBill : approveBills) {
            Long entity;
            existApproveBill = true;
            long id = approveBill.getLong("id");
            Long processId = (Long)processBillMap.get(id);
            if (processId == null || processId == 0L || (entity = (Long)processEntityMap.get(processId)) == null || entity == 0L) continue;
            long orgId = approveBill.getLong("eborgid");
            String billNo = approveBill.getString("billno");
            if (orgId == entity || unValidates.contains(billNo)) continue;
            unValidates.add(billNo);
        }
        String validateMessage = String.join((CharSequence)";", unValidates);
        if (StringUtils.isNotEmpty((String)validateMessage)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u5df2\u7ecf\u63d0\u4ea4\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u3001\u5ba1\u6838\u6216\u53cd\u5ba1\u6838: %s", (String)"ApproveOptimization_7", (String)"epm-eb-formplugin", (Object[])new Object[]{validateMessage}));
            return;
        }
        if (!(existApproveBill || containLocalApprove && QueryServiceHelper.exists((String)"eb_reportprocess", (QFilter[])new QFilter[]{new QFilter("id", "in", relateApproveBills)}))) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5173\u8054\u5355\u636e\u5df2\u4e0d\u5b58\u5728", (String)"ApproveOptimization_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long modelId = ((DynamicObject)view.getModel().getValue("model")).getLong("id");
        Set<Long> hasAdjs = AdjustRecordHelper.hasAdjustRecords(modelId, approveBillIds);
        if (!hasAdjs.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(ResManager.loadKDString((String)"\u4ee5\u4e0b\u62a5\u8868\u5df2\u88ab\u5ba1\u6279\u8c03\u6574\uff0c\u64a4\u9500\u5931\u8d25\u3002", (String)"CommitCancel_03", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            int index = 1;
            for (Long failAproveId : hasAdjs) {
                if (index != 1) {
                    stringBuilder.append("\uff1b");
                }
                stringBuilder.append(String.format("%s.%s", index++, reportNameMaps.get(failAproveId)));
            }
            stringBuilder.append("\u3002");
            view.showTipNotification(stringBuilder.toString());
            return;
        }
        this.showCancelConfirmPage(view, relateApproveBills, pluginName, containLocalApprove);
    }

    private void showCancelConfirmPage(IFormView view, List<Long> relateApproveBills, String pluginName, boolean containLocalApprove) {
        IDataModel model = view.getModel();
        Long modelId = ((DynamicObject)model.getValue("model")).getLong("id");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_batchcancelconfirm");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> customMap = new HashMap<String, Object>(16);
        customMap.put("modelId", modelId);
        customMap.put("relateApproveBills", SerializationUtils.toJsonString(relateApproveBills));
        customMap.put("containLocalApprove", String.valueOf(containLocalApprove));
        formShowParameter.setCustomParams(customMap);
        formShowParameter.setCloseCallBack(new CloseCallBack(pluginName, CANCEL_CLOSE_KEY));
        view.showForm(formShowParameter);
    }

    public void batchCancelBills(IFormView view, Object returnData, String pluginName) {
        if (returnData == null) {
            return;
        }
        Map retData = (Map)SerializationUtils.fromJsonString((String)returnData.toString(), HashMap.class);
        if (retData == null || retData.size() == 0) {
            return;
        }
        boolean containLocalApprove = Convert.toBool(retData.get("containLocalApprove"), (Boolean)false);
        List relateApproveBills = (List)SerializationUtils.fromJsonString((String)retData.get("relateApproveBills").toString(), ArrayList.class);
        HashMap<String, String> errMessages = new HashMap<String, String>(16);
        HashMap<Long, String> billInfoMap = new HashMap<Long, String>(16);
        ArrayList<Long> toCancelBills = new ArrayList<Long>(16);
        DynamicObjectCollection approveBills = QueryServiceHelper.query((String)"eb_approvebill", (String)"id, billno, eborgid", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)relateApproveBills)});
        for (DynamicObject approveBill : approveBills) {
            String billNo = approveBill.getString("billno");
            long approveBillId = approveBill.getLong("id");
            billInfoMap.put(approveBillId, billNo);
            toCancelBills.add(approveBillId);
        }
        HashMap successInfos = new HashMap(16);
        HashSet successInfo = new HashSet(16);
        OperateOption op = OperateOption.create();
        op.setVariableValue("currbizappid", "bgm");
        op.setVariableValue("fromreport", "fromreport");
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"unsubmit01", (String)"eb_approvebill", (Object[])toCancelBills.toArray(), (OperateOption)op);
        if (operationResult.isSuccess()) {
            List successPkIds = operationResult.getSuccessPkIds();
            successPkIds.forEach(e -> successInfo.add(billInfoMap.get(ConvertUtils.toLong((Object)e))));
        } else {
            String billNo;
            List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
            for (IOperateInfo iOperateInfo : allErrorOrValidateInfo) {
                billNo = (String)billInfoMap.get(ConvertUtils.toLong((Object)iOperateInfo.getPkValue()));
                errMessages.put(billNo, iOperateInfo.getMessage());
            }
            if (errMessages.size() == 0 && StringUtils.isNotEmpty((String)operationResult.getMessage())) {
                for (Long toCancelBill : toCancelBills) {
                    billNo = (String)billInfoMap.get(toCancelBill);
                    errMessages.put(billNo, operationResult.getMessage());
                }
            }
        }
        if (containLocalApprove) {
            String fields = "id, template.name as tempName, template.id as tempId, model, approvebill, period, version, datatype, entity.number";
            DynamicObjectCollection processes = QueryServiceHelper.query((String)"eb_reportprocess", (String)fields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)relateApproveBills)});
            HashMap tempIds = new HashMap(16);
            ArrayList approveBillIds = new ArrayList(16);
            HashMap tempNameMap = new HashMap(16);
            HashMap approveProcessMap = new HashMap(16);
            processes.forEach(e -> {
                long id = e.getLong("id");
                long approveBill = e.getLong("approvebill");
                tempIds.computeIfAbsent(approveBill, k -> new ArrayList(16)).add(e.getLong("tempId"));
                approveBillIds.add(approveBill);
                List tempNames = tempNameMap.computeIfAbsent(approveBill, k -> new ArrayList(16));
                tempNames.add(e.getString("tempName"));
                List ref_processIds = approveProcessMap.computeIfAbsent(approveBill, k -> new ArrayList(16));
                ref_processIds.add(id);
            });
            HashSet success_tmp = new HashSet(16);
            HashSet toUpdateProcessIds = new HashSet(16);
            HashSet<Long> toUpdateApproveIds = new HashSet<Long>(16);
            HashSet<Long> hasCheckedBills = new HashSet<Long>(16);
            for (Long approveBillId : approveBillIds) {
                if (hasCheckedBills.contains(approveBillId)) continue;
                List tempNames = tempNameMap.getOrDefault(approveBillId, new ArrayList(16));
                boolean canOperation = new CommitCheck().checkCurrentSchemeOrTaskEntityReportCanOperation(approveBillId, null, false);
                if (!canOperation) {
                    errMessages.put(String.join((CharSequence)"\u3001", tempNames), ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u5df2\u63d0\u4ea4\uff0c\u65e0\u6cd5\u64a4\u9500\u6216\u53cd\u5ba1\u6838\u3002", (String)"CommitCheck_6", (String)"epm-eb-business", (Object[])new Object[0]));
                    continue;
                }
                String billNo = ApproveUtils.getInstance().isParentEntityInApprove(approveBillId);
                if (billNo != null) {
                    errMessages.put(String.join((CharSequence)"\u3001", tempNames), ResManager.loadResFormat((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u5df2\u63d0\u4ea4\u5355\u636e\u201c%1\u201d\uff0c\u65e0\u6cd5\u64a4\u9500\u6216\u53cd\u5ba1\u6838\u3002", (String)"CommitCheck_11", (String)"epm-eb-formplugin", (Object[])new Object[]{billNo}));
                } else {
                    success_tmp.addAll(tempNames);
                    toUpdateProcessIds.addAll(approveProcessMap.getOrDefault(approveBillId, new ArrayList(16)));
                    toUpdateApproveIds.add(approveBillId);
                }
                hasCheckedBills.add(approveBillId);
            }
            if (toUpdateProcessIds.size() != 0) {
                Set process_all = ApproveUtils.getInstance().getProcessRefReportProcessInfoWithAllEntity(toUpdateProcessIds);
                if (process_all.size() != 0) {
                    SqlBuilder sqlBuilder = new SqlBuilder();
                    sqlBuilder.append("update t_eb_reportprocess set fstatus = '0', fsubmitdate = null, fsubmituser = 0, fsubmitentity = 0, fapprovebill = 0 where ", new Object[0]);
                    sqlBuilder.appendIn("fid", process_all.toArray());
                    sqlBuilder.append(" and (fmodifier = 0 or fmodifier is null)", new Object[0]);
                    DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
                    sqlBuilder = new SqlBuilder();
                    sqlBuilder.append("update t_eb_reportprocess set fstatus = '7', fsubmitdate = null, fsubmituser = 0, fsubmitentity = 0, fapprovebill = 0 where ", new Object[0]);
                    sqlBuilder.appendIn("fid", process_all.toArray());
                    sqlBuilder.append(" and fmodifier != 0", new Object[0]);
                    DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
                    this.updateProcessStatusByRptReadOnlyTemplate(process_all);
                }
                ApproveUtils.getInstance().deleteRefApproveDesc(toUpdateProcessIds);
                ApproveBillServiceHelper.unLockDimMemForLocalApprove(toUpdateApproveIds);
                for (Long toUpdateApproveId : toUpdateApproveIds) {
                    this.deleteTemplateInApproveBill(Lists.newArrayList((Object[])new Long[]{toUpdateApproveId}), tempIds.getOrDefault(toUpdateApproveId, new ArrayList(16)));
                }
                UpgradesTaskUtil.getInstance().clearDataEntityCache("eb_reportprocess");
                successInfo.addAll(success_tmp);
            }
        }
        if (successInfo.size() != 0) {
            successInfos.put(ResManager.loadKDString((String)"\u5df2\u64a4\u9500", (String)"ApproveOptimization_9", (String)"epm-eb-formplugin", (Object[])new Object[0]), successInfo);
        }
        String opName = ResManager.loadKDString((String)"\u64a4\u9500", (String)"ApproveOptimization_10", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        CentralAppBillService.getInstance().showOperationResult(opName, successInfos, errMessages, view, pluginName);
    }

    public void deleteTemplateInApproveBill(List<Long> approveBillIds, List<Long> tempIds) {
        if (tempIds == null || tempIds.size() == 0) {
            return;
        }
        HashMap<Long, Boolean> existTemp = new HashMap<Long, Boolean>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid, ftempid from t_eb_approvebillentry where ", new Object[0]);
        sqlBuilder.appendIn("fid", approveBillIds.toArray());
        try (DataSet ds = DB.queryDataSet((String)"queryApproveEntry", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long tempId = row.getLong("ftempid");
                if (tempIds.contains(tempId)) continue;
                existTemp.put(row.getLong("fid"), true);
            }
        }
        sqlBuilder = new SqlBuilder();
        sqlBuilder.append("delete from t_eb_approvebillentry where ", new Object[0]);
        sqlBuilder.appendIn("fid", approveBillIds.toArray());
        sqlBuilder.append(" and ", new Object[0]).appendIn("ftempid", tempIds.toArray());
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
        ArrayList<Long> toRemoveApproveBills = new ArrayList<Long>(approveBillIds);
        toRemoveApproveBills.removeAll(existTemp.keySet());
        if (toRemoveApproveBills.size() != 0) {
            sqlBuilder = new SqlBuilder();
            sqlBuilder.append("delete from t_eb_approvebill where ", new Object[0]);
            sqlBuilder.appendIn("fid", toRemoveApproveBills.toArray());
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
        }
        UpgradesTaskUtil.getInstance().clearDataEntityCache("eb_approvebill");
    }

    public void batchApprove(IFormView view, String entryKey, String pluginName, long modelId) {
        this.batchApprove(view, entryKey, pluginName, modelId, false);
    }

    public void batchApprove(IFormView view, String entryKey, String pluginName, long modelId, boolean isApprove) {
        this.batchApprove(view, entryKey, pluginName, modelId, false, isApprove);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void batchApprove(IFormView view, String entryKey, String pluginName, long modelId, boolean isApproveList, boolean isApprove) {
        int[] selectRows;
        HashMap<Long, DynamicObject> approveInfos;
        ArrayList<Long> approveBillIds;
        block7: {
            ArrayList billNumbers;
            block6: {
                block4: {
                    String fields;
                    block5: {
                        approveBillIds = new ArrayList<Long>(16);
                        approveInfos = new HashMap<Long, DynamicObject>(16);
                        if (!isApprove) break block4;
                        fields = "id, billno as reportname, billstatus as status, rptprocesstype, eborgid, bizmodelid, modelid, orgviewid";
                        if (!isApproveList) break block5;
                        billNumbers = new ArrayList(16);
                        BillList billList = (BillList)view.getControl("billlistap");
                        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                        selectedRows.forEach(e -> {
                            approveBillIds.add(ConvertUtils.toLong((Object)e.getPrimaryKeyValue()));
                            billNumbers.add(e.getNumber());
                        });
                        DynamicObjectCollection bills = QueryServiceHelper.query((String)"eb_approvebill", (String)fields, (QFilter[])new QFilter[]{new QFilter("id", "in", approveBillIds)});
                        bills.forEach(e -> approveInfos.put(e.getLong("id"), (DynamicObject)e));
                        selectRows = new int[approveBillIds.size()];
                        break block6;
                    }
                    Long pkId = ConvertUtils.toLong((Object)((BillShowParameter)view.getFormShowParameter()).getPkId());
                    DynamicObject bill = QueryServiceHelper.queryOne((String)"eb_approvebill", (String)fields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pkId)});
                    if (bill == null) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (String)"ApproveOptimization_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    selectRows = new int[1];
                    approveInfos.put(bill.getLong("id"), bill);
                    approveBillIds.add(bill.getLong("id"));
                    break block7;
                }
                EntryGrid control = (EntryGrid)view.getControl(entryKey);
                selectRows = control.getSelectRows();
                break block7;
            }
            for (int i = 0; i < approveBillIds.size(); ++i) {
                if (approveInfos.get(approveBillIds.get(i)) == null) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e%s\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"ApproveOptimization_38", (String)"epm-eb-formplugin", (Object[])new Object[]{billNumbers.get(i)}));
                    return;
                }
                selectRows[i] = i;
            }
        }
        if (selectRows != null && selectRows.length != 0) {
            this.checkAuditAndShowApprovePage(view, selectRows, approveBillIds, new ArrayList<Long>(16), approveInfos, entryKey, pluginName, modelId, isApproveList, isApprove);
            return;
        }
        view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5ba1\u6838\u6570\u636e\u3002", (String)"ApproveOptimization_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    public void checkAuditAndShowApprovePage(IFormView view, int[] selectRows, List<Long> approveBillIds, List<Long> processIds, Map<Long, DynamicObject> approveInfos, String entryKey, String pluginName, long modelId, boolean isApproveList, boolean isApprove) {
        String errMessage;
        String validateMessage;
        String errMessage2;
        String errMessage1;
        String approveErrMessage;
        HashMap<Long, Set<Long>> entityPermIds = new HashMap<Long, Set<Long>>(16);
        HashSet<String> statusNotMatch = new HashSet<String>(16);
        HashSet<String> cannotApproveBills = new HashSet<String>(16);
        HashSet<Long> relateApproveBills = new HashSet<Long>(16);
        HashSet<String> notMatchingWorkFlows = new HashSet<String>(16);
        HashSet<String> notEntityPermBills = new HashSet<String>(16);
        HashSet<Long> centralApproveBills = new HashSet<Long>(16);
        HashSet<Long> checkApproveBills = new HashSet<Long>(16);
        boolean containLocalApprove = false;
        boolean containWorkFlowApprove = false;
        ArrayList<DynamicObject> rows = new ArrayList<DynamicObject>(16);
        ArrayList<Long> approveIds = new ArrayList<Long>(16);
        for (int selectRow : selectRows) {
            DynamicObject entryRowEntity = this.getRowDynamicInfo(view, selectRow, approveBillIds, approveInfos, entryKey, isApprove);
            long approveBill = isApprove ? approveBillIds.get(selectRow).longValue() : entryRowEntity.getLong("approvebill.id");
            approveIds.add(approveBill);
            rows.add(entryRowEntity);
        }
        HashMap auditTypeMap = new HashMap(16);
        ApproveUtils.getInstance().queryRelBillInfo(approveIds, auditTypeMap);
        HashMap records = new HashMap(16);
        HashMap<String, String> approveMap = new HashMap<String, String>(16);
        for (int i = 0; i < rows.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)rows.get(i);
            String reportName = dynamicObject.getString("reportname");
            String status = dynamicObject.getString("status");
            if (!BgTaskStateEnum.UNDERWAY.getName().equals(status) && !"B".equals(status)) {
                statusNotMatch.add(reportName);
                continue;
            }
            long approveBill = (Long)approveIds.get(i);
            if (ApproveUtils.getInstance().notInWorkFlow(approveBill, (String)auditTypeMap.get(approveBill), records)) {
                containLocalApprove = true;
                if (containWorkFlowApprove) continue;
                if (isApprove) {
                    if ("1".equals(dynamicObject.getString("rptprocesstype"))) {
                        notMatchingWorkFlows.add(reportName);
                    } else {
                        Set<Long> entityIds = this.getEntityPermIdInApproveList(entityPermIds, dynamicObject);
                        if (entityIds == null || entityIds.contains(dynamicObject.getLong("eborgid"))) {
                            relateApproveBills.addAll(ApproveUtils.getInstance().getApproveRefReportProcessIds(Collections.singleton(approveBill)));
                        } else {
                            notEntityPermBills.add(reportName);
                        }
                    }
                } else {
                    relateApproveBills.add(dynamicObject.getLong("process.id"));
                }
            } else {
                containWorkFlowApprove = true;
                if (containLocalApprove) continue;
                Long taskId = WorkflowServiceHelper.getTaskIdByBusinessKeyAndUserId((String)String.valueOf(approveBill), (Long)UserUtils.getUserId());
                if (taskId == null || taskId == 0L) {
                    if (!isApprove && ApproveUtils.getInstance().isCurWaitNode(approveBill)) {
                        centralApproveBills.add(approveBill);
                        long processId = dynamicObject.getLong("process.id");
                        approveMap.put(String.valueOf(processId), String.valueOf(approveBill));
                        processIds.add(processId);
                    } else {
                        cannotApproveBills.add(reportName);
                    }
                } else {
                    relateApproveBills.add(approveBill);
                    if (!isApprove) {
                        processIds.add(dynamicObject.getLong("process.id"));
                    }
                }
            }
            checkApproveBills.add(approveBill);
        }
        if (RejectOnReportService.getInstance().handleRejectOnReportForAudit(new HashSet(approveIds), new HashSet<Long>(processIds))) {
            view.showSuccessNotification(ResManager.loadKDString((String)"\u5ba1\u6838\u6210\u529f", (String)"ApproveBillListPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<Long, Long> processEntityMap = new HashMap<Long, Long>(16);
        HashMap<Long, Long> processBillMap = new HashMap<Long, Long>(16);
        DynamicObjectCollection processes = QueryServiceHelper.query((String)"eb_reportprocess", (String)"id, submituser, entity, approvebill", (QFilter[])new QFilter[]{new QFilter("id", "in", processIds)});
        for (DynamicObject process : processes) {
            long processId = process.getLong("id");
            processEntityMap.put(processId, process.getLong("entity"));
            processBillMap.put(process.getLong("approvebill"), processId);
        }
        boolean existApproveBill = false;
        ArrayList<String> unValidates = new ArrayList<String>(16);
        QFilter qFilter = new QFilter("id", "in", checkApproveBills);
        qFilter.and("billstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{ApproveBillStatus.SUBMIT.getNumber(), ApproveBillStatus.AUDIT.getNumber()}));
        DynamicObjectCollection approveBills = QueryServiceHelper.query((String)"eb_approvebill", (String)"id, billno, eborgid", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject approveBill : approveBills) {
            Long entity;
            long id;
            Long processId;
            existApproveBill = true;
            if (isApproveList || (processId = (Long)processBillMap.get(id = approveBill.getLong("id"))) == null || processId == 0L || (entity = (Long)processEntityMap.get(processId)) == null || entity == 0L) continue;
            long orgId = approveBill.getLong("eborgid");
            String billNo = approveBill.getString("billno");
            if (orgId == entity || unValidates.contains(billNo)) continue;
            unValidates.add(billNo);
        }
        ArrayList<String> errMessages = new ArrayList<String>(16);
        String statusErrMessage = String.join((CharSequence)"\u3001", statusNotMatch);
        String type = ResManager.loadKDString((String)"\u62a5\u8868", (String)"ApproveOptimization_13", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        if (isApprove) {
            type = ResManager.loadKDString((String)"\u5355\u636e", (String)"ApproveOptimization_14", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        if (StringUtils.isNotEmpty((String)statusErrMessage)) {
            errMessages.add(ResManager.loadResFormat((String)"%1 %2\u4e0d\u662f\u5df2\u63d0\u4ea4\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u5ba1\u6838", (String)"ApproveOptimization_15", (String)"epm-eb-formplugin", (Object[])new Object[]{type, statusErrMessage}));
        }
        if (StringUtils.isNotEmpty((String)(approveErrMessage = String.join((CharSequence)"\u3001", cannotApproveBills)))) {
            errMessages.add(ResManager.loadResFormat((String)"\u4e0d\u80fd\u5ba1\u6838\u975e\u672c\u4eba\u5904\u7406\u7684%1\uff1a%2", (String)"ApproveOptimization_16", (String)"epm-eb-formplugin", (Object[])new Object[]{type, approveErrMessage}));
        }
        if (StringUtils.isNotEmpty((String)(errMessage1 = String.join((CharSequence)"\u3001", notMatchingWorkFlows)))) {
            errMessages.add(ResManager.loadKDString((String)"\u5355\u636e%s\u672a\u80fd\u5339\u914d\u5bf9\u5e94\u7684\u5de5\u4f5c\u6d41", (String)"ApproveOptimization_17", (String)"epm-eb-formplugin", (Object[])new Object[]{errMessage1}));
        }
        if (StringUtils.isNotEmpty((String)(errMessage2 = String.join((CharSequence)"\u3001", notEntityPermBills)))) {
            errMessages.add(ResManager.loadKDString((String)"\u4e0d\u80fd\u5ba1\u6838\u65e0\u5bf9\u5e94\u7f16\u5236\u7ec4\u7ec7\u6743\u9650\u7684\u5355\u636e%s", (String)"ApproveOptimization_18", (String)"epm-eb-formplugin", (Object[])new Object[]{errMessage2}));
        }
        if (containLocalApprove && containWorkFlowApprove) {
            errMessages.add(ResManager.loadKDString((String)"\u4e0d\u80fd\u540c\u65f6\u5ba1\u6838\u5de5\u4f5c\u6d41\u5355\u636e\u548c\u672c\u5730\u5ba1\u6838\u5355\u636e", (String)"ApproveOptimization_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (centralApproveBills.size() > 0 && relateApproveBills.size() != 0) {
            errMessages.add(ResManager.loadKDString((String)"\u4e0d\u80fd\u540c\u65f6\u5ba1\u6838\u5de5\u4f5c\u6d41\u5355\u636e\u548c\u5f52\u53e3\u5ba1\u6838\u5355\u636e", (String)"ApproveOptimization_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (centralApproveBills.size() > 1 && relateApproveBills.size() == 0) {
            errMessages.add(ResManager.loadKDString((String)"\u4e0d\u80fd\u540c\u65f6\u5ba1\u6838\u591a\u4e2a\u5f52\u53e3\u5ba1\u6838\u4e3b\u5355\u636e", (String)"ApproveOptimization_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isNotEmpty((String)(validateMessage = String.join((CharSequence)";", unValidates)))) {
            errMessages.add(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u5df2\u7ecf\u63d0\u4ea4\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u3001\u5ba1\u6838\u6216\u53cd\u5ba1\u6838: %s", (String)"ApproveOptimization_22", (String)"epm-eb-formplugin", (Object[])new Object[]{validateMessage}));
        }
        if (StringUtils.isNotEmpty((String)(errMessage = String.join((CharSequence)";", errMessages)))) {
            view.showTipNotification(errMessage);
            return;
        }
        if (!(existApproveBill || centralApproveBills.size() != 0 || containLocalApprove && QueryServiceHelper.exists((String)"eb_reportprocess", (QFilter[])new QFilter[]{new QFilter("id", "in", relateApproveBills)}))) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5173\u8054\u5355\u636e\u5df2\u4e0d\u5b58\u5728", (String)"ApproveOptimization_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (centralApproveBills.size() == 0) {
            this.showApproveConfirmPage(view, relateApproveBills, pluginName, modelId, containLocalApprove);
        } else {
            this.showApproveTipPage(view, approveMap, pluginName, modelId);
        }
    }

    private void showApproveTipPage(IFormView view, Map<String, String> bills, String pluginName, long modelId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_approvetip");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> customMap = new HashMap<String, Object>(16);
        customMap.put("modelId", modelId);
        customMap.put("bills", SerializationUtils.toJsonString(bills));
        formShowParameter.setCustomParams(customMap);
        formShowParameter.setCloseCallBack(new CloseCallBack(pluginName, APPROVE_CLOSE_KEY_TIP));
        view.showForm(formShowParameter);
    }

    public void showApproveConfirmPage(IFormView view, Collection<Long> relateApproveBills, String pluginName, long modelId, boolean isLocalApprove) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_approveopconfirm");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> customMap = new HashMap<String, Object>(16);
        customMap.put("modelId", modelId);
        ArrayList<String> invisibleObjects = new ArrayList<String>(16);
        HashMap alterRelateInvisibleMap = new HashMap(16);
        ArrayList<String> approveObjects = new ArrayList<String>(16);
        ArrayList<String> opinionObjects = new ArrayList<String>(16);
        ArrayList<String> reportObjects = new ArrayList<String>(16);
        ArrayList<String> localObjects = new ArrayList<String>(16);
        invisibleObjects.add(REJECT_CLOSE_KEY);
        if (isLocalApprove) {
            invisibleObjects.add("reject");
            invisibleObjects.add("rejectonreport");
            localObjects.add("auditpasspanel");
            localObjects.add("rejectnode");
            localObjects.add("mustreject");
            localObjects.add("status");
            localObjects.add("tip");
        } else {
            invisibleObjects.add("localreject");
            opinionObjects.add("auditpasspanel");
            opinionObjects.add("status");
            opinionObjects.add("tip");
            reportObjects.add("auditpasspanel");
            reportObjects.add("mustreject");
        }
        approveObjects.add("rejectpanel");
        approveObjects.add("rejectnode");
        alterRelateInvisibleMap.put(ApproveDecisionEnum.REJECT_TASK.getIndex(), opinionObjects);
        alterRelateInvisibleMap.put(ApproveDecisionEnum.APPROVE.getIndex(), approveObjects);
        alterRelateInvisibleMap.put(ApproveDecisionEnum.REJECT_LOCAL.getIndex(), localObjects);
        alterRelateInvisibleMap.put(ApproveDecisionEnum.REJECT_REPORT.getIndex(), reportObjects);
        customMap.put("invisible_object", SerializationUtils.toJsonString(invisibleObjects));
        customMap.put("alterRelateInvisible", SerializationUtils.toJsonString(alterRelateInvisibleMap));
        customMap.put("relateApproveBills", SerializationUtils.toJsonString(relateApproveBills));
        customMap.put("containLocalApprove", String.valueOf(isLocalApprove));
        formShowParameter.setCustomParams(customMap);
        formShowParameter.setCloseCallBack(new CloseCallBack(pluginName, APPROVE_CLOSE_KEY));
        view.showForm(formShowParameter);
    }

    public boolean isApproveConfirm(Object retData) {
        if (retData == null) {
            return false;
        }
        Map returnData = (Map)retData;
        String result = (String)returnData.get("result");
        return "success".equals(result);
    }

    public Set<Long> getEntityPermIdInApproveList(Map<Long, Set<Long>> entityPermIds, DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return new HashSet<Long>(16);
        }
        long bizModelId = dynamicObject.getLong("bizmodelid");
        Long orgViewId = dynamicObject.getLong("orgviewid.id");
        Set hasPerms = entityPermIds.get(bizModelId);
        if (hasPerms == null) {
            hasPerms = DimMembPermHelper.getPermMembIds((String)SysDimensionEnum.Entity.getNumber(), (Long)dynamicObject.getLong("modelid"), (Long)bizModelId, (Long)orgViewId, (DimMembPermType)DimMembPermType.READ, (boolean)true);
            if (hasPerms == null) {
                entityPermIds.put(bizModelId, Collections.singleton(-1L));
                return null;
            }
            entityPermIds.put(bizModelId, hasPerms);
        } else if (hasPerms.size() == 1 && hasPerms.contains(-1L)) {
            return null;
        }
        return hasPerms;
    }

    private DynamicObject getRowDynamicInfo(IFormView view, int selectRow, List<Long> approveBillIds, Map<Long, DynamicObject> approveInfos, String entryKey, boolean isApprove) {
        if (isApprove) {
            return approveInfos.get(approveBillIds.get(selectRow));
        }
        return view.getModel().getEntryRowEntity(entryKey, selectRow);
    }

    public void openDownloadPage(IFormView view, Long modelId) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("eb_exportfilelist");
        OpenStyle openStyle = showParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("1000");
        css.setHeight("600");
        openStyle.setInlineStyleCss(css);
        showParameter.setMultiSelect(true);
        showParameter.setShowTitle(true);
        showParameter.setLookUp(false);
        Long userId = UserUtils.getUserId();
        showParameter.setCustomParam("model", (Object)modelId);
        showParameter.setCustomParam("creater", (Object)userId);
        ArrayList filters = Lists.newArrayList((Object[])new QFilter[]{new QFilter("model", "=", (Object)modelId)});
        filters.add(new QFilter("creater", "=", (Object)userId));
        showParameter.getListFilterParameter().setQFilters((List)filters);
        view.showForm((FormShowParameter)showParameter);
    }

    public void batchUnAudit(IFormView view, String pluginName, Long schemeAssignId) {
        String errMessage;
        String validateMessage;
        String approveErrMessage;
        EntryGrid control = (EntryGrid)view.getControl("billlist_entity");
        int[] selectRows = control.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53cd\u5ba1\u6838\u6570\u636e", (String)"ApproveOptimization_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<String> statusNotMatch = new ArrayList<String>(16);
        ArrayList<String> cannotUnApproveBills = new ArrayList<String>(16);
        ArrayList<Long> relateApproveBills = new ArrayList<Long>(16);
        boolean containLocalApprove = false;
        boolean containWorkFlowApprove = false;
        ArrayList<DynamicObject> rows = new ArrayList<DynamicObject>(16);
        HashSet<Long> approveBillIds = new HashSet<Long>(16);
        HashSet<Long> checkApproveBills = new HashSet<Long>(16);
        HashSet<Long> processIds = new HashSet<Long>(16);
        for (int selectRow : selectRows) {
            DynamicObject entryRowEntity = view.getModel().getEntryRowEntity("billlist_entity", selectRow);
            long approveBill = entryRowEntity.getLong("approvebill.id");
            approveBillIds.add(approveBill);
            rows.add(entryRowEntity);
        }
        HashMap auditTypeMap = new HashMap(16);
        ApproveUtils.getInstance().queryRelBillInfo(approveBillIds, auditTypeMap);
        HashMap records = new HashMap(16);
        ArrayList<Long> currentSchemeCannotUnAduit = new ArrayList<Long>(16);
        for (DynamicObject entryRowEntity : rows) {
            String reportName = entryRowEntity.getString("reportname");
            String status = entryRowEntity.getString("status");
            if (!BgTaskStateEnum.COMPLETED.getName().equals(status)) {
                if (statusNotMatch.contains(reportName)) continue;
                statusNotMatch.add(reportName);
                continue;
            }
            long approveBill = entryRowEntity.getLong("approvebill.id");
            long processId = entryRowEntity.getLong("process.id");
            long orgId = entryRowEntity.getLong("process.entity.id");
            processIds.add(processId);
            boolean canOperation = new CommitCheck().checkCurrentSchemeOrTaskEntityReeportCanOperationByTaskOrSchemeAssign(schemeAssignId, null, false, Long.valueOf(orgId));
            if (!canOperation) {
                currentSchemeCannotUnAduit.add(approveBill);
                continue;
            }
            if (ApproveUtils.getInstance().notInWorkFlow(approveBill, (String)auditTypeMap.get(approveBill), records)) {
                containLocalApprove = true;
                if (containWorkFlowApprove) continue;
                relateApproveBills.add(entryRowEntity.getLong("process.id"));
            } else {
                containWorkFlowApprove = true;
                if (containLocalApprove) continue;
                Long taskId = WorkflowServiceHelper.getTaskIdByBusinessKeyAndUserId((String)String.valueOf(approveBill), (Long)UserUtils.getUserId());
                if (taskId == null || taskId == 0L) {
                    relateApproveBills.add(approveBill);
                } else if (!cannotUnApproveBills.contains(reportName)) {
                    cannotUnApproveBills.add(reportName);
                }
            }
            checkApproveBills.add(approveBill);
        }
        HashMap<Long, Long> processEntityMap = new HashMap<Long, Long>(16);
        HashMap<Long, Long> processBillMap = new HashMap<Long, Long>(16);
        DynamicObjectCollection processes = QueryServiceHelper.query((String)"eb_reportprocess", (String)"id, entity, approvebill", (QFilter[])new QFilter[]{new QFilter("id", "in", processIds)});
        for (DynamicObject process : processes) {
            long processId = process.getLong("id");
            processEntityMap.put(processId, process.getLong("entity"));
            processBillMap.put(process.getLong("approvebill"), processId);
        }
        boolean existApproveBill = false;
        ArrayList<String> unValidates = new ArrayList<String>(16);
        QFilter qFilter = new QFilter("id", "in", checkApproveBills);
        qFilter.and("billstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{ApproveBillStatus.SUBMIT.getNumber(), ApproveBillStatus.AUDIT.getNumber()}));
        DynamicObjectCollection approveBills = QueryServiceHelper.query((String)"eb_approvebill", (String)"id, billno, eborgid", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject approveBill : approveBills) {
            Long entity;
            existApproveBill = true;
            long id = approveBill.getLong("id");
            Long processId = (Long)processBillMap.get(id);
            if (processId == null || processId == 0L || (entity = (Long)processEntityMap.get(processId)) == null || entity == 0L) continue;
            long orgId = approveBill.getLong("eborgid");
            String billNo = approveBill.getString("billno");
            if (orgId == entity || unValidates.contains(billNo)) continue;
            unValidates.add(billNo);
        }
        ArrayList<String> errMessages = new ArrayList<String>(16);
        String statusErrMessage = String.join((CharSequence)"\u3001", statusNotMatch);
        if (StringUtils.isNotEmpty((String)statusErrMessage)) {
            errMessages.add(ResManager.loadKDString((String)"\u62a5\u8868%s\u4e0d\u662f\u5df2\u5ba1\u6838\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838", (String)"ApproveOptimization_24", (String)"epm-eb-formplugin", (Object[])new Object[]{statusErrMessage}));
        }
        if (StringUtils.isNotEmpty((String)(approveErrMessage = String.join((CharSequence)"\u3001", cannotUnApproveBills)))) {
            errMessages.add(ResManager.loadKDString((String)"\u62a5\u8868%s\u8fd8\u5728\u6d41\u8f6c\u4e2d\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838", (String)"ApproveOptimization_25", (String)"epm-eb-formplugin", (Object[])new Object[]{approveErrMessage}));
        }
        if (containLocalApprove && containWorkFlowApprove) {
            errMessages.add(ResManager.loadKDString((String)"\u4e0d\u80fd\u540c\u65f6\u53cd\u5ba1\u6838\u5de5\u4f5c\u6d41\u5355\u636e\u548c\u672c\u5730\u5ba1\u6838\u5355\u636e", (String)"ApproveOptimization_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isNotEmpty((String)(validateMessage = String.join((CharSequence)";", unValidates)))) {
            errMessages.add(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u5df2\u7ecf\u63d0\u4ea4\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u3001\u5ba1\u6838\u6216\u53cd\u5ba1\u6838: %s", (String)"ApproveOptimization_7", (String)"epm-eb-formplugin", (Object[])new Object[]{validateMessage}));
        }
        if (CollectionUtils.isNotEmpty(currentSchemeCannotUnAduit)) {
            errMessages.add(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u5df2\u7ecf\u63d0\u4ea4\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u6216\u53cd\u5ba1\u6838\u3002", (String)"ApproveOptimization_41", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isNotEmpty((String)(errMessage = String.join((CharSequence)";", errMessages)))) {
            view.showTipNotification(errMessage);
            return;
        }
        if (!(existApproveBill || containLocalApprove && QueryServiceHelper.exists((String)"eb_reportprocess", (QFilter[])new QFilter[]{new QFilter("id", "in", relateApproveBills)}))) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5173\u8054\u5355\u636e\u5df2\u4e0d\u5b58\u5728", (String)"ApproveOptimization_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.showUnApproveConfirmPage(view, relateApproveBills, pluginName, containLocalApprove);
    }

    public void showUnApproveConfirmPage(IFormView view, List<Long> relateApproveBills, String pluginName, boolean isLocalApprove) {
        view.getPageCache().put("isLocalApprove", isLocalApprove ? "true" : null);
        view.getPageCache().put("toUnAuditBills", SerializationUtils.toJsonString(relateApproveBills));
        view.showConfirm(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u62a5\u8868\u4f1a\u5c06\u5ba1\u6838\u8c03\u6574\u8bb0\u5f55\u6e05\u9664\uff0c\u662f\u5426\u53cd\u5ba1\u6838\uff1f", (String)"ReportPreparationListPlugin_58", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(UN_AUDIT_CLOSE_KEY, pluginName));
    }

    public void batchUnAuditBills(IFormView view, Object returnData, String pluginName, String appId, boolean isLocalApprove) {
        String toUnAuditBillsJson = view.getPageCache().get("toUnAuditBills");
        view.getPageCache().remove("toUnAuditBills");
        MessageBoxResult result = (MessageBoxResult)returnData;
        if (MessageBoxResult.Cancel == result) {
            return;
        }
        List unauditBillIds = (List)SerializationUtils.fromJsonString((String)toUnAuditBillsJson, ArrayList.class);
        if (isLocalApprove) {
            String fields = "id, template.id as tempId, approvebill";
            DynamicObjectCollection processes = QueryServiceHelper.query((String)"eb_reportprocess", (String)fields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)unauditBillIds)});
            ArrayList processIds = new ArrayList(16);
            ArrayList tempIds = new ArrayList(16);
            ArrayList approveBillIds = new ArrayList(16);
            processes.forEach(e -> {
                processIds.add(e.getLong("id"));
                tempIds.add(e.getLong("tempId"));
                approveBillIds.add(e.getLong("approvebill"));
            });
            ApproveBillServiceHelper.unauditReportsForLocal(new HashSet(processIds));
        } else {
            int[] selectRows;
            HashSet<Long> reportIds = new HashSet<Long>(16);
            EntryGrid control = (EntryGrid)view.getControl("billlist_entity");
            for (int selectRow : selectRows = control.getSelectRows()) {
                DynamicObject entryRowEntity = view.getModel().getEntryRowEntity("billlist_entity", selectRow);
                Long reportId = entryRowEntity.getLong("process.id");
                reportIds.add(reportId);
            }
            ApproveBillServiceHelper.unauditReportsForWF(new HashSet(unauditBillIds), reportIds);
        }
        view.showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u6210\u529f", (String)"ApproveOptimization_30", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private void updateProcessStatusByRptReadOnlyTemplate(Set<Long> processIds) {
        if (CollectionUtils.isEmpty(processIds)) {
            return;
        }
        QFilter qFilter = new QFilter("id", "in", processIds);
        DynamicObjectCollection reportProcessList = QueryServiceHelper.query((String)"eb_reportprocess", (String)"id,template.isreadonly,template.rptreadonly", (QFilter[])new QFilter[]{qFilter});
        HashSet<Long> filterReportProcessSet = new HashSet<Long>(16);
        if (CollectionUtils.isNotEmpty((Collection)reportProcessList)) {
            for (DynamicObject reportProcess : reportProcessList) {
                if (reportProcess.getBoolean("template.isreadonly") || !reportProcess.getBoolean("template.rptreadonly")) continue;
                filterReportProcessSet.add(reportProcess.getLong("id"));
            }
            if (CollectionUtils.isNotEmpty(filterReportProcessSet)) {
                SqlBuilder sqlBuilder1 = new SqlBuilder();
                sqlBuilder1.append("update t_eb_reportprocess set fstatus = '0' where ", new Object[0]);
                sqlBuilder1.appendIn("fid", filterReportProcessSet.toArray());
                DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder1);
            }
        }
    }

    public void openRejectPage(IFormView view, String pluginName, Long approveBillId, Long modelId, Collection<Long> selectProcessIds) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_approveopconfirm");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> customMap = new HashMap<String, Object>(16);
        IFormView parentView = view.getParentView();
        boolean fromAuditPage = this.isFromAuditPage(parentView);
        if (fromAuditPage) {
            IDataModel model = parentView.getModel();
            customMap.put("decision", model.getValue("combo_decision"));
            customMap.put("approveMessage", model.getValue("msg_approval"));
            String nodeValue = model.getValue("textfield_nextnodevalue").toString();
            String[] split = nodeValue.split("_and_");
            if (split.length >= 2) {
                String userStr = split[0].trim().replaceAll("\u3001", "_");
                String nodeId = split[1];
                if (StringUtils.isNotEmpty((String)userStr)) {
                    nodeId = nodeId + "#" + userStr.substring(0, userStr.length() - 1);
                }
                customMap.put("rejectNode", nodeId);
            }
            customMap.put("isFromAuditPage", "true");
            customMap.put("selectProcessIds", SerializationUtils.toJsonString(selectProcessIds));
        }
        customMap.put("relateApproveBills", SerializationUtils.toJsonString(Collections.singletonList(approveBillId)));
        customMap.put("defaultAlternative", ApproveDecisionEnum.REJECT_TASK.getIndex());
        ArrayList<String> invisibleObjects = new ArrayList<String>(16);
        HashMap alterRelateInvisibleMap = new HashMap(16);
        ArrayList<String> opinionObjects = new ArrayList<String>(16);
        ArrayList<String> reportObjects = new ArrayList<String>(16);
        invisibleObjects.add("approve");
        invisibleObjects.add("localreject");
        if (fromAuditPage) {
            invisibleObjects.add("opinionpanel");
            invisibleObjects.add("auditpasspanel");
            invisibleObjects.add("flexpanelap");
            invisibleObjects.add("rejectonreport");
            StyleCss styleCss = new StyleCss();
            styleCss.setHeight("490px");
            formShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
            opinionObjects.add("rejectnode");
        }
        opinionObjects.add("status");
        opinionObjects.add("tip");
        reportObjects.add(REJECT_CLOSE_KEY);
        reportObjects.add("mustreject");
        alterRelateInvisibleMap.put(ApproveDecisionEnum.REJECT_TASK.getIndex(), opinionObjects);
        alterRelateInvisibleMap.put(ApproveDecisionEnum.REJECT_REPORT.getIndex(), reportObjects);
        customMap.put("invisible_object", SerializationUtils.toJsonString(invisibleObjects));
        customMap.put("alterRelateInvisible", SerializationUtils.toJsonString(alterRelateInvisibleMap));
        customMap.put("modelId", modelId);
        formShowParameter.setCustomParams(customMap);
        formShowParameter.setCloseCallBack(new CloseCallBack(pluginName, REJECT_CLOSE_KEY));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u5f55\u5165\u9a73\u56de\u4fe1\u606f", (String)"ApproveOptimization_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        view.showForm(formShowParameter);
    }

    private boolean isFromAuditPage(IFormView view) {
        if (view == null) {
            return false;
        }
        String formId = view.getFormShowParameter().getFormId();
        return "wf_approvalpage_bac".equals(formId) || "wf_pcprocesspagetpl_epm".equals(formId);
    }

    public boolean needRejectClose(Object returnData) {
        if (returnData == null || StringUtils.isEmpty((String)returnData.toString())) {
            return false;
        }
        return "rejectAndClosePage".equals(returnData.toString());
    }

    public Long getApproveId(IFormView view) {
        Long taskApproveBill = ApproveBillHelper.getAppBillIdFromPage((IFormView)view);
        if (taskApproveBill == 0L) {
            String process = view.getPageCache().get("current_report_id");
            return ApproveUtils.getInstance().getProcessRefMainApproveBillId(ConvertUtils.toLong((Object)process));
        }
        return taskApproveBill;
    }

    public void openSingleRejectPage(IFormView view, String pluginName, Long approveBillId, Long modelId, Collection<Long> selectProcessIds) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_approveopconfirm");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> customMap = new HashMap<String, Object>(16);
        IFormView parentView = view.getParentView();
        boolean fromAuditPage = this.isFromAuditPage(parentView);
        if (fromAuditPage) {
            customMap.put("selectProcessIds", SerializationUtils.toJsonString(selectProcessIds));
        }
        customMap.put("relateApproveBills", SerializationUtils.toJsonString(Collections.singletonList(approveBillId)));
        customMap.put("defaultAlternative", ApproveDecisionEnum.REJECT_REPORT.getIndex());
        ArrayList<String> invisibleObjects = new ArrayList<String>(16);
        HashMap alterRelateInvisibleMap = new HashMap(16);
        ArrayList<String> reportObjects = new ArrayList<String>(16);
        invisibleObjects.add("approve");
        invisibleObjects.add("localreject");
        invisibleObjects.add("auditpasspanel");
        invisibleObjects.add("alternative_panel");
        reportObjects.add(REJECT_CLOSE_KEY);
        reportObjects.add("mustreject");
        alterRelateInvisibleMap.put(ApproveDecisionEnum.REJECT_REPORT.getIndex(), reportObjects);
        customMap.put("invisible_object", SerializationUtils.toJsonString(invisibleObjects));
        customMap.put("alterRelateInvisible", SerializationUtils.toJsonString(alterRelateInvisibleMap));
        customMap.put("modelId", modelId);
        formShowParameter.setCustomParams(customMap);
        formShowParameter.setCloseCallBack(new CloseCallBack(pluginName, REJECT_CLOSE_KEY));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u9a73\u56de\u90e8\u5206\u62a5\u8868", (String)"ApproveOptimization_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        view.showForm(formShowParameter);
    }

    public boolean checkSelectRowType(IFormView view, boolean isList) {
        Map<Long, Long> selectedReportProcessIdSet;
        String formId = view.getFormShowParameter().getFormId();
        if (StringUtils.isEmpty((String)formId)) {
            return false;
        }
        if (isList) {
            selectedReportProcessIdSet = this.getSelectedReportProcessIdSet(view);
        } else {
            IPageCache pageCache = view.getPageCache();
            if (pageCache == null) {
                return false;
            }
            Long processId = ConvertUtils.toLong((Object)pageCache.get("current_report_id"));
            if (processId == 0L) {
                return false;
            }
            Long approveId = ApproveOptimization.getInstance().getApproveId(view);
            selectedReportProcessIdSet = new HashMap<Long, Long>(16);
            selectedReportProcessIdSet.put(processId, approveId);
        }
        if (selectedReportProcessIdSet.size() == 0) {
            return false;
        }
        ApproveUtils instance = ApproveUtils.getInstance();
        HashSet<Long> approveBills = new HashSet<Long>(selectedReportProcessIdSet.values());
        boolean isNotRelateApprove = approveBills.size() == 1 && approveBills.contains(0L);
        approveBills.remove(0L);
        HashSet<Long> processIds = new HashSet<Long>(selectedReportProcessIdSet.keySet());
        if (isNotRelateApprove) {
            Set notAllDealProcesses = instance.getNotAllDealProcesses(processIds, approveBills);
            if (notAllDealProcesses.size() != 0) {
                StringBuilder sb = new StringBuilder();
                sb.append(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u5f53\u524d\u5355\u636e\u5b58\u5728\u5982\u4e0b\u672a\u5904\u7406\u5b8c\u6210\u7684\u9a73\u56de\u62a5\u8868:", (String)"ApproveOptimization_33", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\r\n").append(String.join((CharSequence)"\r\n", notAllDealProcesses));
                view.showTipNotification(sb.toString());
                return true;
            }
            Set rejectOnReports = RejectOnReportService.getInstance().getRejectOnReports(processIds);
            if (rejectOnReports.containsAll(processIds)) {
                RejectOnReportService.getInstance().createAndSubmitBills(processIds);
                view.showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"ApproveOptimization_35", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (rejectOnReports.isEmpty()) {
                return false;
            }
            Set rejectReportNames = RejectOnReportService.getInstance().getRejectReportNames(rejectOnReports);
            StringBuilder sb = new StringBuilder();
            sb.append(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u4ee5\u4e0b\u62a5\u8868\u5173\u8054\u7684\u5ba1\u6279\u5355\u4ecd\u5728\u6d41\u7a0b\u4e2d:", (String)"ApproveOptimization_40", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\r\n").append(String.join((CharSequence)"\r\n", rejectReportNames));
            view.showTipNotification(sb.toString());
            return true;
        }
        QFilter qFilter = new QFilter("id", "in", processIds);
        DynamicObjectCollection reportList = QueryServiceHelper.query((String)"eb_reportprocess", (String)"id,status", (QFilter[])qFilter.toArray());
        for (DynamicObject report : reportList) {
            String reportStatus = report.getString("status");
            if (!BgTaskStateEnum.UNDERWAY.getNumber().equals(reportStatus)) continue;
            return false;
        }
        HashSet inRejectProcessIds = new HashSet(16);
        instance.getInRejectApproveBills(approveBills, inRejectProcessIds);
        if (!inRejectProcessIds.containsAll(processIds)) {
            return false;
        }
        HashSet<Long> unableToSubmitProcessIds = new HashSet<Long>(16);
        for (Map.Entry entry : selectedReportProcessIdSet.entrySet()) {
            Long approveBillId = (Long)entry.getValue();
            Long processId = (Long)entry.getKey();
            RejectStatus processRejectStatus = instance.getProcessRejectStatus(processId, approveBillId);
            if (processRejectStatus.isSubmitNode() || processRejectStatus.isRejectOnReport() && processRejectStatus.isReportCurDeal()) continue;
            unableToSubmitProcessIds.add(processId);
        }
        Set tempNames = instance.getTempNameNumberByProcessIds(unableToSubmitProcessIds, true);
        if (tempNames.size() != 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f %s \u62a5\u8868\u7684\u5904\u7406\u4eba\uff0c\u4e0d\u80fd\u5904\u7406", (String)"ApproveOptimization_34", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)"\u3001", tempNames)}));
            return true;
        }
        Long l = IDUtils.toLong((Object)view.getPageCache().get("modelid"));
        boolean isMatchNewWorkFlow = RejectOnReportService.getInstance().isMatchNewWorkFlow(l);
        if (isMatchNewWorkFlow) {
            RejectOnReportService.getInstance().createRejectBill(approveBills, processIds, "submit");
        } else {
            HashSet<Long> bills = new HashSet<Long>(selectedReportProcessIdSet.values());
            RejectOnReportService.getInstance().updateRejectStatus2FinishWithMsg(bills, processIds);
            Map billRptMap = RejectOnReportService.getInstance().getSrcBillRptIds(bills, processIds);
            if (billRptMap != null && !billRptMap.isEmpty()) {
                billRptMap.values().stream().forEach(rptIds -> processIds.addAll((Collection<Long>)rptIds));
            }
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("update t_eb_reportprocess set fstatus = ? ", new Object[]{BgTaskStateEnum.UNDERWAY.getNumber()});
            sqlBuilder.append(" where ", new Object[0]);
            sqlBuilder.appendIn("fid", processIds.toArray());
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
            UpgradesTaskUtil.getInstance().clearDataEntityCache("eb_reportprocess");
        }
        view.showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"ApproveOptimization_35", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        return true;
    }

    public Map<Long, Long> getSelectedReportProcessIdSet(IFormView view) {
        HashMap<Long, Long> result = new HashMap<Long, Long>(16);
        EntryGrid control = (EntryGrid)view.getControl("billlist_entity");
        int[] selectRows = control.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            return result;
        }
        HashSet<Long> processIds = new HashSet<Long>(16);
        for (int selectRow : selectRows) {
            long reportProcessId;
            DynamicObject entryRowEntity = view.getModel().getEntryRowEntity("billlist_entity", selectRow);
            if (entryRowEntity == null || IDUtils.isEmptyLong((Long)(reportProcessId = entryRowEntity.getLong("process.id"))).booleanValue()) continue;
            processIds.add(reportProcessId);
        }
        return ApproveUtils.getInstance().getProcessRefMainApproveBillIds(processIds);
    }

    public void openBatchSetPage(IFormView view, String pluginName, String invisibleKeys, Long modelId, String entryKey) {
        EntryGrid entryGrid = (EntryGrid)view.getControl(entryKey);
        int[] rows = entryGrid.getSelectRows();
        if (rows.length == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6279\u91cf\u586b\u5199\u7684\u884c\u3002", (String)"ApproveOptimization_36", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_batchsetopinion");
        formShowParameter.setCustomParam("invisible", (Object)invisibleKeys);
        formShowParameter.setCustomParam("modelId", (Object)modelId);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack(pluginName, "batchSet"));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6279\u91cf\u586b\u5199", (String)"ApproveOptimization_39", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        view.showForm(formShowParameter);
    }

    public String[] getWFRefBtnKeys() {
        return new String[]{"btn_circulation", "btn_circulationrecord", "btn_allowaddsign", "btn_transfer", "btn_coordinate", "btn_coortransfer"};
    }

    public void setWfRefBtnVisible(IFormView view) {
        this.setWfRefBtnVisible(view, view);
    }

    public void setWfRefBtnVisible(IFormView checkView, IFormView curView) {
        String[] wfRefBtnKeys = this.getWFRefBtnKeys();
        if (checkView == null) {
            curView.setVisible(Boolean.valueOf(false), wfRefBtnKeys);
            return;
        }
        Object scene = checkView.getFormShowParameter().getCustomParam("SCENE");
        if (scene == null || !"AUDITFLOW".equals(scene.toString())) {
            curView.setVisible(Boolean.valueOf(false), wfRefBtnKeys);
            return;
        }
        IFormView parentView = checkView.getParentView();
        if (parentView == null) {
            curView.setVisible(Boolean.valueOf(false), wfRefBtnKeys);
            return;
        }
        IPageCache pageCache = parentView.getPageCache();
        if (pageCache == null) {
            curView.setVisible(Boolean.valueOf(false), wfRefBtnKeys);
            return;
        }
        ArrayList<String> visibleKeys = new ArrayList<String>(16);
        ArrayList<String> invisibleKeys = new ArrayList<String>(16);
        for (String wfRefBtnKey : wfRefBtnKeys) {
            if ("btn_coortransfer".equals(wfRefBtnKey)) {
                if (this.checkCacheExist(this.getRelateCacheKey("btn_coordinate"), pageCache) && this.checkCacheExist(this.getRelateCacheKey("btn_transfer"), pageCache)) {
                    visibleKeys.add(wfRefBtnKey);
                    continue;
                }
                invisibleKeys.add(wfRefBtnKey);
                continue;
            }
            String relateCacheKey = this.getRelateCacheKey(wfRefBtnKey);
            if (this.checkCacheExist(relateCacheKey, pageCache)) {
                visibleKeys.add(wfRefBtnKey);
                continue;
            }
            invisibleKeys.add(wfRefBtnKey);
        }
        if (visibleKeys.size() != 0) {
            curView.setVisible(Boolean.valueOf(true), visibleKeys.toArray(new String[0]));
        }
        if (invisibleKeys.size() != 0) {
            curView.setVisible(Boolean.valueOf(false), invisibleKeys.toArray(new String[0]));
        }
    }

    private String getRelateCacheKey(String wfRefBtnKey) {
        String relateCacheKey = "";
        if (StringUtils.isEmpty((String)wfRefBtnKey)) {
            return relateCacheKey;
        }
        switch (wfRefBtnKey) {
            case "btn_circulation": 
            case "btn_circulationrecord": {
                relateCacheKey = "btncirculation";
                break;
            }
            case "btn_allowaddsign": {
                relateCacheKey = "allowaddsign";
                break;
            }
            case "btn_transfer": {
                relateCacheKey = "btntransfer";
                break;
            }
            case "btn_coordinate": {
                relateCacheKey = "btncoordinate";
                break;
            }
        }
        return relateCacheKey;
    }

    private boolean checkCacheExist(String relateCacheKey, IPageCache pageCache) {
        if (pageCache == null || StringUtils.isEmpty((String)relateCacheKey)) {
            return false;
        }
        String relateCacheValue = pageCache.get(relateCacheKey);
        return Convert.toBool((Object)relateCacheValue, (Boolean)false);
    }

    public void openExportPageFromList(IFormView view, CloseCallBack closeCallBack, Long approveBillId, Long modelId) {
        this.openExportPageFromList(view, closeCallBack, approveBillId, null, modelId);
    }

    public void openExportPageFromList(IFormView view, CloseCallBack closeCallBack, Long approveBillId, List<Long> processIds, Long modelId) {
        String selectFields = "eborgid, dim_datatype, dim_period, dim_version, orgviewid, source, rptprocesstype, entryentity.taskprocessid, entryentity.tempid";
        DynamicObject approveBill = BusinessDataServiceHelper.loadSingle((Object)approveBillId, (String)"eb_approvebill", (String)selectFields);
        if (approveBill == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"ApproveOptimization_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean isTaskList = "1".equals(approveBill.getString("rptprocesstype"));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bgm_addexportreport");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u5bfc\u51fa\u62a5\u8868\u9009\u62e9", (String)"ReportPreparationListPlugin_excel_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        long yearId = approveBill.getLong("dim_period.id");
        long dataTypeId = approveBill.getLong("dim_datatype.id");
        long versionId = approveBill.getLong("dim_version.id");
        long schemeId = approveBill.getLong("source_id");
        formShowParameter.setCustomParam("model", (Object)modelId);
        formShowParameter.setCustomParam("sourceType", (Object)(isTaskList ? "eb_tasklist" : "eb_rptscheme"));
        formShowParameter.setCustomParam("pageType", (Object)"export");
        formShowParameter.setCustomParam("period", (Object)yearId);
        formShowParameter.setCustomParam("dataType", (Object)dataTypeId);
        formShowParameter.setCustomParam("version", (Object)versionId);
        formShowParameter.setCustomParam("orgViewId", (Object)approveBill.getLong("orgviewid.id"));
        formShowParameter.setCustomParam("processtype", (Object)SerializationUtils.serializeToBase64((Object)ProcessTypeEnum.REPORT));
        formShowParameter.setCustomParam("processId", (Object)0L);
        formShowParameter.setCustomParam("reportProcessId", (Object)0L);
        DynamicObjectCollection entryEntity = approveBill.getDynamicObjectCollection("entryentity");
        ArrayList templateEntityDtos = new ArrayList(16);
        ArrayList templates = new ArrayList(16);
        Long _entity = approveBill.getLong("eborgid.id");
        entryEntity.forEach(e -> {
            long templateId = e.getLong("tempid.id");
            templates.add(templateId);
            templateEntityDtos.add(new TemplateEntityDto(Long.valueOf(templateId), _entity));
        });
        ArrayList<BaseRptProcessRequest> queryRptProcessRequests = new ArrayList<BaseRptProcessRequest>(16);
        queryRptProcessRequests.add(new BaseRptProcessRequest(modelId, Long.valueOf(approveBill.getLong("orgviewid.id")), Long.valueOf(yearId), Long.valueOf(dataTypeId), Long.valueOf(versionId), templateEntityDtos));
        ReportProcessAggService instance = ReportProcessAggService.getInstance();
        List reportProcessList = instance.getReportProcessList(queryRptProcessRequests);
        if (isTaskList) {
            LinkedHashMap<Long, Long> taskProcessIdMap = new LinkedHashMap<Long, Long>(16);
            Map reportProcessMap = instance.convertReportProcessListToCombinationMap(reportProcessList);
            QFilter qFilter = new QFilter("org", "=", (Object)_entity);
            qFilter.and("template", "in", templates);
            qFilter.and("task.tasklist.year", "=", (Object)yearId);
            qFilter.and("task.tasklist.version", "=", (Object)versionId);
            qFilter.and("task.tasklist.datatype", "=", (Object)dataTypeId);
            qFilter.and("task.tasklist", "=", (Object)schemeId);
            DynamicObjectCollection taskProcesses = QueryServiceHelper.query((String)"eb_taskprocess", (String)"id, template", (QFilter[])qFilter.toArray());
            taskProcesses.sort((o1, o2) -> {
                int index1 = templates.indexOf(o1.getLong("template"));
                int index2 = templates.indexOf(o2.getLong("template"));
                if (index1 == -1) {
                    index1 = Integer.MAX_VALUE;
                }
                if (index2 == -1) {
                    index2 = Integer.MAX_VALUE;
                }
                return Integer.compare(index1, index2);
            });
            for (DynamicObject taskProcess : taskProcesses) {
                Long taskProcessId = taskProcess.getLong("id");
                Long templateId = taskProcess.getLong("template");
                ReportProcess reportProcessKey = ReportProcess.buildReportProcessCombination((Long)modelId, (Long)templateId, (Long)_entity, (Long)yearId, (Long)dataTypeId, (Long)versionId);
                ReportProcess reportProcess = (ReportProcess)reportProcessMap.get(reportProcessKey);
                if (reportProcess == null) continue;
                taskProcessIdMap.put(reportProcess.getId(), taskProcessId);
            }
            formShowParameter.setCustomParam("taskProcessIdMap", (Object)SerializationUtils.serializeToBase64(taskProcessIdMap));
            formShowParameter.setCustomParam("processtype", (Object)SerializationUtils.serializeToBase64((Object)ProcessTypeEnum.TASK));
            if (taskProcessIdMap.size() != 0) {
                formShowParameter.setCustomParam("processId", taskProcessIdMap.entrySet().iterator().next().getValue());
            }
        } else {
            QFilter qFilter = new QFilter("scheme", "=", (Object)schemeId);
            qFilter.and("year", "=", (Object)yearId);
            qFilter.and("version", "=", (Object)versionId);
            qFilter.and("datatype", "=", (Object)dataTypeId);
            DynamicObject assign = QueryServiceHelper.queryOne((String)"eb_schemeassign", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (assign != null) {
                formShowParameter.setCustomParam("processId", (Object)assign.getLong("id"));
            }
        }
        reportProcessList.sort((o1, o2) -> {
            int index1 = templates.indexOf(o1.getTemplateId());
            int index2 = templates.indexOf(o2.getTemplateId());
            if (index1 == -1) {
                index1 = Integer.MAX_VALUE;
            }
            if (index2 == -1) {
                index2 = Integer.MAX_VALUE;
            }
            return Integer.compare(index1, index2);
        });
        List reportProcessIds = reportProcessList.stream().map(ReportProcess::getId).collect(Collectors.toList());
        formShowParameter.setCustomParam("allReportProcessId", (Object)SerializationUtils.toJsonString(reportProcessIds));
        if (processIds == null) {
            formShowParameter.setCustomParam("reportProcessIdSet", (Object)SerializationUtils.toJsonString(reportProcessIds));
        } else {
            formShowParameter.setCustomParam("reportProcessIdSet", (Object)SerializationUtils.toJsonString(processIds));
        }
        formShowParameter.setCustomParam("exportType", (Object)ReportExportTypeEnum.EXPORT_DATA);
        formShowParameter.setCustomParam("schemeId", (Object)schemeId);
        List centralDimRange = ApproveUtils.getInstance().getCentralDimRange(approveBillId);
        if (CollectionUtils.isNotEmpty((Collection)centralDimRange)) {
            formShowParameter.setCustomParam("filterInfo", (Object)ObjectSerialUtil.toByteSerialized((Object)centralDimRange));
        }
        if (closeCallBack != null) {
            formShowParameter.setCloseCallBack(closeCallBack);
        }
        view.showForm(formShowParameter);
    }

    public void handleCloseCallback(IFormView formView, Long modelId, Object returnData) {
        if (returnData == null) {
            return;
        }
        Map returnDataMap = (Map)returnData;
        String success = (String)returnDataMap.get("success");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)success)) {
            ApproveOptimization.getInstance().openDownloadPage(formView, modelId);
        }
    }
}

