/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.approveBill;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.pojo.BasedataPojo;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class BatchCancelConfirmPlugin
extends AbstractFormPlugin {
    private Boolean needHideButtons;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_confirm"});
    }

    public void afterCreateNewData(EventObject e) {
        this.initCancelDetails();
        if (this.needHideButtons()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap1"});
        }
        this.setDefinedLabelText();
    }

    private void initCancelDetails() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object relateApproveBillsJson = customParams.get("relateApproveBills");
        List relateApproveBills = new ArrayList(16);
        if (relateApproveBillsJson != null) {
            relateApproveBills = (List)SerializationUtils.fromJsonString((String)relateApproveBillsJson.toString(), ArrayList.class);
        }
        Boolean containLocalApprove = Convert.toBool(customParams.get("containLocalApprove"), (Boolean)false);
        HashSet templates = new HashSet(16);
        HashMap refInfoMap = new HashMap(16);
        String fields = "id, entryentity.tempid.id as tempId, billno, eborgid.name, dim_datatype.name, dim_period.name, dim_version.name";
        DynamicObjectCollection approveBills = QueryServiceHelper.query((String)"eb_approvebill", (String)fields, (QFilter[])new QFilter[]{new QFilter("id", "in", relateApproveBills)});
        HashMap approveBillInfos = new HashMap(16);
        HashMap billNoMap = new HashMap(16);
        approveBills.forEach(e -> {
            long billId = e.getLong("id");
            List relateTempNames = approveBillInfos.computeIfAbsent(billId, k -> new ArrayList(16));
            long tempId = e.getLong("tempId");
            relateTempNames.add(tempId);
            templates.add(tempId);
            billNoMap.put(billId, e.getString("billno"));
            if (!refInfoMap.containsKey(billId)) {
                String[] refInfo = new String[4];
                refInfoMap.put(billId, refInfo);
                refInfo[0] = e.getString("eborgid.name");
                refInfo[1] = e.getString("dim_period.name");
                refInfo[2] = e.getString("dim_version.name");
                refInfo[3] = e.getString("dim_datatype.name");
            }
        });
        HashMap reportProcessTemplateMap = new HashMap(16);
        if (containLocalApprove.booleanValue()) {
            fields = "id, template, entity.name, period.name, version.name, datatype.name";
            DynamicObjectCollection reportProcesses = QueryServiceHelper.query((String)"eb_reportprocess", (String)fields, (QFilter[])new QFilter[]{new QFilter("id", "in", relateApproveBills)});
            reportProcesses.forEach(e -> {
                long template = e.getLong("template");
                long processId = e.getLong("id");
                reportProcessTemplateMap.put(processId, template);
                templates.add(template);
                String[] refInfo = refInfoMap.computeIfAbsent(processId, k -> new String[4]);
                refInfo[0] = e.getString("entity.name");
                refInfo[1] = e.getString("period.name");
                refInfo[2] = e.getString("version.name");
                refInfo[3] = e.getString("datatype.name");
            });
        }
        HashMap templateInfoMap = new HashMap(16);
        DynamicObjectCollection templateInfos = QueryServiceHelper.query((String)"eb_templateentity", (String)"id, name, number", (QFilter[])new QFilter[]{new QFilter("id", "in", templates)});
        templateInfos.forEach(e -> {
            long templateId = e.getLong("id");
            templateInfoMap.put(templateId, new BasedataPojo(Long.valueOf(templateId), e.getString("name"), e.getString("number")));
        });
        HashSet<Long> hasShowBills = new HashSet<Long>(16);
        for (Long relateApproveBill : relateApproveBills) {
            if (hasShowBills.contains(relateApproveBill)) continue;
            List<Long> relateTemplates = (List<Long>)approveBillInfos.get(relateApproveBill);
            String billNo = ResManager.loadKDString((String)"\u672c\u5730\u5ba1\u6838", (String)"", (String)"", (Object[])new Object[0]);
            if (relateTemplates == null) {
                Long relateTemplate = (Long)reportProcessTemplateMap.get(relateApproveBill);
                if (relateTemplate == null) continue;
                relateTemplates = Collections.singletonList(relateTemplate);
            } else {
                billNo = ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u5ba1\u6838-\u5ba1\u6838\u5355\u636e\uff1a%s", (String)"", (String)"", (Object[])new Object[]{billNoMap.get(relateApproveBill)});
            }
            String[] refInfos = (String[])refInfoMap.get(relateApproveBill);
            for (Long relateTemplate : relateTemplates) {
                int newEntryRow = this.getModel().createNewEntryRow("entryentity");
                BasedataPojo basedataPojo = (BasedataPojo)templateInfoMap.get(relateTemplate);
                this.getModel().setValue("reportnumber", (Object)basedataPojo.getNumber(), newEntryRow);
                this.getModel().setValue("reportname", (Object)basedataPojo.getName(), newEntryRow);
                this.getModel().setValue("audittype", (Object)billNo, newEntryRow);
                this.getModel().setValue("org", (Object)refInfos[0], newEntryRow);
                this.getModel().setValue("period", (Object)refInfos[1], newEntryRow);
                this.getModel().setValue("version", (Object)refInfos[2], newEntryRow);
                this.getModel().setValue("datatype", (Object)refInfos[3], newEntryRow);
            }
            hasShowBills.add(relateApproveBill);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (!"btn_confirm".equals(key)) {
            return;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object relateApproveBills = customParams.get("relateApproveBills");
        HashMap retData = new HashMap(16);
        retData.put("relateApproveBills", relateApproveBills);
        retData.put("containLocalApprove", customParams.get("containLocalApprove"));
        retData.put("current_org", customParams.get("current_org"));
        this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(retData));
        this.getView().close();
    }

    private boolean needHideButtons() {
        if (this.needHideButtons == null) {
            Object hideButtons = this.getView().getFormShowParameter().getCustomParam("hideButtons");
            this.needHideButtons = Convert.toBool((Object)hideButtons, (Boolean)false);
        }
        return this.needHideButtons;
    }

    private void setDefinedLabelText() {
        String definedLabelText = (String)this.getView().getFormShowParameter().getCustomParam("definedLabelText");
        if (StringUtils.isEmpty((String)definedLabelText)) {
            return;
        }
        Label label = (Label)this.getControl("labelap");
        label.setText(definedLabelText);
    }
}

