/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.approveBill;

import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.approveBill.ApproveBillCommon;
import kd.epm.eb.common.approveBill.Entity.ApproveBillRptTemp;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitDim;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitInfo;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.ebSpread.common.util.StringUtil;
import kd.epm.eb.formplugin.approveBill.CommitCommandBGMTask;
import kd.epm.eb.formplugin.reportscheme.command.IReportBySchemePlugin;
import kd.epm.eb.spread.template.ITemplateModel;

public class CommitCommandBGMReport
extends CommitCommandBGMTask {
    public CommitCommandBGMReport(String key) {
        super(key);
    }

    @Override
    protected int getProcessType() {
        return ProcessTypeEnum.REPORT.getIndex();
    }

    @Override
    protected String getFormEntity() {
        return "billlist_entity";
    }

    @Override
    protected ITemplateModel getTemplateModel() {
        return ((IReportBySchemePlugin)this.formPlugin).getReportProcessPlugin().getTemplateModel();
    }

    @Override
    protected boolean isClosed(Collection<ApproveBillRptTemp> rptTemps) {
        return false;
    }

    @Override
    protected String getCommitBTNName() {
        return "btn_batchcommit";
    }

    @Override
    protected ApproveBillSubMitInfo getApproveBillParams(String key, Collection<ApproveBillRptTemp> rptTemps) {
        ApproveBillSubMitInfo bgmBill = new ApproveBillSubMitInfo();
        bgmBill.setBtnKey(key);
        bgmBill.setRptProcessType(this.getProcessType());
        bgmBill.setRptTemps(rptTemps);
        ApproveBillSubMitDim submitDims = new ApproveBillSubMitDim();
        bgmBill.setSubmitDims(submitDims);
        submitDims.setTempIds(ApproveBillCommon.getTempIds(rptTemps));
        submitDims.setModelId(this.formPlugin.getModelId());
        submitDims.setOrgId(rptTemps.iterator().next().getOrgId());
        this.getPeiodVersionDataTypeInfo(bgmBill);
        submitDims.setCommitType("1");
        if (submitDims.getViewId() == null) {
            Long viewId = IDUtils.toLong((Object)this.pageCache.get("CURRENT_ORG_VIEW"));
            submitDims.setViewId(viewId);
        }
        return bgmBill;
    }

    @Override
    protected void getPeiodVersionDataTypeInfo(ApproveBillSubMitInfo bgmBill) {
        if (bgmBill.getBtnKey().equalsIgnoreCase(this.getCommitBTNName()) || bgmBill.getBtnKey().equalsIgnoreCase("examinecheck_inlist")) {
            this.getPeiodVersionDataTypeInfoBatch(bgmBill);
        } else {
            this.getPeiodVersionDataTypeInfoSingle(bgmBill);
        }
        this.getBizModelId(bgmBill);
    }

    protected void getPeiodVersionDataTypeInfoSingle(ApproveBillSubMitInfo bgmBill) {
        Long dataTypeId = IDUtils.toLong((Object)this.pageCache.get("CURRENT_DATATYPE"));
        Long periodId = IDUtils.toLong((Object)this.pageCache.get("CURRENT_PERIOD"));
        Long versionId = IDUtils.toLong((Object)this.pageCache.get("CURRENT_VERSION"));
        bgmBill.getSubmitDims().setDataTypeId(dataTypeId);
        bgmBill.getSubmitDims().setVersionId(versionId);
        bgmBill.getSubmitDims().setYearPeriodId(periodId);
        String dataTypeNumber = this.pageCache.get("CURRENT_DATATYPE_NUMBER");
        String periodNumber = this.pageCache.get("CURRENT_PERIOD_NUMBER");
        String versionNumber = this.pageCache.get("CURRENT_VERSION_NUMBER");
        bgmBill.getSubmitDims().setDataTypeNumber(dataTypeNumber);
        bgmBill.getSubmitDims().setVersionNumber(versionNumber);
        bgmBill.getSubmitDims().setYearPeriodNumber(periodNumber);
    }

    protected void getPeiodVersionDataTypeInfoBatch(ApproveBillSubMitInfo bgmBill) {
        String entryName = this.getFormEntity();
        EntryGrid reportLs = (EntryGrid)this.formView.getControl(entryName);
        int[] selectRows = reportLs.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            this.formView.showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62a5\u8868\u3002", (String)"CommitCommandCommon_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        bgmBill.getSubmitDims().setDataTypeId(Long.valueOf(((DynamicObject)this.formView.getModel().getValue("datatype", 0)).getLong("id")));
        bgmBill.getSubmitDims().setDataTypeNumber(((DynamicObject)this.formView.getModel().getValue("datatype", 0)).getString("number"));
        bgmBill.getSubmitDims().setVersionId(Long.valueOf(((DynamicObject)this.formView.getModel().getValue("version", 0)).getLong("id")));
        bgmBill.getSubmitDims().setVersionNumber(((DynamicObject)this.formView.getModel().getValue("version", 0)).getString("number"));
        bgmBill.getSubmitDims().setYearPeriodId(Long.valueOf(((DynamicObject)this.formView.getModel().getValue("year", 0)).getLong("id")));
        bgmBill.getSubmitDims().setYearPeriodNumber(((DynamicObject)this.formView.getModel().getValue("year", 0)).getString("number"));
        DynamicObject schemecondition = (DynamicObject)this.formView.getModel().getValue("schemecondition");
        long id = 0L;
        if (schemecondition != null) {
            id = schemecondition.getLong("orgview.id");
        }
        bgmBill.getSubmitDims().setViewId(Long.valueOf(id));
    }

    @Override
    protected void setOtherParamFromViewSingle(ApproveBillRptTemp rptTemp) {
        rptTemp.setRptId(IDUtils.toLong((Object)this.pageCache.get("current_report_id")));
        rptTemp.setOrgId(IDUtils.toLong((Object)this.pageCache.get("current_org")));
        String childBillIdStr = this.pageCache.get("childBillId");
        if (!StringUtil.isEmptyString((String)childBillIdStr)) {
            rptTemp.setApproveBillId(IDUtils.toLong((Object)childBillIdStr));
        }
    }

    @Override
    protected ApproveBillRptTemp batchGetTempInfo(Integer row, IFormView formView) {
        ApproveBillRptTemp returns = new ApproveBillRptTemp();
        DynamicObject entryRowEntity = formView.getModel().getEntryRowEntity(this.getFormEntity(), row.intValue());
        String reportName = (String)formView.getModel().getValue("reportname", row.intValue());
        DynamicObject process = entryRowEntity.getDynamicObject("process");
        if (process == null || process.getDynamicObject("template") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u5b9e\u4f8b\u4e0d\u5b58\u5728\u3002", (String)"ExportCommand_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        returns.setRptId(Long.valueOf(process.getLong("id")));
        returns.setTempId(Long.valueOf(process.getDynamicObject("template").getLong("id")));
        returns.setTempName(reportName);
        QFilter qFilter = new QFilter("id", "=", (Object)process.getDynamicObject("template").getLong("id"));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_templateentity", (String)"templatetype", (QFilter[])qFilter.toArray());
        returns.setRptType(dynamicObject.getString("templatetype"));
        returns.setTaskListId(Long.valueOf(((DynamicObject)formView.getModel().getValue("schemecondition")).getLong("id")));
        returns.setOrgId(Long.valueOf(process.getDynamicObject("entity").getLong("id")));
        returns.setStatus(process.getString("status"));
        returns.setApproveBillId(Long.valueOf(process.getDynamicObject("approvebill") == null ? 0L : process.getDynamicObject("approvebill").getLong("id")));
        returns.setApproveDesc(entryRowEntity.getString("approvedesc"));
        return returns;
    }

    protected void getBizModelId(ApproveBillSubMitInfo bgmBill) {
        Object schemeObj = this.formView.getModel().getValue("schemecondition");
        if (schemeObj instanceof DynamicObject) {
            DynamicObject scheme = (DynamicObject)schemeObj;
            bgmBill.getSubmitDims().setBizModelId(Long.valueOf(scheme.getLong("bizrange_id")));
        }
    }
}

