/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.approveBill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.reportscheme.service.ReportSchemeTemplateSortService;
import kd.epm.eb.common.approveBill.Entity.ApproveBillRptTemp;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitInfo;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.reportprocess.entity.domain.ReportProcess;
import kd.epm.eb.formplugin.approveBill.CommitCommandBGMReport;
import kd.epm.eb.formplugin.approveBill.ICommitCommandBGMOrg;
import kd.epm.eb.formplugin.reportscheme.ReportPreparationListPlugin;
import kd.epm.eb.formplugin.reportscheme.custom.MyEntryGridControl;
import kd.epm.eb.formplugin.reportscheme.helper.ReportPreparationListHelper;
import kd.epm.eb.formplugin.task.BgTaskExecutePlugin;
import org.apache.commons.collections4.CollectionUtils;

public class CommitCommandBGMReportOrg
extends CommitCommandBGMReport
implements ICommitCommandBGMOrg {
    public CommitCommandBGMReportOrg(String key) {
        super(key);
    }

    @Override
    protected String getCommitBTNName() {
        return "orgcommit";
    }

    @Override
    protected ApproveBillSubMitInfo getApproveBillParams(String key, Collection<ApproveBillRptTemp> rptTemps) {
        ApproveBillSubMitInfo bgmBill = super.getApproveBillParams(key, rptTemps);
        QFilter qf = new QFilter("scheme.id", "=", (Object)this.getSchemeId()).and(new QFilter("year.id", "=", (Object)bgmBill.getSubmitDims().getYearPeriodId()));
        qf.and(new QFilter("datatype.id", "=", (Object)bgmBill.getSubmitDims().getDataTypeId()).and(new QFilter("version.id", "=", (Object)bgmBill.getSubmitDims().getVersionId())));
        DynamicObject taskList = QueryServiceHelper.queryOne((String)"eb_schemeassign", (String)"bizrange.id bizrangid", (QFilter[])qf.toArray());
        bgmBill.getSubmitDims().setBizModelId(taskList == null ? null : Long.valueOf(taskList.getLong("bizrangid")));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)SysDimensionEnum.Entity.getMemberTreemodel(), (String)"number", (QFilter[])new QFilter("id", "=", (Object)bgmBill.getSubmitDims().getOrgId()).toArray());
        bgmBill.getSubmitDims().setOrgNumber(dynamicObject.getString("number"));
        bgmBill.getSubmitDims().setCommitType("2");
        String selectOrg = this.formView.getPageCache().get("select_org");
        bgmBill.getSubmitDims().setSelectOrg(selectOrg);
        return bgmBill;
    }

    @Override
    protected Collection<ApproveBillRptTemp> getBGMSelectedTempRPTFromViewBatch(IFormView formView) {
        if (this.formPlugin instanceof ReportPreparationListPlugin) {
            Map<String, Object> orgMap = this.getSelectNodes();
            if (orgMap == null) {
                return null;
            }
            if ("-1".equals(orgMap.get("id"))) {
                formView.showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u7ec4\u7ec7\u3002", (String)"CommitCommand_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return null;
            }
            ArrayList<String> errorInfo = new ArrayList<String>(16);
            Collection<ApproveBillRptTemp> approveBillRptTemps = this.orgGetTempInfo(formView, errorInfo);
            if (CollectionUtils.isNotEmpty(errorInfo)) {
                String title = ResManager.loadResFormat((String)"\u7ec4\u7ec7\u201c%1\u201d\u63d0\u4ea4\u5931\u8d25\u3002", (String)"CommitCommand_12", (String)"epm-eb-formplugin", (Object[])new Object[]{orgMap.get("text")});
                OperationResult result = new OperationResult();
                for (String msg : errorInfo) {
                    this.addErrInoResult(result, msg);
                }
                this.showOperationResult(title, result, this.pageCache, formView);
                return null;
            }
            return approveBillRptTemps;
        }
        if (this.formPlugin instanceof BgTaskExecutePlugin) {
            // empty if block
        }
        return null;
    }

    protected Map<String, Object> getSelectNodes() {
        TreeView orgtree = (TreeView)this.formView.getControl("ORGTREE");
        List selectedNodes = orgtree.getTreeState().getSelectedNodes();
        if (selectedNodes == null || selectedNodes.size() != 1) {
            this.formView.showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u7ec4\u7ec7\u3002", (String)"CommitCommand_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        Map orgMap = (Map)selectedNodes.get(0);
        return orgMap;
    }

    protected long getSchemeId() {
        MyEntryGridControl entryGridControl = (MyEntryGridControl)this.formView.getControl("billlist_entity");
        return entryGridControl.getSchemeObj().getLong("id");
    }

    private Collection<ApproveBillRptTemp> orgGetTempInfo(IFormView formView, List<String> errorInfo) {
        ArrayList<ApproveBillRptTemp> returns = new ArrayList<ApproveBillRptTemp>(16);
        if (this.formPlugin instanceof ReportPreparationListPlugin) {
            List<Object> reportProcessList = ((ReportPreparationListPlugin)this.formPlugin).getCurrentEntityAllReportProcessList();
            if (CollectionUtils.isEmpty(reportProcessList)) {
                formView.showMessage(ResManager.loadKDString((String)"\u5931\u8d25  \u5f53\u524d\u7ec4\u7ec7\u53ca\u4e0b\u7ea7\u7ec4\u7ec7\u6ca1\u6709\u9884\u7b97\u8868\uff0c\u8bf7\u68c0\u67e5\u7528\u6237\u7684\u9884\u7b97\u6a21\u677f\u6743\u9650\u3002", (String)"CommitCommandCommon_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return null;
            }
            if (CollectionUtils.isEmpty(reportProcessList = reportProcessList.stream().filter(x -> !BgTaskStateEnum.UNDERWAY.getNumber().equals(x.getStatus()) && !BgTaskStateEnum.COMPLETED.getNumber().equals(x.getStatus())).collect(Collectors.toList()))) {
                formView.showMessage(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0b\u7684\u62a5\u8868\u5747\u5df2\u63d0\u4ea4\u6216\u5df2\u5ba1\u6838\uff0c\u65e0\u9700\u91cd\u590d\u63d0\u4ea4\u3002", (String)"CommitCommandCommon_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return null;
            }
            Set templateIds = reportProcessList.stream().map(ReportProcess::getTemplateId).collect(Collectors.toSet());
            DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_templateentity", (String)"id, number,name, templatetype", (QFilter[])new QFilter[]{new QFilter("id", "in", templateIds)});
            HashMap<Long, DynamicObject> templateMap = new HashMap<Long, DynamicObject>(16);
            for (DynamicObject dynamicObject : query) {
                templateMap.put(dynamicObject.getLong("id"), dynamicObject);
            }
            long schemeId = this.getSchemeId();
            Set<Long> templateIdSet = ((ReportPreparationListPlugin)this.formPlugin).getReportPreparationListLocal().getTemplateIdSet();
            List templateSortIds = ReportSchemeTemplateSortService.getInstance().getTemplateIdsBySort(Long.valueOf(schemeId), templateIdSet);
            new ReportPreparationListHelper().sortReportProcessByTemplate(templateSortIds, reportProcessList);
            for (ReportProcess reportProcess : reportProcessList) {
                Long id = reportProcess.getId();
                Long templateId = reportProcess.getTemplateId();
                DynamicObject templateObj = (DynamicObject)templateMap.get(templateId);
                if (templateObj == null) continue;
                ApproveBillRptTemp approveBillRptTemp = new ApproveBillRptTemp();
                approveBillRptTemp.setTempName(templateObj.getString("name"));
                approveBillRptTemp.setTempNumber(templateObj.getString("number"));
                approveBillRptTemp.setTempId(templateId);
                approveBillRptTemp.setRptId(id);
                String templateType = templateObj.getString("templatetype");
                approveBillRptTemp.setRptType(templateType);
                approveBillRptTemp.setTaskListId(Long.valueOf(schemeId));
                approveBillRptTemp.setOrgId(reportProcess.getEntityId());
                approveBillRptTemp.setStatus(StringUtils.isEmpty((String)reportProcess.getStatus()) ? BgTaskStateEnum.UNSTARTED.getNumber() : reportProcess.getStatus());
                approveBillRptTemp.setApproveBillId(reportProcess.getApproveBillId() == null ? Long.valueOf(0L) : reportProcess.getApproveBillId());
                returns.add(approveBillRptTemp);
            }
        }
        return returns;
    }

    @Override
    protected void getPeiodVersionDataTypeInfoBatch(ApproveBillSubMitInfo bgmBill) {
        DynamicObject dynamicObject = null;
        dynamicObject = (DynamicObject)this.formView.getModel().getValue("datatype");
        if (dynamicObject != null) {
            bgmBill.getSubmitDims().setDataTypeId(Long.valueOf(dynamicObject.getLong("id")));
            bgmBill.getSubmitDims().setDataTypeNumber(dynamicObject.getString("number"));
        }
        if ((dynamicObject = (DynamicObject)this.formView.getModel().getValue("version")) != null) {
            bgmBill.getSubmitDims().setVersionId(Long.valueOf(dynamicObject.getLong("id")));
            bgmBill.getSubmitDims().setVersionNumber(dynamicObject.getString("number"));
        }
        if ((dynamicObject = (DynamicObject)this.formView.getModel().getValue("year")) != null) {
            bgmBill.getSubmitDims().setYearPeriodId(Long.valueOf(dynamicObject.getLong("id")));
            bgmBill.getSubmitDims().setYearPeriodNumber(dynamicObject.getString("number"));
        }
        DynamicObject schemecondition = (DynamicObject)this.formView.getModel().getValue("schemecondition");
        bgmBill.getSubmitDims().setViewId(Long.valueOf(schemecondition == null ? 0L : schemecondition.getLong("orgview.id")));
    }
}

