/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.approveBill;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.epm.eb.business.approveBill.CommitCheck;
import kd.epm.eb.business.approvetype.ApproveUtils;
import kd.epm.eb.common.approveBill.ApproveBillCommon;
import kd.epm.eb.common.approveBill.ApproveBillQuery;
import kd.epm.eb.common.approveBill.CentralBillRptSubmitHelper;
import kd.epm.eb.common.approveBill.Entity.ApproveBillInfo;
import kd.epm.eb.common.approveBill.Entity.ApproveBillRptTemp;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitDim;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitInfo;
import kd.epm.eb.common.approveBill.Entity.CentralBillFilterInfo;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.examine.enums.ExamineExecTypeEnum;
import kd.epm.eb.common.reportprocess.entity.domain.ReportProcess;
import kd.epm.eb.common.reportprocess.entity.dto.RptSubmitResult;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessAggService;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.ebSpread.common.util.StringUtil;
import kd.epm.eb.formplugin.approveBill.ApproveBillEditSupport;
import kd.epm.eb.formplugin.approveBill.CommitCancel;
import kd.epm.eb.formplugin.approveBill.CommitCommandUtil;
import kd.epm.eb.formplugin.approveBill.CommitExaminCheck;
import kd.epm.eb.formplugin.approveBill.MetricNotNullCheck;
import kd.epm.eb.formplugin.task.BgTaskExecutePlugin;
import kd.epm.eb.formplugin.task.command.BgTaskExecuteCommand;
import kd.epm.eb.formplugin.task.command.BgTaskExecuteHelper;
import kd.epm.eb.formplugin.task.command.IBgTaskExecutePlugin;
import kd.epm.eb.spread.baseplugin.AbstractReportPlugin;
import kd.epm.eb.spread.template.ITemplateModel;

public class CommitCommandBGMTask
extends BgTaskExecuteCommand {
    protected static final Log log = LogFactory.getLog(CommitCommandBGMTask.class);
    private boolean notCheckExamine = false;
    private ApproveBillInfo refApproveInfo;
    private String key;
    private RptSubmitResult submitResult;

    public CommitCommandBGMTask(String key) {
        this.key = key;
    }

    protected int getProcessType() {
        return ProcessTypeEnum.TASK.getIndex();
    }

    protected String getCommitBTNName() {
        return "batch_commit";
    }

    protected String getFormEntity() {
        return "entryentity";
    }

    protected ITemplateModel getTemplateModel() {
        return ((BgTaskExecutePlugin)this.formPlugin).getReportProcessPlugin().getTemplateModel();
    }

    protected boolean isClosed(Collection<ApproveBillRptTemp> rptTemps) {
        Set<Long> subTaskIds = rptTemps.stream().map(ApproveBillRptTemp::getSubTaskId).collect(Collectors.toSet());
        String info = BgTaskExecuteHelper.isTaskNotEnable(subTaskIds);
        if (StringUtils.isNotEmpty((CharSequence)info)) {
            this.formView.showErrorNotification(ResManager.loadResFormat((String)"\u4efb\u52a1\u201c%1\u201d\u672a\u542f\u7528\uff0c\u65e0\u6cd5\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"CommitCommandBGMTask_3", (String)"epm-eb-formplugin", (Object[])new Object[]{info}));
            return true;
        }
        return false;
    }

    @Override
    public void doExecute(IBgTaskExecutePlugin formPlugin) {
        try {
            Collection<ApproveBillRptTemp> rptTemps = this.getRptTemps(this.key, this.formView, formPlugin, this.pageCache);
            if (rptTemps == null || rptTemps.size() == 0) {
                return;
            }
            ApproveBillSubMitInfo bgmBill = this.getApproveBillParams(this.key, rptTemps);
            bgmBill.setSubmitInApproveBill(this.isApproveBill());
            log.info("submitReport_doExecute:" + JSON.toJSONString((Object)bgmBill));
            if (!this.key.equalsIgnoreCase("cancelcommit")) {
                if (!"examinecheck_inlist".equals(this.key) && this.isClosed(rptTemps)) {
                    return;
                }
                CentralBillFilterInfo centralBillFilterInfo = null;
                ApproveBillInfo approveBillInfo = this.getApproveBillInfo();
                if (approveBillInfo != null) {
                    List centralDimRange = ApproveUtils.getInstance().getCentralDimRange(approveBillInfo.getBillId());
                    centralBillFilterInfo = new CentralBillFilterInfo(approveBillInfo, centralDimRange);
                }
                this.formView.getPageCache().put("commitType", this.key);
                OperationResult result = new OperationResult();
                if (this.isOnlyExamineCheck()) {
                    this.checkExamineIsOk(ExamineExecTypeEnum.CheckInList, formPlugin, centralBillFilterInfo, bgmBill);
                } else if (new CommitCheck().checkCommitRptTempNotValiad(bgmBill, approveBillInfo, result)) {
                    CommitCommandUtil.showErrInfo(result, this.formView);
                } else if (this.checkMetricNotNull(formPlugin, centralBillFilterInfo, bgmBill) && (CommitCommandBGMTask.submitNotExamine() || this.checkExamineIsOk(ExamineExecTypeEnum.Commit, formPlugin, centralBillFilterInfo, bgmBill)) && !this.submit4CentralBill(result)) {
                    this.pageCache.put("isexcelkip", "1");
                    CommitCommandUtil.showConfirmFormWithCloseCallBack(bgmBill, this.formView, "bgm_dimrangeselect", formPlugin);
                }
            } else {
                this.getCommitCancelPlugin(formPlugin).cancelCommit(bgmBill);
            }
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.info(StringUtils.join((Object[])new String[]{"submitReport_doExecute_fail!", ex.getMessage(), Arrays.toString(ex.getStackTrace())}));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7:traceId[%1$s]", (String)"CommitCommandBGMTask_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), RequestContext.get().getTraceId()));
        }
    }

    public static boolean submitNotExamine() {
        boolean verify;
        block15: {
            verify = false;
            try {
                if (!SqlBatchUtils.hasTable((String)"T_EB_PARAM")) break block15;
                SqlBuilder sql = new SqlBuilder();
                sql.append("select fid, fvalue from t_eb_param where fnumber = ?", new Object[]{"SUBMIT_NOT_EXAMINE"});
                try (DataSet ds = DB.queryDataSet((String)"queryParams", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
                    if (ds != null && ds.hasNext()) {
                        Row row = ds.next();
                        verify = kd.epm.eb.common.utils.StringUtils.equals((String)"1", (String)row.getString("fvalue"));
                    }
                }
            }
            catch (Exception ex) {
                log.error("queryParams-error:", (Throwable)ex);
            }
        }
        return verify;
    }

    private boolean submit4CentralBill(OperationResult result) {
        ApproveBillInfo approveBillInfo = this.getApproveBillInfo();
        if (approveBillInfo == null || !approveBillInfo.isCentralBill()) {
            return false;
        }
        Long currentRptProcessId = this.getCurrentRptProcessId();
        Set notSubmitRptProcessIds = CentralBillRptSubmitHelper.getNotSubmitRptProcessIds((Long)approveBillInfo.getBillId());
        if (!notSubmitRptProcessIds.contains(currentRptProcessId)) {
            String title = ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff1a", (String)"BgApplyBillPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            ApproveBillCommon.addErrIntoResult((String)title, (String)ResManager.loadKDString((String)"\u5f53\u524d\u62a5\u8868\u5df2\u63d0\u4ea4\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u63d0\u4ea4\u3002", (String)"CommitCommandBGMTask_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), (OperationResult)result);
            CommitCommandUtil.showErrInfo(result, this.formView);
        } else {
            if (notSubmitRptProcessIds.size() > 1) {
                CentralBillRptSubmitHelper.markRptSubmit((Long)approveBillInfo.getBillId(), (Long)currentRptProcessId);
            } else {
                OperateOption op = OperateOption.create();
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)"eb_approvebill", (Object[])new Object[]{approveBillInfo.getBillId()}, (OperateOption)op);
                if (!operationResult.isSuccess()) {
                    CommitCommandUtil.showErrInfo(operationResult, this.formView);
                }
            }
            this.submitResult = new RptSubmitResult();
            if (this.formView != null) {
                this.submitResult.setSubmitType(this.formView.getPageCache().get("submitType"));
            }
        }
        return true;
    }

    private Long getCurrentRptProcessId() {
        AbstractReportPlugin reportProcessPlugin;
        Long processId = null;
        if (this.formPlugin != null && (reportProcessPlugin = this.formPlugin.getReportProcessPlugin()) != null) {
            processId = reportProcessPlugin.getProcessId();
        }
        if (processId == null) {
            return 0L;
        }
        return processId;
    }

    private ApproveBillInfo getApproveBillInfo() {
        if (this.refApproveInfo == null && this.formPlugin != null && this.formPlugin instanceof ApproveBillEditSupport) {
            this.refApproveInfo = ((ApproveBillEditSupport)((Object)this.formPlugin)).getApproveBillInfo();
        }
        return this.refApproveInfo;
    }

    protected CommitCancel getCommitCancelPlugin(IBgTaskExecutePlugin formPlugin) {
        return new CommitCancel(formPlugin);
    }

    protected boolean checkExamineIsOk(ExamineExecTypeEnum execTypeEnum, IBgTaskExecutePlugin formPlugin, CentralBillFilterInfo refBillFilterInfo, ApproveBillSubMitInfo bgmBill) {
        return this.isNotCheckExamine() || new CommitExaminCheck().batchCheckExamine(execTypeEnum, refBillFilterInfo, bgmBill, this.formView, formPlugin);
    }

    protected boolean checkMetricNotNull(IBgTaskExecutePlugin formPlugin, CentralBillFilterInfo refBillFilterInfo, ApproveBillSubMitInfo bgmBill) {
        return new MetricNotNullCheck().batchCheckExamine(ExamineExecTypeEnum.Commit, refBillFilterInfo, bgmBill, this.formView, formPlugin);
    }

    protected ApproveBillSubMitInfo getApproveBillParams(String key, Collection<ApproveBillRptTemp> rptTemps) {
        ApproveBillSubMitInfo bgmBill = new ApproveBillSubMitInfo();
        bgmBill.setBtnKey(key);
        bgmBill.setRptProcessType(this.getProcessType());
        bgmBill.setRptTemps(rptTemps);
        ApproveBillSubMitDim submitDims = new ApproveBillSubMitDim();
        bgmBill.setSubmitDims(submitDims);
        submitDims.setTempIds(ApproveBillCommon.getTempIds(rptTemps));
        submitDims.setModelId(this.formPlugin.getModelId());
        submitDims.setOrgId(IDUtils.toLong((Object)this.pageCache.get("current_org")));
        this.getPeiodVersionDataTypeInfo(bgmBill);
        submitDims.setViewId(this.getOrgViewId());
        submitDims.setCommitType("1");
        return bgmBill;
    }

    private Long getOrgViewId() {
        QFilter qFilter;
        DynamicObject dynamicObject;
        String tasklist = this.pageCache.get("current_taskp");
        if (StringUtils.isNotEmpty((CharSequence)tasklist) && (dynamicObject = QueryServiceHelper.queryOne((String)"eb_tasklist", (String)"orgview", (QFilter[])(qFilter = new QFilter("id", "=", (Object)IDUtils.toLong((Object)tasklist))).toArray())) != null) {
            return dynamicObject.getLong("orgview");
        }
        return 0L;
    }

    protected void getPeiodVersionDataTypeInfo(ApproveBillSubMitInfo bgmBill) {
        String taskListId = this.pageCache.get("current_taskp");
        DynamicObject taskList = QueryServiceHelper.queryOne((String)"eb_tasklist", (String)"year.id yearid,datatype.id datatypeid,version.id versionid , year.number yearnumber, datatype.number datatypenumber, version.number versionnumber,bizmodel.id bizmodelid ", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)IDUtils.toLong((Object)taskListId))});
        bgmBill.getSubmitDims().setDataTypeId(Long.valueOf(taskList.getLong("datatypeid")));
        bgmBill.getSubmitDims().setVersionId(Long.valueOf(taskList.getLong("versionid")));
        bgmBill.getSubmitDims().setYearPeriodId(Long.valueOf(taskList.getLong("yearid")));
        bgmBill.getSubmitDims().setBizModelId(Long.valueOf(taskList.getLong("bizmodelid")));
        bgmBill.getSubmitDims().setDataTypeNumber(taskList.getString("datatypenumber"));
        bgmBill.getSubmitDims().setVersionNumber(taskList.getString("versionnumber"));
        bgmBill.getSubmitDims().setYearPeriodNumber(taskList.getString("yearnumber"));
    }

    public Collection<ApproveBillRptTemp> getRptTemps(String key, IFormView formView, IFormPlugin formPlugin, IPageCache pageCache) {
        Collection<Object> rptTemps = new ArrayList(16);
        if ("examinecheck_inlist".equals(key)) {
            rptTemps = this.getBGMSelectedTempRPTFromViewBatch(formView);
            if (rptTemps != null && rptTemps.size() > 1000) {
                formView.showTipNotification(ResManager.loadResFormat((String)"\u6279\u91cf\u52fe\u7a3d\u68c0\u67e5\u6bcf\u6279\u6b21\u4e0d\u5141\u8bb8\u8d85\u8fc71000\u6761\u8bb0\u5f55\uff0c\u5f53\u524d\u5df2\u9009\u62e9%1\u6761\uff0c\u8bf7\u7f29\u5c0f\u8303\u56f4\u3002", (String)"CommitCommand_13", (String)"epm-eb-formplugin", (Object[])new Object[]{rptTemps.size()}));
                return null;
            }
        } else {
            rptTemps = this.getCommitBTNName().equalsIgnoreCase(key) ? this.getBGMSelectedTempRPTFromViewBatch(formView) : this.getBGMSelectedTempRPTFromViewSingle(pageCache, key);
        }
        this.updateRptInfos(rptTemps);
        return rptTemps;
    }

    private void updateRptInfos(Collection<ApproveBillRptTemp> rptTemps) {
        if (rptTemps == null || rptTemps.size() == 0) {
            return;
        }
        HashSet rptIds = new HashSet(rptTemps.size());
        rptTemps.forEach(e -> rptIds.add(e.getRptId()));
        Map processOtherInfos = ApproveBillQuery.getInstance().getProcessOtherInfos(rptIds);
        if (processOtherInfos == null || processOtherInfos.size() == 0) {
            return;
        }
        ApproveBillInfo approveBillInfo = this.getApproveBillInfo();
        for (ApproveBillRptTemp rptTemp : rptTemps) {
            if (approveBillInfo != null && approveBillInfo.isCentralBill()) {
                rptTemp.setStatus(approveBillInfo.getStatus4Rpt());
                rptTemp.setApproveBillId(approveBillInfo.getBillId());
                continue;
            }
            String processOtherInfo = (String)processOtherInfos.get(rptTemp.getRptId());
            String bill = "0";
            String status = BgTaskStateEnum.UNSTARTED.getNumber();
            if (StringUtils.isNotEmpty((CharSequence)processOtherInfo)) {
                String[] split = processOtherInfo.split("!");
                status = split[0];
                if (split.length > 1 && StringUtils.isNotEmpty((CharSequence)split[1])) {
                    bill = split[1];
                }
            }
            rptTemp.setStatus(status);
            rptTemp.setApproveBillId(IDUtils.toLong((Object)bill));
        }
    }

    protected Collection<ApproveBillRptTemp> getBGMSelectedTempRPTFromViewBatch(IFormView formView) {
        EntryGrid reportLs = (EntryGrid)formView.getControl(this.getFormEntity());
        int[] selectRows = reportLs.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62a5\u8868\u3002", (String)"CommitCommandCommon_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        ArrayList<ApproveBillRptTemp> returns = new ArrayList<ApproveBillRptTemp>(selectRows.length);
        for (int i = 0; i < selectRows.length; ++i) {
            ApproveBillRptTemp rptTemp = this.batchGetTempInfo(selectRows[i], formView);
            returns.add(rptTemp);
        }
        return returns;
    }

    protected void setOtherParamFromViewSingle(ApproveBillRptTemp rptTemp) {
        rptTemp.setRptId(IDUtils.toLong((Object)this.formView.getPageCache().get("current_report_id")));
        rptTemp.setOrgId(IDUtils.toLong((Object)this.formView.getPageCache().get("current_org")));
    }

    protected Collection<ApproveBillRptTemp> getBGMSelectedTempRPTFromViewSingle(IPageCache pageCache) {
        return this.getBGMSelectedTempRPTFromViewSingle(pageCache, null);
    }

    protected Collection<ApproveBillRptTemp> getBGMSelectedTempRPTFromViewSingle(IPageCache pageCache, String key) {
        ArrayList<ApproveBillRptTemp> returns = new ArrayList<ApproveBillRptTemp>();
        ApproveBillInfo approveBillInfo = this.getApproveBillInfo();
        ITemplateModel templateModel = this.getTemplateModel();
        Long taskId = IDUtils.toLong((Object)this.formView.getPageCache().get("current_taskp"));
        if (IDUtils.isNull((Long)taskId)) {
            taskId = IDUtils.toLong((Object)this.formView.getFormShowParameter().getCustomParam("current_taskp"));
        }
        if (this.isApproveBill() && approveBillInfo != null && StringUtils.isNotEmpty((CharSequence)key) && !"cancelcommit".equals(key)) {
            HashMap<Long, Long> taskProcessIdMap = new HashMap<Long, Long>(16);
            Map reportProcesses = ApproveUtils.getInstance().getApproveRefReportProcessInfo((Collection)Lists.newArrayList((Object[])new Long[]{approveBillInfo.getBillId()}));
            Map reportProcessMap = ReportProcessAggService.getInstance().convertReportProcessListToCombinationMap(new ArrayList(reportProcesses.values()));
            QFilter qFilter = new QFilter("org", "=", (Object)approveBillInfo.getBudgetOrgId());
            qFilter.and("template", "in", (Object)approveBillInfo.getTemplates());
            qFilter.and("task.tasklist.year", "=", (Object)approveBillInfo.getPeriodId());
            qFilter.and("task.tasklist.version", "=", (Object)approveBillInfo.getVersionId());
            qFilter.and("task.tasklist.datatype", "=", (Object)approveBillInfo.getDataTypeId());
            qFilter.and("task.tasklist", "=", (Object)taskId);
            DynamicObjectCollection taskProcesses = QueryServiceHelper.query((String)"eb_taskprocess", (String)"task, template", (QFilter[])qFilter.toArray());
            for (DynamicObject taskProcess : taskProcesses) {
                Long task = taskProcess.getLong("task");
                Long templateId = taskProcess.getLong("template");
                ReportProcess reportProcessKey = ReportProcess.buildReportProcessCombination((Long)templateModel.getModelId(), (Long)templateId, (Long)approveBillInfo.getBudgetOrgId(), (Long)approveBillInfo.getPeriodId(), (Long)approveBillInfo.getDataTypeId(), (Long)approveBillInfo.getVersionId());
                ReportProcess reportProcess = (ReportProcess)reportProcessMap.get(reportProcessKey);
                if (reportProcess == null) continue;
                taskProcessIdMap.put(reportProcess.getId(), task);
            }
            for (Map.Entry entry : reportProcesses.entrySet()) {
                ReportProcess reportProcess = (ReportProcess)entry.getValue();
                if (!approveBillInfo.isCentralBill() && !BgTaskStateEnum.TEMPSAVE.getNumber().equals(reportProcess.getStatus()) && !BgTaskStateEnum.UNPREPARED.getNumber().equals(reportProcess.getStatus()) && !BgTaskStateEnum.INCOMPLETE.getNumber().equals(reportProcess.getStatus())) continue;
                ApproveBillRptTemp rptTemp = new ApproveBillRptTemp();
                rptTemp.setTempId(reportProcess.getTemplateId());
                rptTemp.setTempName(reportProcess.getTemplateName());
                rptTemp.setTaskListId(taskId);
                rptTemp.setRptId(reportProcess.getId());
                rptTemp.setOrgId(reportProcess.getEntityId());
                rptTemp.setSubTaskId(taskProcessIdMap.getOrDefault(reportProcess.getId(), 0L));
                String childBillIdStr = pageCache.get("childBillId");
                if (!StringUtil.isEmptyString((String)childBillIdStr)) {
                    rptTemp.setApproveBillId(IDUtils.toLong((Object)childBillIdStr));
                }
                returns.add(rptTemp);
            }
        } else {
            ApproveBillRptTemp rptTemp = new ApproveBillRptTemp();
            rptTemp.setTempId(templateModel.getTemplateBaseInfo().getId());
            rptTemp.setTempNumber(templateModel.getTemplateBaseInfo().getNumber());
            rptTemp.setTempName(templateModel.getTemplateBaseInfo().getName());
            rptTemp.setRptType(String.valueOf(templateModel.getTemplateBaseInfo().getTemplatetype()));
            rptTemp.setTaskListId(taskId);
            Long subTaskId = IDUtils.toLong((Object)this.formView.getPageCache().get("subtaskid"));
            if (IDUtils.isNotNull((Long)subTaskId)) {
                rptTemp.setSubTaskId(subTaskId);
            }
            this.setOtherParamFromViewSingle(rptTemp);
            returns.add(rptTemp);
        }
        return returns;
    }

    protected ApproveBillRptTemp batchGetTempInfo(Integer row, IFormView formView) {
        ApproveBillRptTemp returns = new ApproveBillRptTemp();
        DynamicObject entryRowEntity = formView.getModel().getEntryRowEntity(this.getFormEntity(), row.intValue());
        returns.setTempId(IDUtils.toLong((Object)formView.getModel().getValue("ls_reportid", row.intValue()).toString()));
        returns.setTempName(formView.getModel().getValue("ls_reportname", row.intValue()).toString());
        DynamicObject process = entryRowEntity.getDynamicObject("reportprocess");
        if (process == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u5b9e\u4f8b\u4e0d\u5b58\u5728\u3002", (String)"ExportCommand_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        returns.setRptId(Long.valueOf(process.getLong("id")));
        returns.setRptType(formView.getModel().getValue("ls_reporttype", row.intValue()).toString());
        returns.setTaskListId(IDUtils.toLong((Object)formView.getPageCache().get("current_taskp")));
        returns.setOrgId(IDUtils.toLong((Object)formView.getModel().getValue("ls_orgid", row.intValue()).toString()));
        returns.setStatus(StringUtils.isEmpty((CharSequence)formView.getModel().getValue("ls_taskstate", row.intValue()).toString()) ? BgTaskStateEnum.UNSTARTED.getNumber() : formView.getModel().getValue("ls_taskstate", row.intValue()).toString());
        returns.setApproveBillId(Long.valueOf(process.getDynamicObject("approvebill") == null ? 0L : process.getDynamicObject("approvebill").getLong("id")));
        returns.setSubTaskId(IDUtils.toLong((Object)formView.getModel().getValue("ls_taskid", row.intValue()).toString()));
        returns.setApproveDesc(entryRowEntity.getString("approvedesc"));
        return returns;
    }

    @Override
    public void beforeExecute(IBgTaskExecutePlugin formPlugin) {
        super.beforeExecute(formPlugin);
        if ("examinecheck_inlist".equals(this.key)) {
            this.pageCache.put("isOnlyExamineCheck", "1");
        }
    }

    @Override
    public void afterExecute(IBgTaskExecutePlugin formPlugin) {
        super.afterExecute(formPlugin);
        if ("examinecheck_inlist".equals(this.key)) {
            this.pageCache.remove("isOnlyExamineCheck");
        }
        if (this.submitResult != null && formPlugin instanceof ApproveBillEditSupport) {
            ((ApproveBillEditSupport)((Object)formPlugin)).afterCommitRpt(SerializationUtils.toJsonString((Object)this.submitResult));
        }
    }

    private boolean isOnlyExamineCheck() {
        return "1".equals(this.pageCache.get("isOnlyExamineCheck"));
    }

    private boolean isApproveBill() {
        Map customParams = this.formView.getFormShowParameter().getCustomParams();
        return customParams.get("approveBill") != null && ("1".equals(customParams.get("approveBill")) || "2".equals(customParams.get("approveBill")));
    }

    public boolean isNotCheckExamine() {
        return this.notCheckExamine;
    }

    public void setNotCheckExamine(boolean notCheckExamine) {
        this.notCheckExamine = notCheckExamine;
    }
}

