/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.approveBill;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.epm.eb.business.reportscheme.service.ReportSchemeTemplateSortService;
import kd.epm.eb.common.approveBill.Entity.ApproveBillRptTemp;
import kd.epm.eb.common.approveBill.Entity.ApproveBillStatus;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitDim;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitInfo;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.ebcommon.common.enums.RangeEnum;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.reportprocess.entity.domain.ReportProcess;
import kd.epm.eb.common.reportprocess.helper.ApproveBillHelper;
import kd.epm.eb.common.reportprocess.helper.MemberHelper;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessServiceImpl;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.formplugin.approveBill.ApproveBillUtil;
import kd.epm.eb.formplugin.report.submission.controller.ReportSubmitRangeController;
import kd.epm.eb.formplugin.report.submission.enums.ReportSubmitTypeEnum;
import kd.epm.eb.formplugin.report.submission.vo.ReportSubmitRangeViewParam;
import kd.epm.eb.formplugin.reportscheme.helper.ReportPreparationListHelper;
import kd.epm.eb.formplugin.task.command.ListPanelDraw;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CommitCommandUtil {
    public static void showErrInfo(OperationResult result, IFormView formView) {
        if (result.getAllErrorInfo().size() > 0) {
            result.setBillCount(result.getAllErrorInfo().size());
            formView.showOperationResult(result);
        }
    }

    public static void showConfirmFormWithCloseCallBack(ApproveBillSubMitInfo bgmBill, IFormView formView, String formId, IFormPlugin formPlugin) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("selectOrg", (Object)formView.getPageCache().get("select_org"));
        parameter.setCustomParam("submitType", (Object)formView.getPageCache().get("submitType"));
        parameter.setCustomParam("rptinfo", (Object)kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil.toByteSerialized((Object)bgmBill));
        if (formPlugin != null) {
            parameter.setCloseCallBack(new CloseCallBack(formPlugin, "commit"));
        }
        if (bgmBill.isSubmitInApproveBill()) {
            StyleCss styleCss = new StyleCss();
            styleCss.setHeight("825px");
            parameter.getOpenStyle().setInlineStyleCss(styleCss);
        }
        formView.showForm(parameter);
    }

    public static void doCommitByNotPromptConfirm(Map<String, Object> returnDataMap, Long modelId, Long userId, IPageCache pageCache, IFormView view, IFormPlugin formPlugin) {
        if (returnDataMap == null || IDUtils.isEmptyLong((Long)modelId).booleanValue() || IDUtils.isEmptyLong((Long)userId).booleanValue() || pageCache == null || view == null) {
            return;
        }
        ApproveBillUtil.saveUserSelNotPrompt(returnDataMap, modelId, userId);
        String result = (String)returnDataMap.get("result");
        if ("true".equals(result)) {
            pageCache.put("isexcelkip", "1");
            String rptInfoCache = pageCache.get("commitrptinfo");
            if (StringUtils.isNotEmpty((CharSequence)rptInfoCache)) {
                ApproveBillSubMitInfo rptInfo = (ApproveBillSubMitInfo)ObjectSerialUtil.deSerializedBytes((String)rptInfoCache);
                CommitCommandUtil.showConfirmFormWithCloseCallBack(rptInfo, view, "bgm_dimrangeselect", formPlugin);
            }
        }
    }

    public static void showNotPromptConfirmWithCloseCallBack(List<ApproveBillRptTemp> unPreparedList, IFormView formView, String formId, IFormPlugin formPlugin, String title, String closeCallBackKey, Long modelId, Long orgViewId) {
        if (CollectionUtils.isEmpty(unPreparedList)) {
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        ArrayList<String> messages = new ArrayList<String>(unPreparedList.size());
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Dimension dimension = modelCacheHelper.getDimension(SysDimensionEnum.Entity.getNumber());
        Member member = null;
        for (ApproveBillRptTemp approveBillRptTemp : unPreparedList) {
            member = dimension.getMember(orgViewId, approveBillRptTemp.getOrgId());
            if (member != null) {
                messages.add(ResManager.loadResFormat((String)"\u7ec4\u7ec7\u201c%1\u201d\u7684\u62a5\u8868\u201c%2\u201d\u4e3a\u672a\u7f16\u5236\u72b6\u6001", (String)"CommitCommandUtil_7", (String)"epm-eb-formplugin", (Object[])new Object[]{member.getName(), approveBillRptTemp.getTempName()}));
                continue;
            }
            messages.add(ResManager.loadResFormat((String)"\u62a5\u8868\uff1a%1\u672a\u7f16\u5236\u3002", (String)"CommitCommandUtil_0", (String)"epm-eb-formplugin", (Object[])new Object[]{approveBillRptTemp.getTempName()}));
        }
        title = ResManager.loadResFormat((String)"%1\u5b58\u5728%2\u5f20\u72b6\u6001\u4e3a\u672a\u7f16\u5236\u7684\u62a5\u8868\uff0c\u662f\u5426\u7ee7\u7eed\u63d0\u4ea4\uff1f", (String)"CommitCommandUtil_1", (String)"epm-eb-formplugin", (Object[])new Object[]{title, unPreparedList.size()});
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("title", (Object)title);
        parameter.setCustomParam("message", messages);
        parameter.setCustomParam("opentype", (Object)closeCallBackKey);
        if (formPlugin != null) {
            parameter.setCloseCallBack(new CloseCallBack(formPlugin, closeCallBackKey));
        }
        formView.showForm(parameter);
    }

    public static String checkChildrenApproveBill(ApproveBillSubMitInfo rptInfo) {
        StringBuilder commitMsg = new StringBuilder();
        ApproveBillSubMitDim submitDims = rptInfo.getSubmitDims();
        Set templateIdSet = submitDims.getTempIds();
        Long modelId = submitDims.getModelId();
        Long viewId = submitDims.getViewId();
        Long entityId = submitDims.getOrgId();
        Long periodId = submitDims.getYearPeriodId();
        Long dataTypeId = submitDims.getDataTypeId();
        Long versionId = submitDims.getVersionId();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Set entityIdSetByRange = MemberHelper.getEntityIdSetByView((IModelCacheHelper)modelCacheHelper, (Long)viewId, (Long)entityId, (Integer)RangeEnum.VALUE_50.getValue());
        entityIdSetByRange.remove(entityId);
        if (CollectionUtils.isEmpty((Collection)entityIdSetByRange)) {
            return "";
        }
        DynamicObject[] approveBillList = ApproveBillHelper.getApproveBillListByStatus((Long)modelId, (Long)periodId, (Long)dataTypeId, (Long)versionId, (List)Lists.newArrayList((Object[])new String[]{ApproveBillStatus.SUBMIT.getNumber()}));
        HashSet<String> approveIds = new HashSet<String>(16);
        HashMap<Long, String> templateNameMap = new HashMap<Long, String>(16);
        HashMap<Long, Map> entityApproveMap = new HashMap<Long, Map>(16);
        for (DynamicObject dynamicObject : approveBillList) {
            long orgId = dynamicObject.getLong("eborgid.id");
            String approveId = dynamicObject.getString("id");
            if (!entityIdSetByRange.contains(orgId)) continue;
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject object : entryEntity) {
                DynamicObject templateDy = object.getDynamicObject("tempid");
                long aLong = templateDy.getLong("id");
                if (!templateIdSet.contains(aLong)) continue;
                Map approveTemplateMap = entityApproveMap.computeIfAbsent(orgId, v -> new HashMap(16));
                Set templateSet = approveTemplateMap.computeIfAbsent(approveId, v -> new HashSet(16));
                templateSet.add(aLong);
                templateNameMap.put(aLong, templateDy.getString("name"));
                approveIds.add(approveId);
            }
        }
        String[] pks = approveIds.toArray(new String[0]);
        Map allPro = WorkflowServiceHelper.getBizProcessStatus((String[])pks);
        HashMap<String, List<String>> auditorMap = new HashMap<String, List<String>>(16);
        for (Map.Entry entry : allPro.entrySet()) {
            String pkid = (String)entry.getKey();
            List node = (List)entry.getValue();
            node.forEach(e -> {
                List auditors;
                String auditor;
                if (e.getProcessStatus().equals("1") && (auditor = e.getParticipantName()) != null && !"".equals(auditor.trim()) && !(auditors = auditorMap.computeIfAbsent(pkid, k -> new ArrayList(16))).contains(auditor.replace(",", "\u3001"))) {
                    auditors.add(auditor.replace(",", "\u3001"));
                }
            });
        }
        for (Map.Entry entry : entityApproveMap.entrySet()) {
            Long entity = (Long)entry.getKey();
            Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), viewId, entity);
            Map approveMap = (Map)entry.getValue();
            String tips = CommitCommandUtil.buildChildrenApproveBillTemplateTips(member.getName(), approveMap, templateNameMap, auditorMap);
            commitMsg.append(tips).append("\n");
        }
        return StringUtils.isEmpty((CharSequence)commitMsg.toString()) ? "" : commitMsg.substring(0, commitMsg.length() - 1);
    }

    public static String buildChildrenApproveBillTemplateTips(String entityName, Map<String, Set<Long>> approveMap, Map<Long, String> templateNameMap, Map<String, List<String>> auditorMap) {
        String tipsTitle = ResManager.loadKDString((String)"\u4e0b\u7ea7\u7ec4\u7ec7%1$s\u7684\u62a5\u8868\u672a\u5ba1\u6838\u901a\u8fc7\uff0c\u63d0\u4ea4\u4e0a\u7ea7\u7ec4\u7ec7\u5ba1\u6279\u7684\u62a5\u8868\u6570\u636e\u4ecd\u53ef\u80fd\u53d1\u751f\u53d8\u52a8\uff0c\u63d0\u4ea4\u5931\u8d25\u3002", (String)"CommitCommandUtil_2", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        StringBuilder stringBuilder = new StringBuilder();
        String report = ResManager.loadKDString((String)"\u62a5\u8868\uff1a", (String)"CommitCommandUtil_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String audit = ResManager.loadKDString((String)"\u5ba1\u6838\u4eba\uff1a", (String)"CommitCommandUtil_4", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        stringBuilder.append(String.format(tipsTitle, entityName)).append("\n");
        int index = 1;
        int totalCount = 0;
        Optional<Integer> optional = approveMap.values().stream().map(Set::size).reduce(Integer::sum);
        if (optional.isPresent()) {
            totalCount = optional.get();
        }
        for (Map.Entry<String, Set<Long>> entry : approveMap.entrySet()) {
            List<String> auditorList = auditorMap.get(entry.getKey());
            String auditorName = "";
            if (CollectionUtils.isNotEmpty(auditorList)) {
                auditorName = String.join((CharSequence)";", auditorList);
            }
            Set<Long> templateIds = entry.getValue();
            boolean needAppendAudit = StringUtils.isNotEmpty((CharSequence)auditorName);
            for (Long templateId : templateIds) {
                StringBuilder templateTips = new StringBuilder();
                String templateName = templateNameMap.get(templateId);
                templateTips.append(index).append(".").append(report).append(entityName).append("-").append(templateName);
                if (needAppendAudit) {
                    templateTips.append("\uff0c").append(audit).append(auditorName);
                }
                if (index != totalCount) {
                    templateTips.append("\uff1b");
                } else {
                    templateTips.append("\u3002");
                }
                stringBuilder.append((CharSequence)templateTips).append("\n");
                ++index;
            }
        }
        return stringBuilder.toString();
    }

    public static String checkChildPassiveCommit(ApproveBillSubMitInfo rptInfo, List<Object> successPkIds) {
        ApproveBillSubMitDim submitDims = rptInfo.getSubmitDims();
        Set templateIdSet = submitDims.getTempIds();
        Long modelId = submitDims.getModelId();
        Long viewId = submitDims.getViewId();
        Long entityId = submitDims.getOrgId();
        Long periodId = submitDims.getYearPeriodId();
        Long dataTypeId = submitDims.getDataTypeId();
        Long versionId = submitDims.getVersionId();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Set entityIdSetByRange = MemberHelper.getEntityIdSetByView((IModelCacheHelper)modelCacheHelper, (Long)viewId, (Long)entityId, (Integer)RangeEnum.VALUE_50.getValue());
        entityIdSetByRange.remove(entityId);
        if (CollectionUtils.isEmpty((Collection)entityIdSetByRange)) {
            return "";
        }
        List reportProcessList = ReportProcessServiceImpl.getInstance().getReportProcessList(modelId, viewId, entityIdSetByRange, templateIdSet, periodId, dataTypeId, versionId);
        List passiveReportProcess = reportProcessList.stream().filter(reportProcess -> successPkIds.contains(reportProcess.getApproveBillId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(passiveReportProcess)) {
            return "";
        }
        List<ReportProcess> passiveReport = passiveReportProcess.stream().filter(reportProcess -> !"5".equals(reportProcess.getStatus()) && !"9".equals(reportProcess.getStatus()) && templateIdSet.contains(reportProcess.getTemplateId()) && entityIdSetByRange.contains(reportProcess.getEntityId())).collect(Collectors.toList());
        Map templateMap = BusinessDataServiceHelper.loadFromCache((Object[])passiveReport.stream().map(ReportProcess::getTemplateId).distinct().toArray(), (String)"eb_templateentity");
        return CommitCommandUtil.buildChildrenPassiveMsg(passiveReport, modelCacheHelper, templateMap, viewId);
    }

    public static String buildChildrenPassiveMsg(List<ReportProcess> passiveReport, IModelCacheHelper modelCacheHelper, Map<Object, DynamicObject> templateMap, Long viewId) {
        if (CollectionUtils.isNotEmpty(passiveReport)) {
            StringBuilder stringBuilder = new StringBuilder(ResManager.loadKDString((String)"\u63d0\u4ea4\u4e0a\u7ea7\u7ec4\u7ec7\u7684\u62a5\u8868\u4f1a\u5c06\u4e0b\u7ea7\u7ec4\u7ec7\u672a\u63d0\u4ea4\u7684\u62a5\u8868\u4e00\u8d77\u63d0\u4ea4\uff0c\u4e0b\u7ea7\u7ec4\u7ec7\u672a\u63d0\u4ea4\u7684\u62a5\u8868\u5982\u4e0b\uff1a", (String)"CommitCommandUtil_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            stringBuilder.append("\n");
            String entity = ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a", (String)"CommitCommandUtil_5", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            String report = ResManager.loadKDString((String)"\u62a5\u8868\uff1a", (String)"CommitCommandUtil_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            for (int i = 1; i <= passiveReport.size(); ++i) {
                ReportProcess reportProcess = passiveReport.get(i - 1);
                StringBuilder tips = new StringBuilder();
                tips.append(i).append(".").append(entity).append(modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), viewId, reportProcess.getEntityId()).getName()).append("\uff0c").append(report).append(templateMap.get(reportProcess.getTemplateId()).getString("name"));
                if (i != passiveReport.size()) {
                    tips.append("\uff1b");
                } else {
                    tips.append("\u3002");
                }
                stringBuilder.append((CharSequence)tips).append("\n");
            }
            return stringBuilder.substring(0, stringBuilder.length() - 1);
        }
        return "";
    }

    public static Map<Long, Set<ReportProcess>> initReportProcessListMap(Set<Long> submitEntityIds, Map<Long, Long> processTaskIdMap, ReportSubmitRangeViewParam params, IFormView formView) {
        LinkedHashMap<Long, Set<ReportProcess>> result = new LinkedHashMap<Long, Set<ReportProcess>>(16);
        if (params == null) {
            return result;
        }
        if (params.getReportSubmitTypeEnum() == ReportSubmitTypeEnum.batch_report_commit) {
            Map<Long, Set<Long>> selectEntityReportProcessMap = params.getSelectEntityReportProcessMap();
            HashSet selectRptIds = new HashSet(16);
            if (selectEntityReportProcessMap != null && selectEntityReportProcessMap.size() > 0) {
                for (Map.Entry<Long, Set<Long>> entry : selectEntityReportProcessMap.entrySet()) {
                    if (!submitEntityIds.contains(entry.getKey())) continue;
                    selectRptIds.addAll((Collection)entry.getValue());
                }
                List reportProcess = ReportProcessServiceImpl.getInstance().getReportProcess(selectRptIds);
                for (ReportProcess process : reportProcess) {
                    Set reportProcesses = result.computeIfAbsent(process.getEntityId(), t -> new LinkedHashSet(16));
                    if (!ReportSubmitRangeController.RPTFILTERSTATUS.contains(process.getStatus())) continue;
                    reportProcesses.add(process);
                }
            }
            return result;
        }
        ProcessTypeEnum reportSubmitEnterEnum = params.getReportSubmitEnterEnum();
        Long modelId = params.getModelId();
        Long periodId = params.getPeriodId();
        Long dataTypeId = params.getDataTypeId();
        Long versionId = params.getVersionId();
        Long schemeId = params.getSchemeId();
        Long entityViewId = params.getEntityViewId();
        Long schemeAssignId = params.getSchemeAssignId();
        ReportPreparationListHelper reportPreparationListHelper = new ReportPreparationListHelper();
        if (reportSubmitEnterEnum == ProcessTypeEnum.REPORT) {
            Set<Long> templateTreeIdSet = reportPreparationListHelper.getTemplateTreeIdSet(modelId, schemeId);
            List templateSortIds = ReportSchemeTemplateSortService.getInstance().getTemplateIdsBySort(schemeAssignId, templateTreeIdSet);
            templateTreeIdSet.clear();
            templateTreeIdSet.addAll(templateSortIds);
            return new ReportPreparationListHelper().getCurrentUserReportProcessListMap(modelId, periodId, dataTypeId, versionId, ModelCacheContext.getOrCreate((Long)modelId), entityViewId, schemeId, submitEntityIds, templateTreeIdSet, ReportSubmitRangeController.RPTFILTERSTATUS);
        }
        if (reportSubmitEnterEnum == ProcessTypeEnum.TASK) {
            List<Map<String, Object>> taskProcessList = new ListPanelDraw(modelId, params.getRole(), params.getTaskListId() + "", null, null, null, formView, false).getTaskProcessList(submitEntityIds, 0L);
            Map<ReportProcess, ReportProcess> reportProcessMap = ReportSubmitRangeController.getInstance().getReportProcessMap(modelId, periodId, dataTypeId, versionId, submitEntityIds, null);
            taskProcessList.sort((o1, o2) -> {
                Long taskId2;
                Long taskId1 = IDUtils.toLong(o1.get("taskid"));
                if (taskId1.equals(taskId2 = IDUtils.toLong(o2.get("taskid")))) {
                    Long tempSeq1 = IDUtils.toLong(o1.get("tempseq"));
                    Long tempSeq2 = IDUtils.toLong(o2.get("tempseq"));
                    return Long.compare(tempSeq1, tempSeq2);
                }
                return Long.compare(taskId1, taskId2);
            });
            for (Map<String, Object> row : taskProcessList) {
                Long orgid = IDUtils.toLong((Object)row.get("orgid"));
                Long templateId = IDUtils.toLong((Object)row.get("template"));
                Set reportProcesses = result.computeIfAbsent(orgid, t -> new LinkedHashSet(16));
                ReportProcess reportProcess = new ReportProcess(modelId, templateId, orgid, periodId, dataTypeId, versionId);
                ReportProcess reportProcessFromDb = reportProcessMap.get(reportProcess);
                if (reportProcessFromDb == null || !ReportSubmitRangeController.RPTFILTERSTATUS.contains(reportProcessFromDb.getStatus())) continue;
                reportProcesses.add(reportProcessFromDb);
                if (processTaskIdMap == null) continue;
                processTaskIdMap.put(reportProcessFromDb.getId(), IDUtils.toLong((Object)row.get("taskid")));
            }
        }
        return result;
    }
}

