/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.approveBill;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.applybill.service.ApplyBillServiceHelper;
import kd.epm.eb.business.applybill.util.ApplyTemplateUtils;
import kd.epm.eb.business.applybill.util.BgApplyBillUtils;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateColCfgService;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.business.examinev2.cache.ExamineCache;
import kd.epm.eb.business.examinev2.service.ExamineCheckRangeUtils;
import kd.epm.eb.business.examinev2.service.ExamineCheckServiceImpl;
import kd.epm.eb.business.examinev2.service.ExamineServiceImpl;
import kd.epm.eb.common.applyTemplate.constants.FormTypeEnum;
import kd.epm.eb.common.applybill.ApplyBillType;
import kd.epm.eb.common.applybill.SchemeAssignDimGroup;
import kd.epm.eb.common.applytemplatecolumn.EntryTemplateConfig;
import kd.epm.eb.common.approveBill.ApproveBillCommon;
import kd.epm.eb.common.approveBill.Entity.ApproveBillRptTemp;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitInfo;
import kd.epm.eb.common.approveBill.Entity.CentralBillFilterInfo;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.centralapproval.CentralAppShowInfo;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.TriggerEventEnum;
import kd.epm.eb.common.examine.domain.report.ExamineCheckReport;
import kd.epm.eb.common.examine.enums.ExamineCheckResultEnum;
import kd.epm.eb.common.examine.enums.ExamineExecTypeEnum;
import kd.epm.eb.common.examine.request.MultiExamineCheckRequest;
import kd.epm.eb.common.examine.request.ReportCheckRange;
import kd.epm.eb.common.examine.request.ReportCheckRangeRequest;
import kd.epm.eb.common.examine.request.SchemeOrTaskReqeust;
import kd.epm.eb.common.pojo.ReportOrTaskPojo;
import kd.epm.eb.common.reportprocess.entity.domain.ReportProcess;
import kd.epm.eb.common.reportprocess.helper.ApproveBillHelper;
import kd.epm.eb.common.reportprocess.helper.MemberHelper;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessServiceImpl;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.base.CacheUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.ebSpread.common.util.StringUtil;
import kd.epm.eb.formplugin.approveBill.ApproveBillListPlugin;
import kd.epm.eb.formplugin.report.submission.dto.ReportBatchSubmitResponse;
import kd.epm.eb.formplugin.report.submission.view.ReportSubmitRangePlugin;
import kd.epm.eb.formplugin.reportscheme.ReportPreparationListPlugin;
import kd.epm.eb.formplugin.task.BgTaskExecutePlugin;
import kd.epm.eb.formplugin.task.command.IBgTaskExecutePlugin;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateFactory;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;
import kd.epm.eb.spread.template.afix.FixTemplateModel;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import kd.epm.eb.spread.template.spread.style.MetricCellStyleInfo;
import kd.epm.eb.spread.template.spreadmanager.EbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.book.EBook;
import kd.epm.eb.spread.template.spreadmanager.book.IEBook;
import kd.epm.eb.spread.template.spreadmanager.fix.FixSpreadManager;
import kd.epm.eb.spread.template.viewpointdim.IViewPointDimensionEntry;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class CommitExaminCheck {
    private static final Log log = LogFactory.getLog(CommitExaminCheck.class);
    private static final String LOG_PREFIX = "EB_FORM_EXAMINE";

    public boolean batchCheckExamine(ExamineExecTypeEnum execTypeEnum, CentralBillFilterInfo refBillFilterInfo, ApproveBillSubMitInfo rptInfo, IFormView formView, IBgTaskExecutePlugin formPlugin) {
        Collection rptTemps = rptInfo.getRptTemps();
        if (rptTemps == null || rptTemps.size() == 0) {
            return true;
        }
        Set tempids = ApproveBillCommon.getTempIds((Collection)rptTemps);
        Long taskListId = ProcessTypeEnum.REPORT.getIndex() == rptInfo.getRptProcessType() ? ReportVarUtil.querySchemeAssign((Long)rptInfo.getSubmitDims().getModelId(), (Long)rptInfo.getSubmitDims().getDataTypeId(), (Long)rptInfo.getSubmitDims().getVersionId(), (Long)rptInfo.getSubmitDims().getYearPeriodId(), (Long)((ApproveBillRptTemp)rptInfo.getRptTemps().iterator().next()).getTaskListId()) : ((ApproveBillRptTemp)rptInfo.getRptTemps().iterator().next()).getTaskListId();
        Map varValues = ReportVarUtil.getVarValues((Integer)rptInfo.getRptProcessType(), (Long)rptInfo.getSubmitDims().getModelId(), (Long)taskListId);
        ArrayList<ITemplateModel> templateModels = new ArrayList<ITemplateModel>(tempids.size());
        DynamicObject[] temDyn = (DynamicObject[])BusinessDataServiceHelper.load((Object[])tempids.toArray(new Long[0]), (IDataEntityType)ORM.create().getDataEntityType("eb_templateentity"));
        ExamineCache examineCache = ExamineServiceImpl.getInstance().listExamineFromLocalCache(rptInfo.getSubmitDims().getModelId()).getExamineCache();
        for (DynamicObject temp : temDyn) {
            String data;
            Set examineDtos = examineCache.getExamineByTempId(Long.valueOf(temp.getLong("id")));
            if (CollectionUtils.isEmpty((Collection)examineDtos) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)(data = (String)temp.get("data")))) continue;
            ITemplateModel templateModel = org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)data) ? TemplateModelJSONUtil.parseITemplateModel((String)data) : TemplateFactory.buildTemplateModel();
            templateModel.setTemplateBaseInfo(this.getTemplateBaseInfo(temp));
            templateModel.initDimensionViewsFromDataSet();
            templateModels.add(templateModel);
        }
        if (CollectionUtils.isEmpty(templateModels)) {
            String hideExamineTip = formPlugin.getView().getPageCache().get("hideUnExamineTip");
            if (ExamineExecTypeEnum.CheckInList == execTypeEnum && !"true".equals(hideExamineTip)) {
                formView.showTipNotification(ResManager.loadKDString((String)"\u672a\u68c0\u6d4b\u5173\u8054\u7684\u52fe\u7a3d\u5173\u7cfb\u3002", (String)"BgExamineCheckCommand_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            return true;
        }
        return this.doCheckExamine(execTypeEnum, formPlugin, formView, templateModels, rptInfo, varValues, taskListId);
    }

    public void checkExamineIsOk(Long modelId, ProcessTypeEnum processTypeEnum, Long entityViewId, Long periodId, Long dataTypeId, Long versionId, Map<String, Map<String, String>> varValues, Long taskProcessId, Map<Long, Set<ReportProcess>> toSubmitEntityRptMap, Set<Long> templateIds, ReportBatchSubmitResponse reportSubmitResponse) {
        if (reportSubmitResponse == null) {
            return;
        }
        HashMap<Long, ITemplateModel> templateModelMap = new HashMap<Long, ITemplateModel>(16);
        HashMap<Long, IEbSpreadManager> spreadManagerMap = new HashMap<Long, IEbSpreadManager>(16);
        this.getHasExamineTemplateMap(modelId, processTypeEnum, taskProcessId, templateIds, templateModelMap, spreadManagerMap, false);
        if (templateModelMap.size() == 0) {
            reportSubmitResponse.getWarningInfoList().add(ResManager.loadKDString((String)"\u672a\u68c0\u6d4b\u5173\u8054\u7684\u52fe\u7a3d\u5173\u7cfb\u3002", (String)"BgExamineCheckCommand_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)modelId);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        ArrayList reportCheckRanges = new ArrayList(16);
        boolean checkAllChild = CommitExaminCheck.isCheckAllChild();
        for (Map.Entry<Long, Set<ReportProcess>> entry : toSubmitEntityRptMap.entrySet()) {
            List allChildMembers;
            Member member;
            Long entityId = entry.getKey();
            Set<ReportProcess> reportProcessList = entry.getValue();
            HashSet<Long> allChildEntityIds = null;
            if (checkAllChild && (member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), entityViewId, entityId)) != null && !member.isLeaf() && CollectionUtils.isNotEmpty((Collection)(allChildMembers = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), entityViewId, member.getNumber(), RangeEnum.ALL_EXCLUDE.getIndex())))) {
                allChildEntityIds = new HashSet<Long>(16);
                for (Member allChildMember : allChildMembers) {
                    allChildEntityIds.add(allChildMember.getId());
                }
            }
            for (ReportProcess reportProcess : reportProcessList) {
                List allChildReportProcessList;
                if (templateModelMap.get(reportProcess.getTemplateId()) == null) continue;
                List reportCheckRange = ExamineCheckRangeUtils.parseRptExamineScope((Long)periodId, (Long)dataTypeId, (Long)versionId, (Long)entityViewId, (IModelCacheHelper)modelCacheHelper, (MemberPropCache)memberPropCache, (Long)entityId, (Long)reportProcess.getId(), varValues, (ITemplateModel)((ITemplateModel)templateModelMap.get(reportProcess.getTemplateId())), (IEbSpreadManager)((IEbSpreadManager)spreadManagerMap.get(reportProcess.getTemplateId())));
                reportCheckRanges.addAll(reportCheckRange);
                if (!checkAllChild || allChildEntityIds == null || !CollectionUtils.isNotEmpty((Collection)(allChildReportProcessList = ReportProcessServiceImpl.getInstance().getReportProcessList(modelId, periodId, dataTypeId, versionId, allChildEntityIds, Collections.singleton(reportProcess.getTemplateId()))))) continue;
                for (ReportProcess process : allChildReportProcessList) {
                    reportCheckRange = ExamineCheckRangeUtils.parseRptExamineScope((Long)periodId, (Long)dataTypeId, (Long)versionId, (Long)entityViewId, (IModelCacheHelper)modelCacheHelper, (MemberPropCache)memberPropCache, (Long)process.getEntityId(), (Long)process.getId(), varValues, (ITemplateModel)((ITemplateModel)templateModelMap.get(process.getTemplateId())), (IEbSpreadManager)((IEbSpreadManager)spreadManagerMap.get(process.getTemplateId())));
                    reportCheckRanges.addAll(reportCheckRange);
                }
            }
        }
        MultiExamineCheckRequest multiExamineCheckRequest = new MultiExamineCheckRequest();
        multiExamineCheckRequest.setExecutorId(UserUtils.getUserId());
        multiExamineCheckRequest.setModelId(modelId);
        multiExamineCheckRequest.setTriggerEvent(TriggerEventEnum.BUDGET_TABLE_SUBMIT);
        multiExamineCheckRequest.setReportCheckRangeList(reportCheckRanges);
        multiExamineCheckRequest.setProcessTypeEnum(processTypeEnum);
        multiExamineCheckRequest.setVarValues(varValues);
        reportSubmitResponse.getExamineCheckReports().addAll(ExamineCheckServiceImpl.getInstance().multiCheck(multiExamineCheckRequest));
    }

    public void getHasExamineTemplateMap(Long modelId, ProcessTypeEnum reportSubmitEnterEnum, Long taskProcessId, Set<Long> submitTemplateIds, Map<Long, ITemplateModel> templateModelMap, Map<Long, IEbSpreadManager> spreadManagerMap, boolean metricNotNull) {
        if (templateModelMap == null || spreadManagerMap == null) {
            return;
        }
        String selectFields = "id,data,name,number,dataunit,model.id,templateCatalog.id,dataset.businessmodel.id,dataset,varbaseforeb,isreadonly,isrelation,floatcalculate";
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"eb_templateentity", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", submitTemplateIds)});
        ExamineCache examineCache = null;
        if (!metricNotNull) {
            examineCache = ExamineServiceImpl.getInstance().listExamineFromLocalCache(modelId).getExamineCache();
        }
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            FixSpreadManager spreadManager;
            Optional<MetricCellStyleInfo> first2;
            Optional<IPageDimensionEntry> first1;
            Optional<IViewPointDimensionEntry> first;
            ITemplateModel templateModel;
            String data;
            Set examineDtos;
            if (examineCache != null && CollectionUtils.isEmpty((Collection)(examineDtos = examineCache.getExamineByTempId(Long.valueOf(dynamicObject.getLong("id"))))) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)(data = (String)dynamicObject.get("data"))) || (templateModel = org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)data) ? TemplateModelJSONUtil.parseITemplateModel((String)data) : TemplateFactory.buildTemplateModel()) == null) continue;
            templateModel.setTemplateBaseInfo(this.getTemplateBaseInfo(dynamicObject));
            templateModel.initDimensionViewsFromDataSet();
            if (metricNotNull && (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)data) || !CollectionUtils.isNotEmpty((Collection)templateModel.getMetricCellStyleInfo()) || dynamicObject.getBoolean("isreadonly") || (first = templateModel.getViewpointmembentry().stream().filter(x -> x.getDimension().getNumber().equals(SysDimensionEnum.Metric.getNumber())).findFirst()).isPresent() || (first1 = templateModel.getPagemembentry().stream().filter(x -> x.getDimension().getNumber().equals(SysDimensionEnum.Metric.getNumber())).findFirst()).isPresent() || !(first2 = templateModel.getMetricCellStyleInfo().stream().filter(x -> x.getMustInput() != null && x.getMustInput() != false).findFirst()).isPresent())) continue;
            templateModelMap.put(dynamicObject.getLong("id"), templateModel);
            if (templateModel instanceof FixTemplateModel) {
                spreadManager = new FixSpreadManager();
                spreadManager.setProcessId(taskProcessId);
                spreadManager.setVarFlagStr("1");
                spreadManager.setProcessType(reportSubmitEnterEnum.getNumber());
                spreadManager.initModelObj(templateModel);
                spreadManager.buildReportManager(templateModel);
            } else {
                spreadManager = new EbSpreadManager();
                spreadManager.setProcessId(taskProcessId);
                spreadManager.setVarFlagStr("1");
                spreadManager.setProcessType(reportSubmitEnterEnum.getNumber());
                spreadManager.initModelObj(templateModel);
                EBook ieBook = new EBook(new String[]{"Sheet1"});
                spreadManager.setEbook((IEBook)ieBook);
                spreadManager.buildReportManager(templateModel);
            }
            spreadManagerMap.put(dynamicObject.getLong("id"), (IEbSpreadManager)spreadManager);
        }
    }

    @NotNull
    protected BgTemplate getTemplateBaseInfo(DynamicObject dyna) {
        BgTemplate templateBaseInfo = new BgTemplate();
        templateBaseInfo.setId(Long.valueOf(dyna.getLong("id")));
        templateBaseInfo.setName(dyna.getString("name"));
        templateBaseInfo.setNumber(dyna.getString("number"));
        templateBaseInfo.setDataunit(dyna.getString("dataunit"));
        templateBaseInfo.setModelID(Long.valueOf(dyna.getLong("model.id")));
        templateBaseInfo.setCatalog(Long.valueOf(dyna.getLong("templateCatalog.id")));
        templateBaseInfo.setBizModel(Long.valueOf(dyna.getLong("dataset.businessmodel.id")));
        Object dataset = dyna.get("dataset");
        if (dataset instanceof DynamicObject) {
            templateBaseInfo.setDatasetID(Long.valueOf(dyna.getDynamicObject("dataset").getLong("id")));
        } else {
            templateBaseInfo.setDatasetID(Long.valueOf(dyna.getLong("dataset")));
        }
        templateBaseInfo.setVarBase(dyna.getString("varbaseforeb"));
        templateBaseInfo.setIsReadOnly(dyna.getBoolean("isreadonly") ? "1" : "0");
        templateBaseInfo.setIsDimRelation(dyna.getBoolean("isrelation") ? "1" : "0");
        templateBaseInfo.setFloatcalculate(dyna.getBoolean("floatcalculate") ? "1" : "0");
        String selectFields = "id,model,dataset.businessmodel,isrelation,dimrelationinfo2";
        DynamicObject tem = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_templateentity", (String)selectFields, (QFilter[])new QFilter("id", "=", (Object)dyna.getLong("id")).toArray());
        if (tem != null) {
            DynamicObjectCollection dimrelationinfos = tem.getDynamicObjectCollection("dimrelationinfo2");
            List dimRelations = dimrelationinfos.stream().map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toList());
            templateBaseInfo.setDimRelations(dimRelations);
        }
        return templateBaseInfo;
    }

    protected boolean doCheckExamine(ExamineExecTypeEnum execTypeEnum, IBgTaskExecutePlugin formPlugin, IFormView formView, List<ITemplateModel> templateModels, ApproveBillSubMitInfo rptInfo, Map<String, Map<String, String>> varValues, long taskListId) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        MultiExamineCheckRequest multiExamineCheckRequest = new MultiExamineCheckRequest();
        multiExamineCheckRequest.setExecutorId(UserUtils.getUserId());
        multiExamineCheckRequest.setModelId(formPlugin.getModelId());
        multiExamineCheckRequest.setTriggerEvent(TriggerEventEnum.BUDGET_TABLE_SUBMIT);
        ArrayList reportCheckRanges = new ArrayList(templateModels.size());
        multiExamineCheckRequest.setReportCheckRangeList(reportCheckRanges);
        multiExamineCheckRequest.setProcessTypeEnum(ProcessTypeEnum.getProcessTypeByIndex((int)rptInfo.getRptProcessType()));
        multiExamineCheckRequest.setVarValues(varValues);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)formPlugin.getModelId());
        Map<Object, Object> reportProcessMap = Collections.emptyMap();
        if (execTypeEnum == ExamineExecTypeEnum.CheckInList) {
            reportProcessMap = rptInfo.getRptTemps().stream().collect(Collectors.groupingBy(ApproveBillRptTemp::getTempId));
        }
        ArrayList<SchemeOrTaskReqeust> reportList = new ArrayList<SchemeOrTaskReqeust>(16);
        boolean checkAllChild = CommitExaminCheck.isCheckAllChild();
        for (ITemplateModel templateModel : templateModels) {
            List<Object> reportIds = new ArrayList(16);
            if (execTypeEnum == ExamineExecTypeEnum.CheckInList) {
                String examineOrgIds;
                List approveBillRptTemps = (List)reportProcessMap.get(templateModel.getTemplateBaseInfo().getId());
                if (approveBillRptTemps != null) {
                    reportIds = approveBillRptTemps.stream().map(x -> x.getRptId()).collect(Collectors.toList());
                }
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)(examineOrgIds = formPlugin.getView().getPageCache().get("examineOrgIds")))) {
                    Set entityIdSetByRange = (Set)JsonUtils.readValue((String)examineOrgIds, (TypeReference)new TypeReference<Set<Long>>(){});
                    List notApproveBillProcessList = ApproveBillHelper.getNotApproveBillProcessList((Long)formPlugin.getModelId(), (Long)rptInfo.getSubmitDims().getViewId(), (Long)rptInfo.getSubmitDims().getYearPeriodId(), (Long)rptInfo.getSubmitDims().getDataTypeId(), (Long)rptInfo.getSubmitDims().getVersionId(), (Set)Sets.newHashSet((Object[])new Long[]{templateModel.getTemplateBaseInfo().getId()}), (Set)entityIdSetByRange, (boolean)true);
                    for (ReportProcess reportProcess : notApproveBillProcessList) {
                        if (reportIds.contains(reportProcess.getId())) continue;
                        reportIds.add(reportProcess.getId());
                    }
                }
            } else {
                reportIds = ApproveBillCommon.getRptIds((Collection)rptInfo.getRptTemps(), (Long)templateModel.getTemplateBaseInfo().getId()).stream().collect(Collectors.toList());
                if (checkAllChild) {
                    Set entityIdSetByRange = MemberHelper.getEntityIdSetByView((IModelCacheHelper)modelCache, (Long)rptInfo.getSubmitDims().getViewId(), (Long)rptInfo.getSubmitDims().getOrgId(), (Integer)kd.epm.eb.common.ebcommon.common.enums.RangeEnum.VALUE_40.getValue());
                    List notApproveBillProcessList = ApproveBillHelper.getNotApproveBillProcessList((Long)formPlugin.getModelId(), (Long)rptInfo.getSubmitDims().getViewId(), (Long)rptInfo.getSubmitDims().getYearPeriodId(), (Long)rptInfo.getSubmitDims().getDataTypeId(), (Long)rptInfo.getSubmitDims().getVersionId(), (Set)Sets.newHashSet((Object[])new Long[]{templateModel.getTemplateBaseInfo().getId()}), (Set)entityIdSetByRange, (boolean)true);
                    for (ReportProcess reportProcess : notApproveBillProcessList) {
                        if (reportIds.contains(reportProcess.getId())) continue;
                        reportIds.add(reportProcess.getId());
                    }
                }
            }
            SchemeOrTaskReqeust schemeOrTaskReqeust = new SchemeOrTaskReqeust();
            schemeOrTaskReqeust.setReportProcessId(reportIds);
            schemeOrTaskReqeust.setReportProcessType(Integer.valueOf(rptInfo.getRptProcessType()));
            schemeOrTaskReqeust.setTaskProcessId(Long.valueOf(taskListId));
            reportList.add(schemeOrTaskReqeust);
        }
        ReportCheckRangeRequest reportCheckRangeRequest = new ReportCheckRangeRequest();
        reportCheckRangeRequest.setModel(formPlugin.getModelId());
        reportCheckRangeRequest.setReportList(reportList);
        log.info("{} createRequest cost:{}ms,params:{}", new Object[]{LOG_PREFIX, stopwatch.elapsed(TimeUnit.MILLISECONDS), JsonUtils.getJsonString((Object)reportCheckRangeRequest)});
        stopwatch.reset();
        stopwatch.start();
        List reportCheckRanges1 = ExamineCheckServiceImpl.getInstance().getReportCheckRange(reportCheckRangeRequest);
        log.info("{} getReportCheckRange cost:{}ms,response:{}", new Object[]{LOG_PREFIX, stopwatch.elapsed(TimeUnit.MILLISECONDS), JsonUtils.getJsonString((Object)reportCheckRanges1)});
        stopwatch.reset();
        stopwatch.start();
        reportCheckRanges.addAll(reportCheckRanges1);
        if (CollectionUtils.isEmpty(reportCheckRanges)) {
            return true;
        }
        List examineCheckReports = ExamineCheckServiceImpl.getInstance().multiCheck(multiExamineCheckRequest);
        log.info("{} multiCheck cost:{}ms", (Object)LOG_PREFIX, (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        stopwatch.reset();
        return this.handleCheckReport(examineCheckReports, formView, rptInfo, formPlugin, execTypeEnum);
    }

    public boolean handleCheckReport(List<ExamineCheckReport> examineCheckReports, IFormView formView, ApproveBillSubMitInfo rptInfo, IFormPlugin formPlugin, ExamineExecTypeEnum execTypeEnum) {
        boolean result = examineCheckReports.stream().anyMatch(e -> !e.getExamineCheckResultEnum().isPass());
        if (rptInfo != null) {
            formView.getPageCache().put("currBill", SerializationUtils.toJsonString((Object)rptInfo));
        }
        if (result) {
            boolean match = examineCheckReports.stream().anyMatch(e -> e.getExamineCheckResultEnum() == ExamineCheckResultEnum.NoPass);
            boolean match1 = examineCheckReports.stream().anyMatch(e -> e.getExamineCheckResultEnum() == ExamineCheckResultEnum.NoPassCanAnnotation);
            if (match) {
                formView.showTipNotification(ResManager.loadKDString((String)"\u52fe\u7a3d\u68c0\u67e5\u672a\u901a\u8fc7\u3002", (String)"BgExamineCheckCommand_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else if (match1) {
                formView.showTipNotification(ResManager.loadKDString((String)"\u52fe\u7a3d\u68c0\u67e5\u672a\u901a\u8fc7\uff0c\u4f46\u53ef\u586b\u5199\u6279\u6ce8\uff0c\u8bf7\u5bf9\u672a\u901a\u8fc7\u7684\u62a5\u544a\u586b\u5199\u6279\u6ce8\u8bf4\u660e\u3002", (String)"BgExamineCheckCommand_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                formView.showTipNotification(ExamineCheckResultEnum.OverRange.getDescription().loadKDString());
            }
            this.showExamineResult(execTypeEnum, formPlugin, formView, examineCheckReports);
            return false;
        }
        boolean match = examineCheckReports.stream().anyMatch(e -> e.getExamineCheckResultEnum() == ExamineCheckResultEnum.NoPassIgnore);
        boolean match1 = examineCheckReports.stream().allMatch(e -> e.getExamineCheckResultEnum() == ExamineCheckResultEnum.NoExamine);
        boolean match2 = examineCheckReports.stream().anyMatch(e -> ExamineCheckResultEnum.Annotation == e.getExamineCheckResultEnum());
        String sourceFrom = formView.getPageCache().get("sourceFrom");
        if (match) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u52fe\u7a3d\u68c0\u67e5\u672a\u901a\u8fc7(\u4e0d\u5f71\u54cd\u63d0\u4ea4)\u3002", (String)"BgExamineCheckCommand_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.showExamineResult(execTypeEnum, formPlugin, formView, examineCheckReports);
            if (!"excel".equals(sourceFrom)) {
                this.showExamineResult(execTypeEnum, formPlugin, formView, examineCheckReports);
                return false;
            }
        } else if (match1) {
            if (execTypeEnum != ExamineExecTypeEnum.Commit) {
                formView.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u4e0a\u52fe\u7a3d\u5173\u7cfb", (String)"ExamineCheckResultEnum_1", (String)"epm-eb-common", (Object[])new Object[0]));
            }
        } else if (match2) {
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u5f85\u5ba1\u6279\u8868\u5b58\u5728\u52fe\u7a3d\u5dee\u5f02\uff0c\u5df2\u6dfb\u52a0\u6279\u6ce8\u8bf4\u660e\uff0c\u8bf7\u5173\u6ce8\u3002", (String)"CommitExaminCheck_0", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            if (rptInfo != null) {
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)rptInfo.getApproveNote())) {
                    rptInfo.setApproveNote(rptInfo.getApproveNote() + "\r\n" + msg);
                } else {
                    rptInfo.setApproveNote(msg);
                }
                formView.getPageCache().put("currBill", SerializationUtils.toJsonString((Object)rptInfo));
            }
            formView.showSuccessNotification(ResManager.loadKDString((String)"\u52fe\u7a3d\u68c0\u67e5\u901a\u8fc7(\u6279\u6ce8\u901a\u8fc7)\u3002", (String)"BgExamineCheckCommand_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            if (!"excel".equals(sourceFrom)) {
                this.showExamineResult(execTypeEnum, formPlugin, formView, examineCheckReports);
                return false;
            }
        } else {
            formView.showSuccessNotification(ResManager.loadKDString((String)"\u52fe\u7a3d\u68c0\u67e5\u5df2\u901a\u8fc7\u3002", (String)"BgExamineCheckCommand_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return true;
    }

    public static boolean isCheckAllChild() {
        boolean verify;
        block15: {
            verify = false;
            try {
                if (!SqlBatchUtils.hasTable((String)"T_EB_PARAM")) break block15;
                SqlBuilder sql = new SqlBuilder();
                sql.append("select fid, fvalue from t_eb_param where fnumber = ?", new Object[]{"EXAMINE_CHECK_ALL_CHILD"});
                try (DataSet ds = DB.queryDataSet((String)"queryParams", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
                    if (ds != null && ds.hasNext()) {
                        Row row = ds.next();
                        verify = StringUtils.equals((String)"1", (String)row.getString("fvalue"));
                    }
                }
            }
            catch (Exception ex) {
                log.error("queryParams-error:", (Throwable)ex);
            }
        }
        return verify;
    }

    public boolean examineCheck(Collection<DynamicObject> billDynamicMap, IFormView formView, Boolean isSubmit) {
        Boolean status = Boolean.TRUE;
        HashMap<Long, EntryTemplateConfig> allTemplateConfig = new HashMap<Long, EntryTemplateConfig>(16);
        Map allDimValSetting = new HashMap(16);
        ApplyTemplateColCfgService templateColCfgService = ApplyTemplateColCfgService.getInstance();
        for (DynamicObject billDynamicObj : billDynamicMap) {
            long modelId = billDynamicObj.getLong("model.id");
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            DynamicObject schemeobj = billDynamicObj.getDynamicObject("applyscheme");
            Long schemeId = schemeobj.getLong("id");
            Long bizCtrlRangeId = schemeobj.getLong("bizrange.id");
            DynamicObject org = billDynamicObj.getDynamicObject("org");
            Long collectOrgId = billDynamicObj.getLong("collectorg.id");
            String billNumber = billDynamicObj.getString("billnumber");
            Long orgId = org.getLong("id");
            Long billId = billDynamicObj.getLong("id");
            String billType = billDynamicObj.getString("billtype");
            boolean isApplyBill = ApplyBillType.APPLY.getNumber().equals(billType);
            boolean showsubtotal = billDynamicObj.getBoolean("showsubtotal");
            FormTypeEnum formTypeEnumByBillType = templateColCfgService.getFormTypeEnumByBillType(billType);
            Map CVDMembIds = BgApplyBillUtils.getInstance().selectDVYOnBillObj(billDynamicObj);
            SchemeAssignDimGroup schemeAssignDimGroup = new SchemeAssignDimGroup(Long.valueOf(modelId), schemeId, (Long)CVDMembIds.get(SysDimensionEnum.Year.getNumber()), (Long)CVDMembIds.get(SysDimensionEnum.Version.getNumber()), (Long)CVDMembIds.get(SysDimensionEnum.DataType.getNumber()));
            Set tempIds = BgApplyBillUtils.getInstance().getTemplateByOrg(orgId, schemeId, Long.valueOf(modelId));
            Set notInitTemp = tempIds.stream().filter(id -> !allTemplateConfig.containsKey(id)).collect(Collectors.toSet());
            allDimValSetting = ReportVarUtil.getVarInfo((SchemeAssignDimGroup)schemeAssignDimGroup);
            if (!notInitTemp.isEmpty()) {
                Map templateObjs = BusinessDataServiceHelper.loadFromCache((String)"eb_applytemplate", (QFilter[])new QFilter[]{new QFilter("id", "in", notInitTemp)});
                for (Object tempObj : templateObjs.values()) {
                    EntryTemplateConfig templateConfig = ApplyTemplateUtils.convertToBaseConfig((DynamicObject)tempObj, (FormTypeEnum)formTypeEnumByBillType, (IModelCacheHelper)modelCacheHelper, allDimValSetting);
                    allTemplateConfig.put(tempObj.getLong("id"), templateConfig);
                }
            }
            ArrayList<ReportCheckRange> reportCheckRanges = new ArrayList<ReportCheckRange>(tempIds.size());
            MultiExamineCheckRequest multiExamineCheckRequest = new MultiExamineCheckRequest();
            multiExamineCheckRequest.setExecutorId(UserUtils.getUserId());
            multiExamineCheckRequest.setModelId(Long.valueOf(modelId));
            multiExamineCheckRequest.setTriggerEvent(TriggerEventEnum.APPLY_CHECK);
            multiExamineCheckRequest.setReportCheckRangeList(reportCheckRanges);
            multiExamineCheckRequest.setProcessTypeEnum(ProcessTypeEnum.APPLY);
            multiExamineCheckRequest.setVarValues(allDimValSetting);
            multiExamineCheckRequest.setCartesian(Boolean.TRUE);
            if (isApplyBill) {
                Object tempObj;
                tempObj = tempIds.iterator();
                while (tempObj.hasNext()) {
                    Long templateId = (Long)tempObj.next();
                    EntryTemplateConfig templateConfig = (EntryTemplateConfig)allTemplateConfig.get(templateId);
                    List entityData = ApplyTemplateUtils.getEntityData((String)templateConfig.getEntryTable(), (Object)billId, (List)templateConfig.getEntryColumns());
                    ReportCheckRange reportCheckRange = ApplyBillServiceHelper.getInstance().getReportCheckRang(entityData, templateConfig, Long.valueOf(modelId), CVDMembIds, billId, Boolean.valueOf(true), showsubtotal);
                    if (reportCheckRange == null) continue;
                    reportCheckRanges.add(reportCheckRange);
                }
            } else {
                String selappbills = billDynamicObj.getString("selappbills");
                Set selAppBills = StringUtil.isEmptyString((String)selappbills) ? new HashSet(16) : (Set)SerializationUtils.fromJsonString((String)selappbills, HashSet.class);
                CentralAppShowInfo showInfo = CentralAppBillService.getInstance().getCenAppInfosByEntity(billDynamicObj, collectOrgId, new ArrayList(tempIds), Long.valueOf(modelId), bizCtrlRangeId, Boolean.valueOf(true), selAppBills, Long.valueOf(schemeobj.getLong("id")), true);
                Map<String, EntryTemplateConfig> templateConfigMap = allTemplateConfig.values().stream().filter(config -> tempIds.contains(config.getTemplateID())).collect(Collectors.toMap(t -> t.getNumber(), t -> t));
                Map allRowData = BgApplyBillUtils.getInstance().getAuditBillData(showInfo, billNumber, templateConfigMap, false);
                for (Map.Entry entry1 : allRowData.entrySet()) {
                    ReportCheckRange reportCheckRange = ApplyBillServiceHelper.getInstance().getReportCheckRang((List)entry1.getValue(), templateConfigMap.get(entry1.getKey()), Long.valueOf(modelId), CVDMembIds, billId, Boolean.valueOf(false), false);
                    if (reportCheckRange == null) continue;
                    reportCheckRanges.add(reportCheckRange);
                }
                multiExamineCheckRequest.setReportCheckRangeList(reportCheckRanges);
            }
            if (new CommitExaminCheck().batchCheckApplyExamine(multiExamineCheckRequest, formView, isSubmit)) continue;
            status = false;
        }
        return status;
    }

    public boolean examineCheck2(Collection<DynamicObject> billDynamicMap, IFormView formView, String billType, CentralAppShowInfo centralAppShowInfo) {
        Boolean status = Boolean.TRUE;
        HashMap<Long, EntryTemplateConfig> allTemplateConfig = new HashMap<Long, EntryTemplateConfig>(16);
        Map allDimValSetting = new HashMap(16);
        ApplyTemplateColCfgService templateColCfgService = ApplyTemplateColCfgService.getInstance();
        for (DynamicObject billDynamicObj : billDynamicMap) {
            long modelId = billDynamicObj.getLong("model.id");
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            DynamicObject schemeobj = billDynamicObj.getDynamicObject("reportscheme");
            Long schemeId = schemeobj.getLong("id");
            DynamicObject org = billDynamicObj.getDynamicObject("reportentity");
            String billNumber = billDynamicObj.getString("billno");
            Long orgId = org.getLong("id");
            Long billId = billDynamicObj.getLong("id");
            FormTypeEnum formTypeEnumByBillType = templateColCfgService.getFormTypeEnumByBillType(billType);
            Map CVDMembIds = BgApplyBillUtils.getInstance().selectDVYOnBillObj(billDynamicObj);
            SchemeAssignDimGroup schemeAssignDimGroup = new SchemeAssignDimGroup(Long.valueOf(modelId), schemeId, (Long)CVDMembIds.get(SysDimensionEnum.Year.getNumber()), (Long)CVDMembIds.get(SysDimensionEnum.Version.getNumber()), (Long)CVDMembIds.get(SysDimensionEnum.DataType.getNumber()));
            Set tempIds = BgApplyBillUtils.getInstance().getTemplateByOrg(orgId, schemeId, Long.valueOf(modelId));
            Set notInitTemp = tempIds.stream().filter(id -> !allTemplateConfig.containsKey(id)).collect(Collectors.toSet());
            allDimValSetting = ReportVarUtil.getVarInfo((SchemeAssignDimGroup)schemeAssignDimGroup);
            if (!notInitTemp.isEmpty()) {
                Map templateObjs = BusinessDataServiceHelper.loadFromCache((String)"eb_applytemplate", (QFilter[])new QFilter[]{new QFilter("id", "in", notInitTemp)});
                for (DynamicObject tempObj : templateObjs.values()) {
                    EntryTemplateConfig templateConfig = ApplyTemplateUtils.convertToBaseConfig((DynamicObject)tempObj, (FormTypeEnum)formTypeEnumByBillType, (IModelCacheHelper)modelCacheHelper, allDimValSetting);
                    allTemplateConfig.put(tempObj.getLong("id"), templateConfig);
                }
            }
            ArrayList<ReportCheckRange> reportCheckRanges = new ArrayList<ReportCheckRange>(tempIds.size());
            MultiExamineCheckRequest multiExamineCheckRequest = new MultiExamineCheckRequest();
            multiExamineCheckRequest.setExecutorId(UserUtils.getUserId());
            multiExamineCheckRequest.setModelId(Long.valueOf(modelId));
            multiExamineCheckRequest.setTriggerEvent(TriggerEventEnum.APPLY_CHECK);
            multiExamineCheckRequest.setReportCheckRangeList(reportCheckRanges);
            multiExamineCheckRequest.setProcessTypeEnum(ProcessTypeEnum.APPLY);
            multiExamineCheckRequest.setVarValues(allDimValSetting);
            multiExamineCheckRequest.setCartesian(Boolean.valueOf(true));
            String billTypes = "";
            DynamicObject queriedOne = null;
            boolean showsubtotal = false;
            if (billDynamicObj.getBoolean("ismainbill")) {
                DynamicObjectCollection centralapprptentity = billDynamicObj.getDynamicObjectCollection("centralapprptentity");
                String sumbillno = ((DynamicObject)centralapprptentity.get(0)).getString("sumbillno");
                String billno = sumbillno.isEmpty() ? ((DynamicObject)centralapprptentity.get(0)).getString("reportbillno") : sumbillno;
                queriedOne = QueryServiceHelper.queryOne((String)"eb_bgapplybill", (String)"id", (QFilter[])new QFilter[]{new QFilter("billnumber", "=", (Object)billno)});
                if (queriedOne == null) continue;
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)queriedOne.getLong("id"), (String)"eb_bgapplybill");
                billTypes = dynamicObject.getString("billtype");
                showsubtotal = dynamicObject.getBoolean("showsubtotal");
            }
            boolean isApplyBill = ApplyBillType.APPLY.getNumber().equals(billTypes);
            Map<String, EntryTemplateConfig> templateConfigMap = allTemplateConfig.values().stream().filter(config -> tempIds.contains(config.getTemplateID())).collect(Collectors.toMap(t -> t.getNumber(), t -> t));
            Map allRowData = BgApplyBillUtils.getInstance().getAuditBillDataNew(centralAppShowInfo, billNumber, templateConfigMap, false, isApplyBill);
            for (Map.Entry entry1 : allRowData.entrySet()) {
                ReportCheckRange reportCheckRange = ApplyBillServiceHelper.getInstance().getReportCheckRang((List)entry1.getValue(), templateConfigMap.get(entry1.getKey()), Long.valueOf(modelId), CVDMembIds, billId, Boolean.valueOf(isApplyBill), isApplyBill && showsubtotal);
                if (reportCheckRange == null) continue;
                reportCheckRanges.add(reportCheckRange);
            }
            multiExamineCheckRequest.setReportCheckRangeList(reportCheckRanges);
            if (new CommitExaminCheck().batchCheckApplyExamine(multiExamineCheckRequest, formView, false)) continue;
            status = false;
        }
        return status;
    }

    public boolean batchCheckApplyExamine(MultiExamineCheckRequest multiExamineCheckRequest, IFormView formView, Boolean isSubmit) {
        List examineCheckReports = ExamineCheckServiceImpl.getInstance().multiCheck(multiExamineCheckRequest);
        boolean result = examineCheckReports.stream().anyMatch(e -> !e.getExamineCheckResultEnum().isPass());
        if (result) {
            if (formView != null) {
                boolean match = examineCheckReports.stream().anyMatch(e -> e.getExamineCheckResultEnum() == ExamineCheckResultEnum.NoPass);
                boolean match1 = examineCheckReports.stream().anyMatch(e -> e.getExamineCheckResultEnum() == ExamineCheckResultEnum.NoPassCanAnnotation);
                boolean match2 = examineCheckReports.stream().anyMatch(e -> e.getExamineCheckResultEnum() == ExamineCheckResultEnum.OverRange);
                if (match) {
                    formView.showTipNotification(ResManager.loadKDString((String)"\u52fe\u7a3d\u68c0\u67e5\u672a\u901a\u8fc7\u3002", (String)"BgExamineCheckCommand_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                } else if (match1) {
                    formView.showTipNotification(ResManager.loadKDString((String)"\u52fe\u7a3d\u68c0\u67e5\u672a\u901a\u8fc7\uff0c\u4f46\u53ef\u586b\u5199\u6279\u6ce8\uff0c\u8bf7\u5bf9\u672a\u901a\u8fc7\u7684\u62a5\u544a\u586b\u5199\u6279\u6ce8\u8bf4\u660e\u3002", (String)"BgExamineCheckCommand_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                } else if (match2) {
                    formView.showTipNotification(ResManager.loadKDString((String)"\u52fe\u7a3d\u68c0\u67e5\u4e0d\u901a\u8fc7\uff08\u68c0\u67e5\u6570\u636e\u8d85\u51fa\u8303\u56f4\uff09\u3002", (String)"BgExamineCheckCommand_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                return false;
            }
        } else {
            boolean match = examineCheckReports.stream().anyMatch(e -> e.getExamineCheckResultEnum() == ExamineCheckResultEnum.NoPassIgnore);
            boolean match1 = examineCheckReports.stream().allMatch(e -> e.getExamineCheckResultEnum() == ExamineCheckResultEnum.NoExamine);
            boolean match2 = examineCheckReports.stream().allMatch(e -> e.getExamineCheckResultEnum() == ExamineCheckResultEnum.Annotation);
            if (match) {
                if (formView != null) {
                    formView.showTipNotification(ResManager.loadKDString((String)"\u52fe\u7a3d\u68c0\u67e5\u672a\u901a\u8fc7(\u4e0d\u5f71\u54cd\u63d0\u4ea4)\u3002", (String)"BgExamineCheckCommand_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            } else if (match1) {
                if (!isSubmit.booleanValue()) {
                    formView.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u4e0a\u52fe\u7a3d\u5173\u7cfb\u3002", (String)"BgExamineCheckCommand_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            } else if (match2) {
                formView.showTipNotification(ResManager.loadKDString((String)"\u52fe\u7a3d\u68c0\u67e5\u901a\u8fc7(\u6279\u6ce8\u901a\u8fc7)\u3002", (String)"BgExamineCheckCommand_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                formView.showSuccessNotification(ResManager.loadKDString((String)"\u52fe\u7a3d\u68c0\u67e5\u5df2\u901a\u8fc7\u3002", (String)"BgExamineCheckCommand_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        return true;
    }

    public void showExamineResult(ExamineExecTypeEnum execTypeEnum, IFormPlugin formPlugin, IFormView formView, List<ExamineCheckReport> examineCheckReports) {
        String sourceFrom = formView.getPageCache().get("sourceFrom");
        if ("excel".equals(sourceFrom)) {
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCustomParam("examineCheckReport", (Object)SerializationUtils.toJsonString(examineCheckReports));
        if (ExamineExecTypeEnum.Commit == execTypeEnum) {
            formShowParameter.setCustomParam("key", (Object)"commit");
        } else if (ExamineExecTypeEnum.CheckInList == execTypeEnum) {
            formShowParameter.setCustomParam("key", (Object)"checkinlist");
        }
        if (formPlugin instanceof ReportPreparationListPlugin) {
            Long schemeId = ((ReportPreparationListPlugin)formPlugin).getSchemeId();
            if (schemeId != null) {
                formShowParameter.setCustomParam("schemeOrTaskId", (Object)schemeId.toString());
            }
            formShowParameter.setCustomParam("model", (Object)((ReportPreparationListPlugin)formPlugin).getModelId());
        } else if (formPlugin instanceof BgTaskExecutePlugin) {
            String taskId = formView.getPageCache().get("current_taskp");
            formShowParameter.setCustomParam("schemeOrTaskId", (Object)taskId);
            formShowParameter.setCustomParam("model", (Object)((BgTaskExecutePlugin)formPlugin).getModelId());
        } else if (formPlugin instanceof ApproveBillListPlugin) {
            formShowParameter.setCustomParam("model", (Object)((ApproveBillListPlugin)formPlugin).getModelId());
        } else if (formPlugin instanceof ReportSubmitRangePlugin) {
            formShowParameter.setCustomParam("model", (Object)((ReportSubmitRangePlugin)formPlugin).getModelId());
        }
        String reportOrTaskPojoJsonString = CacheUtils.get((IPageCache)formView.getPageCache(), (String)ReportOrTaskPojo.class.getName());
        if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)reportOrTaskPojoJsonString)) {
            formShowParameter.setCustomParam(ReportOrTaskPojo.class.getName(), (Object)reportOrTaskPojoJsonString);
        }
        formShowParameter.setFormId("eb_examine_result");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u52fe\u7a3d\u68c0\u67e5\u7ed3\u679c", (String)"EbExamineEditPlugin_61", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setParentPageId(formView.getPageId());
        formShowParameter.setPageId(formView.getPageId() + "eb_examine_result");
        formShowParameter.setCloseCallBack(new CloseCallBack(formPlugin, "examineCheckResult"));
        formView.showForm(formShowParameter);
    }
}

