/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.approveBill;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.CellStyle;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.epm.eb.business.approveBill.ApproveBillAutoCreate;
import kd.epm.eb.business.approveBill.ApproveBillAutoCreateEB;
import kd.epm.eb.business.approveBill.helper.ApproveBillSubmitHelper;
import kd.epm.eb.business.approvetype.ApproveUtils;
import kd.epm.eb.business.bailorg.BailOrgService;
import kd.epm.eb.business.bailorg.pojo.BailOrgRelation;
import kd.epm.eb.business.task.service.BgTaskDeployListService;
import kd.epm.eb.common.approveBill.ApproveBillCommon;
import kd.epm.eb.common.approveBill.Entity.ApproveBillRptTemp;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitDim;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitInfo;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitInfoEB;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgConstant;
import kd.epm.eb.common.ebcommon.common.enums.RangeEnum;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.reportprocess.entity.dto.RptSubmitResult;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessServiceImpl;
import kd.epm.eb.common.utils.ApproveBill.BasicInfoHelper;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.controlParamsSetting.ControlParamsSettingUtil;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.approveBill.ApproveOptimization;
import kd.epm.eb.formplugin.approveBill.CommitCommandUtil;
import kd.epm.eb.formplugin.excel.ExcelFormView;
import org.apache.commons.lang3.StringUtils;

public class DimRangeSelect
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(DimRangeSelect.class);
    private static final String TO_SUBMIT_BILLS = "toSubmitBills";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "switchdept", "btn_copydesc"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.fillUserInfo();
        this.fillOtherInfo();
        this.setOtherParams();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ApproveBillSubMitInfo rptInfo = this.getApproveBill();
        if (!rptInfo.isSubmitInApproveBill()) {
            return;
        }
        int rowCount = this.getModel().getEntryRowCount("tempentry");
        if (rowCount <= 0) {
            return;
        }
        int[] rows = new int[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            rows[i] = i;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("tempentry");
        entryGrid.selectRows(rows, 0);
    }

    private void fillUserInfo() {
        IDataModel dataModel = this.getModel();
        dataModel.setValue("applier", (Object)UserUtils.getUserId());
        BasicInfoHelper.setFormInfo((IDataModel)dataModel, (IFormView)this.getView(), (boolean)true);
        DynamicObject object = (DynamicObject)dataModel.getValue("applier");
        if (object == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\u3002", (String)"EbAdjustBillEditPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Label label = (Label)this.getControl("appliertag");
        label.setText(object.getString("name"));
        label = (Label)this.getControl("userphone");
        label.setText(object.getString("phone"));
        Image pic = (Image)this.getControl("userpic");
        Long userId = object.getLong("id");
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(userId);
        Map userPics = UserServiceHelper.getUserAvatarPath(userIds, (boolean)true);
        pic.setUrl((String)userPics.get(userId));
    }

    private void setOtherParams() {
        ApproveBillSubMitInfo rptInfo = this.getApproveBill();
        IDataModel dataModel = this.getModel();
        rptInfo.setCreaterId(UserUtils.getUserId());
        Label label = null;
        DynamicObject dynamicObjectCompany = (DynamicObject)dataModel.getValue("company");
        rptInfo.setCreateOrgId(Long.valueOf(dynamicObjectCompany == null ? 0L : ((DynamicObject)dataModel.getValue("company")).getLong("id")));
        if (dynamicObjectCompany != null && (label = (Label)this.getControl("companytag")) != null) {
            label.setText(dynamicObjectCompany.getString("name"));
        } else if (dynamicObjectCompany == null && (label = (Label)this.getControl("companytag")) != null) {
            label.setText("");
        }
        rptInfo.setDepartment(Long.valueOf((DynamicObject)dataModel.getValue("department") == null ? 0L : ((DynamicObject)dataModel.getValue("department")).getLong("id")));
        rptInfo.setPosition(dataModel.getValue("position") == null ? "" : dataModel.getValue("position").toString());
        rptInfo.setApproveNote(dataModel.getValue("approveinfo") == null ? "" : dataModel.getValue("approveinfo").toString());
        this.getPageCache().put("rptinfo", ObjectSerialUtil.toByteSerialized((Object)rptInfo));
        if (!rptInfo.isSubmitInApproveBill()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"descpanel"});
        }
    }

    private void fillOtherInfo() {
        ApproveBillSubMitInfo rptInfo = this.getApproveBill();
        this.fillBaseCtrl(rptInfo);
        this.fillOrgCtrl(rptInfo);
        this.fillTempEntry(rptInfo);
    }

    protected ApproveBillSubMitInfo getApproveBill() {
        ApproveBillSubMitInfo rptInfo = null;
        String rptInfoCache = this.getPageCache().get("rptinfo");
        if (StringUtils.isEmpty((CharSequence)rptInfoCache)) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            rptInfo = (ApproveBillSubMitInfo)ObjectSerialUtil.deSerializedBytes((String)((String)formShowParameter.getCustomParam("rptinfo")));
        } else {
            rptInfo = (ApproveBillSubMitInfo)ObjectSerialUtil.deSerializedBytes((String)rptInfoCache);
        }
        Object approveinfo = this.getModel().getValue("approveinfo");
        if (approveinfo instanceof String) {
            if (StringUtils.isEmpty((CharSequence)approveinfo.toString()) && StringUtils.isNotEmpty((CharSequence)rptInfo.getApproveNote())) {
                this.getModel().setValue("approveinfo", (Object)rptInfo.getApproveNote());
            } else {
                rptInfo.setApproveNote((String)approveinfo);
            }
        }
        return rptInfo;
    }

    private void fillBaseCtrl(ApproveBillSubMitInfo rptInfo) {
        this.getModel().setValue("baseperiod", (Object)rptInfo.getSubmitDims().getYearPeriodId());
        this.getModel().setValue("basedatatype", (Object)rptInfo.getSubmitDims().getDataTypeId());
        this.getModel().setValue("baseversion", (Object)rptInfo.getSubmitDims().getVersionId());
    }

    private void fillOrgCtrl(ApproveBillSubMitInfo rptInfo) {
        Member entityMember = ApproveBillCommon.getOrgMember((ApproveBillSubMitInfo)rptInfo, null);
        if (entityMember == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u7ec4\u7ec7ID\u201c%1\u201d\u4e0d\u5b58\u5728\u3002", (String)"DimRangeSelect_4", (String)"epm-eb-formplugin", (Object[])new Object[]{rptInfo.getSubmitDims().getOrgId()}));
        }
        this.getModel().setValue("orgtext", (Object)StringUtils.join((Object[])new String[]{entityMember.getNumber(), " (", entityMember.getName(), ")", RangeEnum.getRangeByVal((int)50).getName()}));
        this.fillBailOrg(rptInfo, entityMember);
    }

    private void fillBailOrg(ApproveBillSubMitInfo rptInfo, Member member) {
        BailOrgRelation bailOrgRelation = BailOrgService.getInstance().getBailOrgRelation(rptInfo.getSubmitDims().getModelId(), member.getNumber());
        if (bailOrgRelation != null) {
            Long bailOrgId = bailOrgRelation.getDefaultBailId();
            this.getModel().setValue("bailorg", (Object)new Object[]{bailOrgId});
        }
    }

    private void fillTempEntry(ApproveBillSubMitInfo rptInfo) {
        Collection rptTemps = rptInfo.getRptTemps();
        if (rptTemps == null || rptTemps.size() == 0) {
            return;
        }
        TableValueSetter tableValueSetter = new TableValueSetter(new String[]{"tempnumber"});
        Set tempids = ApproveBillCommon.getTempIds((Collection)rptTemps);
        Set subTaskIds = rptTemps.stream().map(ApproveBillRptTemp::getSubTaskId).collect(Collectors.toSet());
        Map subTaskName = BgTaskDeployListService.getInstance().getSubTaskName(subTaskIds);
        this.getModel().beginInit();
        for (Long tempid : tempids) {
            tableValueSetter.addRow(new Object[]{tempid});
        }
        HashMap<String, Set<Integer>> map = new HashMap<String, Set<Integer>>(16);
        this.getModel().deleteEntryData("tempentry");
        int i = 0;
        this.getModel().batchCreateNewEntryRow("tempentry", rptTemps.size());
        for (ApproveBillRptTemp approveBillRptTemp : rptTemps) {
            this.getModel().setValue("tempnumber", (Object)approveBillRptTemp.getTempId(), i);
            this.getModel().setValue("taskname", subTaskName.get(approveBillRptTemp.getSubTaskId()), i);
            this.getModel().setValue("temporg", (Object)approveBillRptTemp.getOrgId(), i);
            this.getModel().setValue("approvedesc", (Object)approveBillRptTemp.getApproveDesc(), i);
            String status = approveBillRptTemp.getStatus();
            Set statusSet = map.computeIfAbsent(status, v -> Sets.newLinkedHashSet());
            statusSet.add(i);
            this.getModel().setValue("status", (Object)this.getBgTaskStateDesc(status), i);
            ++i;
        }
        this.getModel().endInit();
        this.setStateColor(map);
        this.getView().updateView("tempentry");
        this.getView().setVisible(Boolean.valueOf(subTaskName.size() > 0), new String[]{"taskname"});
    }

    private void setStateColor(Map<String, Set<Integer>> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        ArrayList styleList = new ArrayList(16);
        for (Map.Entry<String, Set<Integer>> entry : map.entrySet()) {
            String key = entry.getKey();
            Set<Integer> value = entry.getValue();
            String[] color = new String[]{""};
            color[0] = BgTaskStateEnum.UNPREPARED.getNumber().equals(key) || BgTaskStateEnum.INCOMPLETE.getNumber().equals(key) ? BgConstant.COLOR[0] : (BgTaskStateEnum.COMPLETED.getNumber().equals(key) ? BgConstant.COLOR[1] : BgConstant.COLOR[2]);
            value.forEach(it -> {
                CellStyle style = new CellStyle();
                style.setFieldKey("status");
                style.setRow(it.intValue());
                style.setForeColor(color[0]);
                styleList.add(style);
            });
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("tempentry");
        entryGrid.setCellStyle(styleList);
    }

    private String getBgTaskStateDesc(String status) {
        if (BgTaskStateEnum.INCOMPLETE.getNumber().equals(status)) {
            return ResManager.loadKDString((String)"\u5ba1\u6838\u672a\u901a\u8fc7", (String)"BgTaskExecutePlugin_98", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        for (BgTaskStateEnum value : BgTaskStateEnum.values()) {
            if (!StringUtils.equals((CharSequence)value.getNumber(), (CharSequence)status)) continue;
            return value.getName();
        }
        return "";
    }

    private Object[] createApproveBillAuto(ApproveBillSubMitInfo rptInfo) {
        Object[] approveBillIds = null;
        if (rptInfo instanceof ApproveBillSubMitInfo) {
            approveBillIds = new ApproveBillAutoCreate().createApproveBillAuto(rptInfo);
        }
        if (rptInfo instanceof ApproveBillSubMitInfoEB) {
            approveBillIds = new ApproveBillAutoCreateEB().createApproveBillAuto(rptInfo);
        }
        return approveBillIds;
    }

    @Override
    public void beforeClick(BeforeClickEvent evt) {
        String commitMsg;
        super.beforeClick(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (!"btnok".equals(key)) {
            return;
        }
        ApproveBillSubMitInfo rptInfo = this.getApproveBill();
        if (rptInfo.isSubmitInApproveBill()) {
            Long tempId;
            EntryGrid entryGrid = (EntryGrid)this.getControl("tempentry");
            int[] rows = entryGrid.getSelectRows();
            if (rows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u63d0\u4ea4\u7684\u62a5\u8868\u3002", (String)"", (String)"", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            HashSet<Long> tempIds = new HashSet<Long>(16);
            for (int row : rows) {
                tempId = (Long)this.getEntryValue("tempentry", "tempnumber", "id", row);
                tempIds.add(tempId);
            }
            if (tempIds.size() == 0) {
                return;
            }
            Collection rptTemps = rptInfo.getRptTemps();
            ArrayList<ApproveBillRptTemp> rptTemps_new = new ArrayList<ApproveBillRptTemp>(16);
            for (ApproveBillRptTemp rptTemp : rptTemps) {
                tempId = rptTemp.getTempId();
                if (!tempIds.contains(tempId)) continue;
                rptTemps_new.add(rptTemp);
            }
            if (rptTemps_new.size() == 0) {
                return;
            }
            rptInfo.setRptTemps(rptTemps_new);
            rptInfo.getSubmitDims().setTempIds(tempIds);
            this.getPageCache().put("rptinfo", ObjectSerialUtil.toByteSerialized((Object)rptInfo));
        }
        if (ControlParamsSettingUtil.forbidCommitParent((Long)rptInfo.getSubmitDims().getModelId()) && StringUtils.isNotEmpty((CharSequence)(commitMsg = CommitCommandUtil.checkChildrenApproveBill(rptInfo)))) {
            this.getView().showMessage("", commitMsg, MessageTypes.Default);
            evt.setCancel(true);
            return;
        }
        this.createAndSaveBills();
    }

    public void click(EventObject evt) {
        try {
            super.click(evt);
            String key = ((Control)evt.getSource()).getKey();
            if ("btnok".equals(key)) {
                ApproveBillSubMitInfo rptInfo = this.getApproveBill();
                log.info("submitReport_submitBills");
                List toSubmitBills = (List)this.getCache(TO_SUBMIT_BILLS, ArrayList.class, () -> new ArrayList(16));
                this.submitBills(toSubmitBills, rptInfo);
                log.info("submitReport_ok");
            } else if ("switchdept".equals(key)) {
                this.selectDept();
            } else if ("btn_copydesc".equals(key)) {
                this.openCopyDescPage();
            }
        }
        catch (KDBizException e) {
            throw e;
        }
        catch (Exception ex) {
            log.info(StringUtils.join((Object[])new String[]{"submitReport_fail!", ex.getMessage(), Arrays.toString(ex.getStackTrace())}));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u62a5\u8868\u63d0\u4ea4\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7:traceId[%1$s]", (String)"DimRangeSelect_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), RequestContext.get().getTraceId()));
        }
    }

    protected void submitBill() {
        log.info("submitReport_getApproveBill");
        ApproveBillSubMitInfo rptInfo = this.getApproveBill();
        this.checkPerm(rptInfo);
        log.info("submitReport_checkReportProcess");
        if (!this.checkReportProcess(rptInfo).booleanValue()) {
            return;
        }
        Object[] approveBillIds = null;
        log.info("submitReport_addBailOrg");
        this.addBailOrg(rptInfo);
        log.info("submitReport_createApproveBillAuto");
        approveBillIds = this.createApproveBillAuto(rptInfo);
        log.info("submitReport_submitBills");
        this.submitBills(approveBillIds, rptInfo);
        log.info("submitReport_ok");
    }

    protected void createAndSaveBills() {
        log.info("submitReport_getApproveBill");
        ApproveBillSubMitInfo rptInfo = this.getApproveBill();
        this.checkPerm(rptInfo);
        log.info("submitReport_checkReportProcess");
        if (!this.checkReportProcess(rptInfo).booleanValue()) {
            return;
        }
        Object[] approveBillIds = null;
        log.info("submitReport_addBailOrg");
        this.addBailOrg(rptInfo);
        log.info("submitReport_createApproveBillAuto");
        approveBillIds = this.createApproveBillAuto(rptInfo);
        List approveBillIdList = Arrays.stream(approveBillIds).map(p -> ((DynamicObject)p).getLong("id")).collect(Collectors.toList());
        this.putCache(TO_SUBMIT_BILLS, approveBillIdList);
    }

    protected void addBailOrg(ApproveBillSubMitInfo rptInfo) {
        Object bailOrgObj = this.getModel().getValue("bailorg");
        if (bailOrgObj instanceof DynamicObjectCollection) {
            DynamicObjectCollection bailOrg = (DynamicObjectCollection)bailOrgObj;
            Set bailOrgSet = bailOrg.stream().map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toSet());
            rptInfo.setBailOrgIds(bailOrgSet);
        }
    }

    private void openCopyDescPage() {
        ApproveBillSubMitInfo approveBill = this.getApproveBill();
        if (approveBill == null) {
            return;
        }
        ApproveBillSubMitDim submitDims = approveBill.getSubmitDims();
        if (submitDims == null) {
            return;
        }
        ApproveOptimization.getInstance().openBatchSetPage(this.getView(), this.getPluginName(), this.getInvisibleKeys(), submitDims.getModelId(), "tempentry");
    }

    private String getInvisibleKeys() {
        ArrayList<String> invisibleKeys = new ArrayList<String>(16);
        invisibleKeys.add("needreject");
        invisibleKeys.add("mustreject");
        invisibleKeys.add("opinion");
        return SerializationUtils.toJsonString(invisibleKeys);
    }

    private Boolean checkReportProcess(ApproveBillSubMitInfo rptInfo) {
        ApproveBillSubMitDim submitDims;
        if (rptInfo != null && (submitDims = rptInfo.getSubmitDims()) != null) {
            Set tempIds = submitDims.getTempIds();
            HashSet<Long> entityIds = new HashSet<Long>(16);
            entityIds.add(submitDims.getOrgId());
            List list = ReportProcessServiceImpl.getInstance().getReportProcessList(submitDims.getModelId(), submitDims.getViewId(), entityIds, tempIds, submitDims.getYearPeriodId(), submitDims.getDataTypeId(), submitDims.getVersionId());
            if (list.size() != tempIds.size()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u5b9e\u4f8b\u4e0d\u5b58\u5728\u3002", (String)"ExportCommand_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        return true;
    }

    private void selectDept() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setShowTitle(true);
        formShowParameter.setFormId("eb_userdeptlist");
        Object user = this.getModel().getValue("applier");
        Object dept = this.getModel().getValue("department");
        String position = (String)this.getModel().getValue("position");
        if (user instanceof DynamicObject) {
            formShowParameter.setCustomParam("user", (Object)((DynamicObject)user).getString("id"));
            if (dept instanceof DynamicObject) {
                formShowParameter.setCustomParam("dept.id", (Object)((DynamicObject)dept).getString("id"));
                if (position != null) {
                    formShowParameter.setCustomParam("position", (Object)position);
                }
            }
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "switchdept"));
        this.getView().showForm(formShowParameter);
    }

    private void submitBills(Object[] approveBillIds, ApproveBillSubMitInfo rptInfo) {
        if (approveBillIds != null && approveBillIds.length > 0) {
            List<Long> approveBillIdList = Arrays.stream(approveBillIds).map(p -> ((DynamicObject)p).getLong("id")).collect(Collectors.toList());
            this.submitBills(approveBillIdList, rptInfo);
        }
    }

    private void submitBills(List<Long> toSubmitBills, ApproveBillSubMitInfo rptInfo) {
        if (toSubmitBills != null && toSubmitBills.size() > 0) {
            String appid = ApproveBillCommon.getAppId((ApproveBillSubMitInfo)rptInfo);
            String formId = ApproveBillCommon.getFormId((ApproveBillSubMitInfo)rptInfo);
            log.info(StringUtils.join((Object[])new String[]{"submitReport_appid:", appid, formId}));
            OperateOption op = OperateOption.create();
            this.addApproveDesc(op);
            op.setVariableValue("currbizappid", appid);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btnok", "btncancel"});
            OperationResult operationResult = null;
            String viewFormId = this.getView().getFormShowParameter().getFormId();
            if (toSubmitBills.size() > 1 || StringUtils.isBlank((CharSequence)viewFormId)) {
                operationResult = ApproveBillSubmitHelper.getInstance().submitApproveBillWithShowMessage(this.getView(), appid, formId, rptInfo.getSubmitDims().getModelId(), new HashSet<Long>(toSubmitBills), op);
            } else {
                this.showApproveBillFormInContainer(toSubmitBills.get(0), formId, op);
            }
            if (operationResult != null) {
                RptSubmitResult rptSubmitResult = new RptSubmitResult();
                String submitType = (String)this.getView().getFormShowParameter().getCustomParam("submitType");
                rptSubmitResult.setSubmitType(submitType);
                if (StringUtils.isBlank((CharSequence)viewFormId)) {
                    this.showEpmOperationResult(operationResult);
                }
                Set pkIds = operationResult.getSuccessPkIds().stream().map(ConvertUtils::toLong).collect(Collectors.toSet());
                ApproveUtils.getInstance().saveSubmitInfos(pkIds);
                ApproveUtils.getInstance().saveApproveBillAuditType(pkIds);
                Set approveReportProcessIds = ApproveUtils.getInstance().getApproveReportProcessIds(pkIds);
                ApproveUtils.getInstance().updateRejectBillStatus(pkIds, (Collection)approveReportProcessIds);
                ApproveBillSubMitInfo approveBill = this.getApproveBill();
                String passiveCommitMsg = CommitCommandUtil.checkChildPassiveCommit(approveBill, operationResult.getSuccessPkIds());
                rptSubmitResult.setPassiveCommitMsg(passiveCommitMsg);
                operationResult.setSuccessPkIds(new ArrayList(16));
                rptSubmitResult.setOpResult(SerializationUtils.toJsonString((Object)operationResult));
                if (StringUtils.isBlank((CharSequence)viewFormId) && StringUtils.isNotEmpty((CharSequence)passiveCommitMsg)) {
                    String title = ResManager.loadKDString((String)"\u63d0\u4ea4\u4e0a\u7ea7\u7ec4\u7ec7\u7684\u62a5\u8868\u4f1a\u5c06\u4e0b\u7ea7\u7ec4\u7ec7\u672a\u63d0\u4ea4\u7684\u62a5\u8868\u4e00\u8d77\u63d0\u4ea4\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"DimRangeSelect_2", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    ((ExcelFormView)this.getView()).showMessage(title, passiveCommitMsg, true);
                }
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)rptSubmitResult));
                this.getView().close();
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5ba1\u6279\u5355\u521b\u5efa\u5931\u8d25\u3002", (String)"BgDimRangeSelect_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        log.info("submitReport_aftersubmitBills");
    }

    protected void addApproveDesc(OperateOption op) {
        DynamicObjectCollection entity = this.getModel().getEntryEntity("tempentry");
        HashMap<String, String> descMap = new HashMap<String, String>(16);
        for (DynamicObject dynamicObject : entity) {
            String approveDesc = dynamicObject.getString("approvedesc");
            if (StringUtils.isEmpty((CharSequence)approveDesc)) continue;
            DynamicObject temp = dynamicObject.getDynamicObject("tempnumber");
            descMap.put(temp.getString("id"), approveDesc);
        }
        op.setVariableValue("descInfo", SerializationUtils.toJsonString(descMap));
        log.info("submitReport_aftersubmitBills");
    }

    private void showApproveBillFormInContainer(Object id, String formId, OperateOption option) {
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.getOpenStyle().setTargetKey("approvebill");
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.setPkId(id);
        formShowParameter.setCustomParam("from", (Object)"dimrangeselect");
        formShowParameter.setCustomParam("descInfo", (Object)option.getVariableValue("descInfo"));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dimrangeselect"));
        formShowParameter.setCustomParam("model", CommonServiceHelper.getValueFromDB((String)formId, (String)"modelid", (String)"id", (Object[])new Object[]{id}));
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void checkPerm(ApproveBillSubMitInfo rptInfo) {
        String appid = null;
        String formId = ApproveBillCommon.getFormId((ApproveBillSubMitInfo)rptInfo);
        IFormView view = this.getView();
        if (view != null) {
            appid = view.getFormShowParameter().getAppId();
        }
        if (appid == null || !appid.equals(ApplicationTypeEnum.BGRP.getAppnum())) {
            appid = ApproveBillCommon.getAppId((ApproveBillSubMitInfo)rptInfo);
        }
        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"EPMPermissionService", (String)"checkPermission", (Object[])new Object[]{rptInfo.getSubmitDims().getModelId(), UserUtils.getUserId(), AppMetadataCache.getAppInfo((String)appid).getId(), formId, "btn_submit"});
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("switchdept".equals(actionId)) {
            String data = (String)closedCallBackEvent.getReturnData();
            if (data != null) {
                IDataModel dataModel = this.getModel();
                Map dataMap = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                BasicInfoHelper.setFormInfo((IDataModel)dataModel, (IFormView)this.getView(), (Map)dataMap);
                this.setOtherParams();
            }
        } else if ("batchSet".equals(actionId)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            Map retData = (Map)SerializationUtils.fromJsonString((String)returnData.toString(), HashMap.class);
            EntryGrid entryGrid = (EntryGrid)this.getControl("tempentry");
            int[] rows = entryGrid.getSelectRows();
            if (rows.length == 0) {
                return;
            }
            String submitDesc = retData.getOrDefault("submitdesc", "");
            for (int row : rows) {
                this.getModel().setValue("approvedesc", (Object)submitDesc, row);
            }
        } else if ("dimrangeselect".equals(actionId)) {
            if (closedCallBackEvent.getReturnData() != null) {
                Object returnData = closedCallBackEvent.getReturnData();
                Map returnDataMap = (Map)returnData;
                String submitResult = (String)returnDataMap.get("submitResult");
                RptSubmitResult rptSubmitResult = new RptSubmitResult();
                if (StringUtils.isNotBlank((CharSequence)submitResult)) {
                    OperationResult operationResult = (OperationResult)SerializationUtils.deSerializeFromBase64((String)submitResult);
                    FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                    String submitType = (String)formShowParameter.getCustomParam("submitType");
                    if (!operationResult.isSuccess() || operationResult.isShowMessage() && StringUtils.isNotBlank((CharSequence)operationResult.getMessage())) {
                        rptSubmitResult.setOpResult(SerializationUtils.toJsonString((Object)operationResult));
                    }
                    rptSubmitResult.setSubmitType(submitType);
                    List successPkIds = operationResult.getSuccessPkIds();
                    if (StringUtils.isBlank((CharSequence)this.getView().getFormShowParameter().getFormId())) {
                        this.showEpmOperationResult(operationResult);
                    }
                    ApproveBillSubMitInfo approveBill = this.getApproveBill();
                    String passiveCommitMsg = CommitCommandUtil.checkChildPassiveCommit(approveBill, successPkIds);
                    rptSubmitResult.setPassiveCommitMsg(passiveCommitMsg);
                    if (StringUtils.isBlank((CharSequence)this.getView().getFormShowParameter().getFormId()) && StringUtils.isNotEmpty((CharSequence)passiveCommitMsg)) {
                        String title = ResManager.loadKDString((String)"\u63d0\u4ea4\u4e0a\u7ea7\u7ec4\u7ec7\u7684\u62a5\u8868\u4f1a\u5c06\u4e0b\u7ea7\u7ec4\u7ec7\u672a\u63d0\u4ea4\u7684\u62a5\u8868\u4e00\u8d77\u63d0\u4ea4\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"DimRangeSelect_2", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                        ((ExcelFormView)this.getView()).showMessage(title, passiveCommitMsg, true);
                    }
                    this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)rptSubmitResult));
                    this.getView().close();
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"DimRangeSelect_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"btnok", "btncancel"});
        }
    }

    public void showEpmOperationResult(OperationResult operationResult) {
        if (operationResult.isSuccess()) {
            if (operationResult.isShowMessage() && StringUtils.isNotBlank((CharSequence)operationResult.getMessage())) {
                this.getView().showSuccessNotification(operationResult.getMessage());
            } else {
                String title = ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"ApproveBillList_001", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.getView().showSuccessNotification(title);
            }
        } else if (operationResult.isShowMessage() && StringUtils.isNotBlank((CharSequence)operationResult.getMessage())) {
            this.getView().showTipNotification(operationResult.getMessage());
        } else {
            String title = ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\u3002", (String)"ApproveBillList_002", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(title);
        }
    }
}

