/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.approveBill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.Control;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.approveBill.Entity.ApproveBillRptTemp;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitInfo;
import kd.epm.eb.common.examine.domain.report.ExamineCheckReport;
import kd.epm.eb.common.examine.enums.ExamineCheckResultEnum;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.approveBill.MetricNotNullCheckUtils;
import org.apache.commons.collections4.CollectionUtils;

public class MetricNotNullCheckPlugin
extends AbstractListPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_commit"});
    }

    public void afterCreateNewData(EventObject e) {
        this.initData();
    }

    private void initData() {
        Collection<ApproveBillRptTemp> rptTemps;
        String examineCheckReportJson = (String)this.getView().getFormShowParameter().getCustomParam("examineCheckReport");
        List examineCheckReports = SerializationUtils.fromJsonStringToList((String)examineCheckReportJson, ExamineCheckReport.class);
        if (CollectionUtils.isEmpty((Collection)examineCheckReports)) {
            return;
        }
        String rptInfoJson = (String)this.getView().getFormShowParameter().getCustomParam("rptInfo");
        if (StringUtils.isEmpty((String)rptInfoJson)) {
            rptTemps = new ArrayList(16);
            Set rptIds = examineCheckReports.stream().map(ExamineCheckReport::getReportProcessId).collect(Collectors.toSet());
            DynamicObjectCollection rptCollections = QueryServiceHelper.query((String)"eb_reportprocess", (String)"id, entity", (QFilter[])new QFilter[]{new QFilter("id", "in", rptIds)});
            HashMap rptEntityIdMap = new HashMap(16);
            for (DynamicObject rptCollection : rptCollections) {
                rptEntityIdMap.put(rptCollection.getLong("id"), rptCollection.getLong("entity"));
            }
            for (ExamineCheckReport examineCheckReport : examineCheckReports) {
                ApproveBillRptTemp approveBillRptTemp = new ApproveBillRptTemp();
                approveBillRptTemp.setRptId(examineCheckReport.getReportProcessId());
                approveBillRptTemp.setTempId(examineCheckReport.getTemplateId());
                approveBillRptTemp.setOrgId((Long)rptEntityIdMap.get(examineCheckReport.getReportProcessId()));
                rptTemps.add(approveBillRptTemp);
            }
        } else {
            ApproveBillSubMitInfo rptInfo = (ApproveBillSubMitInfo)SerializationUtils.fromJsonString((String)rptInfoJson, ApproveBillSubMitInfo.class);
            if (rptInfo == null) {
                return;
            }
            rptTemps = rptInfo.getRptTemps();
        }
        if (CollectionUtils.isEmpty(rptTemps)) {
            return;
        }
        ArrayList checkList = new ArrayList(16);
        int overRangeCheck = 0;
        Long modelId = ((ExamineCheckReport)examineCheckReports.get(0)).getModelId();
        for (ApproveBillRptTemp rptTemp : rptTemps) {
            Optional<ExamineCheckReport> first = examineCheckReports.stream().filter(x -> x.getReportProcessId().equals(rptTemp.getRptId())).findFirst();
            if (!first.isPresent()) continue;
            ExamineCheckReport examineCheckReport = first.get();
            HashMap<String, Object> temp = new HashMap<String, Object>(3);
            temp.put("entity", rptTemp.getOrgId());
            temp.put("template", rptTemp.getTempId());
            if (examineCheckReport.getExamineCheckResultEnum() == ExamineCheckResultEnum.OverRange) {
                temp.put("checkresult", ResManager.loadKDString((String)"\u5ea6\u91cf\u5fc5\u5f55\u6821\u9a8c\u7684\u6570\u636e\u7684\u5927\u5c0f\u8d85\u8fc7100\u4e07\uff0c\u65e0\u6cd5\u81ea\u52a8\u6821\u9a8c\u9700\u81ea\u884c\u9a8c\u8bc1", (String)"MetricNotNullCheckPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                ++overRangeCheck;
            } else {
                temp.put("checkresult", MetricNotNullCheckUtils.getNullMertic(examineCheckReport.getExamineCheckResultForExamineList(), modelId));
            }
            checkList.add(temp);
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_commit"});
        if (CollectionUtils.isNotEmpty(checkList)) {
            this.getModel().beginInit();
            this.getModel().batchCreateNewEntryRow("entryentity", checkList.size());
            for (int i = 0; i < checkList.size(); ++i) {
                Map map = (Map)checkList.get(i);
                this.getModel().setValue("entity", map.get("entity"), i);
                this.getModel().setValue("template", map.get("template"), i);
                this.getModel().setValue("checkresult", map.get("checkresult"), i);
            }
            this.getModel().endInit();
            if (overRangeCheck == checkList.size()) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_commit"});
            }
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btn_commit".equals(key)) {
            this.getView().returnDataToParent((Object)"needCheckMetricNotNull");
            this.getView().close();
        }
    }
}

