/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.approveBill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.epm.eb.common.approveBill.Entity.ApproveBillRptTemp;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitInfo;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.ebcommon.common.enums.dimension.SysDimensionEnum;
import kd.epm.eb.common.examine.domain.report.ExamineCheckReport;
import kd.epm.eb.common.examine.domain.report.ExamineCheckResultForExamine;
import kd.epm.eb.common.examine.enums.ExamineCheckResultEnum;
import kd.epm.eb.common.utils.StringUtils;
import org.apache.commons.collections4.CollectionUtils;

public class MetricNotNullCheckUtils {
    public static String getNullMertic(List<ExamineCheckResultForExamine> list, Long modelId) {
        if (CollectionUtils.isEmpty(list)) {
            return "";
        }
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)modelId);
        if (orCreate == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u586b\u5fc5\u5f55\u5ea6\u91cf\uff1a", (String)"MetricNotNullCheckPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        for (ExamineCheckResultForExamine examineCheckResultForExamine : list) {
            Member member;
            String[] split;
            String examineNumber;
            if (examineCheckResultForExamine.getExamineCheckResultEnum().isPass() || !StringUtils.isNotEmpty((String)(examineNumber = examineCheckResultForExamine.getExamineNumber())) || (split = examineNumber.split("_")).length != 3 || (member = orCreate.getMember(SysDimensionEnum.Metric.getNumber(), null, split[1])) == null) continue;
            sb.append(member.getName()).append("(").append(member.getNumber()).append("),");
        }
        return sb.toString().substring(0, sb.length() - 1);
    }

    public static List<Map<String, Object>> getExcelCheckResult(FormShowParameter param) {
        String examineCheckReportJson = (String)param.getCustomParam("examineCheckReport");
        List examineCheckReports = SerializationUtils.fromJsonStringToList((String)examineCheckReportJson, ExamineCheckReport.class);
        String rptInfoJson = (String)param.getCustomParam("rptInfo");
        ApproveBillSubMitInfo rptInfo = (ApproveBillSubMitInfo)SerializationUtils.fromJsonString((String)rptInfoJson, ApproveBillSubMitInfo.class);
        if (CollectionUtils.isEmpty((Collection)examineCheckReports) || rptInfo == null) {
            return new ArrayList<Map<String, Object>>(16);
        }
        Collection rptTemps = rptInfo.getRptTemps();
        if (CollectionUtils.isEmpty((Collection)rptTemps)) {
            return new ArrayList<Map<String, Object>>(16);
        }
        ArrayList<Map<String, Object>> checkList = new ArrayList<Map<String, Object>>(16);
        int overRangeCheck = 0;
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)((Long)param.getCustomParam("modelid")));
        for (ApproveBillRptTemp rptTemp : rptTemps) {
            Member member;
            Optional<ExamineCheckReport> first = examineCheckReports.stream().filter(x -> x.getReportProcessId().equals(rptTemp.getRptId())).findFirst();
            if (!first.isPresent()) continue;
            ExamineCheckReport examineCheckReport = first.get();
            HashMap<String, String> temp = new HashMap<String, String>(3);
            Dimension dimension = orCreate.getDimension(SysDimensionEnum.Entity.getNumber());
            if (dimension == null || (member = dimension.getStructOfMember(rptTemp.getOrgId())) == null) continue;
            temp.put("entity", member.getName());
            temp.put("template", rptTemp.getTempName());
            if (examineCheckReport.getExamineCheckResultEnum() == ExamineCheckResultEnum.OverRange) {
                temp.put("checkresult", ResManager.loadKDString((String)"\u5ea6\u91cf\u5fc5\u5f55\u6821\u9a8c\u7684\u6570\u636e\u7684\u5927\u5c0f\u8d85\u8fc7100\u4e07\uff0c\u65e0\u6cd5\u81ea\u52a8\u6821\u9a8c\u9700\u81ea\u884c\u9a8c\u8bc1", (String)"MetricNotNullCheckPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                ++overRangeCheck;
            } else {
                temp.put("checkresult", MetricNotNullCheckUtils.getNullMertic(examineCheckReport.getExamineCheckResultForExamineList(), (Long)param.getCustomParam("modelid")));
            }
            checkList.add(temp);
        }
        return checkList;
    }
}

