/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.approveType;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.approvetype.ApproveTypeUtils;
import kd.epm.eb.business.centralrelation.CentralRelationService;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.model.utils.ModelUtil;

public class ApprovalTypeCentralPlugin
extends AbstractFormPlugin
implements TreeNodeCheckListener {
    private static final String CB_CENTRAL_SPLIT = "cb_centralsplit";
    private static final String TAB_CENTRAL_RELATION = "tab_centralrelation";
    private static final String TREE_VIEW = "treeview_centralorg";
    private static final String BTN_ADD = "btn_add1";
    private static final String BTN_REMOVE = "btn_remove1";
    private static final String BTN_SELECT_ALL = "select_all_temp1";
    private static final String BTN_CLEAR_ALL = "clear_all_temp1";
    private static final String BTN_EXPAND = "expand_all_temp1";
    private static final String BTN_COLLAPSE = "shrink_all_temp1";
    private static final String ENTRY_ENTITY = "entryentity_relation";
    private static final String TREE_NODE_CACHE = "treeview_centralorg";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_ADD, BTN_REMOVE, BTN_SELECT_ALL, BTN_CLEAR_ALL, BTN_EXPAND, BTN_COLLAPSE});
        TreeView customTree = (TreeView)this.getControl("treeview_centralorg");
        customTree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long pkId = this.getPkId();
        Long modelId = (Long)this.getValue("model", "id");
        Long bizModelId = (Long)this.getValue("bizmodel", "id");
        if (IDUtils.isNull((Long)pkId)) {
            if (IDUtils.isNull((Long)bizModelId)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"tabap1"});
            }
            if (ModelUtil.isBGModel((Long)modelId)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{TAB_CENTRAL_RELATION});
            }
            return;
        }
        DynamicObject approveType = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"eb_approvaltypeentity");
        this.getModel().setValue(CB_CENTRAL_SPLIT, (Object)approveType.getBoolean("centralsplit"));
        Boolean isOn = (Boolean)this.getValue(CB_CENTRAL_SPLIT, null);
        if (IDUtils.isNull((Long)bizModelId)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tabap1"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"tabap1"});
            if (isOn.booleanValue()) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{TAB_CENTRAL_RELATION});
                this.initTree(bizModelId);
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{TAB_CENTRAL_RELATION});
            }
        }
        DynamicObjectCollection centralRelationColl = approveType.getDynamicObjectCollection(ENTRY_ENTITY);
        if (CollectionUtils.isEmpty((Collection)centralRelationColl)) {
            return;
        }
        HashSet<Long> centralSchemaIds = new HashSet<Long>(centralRelationColl.size());
        for (DynamicObject centralRelation : centralRelationColl) {
            Long centralSchemaId = centralRelation.getLong("centralschema.id");
            centralSchemaIds.add(centralSchemaId);
        }
        Map centralOrgMap = ApproveTypeUtils.getInstance().getCentralOrgMap(modelId, centralSchemaIds);
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, centralRelationColl.size());
        for (int i = 0; i < centralRelationColl.size(); ++i) {
            DynamicObject selectedRow = (DynamicObject)centralRelationColl.get(i);
            Long schemaId = selectedRow.getLong("centralschema.id");
            boolean isValid = selectedRow.getBoolean("validstatus");
            this.getModel().setValue("budgetorg", (Object)selectedRow.getLong("budgetorg.id"), i);
            this.getModel().setValue("centralschema", (Object)schemaId, i);
            this.getModel().setValue("centralorg", centralOrgMap.get(schemaId), i);
            this.getModel().setValue("validstatus", (Object)(isValid ? "1" : "0"), i);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String keyName = e.getProperty().getName();
        if (CB_CENTRAL_SPLIT.equals(keyName)) {
            Boolean isOn = (Boolean)this.getValue(CB_CENTRAL_SPLIT, null);
            if (isOn.booleanValue()) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{TAB_CENTRAL_RELATION});
                Long bizModelId = (Long)this.getValue("bizmodel", "id");
                if (IDUtils.isNotNull((Long)bizModelId)) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"tabap1"});
                    Tab tab = (Tab)this.getControl("tabap1");
                    tab.activeTab(TAB_CENTRAL_RELATION);
                    this.initTree(bizModelId);
                } else {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"tabap1"});
                }
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{TAB_CENTRAL_RELATION});
            }
        } else if ("bizmodel".equals(keyName)) {
            Long bizModelId = (Long)this.getValue("bizmodel", "id");
            if (IDUtils.isNull((Long)bizModelId)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"tabap1"});
                return;
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"tabap1"});
            Boolean isOn = (Boolean)this.getValue(CB_CENTRAL_SPLIT, null);
            if (isOn.booleanValue()) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{TAB_CENTRAL_RELATION});
                this.unselectAllNodes();
                this.getPageCache().remove("treeview_centralorg");
                this.getModel().deleteEntryData(ENTRY_ENTITY);
                this.initTree(bizModelId);
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{TAB_CENTRAL_RELATION});
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_ADD.equals(key)) {
            this.addCentralSchema();
        } else if (BTN_REMOVE.equals(key)) {
            EntryGrid entrygrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
            int[] selectRows = entrygrid.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u79fb\u9664\u7684\u8bb0\u5f55\u3002", (String)"ApprovalTypeRelationPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getModel().deleteEntryRows(ENTRY_ENTITY, selectRows);
            if (selectRows.length != 0) {
                this.setChanged(true);
            }
        } else if (BTN_SELECT_ALL.equals(key)) {
            this.selectAllNodes();
        } else if (BTN_CLEAR_ALL.equals(key)) {
            this.unselectAllNodes();
        } else if (BTN_EXPAND.equals(key)) {
            this.expandOrCollapseNodes(this.getCacheTree(), true);
        } else if (BTN_COLLAPSE.equals(key)) {
            this.expandOrCollapseNodes(this.getCacheTree(), false);
        }
    }

    private List<Long> getCentralSchemaIds() {
        DynamicObjectCollection rightColl = this.getModel().getEntryEntity(ENTRY_ENTITY);
        ArrayList<Long> centralSchemaIds = new ArrayList<Long>(rightColl.size());
        for (DynamicObject rightData : rightColl) {
            Long schemaId = rightData.getLong("centralschema.id");
            centralSchemaIds.add(schemaId);
        }
        return centralSchemaIds;
    }

    private void initTree(Long bizModelId) {
        TreeNode root = this.getCacheTree();
        if (root == null) {
            TreeNode centralTreeNode;
            root = new TreeNode();
            root.setId("0");
            root.setParentid("");
            root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"CentralRelationSettingPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            QFilter qFilter = new QFilter("bizmodel", "=", (Object)bizModelId);
            qFilter.and(new QFilter("status", "=", (Object)true));
            DynamicObject rangeObj = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_centralrelrange", (QFilter[])qFilter.toArray());
            if (rangeObj != null && (centralTreeNode = CentralRelationService.getInstance().buildTreeNode(rangeObj, false, true, false)) != null) {
                root.addChild(centralTreeNode);
            }
            this.setTreeCache(root);
        }
        TreeView tree = (TreeView)this.getView().getControl("treeview_centralorg");
        tree.addNode(root);
        tree.updateNode(root);
        tree.expand(root.getId());
        List treeNodeList = root.getChildren();
        Label label = (Label)this.getControl("label_org_all");
        if (CollectionUtils.isEmpty((Collection)treeNodeList)) {
            label.setText("0");
            return;
        }
        Map data = (Map)((TreeNode)treeNodeList.get(0)).getData();
        String totalCounts = (String)data.get("leafCounts");
        label.setText(totalCounts);
    }

    private void setTreeCache(TreeNode root) {
        this.getPageCache().put("treeview_centralorg", SerializationUtils.toJsonString((Object)root));
    }

    private TreeNode getCacheTree() {
        String treeNodeCache = this.getPageCache().get("treeview_centralorg");
        if (StringUtils.isEmpty((String)treeNodeCache)) {
            return null;
        }
        return (TreeNode)SerializationUtils.fromJsonString((String)treeNodeCache, TreeNode.class);
    }

    private void selectAllNodes() {
        TreeNode treeNode = this.getCacheTree();
        if (treeNode == null) {
            return;
        }
        TreeView treeView = (TreeView)this.getView().getControl("treeview_centralorg");
        treeView.checkNode(treeNode);
        List treeNodes = treeNode.getChildren();
        if (CollectionUtils.isNotEmpty((Collection)treeNodes)) {
            treeView.checkNodes(treeNodes);
            Map data = (Map)((TreeNode)treeNodes.get(0)).getData();
            String totalCounts = (String)data.get("leafCounts");
            Label label = (Label)this.getControl("label_org_selected");
            label.setText(totalCounts);
        }
    }

    private void unselectAllNodes() {
        TreeNode treeNode = this.getCacheTree();
        if (treeNode == null) {
            return;
        }
        TreeView treeView = (TreeView)this.getView().getControl("treeview_centralorg");
        treeView.uncheckNode(treeNode.getId());
        List treeNodes = treeNode.getChildren();
        if (CollectionUtils.isNotEmpty((Collection)treeNodes)) {
            List nodeIds = treeNodes.stream().map(child -> child.getId()).collect(Collectors.toList());
            treeView.uncheckNodes(nodeIds);
            Label label = (Label)this.getControl("label_org_selected");
            label.setText("0");
        }
    }

    private void expandOrCollapseNodes(TreeNode treeNode, boolean isExpand) {
        if (treeNode == null) {
            return;
        }
        TreeView treeView = (TreeView)this.getView().getControl("treeview_centralorg");
        if (isExpand) {
            treeView.expand(treeNode.getId());
        } else {
            treeView.collapse(treeNode.getId());
        }
        List children = treeNode.getChildren();
        if (CollectionUtils.isNotEmpty((Collection)children)) {
            for (TreeNode child : children) {
                this.expandOrCollapseNodes(child, isExpand);
            }
        }
    }

    public Long getPkId() {
        Object pkId = this.getCache("pkId", String.class);
        if (pkId == null) {
            pkId = this.getView().getFormShowParameter().getCustomParam("pkId");
        }
        return ConvertUtils.toLong((Object)pkId);
    }

    public void treeNodeCheck(TreeNodeCheckEvent treeNodeCheckEvent) {
        TreeView treeView = (TreeView)treeNodeCheckEvent.getSource();
        int count = 0;
        List checkedNodes = treeView.getTreeState().getCheckedNodes();
        for (Map checkedNode : checkedNodes) {
            Object isParent = checkedNode.get("isParent");
            if (Convert.toBool(isParent).booleanValue()) continue;
            ++count;
        }
        Label label = (Label)this.getControl("label_org_selected");
        label.setText(String.valueOf(count));
    }

    private void addCentralSchema() {
        TreeView treeView = (TreeView)this.getView().getControl("treeview_centralorg");
        List checkedNodes = treeView.getTreeState().getCheckedNodes();
        if (CollectionUtils.isEmpty((Collection)checkedNodes)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6dfb\u52a0\u7684\u8bb0\u5f55\u3002", (String)"ApprovalTypeRelationPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode cacheTree = this.getCacheTree();
        if (cacheTree == null) {
            return;
        }
        ArrayList<String> selectNodeIds = new ArrayList<String>(checkedNodes.size());
        HashSet<Long> centralSchemaIds = new HashSet<Long>(checkedNodes.size());
        for (Map checkedNode : checkedNodes) {
            Object isParent;
            String parentId = (String)checkedNode.get("parentid");
            if (StringUtils.isEmpty((String)parentId) || Convert.toBool(isParent = checkedNode.get("isParent")).booleanValue()) continue;
            String selectNodeId = (String)checkedNode.get("id");
            selectNodeIds.add(selectNodeId);
            Long centralSchemaId = Long.valueOf(selectNodeId.split("_")[1]);
            centralSchemaIds.add(centralSchemaId);
        }
        Long modelId = (Long)this.getValue("model", "id");
        Map centralOrgMap = ApproveTypeUtils.getInstance().getCentralOrgMap(modelId, centralSchemaIds);
        List<Long> rightSchemaIds = this.getCentralSchemaIds();
        boolean isChanged = false;
        for (int i = 0; i < selectNodeIds.size(); ++i) {
            String selectNodeId = (String)selectNodeIds.get(i);
            Long budgetOrgId = Long.valueOf(selectNodeId.split("_")[0]);
            Long schemaId = Long.valueOf(selectNodeId.split("_")[1]);
            if (rightSchemaIds.contains(schemaId)) continue;
            int row = this.getModel().createNewEntryRow(ENTRY_ENTITY);
            this.getModel().setValue("budgetorg", (Object)budgetOrgId, row);
            this.getModel().setValue("centralschema", (Object)schemaId, row);
            this.getModel().setValue("centralorg", centralOrgMap.get(schemaId), row);
            isChanged = true;
        }
        treeView.uncheckNodes(selectNodeIds);
        Label label = (Label)this.getControl("label_org_selected");
        label.setText("0");
        if (isChanged) {
            this.setChanged(true);
        }
    }

    private void setChanged(Boolean changed) {
        this.putCache("hasChanged", changed);
    }
}

