/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.approveType;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.approvetype.ApproveTypeUtils;
import kd.epm.eb.business.approvetype.aproveAuditType.ApproveBaseType;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.approveBill.Entity.AllocateRecord;
import kd.epm.eb.common.enums.dimensionEnums.RangeF7PropertyCataEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.SaveCheck;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.templateperm.vo.SearchResult;

public class ApprovalTypeEditPluginNew
extends AbstractFormPlugin
implements BeforeF7SelectListener,
TreeNodeCheckListener,
SearchEnterListener,
SaveCheck {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addF7SelectListener(this, new String[]{"bizmodel"});
        TreeView tempTree = (TreeView)this.getControl("temp_tree");
        tempTree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        TreeView memberTree = (TreeView)this.getControl("member_tree");
        memberTree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        TreeView customTree = (TreeView)this.getControl("custom_tree");
        customTree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        Search searchTemp = (Search)this.getControl("temp_search");
        searchTemp.addEnterListener((SearchEnterListener)this);
        Search searchMember = (Search)this.getControl("member_search");
        searchMember.addEnterListener((SearchEnterListener)this);
        Search searchCustom = (Search)this.getControl("custom_search");
        searchCustom.addEnterListener((SearchEnterListener)this);
        Search searchCentral = (Search)this.getControl("search_central");
        searchCentral.addEnterListener((SearchEnterListener)this);
        this.addClickListeners(new String[]{"select_all_temp", "select_all_member", "clear_all_temp", "clear_all_member", "expand_all_temp", "expand_all_member", "shrink_all_temp", "shrink_all_member", "select_entity", "delete_entity", "pre_temp", "next_temp", "pre_member", "next_member", "pre_custom", "next_custom", "btn_add", "btn_remove", "pre_central", "next_central"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object model = formShowParameter.getCustomParam("model");
        if (model == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"ApprovalTypeEditPluginNew_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long modelId = ConvertUtils.toLong((Object)model);
        this.getModel().setValue("model", (Object)modelId);
        boolean isNewEB = NewEbAppUtil.isNewEbForm((IFormView)this.getView()) || NewEbAppUtil.isNewEbModel((Long)modelId);
        Long pkId = this.getPkId();
        if (pkId != 0L) {
            this.bindData(pkId);
        } else if (isNewEB) {
            DynamicObject bizObj = NewEbAppUtil.getDefaultObj((String)"eb_businessmodel", (Long)modelId);
            if (bizObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ApprovalTypeEditPluginNew_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getModel().setValue("bizmodel", (Object)bizObj);
        }
        this.getView().setVisible(Boolean.valueOf(!isNewEB), new String[]{"bizmodel"});
        String auditType = (String)this.getValue("audittype", null);
        Long bizModelId = (Long)this.getValue("bizmodel", "id");
        this.setPanelVisible(auditType, bizModelId);
        this.updateAuditRangePanelShow(auditType, bizModelId);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"audittype"});
    }

    public Long getPkId() {
        Object pkId = this.getCache("pkId", String.class);
        if (pkId == null) {
            pkId = this.getView().getFormShowParameter().getCustomParam("pkId");
        }
        return ConvertUtils.toLong((Object)pkId);
    }

    public String getEntityId() {
        return "eb_approvaltypeentity";
    }

    private void setPanelVisible(String auditType, Long bizModelId) {
        if (StringUtils.isEmpty((String)auditType)) {
            auditType = (String)this.getValue("audittype", null);
        }
        if (bizModelId == null || bizModelId == 0L) {
            bizModelId = (Long)this.getValue("bizmodel", "id");
        }
        ArrayList<String> unVisiblePanels = new ArrayList<String>(Arrays.asList("temp_panel", "entity_panel1", "entity_panel2", "showwaypanel", "tempnumber", "tempname", "entity_number", "entity_name", "entityrange", "type", "allocatesign"));
        ArrayList<String> visiblePanels = new ArrayList<String>(Collections.singletonList("auditrange"));
        ApproveBaseType approveType = this.getApproveType(auditType);
        approveType.setPanelVisible(unVisiblePanels, visiblePanels, bizModelId);
        this.getView().setVisible(Boolean.valueOf(true), visiblePanels.toArray(new String[0]));
        this.getView().setVisible(Boolean.valueOf(false), unVisiblePanels.toArray(new String[0]));
    }

    private void updateAuditRangePanelShow(String auditType, Long bizModelId) {
        if (StringUtils.isEmpty((String)auditType)) {
            auditType = (String)this.getValue("audittype", null);
        }
        if (!(bizModelId != null && bizModelId != 0L || (bizModelId = (Long)this.getValue("bizmodel", "id")) != null && bizModelId != 0L)) {
            return;
        }
        ApproveBaseType approveType = this.getApproveType(auditType);
        approveType.loadTree(bizModelId);
    }

    private void updateLabelValue(String labelKey, int count) {
        if (StringUtils.isEmpty((String)labelKey)) {
            return;
        }
        Label label = (Label)this.getControl(labelKey);
        label.setText(String.valueOf(count));
        this.putCache(labelKey, count);
    }

    private void bindData(Long typeId) {
        DynamicObject type = BusinessDataServiceHelper.loadSingle((Object)typeId, (String)"eb_approvaltypeentity");
        if (type == null) {
            return;
        }
        this.bindBaseData(type);
        this.bindAllocateData(this.filterCurVersionData(type.getDynamicObjectCollection("entryentity"), type.getLong("curdataversion"), type.getString("audit_type")));
    }

    private void bindBaseData(DynamicObject type) {
        this.getModel().setValue("model", (Object)type.getLong("model.id"));
        this.getModel().setValue("bizmodel", (Object)type.getLong("bizmodel.id"));
        this.getModel().setValue("name", (Object)type.getLocaleString("name"));
        this.getModel().setValue("number", (Object)type.getString("number"));
        this.getModel().setValue("desc", (Object)type.getLocaleString("desc"));
        this.getModel().setValue("audittype", (Object)type.getString("audit_type"));
        this.getModel().setValue("status", (Object)type.getBoolean("status"));
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
    }

    private void bindAllocateData(List<DynamicObject> entryEntity) {
        if (entryEntity == null || entryEntity.size() == 0) {
            return;
        }
        ApproveBaseType auditType = this.getApproveType((String)this.getValue("audittype", null));
        auditType.bindAllocateRecord(entryEntity, this.getModelId());
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("btn_save".equals(itemKey)) {
            this.handleSave();
        } else if ("btn_close".equals(itemKey)) {
            if (this.hasChanged()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u4fdd\u5b58\u7684\u6570\u636e\uff0c\u662f\u5426\u9000\u51fa\uff1f", (String)"ApprovalTypeEditPluginNew_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("close", (IFormPlugin)this));
            } else {
                this.getView().close();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        MessageBoxResult result = event.getResult();
        if (MessageBoxResult.Cancel == result) {
            return;
        }
        String callBackId = event.getCallBackId();
        if ("close".equals(callBackId)) {
            this.getView().close();
        }
    }

    private void handleSave() {
        long curDataVersion;
        DynamicObjectCollection records;
        DynamicObject approveType;
        String checkMessage = this.saveValidate();
        if (StringUtils.isNotEmpty((String)checkMessage)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c%s", (String)"ApprovalTypeEditPluginNew_2", (String)"epm-eb-formplugin", (Object[])new Object[]{checkMessage}));
            return;
        }
        String checkSchema = this.checkCentralSchema();
        if (StringUtils.isNotEmpty((String)checkSchema)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c%s", (String)"ApprovalTypeEditPluginNew_2", (String)"epm-eb-formplugin", (Object[])new Object[]{checkSchema}));
            return;
        }
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        qFilter.and("bizmodel", "=", this.getValue("bizmodel", "id"));
        qFilter.and("status", "=", (Object)"1");
        Long pkId = this.getPkId();
        if (pkId != 0L) {
            qFilter.and("id", "!=", (Object)pkId);
        }
        boolean isOn = (Boolean)this.getValue("status", null);
        String type = (String)this.getValue("audittype", null);
        ApproveBaseType auditType = this.getApproveType(type);
        AllocateRecord allocateRecord = auditType.buildHasAllocateRecords(qFilter);
        boolean isRecordEmpty = auditType.isRecordEmpty(allocateRecord);
        AllocateRecord allocatedRecordFromDB = ApproveTypeUtils.getInstance().buildAllocatedRecordFromDB(qFilter);
        HashSet conflictTypeList = new HashSet(16);
        if (isOn && !isRecordEmpty && ApproveTypeUtils.getInstance().checkRecordConflict(allocateRecord, allocatedRecordFromDB, conflictTypeList, this.getModelId(), this.getViewId())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5df2\u5206\u914d\u7684\u8bb0\u5f55\u4e0e\u5ba1\u6279\u7c7b\u578b\u201c%s\u201d\u4e2d\u7684\u5df2\u5206\u914d\u8bb0\u5f55\u51b2\u7a81\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ApprovalTypeEditPluginNew_3", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)",", conflictTypeList)}));
            return;
        }
        Long userId = this.getUserId();
        Date time = TimeServiceHelper.now();
        boolean detailRecordChanged = true;
        boolean isNew = false;
        if (IDUtils.isNotNull((Long)pkId)) {
            approveType = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"eb_approvaltypeentity");
            records = approveType.getDynamicObjectCollection("entryentity");
            curDataVersion = 0L;
            records.clear();
        } else {
            approveType = BusinessDataServiceHelper.newDynamicObject((String)"eb_approvaltypeentity");
            records = approveType.getDynamicObjectCollection("entryentity");
            approveType.set("creater", (Object)userId);
            approveType.set("createdate", (Object)time);
            pkId = DB.genGlobalLongId();
            approveType.set("id", (Object)pkId);
            curDataVersion = 0L;
            isNew = true;
        }
        approveType.set("name", this.getValue("name", null));
        approveType.set("number", this.getValue("number", null));
        approveType.set("bizmodel", this.getValue("bizmodel", "id"));
        Long modelId = (Long)this.getValue("model", "id");
        approveType.set("model", (Object)modelId);
        approveType.set("audit_type", (Object)type);
        approveType.set("status", (Object)isOn);
        approveType.set("desc", this.getValue("desc", null));
        approveType.set("modifier", (Object)userId);
        approveType.set("modifydate", (Object)time);
        approveType.set("curdataversion", (Object)curDataVersion);
        if (!isRecordEmpty) {
            auditType.fillAllocateEntry(allocateRecord, records, curDataVersion, type);
        }
        this.saveCentralRelationEntry(approveType);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{approveType});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ApprovalTypeEditPluginNew_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.updateQuote(auditType, records, pkId, modelId);
        this.putCache("pkId", String.valueOf(pkId));
        String number = approveType.getString("number");
        String opKey = "addnew";
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u65b0\u589e", "ApprovalTypeEditPluginNew_21", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u7f16\u7801%1$s\uff0c\u65b0\u589e\u6210\u529f", "ApprovalTypeEditPluginNew_22", "epm-eb-formplugin");
        if (!isNew) {
            opKey = "save";
            opName = new MultiLangEnumBridge("\u4fee\u6539", "ApprovalTypeEditPluginNew_23", "epm-eb-formplugin");
            opDesc = new MultiLangEnumBridge("\u7f16\u7801%1\uff0c\u4fee\u6539\u6210\u529f", "ApprovalTypeEditPluginNew_24", "epm-eb-formplugin");
        }
        this.writeLog(number, opKey, opName, opDesc, new String[]{number});
        this.afterSave();
    }

    private void afterSave() {
        this.setChanged(false);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
    }

    private void updateQuote(ApproveBaseType auditType, DynamicObjectCollection records, Long pkId, Long modelId) {
        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"delete", (Object[])new Object[]{MemberQuoteResourceEnum.APPROVE_TYPE.getType(), Sets.newHashSet((Object[])new Long[]{pkId})});
        List quotes = auditType.getMemberQuotes(records, pkId, modelId);
        if (quotes.size() > 0) {
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"save", (Object[])new Object[]{quotes});
        }
    }

    private List<DynamicObject> filterCurVersionData(DynamicObjectCollection records, long curDataVersion, String type) {
        return ApproveTypeUtils.getInstance().filterCurVersionData(records, curDataVersion, type);
    }

    public QFilter getExtraFilter() {
        return null;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        IDataEntityProperty property = evt.getProperty();
        String name = property.getName();
        if (!"bizmodel".equals(name)) {
            return;
        }
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl("bizmodel")).getQFilters();
        if (qFilterList == null) {
            qFilterList = new ArrayList<QFilter>();
        }
        qFilterList.add(new QFilter("model", "=", (Object)this.getModelId()));
        showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if ("bizmodel".equals(name) || "audittype".equals(name)) {
            this.setPanelVisible(null, 0L);
            this.updateAuditRangePanelShow(null, 0L);
            if ("audittype".equals(name)) {
                this.updateAllocateShowCols("0");
            } else {
                this.removeCache("viewId");
            }
            this.getModel().deleteEntryData("entryentity_allocate");
            this.setChanged(true);
        } else if ("showtype".equals(name)) {
            String showType = newValue.toString();
            ApproveBaseType approveType = this.getApproveType((String)this.getValue("audittype", null));
            approveType.updateTreeShowType(showType);
        } else if ("showway".equals(name)) {
            String showWay = newValue.toString();
            this.updateAllocateShowCols(showWay);
        } else if ("number".equals(name) || "name".equals(name) || "status".equals(name) || "desc".equals(name)) {
            this.setChanged(true);
        }
    }

    private void setChanged(Boolean changed) {
        this.putCache("hasChanged", changed);
    }

    private boolean hasChanged() {
        return (Boolean)this.getCache("hasChanged", Boolean.class, () -> false);
    }

    public void updateAllocateShowCols(String showWay) {
    }

    public void treeNodeCheck(TreeNodeCheckEvent treeNodeCheckEvent) {
        TreeView treeView = (TreeView)treeNodeCheckEvent.getSource();
        Pair<String, Integer> toUpdateLabelInfo = this.getToUpdateLabelInfo(treeView, false, false);
        this.updateLabelValue((String)toUpdateLabelInfo.p1, (Integer)toUpdateLabelInfo.p2);
    }

    private Pair<String, Integer> getToUpdateLabelInfo(TreeView treeView, boolean isSelectAllOrClearAll, boolean selectAll) {
        List checkedNodes = treeView.getTreeState().getCheckedNodes();
        int count = 0;
        String labelKey = "";
        String key = treeView.getKey();
        if ("temp_tree".equals(key)) {
            labelKey = "label_temp_focus";
            if (!isSelectAllOrClearAll) {
                for (Map checkedNode : checkedNodes) {
                    String parentId = checkedNode.get("parentid").toString();
                    Object isParent = checkedNode.get("isParent");
                    if (StringUtils.isEmpty((String)parentId) || Convert.toBool(isParent).booleanValue()) continue;
                    ++count;
                }
            } else if (selectAll) {
                count = this.getAllSumLabelCache(key);
            }
        } else if ("member_tree".equals(key) || "custom_tree".equals(key)) {
            // empty if block
        }
        return new Pair((Object)labelKey, (Object)count);
    }

    private Integer getAllSumLabelCache(String treeViewKey) {
        return (Integer)this.getCache(this.getAllSumLabelCacheKey(treeViewKey), Integer.class, () -> 0);
    }

    private String getAllSumLabelCacheKey(String treeViewKey) {
        String cacheKey = "";
        switch (treeViewKey) {
            case "temp_tree": {
                cacheKey = "label_temp_all";
                break;
            }
        }
        return cacheKey;
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        Control control = (Control)searchEnterEvent.getSource();
        String controlKey = control.getKey();
        String entryOrTreeKey = this.getEntryOrTreeKey(controlKey);
        TreeNode root = (TreeNode)this.getCache(entryOrTreeKey, TreeNode.class);
        String searchText = searchEnterEvent.getText();
        ArrayList<TreeNode> result = new ArrayList<TreeNode>(16);
        root.getTreeNodeListByText(result, searchText, 15);
        this.removeEnableNodes(result, entryOrTreeKey);
        if (result.size() == 0) {
            return;
        }
        SearchResult searchResult = new SearchResult(result);
        TreeNode next = searchResult.next(1);
        TreeView treeView = (TreeView)this.getControl(entryOrTreeKey);
        treeView.focusNode(next);
        this.putBase64Cache(entryOrTreeKey + "_search", searchResult);
    }

    private void removeEnableNodes(List<TreeNode> nodes, String treeKey) {
        Map disableNodes = (Map)this.getCache("disableNodes", HashMap.class, () -> new HashMap(16));
        List nodeIds = (List)disableNodes.get(treeKey);
        if (nodeIds == null || nodeIds.size() == 0) {
            return;
        }
        ArrayList<TreeNode> tmp = new ArrayList<TreeNode>(nodes);
        for (TreeNode treeNode : tmp) {
            if (!nodeIds.contains(treeNode.getId())) continue;
            nodes.remove(treeNode);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String controlKey = control.getKey();
        String entryOrTreeKey = this.getEntryOrTreeKey(controlKey);
        if (controlKey.startsWith("select_all")) {
            this.selectOrClearAllNodes(entryOrTreeKey, true);
        } else if (controlKey.startsWith("clear_all")) {
            this.selectOrClearAllNodes(entryOrTreeKey, false);
        } else if (controlKey.startsWith("expand_all")) {
            this.expandOrShrinkAllNodes(entryOrTreeKey, true);
        } else if (controlKey.startsWith("shrink_all")) {
            this.expandOrShrinkAllNodes(entryOrTreeKey, false);
        } else if ("select_entity".equals(controlKey)) {
            this.openEntitySelectPage(entryOrTreeKey);
        } else if ("delete_entity".equals(controlKey)) {
            this.deleteSelectRows(entryOrTreeKey);
        } else if ("btn_add".equals(controlKey)) {
            this.buildAllocateRecord();
        } else if ("btn_remove".equals(controlKey)) {
            this.removeAllocateRecord();
        } else if (controlKey.startsWith("pre")) {
            this.moveSearchResult(entryOrTreeKey, -1);
        } else if (controlKey.startsWith("next")) {
            this.moveSearchResult(entryOrTreeKey, 1);
        }
    }

    private void moveSearchResult(String entryOrTreeKey, int moveStep) {
        SearchResult result = (SearchResult)this.getBase64Cache(entryOrTreeKey + "_search");
        if (result == null) {
            return;
        }
        TreeNode node = result.next(moveStep);
        if (node == null) {
            if (moveStep == 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"ApprovalTypeEditPluginNew_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"ApprovalTypeEditPluginNew_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        TreeView treeView = (TreeView)this.getControl(entryOrTreeKey);
        treeView.focusNode(node);
        this.putBase64Cache(entryOrTreeKey + "_search", result);
    }

    private void buildAllocateRecord() {
        Long modelId = this.getModelId();
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("bizmodel", "=", this.getValue("bizmodel", "id"));
        qFilter.and("status", "=", (Object)"1");
        Long pkId = this.getPkId();
        if (pkId != 0L) {
            qFilter.and("id", "!=", (Object)pkId);
        }
        Long viewId = this.getViewId();
        HashMap templateBaseInfo = new HashMap(16);
        ApproveBaseType auditType = this.getApproveType((String)this.getValue("audittype", null));
        AllocateRecord toAllocateRecord = auditType.buildToAllocateRecordAndFilter(qFilter, templateBaseInfo);
        auditType.removeHasAllocateRecords(toAllocateRecord);
        auditType.addToHasAllocateRecordEntry(toAllocateRecord, templateBaseInfo, viewId);
        if (!auditType.isRecordEmpty(toAllocateRecord)) {
            this.setChanged(true);
        }
    }

    private Long getViewId() {
        Long viewId = (Long)this.getCache("viewId", Long.class, () -> 0L);
        if (viewId == 0L) {
            viewId = (Long)this.getValue("view", "id");
            if (viewId != null) {
                this.putCache("viewId", viewId);
            } else {
                viewId = 0L;
            }
        }
        return viewId;
    }

    private void removeAllocateRecord() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity_allocate");
        int[] rows = entryGrid.getSelectRows();
        this.getModel().deleteEntryRows("entryentity_allocate", rows);
        if (rows.length != 0) {
            this.setChanged(true);
        }
    }

    private void selectOrClearAllNodes(String entryOrTreeKey, boolean isSelectAll) {
        TreeView treeView = (TreeView)this.getControl(entryOrTreeKey);
        if (isSelectAll) {
            TreeNode root = (TreeNode)this.getCache(entryOrTreeKey, TreeNode.class);
            treeView.checkNode(root);
        } else if ("custom_tree".equals(entryOrTreeKey)) {
            List checkedNodeIds = treeView.getTreeState().getCheckedNodeIds();
            treeView.uncheckNodes(checkedNodeIds);
        } else {
            treeView.uncheckNode("0");
        }
        Pair<String, Integer> toUpdateLabelInfo = this.getToUpdateLabelInfo(treeView, true, isSelectAll);
        this.updateLabelValue((String)toUpdateLabelInfo.p1, (Integer)toUpdateLabelInfo.p2);
    }

    private void expandOrShrinkAllNodes(String entryOrTreeKey, boolean isExpand) {
        TreeView treeView = (TreeView)this.getControl(entryOrTreeKey);
        TreeNode root = (TreeNode)this.getCache(entryOrTreeKey, TreeNode.class);
        if ("custom_tree".equals(entryOrTreeKey)) {
            List children = root.getChildren();
            children.forEach(e -> this.expandOrShrinkNodes(treeView, (TreeNode)e, isExpand));
        } else {
            this.expandOrShrinkNodes(treeView, root, isExpand);
        }
    }

    private void expandOrShrinkNodes(TreeView treeView, TreeNode node, boolean isExpand) {
        List children = node.getChildren();
        if (children != null && children.size() != 0) {
            if (isExpand) {
                treeView.expand(node.getId());
            }
            for (TreeNode child : children) {
                this.expandOrShrinkNodes(treeView, child, isExpand);
            }
            if (!isExpand) {
                treeView.collapse(node.getId());
            }
        }
    }

    private void openEntitySelectPage(String entryOrTreeKey) {
    }

    private void deleteSelectRows(String entryOrTreeKey) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryOrTreeKey);
        int[] rows = entryGrid.getSelectRows();
        this.getModel().deleteEntryRows(entryOrTreeKey, rows);
    }

    private String getEntryOrTreeKey(String signKey) {
        String relateKey = null;
        if (signKey.endsWith("temp") || signKey.startsWith("temp")) {
            relateKey = "temp_tree";
        } else if (signKey.startsWith("member")) {
            relateKey = "member_tree";
        } else if (signKey.endsWith("entity")) {
            relateKey = "entryentity";
        } else if (signKey.endsWith("member")) {
            Tab tab = (Tab)this.getControl("tabap");
            String currentTab = tab.getCurrentTab();
            relateKey = "member".equals(currentTab) ? "member_tree" : "custom_tree";
        } else if (signKey.startsWith("custom")) {
            relateKey = "custom_tree";
        } else if (signKey.endsWith("central")) {
            relateKey = "treeview_centralorg";
        }
        return relateKey;
    }

    @Override
    public Long getModelId() {
        Long modelId = (Long)this.getValue("model", "id");
        if (modelId == null) {
            modelId = 0L;
        }
        return modelId;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object backData = closedCallBackEvent.getReturnData();
        if ("selectEntity".equals(actionId)) {
            this.handleEntityClosedCallBack(backData);
        }
    }

    private void handleEntityClosedCallBack(Object backData) {
        if (backData == null) {
            return;
        }
        DynamicObjectCollection selectedRows = (DynamicObjectCollection)backData;
        ArrayList selectIds = new ArrayList(16);
        selectedRows.forEach(row -> selectIds.add(row.getLong("mid")));
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData("entryentity");
        dataModel.batchCreateNewEntryRow("entryentity", selectIds.size());
        for (int i = 0; i < selectIds.size(); ++i) {
            DynamicObject selectedRow = (DynamicObject)selectedRows.get(i);
            this.getModel().setValue("entitytypeclass", (Object)this.getType(selectedRow), i);
            this.getModel().setValue("entity", selectIds.get(i), i);
            this.getModel().setValue("entity_range", (Object)selectedRow.getString("scope"), i);
        }
    }

    private String getType(DynamicObject selectedRow) {
        String type = selectedRow.getString("type");
        if (RangeF7PropertyCataEnum.Property.getIndex().equals(type)) {
            return "eb_custompropertyvalue";
        }
        return "epm_entitymembertree";
    }

    private ApproveBaseType getApproveType(String auditType) {
        return ApproveTypeUtils.getInstance().getApproveType(auditType, this.getView(), this.getModel());
    }

    public List<String> getAllCheckTypes() {
        List baseCheckTypes = this.getBaseCheckTypes();
        baseCheckTypes.add("hasSelect");
        return baseCheckTypes;
    }

    public String validate(String checkType) {
        AllocateRecord allocateRecord;
        if (!"hasSelect".equals(checkType)) {
            return null;
        }
        Boolean enable = (Boolean)this.getValue("status", null);
        if (!enable.booleanValue()) {
            return null;
        }
        String type = (String)this.getValue("audittype", null);
        ApproveBaseType auditType = this.getApproveType(type);
        boolean isRecordEmpty = auditType.isRecordEmpty(allocateRecord = auditType.buildHasAllocateRecords(null));
        if (isRecordEmpty) {
            return ResManager.loadKDString((String)"\u542f\u7528\u7684\u5ba1\u6279\u7c7b\u578b\u4e2d\uff0c\u5ba1\u6279\u8303\u56f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ApprovalTypeEditPluginNew_12", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    private void saveCentralRelationEntry(DynamicObject approveType) {
        approveType.set("centralsplit", this.getValue("cb_centralsplit", null));
        DynamicObjectCollection relationColl = this.getModel().getEntryEntity("entryentity_relation");
        DynamicObjectCollection centralRelationList = approveType.getDynamicObjectCollection("entryentity_relation");
        centralRelationList.clear();
        for (DynamicObject relation : relationColl) {
            DynamicObject centralRelation = centralRelationList.addNew();
            centralRelation.set("budgetorg", (Object)relation.getLong("budgetorg.id"));
            centralRelation.set("centralschema", (Object)relation.getLong("centralschema.id"));
            centralRelation.set("validstatus", (Object)("1".equals(relation.getString("validstatus")) ? 1 : 0));
        }
    }

    private String checkCentralSchema() {
        String result = "";
        DynamicObjectCollection relationColl = this.getModel().getEntryEntity("entryentity_relation");
        for (DynamicObject relation : relationColl) {
            Long schemaId = relation.getLong("centralschema.id");
            if (!IDUtils.isNull((Long)schemaId)) continue;
            result = ResManager.loadKDString((String)"\u5f52\u53e3\u5173\u7cfb\u65b9\u6848\u4e0d\u5b58\u5728\u3002", (String)"ApprovalTypeEditPluginNew_25", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            break;
        }
        return result;
    }
}

