/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.approveType;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.epm.eb.business.approvetype.ApproveTypeUtils;
import kd.epm.eb.business.approvetype.aproveAuditType.ApproveBaseType;
import kd.epm.eb.business.utils.ImportAndExportUtil;
import kd.epm.eb.common.applyTemplate.helper.ExcelHelper;
import kd.epm.eb.common.approveBill.Entity.AllocateDetailRecord;
import kd.epm.eb.common.approveBill.Entity.AllocateRecord;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.excelImport.POIUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ApprovalTypeListPluginNew
extends AbstractListPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(ApprovalTypeListPluginNew.class);
    private static final String MODEL = "model";
    private static final String BILL_LIST_AP = "billlistap";

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl(BILL_LIST_AP);
        billList.addHyperClickListener((HyperLinkClickListener)this);
        billList.addSetFilterListener(this::setFilter);
        billList.addCreateListColumnsListener(this::beforeCreateListColumns);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7SelectListener(this, new String[]{MODEL});
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        Long modelId = this.getModelId();
        if (modelId == 0L) {
            modelId = ConvertUtils.toLong((Object)UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)MODEL, (boolean)false));
        }
        if (modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ApprovalTypeListPluginNew_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            this.getModel().setValue(MODEL, (Object)modelId);
        }
        this.modelChanged(modelId);
    }

    @Override
    protected void addColumnKeysToHide4NewEb(Set<String> colsToHide) {
        super.addColumnKeysToHide4NewEb(colsToHide);
        colsToHide.add("bizmodel.name");
    }

    private void refreshBillList() {
        this.modelChanged(this.getModelId());
    }

    private void modelChanged(Long modelId) {
        BillList billList = (BillList)this.getControl(BILL_LIST_AP);
        billList.setFilter(new QFilter(MODEL, "=", (Object)modelId));
        billList.clearSelection();
        billList.refresh();
    }

    public void setFilter(SetFilterEvent e) {
        e.addCustomQFilter(new QFilter(MODEL, "=", (Object)this.getModelId()));
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key = event.getProperty().getName();
        if (MODEL.equals(key)) {
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            ArrayList qFilterList = ((BasedataEdit)this.getControl(MODEL)).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList();
            }
            qFilterList.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    @Override
    public Long getModelId() {
        long modelId;
        Object modelObj = this.getModel().getValue(MODEL);
        if (modelObj != null) {
            modelId = ((DynamicObject)modelObj).getLong("id");
        } else {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            modelId = ConvertUtils.toLong((Object)formShowParameter.getCustomParam(MODEL));
        }
        return modelId;
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_add": {
                this.openApprovalType(0L);
                break;
            }
            case "btn_delete": {
                this.doDelete();
                break;
            }
            case "btn_import": {
                this.openImportPage();
                break;
            }
            case "btn_export": {
                this.exportData();
                break;
            }
            case "btn_enable": {
                this.setEnable(true);
                break;
            }
            case "btn_unable": {
                this.setEnable(false);
                break;
            }
            case "btn_refresh": {
                this.refreshBillList();
                break;
            }
            case "btn_update": {
                UpgradeResult result = (UpgradeResult)DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"ApproveTypeUpgradeService", (String)"beforeExecuteSqlWithResult", (Object[])new Object[]{null, null, null, null});
                if (result.isSuccess()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f", (String)"", (String)"", (Object[])new Object[0]));
                    break;
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u5931\u8d25", (String)"", (String)"", (Object[])new Object[0]));
                break;
            }
        }
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent e) {
        super.hyperLinkClick(e);
        BillList billList = (BillList)this.getControl(BILL_LIST_AP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        this.openApprovalType(ConvertUtils.toLong((Object)selectedRows.get(0).getPrimaryKeyValue()));
    }

    private void openApprovalType(long approveTypeId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_approvetype");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        Long modelId = this.getModelId();
        showParameter.setCustomParam(MODEL, (Object)modelId);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openApprovalType"));
        if (approveTypeId != 0L) {
            showParameter.setCustomParam("pkId", (Object)approveTypeId);
        }
        if (NewEbAppUtil.isNewEbForm((IFormView)this.getView()) || NewEbAppUtil.isNewEbModel((Long)modelId)) {
            showParameter.setCustomParam("newEbForm", (Object)"true");
        }
        this.getView().showForm(showParameter);
    }

    private void doDelete() {
        if (this.checkBeforeDelete()) {
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u786e\u5b9a\u5220\u9664\u9009\u4e2d\u7684\u6570\u636e\uff1f", (String)"ApprovalTypeListPluginNew_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete", (IFormPlugin)this));
    }

    private boolean checkBeforeDelete() {
        BillList billList = (BillList)this.getControl(BILL_LIST_AP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ApprovalTypeListPluginNew_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        List pkIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        QFilter qFilter1 = new QFilter("id", "in", pkIds);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_approvaltypeentity", (String)"status", (QFilter[])new QFilter[]{qFilter1});
        for (DynamicObject dynamicObject : query) {
            boolean enable = dynamicObject.getBoolean("status");
            if (!enable) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u542f\u7528\u72b6\u6001\u7684\u5ba1\u6279\u7c7b\u578b\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ApprovalTypeListPluginNew_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        QFilter qFilter = new QFilter("approvetype", "in", pkIds);
        qFilter.and("billstatus", "=", (Object)"B");
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"eb_approvebill", (String)"id", (QFilter[])new QFilter[]{qFilter});
        List billIds = bills.stream().map(e -> e.getString("id")).collect(Collectors.toList());
        for (String billId : billIds) {
            boolean inProcess = WorkflowServiceHelper.inProcess((String)billId);
            if (!inProcess) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5de5\u4f5c\u6d41\u5ba1\u6838\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ApprovalTypeListPluginNew_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void openImportPage() {
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put(MODEL, this.getModelId());
        String caption = ResManager.loadKDString((String)"\u5bfc\u5165", (String)"ApprovalTypeListPluginNew_2", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String plugin = "kd.epm.eb.formplugin.approveType.ApproveTypeImportPlugin";
        String actionId = "importApproveType";
        this.showImportPage(caption, plugin, actionId, customParams);
    }

    public void showImportPage(String caption, String plugin, String actionId, Map<String, Object> customParams) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epm_import");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(caption);
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)"epm_import");
        formConfig.getPlugins().clear();
        showParameter.setFormConfig(formConfig);
        showParameter.addCustPlugin(plugin);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, actionId);
        showParameter.setCustomParams(customParams);
        showParameter.setCloseCallBack(callBack);
        this.getView().showForm(showParameter);
    }

    private void exportData() {
        BillList billList = (BillList)this.getControl(BILL_LIST_AP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ApprovalTypeListPluginNew_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        List pkIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        DynamicObject[] approveTypes = BusinessDataServiceHelper.load((Object[])pkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_approvaltypeentity"));
        Long modelId = this.getModelId();
        String path = "approveRelatTemplate/approveTypeImportTemplateNew.xlsx";
        boolean isNewEB = NewEbAppUtil.isNewEbForm((IFormView)this.getView()) || NewEbAppUtil.isNewEbModel((Long)modelId);
        int colIndex = 6;
        if (isNewEB) {
            path = "approveRelatTemplate/approveTypeImportTemplateNew_bg.xlsx";
            colIndex = 4;
        }
        InputStream inputStream = null;
        try {
            String url;
            XSSFWorkbook workbook;
            inputStream = this.getClass().getClassLoader().getResourceAsStream(path);
            if (inputStream == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u6a21\u677f\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ApprovalTypeListPluginNew_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            try {
                workbook = new XSSFWorkbook(inputStream);
            }
            catch (Exception ex) {
                log.error((Throwable)ex);
                throw new KDBizException(ResManager.loadKDString((String)"\u89e3\u6790\u6a21\u677f\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ApprovalTypeListPluginNew_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            StringBuilder numberStr = new StringBuilder();
            StringBuilder nameStr = new StringBuilder();
            ApproveTypeUtils.getInstance().supportMultiLangForTitle(workbook, isNewEB);
            XSSFSheet sheet = workbook.getSheetAt(0);
            CellStyle textCellStyle = POIUtils.get().getTextCellStyle((Workbook)workbook);
            int rowIndex = 2;
            for (DynamicObject approveType : approveTypes) {
                boolean centralSplitStatus;
                String name = approveType.getString("name");
                String number = approveType.getString("number");
                String bizName = approveType.getString("bizmodel.name");
                String bizNumber = approveType.getString("bizmodel.number");
                boolean status = approveType.getBoolean("status");
                String statusName = status ? ResManager.loadKDString((String)"\u542f\u7528", (String)"ApprovalTypeListPluginNew_7", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7981\u7528", (String)"ApprovalTypeListPluginNew_6", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                String type = approveType.getString("audit_type");
                long curVersion = approveType.getLong("curdataversion");
                DynamicObjectCollection entryEntity = approveType.getDynamicObjectCollection("entryentity");
                List filterRecords = ApproveTypeUtils.getInstance().filterCurVersionData(entryEntity, curVersion, type);
                for (DynamicObject entry : filterRecords) {
                    String tempNumber = entry.getString("template.number");
                    String tempName = entry.getString("template.name");
                    numberStr.append(tempNumber).append(",");
                    nameStr.append(tempName).append(",");
                }
                String tempNumbers = "";
                String tempNames = "";
                if (StringUtils.isNotEmpty((String)numberStr.toString())) {
                    tempNumbers = numberStr.substring(0, numberStr.length() - 1);
                    tempNames = nameStr.substring(0, nameStr.length() - 1);
                    numberStr.setLength(0);
                    nameStr.setLength(0);
                }
                String centralSplitStatusName = (centralSplitStatus = approveType.getBoolean("centralsplit")) ? ResManager.loadKDString((String)"\u662f", (String)"ControlBillCheckListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"ControlBillCheckListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                DynamicObjectCollection centralEntityColl = approveType.getDynamicObjectCollection("entryentity_relation");
                for (DynamicObject entry : centralEntityColl) {
                    String schemaNumber = entry.getString("centralschema.number");
                    String schemaName = entry.getString("centralschema.name");
                    numberStr.append(schemaNumber).append(",");
                    nameStr.append(schemaName).append(",");
                }
                String schemaNumbers = "";
                String schemaNames = "";
                if (StringUtils.isNotEmpty((String)numberStr.toString())) {
                    schemaNumbers = numberStr.substring(0, numberStr.length() - 1);
                    schemaNames = nameStr.substring(0, nameStr.length() - 1);
                    numberStr.setLength(0);
                    nameStr.setLength(0);
                }
                ExcelHelper.setCellValue((XSSFSheet)sheet, null, (Integer)(++rowIndex), (Integer)0, (String)number);
                ExcelHelper.setCellValue((XSSFSheet)sheet, (CellStyle)textCellStyle, (Integer)rowIndex, (Integer)1, (String)name);
                if (!isNewEB) {
                    ExcelHelper.setCellValue((XSSFSheet)sheet, null, (Integer)rowIndex, (Integer)2, (String)bizNumber);
                    ExcelHelper.setCellValue((XSSFSheet)sheet, (CellStyle)textCellStyle, (Integer)rowIndex, (Integer)3, (String)bizName);
                }
                ExcelHelper.setCellValue((XSSFSheet)sheet, null, (Integer)rowIndex, (Integer)(isNewEB ? 2 : 4), (String)tempNumbers);
                ExcelHelper.setCellValue((XSSFSheet)sheet, (CellStyle)textCellStyle, (Integer)rowIndex, (Integer)(isNewEB ? 3 : 5), (String)tempNames);
                ExcelHelper.setCellValue((XSSFSheet)sheet, (CellStyle)textCellStyle, (Integer)rowIndex, (Integer)(isNewEB ? 4 : 6), (String)statusName);
                ExcelHelper.setCellValue((XSSFSheet)sheet, null, (Integer)rowIndex, (Integer)(isNewEB ? 5 : 7), (String)centralSplitStatusName);
                ExcelHelper.setCellValue((XSSFSheet)sheet, null, (Integer)rowIndex, (Integer)(isNewEB ? 6 : 8), (String)schemaNumbers);
                ExcelHelper.setCellValue((XSSFSheet)sheet, (CellStyle)textCellStyle, (Integer)rowIndex, (Integer)(isNewEB ? 7 : 9), (String)schemaNames);
            }
            String[] values = new String[]{ResManager.loadKDString((String)"\u542f\u7528", (String)"OffsetRuleListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7981\u7528", (String)"OffsetRuleListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0])};
            ApproveTypeUtils.getInstance().addDropDown(workbook, values, Integer.valueOf(3), Integer.valueOf(100), Integer.valueOf(colIndex), Integer.valueOf(colIndex));
            XSSFSheet tempSheet = workbook.getSheetAt(1);
            QFilter qFilter = new QFilter(MODEL, "=", (Object)modelId);
            DynamicObjectCollection templates = QueryServiceHelper.query((String)"eb_templateentity", (String)"number, name", (QFilter[])new QFilter[]{qFilter});
            rowIndex = 1;
            for (DynamicObject template : templates) {
                ExcelHelper.setCellValue((XSSFSheet)tempSheet, null, (Integer)rowIndex, (Integer)2, (String)template.getString("number"));
                ExcelHelper.setCellValue((XSSFSheet)tempSheet, (CellStyle)textCellStyle, (Integer)rowIndex++, (Integer)3, (String)template.getString("name"));
            }
            String fileName = ResManager.loadKDString((String)"\u5ba1\u6279\u7c7b\u578b\u5bfc\u51fa\u6570\u636e", (String)"ApprovalTypeListPluginNew_8", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            try {
                url = ImportAndExportUtil.writeFile((Workbook)workbook, (String)fileName);
            }
            catch (IOException ex) {
                log.error((Throwable)ex);
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ApprovalTypeListPluginNew_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isNotEmpty((String)url)) {
                ImportAndExportUtil.addTempFileCheck((String)url, (String)"eb_approvaltypelist_new", (String)(isNewEB ? ApplicationTypeEnum.EB.getAppnum() : ApplicationTypeEnum.BGMD.getAppnum()), (int)10000);
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
            }
            this.writeLog("export", new MultiLangEnumBridge("\u5bfc\u51fa", "AnalyseReportTemplateListPlugin_18", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5bfc\u51fa\u6210\u529f", "AnalyseReportTemplateListPlugin_19", "epm-eb-formplugin"));
        }
        catch (Exception ex) {
            if (ex instanceof KDBizException) {
                throw ex;
            }
            log.error((Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ApprovalTypeListPluginNew_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setEnable(boolean enable) {
        BillList billList = (BillList)this.getControl(BILL_LIST_AP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ApprovalTypeListPluginNew_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Object[] pkArray = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
        DynamicObject[] approveTypes = BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_approvaltypeentity"));
        ArrayList<String> noBusiness = new ArrayList<String>(16);
        ArrayList<String> noAllocateRecord = new ArrayList<String>(16);
        QFilter qFilter = new QFilter(MODEL, "=", (Object)this.getModelId());
        qFilter.and("status", "=", (Object)"1");
        HashMap<Long, List> toModifyRecords = new HashMap<Long, List>(16);
        HashMap<String, ApproveBaseType> approveTypeMap = new HashMap<String, ApproveBaseType>(16);
        HashSet toQueryTemplates = new HashSet(16);
        HashSet toQueryEntities = new HashSet(16);
        for (DynamicObject approveType : approveTypes) {
            AllocateRecord allocateRecord;
            if (!enable) {
                approveType.set("status", (Object)"0");
                continue;
            }
            DynamicObject dynamicObject = approveType.getDynamicObject("bizmodel");
            if (dynamicObject == null) {
                noBusiness.add(approveType.getString("name"));
                continue;
            }
            boolean status = approveType.getBoolean("status");
            if (status) continue;
            DynamicObjectCollection entryEntity = approveType.getDynamicObjectCollection("entryentity");
            String audit_type = approveType.getString("audit_type");
            long dataVersion = approveType.getLong("curdataversion");
            List entryRows = ApproveTypeUtils.getInstance().filterCurVersionData(entryEntity, dataVersion, audit_type);
            if (entryRows.size() == 0) {
                noAllocateRecord.add(approveType.getString("name"));
                continue;
            }
            if (noBusiness.size() != 0 || noAllocateRecord.size() != 0) continue;
            ApproveBaseType type = approveTypeMap.computeIfAbsent(audit_type, k -> ApproveTypeUtils.getInstance().getApproveType(audit_type, null, null));
            if (type.isRecordEmpty(allocateRecord = type.buildHasAllocateRecords(entryRows, toQueryTemplates, toQueryEntities, qFilter))) {
                noAllocateRecord.add(approveType.getString("name"));
                continue;
            }
            List records = toModifyRecords.computeIfAbsent(dynamicObject.getLong("id"), k -> new ArrayList(16));
            records.add(allocateRecord);
            approveType.set("status", (Object)"1");
        }
        ApproveBaseType baseType = new ApproveBaseType(this.getView(), this.getModel());
        baseType.addTemplateQFilter(qFilter, toQueryTemplates);
        baseType.addEntityQFilter(toQueryEntities, qFilter);
        if (noBusiness.size() != 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\uff0c\u5ba1\u6279\u7c7b\u578b\u201c%s\u201d\u672a\u5173\u8054\u4e1a\u52a1\u6a21\u578b", (String)"ApprovalTypeListPluginNew_10", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)",", noBusiness)}));
        } else if (noAllocateRecord.size() != 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\uff0c\u5ba1\u6279\u7c7b\u578b\u201c%s\u201d\u4e0d\u5b58\u5728\u5ba1\u6279\u8303\u56f4", (String)"ApprovalTypeListPluginNew_11", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)",", noAllocateRecord)}));
        } else {
            void var17_23;
            HashSet conflictTypeList = new HashSet(16);
            boolean toEnableConflict = false;
            block1: for (Map.Entry entry : toModifyRecords.entrySet()) {
                if (toEnableConflict) break;
                Long bizModelId = (Long)entry.getKey();
                QFilter qf = new QFilter("bizmodel", "=", (Object)bizModelId);
                qf.and("id", "not in", Arrays.asList(pkArray));
                AllocateRecord allocatedRecordFromDB = ApproveTypeUtils.getInstance().buildAllocatedRecordFromDB(qf.and(qFilter));
                List records = (List)entry.getValue();
                for (int i = 0; i < records.size(); ++i) {
                    AllocateRecord record = (AllocateRecord)records.get(i);
                    List<Long> templates = this.getTemplatesFromRecord(record);
                    if (templates == null) continue;
                    for (int j = i + 1; j < records.size(); ++j) {
                        AllocateRecord _record = (AllocateRecord)records.get(j);
                        List<Long> _templates = this.getTemplatesFromRecord(_record);
                        if (_templates == null || !CollectionUtils.containsAny(templates, _templates)) continue;
                        toEnableConflict = true;
                        break;
                    }
                    if (toEnableConflict) continue block1;
                    ApproveTypeUtils.getInstance().checkRecordConflict(record, allocatedRecordFromDB, conflictTypeList, this.getModelId(), Long.valueOf(0L));
                }
            }
            if (toEnableConflict) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\uff0c\u5f85\u542f\u7528\u7684\u8bb0\u5f55\u5b58\u5728\u51b2\u7a81\u3002", (String)"ApprovalTypeListPluginNew_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (conflictTypeList.size() != 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\uff0c\u5f85\u542f\u7528\u7684\u8bb0\u5f55\u4e0e\u5ba1\u6279\u7c7b\u578b\u201c%s\u201d\u4e2d\u7684\u5df2\u5206\u914d\u8bb0\u5f55\u51b2\u7a81\u3002", (String)"ApprovalTypeListPluginNew_18", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)"; ", conflictTypeList)}));
                return;
            }
            Set numbers = Arrays.stream(approveTypes).map(e -> e.getString("number")).collect(Collectors.toSet());
            MultiLangEnumBridge multiLangEnumBridge = new MultiLangEnumBridge("\u542f\u7528", "ApprovalTypeListPluginNew_20", "epm-eb-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u7f16\u7801%1$s\uff0c\u542f\u7528\u6210\u529f", "ApprovalTypeListPluginNew_21", "epm-eb-formplugin");
            SaveServiceHelper.save((DynamicObject[])approveTypes);
            if (enable) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"ApprovalTypeListPluginNew_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"ApprovalTypeListPluginNew_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                MultiLangEnumBridge multiLangEnumBridge2 = new MultiLangEnumBridge("\u7981\u7528", "ApprovalTypeListPluginNew_22", "epm-eb-formplugin");
                opDesc = new MultiLangEnumBridge("\u7f16\u7801%1$s\uff0c\u7981\u7528\u6210\u529f", "ApprovalTypeListPluginNew_23", "epm-eb-formplugin");
            }
            this.writeLog("update", (MultiLangEnumBridge)var17_23, opDesc, new String[]{String.join((CharSequence)"\u3001", numbers)});
            this.refreshBillList();
        }
    }

    private List<Long> getTemplatesFromRecord(AllocateRecord record) {
        List templateRecords = record.getTemplateRecords();
        if (templateRecords == null || templateRecords.size() == 0) {
            return null;
        }
        AllocateDetailRecord allocateDetailRecord = (AllocateDetailRecord)templateRecords.get(0);
        List templates = allocateDetailRecord.getTemplates();
        if (templates == null || templates.size() == 0) {
            return null;
        }
        return templates.stream().map(template -> template.getId()).collect(Collectors.toList());
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnData;
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("openApprovalType".equals(actionId)) {
            this.refreshBillList();
        } else if ("importApproveType".equals(actionId) && (returnData = event.getReturnData()) != null && "successful".equals(returnData.toString())) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"ApprovalTypeListPluginNew_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.refreshBillList();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (MessageBoxResult.Cancel == event.getResult()) {
            return;
        }
        String callBackId = event.getCallBackId();
        if ("delete".equals(callBackId)) {
            BillList billList = (BillList)this.getControl(BILL_LIST_AP);
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            List pkIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            QFilter qFilter = new QFilter("id", "in", pkIds);
            DeleteServiceHelper.delete((String)"eb_approvaltypeentity", (QFilter[])new QFilter[]{qFilter});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ApprovalTypeListPluginNew_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.refreshBillList();
            Set deleteIds = pkIds.stream().map(ConvertUtils::toLong).collect(Collectors.toSet());
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"delete", (Object[])new Object[]{MemberQuoteResourceEnum.APPROVE_TYPE.getType(), deleteIds});
            Set numbers = selectedRows.stream().map(ListSelectedRow::getNumber).collect(Collectors.toSet());
            this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "ApprovalTypeListPluginNew_24", "epm-eb-formplugin"), new MultiLangEnumBridge("\u7f16\u7801%1$s, \u5220\u9664\u6210\u529f", "ApprovalTypeListPluginNew_25", "epm-eb-formplugin"), new String[]{String.join((CharSequence)"\u3001", numbers)});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        ChangeData changeSet = e.getChangeSet()[0];
        Object newValue = changeSet.getNewValue();
        Object oldValue = changeSet.getOldValue();
        String name = property.getName();
        if (MODEL.equals(name)) {
            if (newValue == null) {
                this.getModel().setValue(MODEL, oldValue);
            } else {
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)((DynamicObject)newValue).getLong("id"));
                this.refreshBillList();
            }
        }
    }
}

