/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.approveType;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.approvetype.ApproveTypeUtils;
import kd.epm.eb.business.utils.ImportAndExportUtil;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.applyTemplate.helper.ExcelHelper;
import kd.epm.eb.common.centralapproval.CentralScheme;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.formplugin.applybill.fileImport.BgApplyBillImportBasePlugin;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ApproveTypeImportPlugin
extends BgApplyBillImportBasePlugin {
    private static final Log log = LogFactory.getLog(ApproveTypeImportPlugin.class);
    private String defaultBizModel;

    @Override
    protected boolean showAddBtn() {
        return true;
    }

    @Override
    protected void downLoadTemplate() {
        Long modelId = this.getModelId();
        String path = "approveRelatTemplate/approveTypeImportTemplateNew.xlsx";
        boolean isNewEb = NewEbAppUtil.isNewEbModel((Long)modelId);
        int colIndex = 6;
        if (isNewEb) {
            path = "approveRelatTemplate/approveTypeImportTemplateNew_bg.xlsx";
            colIndex = 4;
        }
        InputStream inputStream = null;
        try {
            String url;
            inputStream = this.getClass().getClassLoader().getResourceAsStream(path);
            if (inputStream == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u6a21\u677f\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ApproveTypeImportPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            XSSFWorkbook workBook = this.getWorkBook(inputStream);
            ApproveTypeUtils.getInstance().supportMultiLangForTitle(workBook, isNewEb);
            XSSFSheet sheet = workBook.getSheetAt(1);
            QFilter qFilter = new QFilter("model", "=", (Object)modelId);
            DynamicObjectCollection templates = QueryServiceHelper.query((String)"eb_templateentity", (String)"number, name", (QFilter[])new QFilter[]{qFilter}, (String)"number");
            int rowIndex = 1;
            for (DynamicObject template : templates) {
                ExcelHelper.setCellValue((XSSFSheet)sheet, null, (Integer)rowIndex, (Integer)2, (String)template.getString("number"));
                ExcelHelper.setCellValue((XSSFSheet)sheet, null, (Integer)rowIndex++, (Integer)3, (String)template.getString("name"));
            }
            String[] values = new String[]{ResManager.loadKDString((String)"\u542f\u7528", (String)"OffsetRuleListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7981\u7528", (String)"OffsetRuleListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0])};
            ApproveTypeUtils.getInstance().addDropDown(workBook, values, Integer.valueOf(3), Integer.valueOf(100), Integer.valueOf(colIndex), Integer.valueOf(colIndex));
            String fileName = ResManager.loadKDString((String)"\u5ba1\u6279\u7c7b\u578b\u5bfc\u5165\u6a21\u677f", (String)"ApproveTypeImportPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            try {
                url = ImportAndExportUtil.writeFile((Workbook)workBook, (String)fileName);
            }
            catch (IOException ex) {
                log.error((Throwable)ex);
                throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u4e0b\u8f7d\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ApproveTypeImportPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isNotEmpty((String)url)) {
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
            }
        }
        catch (Exception ex) {
            if (ex instanceof KDBizException) {
                throw ex;
            }
            log.error((Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u4e0b\u8f7d\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ApproveTypeImportPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
        }
    }

    @Override
    protected Pair<Integer, Integer> getTitleRow() {
        return new Pair((Object)2, (Object)2);
    }

    @Override
    protected void importFileData(InputStream inputStream) {
        XSSFRow row;
        XSSFWorkbook workBook = this.getWorkBook(inputStream);
        boolean addAndUpdate = this.isAddAndUpdate();
        Long modelId = this.getModelId();
        boolean isNewEB = NewEbAppUtil.isNewEbModel((Long)modelId);
        XSSFSheet sheet = workBook.getSheetAt(0);
        int rowIndex = 2;
        if (this.checkTitleValidate(row = sheet.getRow(rowIndex++), isNewEB)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0e\u5bfc\u5165\u6a21\u677f\u683c\u5f0f\u4e0d\u5339\u914d\u3002", (String)"ApproveTypeImportPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<String> approveTypes = new ArrayList<String>(16);
        HashMap<String, List<String>> templateInBizModel = new HashMap<String, List<String>>(16);
        HashMap<String, Long> approveTypeInfo = new HashMap<String, Long>(16);
        HashMap<String, Long> bizModelInfo = new HashMap<String, Long>(16);
        HashMap<String, Long> templateInfo = new HashMap<String, Long>(16);
        ArrayList<String> hasExistTemplates = new ArrayList<String>(16);
        HashMap<String, List<String>> _templatesInApproveType = new HashMap<String, List<String>>(16);
        this.prepareDataFromApproveType(approveTypes, approveTypeInfo, hasExistTemplates, _templatesInApproveType);
        this.prepareDataFromTemplate(templateInBizModel, bizModelInfo, templateInfo);
        Map<String, CentralScheme> centralSchemaMap = this.getCentralSchemaInfo(this.getModelId());
        HashSet<String> toImportTypeNumbers = new HashSet<String>(16);
        ArrayList<String> toImportTemplates = new ArrayList<String>(16);
        HashMap<String, Long> toUpdateTypes = new HashMap<String, Long>(16);
        HashMap<String, DynamicObject> modifyTypes = new HashMap<String, DynamicObject>(16);
        int lastRowNum = sheet.getLastRowNum();
        while (rowIndex <= lastRowNum) {
            String schemaNumber;
            String centralSplitValue;
            String templateNumber;
            String status;
            int colIndex;
            String statusName;
            String approveTypeName;
            String approveType;
            XSSFCell cell;
            String bizNumber;
            if (this.isRowEmpty(row = sheet.getRow(rowIndex++))) continue;
            if (isNewEB) {
                bizNumber = this.getDefaultBizModel(modelId);
                if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)bizNumber)) {
                    this.recordErrorInfo(sheet, row, ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4e0d\u5b58\u5728\u9ed8\u8ba4\u4e1a\u52a1\u6a21\u578b\u3002", (String)"ApproveTypeImportPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    continue;
                }
            } else {
                cell = row.getCell(2);
                bizNumber = this.getCellValue(cell, 2);
                if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)bizNumber)) {
                    this.recordErrorInfo(sheet, row, ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ApproveTypeImportPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    continue;
                }
                if (!bizModelInfo.containsKey(bizNumber)) {
                    this.recordErrorInfo(sheet, row, ResManager.loadResFormat((String)"\u4e1a\u52a1\u6a21\u578b\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ApproveTypeImportPlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[]{bizNumber}));
                    continue;
                }
            }
            if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)(approveType = this.getCellValue(cell = row.getCell(0), 0)))) {
                this.recordErrorInfo(sheet, row, ResManager.loadKDString((String)"\u5ba1\u6279\u7c7b\u578b\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ApproveTypeImportPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (toImportTypeNumbers.contains(approveType)) {
                String errMsg = ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6570\u636e\u4e2d\u5b58\u5728\u76f8\u540c\u5ba1\u6279\u7c7b\u578b\u7f16\u7801\uff0c\u4f46\u4e0d\u540c\u5ba1\u6279\u7c7b\u578b\u540d\u79f0\u7684\u6570\u636e\u3002", (String)"ApproveTypeImportPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.recordErrorInfo(sheet, row, errMsg);
                continue;
            }
            boolean isNotExistApproveType = true;
            if (approveTypes.contains(approveType)) {
                if (!addAndUpdate) {
                    String errMsg = ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4e0b\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u7801\u7684\u5ba1\u6279\u7c7b\u578b\u3002", (String)"ApproveTypeImportPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    if (isNewEB) {
                        errMsg = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u7801\u7684\u5ba1\u6279\u7c7b\u578b\u3002", (String)"ApproveTypeImportPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    }
                    this.recordErrorInfo(sheet, row, errMsg);
                    continue;
                }
                Long approveTypeId = (Long)approveTypeInfo.get(approveType);
                toUpdateTypes.put(approveType, approveTypeId);
            }
            toImportTypeNumbers.add(approveType);
            DynamicObject approveTypeDynamic = (DynamicObject)modifyTypes.get(approveType);
            if (approveTypeDynamic == null) {
                approveTypeDynamic = BusinessDataServiceHelper.newDynamicObject((String)"eb_approvaltypeentity");
                approveTypeDynamic.set("model", (Object)modelId);
                approveTypeDynamic.set("audit_type", (Object)"0");
            } else {
                isNotExistApproveType = false;
            }
            if (isNotExistApproveType) {
                approveTypeDynamic.set("number", (Object)approveType);
            }
            if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)(approveTypeName = this.getCellValue(cell = row.getCell(1), 1)))) {
                this.recordErrorInfo(sheet, row, ResManager.loadKDString((String)"\u5ba1\u6279\u7c7b\u578b\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ApproveTypeImportPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (isNotExistApproveType) {
                approveTypeDynamic.set("name", (Object)approveTypeName);
            }
            if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)(statusName = this.getCellValue(cell = row.getCell(colIndex = isNewEB ? 4 : 6), colIndex)))) {
                this.recordErrorInfo(sheet, row, ResManager.loadKDString((String)"\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (String)"ApproveTypeImportPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            String string = status = ResManager.loadKDString((String)"\u542f\u7528", (String)"ApproveTypeImportPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]).equals(statusName) ? "1" : "0";
            if (isNotExistApproveType) {
                approveTypeDynamic.set("status", (Object)status);
            }
            if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)(templateNumber = this.getCellValue(cell = row.getCell(colIndex = isNewEB ? 2 : 4), colIndex)))) {
                this.recordErrorInfo(sheet, row, ResManager.loadKDString((String)"\u9884\u7b97\u6a21\u677f\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ApproveTypeImportPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            StringBuilder errorTemplateNums = new StringBuilder();
            Set templateNumbers = Arrays.stream(templateNumber.split(",")).collect(Collectors.toSet());
            for (String templateNum : templateNumbers) {
                List templatesInBizModel = (List)templateInBizModel.get(bizNumber);
                if (templatesInBizModel.contains(templateNum)) continue;
                errorTemplateNums.append(templateNum).append(",");
            }
            if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)errorTemplateNums.toString())) {
                String errorStr = errorTemplateNums.substring(0, errorTemplateNums.length() - 1);
                String errMsg = ResManager.loadResFormat((String)"\u4e1a\u52a1\u6a21\u578b\u201c%1\u201d\u4e0b\u9884\u7b97\u6a21\u677f\u7f16\u7801\u201c%2\u201d\u4e0d\u5b58\u5728", (String)"ApproveTypeImportPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[]{bizNumber, errorStr});
                if (isNewEB) {
                    errMsg = ResManager.loadResFormat((String)"\u9884\u7b97\u6a21\u677f\u7f16\u7801\u201c%1\u201d\u4e0d\u5b58\u5728", (String)"ApproveTypeImportPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[]{errorStr});
                }
                this.recordErrorInfo(sheet, row, errMsg);
                continue;
            }
            if (toImportTemplates.contains(templateNumber)) {
                String errMsg = ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6570\u636e\u4e2d\u5b58\u5728\u76f8\u540c\u9884\u7b97\u6a21\u677f\u7f16\u7801\u7684\u6570\u636e\u3002", (String)"ApproveTypeImportPlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.recordErrorInfo(sheet, row, errMsg);
                continue;
            }
            if ("1".equals(status)) {
                List _hasExistTemplates = _templatesInApproveType.getOrDefault(approveType, new ArrayList(16));
                ArrayList<String> tmp = new ArrayList<String>(hasExistTemplates);
                tmp.removeAll(_hasExistTemplates);
                for (String templateNum : templateNumbers) {
                    if (!tmp.contains(templateNum)) continue;
                    errorTemplateNums.append(templateNum).append(",");
                }
                if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)errorTemplateNums.toString())) {
                    String errorStr = errorTemplateNums.substring(0, errorTemplateNums.length() - 1);
                    String errMsg = ResManager.loadResFormat((String)"\u6a21\u677f\u201c%1\u201d\u5df2\u5b58\u5728\u4e8e\u76f8\u540c\u4f53\u7cfb\u4e0b\u7684\u5ba1\u6279\u7c7b\u578b\u4e2d\u3002", (String)"ApproveTypeImportPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[]{errorStr});
                    if (isNewEB) {
                        errMsg = ResManager.loadResFormat((String)"\u6a21\u677f\u201c%1\u201d\u5df2\u5b58\u5728\u4e8e\u5176\u4ed6\u5ba1\u6279\u7c7b\u578b\u4e2d\u3002", (String)"ApproveTypeImportPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[]{errorStr});
                    }
                    this.recordErrorInfo(sheet, row, errMsg);
                    continue;
                }
            }
            toImportTemplates.add(templateNumber);
            colIndex = isNewEB ? 5 : 7;
            cell = row.getCell(colIndex);
            String centralSplit = this.getCellValue(cell, colIndex);
            String string2 = centralSplitValue = ResManager.loadKDString((String)"\u662f", (String)"ControlBillCheckListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]).equals(centralSplit) ? "1" : "0";
            if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)centralSplitValue)) {
                approveTypeDynamic.set("centralsplit", (Object)centralSplitValue);
            }
            if ("1".equals(centralSplitValue) && kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)(schemaNumber = this.getCellValue(cell = row.getCell(colIndex = isNewEB ? 6 : 8), colIndex)))) {
                StringBuilder errorSchemaNums = new StringBuilder();
                Set schemaNumbers = Arrays.stream(schemaNumber.split(",")).collect(Collectors.toSet());
                for (String schemaNum : schemaNumbers) {
                    if (centralSchemaMap.containsKey(schemaNum)) continue;
                    errorSchemaNums.append(schemaNum).append(",");
                }
                if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)errorSchemaNums.toString())) {
                    String errorStr = errorSchemaNums.substring(0, errorSchemaNums.length() - 1);
                    String errMsg = ResManager.loadResFormat((String)"\u5f52\u53e3\u65b9\u6848\u7f16\u7801\u201c%1\u201d\u4e0d\u5b58\u5728", (String)"ApproveTypeImportPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[]{errorStr});
                    this.recordErrorInfo(sheet, row, errMsg);
                    continue;
                }
                DynamicObjectCollection centralRelationColl = approveTypeDynamic.getDynamicObjectCollection("entryentity_relation");
                for (String schemaNum : schemaNumbers) {
                    CentralScheme centralScheme = centralSchemaMap.get(schemaNum);
                    DynamicObject centralRelation = centralRelationColl.addNew();
                    centralRelation.set("budgetorg", (Object)centralScheme.getCollectEntity());
                    centralRelation.set("centralschema", (Object)centralScheme.getId());
                }
            }
            approveTypeDynamic.set("bizmodel", bizModelInfo.get(bizNumber));
            DynamicObjectCollection allocateRecords = approveTypeDynamic.getDynamicObjectCollection("entryentity");
            for (String templateNum : templateNumbers) {
                DynamicObject allocateRecord = allocateRecords.addNew();
                allocateRecord.set("template", templateInfo.get(templateNum));
                allocateRecord.set("audittype", (Object)"0");
            }
            modifyTypes.put(approveType, approveTypeDynamic);
        }
        HashSet toUpdateTypeIds = new HashSet(16);
        modifyTypes.keySet().forEach(e -> {
            Long updateTypeId = (Long)toUpdateTypes.get(e);
            if (updateTypeId != null) {
                toUpdateTypeIds.add(updateTypeId);
            }
        });
        DynamicObject[] updateTypeDynamics = BusinessDataServiceHelper.load((Object[])toUpdateTypeIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_approvaltypeentity"));
        HashMap<Long, DynamicObject> updateTypeMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject updateTypeDynamic : updateTypeDynamics) {
            updateTypeMap.put(updateTypeDynamic.getLong("id"), updateTypeDynamic);
        }
        ArrayList<DynamicObject> addTypes = new ArrayList<DynamicObject>(16);
        for (Map.Entry modifyType : modifyTypes.entrySet()) {
            String signKey = (String)modifyType.getKey();
            DynamicObject typeDynamic = (DynamicObject)modifyType.getValue();
            Long approveId = (Long)toUpdateTypes.get(signKey);
            if (approveId == null) {
                addTypes.add(typeDynamic);
                continue;
            }
            DynamicObject updateType = (DynamicObject)updateTypeMap.get(approveId);
            this.copyDynamicValue(updateType, typeDynamic);
        }
        if (this.errorBook.getNumberOfSheets() != 0) {
            String errFileName = ResManager.loadKDString((String)"\u5ba1\u6279\u7c7b\u578b-\u5bfc\u5165\u6570\u636e\u9519\u8bef\u8be6\u60c5", (String)"ApproveTypeImportPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.downLoadFailFile(errFileName, true);
            return;
        }
        try (TXHandle tx = TX.required((String)"importApproveTypeData");){
            try {
                MultiLangEnumBridge opNameBridge;
                Set numbers;
                SaveServiceHelper.save((DynamicObject[])addTypes.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])updateTypeDynamics);
                if (addAndUpdate) {
                    numbers = Arrays.stream(updateTypeDynamics).map(e -> e.getString("number")).collect(Collectors.toSet());
                    opNameBridge = new MultiLangEnumBridge("\u5bfc\u5165-\u8ffd\u52a0\u5e76\u66f4\u65b0", "ApproveTypeImportPlugin_30", "epm-eb-formplugin");
                } else {
                    numbers = addTypes.stream().map(e -> e.getString("number")).collect(Collectors.toSet());
                    opNameBridge = new MultiLangEnumBridge("\u5bfc\u5165-\u65b0\u589e", "ApproveTypeImportPlugin_31", "epm-eb-formplugin");
                }
                MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u7f16\u7801%1$s\uff0c\u5bfc\u5165\u6210\u529f", "ApproveTypeImportPlugin_32", "epm-eb-formplugin");
                OperationLogUtil.log((String)this.getBizAppId(), (String)"eb_approvaltypelist_new", (String)"", (String)"", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, (String[])new String[]{String.join((CharSequence)"\u3001", numbers)});
                this.getView().returnDataToParent((Object)"successful");
                this.getView().close();
            }
            catch (Exception ex) {
                tx.markRollback();
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u65f6\uff0c\u53d1\u751f\u6570\u636e\u5199\u5165\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ApproveTypeImportPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private String getDefaultBizModel(Long modelId) {
        DynamicObject defaultObj;
        if (this.defaultBizModel == null && (defaultObj = NewEbAppUtil.getDefaultObj((String)"eb_businessmodel", (Long)modelId)) != null) {
            this.defaultBizModel = defaultObj.getString("number");
        }
        return this.defaultBizModel;
    }

    private boolean checkTitleValidate(XSSFRow row, boolean isNewEB) {
        if (isNewEB) {
            return this.checkCellValue(row, 0, ResManager.loadKDString((String)"*\u5ba1\u6279\u7c7b\u578b\u7f16\u7801", (String)"ApproveTypeImportPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0])) || this.checkCellValue(row, 1, ResManager.loadKDString((String)"*\u5ba1\u6279\u7c7b\u578b\u540d\u79f0", (String)"ApproveTypeImportPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0])) || this.checkCellValue(row, 2, ResManager.loadKDString((String)"*\u9884\u7b97\u6a21\u677f\u7f16\u7801", (String)"ApproveTypeImportPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0])) || this.checkCellValue(row, 3, ResManager.loadKDString((String)"\u9884\u7b97\u6a21\u677f\u540d\u79f0", (String)"ApproveTypeImportPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0])) || this.checkCellValue(row, 4, ResManager.loadKDString((String)"*\u72b6\u6001", (String)"ApproveTypeImportPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0])) || this.checkCellValue(row, 5, ResManager.loadKDString((String)"\u5f52\u53e3\u62c6\u5206\u6d41\u7a0b", (String)"ApproveTypeImportPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0])) || this.checkCellValue(row, 6, ResManager.loadKDString((String)"\u5f52\u53e3\u65b9\u6848\u7f16\u7801", (String)"ApproveTypeImportPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0])) || this.checkCellValue(row, 7, ResManager.loadKDString((String)"\u5f52\u53e3\u65b9\u6848\u540d\u79f0", (String)"ApproveTypeImportPlugin_38", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return this.checkCellValue(row, 0, ResManager.loadKDString((String)"*\u5ba1\u6279\u7c7b\u578b\u7f16\u7801", (String)"ApproveTypeImportPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0])) || this.checkCellValue(row, 1, ResManager.loadKDString((String)"*\u5ba1\u6279\u7c7b\u578b\u540d\u79f0", (String)"ApproveTypeImportPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0])) || this.checkCellValue(row, 2, ResManager.loadKDString((String)"*\u4e1a\u52a1\u6a21\u578b\u7f16\u7801", (String)"ApproveTypeImportPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0])) || this.checkCellValue(row, 3, ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b\u540d\u79f0", (String)"ApproveTypeImportPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0])) || this.checkCellValue(row, 4, ResManager.loadKDString((String)"*\u9884\u7b97\u6a21\u677f\u7f16\u7801", (String)"ApproveTypeImportPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0])) || this.checkCellValue(row, 5, ResManager.loadKDString((String)"\u9884\u7b97\u6a21\u677f\u540d\u79f0", (String)"ApproveTypeImportPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0])) || this.checkCellValue(row, 6, ResManager.loadKDString((String)"*\u72b6\u6001", (String)"ApproveTypeImportPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0])) || this.checkCellValue(row, 7, ResManager.loadKDString((String)"\u5f52\u53e3\u62c6\u5206\u6d41\u7a0b", (String)"ApproveTypeImportPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0])) || this.checkCellValue(row, 8, ResManager.loadKDString((String)"\u5f52\u53e3\u65b9\u6848\u7f16\u7801", (String)"ApproveTypeImportPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0])) || this.checkCellValue(row, 9, ResManager.loadKDString((String)"\u5f52\u53e3\u65b9\u6848\u540d\u79f0", (String)"ApproveTypeImportPlugin_38", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private boolean checkCellValue(XSSFRow row, int cellIndex, String checkMessage) {
        XSSFCell cell = row.getCell(cellIndex);
        String cellValue = this.getCellValue(cell, cellIndex);
        return !checkMessage.equals(cellValue) && !checkMessage.equals(cellValue.trim());
    }

    private void prepareDataFromApproveType(List<String> approveTypeNumbers, Map<String, Long> approveTypeInfo, List<String> templates, Map<String, List<String>> _templatesInApproveType) {
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        String field = "id,number,audit_type,curdataversion,entryentity.audittype as audittype,entryentity.dataversion as dataversion,entryentity.template.number as templatenumber,status";
        DynamicObjectCollection approveTypes = QueryServiceHelper.query((String)"eb_approvaltypeentity", (String)field, (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject approveType : approveTypes) {
            List _templates;
            long _dataVersion;
            long dataVersion;
            String _auditType;
            String auditType;
            String number = approveType.getString("number");
            Long pkId = approveType.getLong("id");
            if (!approveTypeInfo.containsKey(number)) {
                approveTypeInfo.put(number, pkId);
            }
            if (!approveTypeNumbers.contains(number)) {
                approveTypeNumbers.add(number);
            }
            if (!(auditType = approveType.getString("audit_type")).equals(_auditType = approveType.getString("audittype")) || (dataVersion = approveType.getLong("curdataversion")) != (_dataVersion = approveType.getLong("dataversion")) || !approveType.getBoolean("status")) continue;
            String templateNumber = approveType.getString("templatenumber");
            if (!templates.contains(templateNumber)) {
                templates.add(templateNumber);
            }
            if ((_templates = _templatesInApproveType.computeIfAbsent(number, k -> new ArrayList(16))).contains(templateNumber)) continue;
            _templates.add(templateNumber);
        }
    }

    private void prepareDataFromTemplate(Map<String, List<String>> templateInBizModel, Map<String, Long> bizModelInfo, Map<String, Long> templateInfo) {
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        DynamicObjectCollection businessModels = QueryServiceHelper.query((String)"eb_businessmodel", (String)"id, number", (QFilter[])new QFilter[]{qFilter});
        businessModels.forEach(e -> bizModelInfo.put(e.getString("number"), e.getLong("id")));
        QFilter bizQFilter = new QFilter("businessmodel", "in", bizModelInfo.values());
        DynamicObjectCollection datasets = QueryServiceHelper.query((String)"eb_dataset", (String)"id, businessmodel.number as biznumber", (QFilter[])new QFilter[]{qFilter, bizQFilter});
        HashMap bizDatasetMap = new HashMap(16);
        datasets.forEach(e -> bizDatasetMap.put(e.getLong("id"), e.getString("biznumber")));
        QFilter datasetQFilter = new QFilter("dataset", "in", bizDatasetMap.keySet());
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"eb_templateentity", (String)"id, number, dataset.id as datasetid", (QFilter[])new QFilter[]{qFilter, datasetQFilter});
        for (DynamicObject template : templates) {
            long datasetId;
            String bizNumber;
            long templateId = template.getLong("id");
            String tempNumber = template.getString("number");
            if (!templateInfo.containsKey(tempNumber)) {
                templateInfo.put(tempNumber, templateId);
            }
            if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)(bizNumber = (String)bizDatasetMap.get(datasetId = template.getLong("datasetid"))))) continue;
            List relateTemplates = templateInBizModel.computeIfAbsent(bizNumber, k -> new ArrayList(16));
            relateTemplates.add(tempNumber);
        }
    }

    private void copyDynamicValue(DynamicObject updateType, DynamicObject fromDynamic) {
        updateType.set("name", fromDynamic.get("name"));
        updateType.set("number", fromDynamic.get("number"));
        updateType.set("bizmodel", fromDynamic.get("bizmodel"));
        updateType.set("status", fromDynamic.get("status"));
        DynamicObjectCollection records = updateType.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection fromRecords = fromDynamic.getDynamicObjectCollection("entryentity");
        long curDataVersion = updateType.getLong("curdataversion");
        boolean isDetailChanged = this.checkDataChanged(records, fromRecords, curDataVersion);
        if (isDetailChanged) {
            updateType.set("curdataversion", (Object)(++curDataVersion));
            HashSet<Long> templates = new HashSet<Long>(16);
            for (DynamicObject fromRecord : fromRecords) {
                fromRecord.set("dataversion", (Object)curDataVersion);
                templates.add(fromRecord.getLong("template"));
            }
            List dynamicObjects = ApproveTypeUtils.getInstance().filterCurVersionData(records, curDataVersion - 1L, "0");
            for (DynamicObject record : dynamicObjects) {
                long template = record.getLong("template.id");
                if (templates.contains(template)) continue;
                DynamicObject dynamicObject = fromRecords.addNew();
                DynamicObjectUtils.copy((DynamicObject)record, (DynamicObject)dynamicObject);
                dynamicObject.set("dataversion", (Object)curDataVersion);
            }
            records.addAll((Collection)fromRecords);
        }
    }

    private boolean checkDataChanged(DynamicObjectCollection records, DynamicObjectCollection fromRecords, long curDataVersion) {
        if (records.size() == 0 && fromRecords.size() != 0) {
            return true;
        }
        int notChangeSize = 0;
        boolean isDetailChanged = false;
        for (DynamicObject record : records) {
            long dataVersion = record.getLong("dataversion");
            if (dataVersion != curDataVersion) continue;
            boolean containCurTemplate = false;
            long template = record.getLong("template.id");
            for (DynamicObject fromRecord : fromRecords) {
                long template_record = fromRecord.getLong("template");
                if (template != template_record) continue;
                containCurTemplate = true;
                break;
            }
            if (containCurTemplate) {
                ++notChangeSize;
                continue;
            }
            isDetailChanged = true;
            break;
        }
        if (fromRecords.size() > notChangeSize) {
            isDetailChanged = true;
        }
        return isDetailChanged;
    }

    private Map<String, CentralScheme> getCentralSchemaInfo(Long modelId) {
        QFilter qFilter = new QFilter("centralrange.model", "=", (Object)modelId);
        DynamicObject[] centralSchemaArr = BusinessDataServiceHelper.load((String)"eb_centralrelscheme", (String)"id,number,centralrange.model,entity.id", (QFilter[])qFilter.toArray());
        HashMap<String, CentralScheme> centralSchemaMap = new HashMap<String, CentralScheme>(centralSchemaArr.length);
        for (DynamicObject centralSchema : centralSchemaArr) {
            CentralScheme centralSchemeDto = new CentralScheme();
            centralSchemeDto.setId(Long.valueOf(centralSchema.getLong("id")));
            centralSchemeDto.setCollectEntity(Long.valueOf(centralSchema.getLong("entity.id")));
            centralSchemaMap.put(centralSchema.getString("number"), centralSchemeDto);
        }
        return centralSchemaMap;
    }
}

