/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.bailorg;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.bailorg.BailOrgService;
import kd.epm.eb.business.bailorg.entity.SimpleObject;
import kd.epm.eb.business.bailorg.graph.ForwardLine;
import kd.epm.eb.business.bailorg.graph.GraphHouse;
import kd.epm.eb.business.bailorg.pojo.BailOrgRelation;
import kd.epm.eb.business.servicehelper.DimensionServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.excel.BgExcelWriter;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.bailorg.BailOrgUtil;
import kd.epm.eb.formplugin.bgadjust.utils.AdjustUtil;
import kd.epm.eb.formplugin.utils.TreeSearchUtil;
import kd.epm.eb.model.permission.MemberPermHelper;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.poi.ss.usermodel.CellStyle;

public class BailOrgFormPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
TreeNodeQueryListener,
BeforeF7SelectListener,
AfterF7SelectListener,
TreeNodeClickListener {
    public static final String MODEL = "model";
    public static final String BTN_SAVE = "btn_save";
    public static final String BTN_QUERY = "btn_query";
    public static final String BTN_IMPORT = "btn_import";
    public static final String BTN_EXPORT = "btn_export";
    public static final String BTN_BAIL_BY_NUMBER = "btn_bailbynumber";
    public static final String BTN_ADD_ROW = "btn_addrow";
    public static final String BTN_EXIT = "btn_exit";
    public static final String SEARCH = "search";
    public static final String SEARCH_BEFORE = "searchbefore";
    public static final String SEARCH_NEXT = "searchnext";
    public static final String ORG_VIEW_TREE = "orgviewtree";
    public static final String ENTITY_TREE_ENTRY = "entity_entry";
    public static final String BAIL_ORG_ENTRY = "bailorg_entry";
    public static final String CACHE_ORG_VIEW_TREE = "cache_org_view_tree";
    public static final String CACHE_ORG_TREE = "cache_org_tree";
    public static final String CACHE_ENTITY_BAIL_ORG = "cache_entity_bail_org";
    public static final String CACHE_DATA_CHANGED = "cache_data_changed";
    public static final String BAIL_ORG_SEL_CALL_BACK = "bail_org_call_back";
    public static final String BAIL_ORG_IMPORT_CALL_BACK = "bail_org_import_back";
    public static final String BEFORE_EXIT_BACK = "before_exit_back";
    public static final int MAX_COUNT_BAIL_ORG = 1000;
    BailOrgService bailOrgService = BailOrgService.getInstance();
    BailOrgUtil bailOrgUtil = BailOrgUtil.getInstance();
    private static final Log log = LogFactory.getLog(BailOrgFormPlugin.class);
    private boolean sign = true;

    @Override
    public void ebPreOpen(PreOpenFormEventArgs e) {
        super.ebPreOpen(e);
        this.checkViewPerm(e);
    }

    private void checkViewPerm(PreOpenFormEventArgs e) {
        Long userId = this.getUserId();
        Long modelId = IDUtils.toLong((Object)e.getFormShowParameter().getCustomParam(MODEL));
        int is = this.checkItemPermission(userId, modelId, AppMetadataCache.getAppInfo((String)e.getFormShowParameter().getAppId()).getId(), e.getFormShowParameter().getFormId(), "47150e89000000ac");
        if (is == 0) {
            if (MemberPermHelper.ifUserHasRootPermByModel((Long)userId, (Long)modelId)) {
                return;
            }
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u59d4\u6258\u7ec4\u7ec7\u7ef4\u62a4\u7684\u67e5\u770b\u6743\u9650\uff01", (String)"BailOrgQueryFormPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public void initialize() {
        super.initialize();
        TreeEntryGrid memberTree = (TreeEntryGrid)this.getControl(ENTITY_TREE_ENTRY);
        memberTree.addCellClickListener((TreeNodeQueryListener)this);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit model = (BasedataEdit)this.getControl(MODEL);
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        model.addAfterF7SelectListener((AfterF7SelectListener)this);
        this.addItemClickListeners(new String[]{"toolbarap", "advcontoolbarap", "advcontoolbarap1"});
        this.addClickListeners(new String[]{SEARCH_BEFORE, SEARCH_NEXT});
        this.addOrgViewTreeSearchListener();
        this.addTreeNodeClickListener(this, ORG_VIEW_TREE);
        EntryGrid entityTreeEntry = (EntryGrid)this.getControl(ENTITY_TREE_ENTRY);
        entityTreeEntry.addRowClickListener((RowClickEventListener)this);
    }

    private void addOrgViewTreeSearchListener() {
        Search search = (Search)this.getView().getControl(SEARCH);
        search.addEnterListener(event -> {
            if (event.getText() != null && !"".equals(event.getText())) {
                TreeSearchUtil.searchMember(event.getText().toLowerCase().trim(), this.getView(), this.getPageCache(), new TreeSearchUtil.TreeSearchParam(ORG_VIEW_TREE, CACHE_ORG_VIEW_TREE));
                TreeView viewTree = (TreeView)this.getControl(ORG_VIEW_TREE);
                this.treeNodeClick(new TreeNodeEvent((Object)viewTree, null, (Object)viewTree.getTreeState().getFocusNodeId()));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"BailOrgFormPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        this.initModel();
        this.loadPageData();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (AdjustUtil.isEBModel(this.getModelId())) {
            SplitContainer control = (SplitContainer)this.getControl("splitcontainerap");
            control.hidePanel(SplitDirection.left, true);
        }
    }

    private void initCacheAllEntityBailOrgRelation() {
        Map modelBailOrgRelation = this.bailOrgService.getModelBailOrgRelation(this.getModelId(), null);
        this.cacheEntityBailOrgRelation(modelBailOrgRelation);
    }

    private void initModel() {
        Long modelId = this.getModelId();
        this.getPageCache().put(MODEL, String.valueOf(modelId));
        this.getModel().setValue(MODEL, (Object)modelId);
    }

    private void loadPageData() {
        this.getPageCache().remove(CACHE_ENTITY_BAIL_ORG);
        this.getPageCache().remove(CACHE_ORG_VIEW_TREE);
        this.getPageCache().remove(CACHE_ORG_TREE);
        if (IDUtils.isEmptyLong((Long)this.getModelId()).booleanValue()) {
            return;
        }
        this.initCacheAllEntityBailOrgRelation();
        this.loadOrgViewTree();
        this.setDataChanged(false);
    }

    private void loadOrgViewTree() {
        IModelCacheHelper modelCache = this.getModelCache();
        Long modelId = modelCache.getModelobj().getId();
        Dimension dimension = modelCache.getDimension("Entity");
        String selectFields = "id,number,name,parent,dseq";
        List dimensionViews = DimensionServiceHelper.queryAllView((Long)modelId, (Long)dimension.getId(), (String)selectFields);
        TreeNode root = new TreeNode("", "root", ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe", (String)"BailOrgFormPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        root.setDisabled(true);
        this.buildTree(dimensionViews, root);
        this.putTreeNodeToCache(root, true);
        TreeView orgViewTree = (TreeView)this.getControl(ORG_VIEW_TREE);
        orgViewTree.deleteAllNodes();
        orgViewTree.addNode(root);
        orgViewTree.expand("root");
        List children = root.getChildren();
        if (CollectionUtils.isNotEmpty((Collection)children)) {
            TreeNode firstChildNode = (TreeNode)children.get(0);
            orgViewTree.focusNode(firstChildNode);
            this.treeNodeClick(new TreeNodeEvent((Object)orgViewTree, (Object)"root", (Object)firstChildNode.getId()));
        } else {
            orgViewTree.focusNode(root);
            this.treeNodeClick(new TreeNodeEvent((Object)orgViewTree, (Object)"root", (Object)root.getId()));
        }
    }

    private void buildTree(List<DynamicObject> dimensionViews, TreeNode root) {
        for (DynamicObject object : dimensionViews) {
            String id = object.getString("id");
            TreeNode child = new TreeNode("0", id, object.getString("name"));
            child.setLongNumber(object.getString("number"));
            child.setIsOpened(true);
            root.addChild(child);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Control source = (Control)evt.getSource();
        String sourceKey = source.getKey();
        if (ORG_VIEW_TREE.equals(sourceKey)) {
            this.loadOrgTreeEntry();
        }
    }

    private void loadOrgTreeEntry() {
        this.getPageCache().remove("curSelRowEntityNumber");
        TreeNode curSelViewNode = this.getCurSelViewNode();
        if (curSelViewNode == null) {
            return;
        }
        Long viewId = IDUtils.toLong((Object)curSelViewNode.getId());
        TreeNode orgTree = this.bailOrgService.buildEntityMemberTree(this.getModelId(), viewId.longValue(), curSelViewNode.getLongNumber(), true, null);
        this.putTreeNodeToCache(orgTree, false);
        this.getModel().deleteEntryData(ENTITY_TREE_ENTRY);
        this.getModel().deleteEntryData(BAIL_ORG_ENTRY);
        if (StringUtils.isEmpty((String)orgTree.getLongNumber()) || StringUtils.isEmpty((String)orgTree.getText())) {
            return;
        }
        int newEntryRow = this.getModel().createNewEntryRow(ENTITY_TREE_ENTRY);
        DynamicObject rowEntity = this.getModel().getEntryRowEntity(ENTITY_TREE_ENTRY, newEntryRow);
        this.fillEntityTreeEntry(orgTree, rowEntity);
        if (kd.epm.eb.common.utils.CollectionUtils.isEmpty((Collection)orgTree.getChildren())) {
            this.getView().updateView(ENTITY_TREE_ENTRY);
        } else {
            TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(ENTITY_TREE_ENTRY);
            if (kd.epm.eb.common.utils.CollectionUtils.isNotEmpty((Collection)orgTree.getChildren())) {
                this.loadCurEntityChildRows(0);
                entryGrid.expandOne(0);
            }
        }
    }

    private void fillEntityTreeEntry(TreeNode treeNode, DynamicObject rowEntity) {
        rowEntity.set("entityid", (Object)treeNode.getId());
        rowEntity.set("entitynumber", (Object)treeNode.getLongNumber());
        rowEntity.set("entityname", (Object)treeNode.getText());
        if (kd.epm.eb.common.utils.CollectionUtils.isNotEmpty((Collection)treeNode.getChildren())) {
            rowEntity.set("isgroupnode", (Object)true);
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        int rowKey = evt.getRowKey();
        this.loadCurEntityChildRows(rowKey);
    }

    private void loadCurEntityChildRows(int rowKey) {
        String entityId;
        TreeNode treeNode = this.getTreeNodeFromCache(false);
        TreeNode curEntityNode = treeNode.getTreeNode(entityId = (String)this.getModel().getValue("entityid", rowKey), 20);
        if (curEntityNode == null) {
            return;
        }
        List children = curEntityNode.getChildren();
        if (kd.epm.eb.common.utils.CollectionUtils.isNotEmpty((Collection)children)) {
            this.getModel().beginInit();
            int[] index = this.getModel().batchInsertEntryRow(ENTITY_TREE_ENTRY, rowKey, children.size());
            int i = 0;
            for (TreeNode child : children) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity(ENTITY_TREE_ENTRY, index[i]);
                this.fillEntityTreeEntry(child, rowEntity);
                ++i;
            }
            this.getModel().endInit();
            this.getView().updateView(ENTITY_TREE_ENTRY);
        }
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(ENTITY_TREE_ENTRY);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTITY_TREE_ENTRY);
        if (kd.epm.eb.common.utils.CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            String cacheSelRowEntityNumber = this.getCacheSelRowEntityNumber();
            for (DynamicObject object : entryEntity) {
                if (!StringUtils.equals((String)object.getString("entitynumber"), (String)cacheSelRowEntityNumber)) continue;
                entryGrid.selectRows(object.getInt("seq") - 1);
                return;
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        Control control = (Control)evt.getSource();
        String controlKey = control.getKey();
        if (controlKey.equals(ENTITY_TREE_ENTRY)) {
            this.cacheCurSelRowEntityNumber();
            this.loadCurEntityBailOrg();
        }
    }

    private void cacheCurSelRowEntityNumber() {
        this.getPageCache().put("curSelRowEntityNumber", this.getCurSelEntityNumber());
    }

    private String getCacheSelRowEntityNumber() {
        return this.getPageCache().get("curSelRowEntityNumber");
    }

    private void loadCurEntityBailOrg() {
        BailOrgRelation bailOrgRelation = this.getCurEntityBailOrgRelation();
        this.getModel().beginInit();
        this.getModel().deleteEntryData(BAIL_ORG_ENTRY);
        if (bailOrgRelation != null && bailOrgRelation.getBailOrgSize() > 0) {
            int[] index = this.getModel().batchCreateNewEntryRow(BAIL_ORG_ENTRY, bailOrgRelation.getBailOrgSize());
            int i = 0;
            List bailOrgs = bailOrgRelation.getBailOrgs();
            Long defaultBailId = bailOrgRelation.getDefaultBailId();
            for (SimpleObject bailOrg : bailOrgs) {
                DynamicObject rowEntry = this.getModel().getEntryRowEntity(BAIL_ORG_ENTRY, index[i]);
                rowEntry.set("bailorgid", (Object)bailOrg.getId());
                rowEntry.set("orgnumber", (Object)bailOrg.getNumber());
                rowEntry.set("orgname", (Object)bailOrg.getName());
                if (bailOrg.getId().equals(defaultBailId)) {
                    rowEntry.set("default", (Object)true);
                }
                ++i;
            }
        }
        this.getModel().endInit();
        this.getView().updateView(BAIL_ORG_ENTRY);
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (BTN_EXIT.equals(itemKey) && this.getDataChanged()) {
            evt.setCancel(true);
            this.checkBeforeExit();
        }
    }

    private void checkBeforeExit() {
        String msg = ResManager.loadKDString((String)"\u5185\u5bb9\u5df2\u66f4\u6539\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u5e76\u9000\u51fa\uff1f\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"BailOrgFormPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        HashMap<Integer, String> btnNames = new HashMap<Integer, String>(2);
        String cancel = ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"BailOrgFormPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String sure = ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"BailOrgFormPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        btnNames.put(2, cancel);
        btnNames.put(6, sure);
        this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(BEFORE_EXIT_BACK), btnNames);
    }

    private boolean checkBeforeSave(Long modelId, Map<String, BailOrgRelation> allEntityBailOrgRelation) {
        if (allEntityBailOrgRelation == null || allEntityBailOrgRelation.size() == 0) {
            return false;
        }
        String msg = this.checkMoreToMore(modelId, allEntityBailOrgRelation);
        if (StringUtils.isNotEmpty((String)msg)) {
            this.getView().showErrorNotification(msg);
            return true;
        }
        return false;
    }

    public String checkMoreToMore(Long modelId, Map<String, BailOrgRelation> allEntityBailOrgRelation) {
        GraphHouse graphHouse = new GraphHouse();
        for (Map.Entry<String, BailOrgRelation> entry : allEntityBailOrgRelation.entrySet()) {
            BailOrgRelation bailOrgRelation = entry.getValue();
            for (SimpleObject bailOrg : bailOrgRelation.getBailOrgs()) {
                graphHouse.addLine((Object)bailOrgRelation.getEntityNumber(), (Object)bailOrg.getId());
            }
        }
        ForwardLine forwardLine = graphHouse.isExistMoreToMore();
        if (forwardLine != null) {
            Object entityNumber = forwardLine.getSource();
            DynamicObject entityObject = QueryServiceHelper.queryOne((String)SysDimensionEnum.Entity.getMemberTreemodel(), (String)"name", (QFilter[])new QFilter(MODEL, "=", (Object)modelId).and("number", "=", entityNumber).toArray());
            Object adminOrgId = forwardLine.getTarget();
            DynamicObject orgObject = QueryServiceHelper.queryOne((String)"bos_adminorg", (String)"name", (QFilter[])new QFilter("id", "=", adminOrgId).toArray());
            Object entityName = entityObject != null ? entityObject.getString("name") : entityNumber;
            Object orgName = orgObject != null ? orgObject.getString("name") : adminOrgId;
            return ResManager.loadResFormat((String)"\u9884\u7b97\u7ec4\u7ec7\u201c%1\u201d\u548c\u884c\u653f\u7ec4\u7ec7\u201c%2\u201d\u540c\u65f6\u5b58\u5728\u591a\u4e2a\u59d4\u6258\u5173\u7cfb\uff0c\u8bf7\u4fee\u6539\u3002", (String)"", (String)"", (Object[])new Object[]{entityName, orgName});
        }
        return "";
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_save": {
                this.saveData();
                break;
            }
            case "btn_query": {
                this.queryBailInfo();
                break;
            }
            case "btn_import": {
                this.importData();
                break;
            }
            case "btn_export": {
                this.exportData();
                break;
            }
            case "btn_addrow": {
                this.addBailOrgClick();
                break;
            }
            case "btn_bailbynumber": {
                this.autoBailByNumber();
                break;
            }
        }
    }

    private void queryBailInfo() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_bailorg_query");
        showParameter.setCustomParam(MODEL, (Object)this.getModelId());
        showParameter.setCustomParam("orgview", (Object)this.getCueSelOrgViewId());
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(showParameter);
    }

    private Long getCueSelOrgViewId() {
        TreeNode orgViewNode = this.getCurSelViewNode();
        if (orgViewNode == null) {
            return 0L;
        }
        DynamicObject query = QueryServiceHelper.queryOne((String)"eb_dimensionview", (String)"id", (QFilter[])new QFilter(MODEL, "=", (Object)this.getModelId()).and("number", "=", (Object)orgViewNode.getLongNumber()).toArray());
        if (query != null) {
            return query.getLong("id");
        }
        return 0L;
    }

    private TreeNode getCurSelViewNode() {
        TreeView control = (TreeView)this.getControl(ORG_VIEW_TREE);
        String focusNodeId = control.getTreeState().getFocusNodeId();
        TreeNode treeNodeFromCache = this.getTreeNodeFromCache(true);
        return treeNodeFromCache.getTreeNode(focusNodeId, 20);
    }

    private void importData() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epm_import");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam(MODEL, (Object)this.getModelId());
        showParameter.setCaption(ResManager.loadKDString((String)"\u59d4\u6258\u7ec4\u7ec7\u5bfc\u5165", (String)"BailOrgFormPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)"epm_import");
        formConfig.getPlugins().clear();
        showParameter.setFormConfig(formConfig);
        showParameter.addCustPlugin("kd.epm.eb.formplugin.bailorg.BailOrgImportFormPlugin");
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, BAIL_ORG_IMPORT_CALL_BACK);
        showParameter.setCloseCallBack(callBack);
        this.getView().showForm(showParameter);
    }

    private void exportData() {
        Long modelId = this.getModelId();
        boolean ebModel = ModelUtil.isEbModel((Long)modelId);
        Map allEntityBailOrgRelation = this.bailOrgService.getModelBailOrgRelation(modelId, null);
        TreeNode curOrgViewNode = this.getCurSelViewNode();
        if (curOrgViewNode == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"BailOrgFormPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        long viewId = 0L;
        try {
            viewId = Long.parseLong(curOrgViewNode.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String orgViewNumber = curOrgViewNode.getLongNumber();
        String orgViewName = curOrgViewNode.getText();
        DynamicObjectCollection viewEntityMembers = this.bailOrgService.getEntityMemberObjects(modelId, "id,number,name", viewId, orgViewNumber, true, null);
        BgExcelWriter excelWriter = BgExcelWriter.getInstance().readTemplateByClasspath(ebModel ? "bailorg/bailOrgRelationEb.xlsx" : "bailorg/bailOrgRelation.xlsx");
        this.bailOrgUtil.modifyTitleRow(excelWriter, false, ebModel);
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)modelId);
        Member rootMember = orCreate.getRootMember(SysDimensionEnum.Entity.getNumber(), Long.valueOf(viewId));
        this.handleExportData(excelWriter, allEntityBailOrgRelation, viewEntityMembers, orgViewNumber, orgViewName, rootMember, ebModel);
        if (!ebModel) {
            this.bailOrgUtil.addOrgViewInfoSheet(excelWriter, modelId);
        }
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5bfc\u51fa\u59d4\u6258\u7ec4\u7ec7", "BailOrgFormPlugin_25", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u5bfc\u51fa\u59d4\u6258\u7ec4\u7ec7\u6210\u529f\u3002", "BailOrgFormPlugin_26", "epm-eb-formplugin");
        this.writeLog(null, "export", opName, opDesc, null);
        String fileName = ResManager.loadResFormat((String)"\u59d4\u6258\u5173\u7cfb\u5bfc\u51fa\u6570\u636e%1.xlsx", (String)"BailOrgFormPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[]{DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
        String url = excelWriter.getDownloadUrl(fileName);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
    }

    private void handleExportData(BgExcelWriter excelWriter, Map<String, BailOrgRelation> allEntityBailOrgRelation, DynamicObjectCollection viewEntityMembers, String viewNumber, String viewName, Member rootMember, boolean isEbModel) {
        excelWriter.setStarPosition(4, 0);
        CellStyle cellStyle = excelWriter.getWorkbook().createCellStyle();
        cellStyle.setDataFormat(excelWriter.getWorkbook().createDataFormat().getFormat("@"));
        for (DynamicObject object : viewEntityMembers) {
            String entityNumber = object.getString("number");
            if (rootMember != null && StringUtils.equals((String)rootMember.getNumber(), (String)entityNumber)) continue;
            String entityName = object.getString("name");
            BailOrgRelation bailOrgRelation = allEntityBailOrgRelation.get(entityNumber);
            if (isEbModel) {
                excelWriter.createRow(new Object[]{entityNumber, entityName, bailOrgRelation != null ? bailOrgRelation.getBailOrgNumbers() : "", bailOrgRelation != null ? bailOrgRelation.getBailOrgNames() : ""});
                continue;
            }
            excelWriter.createRow(new Object[]{viewNumber, viewName, entityNumber, entityName, bailOrgRelation != null ? bailOrgRelation.getBailOrgNumbers() : "", bailOrgRelation != null ? bailOrgRelation.getBailOrgNames() : ""});
        }
    }

    private boolean saveData() {
        Map<String, BailOrgRelation> allEntityBailOrgRelation;
        Long modelId = this.getModelId();
        if (this.checkBeforeSave(modelId, allEntityBailOrgRelation = this.getAllEntityBailOrgRelation())) {
            return false;
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.bailOrgService.saveBailOrgRelation(modelId, allEntityBailOrgRelation);
            }
            catch (Exception e) {
                tx.markRollback();
                log.error("saveBailOrgRelation error \uff1a " + e);
                throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"BailOrgFormPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58\u59d4\u6258\u7ec4\u7ec7", "BailOrgFormPlugin_23", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u59d4\u6258\u7ec4\u7ec7\u4fdd\u5b58\u6210\u529f\u3002", "BailOrgFormPlugin_24", "epm-eb-formplugin");
        this.writeLog(null, "save", opName, opDesc, null);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"BailOrgFormPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.setDataChanged(false);
        return true;
    }

    public void click(EventObject evt) {
        String sourceKey;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (sourceKey = source.getKey()) {
            case "searchbefore": 
            case "searchnext": {
                TreeSearchUtil.SearchBtnStatus searchBtnStatus = SEARCH_BEFORE.equals(sourceKey) ? TreeSearchUtil.SearchBtnStatus.LEFT : TreeSearchUtil.SearchBtnStatus.RIGHT;
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(ORG_VIEW_TREE, CACHE_ORG_VIEW_TREE, searchBtnStatus));
                TreeView viewTree = (TreeView)this.getControl(ORG_VIEW_TREE);
                this.treeNodeClick(new TreeNodeEvent((Object)viewTree, null, (Object)viewTree.getTreeState().getFocusNodeId()));
                break;
            }
        }
    }

    private void autoBailByNumber() {
        Long modelId = this.getModelId();
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"BailOrgFormPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode curSelViewNode = this.getCurSelViewNode();
        if (curSelViewNode == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"BailOrgFormPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        List entityNumbers = this.bailOrgService.getBaseViewEntityMemberContainAnalyse(modelId, true, null);
        Map numberToIdMap = this.bailOrgService.getEntityBaseViewMemberId(modelId, (Collection)entityNumbers);
        Map adminOrgInfoMap = this.bailOrgService.getAdminOrgInfoMap((Collection)entityNumbers);
        ArrayList<String> autoBailEntities = new ArrayList<String>(16);
        Map<String, BailOrgRelation> allEntityBailOrgRelation = this.getAllEntityBailOrgRelation();
        for (Map.Entry entry : adminOrgInfoMap.entrySet()) {
            String entityNumber = (String)entry.getKey();
            if (allEntityBailOrgRelation.containsKey(entityNumber)) continue;
            SimpleObject adminOrg = (SimpleObject)entry.getValue();
            BailOrgRelation bailOrgRelation = new BailOrgRelation();
            bailOrgRelation.setEntityId((Long)numberToIdMap.get(entityNumber));
            bailOrgRelation.setEntityNumber(entityNumber);
            bailOrgRelation.addBailOrg((SimpleObject)entry.getValue());
            bailOrgRelation.setDefaultBailId(adminOrg.getId());
            allEntityBailOrgRelation.put(entityNumber, bailOrgRelation);
            autoBailEntities.add(entityNumber);
        }
        this.cacheEntityBailOrgRelation(allEntityBailOrgRelation);
        if (autoBailEntities.size() > 0) {
            this.getView().showMessage(ResManager.loadResFormat((String)"\u6309\u7f16\u7801\u81ea\u52a8\u59d4\u6258\u7ec4\u7ec7\u6210\u529f\uff0c\u5df2\u6309\u7f16\u7801\u81ea\u52a8\u59d4\u6258\u201c%1\u201d\u4e2a\u9884\u7b97\u7ec4\u7ec7\u201c%2\u201d\u3002", (String)"BailOrgFormPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[]{autoBailEntities.size(), SerializationUtils.toJsonString(autoBailEntities)}));
            this.loadCurEntityBailOrg();
            this.setDataChanged(true);
            log.info("autoBailByNumber :" + SerializationUtils.toJsonString(autoBailEntities));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u6ca1\u6709\u53ef\u4ee5\u6309\u7f16\u7801\u81ea\u52a8\u59d4\u6258\u7684\u9884\u7b97\u7ec4\u7ec7\u3002", (String)"BailOrgFormPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void addBailOrgClick() {
        String curSelEntityNumber = this.getCurSelEntityNumber();
        Member rootMember = this.getIModelCacheHelper().getRootMember("Entity", this.getCueSelOrgViewId());
        if (curSelEntityNumber == null || rootMember == null || StringUtils.equals((String)curSelEntityNumber, (String)rootMember.getNumber())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u59d4\u6258\u9884\u7b97\u7ec4\u7ec7\u3002", (String)"BailOrgFormPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"bos_adminorg", (boolean)true);
        BailOrgRelation bailOrgRelation = this.getCurEntityBailOrgRelation();
        if (bailOrgRelation != null && kd.epm.eb.common.utils.CollectionUtils.isNotEmpty((Collection)bailOrgRelation.getBailOrgIds())) {
            listShowParameter.setSelectedRows(bailOrgRelation.getBailOrgIds().toArray());
        }
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BAIL_ORG_SEL_CALL_BACK));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void cacheEntityBailOrgRelation(Map<String, BailOrgRelation> allEntityBailOrgRelation) {
        this.getPageCache().put(CACHE_ENTITY_BAIL_ORG, SerializationUtils.serializeToBase64(allEntityBailOrgRelation));
    }

    private BailOrgRelation getCurEntityBailOrgRelation() {
        String entityNumber = this.getCurSelEntityNumber();
        if (entityNumber == null) {
            return null;
        }
        return this.getAllEntityBailOrgRelation().get(entityNumber);
    }

    private String getCurSelEntityNumber() {
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(ENTITY_TREE_ENTRY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length != 1) {
            return null;
        }
        return (String)this.getModel().getValue("entitynumber");
    }

    private Map<String, BailOrgRelation> getAllEntityBailOrgRelation() {
        String cache = this.getPageCache().get(CACHE_ENTITY_BAIL_ORG);
        if (cache != null) {
            return (Map)SerializationUtils.deSerializeFromBase64((String)cache);
        }
        return new HashMap<String, BailOrgRelation>(0);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (BAIL_ORG_SEL_CALL_BACK.equals(actionId) && evt.getReturnData() != null) {
            this.bailOrgSelCallBack(evt);
        } else if (BAIL_ORG_IMPORT_CALL_BACK.equals(actionId)) {
            this.bailOrgImportCallBack(evt);
        }
    }

    private void bailOrgImportCallBack(ClosedCallBackEvent evt) {
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        Map dataMap = (Map)SerializationUtils.deSerializeFromBase64((String)returnData.toString());
        Boolean isAddAndUpdate = (Boolean)dataMap.get("isAddAndUpdate");
        Map bailOrgRelationMap = (Map)dataMap.get("bailOrgRelation");
        Map<String, BailOrgRelation> allEntityBailOrgRelation = this.getAllEntityBailOrgRelation();
        if (isAddAndUpdate.booleanValue()) {
            allEntityBailOrgRelation.putAll(bailOrgRelationMap);
        } else {
            for (Map.Entry entry : bailOrgRelationMap.entrySet()) {
                String entityNumber = (String)entry.getKey();
                BailOrgRelation bailOrgRelation = (BailOrgRelation)entry.getValue();
                if (allEntityBailOrgRelation.containsKey(entityNumber)) continue;
                allEntityBailOrgRelation.put(entityNumber, bailOrgRelation);
            }
        }
        this.setDataChanged(true);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\uff0c\u8bf7\u67e5\u770b\u5e76\u4fdd\u5b58\u3002", (String)"BailOrgFormPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        log.info("bailOrgImport:" + SerializationUtils.toJsonString((Object)bailOrgRelationMap));
        this.cacheEntityBailOrgRelation(allEntityBailOrgRelation);
        this.loadCurEntityBailOrg();
    }

    private void bailOrgSelCallBack(ClosedCallBackEvent evt) {
        String curSelEntityNumber = this.getCurSelEntityNumber();
        if (curSelEntityNumber == null) {
            return;
        }
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)evt.getReturnData();
        this.getModel().beginInit();
        this.getModel().deleteEntryData(BAIL_ORG_ENTRY);
        if (kd.epm.eb.common.utils.CollectionUtils.isNotEmpty((Collection)returnData)) {
            DynamicObject rowEntity;
            if (returnData.size() > 1000) {
                ListSelectedRowCollection billListSelectedRowCollection = new ListSelectedRowCollection();
                billListSelectedRowCollection.addAll((Collection)returnData.subList(0, 1000));
                returnData = billListSelectedRowCollection;
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u53d7\u6258\u884c\u653f\u7ec4\u7ec7\u6700\u591a\u9009\u62e9%1\u4e2a\uff0c\u5c06\u53ea\u53d6\u524d%2\u4e2a\u3002", (String)"BailOrgFormPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[]{1000, 1000}));
            }
            int[] index = this.getModel().batchCreateNewEntryRow(BAIL_ORG_ENTRY, returnData.size());
            int i = 0;
            HashMap<Long, DynamicObject> bailOrgIdToRowObject = new HashMap<Long, DynamicObject>(returnData.size());
            for (ListSelectedRow returnDatum : returnData) {
                rowEntity = this.getModel().getEntryRowEntity(BAIL_ORG_ENTRY, index[i]);
                rowEntity.set("bailorgid", (Object)String.valueOf(returnDatum.getPrimaryKeyValue()));
                rowEntity.set("orgnumber", (Object)returnDatum.getNumber());
                rowEntity.set("orgname", (Object)returnDatum.getName());
                bailOrgIdToRowObject.put(IDUtils.toLong((Object)returnDatum.getPrimaryKeyValue()), rowEntity);
                ++i;
            }
            BailOrgRelation curEntityBailOrgRelation = this.getCurEntityBailOrgRelation();
            rowEntity = curEntityBailOrgRelation != null && bailOrgIdToRowObject.containsKey(curEntityBailOrgRelation.getDefaultBailId()) ? (DynamicObject)bailOrgIdToRowObject.get(curEntityBailOrgRelation.getDefaultBailId()) : this.getModel().getEntryRowEntity(BAIL_ORG_ENTRY, index[0]);
            rowEntity.set("default", (Object)true);
        }
        this.getModel().endInit();
        this.getView().updateView(BAIL_ORG_ENTRY);
        this.setDataChanged(true);
        this.cacheCurEntityBailRelation();
    }

    private void cacheCurEntityBailRelation() {
        String curSelEntityNumber = this.getCurSelEntityNumber();
        if (curSelEntityNumber == null) {
            return;
        }
        Map numberToIdMap = this.bailOrgService.getEntityBaseViewMemberId(this.getModelId(), (Collection)Sets.newHashSet((Object[])new String[]{curSelEntityNumber}));
        Map<String, BailOrgRelation> allEntityBailOrgRelation = this.getAllEntityBailOrgRelation();
        DynamicObjectCollection bailObjects = this.getModel().getEntryEntity(BAIL_ORG_ENTRY);
        if (kd.epm.eb.common.utils.CollectionUtils.isEmpty((Collection)bailObjects)) {
            allEntityBailOrgRelation.remove(curSelEntityNumber);
        } else {
            BailOrgRelation bailOrgRelation = new BailOrgRelation();
            bailOrgRelation.setEntityId((Long)numberToIdMap.get(curSelEntityNumber));
            bailOrgRelation.setEntityNumber(curSelEntityNumber);
            for (DynamicObject bailObject : bailObjects) {
                long bailOrgId = bailObject.getLong("bailorgid");
                bailOrgRelation.addBailOrg(new SimpleObject(Long.valueOf(bailOrgId), bailObject.getString("orgname"), bailObject.getString("orgnumber")));
                if (!bailObject.getBoolean("default")) continue;
                bailOrgRelation.setDefaultBailId(Long.valueOf(bailOrgId));
            }
            allEntityBailOrgRelation.put(curSelEntityNumber, bailOrgRelation);
        }
        this.cacheEntityBailOrgRelation(allEntityBailOrgRelation);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (MODEL.equals(key)) {
            if (this.getDataChanged()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4fe1\u606f\u672a\u4fdd\u5b58\uff0c\u8bf7\u4fdd\u5b58\u3002", (String)"BailOrgFormPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            ArrayList qFilterList = ((BasedataEdit)this.getControl(MODEL)).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList();
            }
            qFilterList.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    @Override
    public void afterF7Select(AfterF7SelectEvent event) {
        Control source = (Control)event.getSource();
        String sourceKey = source.getKey();
        if (MODEL.equals(sourceKey)) {
            this.afterModelF7Sel(event);
        }
    }

    private void afterModelF7Sel(AfterF7SelectEvent event) {
        ListSelectedRowCollection listSelectedRows = event.getListSelectedRowCollection();
        Long modelId = IDUtils.toLong((Object)event.getInputValue());
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue() && kd.epm.eb.common.utils.CollectionUtils.isNotEmpty((Collection)listSelectedRows)) {
            modelId = IDUtils.toLong((Object)listSelectedRows.get(0).getPrimaryKeyValue());
        }
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            this.getModel().setValue(MODEL, (Object)this.getModelId());
        } else {
            this.getPageCache().put(MODEL, String.valueOf(modelId));
            this.loadPageData();
            UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (!MODEL.equals(callBackId) && BEFORE_EXIT_BACK.equals(callBackId)) {
            this.beforeExitConfirmBack(event.getResult());
        }
    }

    private void beforeExitConfirmBack(MessageBoxResult result) {
        if (MessageBoxResult.Yes == result) {
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("default".equals(name)) {
            this.defaultBailOrgChange(e);
        }
    }

    private void defaultBailOrgChange(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        if (this.sign && Boolean.TRUE.equals(changeData.getOldValue()) && Boolean.FALSE.equals(changeData.getNewValue())) {
            this.sign = false;
            this.getModel().setValue("default", (Object)true, changeData.getRowIndex());
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7b97\u7ec4\u7ec7\u5173\u8054\u7684\u9ed8\u8ba4\u59d4\u6258\u884c\u653f\u7ec4\u7ec7\u4ec5\u80fd\u9009\u62e9\u4e00\u4e2a\u3002", (String)"BailOrgFormPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            this.getModel().beginInit();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(BAIL_ORG_ENTRY);
            for (DynamicObject object : entryEntity) {
                int rowIndex = object.getInt("seq") - 1;
                if (rowIndex == changeData.getRowIndex()) continue;
                this.getModel().setValue("default", (Object)false, rowIndex);
            }
            this.getModel().endInit();
            this.getView().updateView(BAIL_ORG_ENTRY);
            this.setDataChanged(true);
            this.cacheCurEntityBailRelation();
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        EntryProp entryProp = e.getEntryProp();
        if (BAIL_ORG_ENTRY.equals(entryProp.getName())) {
            this.afterDelBailOrg();
        }
    }

    private void afterDelBailOrg() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(BAIL_ORG_ENTRY);
        if (kd.epm.eb.common.utils.CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            boolean isExistDefault = false;
            for (DynamicObject object : entryEntity) {
                if (!object.getBoolean("default")) continue;
                isExistDefault = true;
            }
            if (!isExistDefault) {
                this.getModel().setValue("default", (Object)true, 0);
            }
        }
        this.setDataChanged(true);
        this.cacheCurEntityBailRelation();
    }

    private TreeNode getTreeNodeFromCache(boolean isOrgViewTree) {
        String cache = isOrgViewTree ? this.getPageCache().get(CACHE_ORG_VIEW_TREE) : this.getPageCache().get(CACHE_ORG_TREE);
        if (cache == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9875\u9762\u7f13\u5b58\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u3002", (String)"BailOrgFormPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return (TreeNode)SerializationUtils.fromJsonString((String)cache, TreeNode.class);
    }

    private void putTreeNodeToCache(TreeNode treeNode, boolean isOrgViewTree) {
        this.getPageCache().put(isOrgViewTree ? CACHE_ORG_VIEW_TREE : CACHE_ORG_TREE, SerializationUtils.toJsonString((Object)treeNode));
    }

    private IModelCacheHelper getModelCache() {
        return ModelCacheContext.getOrCreate((Long)this.getModelId());
    }

    private void setDataChanged(boolean dataChanged) {
        this.getPageCache().put(CACHE_DATA_CHANGED, dataChanged ? "1" : null);
    }

    private boolean getDataChanged() {
        return "1".equals(this.getPageCache().get(CACHE_DATA_CHANGED));
    }

    @Override
    public Long getModelId() {
        String cache = this.getPageCache().get(MODEL);
        DynamicObject value = (DynamicObject)this.getModel().getValue(MODEL);
        if (StringUtils.isNotEmpty((String)cache)) {
            return IDUtils.toLong((Object)this.getPageCache().get(MODEL));
        }
        if (value != null) {
            return value.getLong("id");
        }
        return (Long)this.getCustomFormParam(MODEL);
    }
}

