/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.bailorg;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.bailorg.BailOrgService;
import kd.epm.eb.business.bailorg.entity.SimpleObject;
import kd.epm.eb.business.bailorg.pojo.BailOrgRelation;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.ImportEnum;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UploadUtil;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.excel.BgExcelReader;
import kd.epm.eb.common.utils.excel.BgExcelWriter;
import kd.epm.eb.common.utils.excelImport.POIUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.bailorg.BailOrgUtil;
import kd.epm.eb.model.utils.ModelUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.poi.ss.usermodel.CellStyle;

public class BailOrgImportFormPlugin
extends AbstractFormPlugin
implements UploadListener {
    protected static Log log = LogFactory.getLog(BailOrgImportFormPlugin.class);
    public static final String MODEL = "model";
    private static final String BTN_CANCEL = "btncancel";
    private static final String BTN_DOWNLOAD = "btndownload";
    private static final String BTN_OK = "btnok";
    BailOrgService bailOrgService = BailOrgService.getInstance();
    BailOrgUtil bailOrgUtil = BailOrgUtil.getInstance();

    public void afterCreateNewData(EventObject e) {
        HashMap<String, Integer> dataMap = new HashMap<String, Integer>(16);
        dataMap.put("maxatmcount", 1);
        this.getView().updateControlMetadata("attachmentpanelap", dataMap);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CANCEL, BTN_DOWNLOAD, BTN_OK});
        AttachmentPanel attach = (AttachmentPanel)this.getControl("attachmentpanelap");
        attach.addUploadListener((UploadListener)this);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.importData();
                break;
            }
            case "btndownload": {
                this.downImportTemplate();
                break;
            }
        }
    }

    private void importData() {
        String fileUrl = this.getPageCache().get("file_url");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)fileUrl)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u9644\u4ef6\u3002", (String)"BailOrgImportFormPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Long modelId = this.getModelId();
        boolean ebModel = ModelUtil.isEbModel((Long)modelId);
        List inputStreams = UploadUtil.getFileInputStreams((String)fileUrl);
        ArrayList<List<String>> dataList = new ArrayList<List<String>>(10);
        try {
            for (InputStream inputStream : inputStreams) {
                BgExcelReader excelReader = BgExcelReader.getInstance().readByInputstream(inputStream);
                List datas = excelReader.readString(3, 0, ebModel ? 3 : 5);
                dataList.addAll(datas);
            }
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20Excel\u6587\u6863\u3002", (String)"BailOrgImportFormPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.checkTemplateFormat(dataList, ebModel);
        HashMap<String, Set<String>> validViewMemberInfo = new HashMap<String, Set<String>>(16);
        HashMap<String, SimpleObject> validOrgInfo = new HashMap<String, SimpleObject>(1024);
        this.getInfoInDataList(dataList, validViewMemberInfo, validOrgInfo, ebModel);
        Map entityViewIdMap = this.bailOrgService.getEntityViewIdMap(modelId);
        HashMap<String, Set<String>> permMemberNumbers = new HashMap<String, Set<String>>(16);
        for (String viewNumber : validViewMemberInfo.keySet()) {
            Long viewId = (Long)entityViewIdMap.get(viewNumber);
            Set permMemNumbers = DimMembPermHelper.getPermMembNumbers((Long)UserUtils.getUserId(), (String)"Entity", (Long)modelId, (Long)0L, (Long)viewId, (DimMembPermType)DimMembPermType.MANAGER, (boolean)true);
            permMemberNumbers.put(viewNumber, permMemNumbers);
        }
        HashSet entityNumbers = new HashSet(16);
        validViewMemberInfo.values().forEach(entityNumbers::addAll);
        Map viewMemberMap = this.bailOrgService.getEntityViewMemberId(modelId, validViewMemberInfo.keySet(), entityNumbers, ebModel);
        if (this.validExcel(dataList, validViewMemberInfo, permMemberNumbers, validOrgInfo, entityViewIdMap, ebModel)) {
            BgExcelWriter excelWriter = BgExcelWriter.getInstance().readTemplateByClasspath(ebModel ? "bailorg/bailOrgRelationEb_err.xlsx" : "bailorg/bailOrgRelation_err.xlsx");
            this.bailOrgUtil.modifyTitleRow(excelWriter, true, ebModel);
            excelWriter.setStarPosition(4, 0);
            CellStyle cellStyle = excelWriter.getWorkbook().createCellStyle();
            cellStyle.setDataFormat(excelWriter.getWorkbook().createDataFormat().getFormat("@"));
            for (List list : dataList) {
                excelWriter.createRow(cellStyle, (Iterable)list);
            }
            this.bailOrgUtil.addOrgViewInfoSheet(excelWriter, modelId);
            String fileName = ResManager.loadKDString((String)"\u5bfc\u5165\u9519\u8bef\u8be6\u60c5.xlsx", (String)"BailOrgImportFormPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            String string = excelWriter.getDownloadUrl(fileName);
            POIUtils.downloadFile((IFormView)this.getView(), (String)string);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u5bfc\u5165\u9519\u8bef\u8be6\u60c5\u3002", (String)"BailOrgImportFormPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5bfc\u5165\u59d4\u6258\u7ec4\u7ec7", "BailOrgFormPlugin_27", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u5bfc\u5165\u59d4\u6258\u7ec4\u7ec7\u6210\u529f\u3002", "BailOrgFormPlugin_28", "epm-eb-formplugin");
        this.writeLog("import", opName, opDesc);
        this.toObjAndReturnData(dataList, validOrgInfo, viewMemberMap, ebModel);
    }

    private void toObjAndReturnData(List<List<String>> dataList, Map<String, SimpleObject> orgInfoMap, Map<String, Map<String, Long>> viewMemberMap, boolean isEbModel) {
        HashMap<String, BailOrgRelation> bailOrgRelationMap = new HashMap<String, BailOrgRelation>(dataList.size());
        for (List<String> dataRow : dataList) {
            String bailOrgStr;
            String entityNumber;
            String viewNumber;
            if (isEbModel) {
                viewNumber = "E001";
                entityNumber = dataRow.get(1);
                bailOrgStr = dataRow.get(3);
            } else {
                viewNumber = dataRow.get(1);
                entityNumber = dataRow.get(3);
                bailOrgStr = dataRow.get(5);
            }
            String[] bailOrgNums = bailOrgStr.split(",");
            BailOrgRelation bailOrgRelation = new BailOrgRelation();
            bailOrgRelationMap.put(entityNumber, bailOrgRelation);
            bailOrgRelation.setEntityId(viewMemberMap.get(viewNumber).get(entityNumber));
            bailOrgRelation.setEntityNumber(entityNumber);
            for (String bailOrgNum : bailOrgNums) {
                bailOrgRelation.addBailOrg(orgInfoMap.get(bailOrgNum));
            }
            if (orgInfoMap.get(bailOrgNums[0]) == null) continue;
            bailOrgRelation.setDefaultBailId(orgInfoMap.get(bailOrgNums[0]).getId());
        }
        HashMap<String, Serializable> returnData = new HashMap<String, Serializable>(2);
        returnData.put("isAddAndUpdate", Boolean.valueOf(this.isAddAndUpdate()));
        returnData.put("bailOrgRelation", bailOrgRelationMap);
        this.getView().returnDataToParent((Object)SerializationUtils.serializeToBase64(returnData));
        this.getView().close();
    }

    private void getInfoInDataList(List<List<String>> dataList, Map<String, Set<String>> viewMemberInfoInDataList, Map<String, SimpleObject> orgNumberInDataList, boolean isEbModel) {
        for (List<String> dataRow : dataList) {
            String[] bailOrgNums;
            String bailOrgStr;
            String entityNumber;
            String viewNumber;
            if (isEbModel) {
                viewNumber = "E001";
                entityNumber = dataRow.get(0);
                bailOrgStr = dataRow.get(2);
            } else {
                viewNumber = dataRow.get(0);
                entityNumber = dataRow.get(2);
                bailOrgStr = dataRow.get(4);
            }
            if (StringUtils.isNotEmpty((String)viewNumber)) {
                Set viewMembers = viewMemberInfoInDataList.computeIfAbsent(viewNumber, e -> new HashSet(16));
                if (StringUtils.isNotEmpty((String)entityNumber)) {
                    viewMembers.add(entityNumber);
                }
            }
            if (!StringUtils.isNotEmpty((String)bailOrgStr)) continue;
            for (String bailOrgNum : bailOrgNums = bailOrgStr.split(",")) {
                orgNumberInDataList.put(bailOrgNum, null);
            }
        }
        Long modelId = this.getModelId();
        if (viewMemberInfoInDataList.size() > 0) {
            Set viewNumbers = this.bailOrgService.getViewNumberSet(modelId, "Entity", viewMemberInfoInDataList.keySet());
            for (Map.Entry<String, Set<String>> entry : viewMemberInfoInDataList.entrySet()) {
                String viewNum = entry.getKey();
                Set<String> memNumbers = entry.getValue();
                if (!viewNumbers.contains(viewNum)) {
                    viewMemberInfoInDataList.put(viewNum, null);
                    continue;
                }
                if (!CollectionUtils.isNotEmpty(memNumbers)) continue;
                Set validViewMemberNumbers = this.bailOrgService.getEntityMemberNumberSet(modelId, viewNum, false, memNumbers);
                memNumbers.removeIf(e -> !validViewMemberNumbers.contains(e));
            }
        }
        if (orgNumberInDataList.size() > 0) {
            Map validAdminOrgInfoMap = this.bailOrgService.getAdminOrgInfoMap(orgNumberInDataList.keySet());
            orgNumberInDataList.putAll(validAdminOrgInfoMap);
        }
    }

    private boolean validExcel(List<List<String>> dataList, Map<String, Set<String>> viewMemberInfo, Map<String, Set<String>> permMemberNumberMap, Map<String, SimpleObject> orgInfoMap, Map<String, Long> entityViewIdMap, boolean isEbModel) {
        boolean isExistErr = false;
        String mustInputTip = ResManager.loadKDString((String)"\u5fc5\u5f55\u9879\u4e3a\u7a7a", (String)"BailOrgImportFormPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String viewNoExistTip = ResManager.loadKDString((String)"\u89c6\u56fe\u4e0d\u5b58\u5728", (String)"BailOrgImportFormPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String entityNoExistTip = ResManager.loadKDString((String)"\u9884\u7b97\u7ec4\u7ec7\u89c6\u56fe\u4e0b\u6210\u5458\u4e0d\u5b58\u5728", (String)"BailOrgImportFormPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String orgNoExistTip = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"BailOrgImportFormPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String entityNoPermTip = ResManager.loadKDString((String)"\u6ca1\u6709\u5f53\u524d\u7ec4\u7ec7\u7684\u7ef4\u5ea6\u7ba1\u7406\u6743", (String)"BailOrgImportFormPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String conflictRowTip = ResManager.loadKDString((String)"\u5b58\u5728\u540c\u4e00\u7ec4\u7ec7\u4e0d\u540c\u884c\u6307\u5b9a\u4e86\u4e0d\u540c\u7684\u59d4\u6258\u7ec4\u7ec7", (String)"BailOrgImportFormPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String rootEntityTip = ResManager.loadKDString((String)"\u7ec4\u7ec7\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u59d4\u6258\u7ec4\u7ec7", (String)"BailOrgImportFormPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        HashMap<String, String> conflictRowRecord = new HashMap<String, String>(dataList.size());
        for (List<String> dataRow : dataList) {
            String bailOrgStr;
            String entityNumber;
            String viewNumber;
            ArrayList<String> errMsgList = new ArrayList<String>(3);
            if (isEbModel) {
                viewNumber = "E001";
                entityNumber = dataRow.get(0);
                bailOrgStr = dataRow.get(2);
            } else {
                viewNumber = dataRow.get(0);
                entityNumber = dataRow.get(2);
                bailOrgStr = dataRow.get(4);
            }
            Long viewId = entityViewIdMap.get(viewNumber);
            Set<String> permMemberNumbers = permMemberNumberMap.get(viewNumber);
            if (org.apache.commons.lang3.StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{viewNumber, entityNumber, bailOrgStr})) {
                errMsgList.add(mustInputTip);
            } else {
                String[] bailOrgNums;
                if (viewMemberInfo.get(viewNumber) == null) {
                    errMsgList.add(viewNoExistTip);
                } else {
                    Member rootMember = modelCacheHelper.getRootMember("Entity", viewId);
                    if (rootMember != null && StringUtils.equals((String)entityNumber, (String)rootMember.getNumber())) {
                        errMsgList.add(rootEntityTip);
                    } else if (!viewMemberInfo.get(viewNumber).contains(entityNumber)) {
                        errMsgList.add(entityNoExistTip);
                    } else if (permMemberNumbers != null && !permMemberNumbers.contains(entityNumber)) {
                        errMsgList.add(entityNoPermTip);
                    }
                }
                for (String bailOrgNum : bailOrgNums = bailOrgStr.split(",")) {
                    if (orgInfoMap.get(bailOrgNum) != null) continue;
                    errMsgList.add(orgNoExistTip);
                }
                if (StringUtils.equals((String)((String)conflictRowRecord.get(entityNumber)), (String)bailOrgStr)) {
                    errMsgList.add(conflictRowTip);
                }
                conflictRowRecord.put(entityNumber, bailOrgStr);
            }
            if (errMsgList.size() > 0) {
                isExistErr = true;
                dataRow.add(0, org.apache.commons.lang3.StringUtils.join(errMsgList, (String)","));
                continue;
            }
            dataRow.add(0, "");
        }
        return isExistErr;
    }

    private void checkTemplateFormat(List<List<String>> dataList, boolean isEbModel) {
        String templateError = ResManager.loadKDString((String)"\u6a21\u677f\u9519\u8bef\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u6a21\u677f\u3002", (String)"BailOrgImportFormPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(dataList)) {
            throw new KDBizException(templateError);
        }
        List<String> billTitleRow = dataList.get(0);
        List<String> billTile = this.bailOrgUtil.getBillTile(isEbModel);
        for (int i = 0; i < billTile.size(); ++i) {
            if (StringUtils.equals((String)billTile.get(i), (String)billTitleRow.get(i))) continue;
            throw new KDBizException(templateError);
        }
        dataList.remove(0);
        if (dataList.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u4e2d\u6ca1\u6709\u53ef\u5bfc\u5165\u7684\u6709\u6548\u6570\u636e\u3002", (String)"BailOrgImportFormPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void downImportTemplate() {
        boolean ebModel = ModelUtil.isEbModel((Long)this.getModelId());
        BgExcelWriter excelWriter = BgExcelWriter.getInstance().readTemplateByClasspath(ebModel ? "bailorg/bailOrgRelationEb.xlsx" : "bailorg/bailOrgRelation.xlsx");
        this.bailOrgUtil.modifyTitleRow(excelWriter, false, ebModel);
        String fileName = ResManager.loadResFormat((String)"\u59d4\u6258\u5173\u7cfb\u5bfc\u5165\u6a21\u677f%1", (String)"BailOrgImportFormPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[]{DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
        fileName = fileName + ".xlsx";
        String url = excelWriter.getDownloadUrl(fileName);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
        String file_url = this.getPageCache().get("file_url");
        List urls = null;
        urls = file_url == null ? new ArrayList(10) : (List)SerializationUtils.fromJsonString((String)file_url, List.class);
        for (Object url : evt.getUrls()) {
            urls.add((String)((Map)url).get("url"));
        }
        this.getPageCache().put("file_url", SerializationUtils.toJsonString(urls));
    }

    public void afterRemove(UploadEvent evt) {
        String file_url = this.getPageCache().get("file_url");
        if (file_url != null) {
            Object[] objects;
            List urls = (List)SerializationUtils.fromJsonString((String)file_url, List.class);
            for (Object object : objects = evt.getUrls()) {
                String url = (String)((Map)object).get("url");
                urls.remove(url);
            }
            this.getPageCache().put("file_url", SerializationUtils.toJsonString((Object)urls));
        }
    }

    private boolean isAddAndUpdate() {
        return ImportEnum.IMPORTTYPE_ADDANDUPADTA.getIndex().equals(this.getModel().getValue("radiogroupfield"));
    }

    @Override
    public Long getModelId() {
        Long modelId = (Long)this.getCustomFormParam(MODEL);
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e3a\u7a7a\u3002", (String)"BailOrgImportFormPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return modelId;
    }
}

