/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.bailorg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.bailorg.BailOrgService;
import kd.epm.eb.business.bailorg.pojo.BailOrgRelation;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.bgadjust.utils.AdjustUtil;
import kd.epm.eb.model.permission.MemberPermHelper;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;

public class BailOrgQueryFromPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
AfterF7SelectListener,
TreeNodeQueryListener {
    public static final String MODEL = "model";
    public static final String ORG_VIEW = "orgview";
    public static final String ENTRY_ENTITY = "treeentryentity";
    public static final String SEARCH = "searchap";
    public static final String SEARCH_BEFORE = "searchbefore";
    public static final String SEARCH_NEXT = "searchnext";
    public static final String CACHE_ORG_TREE = "cache_org_tree";
    private static final String CACHE_SEARCH_RESULT = "cache_search_result";
    private static final String CACHE_SEARCH_INDEX = "cache_search_index";
    BailOrgService bailOrgService = BailOrgService.getInstance();

    @Override
    public void ebPreOpen(PreOpenFormEventArgs e) {
        super.ebPreOpen(e);
        this.checkViewPerm(e);
    }

    private void checkViewPerm(PreOpenFormEventArgs e) {
        Long userId = this.getUserId();
        Long modelId = IDUtils.toLong((Object)e.getFormShowParameter().getCustomParam(MODEL));
        int is = this.checkItemPermission(userId, modelId, AppMetadataCache.getAppInfo((String)e.getFormShowParameter().getAppId()).getId(), "eb_bailorg_modify", "47150e89000000ac");
        if (is == 0) {
            if (MemberPermHelper.ifUserHasRootPermByModel((Long)userId, (Long)modelId)) {
                return;
            }
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u59d4\u6258\u7ec4\u7ec7\u7ef4\u62a4\u7684\u67e5\u770b\u6743\u9650\uff01", (String)"BailOrgQueryFormPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public void initialize() {
        super.initialize();
        TreeEntryGrid memberTree = (TreeEntryGrid)this.getControl(ENTRY_ENTITY);
        memberTree.addCellClickListener((TreeNodeQueryListener)this);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit model = (BasedataEdit)this.getControl(MODEL);
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        model.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit orgView = (BasedataEdit)this.getControl(ORG_VIEW);
        orgView.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        orgView.addAfterF7SelectListener((AfterF7SelectListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{SEARCH_BEFORE, SEARCH_NEXT});
        Search search = (Search)this.getControl(SEARCH);
        search.addEnterListener(this::searchData);
    }

    private void searchData(SearchEnterEvent event) {
        this.clearSearchCache();
        if (event.getText() != null && !"".equals(event.getText())) {
            this.searchMember(event.getText());
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"BailOrgQueryFormPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void searchMember(String searchText) {
        List<String> searchResult = this.getSearchResult(searchText);
        this.getPageCache().put(CACHE_SEARCH_RESULT, SerializationUtils.serializeToBase64(searchResult));
        if (CollectionUtils.isEmpty(searchResult)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u5339\u914d\u9879\u3002", (String)"BailOrgQueryFormPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String firstMatchNodeId = searchResult.get(0);
        this.getPageCache().put(CACHE_SEARCH_INDEX, "0");
        this.focusEntityRowByEntityId(firstMatchNodeId);
    }

    private void focusEntityRowByEntityId(String nodeId) {
        TreeNode treeNodeFromCache = this.getTreeNodeFromCache();
        List childPath = treeNodeFromCache.getChildPath(nodeId);
        if (CollectionUtils.isEmpty((Collection)childPath)) {
            return;
        }
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(ENTRY_ENTITY);
        List expandNodes = (List)treeEntryGrid.getExpandNodes();
        HashSet expandNodeIds = new HashSet(16);
        if (CollectionUtils.isNotEmpty((Collection)expandNodes)) {
            expandNodeIds.addAll(expandNodes);
        }
        int startRow = 0;
        ArrayList<Integer> expandRows = new ArrayList<Integer>(childPath.size());
        for (int i = 0; i < childPath.size(); ++i) {
            startRow = this.getRowIndex(startRow, (String)childPath.get(i));
            if (i >= childPath.size() - 1) continue;
            DynamicObject rowEntity = this.getModel().getEntryRowEntity(ENTRY_ENTITY, startRow);
            if (rowEntity != null && !expandNodeIds.contains(rowEntity.getString("id"))) {
                this.loadCurEntityChildRows(startRow);
            }
            expandRows.add(startRow);
        }
        if (expandRows.size() > 0) {
            treeEntryGrid.expandOne(expandRows.stream().mapToInt(Integer::valueOf).toArray());
        }
        treeEntryGrid.selectRows(startRow);
    }

    private Integer getRowIndex(int startRow, String pathNodeId) {
        int rowCount = this.getModel().getEntryRowCount(ENTRY_ENTITY);
        for (int i = startRow; i < rowCount; ++i) {
            String value = (String)this.getModel().getValue("entityid", i);
            if (!value.equals(pathNodeId)) continue;
            return i;
        }
        return -1;
    }

    private void searchOther(Boolean isNext) {
        List searchResult = new ArrayList(10);
        String searchResultCache = this.getPageCache().get(CACHE_SEARCH_RESULT);
        if (searchResultCache != null) {
            searchResult = (List)SerializationUtils.deSerializeFromBase64((String)searchResultCache);
        }
        if (CollectionUtils.isEmpty(searchResult)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u641c\u7d22\u9700\u8981\u7684\u5185\u5bb9\u3002", (String)"AbstractDimensionMemberTreeSingleF7Plugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String searchIndexCache = this.getPageCache().get(CACHE_SEARCH_INDEX);
        int searchIndex = -1;
        if (searchIndexCache != null) {
            searchIndex = Integer.parseInt(searchIndexCache);
        }
        if (searchIndex == -1) {
            return;
        }
        if (searchIndex == 0 && !isNext.booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u662f\u7b2c\u4e00\u6761\u3002", (String)"BailOrgQueryFormPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (searchIndex == searchResult.size() - 1 && isNext.booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u662f\u6700\u540e\u4e00\u6761\u3002", (String)"BailOrgQueryFormPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (isNext.booleanValue() && searchIndex + 1 < searchResult.size()) {
            String nodeId = (String)searchResult.get(searchIndex + 1);
            this.getPageCache().put(CACHE_SEARCH_INDEX, String.valueOf(searchIndex + 1));
            this.focusEntityRowByEntityId(nodeId);
        } else if (!isNext.booleanValue() && searchIndex - 1 >= -1) {
            String nodeId = (String)searchResult.get(searchIndex - 1);
            this.getPageCache().put(CACHE_SEARCH_INDEX, String.valueOf(searchIndex - 1));
            this.focusEntityRowByEntityId(nodeId);
        }
    }

    public List<String> getSearchResult(String searchText) {
        String nodeId;
        LinkedHashMap<String, String> nodeIdToTextMap = new LinkedHashMap<String, String>(16);
        LinkedHashMap<String, String> nodeIdToNumberMap = new LinkedHashMap<String, String>(16);
        this.getAllNodeIdToTextMap(this.getTreeNodeFromCache(), nodeIdToTextMap, nodeIdToNumberMap);
        ArrayList<String> searchResult = new ArrayList<String>(10);
        for (Map.Entry entry : nodeIdToTextMap.entrySet()) {
            nodeId = (String)entry.getKey();
            String text = (String)entry.getValue();
            if (!text.contains(searchText)) continue;
            searchResult.add(nodeId);
        }
        for (Map.Entry entry : nodeIdToNumberMap.entrySet()) {
            nodeId = (String)entry.getKey();
            String number = (String)entry.getValue();
            if (!number.contains(searchText)) continue;
            searchResult.add(nodeId);
        }
        return searchResult.stream().distinct().collect(Collectors.toList());
    }

    private void getAllNodeIdToTextMap(TreeNode treeNode, Map<String, String> allNodeIdToTextMap, Map<String, String> nodeIdToNumberMap) {
        if (treeNode != null) {
            allNodeIdToTextMap.put(treeNode.getId(), treeNode.getText());
            nodeIdToNumberMap.put(treeNode.getId(), treeNode.getLongNumber());
            if (CollectionUtils.isNotEmpty((Collection)treeNode.getChildren())) {
                for (TreeNode child : treeNode.getChildren()) {
                    this.getAllNodeIdToTextMap(child, allNodeIdToTextMap, nodeIdToNumberMap);
                }
            }
        }
    }

    private void clearSearchCache() {
        this.getPageCache().remove(CACHE_SEARCH_INDEX);
        this.getPageCache().remove(CACHE_SEARCH_RESULT);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        List<QFilter> qFilterList = new ArrayList(5);
        if (MODEL.equals(key)) {
            qFilterList = ((BasedataEdit)this.getControl(MODEL)).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList();
            }
            ApplicationTypeEnum enumByNumber = ApplicationTypeEnum.getEnumByNumber((String)this.getBizAppId());
            qFilterList.add(new QFilter("id", "in", (Object)ModelUtil.getModelIdsWithPerm((String)"eb_bailorg_modify", (ApplicationTypeEnum)enumByNumber)));
            qFilterList.add(new QFilter("reporttype", "=", (Object)enumByNumber.getIndex()));
        } else if (ORG_VIEW.equals(key)) {
            qFilterList = ((BasedataEdit)this.getControl(ORG_VIEW)).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList();
            }
            qFilterList.add(new QFilter(MODEL, "=", (Object)this.getModelId()));
            qFilterList.add(new QFilter("dimension.number", "=", (Object)"Entity"));
        }
        showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
    }

    public void afterCreateNewData(EventObject e) {
        this.initModel();
        this.loadPageData();
    }

    private void initModel() {
        Object modelId = this.getCustomFormParam(MODEL);
        this.getModel().setValue(MODEL, modelId);
        this.getPageCache().put(MODEL, String.valueOf(modelId));
        if (!AdjustUtil.isEBModel(this.getModelId())) {
            Object orgViewId = this.getCustomFormParam(ORG_VIEW);
            this.getModel().setValue(ORG_VIEW, orgViewId);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (AdjustUtil.isEBModel(this.getModelId())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ORG_VIEW});
        }
    }

    private void loadPageData() {
        this.loadOrgTreeEntry();
    }

    private void loadOrgTreeEntry() {
        Long modelId = this.getModelId();
        String orgViewNumber = this.getOrgViewNumber();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Dimension dimension = modelCache.getDimension(SysDimensionEnum.Entity.getNumber());
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter(MODEL, "=", (Object)modelId));
        builder.add(new QFilter("dimension", "=", (Object)dimension.getId()));
        builder.add(new QFilter("number", "=", (Object)orgViewNumber));
        DynamicObject viewDy = QueryServiceHelper.queryOne((String)"eb_dimensionview", (String)"id", (QFilter[])builder.toArray());
        long viewId = 0L;
        if (viewDy != null) {
            viewId = viewDy.getLong("id");
        }
        TreeNode orgTree = this.bailOrgService.buildEntityMemberTree(modelId, viewId, orgViewNumber, true, null);
        this.putTreeNodeToCache(orgTree);
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        if (StringUtils.isEmpty((String)orgTree.getLongNumber()) || StringUtils.isEmpty((String)orgTree.getText())) {
            return;
        }
        int newEntryRow = this.getModel().createNewEntryRow(ENTRY_ENTITY);
        DynamicObject rowEntity = this.getModel().getEntryRowEntity(ENTRY_ENTITY, newEntryRow);
        this.fillEntityTreeEntry(orgTree, rowEntity, null);
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(ENTRY_ENTITY);
        if (CollectionUtils.isNotEmpty((Collection)orgTree.getChildren())) {
            this.loadCurEntityChildRows(0);
            entryGrid.expandOne(0);
        }
        this.getView().updateView(ENTRY_ENTITY);
    }

    private void fillEntityTreeEntry(TreeNode treeNode, DynamicObject rowEntity, BailOrgRelation bailOrgRelation) {
        rowEntity.set("entityid", (Object)treeNode.getId());
        rowEntity.set("entitynumber", (Object)treeNode.getLongNumber());
        rowEntity.set("entityname", (Object)treeNode.getText());
        if (bailOrgRelation != null) {
            rowEntity.set("orgnumber", (Object)bailOrgRelation.getBailOrgNumbers());
            rowEntity.set("orgname", (Object)bailOrgRelation.getBailOrgNames());
        }
        if (CollectionUtils.isNotEmpty((Collection)treeNode.getChildren())) {
            rowEntity.set("isgroupnode", (Object)true);
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
        int rowKey = treeNodeEvent.getRowKey();
        this.loadCurEntityChildRows(rowKey);
    }

    private void loadCurEntityChildRows(int rowKey) {
        String entityId;
        TreeNode treeNode = this.getTreeNodeFromCache();
        TreeNode curEntityNode = treeNode.getTreeNode(entityId = (String)this.getModel().getValue("entityid", rowKey), 20);
        if (curEntityNode == null) {
            return;
        }
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(ENTRY_ENTITY);
        List children = curEntityNode.getChildren();
        if (CollectionUtils.isNotEmpty((Collection)children)) {
            Set entityNumbers = children.stream().map(TreeNode::getLongNumber).collect(Collectors.toSet());
            Map allEntityBailOrgRelation = this.bailOrgService.getModelBailOrgRelation(this.getModelId(), entityNumbers);
            this.getModel().beginInit();
            int[] index = this.getModel().batchInsertEntryRow(ENTRY_ENTITY, rowKey, children.size());
            int i = 0;
            for (TreeNode child : children) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity(ENTRY_ENTITY, index[i]);
                this.fillEntityTreeEntry(child, rowEntity, (BailOrgRelation)allEntityBailOrgRelation.get(child.getLongNumber()));
                ++i;
            }
            this.getModel().endInit();
            this.getView().updateView(ENTRY_ENTITY);
            treeEntryGrid.collapseOne(index);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (itemKey.equals("btn_refresh")) {
            this.loadPageData();
        }
    }

    public void click(EventObject evt) {
        String sourceKey;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (sourceKey = source.getKey()) {
            case "searchbefore": {
                this.searchOther(false);
                break;
            }
            case "searchnext": {
                this.searchOther(true);
                break;
            }
        }
    }

    @Override
    public void afterF7Select(AfterF7SelectEvent event) {
        Control source = (Control)event.getSource();
        String sourceKey = source.getKey();
        if (MODEL.equals(sourceKey)) {
            this.afterModelF7Sel(event);
        } else if (ORG_VIEW.equals(sourceKey)) {
            this.afterOrgViewF7Sel();
        }
    }

    private void afterOrgViewF7Sel() {
        this.loadPageData();
    }

    private void afterModelF7Sel(AfterF7SelectEvent event) {
        ListSelectedRowCollection listSelectedRows = event.getListSelectedRowCollection();
        Long newModelId = IDUtils.toLong((Object)event.getInputValue());
        if (IDUtils.isEmptyLong((Long)newModelId).booleanValue() && CollectionUtils.isNotEmpty((Collection)listSelectedRows)) {
            newModelId = IDUtils.toLong((Object)listSelectedRows.get(0).getPrimaryKeyValue());
        }
        if (IDUtils.isEmptyLong((Long)newModelId).booleanValue()) {
            this.getModel().setValue(MODEL, (Object)this.getModelId());
            return;
        }
        QFilter[] qFilters = new QFilter(MODEL, "=", (Object)newModelId).and("dimension.number", "=", (Object)"Entity").toArray();
        DynamicObject defaultView = QueryServiceHelper.queryOne((String)"eb_dimensionview", (String)"id", (QFilter[])qFilters);
        if (defaultView != null) {
            this.getModel().setValue(ORG_VIEW, (Object)defaultView.getLong("id"));
        }
        UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)newModelId);
        this.getPageCache().put(MODEL, newModelId.toString());
        this.loadPageData();
    }

    private TreeNode getTreeNodeFromCache() {
        String cache = this.getPageCache().get(CACHE_ORG_TREE);
        if (cache == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9875\u9762\u7f13\u5b58\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"BailOrgQueryFormPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return (TreeNode)SerializationUtils.fromJsonString((String)cache, TreeNode.class);
    }

    private void putTreeNodeToCache(TreeNode treeNode) {
        this.getPageCache().put(CACHE_ORG_TREE, SerializationUtils.toJsonString((Object)treeNode));
    }

    private String getOrgViewNumber() {
        DynamicObject value = (DynamicObject)this.getModel().getValue(ORG_VIEW);
        if (value != null) {
            return value.getString("number");
        }
        if (AdjustUtil.isEBModel(this.getModelId())) {
            return "E001";
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"BailOrgQueryFormPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    @Override
    public Long getModelId() {
        String cache = this.getPageCache().get(MODEL);
        if (cache != null) {
            return IDUtils.toLong((Object)cache);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"BailOrgQueryFormPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }
}

